<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				$this->is_xml = false;
				$this->asp_tags = (ini_get('asp_tags') != '0');
				$this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 130 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_OTHER                          = 10;
    const TP_LINEBREAK                      = 11;
    const TP_LITERALSTART                   = 12;
    const TP_LITERALEND                     = 13;
    const TP_LITERAL                        = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_DOLLAR                         = 17;
    const TP_ID                             = 18;
    const TP_EQUAL                          = 19;
    const TP_PTR                            = 20;
    const TP_LDELIF                         = 21;
    const TP_SPACE                          = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_AS                             = 29;
    const TP_APTR                           = 30;
    const TP_LDELSLASH                      = 31;
    const TP_INTEGER                        = 32;
    const TP_COMMA                          = 33;
    const TP_MATH                           = 34;
    const TP_UNIMATH                        = 35;
    const TP_ANDSYM                         = 36;
    const TP_ISIN                           = 37;
    const TP_ISDIVBY                        = 38;
    const TP_ISNOTDIVBY                     = 39;
    const TP_ISEVEN                         = 40;
    const TP_ISNOTEVEN                      = 41;
    const TP_ISEVENBY                       = 42;
    const TP_ISNOTEVENBY                    = 43;
    const TP_ISODD                          = 44;
    const TP_ISNOTODD                       = 45;
    const TP_ISODDBY                        = 46;
    const TP_ISNOTODDBY                     = 47;
    const TP_INSTANCEOF                     = 48;
    const TP_OPENP                          = 49;
    const TP_CLOSEP                         = 50;
    const TP_QMARK                          = 51;
    const TP_NOT                            = 52;
    const TP_TYPECAST                       = 53;
    const TP_HEX                            = 54;
    const TP_DOT                            = 55;
    const TP_SINGLEQUOTESTRING              = 56;
    const TP_DOUBLECOLON                    = 57;
    const TP_AT                             = 58;
    const TP_HATCH                          = 59;
    const TP_OPENB                          = 60;
    const TP_CLOSEB                         = 61;
    const TP_EQUALS                         = 62;
    const TP_NOTEQUALS                      = 63;
    const TP_GREATERTHAN                    = 64;
    const TP_LESSTHAN                       = 65;
    const TP_GREATEREQUAL                   = 66;
    const TP_LESSEQUAL                      = 67;
    const TP_IDENTITY                       = 68;
    const TP_NONEIDENTITY                   = 69;
    const TP_MOD                            = 70;
    const TP_LAND                           = 71;
    const TP_LOR                            = 72;
    const TP_LXOR                           = 73;
    const TP_QUOTE                          = 74;
    const TP_BACKTICK                       = 75;
    const TP_DOLLARID                       = 76;
    const YY_NO_ACTION = 564;
    const YY_ACCEPT_ACTION = 563;
    const YY_ERROR_ACTION = 562;

    const YY_SZ_ACTTAB = 2088;
static public $yy_action = array(
 /*     0 */   182,   20,    8,  140,  302,  299,  298,  294,  293,  295,
 /*    10 */   296,  297,  304,  160,  163,  323,    2,  270,  161,  341,
 /*    20 */     4,  188,  195,  168,  208,   27,   26,   38,  114,  124,
 /*    30 */   265,  271,  204,   48,   47,   44,   39,   32,   30,  348,
 /*    40 */   349,   28,   15,  356,  357,   16,   18,  312,  307,  306,
 /*    50 */   308,  311,  431,    7,  130,  160,  313,  316,  431,    6,
 /*    60 */   322,  364,  365,  366,  367,  363,  362,  358,  359,  360,
 /*    70 */   361,  344,  343,  182,  326,  300,  301,  303,  194,   12,
 /*    80 */   210,   53,  174,  120,  106,    4,  141,   13,  319,  163,
 /*    90 */   266,  104,   43,  114,  188,  240,  353,  345,  168,  327,
 /*   100 */   270,   26,   38,  217,  193,  133,   48,   47,   44,   39,
 /*   110 */    32,   30,  348,  349,   28,   15,  356,  357,   16,   18,
 /*   120 */   563,   85,  229,  301,  303,   33,   24,  110,  136,  272,
 /*   130 */    36,   94,  237,   84,  364,  365,  366,  367,  363,  362,
 /*   140 */   358,  359,  360,  361,  344,  343,  182,  182,  326,  145,
 /*   150 */    24,  276,  176,  272,  210,   77,   24,  231,  106,  272,
 /*   160 */    36,  167,  338,  270,  266,  199,  189,  188,  188,  216,
 /*   170 */   353,  345,   34,  327,   24,  256,  197,  272,   92,   48,
 /*   180 */    47,   44,   39,   32,   30,  348,  349,   28,   15,  356,
 /*   190 */   357,   16,   18,    9,  278,    4,   24,   23,   24,  272,
 /*   200 */    21,  272,   40,  114,  103,  223,  258,  364,  365,  366,
 /*   210 */   367,  363,  362,  358,  359,  360,  361,  344,  343,  182,
 /*   220 */   326,  135,  188,  164,   98,   24,   99,   50,  272,  123,
 /*   230 */   100,  325,  166,  211,  170,  155,  266,  188,   90,  130,
 /*   240 */   278,  216,  353,  345,  230,  327,   88,  168,  197,  270,
 /*   250 */    26,   38,   48,   47,   44,   39,   32,   30,  348,  349,
 /*   260 */    28,   15,  356,  357,   16,   18,  182,  430,  224,   24,
 /*   270 */   277,    6,  272,  188,  174,   35,  278,  105,  317,   13,
 /*   280 */   364,  365,  366,  367,  363,  362,  358,  359,  360,  361,
 /*   290 */   344,  343,  318,  282,  286,  156,  341,  182,    5,   48,
 /*   300 */    47,   44,   39,   32,   30,  348,  349,   28,   15,  356,
 /*   310 */   357,   16,   18,  182,  150,  339,  273,  331,  188,  275,
 /*   320 */    43,  188,  214,  188,  182,  188,  121,  364,  365,  366,
 /*   330 */   367,  363,  362,  358,  359,  360,  361,  344,  343,  430,
 /*   340 */    24,  327,  206,  272,   87,  188,   48,   47,   44,   39,
 /*   350 */    32,   30,  348,  349,   28,   15,  356,  357,   16,   18,
 /*   360 */   182,   25,  330,  321,  269,  340,  158,  341,  188,  188,
 /*   370 */   188,  188,  192,  248,  364,  365,  366,  367,  363,  362,
 /*   380 */   358,  359,  360,  361,  344,  343,  220,   24,   10,   24,
 /*   390 */   196,   31,  207,   48,   47,   44,   39,   32,   30,  348,
 /*   400 */   349,   28,   15,  356,  357,   16,   18,    4,  320,   43,
 /*   410 */   309,  433,  234,  218,  188,  114,  188,  433,  188,  247,
 /*   420 */   219,  364,  365,  366,  367,  363,  362,  358,  359,  360,
 /*   430 */   361,  344,  343,  182,  326,   23,  243,  139,  194,  126,
 /*   440 */   210,   66,   43,   43,  106,  213,  138,    4,  233,  163,
 /*   450 */   266,  270,  188,  284,   10,  114,  353,  345,  168,  327,
 /*   460 */   270,   26,   38,  315,  474,  314,   48,   47,   44,   39,
 /*   470 */    32,   30,  348,  349,   28,   15,  356,  357,   16,   18,
 /*   480 */   165,  355,  240,  329,    4,  337,  153,  332,  273,  188,
 /*   490 */   130,  188,  114,  188,  364,  365,  366,  367,  363,  362,
 /*   500 */   358,  359,  360,  361,  344,  343,  182,  182,  326,  285,
 /*   510 */    24,  255,   98,  272,  102,   52,  125,  123,  100,  336,
 /*   520 */   147,  221,  268,  163,  266,  209,  222,  104,  188,  162,
 /*   530 */   353,  345,  168,  327,  270,   26,   38,  225,  183,   48,
 /*   540 */    47,   44,   39,   32,   30,  348,  349,   28,   15,  356,
 /*   550 */   357,   16,   18,  182,  347,  280,  333,  310,  324,  246,
 /*   560 */   249,  125,  188,  188,  188,  142,  137,  364,  365,  366,
 /*   570 */   367,  363,  362,  358,  359,  360,  361,  344,  343,  270,
 /*   580 */   270,   24,  354,  212,  181,  254,   48,   47,   44,   39,
 /*   590 */    32,   30,  348,  349,   28,   15,  356,  357,   16,   18,
 /*   600 */   201,   37,  250,  267,  342,  202,  239,  283,  251,  188,
 /*   610 */   188,  157,  274,  273,  364,  365,  366,  367,  363,  362,
 /*   620 */   358,  359,  360,  361,  344,  343,  182,  368,  326,  109,
 /*   630 */   115,  127,  178,  211,  210,   51,   29,  122,  106,  290,
 /*   640 */   144,  128,  263,   93,  266,  284,  111,  188,  278,  113,
 /*   650 */   353,  345,  168,  327,  270,  284,  119,    3,  281,   48,
 /*   660 */    47,   44,   39,   32,   30,  348,  349,   28,   15,  356,
 /*   670 */   357,   16,   18,  112,  292,  282,   40,  130,  118,  328,
 /*   680 */   273,   41,  260,  271,  134,  232,  305,  364,  365,  366,
 /*   690 */   367,  363,  362,  358,  359,  360,  361,  344,  343,  182,
 /*   700 */   326,  159,  182,   95,  194,  326,  210,   80,  235,  194,
 /*   710 */   106,  210,   62,  167,  264,  106,  266,  108,   89,  314,
 /*   720 */   314,  266,  353,  345,  200,  327,  314,  353,  345,   14,
 /*   730 */   327,  284,   48,   47,   44,   39,   32,   30,  348,  349,
 /*   740 */    28,   15,  356,  357,   16,   18,  182,  314,  314,  314,
 /*   750 */   314,  314,  314,  314,  314,  314,  314,  314,   96,   97,
 /*   760 */   364,  365,  366,  367,  363,  362,  358,  359,  360,  361,
 /*   770 */   344,  343,  284,  284,  314,  314,  314,  314,  314,   48,
 /*   780 */    47,   44,   39,   32,   30,  348,  349,   28,   15,  356,
 /*   790 */   357,   16,   18,  314,  314,  205,  314,  314,  314,  314,
 /*   800 */   314,  314,  314,  314,  314,  314,  314,  364,  365,  366,
 /*   810 */   367,  363,  362,  358,  359,  360,  361,  344,  343,  182,
 /*   820 */   326,  314,  314,  129,  194,  326,  210,   63,  314,  194,
 /*   830 */   106,  210,   75,  314,  245,  106,  266,  284,  314,  314,
 /*   840 */   314,  266,  353,  345,  314,  327,  314,  353,  345,  314,
 /*   850 */   327,  314,   48,   47,   44,   39,   32,   30,  348,  349,
 /*   860 */    28,   15,  356,  357,   16,   18,  314,  314,  314,  314,
 /*   870 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  154,
 /*   880 */   364,  365,  366,  367,  363,  362,  358,  359,  360,  361,
 /*   890 */   344,  343,  182,  270,  314,  326,  314,  314,  151,  194,
 /*   900 */   314,  210,   65,  238,  314,  106,  314,  171,   11,  314,
 /*   910 */   169,  266,  270,  314,  195,  314,  208,  353,  345,  314,
 /*   920 */   327,  124,  314,  314,  204,   48,   47,   44,   39,   32,
 /*   930 */    30,  348,  349,   28,   15,  356,  357,   16,   18,  182,
 /*   940 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*   950 */   314,  131,  101,  364,  365,  366,  367,  363,  362,  358,
 /*   960 */   359,  360,  361,  344,  343,  284,  284,  335,   19,  228,
 /*   970 */   314,  314,   48,   47,   44,   39,   32,   30,  348,  349,
 /*   980 */    28,   15,  356,  357,   16,   18,  314,  314,  244,  314,
 /*   990 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  143,
 /*  1000 */   364,  365,  366,  367,  363,  362,  358,  359,  360,  361,
 /*  1010 */   344,  343,  182,  270,  314,  326,  314,  314,  152,  194,
 /*  1020 */   314,  210,   71,  238,  314,  106,  314,  291,   11,  314,
 /*  1030 */   167,  266,  270,  314,  195,  314,  208,  353,  345,  314,
 /*  1040 */   327,  124,  314,  314,  204,   48,   47,   44,   39,   32,
 /*  1050 */    30,  348,  349,   28,   15,  356,  357,   16,   18,  182,
 /*  1060 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1070 */   314,  149,  132,  364,  365,  366,  367,  363,  362,  358,
 /*  1080 */   359,  360,  361,  344,  343,  270,  284,  334,   19,  228,
 /*  1090 */   314,  314,   48,   47,   44,   39,   32,   30,  348,  349,
 /*  1100 */    28,   15,  356,  357,   16,   18,  314,  314,  314,  314,
 /*  1110 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1120 */   364,  365,  366,  367,  363,  362,  358,  359,  360,  361,
 /*  1130 */   344,  343,  314,  146,  148,  314,    2,   91,  116,  175,
 /*  1140 */   314,  314,  195,  314,  208,  167,  168,  270,  270,  124,
 /*  1150 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1160 */   314,  314,  326,  314,  314,  314,  179,  314,  210,   74,
 /*  1170 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1180 */    88,    1,  242,  314,  353,  345,    2,  327,  116,  184,
 /*  1190 */   314,  314,  195,  314,  208,   86,  180,  241,  314,  124,
 /*  1200 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1210 */   314,  314,  326,  314,  314,  314,  179,  314,  210,   74,
 /*  1220 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1230 */    88,    1,  314,  314,  353,  345,    2,  327,  103,  173,
 /*  1240 */   314,  314,  195,  314,  208,   86,  314,  259,  314,  124,
 /*  1250 */   314,  314,  204,  187,  314,  314,   45,  314,  314,  314,
 /*  1260 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   67,
 /*  1270 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1280 */    88,    1,  314,  314,  353,  345,    2,  327,  103,  184,
 /*  1290 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1300 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1310 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   68,
 /*  1320 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1330 */    88,    1,  314,  314,  353,  345,    2,  327,  117,   83,
 /*  1340 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1350 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1360 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   81,
 /*  1370 */    22,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1380 */    88,    1,  314,  314,  353,  345,    2,  327,  116,  177,
 /*  1390 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1400 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1410 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   64,
 /*  1420 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1430 */    88,    1,  314,  314,  353,  345,    2,  327,  116,  184,
 /*  1440 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1450 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1460 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   72,
 /*  1470 */    22,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1480 */    88,    1,  314,  314,  353,  345,    2,  327,  107,  184,
 /*  1490 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1500 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1510 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   69,
 /*  1520 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1530 */    88,    1,  314,  314,  353,  345,    2,  327,  116,  172,
 /*  1540 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1550 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1560 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   54,
 /*  1570 */    22,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1580 */    88,    1,  314,  314,  353,  345,    2,  327,  103,  184,
 /*  1590 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1600 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1610 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   57,
 /*  1620 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1630 */    88,  314,  314,  314,  353,  345,    2,  327,  103,  186,
 /*  1640 */   314,  314,  195,  314,  208,   86,  314,  314,  314,  124,
 /*  1650 */   314,  314,  204,  198,  314,  314,   45,  314,  314,  314,
 /*  1660 */   314,  314,  326,  314,  314,  314,  194,  314,  210,   60,
 /*  1670 */    17,  314,  106,   42,   46,  289,  190,  346,  266,  314,
 /*  1680 */    88,  314,  314,  314,  353,  345,  314,  327,  314,  314,
 /*  1690 */   314,  314,  314,  314,  226,   86,  314,  314,  314,  314,
 /*  1700 */   326,  314,  314,  314,  194,  326,  210,   76,  314,  194,
 /*  1710 */   106,  210,   60,  314,  314,  106,  266,  314,  314,  314,
 /*  1720 */   314,  266,  353,  345,  314,  327,  314,  353,  345,  314,
 /*  1730 */   327,  314,  314,  314,  326,  314,  314,  227,  194,  314,
 /*  1740 */   210,   60,  314,  314,  106,  314,  314,  314,  326,  314,
 /*  1750 */   266,  314,  194,  314,  210,   60,  353,  345,  106,  327,
 /*  1760 */   314,  314,  314,  314,  266,  314,  252,  314,  314,  314,
 /*  1770 */   353,  345,  314,  327,  314,  314,  314,  326,  314,  314,
 /*  1780 */   215,  194,  326,  210,   61,  314,  194,  106,  210,   59,
 /*  1790 */   314,  314,  106,  266,  314,  314,  314,  314,  266,  353,
 /*  1800 */   345,  314,  327,  314,  353,  345,  314,  327,  314,  326,
 /*  1810 */   314,  314,  314,  194,  314,  210,   78,  314,  314,  106,
 /*  1820 */   326,  314,  314,  314,  194,  266,  210,   82,  314,  314,
 /*  1830 */   106,  353,  345,  314,  327,  314,  266,  314,  314,  314,
 /*  1840 */   326,  314,  353,  345,  194,  327,  210,   58,  326,  314,
 /*  1850 */   106,  314,  194,  314,  210,   49,  266,  314,  106,  314,
 /*  1860 */   314,  314,  353,  345,  266,  327,  314,  314,  326,  314,
 /*  1870 */   353,  345,  194,  327,  210,   70,  314,  314,  106,  314,
 /*  1880 */   314,  314,  326,  314,  266,  314,  194,  314,  185,   55,
 /*  1890 */   353,  345,  106,  327,  314,  314,  314,  314,  266,  314,
 /*  1900 */   314,  314,  326,  314,  353,  345,  194,  327,  210,   73,
 /*  1910 */   314,  314,  106,  326,  314,  314,  314,  194,  266,  210,
 /*  1920 */    56,  314,  314,  106,  353,  345,  314,  327,  314,  266,
 /*  1930 */   314,  314,  314,  314,  314,  353,  345,  326,  327,  314,
 /*  1940 */   314,  194,  314,  210,   79,  326,  314,  106,  314,  203,
 /*  1950 */   314,  210,  314,  266,  314,  106,  314,  314,  314,  353,
 /*  1960 */   345,  191,  327,  314,  314,  314,  314,  353,  345,  314,
 /*  1970 */   327,  326,  314,  314,  314,  350,  314,  210,  314,  314,
 /*  1980 */   326,  106,  314,  314,  288,  314,  210,  351,  314,  314,
 /*  1990 */   106,  326,  314,  353,  345,  261,  327,  210,  314,  314,
 /*  2000 */   326,  106,  353,  345,  253,  327,  210,  262,  314,  314,
 /*  2010 */   106,  326,  314,  353,  345,  287,  327,  210,  314,  314,
 /*  2020 */   326,  106,  353,  345,  352,  327,  210,  314,  314,  314,
 /*  2030 */   106,  326,  314,  353,  345,  279,  327,  210,  314,  314,
 /*  2040 */   314,  106,  353,  345,  314,  327,  314,  314,  314,  314,
 /*  2050 */   314,  314,  314,  353,  345,  314,  327,  326,  314,  314,
 /*  2060 */   314,  236,  326,  210,  314,  314,  257,  106,  210,  314,
 /*  2070 */   314,  314,  106,  314,  314,  314,  314,  314,  314,  353,
 /*  2080 */   345,  314,  327,  314,  353,  345,  314,  327,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   30,   33,   86,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,   10,   11,   12,   89,   16,   15,  100,  110,  111,
 /*    20 */    49,   22,   21,   98,   23,   15,  101,  102,   57,   28,
 /*    30 */    61,  114,   31,   34,   35,   36,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,    4,    5,    6,
 /*    50 */     7,    8,   16,   19,   20,   12,   13,   14,   22,   49,
 /*    60 */    16,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,    1,   81,   80,   81,   82,   85,   22,
 /*    80 */    87,   88,   55,   90,   91,   49,   86,   60,   16,   89,
 /*    90 */    97,   57,   48,   57,   22,   81,  103,  104,   98,  106,
 /*   100 */   100,  101,  102,   17,   18,  107,   34,   35,   36,   37,
 /*   110 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   120 */    78,   79,   80,   81,   82,   15,   15,   17,   18,   18,
 /*   130 */    19,  117,  118,   18,   62,   63,   64,   65,   66,   67,
 /*   140 */    68,   69,   70,   71,   72,   73,    1,    1,   81,   86,
 /*   150 */    15,   16,   85,   18,   87,   88,   15,   90,   91,   18,
 /*   160 */    19,   98,   16,  100,   97,   30,   20,   22,   22,   58,
 /*   170 */   103,  104,   27,  106,   15,   16,    2,   18,   99,   34,
 /*   180 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   190 */    45,   46,   47,   19,   25,   49,   15,   19,   15,   18,
 /*   200 */    19,   18,    2,   57,   17,   18,   25,   62,   63,   64,
 /*   210 */    65,   66,   67,   68,   69,   70,   71,   72,   73,    1,
 /*   220 */    81,  107,   22,   24,   85,   15,   87,   88,   18,   90,
 /*   230 */    91,   16,   33,   55,   16,   86,   97,   22,   89,   20,
 /*   240 */    25,   58,  103,  104,   75,  106,   59,   98,    2,  100,
 /*   250 */   101,  102,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   260 */    42,   43,   44,   45,   46,   47,    1,   16,   58,   15,
 /*   270 */    16,   49,   18,   22,   55,   15,   25,   17,   18,   60,
 /*   280 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   290 */    72,   73,   32,  108,   32,  110,  111,    1,   33,   34,
 /*   300 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   310 */    45,   46,   47,    1,  107,   16,  109,   16,   22,   16,
 /*   320 */    48,   22,   87,   22,    1,   22,   91,   62,   63,   64,
 /*   330 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   16,
 /*   340 */    15,  106,   29,   18,   18,   22,   34,   35,   36,   37,
 /*   350 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   360 */     1,    2,   16,   16,   16,   16,  110,  111,   22,   22,
 /*   370 */    22,   22,   18,   61,   62,   63,   64,   65,   66,   67,
 /*   380 */    68,   69,   70,   71,   72,   73,   32,   15,   19,   15,
 /*   390 */    18,   30,   18,   34,   35,   36,   37,   38,   39,   40,
 /*   400 */    41,   42,   43,   44,   45,   46,   47,   49,   16,   48,
 /*   410 */    16,   16,   16,   55,   22,   57,   22,   22,   22,   61,
 /*   420 */    18,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   430 */    71,   72,   73,    1,   81,   19,   61,   86,   85,   95,
 /*   440 */    87,   88,   48,   48,   91,   92,   86,   49,   16,   89,
 /*   450 */    97,  100,   22,  109,   19,   57,  103,  104,   98,  106,
 /*   460 */   100,  101,  102,   82,   29,   84,   34,   35,   36,   37,
 /*   470 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   480 */    18,   18,   81,   16,   49,   16,  107,   16,  109,   22,
 /*   490 */    20,   22,   57,   22,   62,   63,   64,   65,   66,   67,
 /*   500 */    68,   69,   70,   71,   72,   73,    1,    1,   81,  105,
 /*   510 */    15,   16,   85,   18,   87,   88,  112,   90,   91,  118,
 /*   520 */    86,   58,   16,   89,   97,   30,   20,   57,   22,   24,
 /*   530 */   103,  104,   98,  106,  100,  101,  102,   92,   93,   34,
 /*   540 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   550 */    45,   46,   47,    1,  105,   18,   16,   16,   16,   50,
 /*   560 */    50,  112,   22,   22,   22,   86,   86,   62,   63,   64,
 /*   570 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  100,
 /*   580 */   100,   15,   18,   18,   18,   50,   34,   35,   36,   37,
 /*   590 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   600 */    96,   26,   59,   16,   16,   29,   16,   18,   59,   22,
 /*   610 */    22,   99,   16,  109,   62,   63,   64,   65,   66,   67,
 /*   620 */    68,   69,   70,   71,   72,   73,    1,   75,   81,   17,
 /*   630 */    17,   95,   85,   55,   87,   88,   51,   90,   91,   32,
 /*   640 */    86,   95,   16,   89,   97,  109,   17,   22,   25,   17,
 /*   650 */   103,  104,   98,  106,  100,  109,   22,   49,   18,   34,
 /*   660 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   670 */    45,   46,   47,   17,  100,  108,    2,   20,   17,  111,
 /*   680 */   109,   22,  112,  114,  107,   92,   13,   62,   63,   64,
 /*   690 */    65,   66,   67,   68,   69,   70,   71,   72,   73,    1,
 /*   700 */    81,   99,    1,   83,   85,   81,   87,   88,   22,   85,
 /*   710 */    91,   87,   88,   98,   16,   91,   97,   95,  107,  119,
 /*   720 */   119,   97,  103,  104,   94,  106,  119,  103,  104,   94,
 /*   730 */   106,  109,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   740 */    42,   43,   44,   45,   46,   47,    1,  119,  119,  119,
 /*   750 */   119,  119,  119,  119,  119,  119,  119,  119,   95,   95,
 /*   760 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   770 */    72,   73,  109,  109,  119,  119,  119,  119,  119,   34,
 /*   780 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   790 */    45,   46,   47,  119,  119,   50,  119,  119,  119,  119,
 /*   800 */   119,  119,  119,  119,  119,  119,  119,   62,   63,   64,
 /*   810 */    65,   66,   67,   68,   69,   70,   71,   72,   73,    1,
 /*   820 */    81,  119,  119,   95,   85,   81,   87,   88,  119,   85,
 /*   830 */    91,   87,   88,  119,   16,   91,   97,  109,  119,  119,
 /*   840 */   119,   97,  103,  104,  119,  106,  119,  103,  104,  119,
 /*   850 */   106,  119,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   860 */    42,   43,   44,   45,   46,   47,  119,  119,  119,  119,
 /*   870 */   119,  119,  119,  119,  119,  119,  119,  119,  119,   86,
 /*   880 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   890 */    72,   73,    1,  100,  119,   81,  119,  119,   86,   85,
 /*   900 */   119,   87,   88,   10,  119,   91,  119,   16,   15,  119,
 /*   910 */    98,   97,  100,  119,   21,  119,   23,  103,  104,  119,
 /*   920 */   106,   28,  119,  119,   31,   34,   35,   36,   37,   38,
 /*   930 */    39,   40,   41,   42,   43,   44,   45,   46,   47,    1,
 /*   940 */   119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
 /*   950 */   119,   95,   95,   62,   63,   64,   65,   66,   67,   68,
 /*   960 */    69,   70,   71,   72,   73,  109,  109,   74,   75,   76,
 /*   970 */   119,  119,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   980 */    42,   43,   44,   45,   46,   47,  119,  119,   50,  119,
 /*   990 */   119,  119,  119,  119,  119,  119,  119,  119,  119,   86,
 /*  1000 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*  1010 */    72,   73,    1,  100,  119,   81,  119,  119,   86,   85,
 /*  1020 */   119,   87,   88,   10,  119,   91,  119,   16,   15,  119,
 /*  1030 */    98,   97,  100,  119,   21,  119,   23,  103,  104,  119,
 /*  1040 */   106,   28,  119,  119,   31,   34,   35,   36,   37,   38,
 /*  1050 */    39,   40,   41,   42,   43,   44,   45,   46,   47,    1,
 /*  1060 */   119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
 /*  1070 */   119,   86,   95,   62,   63,   64,   65,   66,   67,   68,
 /*  1080 */    69,   70,   71,   72,   73,  100,  109,   74,   75,   76,
 /*  1090 */   119,  119,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  1100 */    42,   43,   44,   45,   46,   47,  119,  119,  119,  119,
 /*  1110 */   119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
 /*  1120 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*  1130 */    72,   73,  119,   86,   86,  119,   15,   89,   17,   18,
 /*  1140 */   119,  119,   21,  119,   23,   98,   98,  100,  100,   28,
 /*  1150 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1160 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1170 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1180 */    59,   60,   61,  119,  103,  104,   15,  106,   17,   18,
 /*  1190 */   119,  119,   21,  119,   23,   74,  115,  116,  119,   28,
 /*  1200 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1210 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1220 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1230 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1240 */   119,  119,   21,  119,   23,   74,  119,  116,  119,   28,
 /*  1250 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1260 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1270 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1280 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1290 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1300 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1310 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1320 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1330 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1340 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1350 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1360 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1370 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1380 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1390 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1400 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1410 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1420 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1430 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1440 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1450 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1460 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1470 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1480 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1490 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1500 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1510 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1520 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1530 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1540 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1550 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1560 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1570 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1580 */    59,   60,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1590 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1600 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1610 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1620 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1630 */    59,  119,  119,  119,  103,  104,   15,  106,   17,   18,
 /*  1640 */   119,  119,   21,  119,   23,   74,  119,  119,  119,   28,
 /*  1650 */   119,  119,   31,   32,  119,  119,   35,  119,  119,  119,
 /*  1660 */   119,  119,   81,  119,  119,  119,   85,  119,   87,   88,
 /*  1670 */    49,  119,   91,   52,   53,   54,   55,   56,   97,  119,
 /*  1680 */    59,  119,  119,  119,  103,  104,  119,  106,  119,  119,
 /*  1690 */   119,  119,  119,  119,  113,   74,  119,  119,  119,  119,
 /*  1700 */    81,  119,  119,  119,   85,   81,   87,   88,  119,   85,
 /*  1710 */    91,   87,   88,  119,  119,   91,   97,  119,  119,  119,
 /*  1720 */   119,   97,  103,  104,  119,  106,  119,  103,  104,  119,
 /*  1730 */   106,  119,  119,  119,   81,  119,  119,  113,   85,  119,
 /*  1740 */    87,   88,  119,  119,   91,  119,  119,  119,   81,  119,
 /*  1750 */    97,  119,   85,  119,   87,   88,  103,  104,   91,  106,
 /*  1760 */   119,  119,  119,  119,   97,  119,  113,  119,  119,  119,
 /*  1770 */   103,  104,  119,  106,  119,  119,  119,   81,  119,  119,
 /*  1780 */   113,   85,   81,   87,   88,  119,   85,   91,   87,   88,
 /*  1790 */   119,  119,   91,   97,  119,  119,  119,  119,   97,  103,
 /*  1800 */   104,  119,  106,  119,  103,  104,  119,  106,  119,   81,
 /*  1810 */   119,  119,  119,   85,  119,   87,   88,  119,  119,   91,
 /*  1820 */    81,  119,  119,  119,   85,   97,   87,   88,  119,  119,
 /*  1830 */    91,  103,  104,  119,  106,  119,   97,  119,  119,  119,
 /*  1840 */    81,  119,  103,  104,   85,  106,   87,   88,   81,  119,
 /*  1850 */    91,  119,   85,  119,   87,   88,   97,  119,   91,  119,
 /*  1860 */   119,  119,  103,  104,   97,  106,  119,  119,   81,  119,
 /*  1870 */   103,  104,   85,  106,   87,   88,  119,  119,   91,  119,
 /*  1880 */   119,  119,   81,  119,   97,  119,   85,  119,   87,   88,
 /*  1890 */   103,  104,   91,  106,  119,  119,  119,  119,   97,  119,
 /*  1900 */   119,  119,   81,  119,  103,  104,   85,  106,   87,   88,
 /*  1910 */   119,  119,   91,   81,  119,  119,  119,   85,   97,   87,
 /*  1920 */    88,  119,  119,   91,  103,  104,  119,  106,  119,   97,
 /*  1930 */   119,  119,  119,  119,  119,  103,  104,   81,  106,  119,
 /*  1940 */   119,   85,  119,   87,   88,   81,  119,   91,  119,   85,
 /*  1950 */   119,   87,  119,   97,  119,   91,  119,  119,  119,  103,
 /*  1960 */   104,   97,  106,  119,  119,  119,  119,  103,  104,  119,
 /*  1970 */   106,   81,  119,  119,  119,   85,  119,   87,  119,  119,
 /*  1980 */    81,   91,  119,  119,   85,  119,   87,   97,  119,  119,
 /*  1990 */    91,   81,  119,  103,  104,   85,  106,   87,  119,  119,
 /*  2000 */    81,   91,  103,  104,   85,  106,   87,   97,  119,  119,
 /*  2010 */    91,   81,  119,  103,  104,   85,  106,   87,  119,  119,
 /*  2020 */    81,   91,  103,  104,   85,  106,   87,  119,  119,  119,
 /*  2030 */    91,   81,  119,  103,  104,   85,  106,   87,  119,  119,
 /*  2040 */   119,   91,  103,  104,  119,  106,  119,  119,  119,  119,
 /*  2050 */   119,  119,  119,  103,  104,  119,  106,   81,  119,  119,
 /*  2060 */   119,   85,   81,   87,  119,  119,   85,   91,   87,  119,
 /*  2070 */   119,  119,   91,  119,  119,  119,  119,  119,  119,  103,
 /*  2080 */   104,  119,  106,  119,  103,  104,  119,  106,
);
    const YY_SHIFT_USE_DFLT = -32;
    const YY_SHIFT_MAX = 227;
    static public $yy_shift_ofst = array(
 /*     0 */     1, 1371, 1321, 1171, 1171, 1171, 1171, 1421, 1371, 1421,
 /*    10 */  1521, 1321, 1471, 1121, 1171, 1171, 1171, 1171, 1171, 1171,
 /*    20 */  1171, 1171, 1171, 1171, 1171, 1171, 1171, 1171, 1171, 1171,
 /*    30 */  1171, 1171, 1171, 1171, 1171, 1171, 1171, 1171, 1171, 1271,
 /*    40 */  1271, 1221, 1571, 1621, 1571, 1571, 1571, 1571, 1571,  145,
 /*    50 */    72,   -1,  625,  625,  698,  552,  818,  891,  938,  432,
 /*    60 */   265,  218,  312,  505,  359,  745, 1011, 1058, 1058, 1058,
 /*    70 */  1058, 1058, 1058, 1058, 1058, 1058, 1058, 1058, 1058, 1058,
 /*    80 */  1058, 1058, 1058,  146,  296,    1, 1013,  506,  187,  219,
 /*    90 */   323,  296,  200,  296,  893,   43,  111,  181,  394,  215,
 /*   100 */    34,  183,  251,  325,   86,  325,  470,  372,  325,  325,
 /*   110 */   374,  325,  325,  325,   86,  325,  372,  566,  325,  661,
 /*   120 */   430,  657,  430,  430,  659,  657,  135,  495,  159,  210,
 /*   130 */   110,  141,  254,   27,   27,   27,   10,  301,  299,  303,
 /*   140 */   348,  346,  347,  349,  588,  540,  471,  396,  469,  541,
 /*   150 */    27,  587,  542,   27,  467,  392,  657,  674,  657,  674,
 /*   160 */   673,  657,  686,  701,  686,  608,  661,  -32,  -32,  -32,
 /*   170 */   -32,  -32,   36,  435,  260,  358,  395,  -29,   44,  361,
 /*   180 */   -31,  174,  463,  199,  398,  169,  398,  178,  354,  115,
 /*   190 */   262,  313,  369,  222,  272,   57,  246,  640,  578,  613,
 /*   200 */   612,  596,  656,  576,  326,  585,  629,  608,  634,  632,
 /*   210 */   623,  607,  626,  590,  549,  509,  537,  462,  402,  375,
 /*   220 */   416,  564,  565,  543,  589,  575,  535,  510,
);
    const YY_REDUCE_USE_DFLT = -93;
    const YY_REDUCE_MAX = 171;
    static public $yy_reduce_ofst = array(
 /*     0 */    42, 1081,  427, 1624, 1667, 1653, 1581,   -7, 1131,  547,
 /*    10 */    67,  139,  353,  624,  739,  744, 1728, 1759, 1739, 1801,
 /*    20 */  1821, 1281,  814, 1381, 1481,  619, 1431, 1531, 1619, 1331,
 /*    30 */   934, 1181, 1231, 1696, 1701, 1832, 1856, 1767, 1787, 1890,
 /*    40 */  1910, 1864, 1930, 1919, 1939, 1950, 1899, 1981, 1976,  434,
 /*    50 */   149,    0,  149,  360,  -75,  -75,  -75,  -75,  -75,  -75,
 /*    60 */   -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
 /*    70 */   -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,  -75,
 /*    80 */   -75,  -75,  -75,  554, 1048,   -5,   14,  812,  235,  185,
 /*    90 */   932,   63,  -83, 1047,  401,  381,  379,  504,  985,  793,
 /*   100 */   256,  379,  793,  857,  449,  728,  256,  663,  207,  664,
 /*   110 */   622,  536,  344,  546,  404,  977,  857,  857,  856,  445,
 /*   120 */   913,  256,  480,  479,  351,  -92,  571,  571,  571,  571,
 /*   130 */   570,  571,  571,  567,  567,  567,  577,  574,  574,  574,
 /*   140 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*   150 */   567,  574,  574,  567,  574,  574,  568,  569,  568,  569,
 /*   160 */   620,  568,  630,  615,  635,  611,  593,  602,  512,   79,
 /*   170 */    -2,  114,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, ),
        /* 1 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 2 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 3 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 4 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 5 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 6 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 7 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 8 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 9 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 10 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 11 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 12 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 13 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 61, 74, ),
        /* 14 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 15 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 16 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 17 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 18 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 19 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 20 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 21 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 22 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 23 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 24 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 25 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 26 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 27 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 28 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 29 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 30 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 31 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 32 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 33 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 34 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 35 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 36 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 37 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 38 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 39 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 40 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 41 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 60, 74, ),
        /* 42 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 43 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 44 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 45 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 46 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 47 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 48 */ array(15, 17, 18, 21, 23, 28, 31, 32, 35, 49, 52, 53, 54, 55, 56, 59, 74, ),
        /* 49 */ array(1, 22, 27, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 50 */ array(1, 16, 22, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 51 */ array(1, 16, 22, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 52 */ array(1, 22, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 53 */ array(1, 22, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 54 */ array(1, 16, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 55 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 75, ),
        /* 56 */ array(1, 16, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 57 */ array(1, 16, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 58 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 50, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 59 */ array(1, 16, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 60 */ array(1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 61 */ array(1, 16, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 62 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 63 */ array(1, 24, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 64 */ array(1, 2, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 65 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 50, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 66 */ array(1, 16, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 67 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 68 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 69 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 70 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 71 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 72 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 73 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 74 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 75 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 76 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 77 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 78 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 79 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 80 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 81 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 82 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, ),
        /* 83 */ array(1, 16, 20, 22, 49, 57, ),
        /* 84 */ array(1, 22, ),
        /* 85 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, ),
        /* 86 */ array(10, 15, 21, 23, 28, 31, 74, 75, 76, ),
        /* 87 */ array(1, 16, 20, 22, ),
        /* 88 */ array(17, 18, 59, ),
        /* 89 */ array(20, 55, 60, ),
        /* 90 */ array(1, 16, 22, ),
        /* 91 */ array(1, 22, ),
        /* 92 */ array(2, 22, ),
        /* 93 */ array(1, 22, ),
        /* 94 */ array(10, 15, 21, 23, 28, 31, 74, 75, 76, ),
        /* 95 */ array(4, 5, 6, 7, 8, 12, 13, 14, ),
        /* 96 */ array(15, 18, 19, 58, ),
        /* 97 */ array(15, 18, 19, 25, ),
        /* 98 */ array(16, 22, 48, ),
        /* 99 */ array(16, 22, 25, ),
        /* 100 */ array(19, 20, 57, ),
        /* 101 */ array(15, 18, 58, ),
        /* 102 */ array(16, 22, 25, ),
        /* 103 */ array(15, 18, ),
        /* 104 */ array(17, 18, ),
        /* 105 */ array(15, 18, ),
        /* 106 */ array(20, 57, ),
        /* 107 */ array(15, 18, ),
        /* 108 */ array(15, 18, ),
        /* 109 */ array(15, 18, ),
        /* 110 */ array(15, 18, ),
        /* 111 */ array(15, 18, ),
        /* 112 */ array(15, 18, ),
        /* 113 */ array(15, 18, ),
        /* 114 */ array(17, 18, ),
        /* 115 */ array(15, 18, ),
        /* 116 */ array(15, 18, ),
        /* 117 */ array(15, 18, ),
        /* 118 */ array(15, 18, ),
        /* 119 */ array(17, ),
        /* 120 */ array(22, ),
        /* 121 */ array(20, ),
        /* 122 */ array(22, ),
        /* 123 */ array(22, ),
        /* 124 */ array(22, ),
        /* 125 */ array(20, ),
        /* 126 */ array(15, 16, 18, 30, ),
        /* 127 */ array(15, 16, 18, 30, ),
        /* 128 */ array(15, 16, 18, ),
        /* 129 */ array(15, 18, 58, ),
        /* 130 */ array(15, 17, 18, ),
        /* 131 */ array(15, 18, 19, ),
        /* 132 */ array(15, 16, 18, ),
        /* 133 */ array(55, 60, ),
        /* 134 */ array(55, 60, ),
        /* 135 */ array(55, 60, ),
        /* 136 */ array(15, 49, ),
        /* 137 */ array(16, 22, ),
        /* 138 */ array(16, 22, ),
        /* 139 */ array(16, 22, ),
        /* 140 */ array(16, 22, ),
        /* 141 */ array(16, 22, ),
        /* 142 */ array(16, 22, ),
        /* 143 */ array(16, 22, ),
        /* 144 */ array(16, 22, ),
        /* 145 */ array(16, 22, ),
        /* 146 */ array(16, 22, ),
        /* 147 */ array(16, 22, ),
        /* 148 */ array(16, 22, ),
        /* 149 */ array(16, 22, ),
        /* 150 */ array(55, 60, ),
        /* 151 */ array(16, 22, ),
        /* 152 */ array(16, 22, ),
        /* 153 */ array(55, 60, ),
        /* 154 */ array(16, 22, ),
        /* 155 */ array(16, 22, ),
        /* 156 */ array(20, ),
        /* 157 */ array(2, ),
        /* 158 */ array(20, ),
        /* 159 */ array(2, ),
        /* 160 */ array(13, ),
        /* 161 */ array(20, ),
        /* 162 */ array(22, ),
        /* 163 */ array(1, ),
        /* 164 */ array(22, ),
        /* 165 */ array(49, ),
        /* 166 */ array(17, ),
        /* 167 */ array(),
        /* 168 */ array(),
        /* 169 */ array(),
        /* 170 */ array(),
        /* 171 */ array(),
        /* 172 */ array(16, 22, 49, 57, ),
        /* 173 */ array(19, 29, 49, 57, ),
        /* 174 */ array(15, 17, 18, 32, ),
        /* 175 */ array(49, 55, 57, 61, ),
        /* 176 */ array(16, 22, 48, ),
        /* 177 */ array(30, 49, 57, ),
        /* 178 */ array(16, 48, ),
        /* 179 */ array(30, 48, ),
        /* 180 */ array(33, 61, ),
        /* 181 */ array(2, 19, ),
        /* 182 */ array(18, 58, ),
        /* 183 */ array(24, 33, ),
        /* 184 */ array(49, 57, ),
        /* 185 */ array(25, 75, ),
        /* 186 */ array(49, 57, ),
        /* 187 */ array(19, 55, ),
        /* 188 */ array(18, 32, ),
        /* 189 */ array(18, ),
        /* 190 */ array(32, ),
        /* 191 */ array(29, ),
        /* 192 */ array(19, ),
        /* 193 */ array(49, ),
        /* 194 */ array(48, ),
        /* 195 */ array(22, ),
        /* 196 */ array(2, ),
        /* 197 */ array(18, ),
        /* 198 */ array(55, ),
        /* 199 */ array(17, ),
        /* 200 */ array(17, ),
        /* 201 */ array(16, ),
        /* 202 */ array(17, ),
        /* 203 */ array(29, ),
        /* 204 */ array(18, ),
        /* 205 */ array(51, ),
        /* 206 */ array(17, ),
        /* 207 */ array(49, ),
        /* 208 */ array(22, ),
        /* 209 */ array(17, ),
        /* 210 */ array(25, ),
        /* 211 */ array(32, ),
        /* 212 */ array(16, ),
        /* 213 */ array(16, ),
        /* 214 */ array(59, ),
        /* 215 */ array(50, ),
        /* 216 */ array(18, ),
        /* 217 */ array(18, ),
        /* 218 */ array(18, ),
        /* 219 */ array(61, ),
        /* 220 */ array(19, ),
        /* 221 */ array(18, ),
        /* 222 */ array(18, ),
        /* 223 */ array(59, ),
        /* 224 */ array(18, ),
        /* 225 */ array(26, ),
        /* 226 */ array(50, ),
        /* 227 */ array(50, ),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
);
    static public $yy_default = array(
 /*     0 */   372,  545,  562,  516,  516,  516,  516,  562,  562,  562,
 /*    10 */   562,  562,  562,  562,  562,  562,  562,  562,  562,  562,
 /*    20 */   562,  562,  562,  562,  562,  562,  562,  562,  562,  562,
 /*    30 */   562,  562,  562,  562,  562,  562,  562,  562,  562,  562,
 /*    40 */   562,  562,  562,  562,  562,  562,  562,  562,  562,  430,
 /*    50 */   562,  562,  430,  430,  562,  562,  562,  562,  562,  562,
 /*    60 */   515,  562,  562,  562,  562,  562,  562,  546,  451,  447,
 /*    70 */   450,  452,  436,  547,  548,  456,  455,  432,  459,  439,
 /*    80 */   463,  415,  460,  474,  430,  369,  562,  562,  562,  528,
 /*    90 */   446,  430,  430,  430,  562,  562,  489,  562,  440,  464,
 /*   100 */   482,  489,  464,  562,  562,  562,  482,  562,  489,  562,
 /*   110 */   562,  562,  562,  562,  562,  562,  562,  562,  562,  562,
 /*   120 */   430,  482,  430,  430,  430,  525,  562,  562,  562,  490,
 /*   130 */   562,  562,  562,  508,  506,  509,  489,  562,  562,  562,
 /*   140 */   562,  562,  562,  562,  562,  562,  562,  562,  562,  562,
 /*   150 */   507,  562,  562,  487,  562,  562,  529,  518,  503,  517,
 /*   160 */   387,  526,  561,  446,  561,  489,  562,  522,  522,  522,
 /*   170 */   489,  489,  474,  435,  562,  474,  440,  474,  440,  440,
 /*   180 */   562,  501,  562,  562,  474,  464,  461,  470,  562,  562,
 /*   190 */   562,  562,  435,  527,  440,  562,  501,  562,  470,  562,
 /*   200 */   562,  562,  562,  562,  562,  476,  562,  501,  562,  562,
 /*   210 */   464,  472,  562,  562,  562,  562,  562,  562,  562,  562,
 /*   220 */   562,  562,  562,  562,  562,  437,  562,  562,  555,  370,
 /*   230 */   553,  434,  438,  418,  417,  560,  442,  552,  559,  413,
 /*   240 */   558,  543,  498,  496,  476,  494,  511,  495,  497,  513,
 /*   250 */   485,  486,  514,  462,  512,  422,  423,  443,  416,  544,
 /*   260 */   510,  523,  524,  427,  502,  542,  445,  425,  424,  426,
 /*   270 */   429,  521,  501,  500,  414,  419,  420,  421,  468,  465,
 /*   280 */   483,  441,  488,  491,  499,  479,  473,  466,  467,  469,
 /*   290 */   471,  412,  428,  379,  378,  380,  381,  382,  377,  376,
 /*   300 */   371,  373,  374,  375,  383,  384,  393,  392,  394,  395,
 /*   310 */   396,  391,  390,  385,  386,  388,  389,  492,  493,  557,
 /*   320 */   399,  400,  401,  402,  398,  556,  481,  484,  505,  397,
 /*   330 */   403,  404,  410,  411,  549,  550,  551,  409,  408,  405,
 /*   340 */   406,  504,  407,  541,  540,  478,  477,  480,  453,  454,
 /*   350 */   449,  448,  444,  475,  519,  520,  457,  458,  536,  537,
 /*   360 */   538,  539,  535,  534,  530,  531,  532,  533,  554,
);
    const YYNOCODE = 120;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 369;
    const YYNRULE = 193;
    const YYERRORSYMBOL = 77;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',   
  'FAKEPHPSTARTTAG',  'XMLTAG',        'OTHER',         'LINEBREAK',   
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',        
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',       
  'PTR',           'LDELIF',        'SPACE',         'LDELFOR',     
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'LDELFOREACH',   'AS',            'APTR',          'LDELSLASH',   
  'INTEGER',       'COMMA',         'MATH',          'UNIMATH',     
  'ANDSYM',        'ISIN',          'ISDIVBY',       'ISNOTDIVBY',  
  'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY', 
  'ISODD',         'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',  
  'INSTANCEOF',    'OPENP',         'CLOSEP',        'QMARK',       
  'NOT',           'TYPECAST',      'HEX',           'DOT',         
  'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',            'HATCH',       
  'OPENB',         'CLOSEB',        'EQUALS',        'NOTEQUALS',   
  'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',   
  'IDENTITY',      'NONEIDENTITY',  'MOD',           'LAND',        
  'LOR',           'LXOR',          'QUOTE',         'BACKTICK',    
  'DOLLARID',      'error',         'start',         'template',    
  'template_element',  'smartytag',     'literal',       'literal_elements',
  'literal_element',  'value',         'attributes',    'variable',    
  'expr',          'modifierlist',  'ternary',       'varindexed',  
  'statement',     'statements',    'optspace',      'varvar',      
  'foraction',     'array',         'modifier',      'modparameters',
  'attribute',     'ifcond',        'lop',           'function',    
  'doublequoted_with_quotes',  'static_class_access',  'object',        'arrayindex',  
  'indexdef',      'varvarele',     'objectchain',   'objectelement',
  'method',        'params',        'modparameter',  'arrayelements',
  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= OTHER",
 /*  14 */ "template_element ::= LINEBREAK",
 /*  15 */ "literal ::= LITERALSTART LITERALEND",
 /*  16 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  17 */ "literal_elements ::= literal_elements literal_element",
 /*  18 */ "literal_elements ::=",
 /*  19 */ "literal_element ::= literal",
 /*  20 */ "literal_element ::= LITERAL",
 /*  21 */ "literal_element ::= PHPSTARTTAG",
 /*  22 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  23 */ "literal_element ::= PHPENDTAG",
 /*  24 */ "literal_element ::= ASPSTARTTAG",
 /*  25 */ "literal_element ::= ASPENDTAG",
 /*  26 */ "smartytag ::= LDEL value RDEL",
 /*  27 */ "smartytag ::= LDEL value attributes RDEL",
 /*  28 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  29 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  31 */ "smartytag ::= LDEL ternary attributes RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL DOLLAR ID EQUAL ternary attributes RDEL",
 /*  36 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  37 */ "smartytag ::= LDEL varindexed EQUAL ternary attributes RDEL",
 /*  38 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID RDEL",
 /*  40 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  41 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  42 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  43 */ "smartytag ::= LDELIF SPACE expr RDEL",
 /*  44 */ "smartytag ::= LDELIF SPACE statement RDEL",
 /*  45 */ "smartytag ::= LDELFOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction RDEL",
 /*  46 */ "foraction ::= EQUAL expr",
 /*  47 */ "foraction ::= INCDEC",
 /*  48 */ "smartytag ::= LDELFOR SPACE statement TO expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOR SPACE statement TO expr STEP expr RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE array AS DOLLAR varvar RDEL",
 /*  54 */ "smartytag ::= LDELFOREACH SPACE array AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  55 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  56 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  57 */ "smartytag ::= LDELSLASH ID modifier modparameters attributes RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  59 */ "attributes ::= attributes attribute",
 /*  60 */ "attributes ::= attribute",
 /*  61 */ "attributes ::=",
 /*  62 */ "attribute ::= SPACE ID EQUAL ID",
 /*  63 */ "attribute ::= SPACE ID EQUAL expr",
 /*  64 */ "attribute ::= SPACE ID EQUAL value",
 /*  65 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  66 */ "attribute ::= SPACE ID",
 /*  67 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  68 */ "statements ::= statement",
 /*  69 */ "statements ::= statements COMMA statement",
 /*  70 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  71 */ "expr ::= value",
 /*  72 */ "expr ::= DOLLAR ID COLON ID",
 /*  73 */ "expr ::= expr MATH value",
 /*  74 */ "expr ::= expr UNIMATH value",
 /*  75 */ "expr ::= expr ANDSYM value",
 /*  76 */ "expr ::= array",
 /*  77 */ "expr ::= expr modifierlist",
 /*  78 */ "expr ::= expr ifcond expr",
 /*  79 */ "expr ::= expr ISIN array",
 /*  80 */ "expr ::= expr ISIN value",
 /*  81 */ "expr ::= expr lop expr",
 /*  82 */ "expr ::= expr ISDIVBY expr",
 /*  83 */ "expr ::= expr ISNOTDIVBY expr",
 /*  84 */ "expr ::= expr ISEVEN",
 /*  85 */ "expr ::= expr ISNOTEVEN",
 /*  86 */ "expr ::= expr ISEVENBY expr",
 /*  87 */ "expr ::= expr ISNOTEVENBY expr",
 /*  88 */ "expr ::= expr ISODD",
 /*  89 */ "expr ::= expr ISNOTODD",
 /*  90 */ "expr ::= expr ISODDBY expr",
 /*  91 */ "expr ::= expr ISNOTODDBY expr",
 /*  92 */ "expr ::= value INSTANCEOF ID",
 /*  93 */ "expr ::= value INSTANCEOF value",
 /*  94 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  95 */ "value ::= variable",
 /*  96 */ "value ::= UNIMATH value",
 /*  97 */ "value ::= NOT value",
 /*  98 */ "value ::= TYPECAST value",
 /*  99 */ "value ::= variable INCDEC",
 /* 100 */ "value ::= HEX",
 /* 101 */ "value ::= INTEGER",
 /* 102 */ "value ::= INTEGER DOT INTEGER",
 /* 103 */ "value ::= INTEGER DOT",
 /* 104 */ "value ::= DOT INTEGER",
 /* 105 */ "value ::= ID",
 /* 106 */ "value ::= function",
 /* 107 */ "value ::= OPENP expr CLOSEP",
 /* 108 */ "value ::= SINGLEQUOTESTRING",
 /* 109 */ "value ::= doublequoted_with_quotes",
 /* 110 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 111 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 112 */ "value ::= smartytag",
 /* 113 */ "variable ::= varindexed",
 /* 114 */ "variable ::= DOLLAR varvar AT ID",
 /* 115 */ "variable ::= object",
 /* 116 */ "variable ::= HATCH ID HATCH",
 /* 117 */ "variable ::= HATCH variable HATCH",
 /* 118 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 119 */ "arrayindex ::= arrayindex indexdef",
 /* 120 */ "arrayindex ::=",
 /* 121 */ "indexdef ::= DOT DOLLAR varvar",
 /* 122 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 123 */ "indexdef ::= DOT ID",
 /* 124 */ "indexdef ::= DOT INTEGER",
 /* 125 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 126 */ "indexdef ::= OPENB ID CLOSEB",
 /* 127 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 128 */ "indexdef ::= OPENB expr CLOSEB",
 /* 129 */ "indexdef ::= OPENB CLOSEB",
 /* 130 */ "varvar ::= varvarele",
 /* 131 */ "varvar ::= varvar varvarele",
 /* 132 */ "varvarele ::= ID",
 /* 133 */ "varvarele ::= LDEL expr RDEL",
 /* 134 */ "object ::= varindexed objectchain",
 /* 135 */ "objectchain ::= objectelement",
 /* 136 */ "objectchain ::= objectchain objectelement",
 /* 137 */ "objectelement ::= PTR ID arrayindex",
 /* 138 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 139 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 140 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 141 */ "objectelement ::= PTR method",
 /* 142 */ "function ::= ID OPENP params CLOSEP",
 /* 143 */ "method ::= ID OPENP params CLOSEP",
 /* 144 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 145 */ "params ::= expr COMMA params",
 /* 146 */ "params ::= expr",
 /* 147 */ "params ::=",
 /* 148 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 149 */ "modifierlist ::= modifier modparameters",
 /* 150 */ "modifier ::= VERT AT ID",
 /* 151 */ "modifier ::= VERT ID",
 /* 152 */ "modparameters ::= modparameters modparameter",
 /* 153 */ "modparameters ::=",
 /* 154 */ "modparameter ::= COLON value",
 /* 155 */ "modparameter ::= COLON array",
 /* 156 */ "static_class_access ::= method",
 /* 157 */ "static_class_access ::= method objectchain",
 /* 158 */ "static_class_access ::= ID",
 /* 159 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 160 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 161 */ "ifcond ::= EQUALS",
 /* 162 */ "ifcond ::= NOTEQUALS",
 /* 163 */ "ifcond ::= GREATERTHAN",
 /* 164 */ "ifcond ::= LESSTHAN",
 /* 165 */ "ifcond ::= GREATEREQUAL",
 /* 166 */ "ifcond ::= LESSEQUAL",
 /* 167 */ "ifcond ::= IDENTITY",
 /* 168 */ "ifcond ::= NONEIDENTITY",
 /* 169 */ "ifcond ::= MOD",
 /* 170 */ "lop ::= LAND",
 /* 171 */ "lop ::= LOR",
 /* 172 */ "lop ::= LXOR",
 /* 173 */ "array ::= OPENB arrayelements CLOSEB",
 /* 174 */ "arrayelements ::= arrayelement",
 /* 175 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 176 */ "arrayelements ::=",
 /* 177 */ "arrayelement ::= value APTR expr",
 /* 178 */ "arrayelement ::= ID APTR expr",
 /* 179 */ "arrayelement ::= expr",
 /* 180 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 181 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 182 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 183 */ "doublequoted ::= doublequotedcontent",
 /* 184 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 185 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 186 */ "doublequotedcontent ::= DOLLARID",
 /* 187 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 188 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 189 */ "doublequotedcontent ::= smartytag",
 /* 190 */ "doublequotedcontent ::= OTHER",
 /* 191 */ "optspace ::= SPACE",
 /* 192 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 82 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1615 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 2 ),
  array( 'lhs' => 79, 'rhs' => 0 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 0 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 5 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 5 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 12 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 8 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 10 ),
  array( 'lhs' => 81, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 10 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 4 ),
  array( 'lhs' => 81, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 0 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 0 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 5 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 4 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 5 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 111, 'rhs' => 6 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 5 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 0 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 0 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 115, 'rhs' => 1 ),
  array( 'lhs' => 115, 'rhs' => 3 ),
  array( 'lhs' => 115, 'rhs' => 0 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        18 => 15,
        16 => 16,
        17 => 17,
        96 => 17,
        98 => 17,
        99 => 17,
        157 => 17,
        19 => 19,
        20 => 19,
        71 => 19,
        95 => 19,
        100 => 19,
        101 => 19,
        106 => 19,
        108 => 19,
        109 => 19,
        115 => 19,
        156 => 19,
        174 => 19,
        21 => 21,
        22 => 21,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 27,
        30 => 27,
        31 => 27,
        29 => 29,
        32 => 32,
        33 => 32,
        34 => 34,
        35 => 34,
        36 => 36,
        37 => 36,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        44 => 43,
        45 => 45,
        46 => 46,
        47 => 47,
        60 => 47,
        146 => 47,
        150 => 47,
        158 => 47,
        179 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        61 => 61,
        62 => 62,
        63 => 63,
        64 => 63,
        65 => 63,
        66 => 66,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        72 => 72,
        73 => 73,
        74 => 73,
        75 => 73,
        76 => 76,
        130 => 76,
        191 => 76,
        77 => 77,
        78 => 78,
        81 => 78,
        92 => 78,
        79 => 79,
        80 => 80,
        82 => 82,
        83 => 83,
        84 => 84,
        89 => 84,
        85 => 85,
        88 => 85,
        86 => 86,
        91 => 86,
        87 => 87,
        90 => 87,
        93 => 93,
        94 => 94,
        97 => 97,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        107 => 107,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        116 => 116,
        117 => 117,
        118 => 118,
        119 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        128 => 125,
        126 => 126,
        127 => 127,
        129 => 129,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        147 => 147,
        148 => 148,
        149 => 149,
        151 => 151,
        152 => 152,
        153 => 153,
        192 => 153,
        154 => 154,
        155 => 154,
        159 => 159,
        160 => 160,
        161 => 161,
        162 => 162,
        163 => 163,
        164 => 164,
        165 => 165,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        180 => 180,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        185 => 184,
        187 => 184,
        186 => 186,
        188 => 188,
        189 => 189,
        190 => 190,
    );
#line 93 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->root_buffer->to_smarty_php();     }
#line 2027 "smarty_internal_templateparser.php"
#line 99 "smarty_internal_templateparser.y"
    function yy_r1(){ $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);     }
#line 2030 "smarty_internal_templateparser.php"
#line 111 "smarty_internal_templateparser.y"
    function yy_r4(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
                                         } else { 
                                           $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2042 "smarty_internal_templateparser.php"
#line 123 "smarty_internal_templateparser.y"
    function yy_r5(){ $this->_retvalue = new _smarty_tag($this, '');    }
#line 2045 "smarty_internal_templateparser.php"
#line 126 "smarty_internal_templateparser.y"
    function yy_r6(){ $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2048 "smarty_internal_templateparser.php"
#line 129 "smarty_internal_templateparser.y"
    function yy_r7(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2061 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true; 
                                       $this->is_xml = true; 
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2077 "smarty_internal_templateparser.php"
#line 157 "smarty_internal_templateparser.y"
    function yy_r9(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }
                                        }
#line 2098 "smarty_internal_templateparser.php"
#line 178 "smarty_internal_templateparser.y"
    function yy_r10(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }
                                        }
#line 2119 "smarty_internal_templateparser.php"
#line 198 "smarty_internal_templateparser.y"
    function yy_r11(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     }
                                        }
#line 2127 "smarty_internal_templateparser.php"
#line 206 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->compiler->tag_nocache = true; $this->is_xml = true; $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));    }
#line 2130 "smarty_internal_templateparser.php"
#line 209 "smarty_internal_templateparser.y"
    function yy_r13(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2138 "smarty_internal_templateparser.php"
#line 215 "smarty_internal_templateparser.y"
    function yy_r14(){
                                     $this->_retvalue = new _smarty_linebreak($this, $this->yystack[$this->yyidx + 0]->minor);
                                       }
#line 2143 "smarty_internal_templateparser.php"
#line 220 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = '';     }
#line 2146 "smarty_internal_templateparser.php"
#line 221 "smarty_internal_templateparser.y"
    function yy_r16(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2149 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2152 "smarty_internal_templateparser.php"
#line 226 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2155 "smarty_internal_templateparser.php"
#line 228 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2158 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r23(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2161 "smarty_internal_templateparser.php"
#line 231 "smarty_internal_templateparser.y"
    function yy_r24(){ $this->_retvalue = '<<?php ?>%';     }
#line 2164 "smarty_internal_templateparser.php"
#line 232 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = '%<?php ?>>';     }
#line 2167 "smarty_internal_templateparser.php"
#line 240 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2170 "smarty_internal_templateparser.php"
#line 241 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2173 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2176 "smarty_internal_templateparser.php"
#line 253 "smarty_internal_templateparser.y"
    function yy_r32(){ $this->_retvalue = $this->compiler->compileTag('assign',array('value'=>$this->yystack[$this->yyidx + -1]->minor,'var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'"));    }
#line 2179 "smarty_internal_templateparser.php"
#line 255 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor,'var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'"),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2182 "smarty_internal_templateparser.php"
#line 257 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor));    }
#line 2185 "smarty_internal_templateparser.php"
#line 260 "smarty_internal_templateparser.y"
    function yy_r38(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2188 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r39(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2191 "smarty_internal_templateparser.php"
#line 263 "smarty_internal_templateparser.y"
    function yy_r40(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2194 "smarty_internal_templateparser.php"
#line 265 "smarty_internal_templateparser.y"
    function yy_r41(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                     }
#line 2199 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r42(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor),$this->yystack[$this->yyidx + -1]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                                }
#line 2204 "smarty_internal_templateparser.php"
#line 273 "smarty_internal_templateparser.y"
    function yy_r43(){ $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2207 "smarty_internal_templateparser.php"
#line 276 "smarty_internal_templateparser.y"
    function yy_r45(){
                                                             $this->_retvalue = $this->compiler->compileTag('for',array('start'=>$this->yystack[$this->yyidx + -9]->minor,'ifexp'=>$this->yystack[$this->yyidx + -6]->minor,'varloop'=>$this->yystack[$this->yyidx + -2]->minor,'loop'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2211 "smarty_internal_templateparser.php"
#line 279 "smarty_internal_templateparser.y"
    function yy_r46(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2214 "smarty_internal_templateparser.php"
#line 280 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2217 "smarty_internal_templateparser.php"
#line 281 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge(array('start'=>$this->yystack[$this->yyidx + -4]->minor,'to'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2220 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->compiler->compileTag('for',array('start'=>$this->yystack[$this->yyidx + -5]->minor,'to'=>$this->yystack[$this->yyidx + -3]->minor,'step'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2223 "smarty_internal_templateparser.php"
#line 284 "smarty_internal_templateparser.y"
    function yy_r50(){ $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2226 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r51(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2230 "smarty_internal_templateparser.php"
#line 288 "smarty_internal_templateparser.y"
    function yy_r52(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2234 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r53(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2238 "smarty_internal_templateparser.php"
#line 292 "smarty_internal_templateparser.y"
    function yy_r54(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2242 "smarty_internal_templateparser.php"
#line 296 "smarty_internal_templateparser.y"
    function yy_r55(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2245 "smarty_internal_templateparser.php"
#line 297 "smarty_internal_templateparser.y"
    function yy_r56(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2248 "smarty_internal_templateparser.php"
#line 298 "smarty_internal_templateparser.y"
    function yy_r57(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                         $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                          }
#line 2253 "smarty_internal_templateparser.php"
#line 302 "smarty_internal_templateparser.y"
    function yy_r58(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2256 "smarty_internal_templateparser.php"
#line 308 "smarty_internal_templateparser.y"
    function yy_r59(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[key($this->yystack[$this->yyidx + 0]->minor)] = $this->yystack[$this->yyidx + 0]->minor[key($this->yystack[$this->yyidx + 0]->minor)];    }
#line 2259 "smarty_internal_templateparser.php"
#line 312 "smarty_internal_templateparser.y"
    function yy_r61(){ $this->_retvalue = array();    }
#line 2262 "smarty_internal_templateparser.php"
#line 315 "smarty_internal_templateparser.y"
    function yy_r62(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2272 "smarty_internal_templateparser.php"
#line 323 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2275 "smarty_internal_templateparser.php"
#line 326 "smarty_internal_templateparser.y"
    function yy_r66(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2278 "smarty_internal_templateparser.php"
#line 327 "smarty_internal_templateparser.y"
    function yy_r67(){$this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2281 "smarty_internal_templateparser.php"
#line 333 "smarty_internal_templateparser.y"
    function yy_r68(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2284 "smarty_internal_templateparser.php"
#line 334 "smarty_internal_templateparser.y"
    function yy_r69(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2287 "smarty_internal_templateparser.php"
#line 336 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2290 "smarty_internal_templateparser.php"
#line 345 "smarty_internal_templateparser.y"
    function yy_r72(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2293 "smarty_internal_templateparser.php"
#line 347 "smarty_internal_templateparser.y"
    function yy_r73(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2296 "smarty_internal_templateparser.php"
#line 353 "smarty_internal_templateparser.y"
    function yy_r76(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2299 "smarty_internal_templateparser.php"
#line 357 "smarty_internal_templateparser.y"
    function yy_r77(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));     }
#line 2302 "smarty_internal_templateparser.php"
#line 362 "smarty_internal_templateparser.y"
    function yy_r78(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2305 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r79(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2308 "smarty_internal_templateparser.php"
#line 364 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2311 "smarty_internal_templateparser.php"
#line 366 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2314 "smarty_internal_templateparser.php"
#line 367 "smarty_internal_templateparser.y"
    function yy_r83(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2317 "smarty_internal_templateparser.php"
#line 368 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2320 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r85(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2323 "smarty_internal_templateparser.php"
#line 370 "smarty_internal_templateparser.y"
    function yy_r86(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2326 "smarty_internal_templateparser.php"
#line 371 "smarty_internal_templateparser.y"
    function yy_r87(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2329 "smarty_internal_templateparser.php"
#line 377 "smarty_internal_templateparser.y"
    function yy_r93(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2332 "smarty_internal_templateparser.php"
#line 383 "smarty_internal_templateparser.y"
    function yy_r94(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2335 "smarty_internal_templateparser.php"
#line 390 "smarty_internal_templateparser.y"
    function yy_r97(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2338 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r102(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2341 "smarty_internal_templateparser.php"
#line 397 "smarty_internal_templateparser.y"
    function yy_r103(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';     }
#line 2344 "smarty_internal_templateparser.php"
#line 398 "smarty_internal_templateparser.y"
    function yy_r104(){ $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2347 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r105(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2357 "smarty_internal_templateparser.php"
#line 411 "smarty_internal_templateparser.y"
    function yy_r107(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2360 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r110(){if ((!$this->template->security || $this->smarty->security_handler->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
                      																				   if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
                                                                  $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
                      																				   } else {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
                                                                 } 
                                                                } else {
                                                                 $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
                                                                }
                                                                   }
#line 2372 "smarty_internal_templateparser.php"
#line 427 "smarty_internal_templateparser.y"
    function yy_r111(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2376 "smarty_internal_templateparser.php"
#line 430 "smarty_internal_templateparser.y"
    function yy_r112(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2379 "smarty_internal_templateparser.php"
#line 439 "smarty_internal_templateparser.y"
    function yy_r113(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
                                      } else {
                                      if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         } else {
                                          $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         }
                                       $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2389 "smarty_internal_templateparser.php"
#line 448 "smarty_internal_templateparser.y"
    function yy_r114(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2397 "smarty_internal_templateparser.php"
#line 457 "smarty_internal_templateparser.y"
    function yy_r116(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2400 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r117(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2403 "smarty_internal_templateparser.php"
#line 461 "smarty_internal_templateparser.y"
    function yy_r118(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2406 "smarty_internal_templateparser.php"
#line 467 "smarty_internal_templateparser.y"
    function yy_r119(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2409 "smarty_internal_templateparser.php"
#line 469 "smarty_internal_templateparser.y"
    function yy_r120(){return;    }
#line 2412 "smarty_internal_templateparser.php"
#line 473 "smarty_internal_templateparser.y"
    function yy_r121(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2415 "smarty_internal_templateparser.php"
#line 474 "smarty_internal_templateparser.y"
    function yy_r122(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2418 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r123(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2421 "smarty_internal_templateparser.php"
#line 476 "smarty_internal_templateparser.y"
    function yy_r124(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2424 "smarty_internal_templateparser.php"
#line 477 "smarty_internal_templateparser.y"
    function yy_r125(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2427 "smarty_internal_templateparser.php"
#line 479 "smarty_internal_templateparser.y"
    function yy_r126(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2430 "smarty_internal_templateparser.php"
#line 480 "smarty_internal_templateparser.y"
    function yy_r127(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2433 "smarty_internal_templateparser.php"
#line 484 "smarty_internal_templateparser.y"
    function yy_r129(){$this->_retvalue = '[]';    }
#line 2436 "smarty_internal_templateparser.php"
#line 492 "smarty_internal_templateparser.y"
    function yy_r131(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2439 "smarty_internal_templateparser.php"
#line 494 "smarty_internal_templateparser.y"
    function yy_r132(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2442 "smarty_internal_templateparser.php"
#line 496 "smarty_internal_templateparser.y"
    function yy_r133(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2445 "smarty_internal_templateparser.php"
#line 501 "smarty_internal_templateparser.y"
    function yy_r134(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2449 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r135(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2452 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r136(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2455 "smarty_internal_templateparser.php"
#line 508 "smarty_internal_templateparser.y"
    function yy_r137(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2458 "smarty_internal_templateparser.php"
#line 509 "smarty_internal_templateparser.y"
    function yy_r138(){ $this->_retvalue = '->{$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor .')->value'.$this->yystack[$this->yyidx + 0]->minor.'}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor,"'"), null, true, false)->nocache;    }
#line 2461 "smarty_internal_templateparser.php"
#line 510 "smarty_internal_templateparser.y"
    function yy_r139(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2464 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r140(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2467 "smarty_internal_templateparser.php"
#line 513 "smarty_internal_templateparser.y"
    function yy_r141(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2470 "smarty_internal_templateparser.php"
#line 519 "smarty_internal_templateparser.y"
    function yy_r142(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2479 "smarty_internal_templateparser.php"
#line 530 "smarty_internal_templateparser.y"
    function yy_r143(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2482 "smarty_internal_templateparser.php"
#line 531 "smarty_internal_templateparser.y"
    function yy_r144(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2485 "smarty_internal_templateparser.php"
#line 535 "smarty_internal_templateparser.y"
    function yy_r145(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2488 "smarty_internal_templateparser.php"
#line 539 "smarty_internal_templateparser.y"
    function yy_r147(){ return;    }
#line 2491 "smarty_internal_templateparser.php"
#line 544 "smarty_internal_templateparser.y"
    function yy_r148(){$this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor));    }
#line 2494 "smarty_internal_templateparser.php"
#line 545 "smarty_internal_templateparser.y"
    function yy_r149(){$this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor);    }
#line 2497 "smarty_internal_templateparser.php"
#line 548 "smarty_internal_templateparser.y"
    function yy_r151(){ $this->_retvalue =  $this->yystack[$this->yyidx + 0]->minor;    }
#line 2500 "smarty_internal_templateparser.php"
#line 553 "smarty_internal_templateparser.y"
    function yy_r152(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2503 "smarty_internal_templateparser.php"
#line 555 "smarty_internal_templateparser.y"
    function yy_r153(){$this->_retvalue = '';    }
#line 2506 "smarty_internal_templateparser.php"
#line 557 "smarty_internal_templateparser.y"
    function yy_r154(){$this->_retvalue = ':'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2509 "smarty_internal_templateparser.php"
#line 567 "smarty_internal_templateparser.y"
    function yy_r159(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2512 "smarty_internal_templateparser.php"
#line 569 "smarty_internal_templateparser.y"
    function yy_r160(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2515 "smarty_internal_templateparser.php"
#line 578 "smarty_internal_templateparser.y"
    function yy_r161(){$this->_retvalue = '==';    }
#line 2518 "smarty_internal_templateparser.php"
#line 579 "smarty_internal_templateparser.y"
    function yy_r162(){$this->_retvalue = '!=';    }
#line 2521 "smarty_internal_templateparser.php"
#line 580 "smarty_internal_templateparser.y"
    function yy_r163(){$this->_retvalue = '>';    }
#line 2524 "smarty_internal_templateparser.php"
#line 581 "smarty_internal_templateparser.y"
    function yy_r164(){$this->_retvalue = '<';    }
#line 2527 "smarty_internal_templateparser.php"
#line 582 "smarty_internal_templateparser.y"
    function yy_r165(){$this->_retvalue = '>=';    }
#line 2530 "smarty_internal_templateparser.php"
#line 583 "smarty_internal_templateparser.y"
    function yy_r166(){$this->_retvalue = '<=';    }
#line 2533 "smarty_internal_templateparser.php"
#line 584 "smarty_internal_templateparser.y"
    function yy_r167(){$this->_retvalue = '===';    }
#line 2536 "smarty_internal_templateparser.php"
#line 585 "smarty_internal_templateparser.y"
    function yy_r168(){$this->_retvalue = '!==';    }
#line 2539 "smarty_internal_templateparser.php"
#line 586 "smarty_internal_templateparser.y"
    function yy_r169(){$this->_retvalue = '%';    }
#line 2542 "smarty_internal_templateparser.php"
#line 588 "smarty_internal_templateparser.y"
    function yy_r170(){$this->_retvalue = '&&';    }
#line 2545 "smarty_internal_templateparser.php"
#line 589 "smarty_internal_templateparser.y"
    function yy_r171(){$this->_retvalue = '||';    }
#line 2548 "smarty_internal_templateparser.php"
#line 590 "smarty_internal_templateparser.y"
    function yy_r172(){$this->_retvalue = ' XOR ';    }
#line 2551 "smarty_internal_templateparser.php"
#line 595 "smarty_internal_templateparser.y"
    function yy_r173(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2554 "smarty_internal_templateparser.php"
#line 597 "smarty_internal_templateparser.y"
    function yy_r175(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2557 "smarty_internal_templateparser.php"
#line 598 "smarty_internal_templateparser.y"
    function yy_r176(){ return;     }
#line 2560 "smarty_internal_templateparser.php"
#line 599 "smarty_internal_templateparser.y"
    function yy_r177(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2563 "smarty_internal_templateparser.php"
#line 600 "smarty_internal_templateparser.y"
    function yy_r178(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2566 "smarty_internal_templateparser.php"
#line 607 "smarty_internal_templateparser.y"
    function yy_r180(){ $this->_retvalue = "''";     }
#line 2569 "smarty_internal_templateparser.php"
#line 608 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2572 "smarty_internal_templateparser.php"
#line 610 "smarty_internal_templateparser.y"
    function yy_r182(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2575 "smarty_internal_templateparser.php"
#line 611 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2578 "smarty_internal_templateparser.php"
#line 613 "smarty_internal_templateparser.y"
    function yy_r184(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2581 "smarty_internal_templateparser.php"
#line 615 "smarty_internal_templateparser.y"
    function yy_r186(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2590 "smarty_internal_templateparser.php"
#line 623 "smarty_internal_templateparser.y"
    function yy_r188(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2593 "smarty_internal_templateparser.php"
#line 624 "smarty_internal_templateparser.y"
    function yy_r189(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2598 "smarty_internal_templateparser.php"
#line 627 "smarty_internal_templateparser.y"
    function yy_r190(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2601 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 75 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2664 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 67 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2682 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>