<?php
/**********************************************
  DF Weather Module for CPG-NUKE 9.2.x
 **********************************************
  Copyright (c) 2006-08

  $Revision: 3.0.00 $
  $Author: BrokenCrust $
  $Date: 2008/06/23 $

***********************************************/
if (!defined('CPG_NUKE')) die('Access Denied');

$pagetitle .= _DFW;

$modheader .= '<link rel="stylesheet" type="text/css" href="themes/'.$CPG_SESS['theme'].'/style/df_weather.css" />';

require_once( "header.php" );

require_once( "modules/DF_Weather/class.weather.inc" );

global $prefix, $db, $userinfo, $user_prefix, $MAIN_CFG, $modheader;

$cid = intval($_GET['cid']);

if ($cid != 0) {
	if (is_user()) {
		$result = $db->sql_query("UPDATE ".$user_prefix."_users SET weather_city=".$cid." WHERE user_id = ".$userinfo['user_id']);
	}
	$city = $db->sql_fetchrow($db->sql_query("SELECT name, code, state FROM ".$prefix."_weather WHERE cid = ".$cid));
} else {
	if ((is_user()) AND (($userinfo['weather_city'] != 0))) {
		$city = $db->sql_fetchrow($db->sql_query("SELECT cid, name, code, state FROM ".$prefix."_weather WHERE cid = ".$userinfo['weather_city']));
	} else {
		$city = $db->sql_fetchrow($db->sql_query("SELECT cid, name, code, state FROM ".$prefix."_weather WHERE cid = ".$MAIN_CFG['df_weather']['default_city']));
	}
	$cid = $city['cid'];
}

$DFW = new dragonfly_weather($cid, $city['name'], $city['state'], $city['code'], $MAIN_CFG['df_weather']['cache_interval'], $MAIN_CFG['df_weather']['use_curl']);

$current = Cache::array_load('current_'.$cid,'DF_Weather', false);

$forecast = Cache::array_load('forecast_'.$cid,'DF_Weather', false);

$cpgtpl->assign_vars(array(
	'C_SHOW_CURRENT'  => $MAIN_CFG['df_weather']['show_current'] == 1 ? 1 : '',
	'C_SHOW_FORECAST' => $MAIN_CFG['df_weather']['show_forecast'] == 1 ? 1 : '',
	'C_SHOW_MORE'     => $MAIN_CFG['df_weather']['show_more'] == 1 ? 1 : '',
	'C_CURRENT'       => count($current['measures']) > 0 ? 1 : '',
	'C_FORECAST'      => count($forecast['period']) > 0 ? 1 : '',
	'C_USA'           => $city['code'] == 000000 ? 1 : '',
	'L_CITY'          => $DFW->city_list($cid),
	'N_CITY'          => 'code',
	'U_MORE'          => $DFW->get_more_url(),
	'V_NAME'          => str_replace("_"," ", $city['name']),
	'V_CODE'          => $city['code'],
	'V_STATE'         => $city['state']
));


if (count($current['measures']) > 0) {
	foreach ($current['measures'] as $i => $value) {
		$cpgtpl->assign_block_vars('measures', array(
			'W_MEASURE' => $current['measures'][$i]
		));
	}
	foreach ($current['datum'] as $i => $value) {
		$cpgtpl->assign_block_vars('data', array(
			'W_DATUM' => $current['datum'][$i]
		));
	}
}

if ($city['code'] == 000000) {
	if (count($forecast['period']) > 0) {
		foreach ($forecast['period'] as $i => $value) {
			$cpgtpl->assign_block_vars('periods', array(
				'W_PERIOD' => $forecast['period'][$i],
				'W_COND'   => $forecast['conditions'][$i]
			));
		}
	}
} else {
	if (count($forecast['period']) > 0) {
		foreach ($forecast['period'] as $i => $value) {
			$cpgtpl->assign_block_vars('periods', array(
				'W_PERIOD' => $forecast['period'][$i]
			));
		}
		foreach ($forecast['conditions'] as $i => $value) {
			$cpgtpl->assign_block_vars('forecast', array(
				'I_COND'  => $DFW->get_condition_image($forecast['conditions'][$i]),
				'W_COND'  => $forecast['conditions'][$i],
				'W_TEMP'  => $forecast['temperature'][$i],
				'W_CLASS' => $forecast['class'][$i]
			));
		}
	}
}

OpenTable();

$cpgtpl->set_filenames(array('forecast' => 'df_weather/forecast.html'));

$cpgtpl->display('forecast');

CloseTable();

?>
