<?php
/**********************************************
  DF Weather Module for CPG-NUKE 9.2.x
 **********************************************
  Copyright (c) 2006-08

  $Revision: 3.0.00 $
  $Author: BrokenCrust $
  $Date: 2008/06/23 $

***********************************************/
if (!defined('ADMIN_MOD_INSTALL')) { exit; }

class DF_Weather {
	var $radmin;
	var $version;
	var $modname;
	var $description;
	var $author;
	var $website;
	var $dbtables;

	// class constructor
	function DF_Weather() {
		$this->radmin = true;
		$this->version = '3.0';
		$this->modname = 'DF Weather';
		$this->description = 'View current weather conditions from a list of cities around the world.';
		$this->author = 'BrokenCrust';
		$this->website = 'www.brokencrust.eu';
		$this->dbtables = array('weather');
	}

	// module installer
	function install() {
		global $installer;

		$installer->add_query('CREATE', 'weather', "
			cid INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
			code INT(5) ZEROFILL UNSIGNED NOT NULL,
			state VARCHAR(2) NOT NULL,
			name VARCHAR(40) NOT NULL,
			PRIMARY KEY (cid)", 'weather');

		// Add a few starter cities
		$installer->add_query('INSERT', 'weather', 'NULL, 07157, "ZZ", "Paris"');
		$installer->add_query('INSERT', 'weather', 'NULL, 03717, "ZZ", "Cardiff"');
		$installer->add_query('INSERT', 'weather', 'NULL, 01026, "ZZ", "Tromso"');
		$installer->add_query('INSERT', 'weather', 'NULL, 40080, "ZZ", "Damascus"');
		$installer->add_query('INSERT', 'weather', 'NULL, 00000, "NY", "New_York"');

		// Add the config to the config_custom table
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'show_current', 1");
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'show_forecast', 1");
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'show_more', 1");
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'block_type', 1");
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'cache_interval', 8");
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'default_city', 4");
		$installer->add_query('INSERT', 'config_custom', "'df_weather', 'use_curl', 1");

		//Add columns to users table
		$installer->add_query('ADD', 'users', 'weather_city INT(11) UNSIGNED NOT NULL DEFAULT "0"');

		return true;
	}

	// module uninstaller
	function uninstall() {
		global $installer;

		$installer->add_query('DROP', 'weather');
		$installer->add_query('DELETE', 'config_custom', "cfg_name='df_weather'");
		$installer->add_query('DEL', 'users', 'weather_city');

		return true;
	}

	// module upgrader
	function upgrade($prev_version) {
		global $installer, $db, $prefix;

		if ($prev_version < 3.0) {

			// Move the config settings to the custom config table
			$weather_config = $db->sql_fetchrow($db->sql_query("SELECT * FROM ".$prefix."_weather_config"));
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'show_current', ".$weather_config['show_current']);
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'show_forecast', ".$weather_config['show_forecast']);
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'show_more', ".$weather_config['show_more']);
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'block_type', ".$weather_config['block_type']);
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'cache_interval', 8");
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'default_city', ".$weather_config['default_city']);
			$installer->add_query('INSERT', 'config_custom', "'df_weather', 'use_curl', 1");

			// Drop the weather_config table
			$installer->add_query('DROP', 'weather_config');
		}

		return true;
	}
}

?>
