<?php
/**********************************************
  DF Weather Module for CPG-NUKE 9.2.x
 **********************************************
  Copyright (c) 2006-08

  $Revision: 3.0.00 $
  $Author: BrokenCrust $
  $Date: 2008/06/23 $

***********************************************/

class dragonfly_weather {

	protected $cid;
	protected $name;
	protected $state;
	protected $code;
	protected $xml;
	protected $cache_interval;
	protected $curl;

	public function __construct($cid, $name, $state, $code, $cache_interval, $curl) {

		$this->cid = $cid;
		$this->name = $name;
		$this->state = $state;
		$this->code = $code;
		$this->cache_interval = $cache_interval * 3600;
		$this->curl = $curl;

		$this->cache_data();
	}

	public function get_more_url() {

		if ($this->code == 00000) {
			$url = 'http://www.wunderground.com/US/'.$this->state.'/'.$this->name.'.html';
		} else {
			$url = 'http://www.wunderground.com/global/stations/'.$this->code.'.html';
		}
		return $url;
	}

	public function city_list($cid) {
		global $db, $prefix;

		$cities = $db->sql_query("SELECT cid, code, name FROM ".$prefix."_weather ORDER BY name ASC");

		$citylist = '';

		if ($db->sql_numrows($cities) > 0) {
			while ($city = $db->sql_fetchrow($cities)) {
				if ($city['cid'] == $cid) {
					 $citylist .= '<option selected="selected" value="'.getlink('DF_Weather&amp;cid='.$city['cid']).'">'.str_replace("_"," ", $city['name']).'</option>';
				} else {
					 $citylist .= '<option value="'.getlink('DF_Weather&amp;cid='.$city['cid']).'">'.str_replace("_"," ", $city['name']).'</option>';
				}
			}
		}
		return($citylist);
	}

	public function get_condition_image($condition) {

		switch($condition) {

			case 'Clear':
			$image = 'modules/DF_Weather/images/0.gif';
			break;

			case 'Partly Cloudy':
			case 'Scattered Clouds':
			$image = 'modules/DF_Weather/images/1.gif';
			break;

			case 'Mostly Cloudy':
			$image = 'modules/DF_Weather/images/2.gif';
			break;

			case 'Overcast':
			$image = 'modules/DF_Weather/images/3.gif';
			break;

			case 'Light Rain':
			$image = 'modules/DF_Weather/images/4.gif';
			break;

			case 'Rain':
			$image = 'modules/DF_Weather/images/5.gif';
			break;

			case 'Sleet':
			$image = 'modules/DF_Weather/images/6.gif';
			break;

			case 'Snow':
			$image = 'modules/DF_Weather/images/7.gif';
			break;

			case 'Hail':
			$image = 'modules/DF_Weather/images/8.gif';
			break;

			case 'T-storms':
			case 'Thunderstorms':
			case 'Light Thunderstorm Rain':
			$image = 'modules/DF_Weather/images/9.gif';
			break;

			case 'Blizzard':
			$image = 'modules/DF_Weather/images/10.gif';
			break;

			case 'Haze':
			$image = 'modules/DF_Weather/images/11.gif';
			break;

			case 'Chance of Rain':
			$image = 'modules/DF_Weather/images/12.gif';
			break;

			case 'Chance of Sleet':
			$image = 'modules/DF_Weather/images/13.gif';
			break;

			case 'Chance of Hail':
			$image = 'modules/DF_Weather/images/14.gif';
			break;

			case 'Chance of Snow':
			$image = 'modules/DF_Weather/images/15.gif';
			break;

			case 'Chance of T-storms':
			case 'Chance of Thunderstorms':
			$image = 'modules/DF_Weather/images/16.gif';
			break;

			case 'Mist':
			$image = 'modules/DF_Weather/images/17.gif';
			break;

			case 'Fog':
			case 'Light Fog':
			case 'Heavy Fog':
			case 'Smoke':
			$image = 'modules/DF_Weather/images/18.gif';
			break;

			case 'Light Snow':
			$image = 'modules/DF_Weather/images/19.gif';
			break;

			case 'Sand Storm':
			case 'Blowing Sand':
			$image = 'modules/DF_Weather/images/20.gif';
			break;

			case 'Light Drizzle':
			case 'Light Rain Showers':
			case 'Light Rain Mist':
			$image = 'modules/DF_Weather/images/21.gif';
			break;
		}
		return $image;
	}

	public function get_temperature_class($temperature, $style=false) {

		preg_match("/\/ (.*)C/isU", $temperature, $temp);

		if ($style) {
			$class = $this->colour_style($temp[1]);
		} else {
			$class = $this->colour_class($temp[1]);
		}

		return $class;
	}

	private function open_page() {

		if ($this->code == 00000) {
			$openfile = 'http://rss.wunderground.com/auto/rss_full/'.$this->state.'/'.$this->name.'.xml';
		} else {
			$openfile = 'http://rss.wunderground.com/auto/rss_full/global/stations/'.$this->code.'.xml';
		}

		if ($this->curl) {
			$file = curl_init();
			$timeout = 30;
			curl_setopt ($file, CURLOPT_URL, $openfile);
			curl_setopt ($file, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($file, CURLOPT_CONNECTTIMEOUT, $timeout);
			$data = curl_exec($file);
			curl_close($file);
		} else {
			$data = @implode ('', file($openfile));
		}

		return($data);
	}

	private function load_xml() {

		$xml = $this->open_page($this->name, $this->state, $this->code);

		if (!$xml) {
			$this->xml = false;
		} else {
			$xml = str_replace('<title>Weather Underground</title>', '', $xml);
			$this->xml = $this->language_decode($xml);
		}
	}

	private function cache_data() {

		$recache = false;
		$current = Cache::array_load('current_'.$this->cid, 'DF_Weather', false);
		$forecast = Cache::array_load('forecast_'.$this->cid, 'DF_Weather', false);

		if (($current) || ($forecast)) {
			$cache_file = 'cache/DF_Weather_current_'.$this->cid.'.php';
			if (file_exists($cache_file)) {
				$recache_time = filemtime($cache_file) + $this->cache_interval;
				if ($recache_time < time()) {
					$recache = true;
				}
			}
		} else {
			$recache = true;
		}
		if ($recache) {
			$this->load_xml();
			if ($this->xml) {
				$data = $this->get_current_data($this->xml);
				$data = $this->get_forecast_data($this->xml);
			}
		}
	}

	private function get_current_data($xml) {

		preg_match_all("/<description>(.*)<\/description>/isU", $xml, $cc);

		$current = $this->clean_data($cc[1][1]);
		$current_data = array('measures' => array(), 'datum' => array());

		if (strpos($current, '|')) {
			$conditions = explode('|', $current);
			foreach ($conditions as $i => $value) {
				$cond = explode(':', $conditions[$i], 2);
				$current_data['measures'][] = $cond[0];
				$current_data['datum'][] = $cond[1];
			}
		} else {
			$current = str_replace('High', '', $current);
			$current = str_replace('Low', '', $current);
			$current = $this->clean_data($current);
			$cond = explode(':', $current);
			$current_data['measures'][0] = 'Temperature';
			$current_data['datum'][0] = str_replace('.', '', $cond[1]);
			$current_data['measures'][1] = 'Conditions';
			$current_data['datum'][1] = trim($cond[0], '. ');
		}
		Cache::array_save('current_'.$this->cid, 'DF_Weather', $current_data);
	}

	private function get_forecast_data($xml) {

		preg_match_all("/<title>(.*)<\/title>/isU", $xml, $title);
		preg_match_all("/<description>(.*)<\/description>/isU", $xml, $desc);

		$forecast_data = array('period' => array(), 'conditions' => array());

		if (strpos($desc[1][1], '|')) {
			$first = 2;
		} else {
			$first = 1;
		}
		$last = count($desc[1]);
		for ($p = $first; $p < $last; $p++) {
			if ($this->code == 00000) {
				$data = $this->clean_data($desc[1][$p]);
				$forecast = explode(' - ', $data, 2);
				$forecast_data['period'][] = $forecast[0];
				$forecast_data['conditions'][] = $forecast[1];
			} else {
				$forecast_data['period'][] = $this->clean_title($title[1][$p]);
				$data = $this->clean_data($desc[1][$p]);
				$data = str_replace('High', '', $data);
				$data = str_replace('Low', '', $data);
				$forecast = explode(':', $data);
				$forecast_data['conditions'][] = trim($forecast[0], '. ');
				$forecast_data['temperature'][] = str_replace('.', '', $forecast[1]);
				$forecast_data['class'][] = $this->get_temperature_class($forecast[1]);
			}
		}
		Cache::array_save('forecast_'.$this->cid, 'DF_Weather', $forecast_data);
	}

	private function colour_class($temp) {

		if ($temp < -20) {
			$class = 'freezing';
		} elseif (($temp >= -20) AND ($temp < -10)){
			$class = 'verycold';
		} elseif (($temp >= -10) AND ($temp < 0)){
			$class = 'cold';
		} elseif (($temp >= 0) AND ($temp < 10)){
			$class = 'cool';
		} elseif (($temp >= 10) AND ($temp < 20)){
			$class = 'mild';
		} elseif (($temp >= 20) AND ($temp < 30)){
			$class = 'warm';
		} elseif (($temp >= 30) AND ($temp < 40)){
			$class = 'hot';
		} elseif (($temp >= 40) AND ($temp < 50)){
			$class = 'veryhot';
		} elseif ($temp >= 50){
			$class = 'boiling';
		}
		return($class);
	}

	private function colour_style($temp) {

		if ($temp < -20) {
			$style = 'text-align: center; color: #000000; background-color: #0033CC;';
		} elseif (($temp >= -20) AND ($temp < -10)){
			$style = 'text-align: center; color: #000000; background-color: #0066FF;';
		} elseif (($temp >= -10) AND ($temp < 0)){
			$style = 'text-align: center; color: #000000; background-color: #3366FF;';
		} elseif (($temp >= 0) AND ($temp < 10)){
			$style = 'text-align: center; color: #000000; background-color: #66FFFF;';
		} elseif (($temp >= 10) AND ($temp < 20)){
			$style = 'text-align: center; color: #000000; background-color: #66FF66;';
		} elseif (($temp >= 20) AND ($temp < 30)){
			$style = 'text-align: center; color: #000000; background-color: #66CC33;';
		} elseif (($temp >= 30) AND ($temp < 40)){
			$style = 'text-align: center; color: #000000; background-color: #FF6633;';
		} elseif (($temp >= 40) AND ($temp < 50)){
			$style = 'text-align: center; color: #000000; background-color: #FF3333;';
		} elseif ($temp >= 50){
			$style = 'text-align: center; color: #000000; background-color: #FF0000;';
		}
		return($style);
	}

	private function clean_title($title) {
		$title = str_replace('Forecast for ', '', $title);
		$title = preg_replace('/as of(.*)T/isU', '', $title);
		return($title);
	}

	private function clean_data($data) {
		$data = str_replace('#176', 'deg', $data);
		$data = str_replace('<![CDATA[', '', $data);
		$data = str_replace(']]>', '', $data);
		$data = str_replace('amp;', '', $data);
		$data = str_replace(' &deg; ', '&deg;', $data);
		return($data);
	}

	private function language_decode($xml) {

		// Days
		$xml = str_replace("Monday", _DFW_MON, $xml);
		$xml = str_replace("Tuesday", _DFW_TUE, $xml);
		$xml = str_replace("Wednesday", _DFW_WED, $xml);
		$xml = str_replace("Thursday", _DFW_THU, $xml);
		$xml = str_replace("Friday", _DFW_FRI, $xml);
		$xml = str_replace("Saturday", _DFW_SAT, $xml);
		$xml = str_replace("Sunday", _DFW_SUN, $xml);

		// Times
		$xml = str_replace("Today", _DFW_TODAY, $xml);
		$xml = str_replace("Tomorrow", _DFW_TOMORROW, $xml);
		$xml = str_replace("Day", _DFW_DAY, $xml);
		$xml = str_replace("Night", _DFW_NIGHT, $xml);
		$xml = str_replace("AM", _DFW_AM, $xml);
		$xml = str_replace("PM", _DFW_PM, $xml);

		// Measures
		$xml = str_replace("Temperature", _DFW_TEMPERATURE, $xml);
		$xml = str_replace("Humidity", _DFW_HUMIDITY, $xml);
		$xml = str_replace("Pressure", _DFW_PRESSURE, $xml);
		$xml = str_replace("Conditions", _DFW_CONDITIONS, $xml);
		$xml = str_replace("Wind Direction", _DFW_DIRECTION, $xml);
		$xml = str_replace("Wind Speed", _DFW_SPEED, $xml);
		$xml = str_replace("Updated", _DFW_UPDATED, $xml);

		// Conditions
		$xml = str_replace("Rain", _DFW_RAIN, $xml);
		$xml = str_replace("Clear", _DFW_CLEAR, $xml);
		$xml = str_replace("Sunny", _DFW_SUNNY, $xml);
		$xml = str_replace("Fair", _DFW_FAIR, $xml);
		$xml = str_replace("Showers", _DFW_SHOWERS, $xml);
		$xml = str_replace("Haze", _DFW_HAZE, $xml);
		$xml = str_replace("Drizzle", _DFW_DRIZZLE, $xml);
		$xml = str_replace("Thunder", _DFW_THUNDER, $xml);
		$xml = str_replace("Thunderstorms", _DFW_THUNDERSTORMS, $xml);
		$xml = str_replace("Light Thunderstorm Rain", _DFW_THUNDERSTORMS, $xml);
		$xml = str_replace("T-storms", _DFW_THUNDERSTORMS, $xml);
		$xml = str_replace("Snow", _DFW_SNOW, $xml);
		$xml = str_replace("Clouds", _DFW_CLOUDS, $xml);
		$xml = str_replace("Cloudy", _DFW_CLOUDY, $xml);
		$xml = str_replace("Fog", _DFW_FOG, $xml);
		$xml = str_replace("Mist", _DFW_MIST, $xml);
		$xml = str_replace("Blizzard", _DFW_BLIZZARD, $xml);
		$xml = str_replace("Hail", _DFW_HAIL, $xml);
		$xml = str_replace("Sleet", _DFW_SLEET, $xml);
		$xml = str_replace("Blowing Sand", _DFW_SAND, $xml);
		$xml = str_replace("Sand Storm", _DFW_SAND, $xml);

		// Condition Qualifiers
		$xml = str_replace("Mostly", _DFW_MOSTLY, $xml);
		$xml = str_replace("Light", _DFW_LIGHT, $xml);
		$xml = str_replace("Heavy", _DFW_HEAVY, $xml);
		$xml = str_replace("Partly", _DFW_PARTLY, $xml);
		$xml = str_replace("Scattered", _DFW_SCATTERED, $xml);
		$xml = str_replace("Isolated", _DFW_ISOLATED, $xml);

		// Direction
		$xml = str_replace("Calm", _DFW_CALM, $xml);
		$xml = str_replace("North", _DFW_NORTH, $xml);
		$xml = str_replace("East", _DFW_EAST, $xml);
		$xml = str_replace("South", _DFW_SOUTH, $xml);
		$xml = str_replace("West", _DFW_WEST, $xml);

		// Missing Data
		$xml = str_replace('-9999mph / -9999km/h', _DFW_UNKNOWN, $xml);
		$xml = str_replace('-999%', _DFW_UNKNOWN, $xml);
		$xml = str_replace("Unavailable", _DFW_UNAVAILABLE, $xml);

		return($xml);
	}
}

?>
