<?php
/**********************************************
  DF Weather Module for CPG-NUKE 9.2.x
 **********************************************
  Copyright (c) 2006-08

  $Revision: 3.0.00 $
  $Author: BrokenCrust $
  $Date: 2008/06/23 $

***********************************************/
if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin('DF_Weather')) { die('Access Denied'); }

$pagetitle .= ' '._BC_DELIM.' <a href="'.adminlink("").'">'._DFW.'</a>';

function cities() {
	global $prefix, $db, $pagetitle, $MAIN_CFG;

	$pagetitle .= ' '._BC_DELIM.' '._DFW_CITIES;

	require_once('header.php');

	GraphicAdmin('_AMENU5');

	$cities = $db->sql_query("SELECT cid, name, state, code FROM ".$prefix."_weather ORDER BY name ASC");

	$cpgtpl->assign_vars(array(
		'C_CITIES' => $db->sql_numrows($cities) > 0 ? 1 : '',
		'U_ADD'    => adminlink('&amp;mode=add_city'),
	));

	if ($db->sql_numrows($cities) > 0) {
		$class = 1;
		while ($city = $db->sql_fetchrow($cities)) {
			$cpgtpl->assign_block_vars('cities', array(
				'W_NAME'    => str_replace("_"," ", $city['name']),
				'W_STATE'   => $city['state'],
				'W_STATE'   => $city['state'] == 'ZZ' ? '' : $city['state'],
				'W_CODE'    => $city['code'] == 00000 ? '' : $city['code'],
				'W_DEFAULT' => $city['cid'] == $MAIN_CFG['df_weather']['default_city'] ? 1 : '',
				'F_CLASS'   => ($class == 1 ? 'row1' : 'row2'),
				'U_NAME'    => getlink('DF_Weather&amp;cid='.$city['cid']),
				'U_DEFAULT' => adminlink('&amp;mode=default_city&amp;cid='.$city['cid']),
				'U_EDIT'    => adminlink('&amp;mode=edit_city&amp;cid='.$city['cid']),
				'U_DELETE'  => adminlink('&amp;mode=delete_city&amp;cid='.$city['cid']),
				'U_REMOVE'  => adminlink('&amp;mode=remove_cache&amp;cid='.$city['cid'])
			));
			if ($class == 1) {
				$class = 2;
			} else {
				$class = 1;
			}
		}
	}

	OpenTable();

	tabs();

	$cpgtpl->set_filenames(array('cities' => 'df_weather/admin/cities.html'));

	$cpgtpl->display('cities');

	CloseTable();
}

function config() {
	global $prefix, $db, $MAIN_CFG, $pagetitle;

	$pagetitle .= ' '._BC_DELIM.' '._DFW_CONFIG_SET;

	require_once('header.php');

	require_once('modules/DF_Weather/admin/admin_lists.inc');

	GraphicAdmin('_AMENU5');

	$cpgtpl->assign_vars(array(
	  'C_SHOWGENERAL'  => $MAIN_CFG['df_weather']['show_current'] == 1 ? 1 : '',
	  'C_SHOWFORECAST' => $MAIN_CFG['df_weather']['show_forecast'] == 1 ? 1 : '',
	  'C_SHOWLINK'     => $MAIN_CFG['df_weather']['show_more'] == 1 ? 1 : '',
	  'C_SHOWDETAIL'   => $MAIN_CFG['df_weather']['block_type'] == 1 ? 1 : '',
	  'C_CURL'         => $MAIN_CFG['df_weather']['use_curl'] == 1 ? 1 : '',
		'L_HOUR'         => hour_list($MAIN_CFG['df_weather']['cache_interval']),
		'N_SHOWGENERAL'  => 'show_current',
		'N_SHOWFORECAST' => 'show_forecast',
		'N_SHOWLINK'     => 'show_more',
		'N_SHOWDETAIL'   => 'block_type',
		'N_CURL'         => 'use_curl',
		'N_HOUR'         => 'cache_interval',
		'U_CONFIG'       => adminlink('&amp;mode=config_settings')
	));

	OpenTable();

	tabs();

	$cpgtpl->set_filenames(array('config' => 'df_weather/admin/config.html'));

	$cpgtpl->display('config');

	CloseTable();
}

function config_settings($show_current, $show_forecast, $show_more, $block_type, $cache_interval, $use_curl) {
	global $prefix, $db;

	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$show_current."' WHERE cfg_name='df_weather' AND cfg_field='show_current'");
	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$show_forecast."' WHERE cfg_name='df_weather' AND cfg_field='show_forecast'");
	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$show_more."' WHERE cfg_name='df_weather' AND cfg_field='show_more'");
	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$block_type."' WHERE cfg_name='df_weather' AND cfg_field='block_type'");
	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$cache_interval."' WHERE cfg_name='df_weather' AND cfg_field='cache_interval'");
	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$use_curl."' WHERE cfg_name='df_weather' AND cfg_field='use_curl'");

	Cache::array_delete('MAIN_CFG');

	url_redirect(adminlink('&amp;mode=config'));
}

function add_city() {
	global $pagetitle;

	$pagetitle .= ' '._BC_DELIM.' '._DFW_ADD_CITY;

	require_once('header.php');

	require_once('modules/DF_Weather/admin/admin_lists.inc');

	$cpgtpl->assign_vars(array(
		'L_STATE'    => state_list(''),
		'N_NAME'     => 'name',
		'N_STATE'    => 'state',
		'N_CODE'     => 'code',
		'N_ADD'      => 'addcity',
		'U_ADD_CITY' => adminlink('&mode=insert_city')
	));

	OpenTable();

	$cpgtpl->set_filenames(array('add' => 'df_weather/admin/add.html'));

	$cpgtpl->display('add');

	CloseTable();
}

function insert_city($name, $state, $code) {
	global $prefix, $db;

	if ($name == '') { cpg_error(_DFW_CITY_BLANK, _DFW); }

	if (($state == '') && ($code == '')) { cpg_error(_DFW_CODE_BLANK, _DFW); }

	if ($state != '') {
		$citycode = 00000;
	} else {
		$state = 'ZZ';
	}

	$result = $db->sql_query("INSERT INTO ".$prefix."_weather VALUES (NULL, $code, '$state', '$name')");

	url_redirect(adminlink(''));
}

function edit_city($cid) {
	global $db, $prefix, $pagetitle;

	$pagetitle .= ' '._BC_DELIM.' '._DFW_EDIT_CITY;

	require_once('header.php');

	require_once('modules/DF_Weather/admin/admin_lists.inc');

	$city = $db->sql_fetchrow($db->sql_query("SELECT name, state, code FROM ".$prefix."_weather WHERE cid=".$cid));

	$cpgtpl->assign_vars(array(
	  'V_NAME'      => $city['name'],
	  'V_CODE'      => $city['code'],
	  'V_CID'       => $cid,
		'L_STATE'     => state_list($city['state']),
		'N_NAME'      => 'name',
		'N_STATE'     => 'state',
		'N_CODE'      => 'code',
		'N_EDIT'      => 'editcity',
		'N_CID'       => 'cid',
		'U_EDIT_CITY' => adminlink('&mode=update_city')
	));

	OpenTable();

	$cpgtpl->set_filenames(array('edit' => 'df_weather/admin/edit.html'));

	$cpgtpl->display('edit');

	CloseTable();
}

function update_city($name, $state, $code, $cid) {
	global $prefix, $db;

	if ($name == '') { cpg_error(_DFW_CITY_BLANK, _DFW); }

	if (($state == '') && ($code == '')) { cpg_error(_DFW_CODE_BLANK, _DFW); }

	if ($state != '') {
		$citycode = 00000;
	} else {
		$state = 'ZZ';
	}

	$result = $db->sql_query("UPDATE ".$prefix."_weather SET name='$name', state='$state', code=$code WHERE cid=".$cid);

	url_redirect(adminlink(''));
}

function delete_city($cid) {
	global $prefix, $db;

	$result = $db->sql_query("DELETE FROM ".$prefix."_weather WHERE cid=".$cid);

	url_redirect(adminlink(''));
}

function default_city($cid) {
	global $prefix, $db;

	$result = $db->sql_query("UPDATE ".$prefix."_config_custom SET cfg_value='".$cid."' WHERE cfg_name='df_weather' AND cfg_field='default_city'");

	Cache::array_delete('MAIN_CFG');

	url_redirect(adminlink(''));
}

function remove_cache($cid) {

	Cache::array_delete('current_'.$cid,'DF_Weather');

	Cache::array_delete('forecast_'.$cid,'DF_Weather');

	cpg_error(_DFW_CACHE_REMOVED, _DFW, adminlink(''));
}


function tabs() {
	global $db, $user_prefix, $mode, $cpgtpl;

	$cpgtpl->assign_vars(array(
		'C_CITIES_TAB' => ($mode == '' || $mode == 'cities' ? 1 : 0),
		'C_CONFIG_TAB'  => ($mode == 'config' ? 1 : 0),
		'U_CITIES_TAB' => adminlink(''),
		'U_CONFIG_TAB'  => adminlink('&amp;mode=config')
	));
}

$mode = isset($_POST['mode']) ? $_POST['mode'] : (isset($_GET['mode']) ? $_GET['mode'] : '');

switch ($mode) {

	case "config":
	config();
	break;

	case "config_settings":
	config_settings(intval($_POST['show_current']), intval($_POST['show_forecast']), intval($_POST['show_more']), intval($_POST['block_type']), intval($_POST['cache_interval']), intval($_POST['use_curl']));
	break;

	case "cities":
	cities();
	break;

	case "add_city":
	add_city();
	break;

	case "insert_city":
	insert_city($_POST['name'], $_POST['state'], intval($_POST['code']));
	break;

	case "edit_city":
	edit_city(intval($_GET['cid']));
	break;

	case "update_city":
	update_city($_POST['name'], $_POST['state'], intval($_POST['code']), intval($_POST['cid']));
	break;

	case "delete_city":
	delete_city(intval($_GET['cid']));
	break;

	case "remove_cache":
	remove_cache(intval($_GET['cid']));
	break;

	case "default_city":
	default_city(intval($_GET['cid']));
	break;

	default:
	cities();
	break;
}
