<?php
/**********************************************
  DF Weather Block for CPG-NUKE 9.2.x
 **********************************************
  Copyright (c) 2006-08

  $Revision: 3.0.00 $
  $Author: BrokenCrust $
  $Date: 2008/06/23 $

***********************************************/
if (!defined('CPG_NUKE')) { exit; }

get_lang('df_weather');

if (!is_active('DF_Weather')) {
	$content = 'ERROR';
	return trigger_error('DF Weather module is inactive', E_USER_WARNING);
}

global $db, $prefix, $user_prefix, $userinfo, $cpgtpl, $MAIN_CFG;

require_once( "modules/DF_Weather/class.weather.inc" );

$usercity = $db->sql_fetchrow($db->sql_query("SELECT weather_city FROM ".$user_prefix."_users WHERE user_id = ".$userinfo['user_id']));

if ((is_user()) AND ($usercity['weather_city'] != 0)) {
	$city = $db->sql_fetchrow($db->sql_query("SELECT cid, name, state,code FROM ".$prefix."_weather WHERE cid = ".$usercity['weather_city']));
} else {
	$city = $db->sql_fetchrow($db->sql_query("SELECT cid, name, state, code FROM ".$prefix."_weather WHERE cid = ".$MAIN_CFG['df_weather']['default_city']));
}

$DFW = new dragonfly_weather($city['cid'], $city['name'], $city['state'], $city['code'], $MAIN_CFG['df_weather']['cache_interval'], $MAIN_CFG['df_weather']['use_curl']);

$current = Cache::array_load('current_'.$city['cid'],'DF_Weather', false);

$key = array_flip($current['measures']);

$cpgtpl->assign_vars(array(
	'BL_C_SHOW_DETAIL' => $MAIN_CFG['df_weather']['block_type'] == 1 ? 1 : '',
	'BL_V_NAME'        => str_replace("_"," ", $city['name']),
	'BL_I_COND'        => $DFW->get_condition_image($current['datum'][$key[_DFW_CONDITIONS]]),
	'BL_W_COND'        => $current['datum'][$key[_DFW_CONDITIONS]],
	'BL_W_TEMP'        => $current['datum'][$key[_DFW_TEMPERATURE]],
	'BL_W_CLASS'       => $DFW->get_temperature_class($current['datum'][$key[_DFW_TEMPERATURE]], true),
	'BL_U_FORECAST'    => getlink('DF_Weather&amp;cid='.$city['cid'])
));

if (count($current['measures']) > 0) {
	foreach ($current['measures'] as $i => $value) {
		$cpgtpl->assign_block_vars('bl_weather', array(
			'BL_W_MEASURE' => $current['measures'][$i] == _DFW_TEMPERATURE ? _DFW_TEMP : $current['measures'][$i],
			'BL_W_DATUM'   => $current['datum'][$i]
		));
	}
}

ob_start();

$cpgtpl->set_filenames(array('block' => 'blocks/'.str_replace('.php', '.html', basename(__FILE__))));

$cpgtpl->display('block');

$content = ob_get_clean();

$cpgtpl->unset_block('bl_weather');

?>
