<?
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

//  The latest version is always availble at http://basmaaks.xs4all.nl
//  You'll need php version 4.1.0 or above to get it all running.
//  Mail me for any questions at the_gamblers@basmaaks.xs4all.nl or post a message

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");    

// Ask for the config.php file with al the settings
require("config.php");  

// check if version is above 4.1.n or 5.n.n
if (ereg( "[4-9]\.[1-9]\.[0-9].*", phpversion() ));
	else 
		if (ereg( "[5-9]\.[0-9]\.[0-9].*", phpversion() ));
			else {echo "<html><body><form method=\"post\"><table border=\"1\" width=\"75%\" align=\"center\"><tr><td align=\"center\">This version of sysinfo requires PHP version 4.1.x or higher.<br /><br />It appears that you do not have the required version.<br /><br />This script cannot continue.  Sorry!</td></tr></table></form>";
	exit();
}

// This routine runs first. If the page is secured you can't pass the routine.
if ($securesite==true){
	function error ($error_message) {
		echo $error_message."<BR>";
		exit;
		}
	if ( (!isset($PHP_AUTH_USER)) || ! (($PHP_AUTH_USER == $loginname) && ( $PHP_AUTH_PW == "$password" )) ) {
		header("WWW-Authenticate: Basic entrer=$infotext");
		header("HTTP/1.0 401 Unauthorized");
		error("Accs non autoris...");
	}
}

// reassign HTTP variables (incase register_globals is off)
if (!empty($HTTP_GET_VARS)) while(list($name, $value) = each($HTTP_GET_VARS)) $$name = $value;
if (!empty($HTTP_POST_VARS)) while(list($name, $value) = each($HTTP_POST_VARS)) $$name = $value;

//check for a theme
if (!(isset($template) && file_exists('themes/' . $template . '.php'))) {
	$template = $defaulttheme;
	if(count($plng) > 0) {
		while(list($k,$v) = each($plng)) {
			$k = split(';', $v, 1);
            $k = split('-', $k[0]);
            if(file_exists('themes/' . $k[0] . '.php')) {
				$template = $k[0];
                break;
             }
        }
    }
}
require('themes/' . $template . '.php');

// Check for a language
if (!(isset($lng) && file_exists('languages/' . $lng . '.php'))) {
    $lng = $defaultlang;
    // see if the browser knows the right languange.
    if(isset($HTTP_ACCEPT_LANGUAGE)) {
        $plng = split(',', $HTTP_ACCEPT_LANGUAGE);
        if(count($plng) > 0) {
            while(list($k,$v) = each($plng)) {
                $k = split(';', $v, 1);
                $k = split('-', $k[0]);
                if(file_exists('languages/' . $k[0] . '.php')) {
                    $lng = $k[0];
                    break;
                }
            }
        }
    }
}
require('languages/' . $lng . '.php');

// Read the filetime of the index file
$filemod = filemtime("index.php"); 
$filemodtime = date("j F  Y h:i:s A", $filemod);

// set cookie for next visit same theme and language
setcookie("template", $template, (time() + 86400));
setcookie("lng", $lng, (time() + 86400));

// Check for an update
if($updatecheck==true && $jump_var=="")
	{
	$filename = "http://www.xs4all.nl/~basmaaks/sysinfo.dat";
	$fd = fopen ($filename, "r");
	$contents = fread($fd, 1024);
	fclose ($fd);
}
	
//Log and counting
if ($logenable==true){
if ($sysinfostats != "Admin") {
	If ($jump_var==""){
		$koekie=$HTTP_COOKIE_VARS['geteld'];
		if(!$koekie=="gestemd"){ 
			setcookie("geteld", "gestemd",time()+60*60*24); 
			if (!file_exists("$countfile")) {
				$fp = fopen("$countfile", "a");
				fputs($fp, "0");
				fclose($fp);
			}
		$count = join('', file($countfile));
		trim($count);
		$count++;
		$fp = fopen($countfile, "w");
		fputs($fp, $count);
		fclose($fp);
		$fp = fopen($logfile, "a");
		$date = date("d M. Y");
		$time = date("g:i a");
		fputs($fp, "".$date.",".$time.",".$_SERVER['REMOTE_ADDR'].",".$HTTP_SERVER_VARS['HTTP_USER_AGENT'].","."a".",");
		fputs($fp, "\n");
		fclose($fp);
		}
	}
}
}

//disk statistics only needed on 2 pages
if ($jump_var=="" or $jump_var=="4"){

	$diskfreec = round(diskfreespace("c:")  /  (1048576),2);
	$diskfreed = round(diskfreespace("d:")  /  (1048576),2);
	$diskfreee = round(diskfreespace("e:")  /  (1048576),2);
	$diskfreef = round(diskfreespace("f:")  /  (1048576),2);
	$diskfreeg = round(diskfreespace("g:")  /  (1048576),2);
	$diskfreeh = round(diskfreespace("h:")  /  (1048576),2);
	$diskfreei = round(diskfreespace("i:")  /  (1048576),2);
	$diskfreej = round(diskfreespace("j:")  /  (1048576),2);
	$diskfreek = round(diskfreespace("k:")  /  (1048576),2);
	$diskfreel = round(diskfreespace("l:")  /  (1048576),2);
	$diskfreem = round(diskfreespace("m:")  /  (1048576),2);
	$diskfreen = round(diskfreespace("n:")  /  (1048576),2);
	$diskfreeo = round(diskfreespace("o:")  /  (1048576),2);
	$diskfreep = round(diskfreespace("p:")  /  (1048576),2);
	$diskfreeq = round(diskfreespace("q:")  /  (1048576),2);
	$diskfreer = round(diskfreespace("r:")  /  (1048576),2);
	$diskfrees = round(diskfreespace("s:")  /  (1048576),2);
	$diskfreet = round(diskfreespace("t:")  /  (1048576),2);
	$diskfreeu = round(diskfreespace("u:")  /  (1048576),2);
	$diskfreev = round(diskfreespace("v:")  /  (1048576),2);
	$diskfreew = round(diskfreespace("w:")  /  (1048576),2);
	$diskfreex = round(diskfreespace("x:")  /  (1048576),2);
	$diskfreey = round(diskfreespace("y:")  /  (1048576),2);
	$diskfreez = round(diskfreespace("z:")  /  (1048576),2);

	$disktotalc = round(disk_total_space("c:") /  (1048576),2);
	$disktotald = round(disk_total_space("d:") /  (1048576),2);
	$disktotale = round(disk_total_space("e:") /  (1048576),2);
	$disktotalf = round(disk_total_space("f:") /  (1048576),2);
	$disktotalg = round(disk_total_space("g:") /  (1048576),2);
	$disktotalh = round(disk_total_space("h:") /  (1048576),2);
	$disktotali = round(disk_total_space("i:") /  (1048576),2);
	$disktotalj = round(disk_total_space("j:") /  (1048576),2);
	$disktotalk = round(disk_total_space("k:") /  (1048576),2);
	$disktotall = round(disk_total_space("l:") /  (1048576),2);
	$disktotalm = round(disk_total_space("m:") /  (1048576),2);
	$disktotaln = round(disk_total_space("n:") /  (1048576),2);
	$disktotalo = round(disk_total_space("o:") /  (1048576),2);
	$disktotalp = round(disk_total_space("p:") /  (1048576),2);
	$disktotalq = round(disk_total_space("q:") /  (1048576),2);
	$disktotalr = round(disk_total_space("r:") /  (1048576),2);
	$disktotals = round(disk_total_space("s:") /  (1048576),2);
	$disktotalt = round(disk_total_space("t:") /  (1048576),2);
	$disktotalu = round(disk_total_space("u:") /  (1048576),2);
	$disktotalv = round(disk_total_space("v:") /  (1048576),2);
	$disktotalw = round(disk_total_space("w:") /  (1048576),2);
	$disktotalx = round(disk_total_space("x:") /  (1048576),2);
	$disktotaly = round(disk_total_space("y:") /  (1048576),2);
	$disktotalz = round(disk_total_space("z:") /  (1048576),2);

	$diskfree = $diskfreec + $diskfreed + $diskfreee + $diskfreef + $diskfreeg + $diskfreeh + $diskfreei + $diskfreej + $diskfreek + $diskfreel + $diskfreem + $diskfreen + $diskfreeo + $diskfreep + $diskfreeq + $diskfreer + $diskfrees + $diskfreet + $diskfreeu + $diskfreev + $diskfreew + $diskfreex + $diskfreey + $diskfreez;

	$disktotal = $disktotalc + $disktotald + $disktotale + $disktotalf + $disktotalg + $disktotalh + $disktotali + $disktotalj + $disktotalk + $disktotall + $disktotalm + $disktotaln + $disktotalo + $disktotalp + $disktotalq + $disktotalr + $disktotals + $disktotalt + $disktotalu + $disktotalv + $disktotalw + $disktotalx + $disktotaly + $disktotalz;

	$diskusage = round(($disktotal-$diskfree),2);
	$diskusagec = round(($disktotalc-$diskfreec),2);
	$diskusedprecent = round((($diskusage/$disktotal ) * 100),2);
	$diskfreeprecent = round((($diskfree/$disktotal ) * 100),2);
	if ($disktotalc!=""){
		$diskusedprecentc = round((($diskusagec/$disktotalc ) * 100),2);
	}
	if ($disktotald!=""){
		$diskusaged = round(($disktotald-$diskfreed),2);
		$diskusedprecentd = round((($diskusaged/$disktotald ) * 100),2);
	}	
	if ($disktotale!=""){
		$diskusagee = round(($disktotale-$diskfreee),2);
		$diskusedprecente = round((($diskusagee/$disktotale ) * 100),2);
	}
	if ($disktotalf!=""){
		$diskusagef = round(($disktotalf-$diskfreef),2);
		$diskusedprecentf = round((($diskusagef/$disktotalf ) * 100),2);
	}
	if ($disktotalg!=""){
		$diskusageg = round(($disktotalg-$diskfreeg),2);
		$diskusedprecentg = round((($diskusageg/$disktotalg ) * 100),2);
	}
	if ($disktotalh!=""){
		$diskusageh = round(($disktotalh-$diskfreeh),2);
		$diskusedprecenth = round((($diskusageh/$disktotalh ) * 100),2);
	}
	if ($disktotali!=""){
		$diskusagei = round(($disktotali-$diskfreei),2);
		$diskusedprecenti = round((($diskusagei/$disktotali ) * 100),2);
	}
	if ($disktotalj!=""){
		$diskusagej = round(($disktotalj-$diskfreej),2);
		$diskusedprecentj = round((($diskusagej/$disktotalj ) * 100),2);
	}
	if ($disktotalk!=""){
		$diskusagek = round(($disktotalk-$diskfreek),2);
		$diskusedprecentk = round((($diskusagek/$disktotalk ) * 100),2);
	}
	if ($disktotall!=""){
		$diskusagel = round(($disktotall-$diskfreel),2);
		$diskusedprecentl = round((($diskusagel/$disktotall ) * 100),2);
	}
	if ($disktotalm!=""){
		$diskusagem = round(($disktotalm-$diskfreem),2);
		$diskusedprecentm = round((($diskusagem/$disktotalm ) * 100),2);
	}
	if ($disktotaln!=""){
		$diskusagen = round(($disktotaln-$diskfreen),2);
		$diskusedprecentn = round((($diskusagen/$disktotaln ) * 100),2);
	}
	if ($disktotalo!=""){
		$diskusageo = round(($disktotalo-$diskfreeo),2);
		$diskusedprecento = round((($diskusageo/$disktotalo ) * 100),2);
	}
	if ($disktotalp!=""){
		$diskusagep = round(($disktotalp-$diskfreep),2);
		$diskusedprecentp = round((($diskusagep/$disktotalp ) * 100),2);
	}
	if ($disktotalq!=""){
		$diskusageq = round(($disktotalq-$diskfreeq),2);
		$diskusedprecentq = round((($diskusageq/$disktotalq ) * 100),2);
	}
	if ($disktotalr!=""){
		$diskusager = round(($disktotalr-$diskfreer),2);
		$diskusedprecentr = round((($diskusager/$disktotalr ) * 100),2);
	}
	if ($disktotals!=""){
		$diskusages = round(($disktotals-$diskfrees),2);
		$diskusedprecents = round((($diskusages/$disktotals ) * 100),2);
	}
	if ($disktotalt!=""){
		$diskusaget = round(($disktotalt-$diskfreet),2);
		$diskusedprecentt = round((($diskusaget/$disktotalt ) * 100),2);
	}
	if ($disktotalu!=""){
		$diskusageu = round(($disktotalu-$diskfreeu),2);
		$diskusedprecentu = round((($diskusageu/$disktotalu ) * 100),2);
	}
	if ($disktotalv!=""){
		$diskusagev = round(($disktotalv-$diskfreev),2);
		$diskusedprecentv = round((($diskusagev/$disktotalv ) * 100),2);
	}
	if ($disktotalw!=""){
		$diskusagew = round(($disktotalw-$diskfreew),2);
		$diskusedprecentw = round((($diskusagew/$disktotalw ) * 100),2);
	}
	if ($disktotalx!=""){
		$diskusagex = round(($disktotalx-$diskfreex),2);
		$diskusedprecentx = round((($diskusagex/$disktotalx ) * 100),2);
	}
	if ($disktotaly!=""){
		$diskusagey = round(($disktotaly-$diskfreey),2);
		$diskusedprecenty = round((($diskusagey/$disktotaly ) * 100),2);
	}
	if ($disktotalz!=""){
		$diskusagez = round(($disktotalz-$diskfreez),2);
		$diskusedprecentz = round((($diskusagez/$disktotalz ) * 100),2);
	}
}

// The costum style sheet
$CSS = "<style type=\"text/css\">table td {background-color:$color_table;color:$font_info;font-family:$font_type;font-size:$font_size;}.head {background-color:$color_header;color:$font_table;}.body {font-family:$font_type;font-size:$font_size;background-color:$color_background;color:$font_text;scrollbar-face-color:$scrollbar_face; scrollbar-highlight-color:$scrollbar_highlight; scrollbar-shadow-color:$scrollbar_shadow; scrollbar-3dlight-color:$scrollbar_3dlight; scrollbar-arrow-color:$scrollbar_arrow; scrollbar-track-color:$scrollbar_track; scrollbar-darkshadow-color:$scrollbar_darkshadow;}.generatedinfo {background-color:$color_table;color:$font_variables;font-family:$font_type;font-size:$font_size;}a:link {font-family:$font_type; color:$color_link;font-size: 11px; font-style: normal; text-decoration: none}a:active {font-family: $font_type; color:$color_alink; font-size: 11px; font-style: normal; text-decoration: none}a:visited {font-family:$font_type; color:$color_vlink; font-size: 11px; font-style: normal; text-decoration: none}a:hover {font-family:$font_type; color:$color_hlink; font-size: 11px; font-style: normal; text-decoration: underline}.buttons {font-family:$font_type; color:$button_text; font-size: 11px; border: 1px solid #C0C0C0;background-color:$button_color}.fields {border:1px solid #7C8184; font-family:$font_type; font-size: 11px; ;}.toneborder {border-color:$border_color;	border-width:$border_thick;	border-style:$border_style; }</style>";

// send the header of the page to the browser and begin the body
echo "<head><meta http-equiv=\"Content-Type\" content=\"text/html; $charset\">";        
echo "$CSS<title>Sysinfo $Version for $HTTP_SERVER_VARS[SERVER_NAME]</title></HEAD><BODY class=body>";
if ($usebackground==true){
	echo "<BODY BACKGROUND=\"$imgbackground\">";
}

// Begin the first page with the general info ( just gather the info )
if ($jump_var=="") {
	$ip='localhost';
	$regels = explode("\n", `memory.exe`);
	$totaal_fysiek = round($regels[2] /1048576);
	$beschikbaar_fysiek = round($regels[3] /1048576);
	$gebruikt_fysiek = $totaal_fysiek - $beschikbaar_fysiek;
	$gebruikt_precent= round ((($gebruikt_fysiek/$totaal_fysiek ) * 100) ,2);
	$beschikbaar_precent = round ((($beschikbaar_fysiek/$totaal_fysiek) *100) ,2);
	$ipadres=gethostbyname($HTTP_SERVER_VARS['SERVER_NAME']);
	$ver = `ver`;
	$date = date('r');

	//Networkstatistics

	$line = explode("\n", `netstat -e`);
	$line = explode(" ",$line[4]);
				$cnt = 0;
				for ($i=0;$i<count($line);$i++) {
					if ($line[$i]=="") continue;
					if ($cnt==0) $text = ucfirst($line[$i]);
					elseif ($cnt==1) $rec = $line[$i];
					elseif ($cnt==2) $sent = $line[$i];             
					$cnt++;
				}
	
	$totalrecieve = round($rec /  (1048576),2);
	$totalsent = round($sent  /  (1048576),2);
	
	//uptime
	$uptime = (time() - filemtime($pagefile));
	$days = floor($uptime / (24*3600));
	$uptime = $uptime - ($days * (24*3600));
	$hours = floor($uptime / (3600));
	$uptime = $uptime - ($hours * (3600));
	$minutes = floor($uptime /(60));
	$uptime = $uptime - ($minutes * 60);
	$seconds = $uptime;
	if (!eregi("[0-9]{2}", $seconds)){
		$seconds = "0".$seconds;
	}
	if (!eregi("[0-9]{2}", $minutes)){
		$minutes = "0".$minutes;
	}
	if (!eregi("[0-9]{2}", $hours)){
		$hours = "0".$hours;
	}
	if($days == 1){
		$days = $days ." ".$label['day'];
	}elseif($days == 0){
		$days="";
	}else{
		$days = $days ." ".$label['days'];
	}
	if($hours == 1){
		$hours = $hours ." ".$label['hour'];
	}else{ $hours = $hours ." ".$label['hours'];
	}
	if($minutes == 1){
		$minutes = $minutes ." ".$label['minute'];
	}else{ $minutes = $minutes ." ".$label['minutes'];
	}
	if($seconds == 1){
		$seconds = $seconds ." ".$label['second'];
	}else{ $seconds = $seconds ." ".$label['seconds'];
	}
	$theuptime = "".$days." ".$hours." ".$minutes." ".$seconds;
	
	//cpu information
	$CPUINFO =  getenv("NUMBER_OF_PROCESSORS")." X ".getenv("PROCESSOR_IDENTIFIER") ." (Architecture: ".getenv("PROCESSOR_ARCHITECTURE").")";
	
	// Get the size of the swapfile
	$swapfile = round ((filesize($pagefile)) / (1048576),2);
	
	//generate the general first html page and send it to the browser
	echo "<center><table border=0><tr><td valign=top>"
	."<table class=toneborder><tr><td class=head><center><b>".$label['general_info']."</b></center></td></tr>" 
	."<tr><td><table border=0>" 
	."<tr><td>".$label['current_time'].":</td><td><span class=generatedinfo>" 
	.$date ." gmt"
	."</span></td></tr><tr><td>".$label['system_uptime'].":</td><td><span class=generatedinfo>"
	.$theuptime
	."</span></td></tr><tr><td>".$label['server_enviroment'].":</td><td><span class=generatedinfo>"
	.$HTTP_SERVER_VARS['SERVER_SOFTWARE']
	."</span></td></tr><tr><td>".$label['domain_name'].":</td><td><span class=generatedinfo>"
	.$HTTP_SERVER_VARS['SERVER_NAME']
	."</span></td></tr><tr><td>".$label['ip_adres'].":</td><td><span class=generatedinfo>"
	.$ipadres
	."</span></td></tr><tr><td>".$label['server_type'].":</td><td><span class=generatedinfo>"
	.$HTTP_SERVER_VARS['SERVER_PROTOCOL'].$HTTP_SERVER_VARS['GATEWAY_INTERFACE']
	."</span></td></tr><tr><td>".$label['server_operating'].":</td><td><span class=generatedinfo>"
	.$ver
	."</span></td></tr><tr><td>".$label['cpu_info'].":</td><td><span class=generatedinfo>"
	.$CPUINFO
	."</span></td></tr><tr><td>".$label['adres_webmaster'].":</td><td><span class=generatedinfo>"
	.$_SERVER["SERVER_ADMIN"]
	."</span></td></tr><tr><td>".$label['swapfile'].":</td><td><span class=generatedinfo>"
	.$label['file'] .$pagefile ." is " .$swapfile ." Mb"
	."</span></table></table>";
	If ($show['services']==true) {
		if ($usebackground==true){
		echo "<td valign=top class=body background=$imgbackground>";
		}else{
				echo "<td valign=top class=body>";
		}
		echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['running_services']."</b></center></td></tr>" 
		."<tr><td><table border=0>";
		if($show['mysql']==true){
			echo "<tr><td>Sql:</td><td>";
			@$fp = fsockopen ($ip, $port['mysql'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		if($show['http']==true){
			echo "<tr><td>Http :</td><td>";
			@$fp = fsockopen ($ip, $port['http'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		if($show['ftp']==true){
			echo "<tr><td>Ftp:</td><td>";
			@$fp = fsockopen ($ip, $port['ftp'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['mail']==true){
			echo "<tr><td>Mail:</td><td>";
			@$fp = fsockopen ($ip, $port['mail'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['vnc']==true){
			echo "<tr><td>vnc:</td><td>";
			@$fp = fsockopen ($ip, $port['vnc'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['telnet']==true){
			echo "<tr><td>Telnet:</td><td>";
			@$fp = fsockopen ($ip, $port['telnet'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['pcanywhere']==true){
			echo "<tr><td>Pc Anywhere:</td><td>";
			@$fp = fsockopen ($ip, $port['pcanywhere'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['fax']==true){
			echo "<tr><td>Active fax:</td><td>";
			@$fp = fsockopen ($ip, $port['fax'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['news']==true){
			echo "<tr><td>News:</td><td>";
			@$fp = fsockopen ($ip, $port['news'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		If($show['irc']==true){
			echo "<tr><td>Irc:</td><td>";
			@$fp = fsockopen ($ip, $port['irc'], &$errno, &$errstr, .2); 
			if (!$fp) { 
				echo "<font color=\"#FF0000\">".$label['offline'] ."</font>"; 
			} else { 
				echo "<font color=\"#00FF00\">".$label['online'] ."</font>"; 
			}
			echo "</td></tr>";
		}
		echo "</table></table></center>";
	};
	echo "</table><br><table class=toneborder><tr><td class=head><center><b>".$label['total_diskspace']." " 
	.$disktotal ." Mb"
	."</b></center></td><td class=head>" 
	."<center><b>".$label['network_statistics']."</b></center>"
	."</td><td class=head><center><b>".$label['memory']." "
	.$totaal_fysiek ." Mb</b></center>" 
	."</td></tr><tr><td>"
	."<table border=0>"
	."<tr><td></TD><TD>".$label['total']."</td><td>".$label['Value']."</td><td>%</td>"
	."<TR><td>".$label['free_diskspace'].":</td><td><span class=generatedinfo>"
	.$diskfree ."</span> Mb"
	."</td><td>" 
	."<img src=\"$barimg\" height=13 width=$diskfreeprecent ALT=\"".$label['Value']."\">"
	."</td><td>"
	.$diskfreeprecent
	."<br></td></tr><tr><td>".$label['used_diskspace'].":</td><td><span class=generatedinfo>" 
	.$diskusage ."</span> Mb"
	."</td><td>" 
	."<img src=\"$barimg\" height=13 width=$diskusedprecent ALT=\"".$label['Value']."\">"
	."</td><td>"
	.$diskusedprecent
	."</td></tr>" 
	."</table>"
	."</td><td rowspan=2>" 
	."<table border=0>" 
	."<td>"
	."</td><td>&nbsp</td><td>" 
	."</td></tr><td>".$label['total_recieved'].":</td><td><span class=generatedinfo>"
	.$totalrecieve ."</span> Mb"
	."</td></tr><tr><td>".$label['total_sent'].":</td><td><span class=generatedinfo>"
	.$totalsent ."</span> Mb"
	."</td><td>&nbsp</td><td>"
	."</td></table></td><td rowspan=2><table border=0><td></td></tr>"
	."<td></td><td>".$label['total']."</td><td>".$label['Value']."</td><td>%</td></tr>"
	."<td>".$label['free_memory'].":</td><td><span class=generatedinfo>"
	.$beschikbaar_fysiek ."</span> Mb"
	."</td><td>"
	."<img src=\"$barimg\" height=13 width=$beschikbaar_precent ALT=\"".$label['Value']."\">"
	."</td><td>"
	.$beschikbaar_precent
	."</td><td>"
	."</td></tr><td>".$label['used_memory'].":</td><td><span class=generatedinfo>"
	.$gebruikt_fysiek ."</span> Mb"
	."</td><td>"
	."<img src=\"$barimg\" height=13 width=$gebruikt_precent ALT=\"".$label['Value']."\">"
	."</td><td>"
	.$gebruikt_precent
	."</td><td>"
	."</td></tr></table></td></tr></table><BR>"
	."<table class=toneborder><tr><td class=head><center><b>".$label['host_info']."</b></center></td></tr>" 
	."<tr><td><table border=0>"
	. "<tr><td>".$label['browser'].":</td><td><span class=generatedinfo>"
	.$HTTP_SERVER_VARS['HTTP_USER_AGENT'];
	if ($show['hostname']==true){	
		echo "</span><br></td></tr><tr><td>".$label['your_hostname'].":</td><td><span class=generatedinfo>"
		.$REMOTE_HOST;
	}
	echo "</span><br></td></tr><tr><td>".$label['your_ip_adres'].":</td><td><span class=generatedinfo>"
	.$HTTP_SERVER_VARS['REMOTE_ADDR'].":".$HTTP_SERVER_VARS['REMOTE_PORT']
	."</span></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with php info
else if ($jump_var=="1"){
	phpinfo();
}

// When this page is selected begin here generate the page with network info
else if ($jump_var=="2"){
	$ipconfig = `ipconfig -all`;
	$connections = `netstat -n`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['network_enviroment']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$ipconfig
	."</pre></td></tr></table></td></tr></table><br></center>"
	."<center><table class=toneborder><tr><td class=head><center><b>".$label['network_connections']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$connections
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// when this page is selected begins here generate the page with scheduled tasks
else if ($jump_var=="3"){
	$tasks = `at`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['scheduled_tasks']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tasks
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with harddisk details
else if($jump_var=="4"){
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><center>".$label['partition']."</center></td><td><center>".$label['percent_used']."</center></td><td><center>%</center></td><td><center>".$label['free']."</center></td><td><center>".$label['used']."</center></td><td><center>".$label['size']."</center>";

	if ($disktotalc!=""){ 
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-c>C:</A></td><td>";
		}else {echo "C:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentc ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentc</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreec ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagec ."</span> Mb"
		."</td><td><P ALIGN=right><span class=generatedinfo>"
		.$disktotalc ."</span> Mb</p>"
		."</td><td>";
	}

	if ($disktotald!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-d>D:</A></td><td>";
		}else {echo "D:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentd ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentd</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreed ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusaged ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotald ."</span> Mb</p>"
		."</td><td>";
	}

	if ($disktotale!=""){
		echo "<tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-e>E:</A></td><td>";
		}else {echo "E:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecente ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecente</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreee ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagee ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotale ."</span> Mb</p>"
		."</td><td>";
	}

	if ($disktotalf!=""){
		echo "<tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-f>F:</A></td><td>";
		}else {echo "F:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentf ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentf</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreef ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagef ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalf ."</span> Mb</p>"
		."</td><td>";
	}

	if ($disktotalg!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-g>G:</A></td><td>";
		}else {echo "G:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentg ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentg</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreeg ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusageg ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalg ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalh!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-h>H:</A></td><td>";
		}else {echo "H:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecenth ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecenth</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreeh ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusageh ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalh ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotali!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-i>I:</A></td><td>";
		}else {echo "I:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecenti ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecenti</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreei ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagei ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotali ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalj!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-j>J:</A></td><td>";
		}else {echo "J:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentj ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentj</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreej ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagej ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalj ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalk!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-k>K:</A></td><td>";
		}else {echo "K:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentk ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentk</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreek ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagek ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalk ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotall!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-l>L:</A></td><td>";
		}else {echo "L:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentl ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentl</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreel ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagel ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotall ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalm!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-m>M:</A></td><td>";
		}else {echo "M:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentm ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentm</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreem ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagem ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalm ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotaln!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-n>N:</A></td><td>";
		}else {echo "N:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentn ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentn</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreen ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagen ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotaln ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalo!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-o>O:</A></td><td>";
		}else {echo "O:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecento ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecento</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreeo ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusageo ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalo ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalp!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-p>P:</A></td><td>";
		}else {echo "P:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentp ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentp</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreep ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagep ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalp ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalq!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-q>Q:</A></td><td>";
		}else {echo "Q:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentq ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentq</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreeq ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusageq ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalq ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalr!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-r>R:</A></td><td>";
		}else {echo "R:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentr ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentr</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreer ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusager ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalr ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotals!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-s>S:</A></td><td>";
		}else {echo "S:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecents ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecents</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfrees ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusages ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotals ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalt!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-t>T:</A></td><td>";
		}else {echo "T:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentt ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentt</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreet ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusaget ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalt ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalu!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-u>U:</A></td><td>";
		}else {echo "U:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentu ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentu</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreeu ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusageu ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalu ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalv!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-v>V:</A></td><td>";
		}else {echo "V:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentv ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentv</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreev ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagev ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalv ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalw!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-w>W:</A></td><td>";
		}else {echo "W:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentw ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentw</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreew ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagew ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalw ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalx!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-x>X:</A></td><td>";
		}else {echo "X:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentx ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentx</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreex ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagex ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalx ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotaly!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-y>Y:</A></td><td>";
		}else {echo "Y:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecenty ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecenty</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreey ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagey ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotaly ."</span> Mb</p>"
		."</td><td";
	}

	if ($disktotalz!=""){
		echo "</tr><tr><td>";
		If ($show['treeharddisk']==true){
			echo "<a href=index.php?jump_var=4-z>Z:</A></td><td>";
		}else {echo "Z:</TD><TD>";
	}
		echo "<img src=\"$barimg\" height=13 width=$diskusedprecentz ALT=\"".$label['Value']."\">"
		."</td><td><p align=right><span class=generatedinfo>$diskusedprecentz</span> %</p></td><td><P ALIGN=right><span class=generatedinfo>"
		.$diskfreez ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$diskusagez ."</span> Mb</p>"
		."</td><td><P ALIGN=right><span class=generatedinfo>" 
		.$disktotalz ."</span> Mb</p>"
		."</td><td";
	}

	echo "</td></tr>" 
	."<tr><td></td><td><td align=right><font size=-1><i>".$label['total']."</i></font></td><td><span class=generatedinfo>"
	.$diskfree ."</span> Mb"
	."</td><td><span class=generatedinfo>"
	.$diskusage ."</span> Mb"
	."</td><td><span class=generatedinfo>"
	.$disktotal ."</span> Mb"
	."</td></tr></table></table><br></center>";
}

// When this page is selected begin here generate the tree info disk c:
else if ($jump_var=="4-c"){
	$tree= `tree c:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." C:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk d:
else if ($jump_var=="4-d"){
	$tree= `tree d:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." D:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk e:
else if ($jump_var=="4-e"){
	$tree= `tree e:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." E:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk f:
else if ($jump_var=="4-f"){
	$tree= `tree f:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." F:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk g:
else if ($jump_var=="4-g"){
	$tree= `tree g:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." G:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk h:
else if ($jump_var=="4-h"){
	$tree= `tree h:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." H:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk i:
else if ($jump_var=="4-i"){
	$tree= `tree i:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." I:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk j:
else if ($jump_var=="4-j"){
	$tree= `tree j:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." J:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk k:
else if ($jump_var=="4-k"){
	$tree= `tree k:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." K:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk l:
else if ($jump_var=="4-l"){
	$tree= `tree l:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." L:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk m:
else if ($jump_var=="4-m"){
	$tree= `tree m:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." M:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk n:
else if ($jump_var=="4-n"){
	$tree= `tree n:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." N:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk o:
else if ($jump_var=="4-o"){
	$tree= `tree o:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." O:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk p:
else if ($jump_var=="4-p"){
	$tree= `tree p:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." P:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk q:
else if ($jump_var=="4-q"){
	$tree= `tree q:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." Q:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk r:
else if ($jump_var=="4-r"){
	$tree= `tree r:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." R:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk s:
else if ($jump_var=="4-s"){
	$tree= `tree s:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." S:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk t:
else if ($jump_var=="4-t"){
	$tree= `tree t:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." T:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk u:
else if ($jump_var=="4-u"){
	$tree= `tree u:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." U:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk v:
else if ($jump_var=="4-v"){
	$tree= `tree v:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." V:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk w:
else if ($jump_var=="4-w"){
	$tree= `tree w:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." W:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk x:
else if ($jump_var=="4-x"){
	$tree= `tree x:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." X:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk y:
else if ($jump_var=="4-y"){
	$tree= `tree y:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." Y:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begin here generate the tree info disk z:
else if ($jump_var=="4-z"){
	$tree= `tree z:\ /a`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['harddisk_details']." Z:</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$tree
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with the running services
else if($jump_var=="5"){
	$servers= `net start`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['running_process']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$servers
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with the loaded device drivers
else if($jump_var=="6"){
	$drivers= `drivers`;
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['drivers']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$drivers
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with apache status
//
//
// C:\Program Files\EasyPHP\apache\conf\httpd.conf
//
// modifie the lines that look likes the example below 
//
// #<Location /server-status>
// #    SetHandler server-status
// #    Order deny,allow
// #    Deny from all
// #    Allow from 127.0.0.1
// #</Location>



else if($jump_var=="7"){
	$status= fopen("http://127.0.0.1/server-status" ,"r");
	$info = fread($status, 20000);
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['server_status']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$info
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with apache info
//
//
// C:\Program Files\EasyPHP\apache\conf\httpd.conf
//
// modifie the lines that look likes the example below 
//
// #<Location /server-info> 
// #    SetHandler server-info
// #    Order deny,allow
// #    Deny from all
// #    Allow from 127.0.0.1
// #</Location>
//
// And remove the # on the line below
// #AddModule mod_info.c


else if($jump_var=="8"){
	$info= fopen("http://127.0.0.1/server-info" ,"r");
	$status = fread($info, 20000);
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['server_info']."</b></center></td></tr>" 
	."<tr><td><table border=0><tr><td><pre class=generatedinfo>" 
	.$status
	."</pre></td></tr></table></td></tr></table><br></center>";
}

// When this page is selected begins here generate the page with Statistics
else if($jump_var=="9"){
	$log= fopen("$logfile" ,"r");
	$logged = fread($log, 20000000);
	$itemslogged= explode (",",$logged);
	$fp = fopen($countfile, "r");
	$count = fread($fp, 20000);
	echo "<center><table class=toneborder><tr><td class=head><center><b>".$label['Statistieken'].". ".$label['pageviews']." : ".$count."</b></center></td></tr>" 
	."<tr><td><table border=1 class=toneborder><tr><td><TR>"
	."<TD><CENTER>".$label['date']."</CENTER></TD><TD><CENTER>".$label['time']."</CENTER></TD><TD><CENTER>".$label['ip_adres']."</CENTER></TD><TD><CENTER>".$label['browser']."</CENTER></TD></TR><TR>";
	foreach ($itemslogged as $key1 => $elem1) {
       if ($elem1=="a") echo'</TR>';
       else 
		   { echo '<td><center>'.$elem1.'</td></center>'; }
   }
	echo "</table></table></center>";
}

if ($updatecheck==true && $jump_var==""){
	if ($Version<$contents){
		echo "<a href=\"http://basmaaks.xs4all.nl\"><img border=\"0\" src=\"images\update_button.gif\" align=\"right\" alt =\"There's is an update available. Just click to go to my homepage and download the latest version\"></a>";
	}
}

$update_form = "<form method=\"POST\" action=\"$PHP_SELF\">\n"
			 . "\t" . $label['theme'] . ":&nbsp;\n"
             . "\t<select name=\"template\" class=fields>\n";

$dir = opendir('themes/');
while (($file = readdir($dir))!=false) {
    if ($file != 'CVS' && $file != '.' && $file != '..') {
		$file = ereg_replace('.php', '', $file);
        $update_form .= "\t\t<option value=\"$file\"";
        if ($template == $file) {
            $update_form .= " SELECTED";
        }
        $update_form .= ">$file</option>\n";
    }
}
closedir($dir);

$update_form .= "\t</select>\n";

$update_form .= "\t" . $label['language'] . ":&nbsp;\n"
             . "\t<select name=\"lng\" class=fields>\n";

$dir = opendir('languages/');
while (($file = readdir($dir)) != false) {
    if ($file != 'CVS' && $file != '.' && $file != '..') {
        $file = ereg_replace('.php', '', $file);
        if ($lng == $file) {
            $update_form .= "\t\t<option value=\"$file\" SELECTED>$file</option>\n";
        } else {
            $update_form .= "\t\t<option value=\"$file\">$file</option>\n";
        }
    }
}
closedir($dir);

$update_form .= "\t</select>\n";

$update_form .= "\t&nbsp;" . $label['document'] . ":&nbsp;\n"
             . "\t<select name=\"jump_var\" class=fields>\n";

$update_form .= "\t\t<option value=>".$label['mainpage']."</option>\n";
if ($show['pagephp']==true){
	$update_form .= "\t\t<option value=1>".$label['php_enviroment']."</option>\n";
}
if ($show['pagenetwork']==true){
	$update_form .= "\t\t<option value=2>".$label['network_connections']."</option>\n";
}
if ($show['pagetasks']==true){
	$update_form .= "\t\t<option value=3>".$label['scheduled_tasks']."</option>\n";
}
if ($show['pagedisks']==true){
	$update_form .= "\t\t<option value=4>".$label['harddisk_details']."</option>\n";
}
if ($show['pagerserv']==true){
	$update_form .= "\t\t<option value=5>".$label['running_process']."</option>\n";
}
if ($show['pagedrivers']==true){
	$update_form .= "\t\t<option value=6>".$label['drivers']."</option>\n";
}
if ($show['serverstatus']==true){
	$update_form .= "\t\t<option value=7>".$label['server_status']."</option>\n";
}
if ($show['serverinfo']==true){
	$update_form .= "\t\t<option value=8>".$label['server_info']."</option>\n";
}
if ($show['logs']==true){
	$update_form .= "\t\t<option value=9>".$label['Statistieken']."</option>\n";
}

$update_form .= "\t</select>\n"
              . "\t<input type=\"submit\" value=\"" . $label['aply'] . "\" class=buttons>\n"
              . "</form>\n";

echo  "<CENTER> $update_form</CENTER>"

."<HR>Generated by <a href=\"http://basmaaks.xs4all.nl\">Sysinfo $Version</a> written by <a href=\"mailto:the_gamblers@xs4all.nl\">The Gamblers.</a> File last modified $filemodtime";
?>
</BODY>