<?php
/*--------------------------------------------------*
 *        CPG Themes [http://cpgthemes.com]         *
 *         Copyright � 2005 by CPG Themes           *
 *--------------------------------------------------*
 *          Theme Name:  cpgT_MintIce               *
 *          Released:    February 25, 2005          *
 *          Version:     1.0.2                      *
 *--------------------------------------------------*
 *  Theme created for CPG Dragonfly� CMS 9.0.1.1    *
 *            http://dragonflycms.com               *
 *--------------------------------------------------*
 *    This theme is released under the terms and    *
 *    conditions of the GNU GPL version 2 or any    *
 *                later revisions.                  *
 *--------------------------------------------------*/
 
if (!defined('CPG_NUKE')) { exit; }

$gfxcolor = '#C0C000';
$bgcolor1 = '#FFFFFF';
$bgcolor2 = '#CEF1E9';
$bgcolor3 = '#F3F3F3';
$bgcolor4 = '#FF9966';
$textcolor1 = '#336666';
$textcolor2 = '#000000';
$hr = 1; # 1 to have horizonal rule in comments instead of table bgcolor

function OpenTable() {
    echo '<div class="table1">';
}
function OpenTable2() {
    echo '<div class="table2">';
}

function CloseTable() {
    echo '</div>';
}
function CloseTable2() {
    echo '</div>';
}

function themeheader() {
    global $slogan, $sitename, $banners, $mainindex, $adminindex, $cpgtpl, $site_logo, $userinfo, $Blocks;
    $imgr = $imgl = '';
    // left blocks ?
    if ($Blocks->l) {
        $img = $Blocks->hideblock('600') ? 'plus.gif' : 'minus.gif';
        $imgl = '<img align="left" alt="Toggle Content" title="Toggle Content" id="pic600" src="themes/cpgT_MintIce/images/'.$img.'" onclick="blockswitch(\'600\');" style="cursor:pointer" />';
    }
    // right blocks ?
    if ($Blocks->r) {
        $img = $Blocks->hideblock('601') ? 'plus.gif' : 'minus.gif';
        $imgr = '<img align="right" alt="Toggle Content" title="Toggle Content" id="pic601" src="themes/cpgT_MintIce/images/'.$img.'" onclick="blockswitch(\'601\');" style="cursor:pointer" />';
    }

	// Date Function
    $time = gmtime();
	if (is_user() && intval($userinfo['user_timezone']) != 0) {
    $time = $time+(3600*intval($userinfo['user_timezone']));
	}
    
    $cpgtpl->assign_vars(array(
        'CSS_FILE'     => ereg('MSIE', $_SERVER['HTTP_USER_AGENT']) ? 'ie' : 'style',
        'PUBLIC_HEADER' => !defined('ADMIN_PAGES'),
        'B_L_VISIBLE' => $Blocks->hideblock('600') ? 'style="display: none"' : '',
        'B_L_HIDDEN'  => $Blocks->hideblock('600') ? '' : 'style="display: none"',
        'G_LEFTIMAGE'  => $imgl,
        'G_RIGHTIMAGE' => $imgr,
        'S_IS_ADMIN'   => is_admin(),
        'S_CAN_ADMIN'  => can_admin(),
        'S_IS_USER'    => is_user(),
        'S_LOGO'       => $site_logo,
        'S_SITENAME'   => $sitename,
        'S_HOME'       => _HOME,
        'S_DOWNLOADS'  => is_active('Downloads') ? _DownloadsLANG : false,
        'S_FORUMS'     => _ForumsLANG,
        'S_GALLERY'	   => _coppermineLANG,
        'S_LOGIN'	   => _Your_AccountLANG,
        'S_MY_ACCOUNT' => is_user() ? _Your_AccountLANG : _BREG,
        'S_ADMIN'      => _ADMINISTRATION,
        'S_BANNER'     => ($banners) ? viewbanner() : '',
        'S_DATE'	   => date('l, F d, Y', $time),
        'U_MAININDEX'  => $mainindex,
        'U_DOWNLOADS'  => getlink('Downloads'),
        'U_FORUMS'     => getlink('Forums'),
        'U_GALLERY'    => getlink('coppermine'),
        'U_LOGIN'	   => getlink('Your_Account'),
        'U_MY_ACCOUNT' => getlink(is_user() ? 'Your_Account' : 'Your_Account&amp;file=register'),
        'U_ADMININDEX' => $adminindex,
        )
    );
    $Blocks->display('l');
}

function themefooter() {
    global $showblocks, $banners, $cpgtpl, $foot1, $foot2, $foot3, $copyright, $start_time, $db, $Blocks;
    $Blocks->display('r');;
    $cpgtpl->assign_vars(array(
        'B_R_VISIBLE'   => $Blocks->hideblock('601') ? 'style="display: none"' : '',
        'B_R_HIDDEN'    => $Blocks->hideblock('601') ? '' : 'style="display: none"',
        'S_FOOTER'      => footmsg()
        )
    );
    $cpgtpl->set_filenames(array('footer' => 'footer.html'));
    $cpgtpl->display('footer');
}

/***********************************************************************************

 void themesidebox

 Output the specific block to left or right
    $title  : the title of the block
    $content: all formatted content for the block
    $bid    : the database record ID of the block

************************************************************************************/
function themesidebox($title, $content, $bid=0) {
    global $cpgtpl, $themeblockside;
    $cpgtpl->assign_block_vars($themeblockside.'block', array(
        'S_TITLE'   => $title,
        'S_CONTENT' => $content,
        'S_BID'     => $bid,
        'S_VISIBLE' => $Blocks->hideblock($bid) ? 'style="display:none"' : '',
        'S_HIDDEN'  => $Blocks->hideblock($bid) ? '' : 'style="display:none"',
        'S_IMAGE'   => 'themes/cpgT_MintIce/images/'.(hideblock($bid) ? 'plus.gif' : 'minus.gif')
        )
    );
    if ($themeblockside == '') {
        $cpgtpl->set_filenames(array('block' => 'block.html'));
        $cpgtpl->display('block');
    }
}
/***********************************************************************************

 string theme_open_form

 Creates start tag for form
    $get_link : link for action default blank
    $form_name : useful for styling and nbbcode
    $legend: optional string value is used in form lagend tag
    $border: optional use 1 to not show border on fieldset from stylesheet
************************************************************************************/
function theme_open_form($link, $form_name=false, $legend=false,$tborder=false) {
    $leg = $legend ? "<legend>$legend</legend>" : '';
    $bord = $tborder ? $tborder : '';
    $form_name  = $form_name ? ' name="'.$form_name.'" id="'.$form_name.'"' :'';
    return '<fieldset '.$bord.'>'.$leg.'<form method="post" action="'.$link.'"'.$form_name.' enctype="multipart/form-data" accept-charset="utf-8">';
}
function theme_close_form() {
    return '</form></fieldset>';
}
/***********************************************************************************

 string theme_yesno_option

 Creates 2 radio buttons with a Yes and No option
    $name : name for the <input>
    $value: current value, 1 = yes, 0 = no

************************************************************************************/
function theme_yesno_option($name, $value=0) {
    $sel[(!$value)] = '';
    $sel[$value] = ' selected="selected"';
    $select = '<select class="set" name="'.$name.'" id="'.$name."\">\n";
    $select .= '<option value="1"'.$sel[1].">"._YES."</option>\n";
    $select .= '<option value="0"'.$sel[0].">"._NO."</option>\n";
    return $select.'</select>';
    //$sel[intval($value)] = ' checked="checked"';
    //return '<input type="radio" name="'.$name.'" value="1"'.$sel[1].' title="'._YES.'" />
    //<label class="yes" for="'.$name.'">'._YES.'</label>
    //<input type="radio" name="'.$name.'" value="0" '.$sel[0].' title="'._NO.'" />
    //<label class="no" for="'.$name.'">'._NO.'</label> ';
}
/***********************************************************************************

 string theme_select_option

 Creates a selection dropdown box of all given variables in the array
    $name : name for the <select>
    $value: current/default value
    $array: array like array("value1","value2")

************************************************************************************/
function theme_select_option($name, $value, $array) {
    $sel[$value] = ' selected="selected"';
    $select = '<select class="set" name="'.$name.'" id="'.$name."\">\n";
    foreach($array as $var) {
        $select .= '<option'.(isset($sel[$var])?$sel[$var]:'').">$var</option>\n";
    }
    return $select.'</select>';
}
/***********************************************************************************

 string theme_select_box

 Creates a selection dropdown box of all given variables in the multi array
    $name : name for the <select>
    $value: current/default value
    $array: array like array("value1 => title1","value2 => title2")

************************************************************************************/
function theme_select_box($name, $value, $array) {
    $select = '<select class="set" name="'.$name.'" id="'.$name."\">\n";
    foreach($array as $val => $title) {
        $select .= "<option value=\"$val\"".(($val==$value) ? ' selected="selected"' : '').">$title</option>\n";
    }
    return $select.'</select>';
}
