<?php
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Copyright (C) 2005-2007 by Dark Grue

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: modules/Content/search.inc $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  Based on:
    The Content Module Enhancements by BrokenCrust.

    Content Module 2.0.1.0
    Copyright (C) 2004-2005 by CPG-Nuke Dev Team
    http://dragonflycms.org

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/


// *********************** Module Instantiation ************************
// Multiple instances of this module can be created by making a copy of
// the module directory and adding an underscore followed by an integer
// to the name of the directory (e.g. "Content_2"). The module
// will detect this and automagically configure itself.
//
// NOTE:
//	The module will check $mod_basename against its installation
//	directory.
//	Blocks that reference this module MUST be configured separately to
//	reference the new instance (e.g. naming to
//	"block-Content_Menu_2.php").
$mod_basename = 'Content';
$mod_dirname = basename(dirname(__FILE__));

$matches = array();
if (preg_match("/^{$mod_basename}(?:_(\d+))?$/", $mod_dirname, $matches)) {
	$suffix = (empty($matches[1])) ? '' : "_{$matches[1]}";
} else {
	trigger_error("The module installation directory, \"{$mod_dirname}\", does not follow the expected instantation syntax of \"{$mod_basename}[_<i>&lt;integer&gt;</i>]\".", E_USER_WARNING);
	return;
}

// REQUIRED: $mod_dirname
// REQUIRED: $suffix
// *********************************************************************


eval("class {$mod_dirname}_search {
	var \$title;
	var \$options;
	var \$result = array();
	var \$result_count = 0;
	var \$link_next;
	var \$link_prev;

	function {$mod_dirname}_search() {
		global \$db, \$prefix;

		// Get custom title for module.
		list(\$custom_title) = \$db->sql_ufetchrow(\"SELECT custom_title FROM {\$prefix}_modules WHERE title='{$mod_dirname}'\", SQL_NUM);

		\$cats[0] = _ALL;
		\$result = \$db->sql_query(\"SELECT cid, title FROM {\$prefix}_pages_categories{$suffix} ORDER BY title\", FALSE);
		while (list(\$id, \$title) = \$db->sql_fetchrow(\$result)) {
			\$cats[\$id] = \$title;
		}
		\$db->sql_freeresult(\$result);

		\$this->title = (empty(\$custom_title)) ? _ContentLANG.'{$suffix}' : \$custom_title;
		\$this->options = '<table border=\"0\">'
		.'<tr><td>'._CATEGORY.'</td><td>'.select_box('content{$suffix}_category', 0, \$cats).'</td></tr>'
			.\"</table>\n\";
	}

	function search(\$search, \$url_search, \$limit = 10, \$page = 0, \$parameters = FALSE) {
		global \$db, \$prefix;

		\$cat = (isset(\$_POST['content{$suffix}_category']) ? intval(\$_POST['content{$suffix}_category']) : ((isset(\$_GET['content{$suffix}_category'])) ? intval(\$_GET['content{$suffix}_category']) : ''));

		// Get module language file.
		".(($mod_dirname != $mod_basename) ? "get_lang('{$mod_basename}');" : '')."

		\$first = \$page * \$limit;

		\$sql = \"SELECT pid, cid, title, UNIX_TIMESTAMP(date) AS time, LEFT(text, 256) AS short_text FROM {\$prefix}_pages{$suffix} WHERE active='1'\";
		if (\$cat != 0) \$sql .= \" AND cid='{\$cat}'\";
		if (\$search != '') \$sql .= \" AND
			(title LIKE '%\$search%' OR 
			subtitle LIKE '%\$search%' OR 
			page_header LIKE '%\$search%' OR 
			text LIKE '%\$search%' OR 
			page_footer LIKE '%\$search%' OR 
			signature LIKE '%\$search%')\";
		\$sql .= \" ORDER BY date DESC LIMIT \$first,\".(\$limit + 1);

		\$result = \$db->sql_query(\$sql, FALSE);
		\$nrows = \$db->sql_numrows(\$result);

		\$x = (\$limit > \$nrows) ? \$nrows : \$limit;

		if (\$nrows > 0) {
			while(\$x > 0) {
				list(\$pid, \$cid, \$title, \$time, \$short_text) = \$db->sql_fetchrow(\$result);
				\$furl = getlink(\"Content{$suffix}&pid=\$pid\");
				\$datetime = formatDateTime(\$time, _DATESTRING3);

				\$item['title'] = \$title;
				\$item['url'] = \$furl;
				\$item['author'] = '';
				\$item['date'] = \$time;
				\$item['short_text'] = trim(strip_tags(\$short_text));
				\$item['image'] = 'images/folders.gif';

				\$this->add_result(\$item);
				unset(\$item);

				\$x--;
			}
		}
		\$db->sql_freeresult(\$result);

		if (\$page > 0) {
			\$this->link_prev = '<a href=\"'.getlink('Search&amp;page='.(\$page - 1).\"&amp;cat=\$cat&amp;search=\$url_search&amp;mod={$mod_dirname}\").'\"><strong>'._PREVMATCHES.' '._IN.' '.\$this->title.'</strong></a>';
		}

		if (\$nrows > \$limit) {
			\$this->link_next = '<a href=\"'.getlink('Search&amp;page='.(\$page + 1).\"&amp;cat=\$cat&amp;search=\$url_search&amp;mod={$mod_dirname}\").'\"><strong>'._NEXTMATCHES.' '._IN.' '.\$this->title.'</strong></a>';
		}

		return TRUE;
	}

	function add_result(\$resultarray) {
		\$this->result[\$this->result_count++] = \$resultarray;
	}
}");