<?php
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Copyright (C) 2005-2007 by Dark Grue

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: modules/Content/index.php $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  Based on:
    The Content Module Enhancements by BrokenCrust.

    Content Module 2.0.1.0
    Copyright (C) 2004-2005 by CPG-Nuke Dev Team
    http://dragonflycms.org

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/
if (!defined('CPG_NUKE')) { exit; }


// *********************** Module Instantiation ************************
// Multiple instances of this module can be created by making a copy of
// the module directory and adding an underscore followed by an integer
// to the name of the directory (e.g. "Content_2"). The module
// will detect this and automagically configure itself.
//
// NOTE:
//	The module will check $mod_basename against its installation
//	directory.
//	Blocks that reference this module MUST be configured separately to
//	reference the new instance (e.g. naming to
//	"block-Content_Menu_2.php").
$mod_basename = 'Content';
$mod_dirname = basename(dirname(__FILE__));

// Get module language file.
if ($mod_dirname != $mod_basename) { get_lang($mod_basename); }

$matches = array();
if (preg_match("/^{$mod_basename}(?:_(\d+))?$/", $mod_dirname, $matches)) {
	$suffix = (empty($matches[1])) ? '' : "_{$matches[1]}";
} else {
	cpg_error('<strong>'._ERR_FATALCONFIG."</strong><br /><br />\n"
		."The module installation directory, \"{$mod_dirname}\", does not follow the expected instantation syntax of \"{$mod_basename}[_<i>&lt;integer&gt;</i>]\".");
}

// REQUIRED: $mod_dirname
// REQUIRED: $suffix
// *********************************************************************


// ************************** Global Variables *************************
global $bgcolor1, $bgcolor2, $bgcolor3;

// Page title.
$pagetitle .= $module_title;


// ***************************** FUNCTIONS *****************************
function PrintConPage(&$mypage) {
	global $BASEHREF, $mod_dirname, $nukeurl, $site_logo, $sitename, $slogan;

	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n"
		."        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html>\n"
		."<head><base href=\"$BASEHREF\" />\n"
		."<title>{$mypage['sitename']}</title></head>\n"
		."<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n"
		."<table border=\"0\"><tr><td>\n"
		."  <table border=\"0\" width=\"640\" cellpadding=\"20\" bgcolor=\"#FFFFFF\"><tr><td>\n"
		."    <center><img src=\"{$BASEHREF}images/$site_logo\" border=\"0\" alt=\"$slogan\" /><br /><br />\n"
		."    <div class=\"content\"><b>{$mypage['title']}</b></div><br />\n";
		if ($mypage['subtitle'] != '') { echo "    <div class=\"content\">{$mypage['subtitle']}</div><br /><br />"; }
	echo "</center>\n";
	if ($mypage['page_header'] != '') { echo "    <div class=\"content\">{$mypage['page_header']}</div><br /><br />\n"; }
	echo "<div class=\"content\">{$mypage['text']}</div><br /><br />\n";
	if ($mypage['page_footer'] != '') { echo "    <div class=\"content\">{$mypage['page_footer']}</div><br /><br />\n"; }
	if ($mypage['signature'] != '') { echo "    <div class=\"content\">{$mypage['signature']}</div><br /><br />\n"; }
	echo '    <div class="content">'._PUBLISHEDON.": {$mypage['date']} ({$mypage['counter']} "._READS.")</div></td></tr></table>\n"
		.'  <div class="content" align="center">'._COMESFROM." $sitename<br />\n"
		."  <a href=\"$nukeurl\">$nukeurl</a><br /><br />\n"
		.'  '._THEURL."<br />\n"
		."  <a href=\"$nukeurl/".getlink("{$mod_dirname}&amp;pid={$mypage['pid']}")."\">$nukeurl/".getlink("{$mod_dirname}&amp;pid={$mypage['pid']}")."</a></div><br />\n"
		."</td></tr></table>\n</body>\n</html>\n";
}

if (isset($_GET['pid'])) {
	$pid = intval($_GET['pid']);
	$mypage = $db->sql_ufetchrow("SELECT * FROM {$prefix}_pages{$suffix} WHERE pid='$pid'");
	if (!isset($mypage['active']) || ($mypage['active'] == 0 && !can_admin($mod_dirname))) {
		cpg_error(sprintf(_MODULENOEXIST, ''), 404);
	}

	if (isset($_GET['page'])) {
		$page = intval($_GET['page']);
	} else {
		$page = 0;

		// Update pageview counter only on first view - moving between
		// pages will not count towards total
		$db->sql_query("UPDATE {$prefix}_pages{$suffix} SET counter=counter+1 WHERE pid='$pid'", FALSE);
	}

	if (isset($_GET['print'])) {
		PrintConPage($mypage);
		return;
	}

	$pagetitle .= ' '._BC_DELIM.' '.$mypage['title'];

	require_once('header.php');
	OpenTable();

	OpenTable();
	echo "<div class=\"title\">{$mypage['title']}</div><br />\n";
	if ($mypage['subtitle'] != '') { echo "<div class=\"nav\">{$mypage['subtitle']}</div>\n"; }
	CloseTable();

	// Paginate content
	$contentpages = explode('<!--pagebreak-->', $mypage['text']);
	$pageno = count($contentpages);
	if ($page=='' || $page < 1) {
		$page = 1;
	}
	if ($page > $pageno) {
		$page = $pageno;
	}
	$arrayelement = (int)$page;
	$arrayelement --;
	echo '<table cellpadding="0" cellspacing="0" width="100%"><tr>';
	if ($pageno > 1) {
		echo '<td nowrap="nowrap">'._PAGE.": $page/$pageno&nbsp;</td>";
	}
	echo "<td width=\"100%\"><hr /></td></tr></table><br />\n";

	if ($page == 1 && ($mypage['page_header'] != '')) {
		echo '<div class="content">'.nl2br($mypage['page_header'])."</div><br />\n";
	}
	echo "<div class=\"content\">$contentpages[$arrayelement]</div><br /><br />\n";
	$next_page = '';
	if($page < $pageno) {
		$next_pagenumber = $page + 1;
		if ($page != 1) {
			$next_page = ' -';
		}
		$next_page .= ' <a href="'.getlink("&amp;pid=$pid&amp;page=$next_pagenumber").'">'._NEXT." ($next_pagenumber/$pageno)</a> "
			.'<a href="'.getlink("&amp;pid=$pid&amp;page=$next_pagenumber")."\"><img src=\"modules/{$mod_dirname}/images/right.gif\" border=\"0\" style=\"vertical-align:middle\" alt=\""._NEXT.'" /></a>';
	}
	if ($page == $pageno && ($mypage['page_footer'] != '')) {
		echo "<br /><div class=\"content\" style=\"text-align: justify;\">".nl2br($mypage['page_footer'])."</div><br /><br />\n";
		echo "<br /><div class=\"content\" style=\"text-align: justify;\">".nl2br($mypage['signature'])."</div><br /><br />\n";
		echo "<br /><div class=\"content\" style=\"text-align: justify;\">"._PUBLISHEDON.': '.nl2br($mypage['date']).' ('.nl2br($mypage['counter']).' '._READS.")</div><br /><br />\n";
	}
	if($page <= 1) {
		$previous_page = '';
	} else {
		$previous_pagenumber = $page - 1;
		$previous_page = '<a href="'.getlink("&amp;pid=$pid&amp;page=$previous_pagenumber")."\"><img src=\"modules/{$mod_dirname}/images/left.gif\" border=\"0\" style=\"vertical-align:middle\" alt=\""._PREVIOUS.'" /></a> '
			.'<a href="'.getlink("&amp;pid=$pid&amp;page=$previous_pagenumber").'">'._PREVIOUS." ($previous_pagenumber/$pageno)</a>";
	}
	if (!empty($previous_page) || !empty($next_page)) {
		echo '<br /><br /><br /><center>'.$previous_page.$next_page."</center><br /><br />\n";
	}

	echo "<center>({$mypage['counter']} "._READS.") <img src=\"modules/{$mod_dirname}/images/print.gif\" border=\"0\" alt=\""._PRINTER.'" title="'._PRINTER.'" onclick="window.open(\''.getlink("{$mod_dirname}&amp;print=yes&amp;pid={$pid}").'\', \'_blank\', \'height=550,menubar=yes,resizable=yes,scrollbars=yes,toolbar=yes,width=685\'); return false;" />'."<br />\n";
	echo '<span class="nav">[&nbsp;'._RETURNCAT.' <a href="';
	if ($mypage['cid'] > 0) {
		list($title) = $db->sql_ufetchrow("SELECT title FROM {$prefix}_pages_categories{$suffix} WHERE cid='{$mypage['cid']}'");
		echo getlink("$mod_dirname&amp;cid={$mypage['cid']}")."\">$title";
	} else {
		// Get custom module title.
		list($custom_title) = $db->sql_ufetchrow("SELECT custom_title FROM {$prefix}_modules WHERE title='{$mod_dirname}'", SQL_NUM);

		echo getlink($mod_dirname).'">'.((empty($custom_title)) ? _ContentLANG.$suffix : $custom_title);
	}
	echo "</a>&nbsp;]</span>";
	if (can_admin($mod_dirname)) {
		echo "<br /><br />\n[&nbsp;<a href=\"".adminlink("&amp;mode=content_edit&amp;pid=$pid").'">'._EDIT.'</a>&nbsp;| ';
		if ($mypage['active']) {
			echo '<a href="'.adminlink("&amp;mode=content_change_status&amp;pid=$pid&amp;active=1").'">'._DEACTIVATE.'</a>&nbsp;| ';
		} else {
			echo '<a href="'.adminlink("&amp;mode=content_change_status&amp;pid=$pid&amp;active=0").'">'._ACTIVATE.'</a>&nbsp;| ';
		}
		echo '<a href="'.adminlink("&amp;mode=content_delete&amp;pid=$pid").'">'._DELETE.'</a>&nbsp;]';
	}
	echo "</center><br /><br />\n";

	CloseTable();
} else {
	$mycid = (isset($_GET['cid'])) ? intval($_GET['cid']) : 0;

	// Construct breadcrumbs
	$crumb = '';
	if ($mycid > 0) {
		$mycat = $db->sql_ufetchrow("SELECT title, parentcid FROM {$prefix}_pages_categories{$suffix} WHERE cid='$mycid'");
		if ($mycat['parentcid'] > 0) {
			$mypcat = $db->sql_ufetchrow("SELECT title FROM {$prefix}_pages_categories{$suffix} WHERE cid='{$mycat['parentcid']}'");
			$crumb = '<a href="'.getlink('&amp;cid='.$mycat['parentcid'])."\">{$mypcat['title']}</a> "._BC_DELIM.' ';
		} else {
			$crumb = '<a href="'.getlink($mod_dirname).'">'._MAINPAGE.'</a> '._BC_DELIM.' ';
		}
		$crumb .= $mycat['title'];
		$pagetitle .= ' '._BC_DELIM.' '.$mycat['title'];
	} else {
		$crumb = _MAINPAGE;
	}

	require_once('header.php');
	OpenTable();
	echo "<span class=\"gen\"><strong>$crumb</strong></span><br /><br />\n";

	// Content Sub-Categories
	$querylang = ($multilingual) ? "AND (language='$currentlang' OR language='')" : '';
	$result = $db->sql_query("SELECT cid, title, description FROM {$prefix}_pages_categories{$suffix} WHERE parentcid='$mycid' $querylang ORDER BY title", FALSE);
	if ($db->sql_numrows($result) > 0) {
		echo '<center><fieldset style="text-align:left;width:75%"><legend>'._CONTENTCATEGORIES."</legend><br />\n"
			."<table border=\"0\" cellpadding=\"4\" cellspacing=\"1\" width=\"100%\" bgcolor=\"$bgcolor1\">\n";
		$row_bgcolor = $bgcolor3;
		while (list($cid, $title, $description) = $db->sql_fetchrow($result)) {
			$row_bgcolor = ($row_bgcolor == '') ? " bgcolor=\"$bgcolor3\"" : '';
			$pages = $db->sql_count("{$prefix}_pages{$suffix}", "cid=$cid AND active=1");
			$cats = $db->sql_count("{$prefix}_pages_categories{$suffix}", "parentcid=$cid");
			echo "<tr{$row_bgcolor}><td valign=\"top\" width=\"25%\"><img src=\"modules/{$mod_dirname}/images/arrow.gif\" border=\"0\" alt=\"\" />&nbsp;<a href=\"".getlink("&amp;cid=$cid")."\">$title</a></td>"
				."<td>$description";
			if ($pages || $cats) {
				echo '<br /><span style="font-size:85%">('
					.(($pages) ? "$pages ".(($pages > 1) ? _PAGES : _PAGE).(($cats) ? ', ' : '') : '')
					.(($cats) ? "$cats ".(($cats > 1) ? _CATEGORIES : _CATEGORY) : '')
					.')</span>';
			}
			echo "</td></tr>\n";
		}
		$db->sql_freeresult($result);
		echo "</table>\n</fieldset></center><br /><br />\n";
	}

	// Active Content Pages
	$result = $db->sql_query("SELECT pid, title, subtitle, counter, language FROM {$prefix}_pages{$suffix} WHERE active='1' AND cid='$mycid' $querylang ORDER BY title", FALSE);
	echo '<table border="0" cellspacing="2" cellpadding="2" width="100%">'
		.'<tr><td nowrap="nowrap"><span class="nav">'._PAGES."</span></td></tr></table>\n"
		.'<table class="forumline" border="0" cellpadding="4" cellspacing="1" width="100%">';
	if ($db->sql_numrows($result) > 0) {
		$i = 0;
		while (list($pid, $title, $subtitle, $counter, $language) = $db->sql_fetchrow($result)) {
			$subtitle = ($subtitle != '') ? "<i>$subtitle</i>" : '&nbsp;';
			$row_class = (!($i++ % 2)) ? 'row2' : 'row3';
			echo "<tr><td class=\"$row_class\" valign=\"top\"><img src=\"modules/{$mod_dirname}/images/arrow.gif\" border=\"0\" alt=\"\" />&nbsp;<a href=\"".getlink("&amp;pid=$pid")."\">$title</a>"
				.((empty($subtitle)) ? '' : "<br /><span style=\"font-size:85%\"><i>$subtitle</i></span>").'</td>'
				."<td class=\"$row_class\" align=\"center\" nowrap=\"nowrap\" valign=\"top\" width=\"25%\">($counter "._READS.") <img src=\"modules/{$mod_dirname}/images/print.gif\" border=\"0\" alt=\""._PRINTER.'" title="'._PRINTER.'" onclick="window.open(\''.getlink("{$mod_dirname}&amp;print=yes&amp;pid={$pid}").'\', \'_blank\', \'height=550,menubar=yes,resizable=yes,scrollbars=yes,toolbar=yes,width=685\'); return false;" />';
			if (can_admin($mod_dirname)) {
				echo "<br />\n[&nbsp;<a href=\"".adminlink("&amp;mode=content_edit&amp;pid=$pid").'">'._EDIT.'</a>&nbsp;| '
					.'<a href="'.adminlink("&amp;mode=content_change_status&amp;pid=$pid&amp;active=1").'">'._DEACTIVATE.'</a>&nbsp;| '
					.'<a href="'.adminlink("&amp;mode=content_delete&amp;pid=$pid").'">'._DELETE.'</a>&nbsp;]';
			}
			echo "</td></tr>\n";
		}
		$db->sql_freeresult($result);
	} else {
		echo '<tr><td align="center"><i>'._NOCONTENT."</i></td></tr>\n";
	}
	echo "</table><br /><br />\n";

	// Administrate Inactive Content
	if (can_admin($mod_dirname)) {
		$result = $db->sql_query("SELECT pid, cid, title, subtitle, language FROM {$prefix}_pages{$suffix} WHERE cid='$mycid' AND active='0' ORDER BY title", FALSE);
		if ($db->sql_numrows($result) > 0) {
			echo '<table border="0" cellspacing="2" cellpadding="2" width="100%">'
				.'<tr><td nowrap="nowrap"><span class="nav">'._YOURADMINLIST."</span></td></tr></table>\n"
				.'<table class="forumline" border="0" cellpadding="4" cellspacing="1" width="100%"><tr>'
				.'<th class="thCornerL"><b>'._TITLE.'</b></th>'
				.'<th class="thTop" align="center"><b>'._CSUBTITLE.'</b></th>'
				.'<th class="thCornerR" align="center"><b>'._FUNCTIONS."</b></th></tr>\n";
			$i = 0;
			while (list($pid, $cid, $title, $subtitle, $language) = $db->sql_fetchrow($result)) {
				$subtitle = ($subtitle != '') ? "<i>$subtitle</i>" : '&nbsp;';
				$row_class = (!($i++ % 2)) ? 'row1' : 'row2';
				echo "<tr><td class=\"$row_class\" valign=\"top\" width=\"25%\"><img src=\"modules/{$mod_dirname}/images/arrow.gif\" border=\"0\" alt=\"\" />&nbsp;<a href=\"".getlink("&amp;pid=$pid")."\">$title</a></td>"
				."<td class=\"$row_class\" valign=\"top\">$subtitle</td>"
				."<td class=\"$row_class\" align=\"center\" valign=\"top\" width=\"25%\">[&nbsp;<a href=\"".adminlink("&amp;mode=content_edit&amp;pid=$pid").'">'._EDIT.'</a>&nbsp;| '
				.'<a href="'.adminlink("&amp;mode=content_change_status&amp;pid=$pid&amp;active=0").'">'._ACTIVATE.'</a>&nbsp;| '
				.'<a href="'.adminlink("&amp;mode=content_delete&amp;pid=$pid")."\">"._DELETE."</a>&nbsp;]</td></tr>\n";
			}
			$db->sql_freeresult($result);
			echo "</table><br /><br />\n";
		}
	}
	CloseTable();
}