<?php 
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Copyright (C) 2005-2007 by Dark Grue

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: modules/Content/functions/categories.inc $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/
if (!defined('CPG_NUKE')) { exit; }


function list_cat_recursive(&$categories, $parent = 0, $depth = 0, $crumb = '') {
	global $db, $prefix, $suffix, $mod_dirname;

	// Retrieve category cache.
	if (($parent == 0) && ($depth == 0)) {
	 	if ($categories = Cache::array_load('categories', $mod_dirname, FALSE)) {
			$depth = $categories['depth'];
            	unset($categories['depth']);

			return $depth;
		}
	}

	// Retrieve content categories.
	$result = $db->sql_query("SELECT cid, title, description FROM {$prefix}_pages_categories{$suffix}
		WHERE parentcid={$parent}
		ORDER BY title", FALSE);
	$numrows = $db->sql_numrows($result);
	if ($numrows) {
		for ($i = 0; $i < $numrows; $i++) {
			$row = $db->sql_fetchrow($result, SQL_ASSOC);
			$row['parentcid'] = $parent;				// diagnostic
			$row['level'] = $depth;
			$row['crumb'] = $crumb;
			$forwardcrumb = '';
			if ($depth > 0) {
				if ($i == ($numrows - 1)) { 
					$row['last'] = TRUE;			// diagnostic
					$image = 'treeimage3.png';		// image: "'-"
					$forwardimage = 'treeimage4.png';	// image: "  " (blank spacer)
				} else {
					$image = 'treeimage2.png';		// image: "|-"
					$forwardimage = 'treeimage1.png';	// image: "| "
				}
				$row['crumb'] .= "<img src=\"modules/{$mod_dirname}/images/folders/{$image}\" style=\"border:0;width:16px;height:16px;vertical-align:middle\" alt=\"\" />";
				$forwardcrumb = "{$crumb}<img src=\"modules/{$mod_dirname}/images/folders/{$forwardimage}\" style=\"border:0;width:16px;height:16px;vertical-align:middle\" alt=\"\" />";
			}
			$row['crumb'] .= "<img src=\"modules/{$mod_dirname}/images/folders/folder.png\" style=\"border:0;width:16px;height:16px;vertical-align:middle\" alt=\"\" />";
			$categories[] = $row;
			$templevel = list_cat_recursive($categories, $row['cid'], ($depth + 1), $forwardcrumb);
		}
	}
	$db->sql_freeresult($result);

	// Save category cache.
	if (($parent == 0) && ($depth == 0)) {
		$categories['depth'] = $depth;
		Cache::array_save('categories', $mod_dirname, $categories);
		unset($categories['depth']);
	}

	return $depth;
}