<?php
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Copyright (C) 2005-2007 by Dark Grue

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: modules/Content/cpg_inst.php $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/
if (!defined('ADMIN_MOD_INSTALL')) { exit; }


// *********************** Module Instantiation ************************
// Multiple instances of this module can be created by making a copy of
// the module directory and adding an underscore followed by an integer
// to the name of the directory (e.g. "Content_2"). The module
// will detect this and automagically configure itself.
//
// NOTE:
//	The module will check $mod_basename against its installation
//	directory.
//	Blocks that reference this module MUST be configured separately to
//	reference the new instance (e.g. naming to
//	"block-Content_Menu_2.php").
$mod_basename = 'Content';
$mod_dirname = basename(dirname(__FILE__));

$matches = array();
if (preg_match("/^{$mod_basename}(?:_(\d+))?$/", $mod_dirname, $matches)) {
	$suffix = (empty($matches[1])) ? '' : "_{$matches[1]}";
} else {
	include('header.php');

	cpg_error("<strong>A fatal configuration error has occurred.</strong><br /><br />\n"
		."The module installation directory, <nobr>\"{$mod_dirname}\"</nobr>, does not follow the expected instantation syntax of <nobr>\"{$mod_basename}[_<i>&lt;integer&gt;</i>]\"</nobr>.");
}

// REQUIRED: $mod_dirname
// REQUIRED: $suffix
// *********************************************************************


eval("class $mod_dirname {
	var \$description;
	var \$radmin;
	var \$modname;
	var \$version;
	var \$author;
	var \$website;
	var \$dbtables;

	function $mod_dirname() {
		\$this->radmin = true;
		\$this->version = '9.7.11';
		\$this->modname = 'Content';
		\$this->description = 'Create an organized collection of HTML pages.';
		\$this->author = 'Dark Grue';
		\$this->website = 'www.theclenchedfist.com/projects/content/';
		\$this->dbtables = array('pages{$suffix}', 'pages_categories{$suffix}');
	}

	function install() {
		global \$installer;

		\$installer->add_query('CREATE', 'pages{$suffix}', \"
			pid INT(10) NOT NULL auto_increment,
			cid INT(10) NOT NULL default '0',
			title VARCHAR(255) NOT NULL,
			subtitle VARCHAR(255) NOT NULL,
			active int(1) NOT NULL default '0',
			page_header TEXT NOT NULL,
			text MEDIUMTEXT NOT NULL,
			page_footer TEXT NOT NULL,
			signature TEXT NOT NULL,
			date DATETIME NOT NULL default '0000-00-00 00:00:00',
			counter INT(10) NOT NULL default '0',
			language VARCHAR(30) NOT NULL,
			PRIMARY KEY (pid),
			KEY pid (pid),
			KEY cid (cid)\", 'pages{$suffix}');
		\$installer->add_query('CREATE', 'pages_categories{$suffix}', \"
			cid INT(10) NOT NULL auto_increment,
			title VARCHAR(255) NOT NULL,
			description TEXT NOT NULL,
			parentcid INT(11) NOT NULL default '0',
			language VARCHAR(30) NOT NULL,
			PRIMARY KEY (cid),
			KEY cid (cid)\", 'pages_categories{$suffix}');

		return TRUE;
	}

	function uninstall() {
		global \$installer;

		foreach(\$this->dbtables as \$table) {
			\$installer->add_query('DROP', \$table);
		}

		return TRUE;
	}

	function upgrade(\$prev_version) {
		global \$db, \$prefix;

		\$matches = array();

		preg_match('/([\d]+)\.([\d]+)(?:\.([\d]+))/', \$prev_version, \$matches);
		\$major = \$matches[1];
		\$minor = \$matches[2];
		\$patch = \$matches[3];

		if ((int)\$major < 9) {
			\$db->sql_query(\"ALTER TABLE {\$prefix}_pages_categories{$suffix} ADD COLUMN parentcid INT(11) NOT NULL DEFAULT 0 AFTER description\", TRUE);
			\$db->sql_query(\"ALTER TABLE {\$prefix}_pages_categories{$suffix} ADD COLUMN language VARCHAR(30)\", TRUE);
			\$db->sql_query(\"UPDATE {\$prefix}_pages_categories{$suffix} SET language=''\", FALSE);
			\$db->sql_query(\"ALTER TABLE {\$prefix}_pages_categories{$suffix} CHANGE COLUMN language language VARCHAR(30) NOT NULL\", FALSE);
		}

		\$db->sql_query(\"ALTER TABLE {\$prefix}_pages{$suffix} CHANGE COLUMN text text MEDIUMTEXT NOT NULL\", TRUE);

		return TRUE;
    }
}");