<?php
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Copyright (C) 2005-2007 by Dark Grue

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: modules/Content/admin/index.inc $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/
if (!defined('ADMIN_PAGES')) { exit; }


// *********************** Module Instantiation ************************
// Multiple instances of this module can be created by making a copy of
// the module directory and adding an underscore followed by an integer
// to the name of the directory (e.g. "Content_2"). The module
// will detect this and automagically configure itself.
//
// NOTE:
//	The module will check $mod_basename against its installation
//	directory.
//	Blocks that reference this module MUST be configured separately to
//	reference the new instance (e.g. naming to
//	"block-Content_Menu_2.php").
$mod_basename = 'Content';
$mod_dirname = basename(dirname(dirname(__FILE__)));

// Get module language file.
if ($mod_dirname != $mod_basename) { get_lang($mod_basename); }

$matches = array();
if (preg_match("/^{$mod_basename}(?:_(\d+))?$/", $mod_dirname, $matches)) {
	$suffix = (empty($matches[1])) ? '' : "_{$matches[1]}";
} else {
	cpg_error('<strong>'._ERR_FATALCONFIG."</strong><br /><br />\n"
		."The module installation directory, <nobr>\"{$mod_dirname}\"</nobr>, does not follow the expected instantation syntax of <nobr>\"{$mod_basename}[_<i>&lt;integer&gt;</i>]\"</nobr>.");
}

// REQUIRED: $mod_dirname
// REQUIRED: $suffix
// *********************************************************************


if (!can_admin($mod_dirname)) { die('Access Denied'); }


function content_save($edit) {
	global $db, $prefix, $suffix, $op, $mod_dirname, $CPG_SESS;
	$cid = intval($_POST['cid']);
	$title = Fix_Quotes($_POST['title']);
	$subtitle = Fix_Quotes($_POST['subtitle']);
	$active = intval($_POST['active']);
	$language = Fix_Quotes($_POST['language']);

	if ((isset($_SESSION['WYSIWYG']) && ($_SESSION['WYSIWYG'] == 'bbcode')) || (isset($CPG_SESS['wysiwyg']) && ($CPG_SESS['wysiwyg'] == 'bbcode'))) {
		require_once(CORE_PATH.'nbbcode.php');
		$page_header = Fix_Quotes(BBCode::decode(BBCode::encode($_POST['page_header']), TRUE, TRUE));
		$text = Fix_Quotes(BBCode::decode(BBCode::encode($_POST['text']), TRUE, TRUE));
		$page_footer = Fix_Quotes(BBCode::decode(BBCode::encode($_POST['page_footer']), TRUE, TRUE));
		$signature = Fix_Quotes(BBCode::decode(BBCode::encode($_POST['signature']), TRUE, TRUE));
	} else {
		$page_header = Fix_Quotes($_POST['page_header']);
		$text = Fix_Quotes($_POST['text']);
		$page_footer = Fix_Quotes($_POST['page_footer']);
		$signature = Fix_Quotes($_POST['signature']);
	}

	if ($edit) {
		$pid = intval($_POST['pid']);
		$db->sql_query("UPDATE {$prefix}_pages{$suffix}
			SET cid='$cid', title='$title', subtitle='$subtitle', active='$active', page_header='$page_header', text='$text', page_footer='$page_footer', signature='$signature', language='$language'
			WHERE pid='$pid'", FALSE);
	} else {
		$db->sql_query("INSERT INTO {$prefix}_pages{$suffix}
			SET cid='$cid', title='$title', subtitle='$subtitle', active='$active', page_header='$page_header', text='$text', page_footer='$page_footer', signature='$signature', date=now(), counter='0', language='$language'", FALSE);
	}

	// Invalidate block menu cache.
	Cache::array_delete('menu', $mod_dirname);

	url_redirect(adminlink($op));
}

function content_delete() {
	global $db, $prefix, $suffix, $op, $mod_dirname;
	$pid = intval($_GET['pid']);

	if (isset($_POST['confirm'])) {
		$db->sql_query("DELETE FROM {$prefix}_pages{$suffix}
			WHERE pid='$pid'", FALSE);

		// Invalidate block menu cache.
		Cache::array_delete('menu', $mod_dirname);

		// Autoreturn back to the calling page.
		url_redirect(adminlink($op));
	} else if (isset($_POST['cancel'])) {
		// Autoreturn back to the calling page.
		url_redirect(adminlink($op));
	} else {
		require('header.php');
		GraphicAdmin('_AMENU5');

		$result = $db->sql_query("SELECT title FROM {$prefix}_pages{$suffix}
			WHERE pid='$pid'", FALSE);
		list($title) = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		OpenTable();

		echo '<center><b>'._DELCONTENT.': '.$title."</b><br /><br />\n"
			.sprintf(_DELCONTWARNING, $title)."<br /><br />\n"
			."<div style=\"display:inline\">\n"
			.'<form style="display:inline;margin:0" action="'.adminlink("&amp;mode=content_delete&amp;pid=$pid").'" method="post" enctype="multipart/form-data" accept-charset="utf-8">'
			.'<input type="submit" name="confirm" value="'._YES."\" class=\"mainoption\" />\n"
			.'<input type="submit" name="cancel" value="'._NO."\" class=\"liteoption\" />\n"
			."</form>\n"
			."</div>\n</center>\n";

		CloseTable();
		require('footer.php');
	}
}

function content_change_status() {
	global $db, $prefix, $suffix, $op, $mod_dirname;
	$pid = intval($_GET['pid']);
	$active = intval($_GET['active']);

	$active = ($active == 0) ? 1 : 0;

	$db->sql_query("UPDATE {$prefix}_pages{$suffix}
		SET active='$active'
		WHERE pid='$pid'", FALSE);

	// Invalidate block menu cache.
	Cache::array_delete('menu', $mod_dirname);

	// Autoreturn back to the calling page - could be content listing or content admin
	(isset($_SERVER['HTTP_REFERER'])) ? url_redirect($_SERVER['HTTP_REFERER']) : url_redirect(adminlink($op));
}

function content_manager() {
	global $db, $prefix, $suffix, $mod_dirname, $bgcolor1, $bgcolor2, $bgcolor3, $op, $multilingual, $language;

	// Load the required WYSIWYG class.
	require(CORE_PATH.'wysiwyg/wysiwyg.inc');

	// Create required WYSIWYG instances.
	$wysiwyg_page_header = new Wysiwyg('content_save', 'page_header', '90%', '80px', '');
	$wysiwyg_text = new Wysiwyg('content_save', 'text', '90%', '300px', '');
	$wysiwyg_page_footer = new Wysiwyg('content_save', 'page_footer', '90%', '80px', '');
	$wysiwyg_signature = new Wysiwyg('content_save', 'signature', '90%', '80px', '');

	// Set all the required WYSIWYG headers.
	$wysiwyg_page_header->setHeader();

	require('header.php');
	GraphicAdmin('_AMENU5');
	OpenTable();

	content_admin_menu('content_manager');
	echo "<hr />\n<br />\n"
		.'<span class="genmed"><strong>'._PAGES."</strong></span><br />\n"
		."Manage and create content pages.<br /><br />\n";

	// Content Page Management
	$result = $db->sql_query("SELECT pages.pid, pages.title, pages.subtitle, pages.active, cats.title category, pages.language FROM {$prefix}_pages{$suffix} pages
		LEFT JOIN {$prefix}_pages_categories{$suffix} cats
		ON pages.cid=cats.cid
		ORDER BY cats.title, pages.title", FALSE);

	if ($db->sql_numrows($result) > 0) {
		echo "<table border=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"$bgcolor1\">\n<tr bgcolor=\"$bgcolor2\">"		
			.'<td width="20"><b>'._ACTIVE.'</b></td>'
			.'<td><b>'._TITLE.'</b></td>'
			.'<td width="100"><b>'._CATEGORY.'</b></td>'
			.'<td width="100"><b>'._LANGUAGE.'</b></td>'
			.'<td width="100"><b>'._FUNCTIONS."</b></td></tr>\n";
		$row_bgcolor = $bgcolor3;
		while ($mypages = $db->sql_fetchrow($result, MYSQL_ASSOC)) {
			$row_bgcolor = ($row_bgcolor == '') ? " bgcolor=\"$bgcolor3\"" : '';
			echo "<tr{$row_bgcolor}>";
			echo '<td style="text-align:center;vertical-align:top">';
			if ($mypages['active'] == 1) {
				echo '<a href="'.adminlink("&amp;mode=content_change_status&amp;pid={$mypages['pid']}&amp;active=1").'">'
					.'<img src="images/checked.gif" alt="'._ACTIVE.'" title="'._DEACTIVATE.'" border="0" /></a></td>';
			} else {
				echo '<a href="'.adminlink("&amp;mode=content_change_status&amp;pid={$mypages['pid']}&amp;active=0").'">'
					.'<img src="images/unchecked.gif" alt="'._INACTIVE.'" title="'._ACTIVATE.'" border="0" /></a></td>';
			}
			echo '<td style="vertical-align:top"><a href="'.getlink("{$mod_dirname}&amp;pid={$mypages['pid']}")."\">{$mypages['title']}</a>"
				.((empty($mypages['subtitle'])) ? '' : "<br /><span style=\"font-size:85%\"><i>{$mypages['subtitle']}</i></span>").'</td>'
				.'<td style="vertical-align:top">'.((empty($mypages['category'])) ? '<i>'._NONE.'</i>' : $mypages['category']).'</td>'
				."<td style=\"vertical-align:top\">{$mypages['language']}</td>"
				.'<td style="vertical-align:top">[&nbsp;<a href="'.adminlink("&amp;mode=content_edit&amp;pid={$mypages['pid']}").'">'._EDIT.'</a>&nbsp;| '
				.'<a href="'.adminlink("&amp;mode=content_delete&amp;pid={$mypages['pid']}").'">'._DELETE.'</a>&nbsp;]'
				."</td></tr>\n";
		}
		echo "</table><br />\n<hr />\n<br />\n";
	}
	$db->sql_freeresult($result);

	// Add a New Page form.
	echo '<form name="wysiwyg" action="'.adminlink($op).'" method="post">'
		.'<span class="genmed">'._WYSIWYGED.':&nbsp;'.$wysiwyg_page_header->getSelect()."</span></form>\n";

	echo open_form(adminlink('&amp;mode=content_save'), 'content_save', _ADDANEWPAGE);
	echo "<table border=\"0\" cellpadding=\"3\" cellspacing=\"1\" width=\"100%\" class=\"forumline\" align=\"center\">\n"
		.'<tr><td class="row1"><span class="gen">'._TITLE.'</span></td>'
		.'<td class="row2"><input type="text"  id="title" name="title" size="90%" value="'.htmlprepare($mypages['title'])."\" /></td></tr>\n";
	// Retrieve content categories.
	$categories = array();
	list_cat_recursive($categories);
	$catlist = '';
	foreach ($categories as $cat) {
		$catlist .= "<option value=\"{$cat['cid']}\">".str_repeat('&nbsp;&nbsp;', $cat['level']).$cat['title'].'</option>';
	}
	echo '<tr><td class="row1"><span class="gen">'._CATEGORY.'</span></td>'
		.'<td class="row2"><select id="cid" name="cid">'
		.'<option value="0" selected="selected">&lt;'._NONE."&gt;</option>$catlist"
		."</select></td></tr>\n";
	echo '<tr><td class="row1"><span class="gen">'._CSUBTITLE.'</span></td>'
		.'<td class="row2"><input type="text" id="subtitle" name="subtitle" size="90%" value="'.htmlprepare($mypages['subtitle'])."\" /></td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._HEADERTEXT.'</span></td>'
		.'<td class="row2">'.$wysiwyg_page_header->getHTML()."</td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._PAGETEXT.'</span></td>'
		.'<td class="row2">'.$wysiwyg_text->getHTML().'<br />'
		.'<font class="tiny">'._PAGEBREAK."</font></td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._FOOTERTEXT.'</span></td>'
		.'<td class="row2">'.$wysiwyg_page_footer->getHTML()."</td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._SIGNATURE.'</span></td>'
		.'<td class="row2">'.$wysiwyg_signature->getHTML()."</td></tr>\n";
	if ($multilingual) {
		echo '<tr><td class="row1"><span class="gen">'._LANGUAGE.'</span></td>'
		.'<td class="row2">'.lang_selectbox($mypages['language'], 'language')."</td></tr>\n";
	}
	echo '<tr><td class="row1"><span class="gen">'._ACTIVATEPAGE.'</span></td>'
		.'<td class="row2">'.yesno_option('active', $mypages['active'])."</td></tr>\n"
		.'<tr><td class="catbottom" colspan="2" align="center" height="28">';
	if (!$multilingual) {
		echo '<input type="hidden" name="language" value="'.$language."\" />\n";
	}
	echo '<input type="submit" value="'._SAVEPAGE."\" class=\"mainoption\" /></td></tr>\n";
	echo "</table>\n";
	echo close_form();

	echo "<br />\n";

	CloseTable();
	require('footer.php');
}

function content_edit() {
	global $db, $prefix, $suffix, $multilingual, $language;
	$pid = isset($_GET['pid']) ? intval($_GET['pid']) : (isset($_POST['pid']) ? intval($_POST['pid']) : '');

	// Retrieve content to edit.
	$result = $db->sql_query("SELECT * FROM {$prefix}_pages{$suffix}
		WHERE pid='$pid'", FALSE);
	$mypages = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);

	// Load the required WYSIWYG class.
	require(CORE_PATH.'wysiwyg/wysiwyg.inc');

	// Create required WYSIWYG instances.
	$wysiwyg_page_header = new Wysiwyg('content_save_edit', 'page_header', '90%', '80px', $mypages['page_header']);
	$wysiwyg_text = new Wysiwyg('content_save_edit', 'text', '90%', '300px', $mypages['text']);
	$wysiwyg_page_footer = new Wysiwyg('content_save_edit', 'page_footer', '90%', '80px', $mypages['page_footer']);
	$wysiwyg_signature = new Wysiwyg('content_save_edit', 'signature', '90%', '80px', $mypages['signature']);

	// Set all the required WYSIWYG headers.
	$wysiwyg_page_header->setHeader();

	require('header.php');
	GraphicAdmin('_AMENU5');
	OpenTable();

	echo '<form name="wysiwyg" action="'.adminlink("&amp;mode=content_edit&amp;pid=$pid").'" method="post" enctype="multipart/form-data" accept-charset="utf-8">'
		.'<span class="genmed">'._WYSIWYGED.':&nbsp;'.$wysiwyg_page_header->getSelect()."</span></form>\n";

	echo open_form(adminlink('&amp;mode=content_save_edit'), 'content_save_edit', _EDITPAGECONTENT);
	echo "<table border=\"0\" cellpadding=\"3\" cellspacing=\"1\" width=\"100%\" class=\"forumline\" align=\"center\">\n"
		.'<tr><td class="row1"><span class="gen">'._TITLE.'</span></td>'
		.'<td class="row2"><input type="text"  id="title" name="title" size="90%" value="'.htmlprepare($mypages['title'])."\" /></td></tr>\n";
	// Retrieve content categories.
	$categories = array();
	list_cat_recursive($categories);
	$catlist = '<option value="0"'.(($mypages['cid'] == 0) ? ' selected="selected"' : '').'>&lt;'._NONE."&gt;</option>";
	foreach ($categories as $cat) {
		$catlist .= "<option value=\"{$cat['cid']}\"".(($mypages['cid'] == $cat['cid']) ? ' selected="selected"' : '').'>'.str_repeat('&nbsp;&nbsp;', $cat['level']).$cat['title'].'</option>';
	}
	echo '<tr><td class="row1"><span class="gen">'._CATEGORY.'</span></td>'
		."<td class=\"row2\"><select id=\"cid\" name=\"cid\">$catlist</select></td></tr>\n";
	echo '<tr><td class="row1"><span class="gen">'._CSUBTITLE.'</span></td>'
		.'<td class="row2"><input type="text" id="subtitle" name="subtitle" size="90%" value="'.htmlprepare($mypages['subtitle'])."\" /></td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._HEADERTEXT.'</span></td>'
		.'<td class="row2">'.$wysiwyg_page_header->getHTML()."</td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._PAGETEXT.'</span></td>'
		.'<td class="row2">'.$wysiwyg_text->getHTML().'<br />'
		.'<font class="tiny">'._PAGEBREAK."</font></td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._FOOTERTEXT.'</span></td>'
		.'<td class="row2">'.$wysiwyg_page_footer->getHTML()."</td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._SIGNATURE.'</span></td>'
		.'<td class="row2">'.$wysiwyg_signature->getHTML()."</td></tr>\n";
	if ($multilingual) {
		echo '<tr><td class="row1"><span class="gen">'._LANGUAGE.'</span></td>'
		.'<td class="row2">'.lang_selectbox($mypages['language'], 'language')."</td></tr>\n";
	}
	echo '<tr><td class="row1"><span class="gen">'._ACTIVATEPAGE.'</span></td>'
		.'<td class="row2">'.yesno_option('active', $mypages['active'])."</td></tr>\n"
		.'<tr><td class="catbottom" colspan="2" align="center" height="28">'
		.'<input type="hidden" name="pid" value="'.$pid."\" />\n";
	if (!$multilingual) {
		echo '<input type="hidden" name="language" value="'.$language."\" />\n";
	}
	echo '<input type="submit" value="'._SAVECHANGES."\" class=\"mainoption\" /></td></tr>\n";
	echo "</table>\n";
	echo close_form();

	echo "<br />\n";

	CloseTable();
	require('footer.php');
}

function category_save($edit) {
	global $db, $prefix, $suffix, $language, $mod_dirname;

	$cat_title = Fix_Quotes($_POST['cat_title']);
	$description = Fix_Quotes($_POST['description']);
	$parentcid = intval($_POST['parentcid']);
	$language = Fix_Quotes($_POST['language']);

	if ($edit) {
		$cid = intval($_POST['cid']);
		$parentcid = ($parentcid == $cid) ? 0 : $parentcid;
		$db->sql_query("UPDATE {$prefix}_pages_categories{$suffix}
			SET title='$cat_title', description='$description', parentcid='$parentcid', language='$language'
			WHERE cid='$cid'", FALSE);
	} else {
		$parentcid = ($parentcid == $cid) ? 0 : $parentcid;
		$db->sql_query("INSERT INTO {$prefix}_pages_categories{$suffix}
			VALUES (NULL, '$cat_title', '$description', '$parentcid', '$language')", FALSE);
	}

	// Invalidate category cache.
	Cache::array_delete('categories', $mod_dirname);
	// Invalidate block menu cache.
	Cache::array_delete('menu', $mod_dirname);

	url_redirect(adminlink('&amp;mode=cat_manager'));
}

function category_delete() {
	global $db, $prefix, $suffix, $mod_dirname;
	$cid = intval($_GET['cid']);

	if (isset($_POST['confirm'])) {
		$db->sql_query("DELETE FROM {$prefix}_pages_categories{$suffix}
			WHERE cid='$cid'", FALSE);
		// Set cid of matching pages to "0" (uncategorized).
		$result = $db->sql_query("SELECT pid FROM {$prefix}_pages{$suffix}
			WHERE cid='$cid'", FALSE);
		while (list($pid) = $db->sql_fetchrow($result)) {
			$pid = intval($pid);
			$db->sql_query("UPDATE {$prefix}_pages{$suffix}
				SET cid='0'
				WHERE pid='$pid'", FALSE);
		}
		$db->sql_freeresult($result);
		// Set parentcid of matching categories to "0" (top level).
		$result = $db->sql_query("SELECT parentcid FROM {$prefix}_pages_categories{$suffix}
			WHERE parentcid='$cid'", FALSE);
		while (list($parentcid) = $db->sql_fetchrow($result)) {
			$parentcid = intval($parentcid);
			$db->sql_query("UPDATE {$prefix}_pages_categories{$suffix}
				SET parentcid='0'
				WHERE parentcid='$parentcid'", FALSE);
		}
		$db->sql_freeresult($result);

		// Invalidate category cache.
		Cache::array_delete('categories', $mod_dirname);
		// Invalidate block menu cache.
		Cache::array_delete('menu', $mod_dirname);

		// Autoreturn back to the calling page.
		url_redirect(adminlink('&amp;mode=cat_manager'));
	} else if (isset($_POST['cancel'])) {
		// Autoreturn back to the calling page.
		url_redirect(adminlink('&amp;mode=cat_manager'));
	} else {
		require('header.php');
		GraphicAdmin('_AMENU5');

		$result = $db->sql_query("SELECT title FROM {$prefix}_pages_categories{$suffix}
			WHERE cid='$cid'", FALSE);
		list($title) = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		OpenTable();

		echo '<center><b>'._DELCATEGORY.": $title</b><br /><br />\n"
			.sprintf(_DELCONTENTCAT, $title)."<br /><br />\n"
			."<div style=\"display:inline\">\n"
			.'<form style="display:inline;margin:0" action="'.adminlink("&amp;mode=category_delete&amp;cid=$cid").'" method="post" enctype="multipart/form-data" accept-charset="utf-8">'
			.'<input type="submit" name="confirm" value="'._YES."\" class=\"mainoption\" />\n"
			.'<input type="submit" name="cancel" value="'._NO."\" class=\"liteoption\" />\n"
			."</form>\n"
			."</div>\n</center>\n";

		CloseTable();
		require('footer.php');
	}
}

function category_edit() {
	global $db, $prefix, $suffix, $language, $multilingual;
	$cid = intval($_GET['cid']);

	require('header.php');
	GraphicAdmin('_AMENU5');

	OpenTable();

	$result = $db->sql_query("SELECT title, description, parentcid, language FROM {$prefix}_pages_categories{$suffix}
		WHERE cid='$cid'", FALSE);
	list($title, $description, $parentcid, $language) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	echo open_form(adminlink('&amp;mode=category_save_edit'), 'category_save_edit', _EDITCATEGORY);
	echo "<table border=\"0\" cellpadding=\"3\" cellspacing=\"1\" width=\"100%\" class=\"forumline\" align=\"center\">\n"
		.'<tr><td class="row1"><span class="gen">'._TITLE.'</span></td>'
		.'<td class="row2"><input type="text" name="cat_title" value="'.htmlprepare($title)."\" size=\"50\" /></td></tr>\n";
	// Retrieve content categories.
	$categories = array();
	list_cat_recursive($categories);
	$catlist = '<option value="0"'.(($parentcid == 0) ? ' selected="selected"' : '').'>&lt;'._NONE."&gt;</option>";
	foreach ($categories as $cat) {
		$catlist .= "<option value=\"{$cat['cid']}\"".(($parentcid == $cat['cid']) ? ' selected="selected"' : '').'>'.str_repeat('&nbsp;&nbsp;', $cat['level']).$cat['title'].'</option>';
	}
	echo '<tr><td class="row1"><span class="gen">'._CATEGORY.'</span></td>'
		."<td class=\"row2\"><select id=\"parentcid\" name=\"parentcid\">$catlist</select></td></tr>\n";
	echo '<tr><td class="row1"><span class="gen">'._DESCRIPTION.'</span></td>'
		.'<td class="row2"><textarea cols="50" rows="10" name="description">'.htmlprepare($description)."</textarea></td></tr>\n";
	if ($multilingual) {
		echo '<tr><td class="row1"><span class="gen">'._LANGUAGE.'</span></td>'
		.'<td class="row2">'.lang_selectbox($mypages['language'], 'language')."</td></tr>\n";
	}
	echo '<tr><td class="catbottom" colspan="2" align="center" height="28">'
		.'<input type="hidden" name="cid" value="'.$cid."\" />\n";
	if (!$multilingual) {
		echo '<input type="hidden" name="language" value="'.$language."\" />\n";
	}
	echo '<input type="submit" value="'._SAVECHANGES.'" class="mainoption" />&nbsp;&nbsp;'
		.'[&nbsp;<a href="'.adminlink("&amp;mode=category_delete&amp;cid=$cid").'">'._DELETE."</a>&nbsp;]</td></tr>\n";
	echo "</table>\n";
	echo close_form();
	echo "<br />\n";

	CloseTable();
	require('footer.php');
}

function category_trans() {
	global $db, $prefix, $suffix, $mod_dirname;
	$cidfrom = intval($_POST['cidfrom']);
	$cidto = intval($_POST['cidto']);

	$db->sql_query("UPDATE {$prefix}_pages{$suffix}
		SET cid='$cidto'
		WHERE cid='$cidfrom'", FALSE);

	// Invalidate block menu cache.
	Cache::array_delete('menu', $mod_dirname);

	url_redirect(adminlink('&amp;mode=cat_manager'));
}

function cat_manager() {
	global $db, $prefix, $suffix, $mod_dirname, $bgcolor1, $bgcolor2, $bgcolor3, $language, $multilingual;

	require('header.php');
	GraphicAdmin('_AMENU5');
	OpenTable();

	content_admin_menu('cat_manager');
	echo "<hr />\n<br />\n"
		.'<span class="genmed"><strong>'._CATEGORIES."</strong></span><br />\n"
		."Manage categories and their subcategories in which various content pages will be filed.<br /><br />\n";

	// Category Management
	$categories = array();
	list_cat_recursive($categories);
	$catlist = '';
	if (count($categories)) {
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"$bgcolor1\">\n<tr bgcolor=\"$bgcolor2\">"		
			.'<td><b>'._CATEGORY.'</b></td>'
			.'<td width="100" align="center"><b>'._PAGES.'</b></td>'
			.'<td width="100"><b>'._FUNCTIONS."</b></td></tr>\n";
		$row_bgcolor = $bgcolor3;
		foreach ($categories as $cat) {
			$catlist .= "<option value=\"{$cat['cid']}\">".str_repeat('&nbsp;&nbsp;', $cat['level']).$cat['title'].'</option>';
			$row_bgcolor = ($row_bgcolor == '') ? " bgcolor=\"$bgcolor3\"" : '';
			echo "<tr{$row_bgcolor}>"
				."<td>{$cat['crumb']}&nbsp;"
				.'<span title="'.str_replace('"', '\"', strip_tags($cat['description'])).'"><a href="'.getlink('&amp;cid='.$cat['cid']).'">'.$cat['title'].'</a></span></td>'
				."<td align=\"center\">".$db->sql_count("{$prefix}_pages{$suffix}", "cid={$cat['cid']}").'</td>'
				."<td>[&nbsp;<a href=\"".adminlink("&amp;mode=category_edit&amp;cid={$cat['cid']}").'">'._EDIT.'</a>&nbsp;| '
				.'<a href="'.adminlink("&amp;mode=category_delete&amp;cid={$cat['cid']}").'">'._DELETE.'</a>&nbsp;]</td>'
				."</tr>\n";
		}
		echo "</table><br />\n<hr />\n<br />\n";
	}

	// Add a New Category form.
	echo open_form(adminlink('&amp;mode=category_save'), 'category_save', _ADDCATEGORY);
	echo "<table border=\"0\" cellpadding=\"3\" cellspacing=\"1\" width=\"100%\" class=\"forumline\" align=\"center\">\n"
		.'<tr><td class="row1"><span class="gen">'._TITLE.'</span></td>'
		."<td class=\"row2\"><input type=\"text\" id=\"cat_title\" name=\"cat_title\" size=\"50\" /></td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._CATEGORY.'</span></td>'
		.'<td class="row2"><select id="parentcid" name="parentcid">'
		.'<option value="0" selected="selected">&lt;'._NONE."&gt;</option>$catlist"
		."</select></td></tr>\n"
		.'<tr><td class="row1"><span class="gen">'._DESCRIPTION.'</span></td>'
		."<td class=\"row2\"><textarea id=\"description\" name=\"description\" rows=\"10\" cols=\"50\"></textarea></td></tr>\n";
	if ($multilingual) {
		echo '<tr><td class="row1"><span class="gen">'._LANGUAGE.'</span></td>'
		.'<td class="row2">'.lang_selectbox($mypages['language'], 'language')."</td></tr>\n";
	}
	echo '<tr><td class="catbottom" colspan="2" align="center" height="28">';
	if (!$multilingual) {
		echo '<input type="hidden" name="language" value="'.$language."\" />\n";
	}
	echo '<input type="submit" value="'._ADD."\" class=\"mainoption\" /></td></tr>\n";
	echo "</table>\n";
	echo close_form();
	echo "<br /><br />\n";

	// Transfer Pages to Another Category form.
	echo open_form(adminlink('&amp;mode=category_trans'), 'category_trans', _TRANSCATEGORY);
	echo "<table border=\"0\" cellpadding=\"3\" cellspacing=\"1\" width=\"100%\" class=\"forumline\" align=\"center\">\n"
		.'<tr><td class="row1" width="100"><span class="gen">'._TRANSFROM.'</span></td>'
		."<td class=\"row2\"><select id=\"cidfrom\" name=\"cidfrom\">$catlist</select></td></tr>\n"
		.'<tr><td class="row1" width="100"><span class="gen">'._TRANSTO.'</span></td>'
		."<td class=\"row2\"><select id=\"cidto\" name=\"cidto\">$catlist</select></td></tr>\n"
		.'<tr><td class="catbottom" colspan="2" align="center" height="28">'
		.'<input type="submit" value="'._TRANS."\" class=\"mainoption\" /></td></tr>\n"
		."</table>\n";
	echo close_form();
	echo "<br />\n";

	CloseTable();
	require('footer.php');
}


require_once("modules/{$mod_dirname}/functions/display.inc");
require_once("modules/{$mod_dirname}/functions/categories.inc");

// Set page title.
global $pagetitle;
$pagetitle .= ' '._BC_DELIM.' '._ContentLANG.$suffix;

// *************************** Mode Select *****************************
$mode = isset($_POST['mode']) ? $_POST['mode'] : (isset($_GET['mode']) ? $_GET['mode'] : '');
switch ($mode) {
	// Content
	case 'content_save':
		content_save();
		break;
	case 'content_save_edit':
		content_save(TRUE);
		break;
	case 'content_delete':
		content_delete();
		break;
	case 'content_change_status':
		content_change_status();
		break;
	case 'content_edit':
		content_edit();
		break;

	// Categories
	case 'cat_manager':
		cat_manager();
		break;
	case 'category_save':
		category_save();
		break;
	case 'category_save_edit':
		category_save(TRUE);
		break;
	case 'category_delete':
		category_delete();
		break;
	case 'category_edit':
		category_edit();
		break;
	case 'category_trans':
		category_trans();
		break;

	default:
		content_manager();
		break;
}