<?php
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Content Menu Block
  Copyright (C) 2005-2007 by Dark Grue

  Block for the Content Module that lists Content categories in a
  collapsible JavaScript menu. State is retained between page loads
  using cookies and state is validated using a hash function.

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: blocks/block-Content_Menu.php $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/
if (!defined('CPG_NUKE')) { exit; }


// ************************* Display Settings **************************
// expand_all:	Menu starts fully open; overrides $displaydepth setting.
//			TRUE - Start menu with all branches open.
//			FALSE - Start menu with all branches collapsed. (Default)
$expand_all = FALSE;

// displaydepth:	How many levels deep to expose subcategories.
$displaydepth = 0;


// *********************** Module Instantiation ************************
// This block can reference alternative instances of its associated
// module by adding an underscore followed by an integer to the name of
// the file (e.g. "block-Content_Menu_2.php"). The block will
// detect this and automagically configure itself.
//
// NOTE:
//	The block will check $blk_basename against its filename.
//	Modules that this block references MUST be configured separately
//	to create/reference the new instance.
$blk_basename = 'block-Content_Menu';
$blk_filename = basename(__FILE__);
$mod_basename = 'Content';

$matches = array();
if (preg_match("/^{$blk_basename}(?:_(\d+))?\.php$/", $blk_filename, $matches)) {
	$suffix = (empty($matches[1])) ? '' : "_{$matches[1]}";
	$mod_dirname = $mod_basename.$suffix;
} else {
	$content = 'ERROR';
	return trigger_error("The block filename, <nobr>\"{$blk_filename}\"</nobr>, does not follow the expected instantation syntax of <nobr>\"{$blk_basename}[_<i>&lt;integer&gt;</i>].php\"</nobr>.", E_USER_WARNING);
}

// REQUIRED: $mod_dirname
// REQUIRED: $suffix
// *********************************************************************


if (empty($mod_dirname) || !file_exists(CORE_PATH."../modules/{$mod_dirname}")) {
	$content = 'ERROR';
	return trigger_error('The expected module directory'.((empty($mod_dirname)) ? '' : ", \"{$mod_dirname}\",").' does not exist.', E_USER_WARNING);
}

if (!is_active($mod_dirname)) {
	$content = 'ERROR';
	return trigger_error("The {$mod_dirname} module is inactive.", E_USER_WARNING);
}

// Retrieve menu cache.
if ($menu = Cache::array_load('menu', $mod_dirname, FALSE)) {
	$content = $menu[0];

	return;
}

global $db, $prefix;
$bid = (isset($block['bid'])) ? $block['bid'] : intval($bid);

$content = '';
$acc = NULL;

// Retrieve active categorized content.
$result = $db->sql_query("SELECT cid, pid, title FROM {$prefix}_pages{$suffix} WHERE active='1' AND cid!='0' ORDER BY title", FALSE);
while (list($cid, $pid, $ptitle) = $db->sql_fetchrow($result)) {
	$acc[$cid][$pid] = $ptitle;
}
$db->sql_freeresult($result);

if (count($acc) != 0) {
	// Avoid polluting the JavaScript namespace by prefixing the
	// function name with the Block ID.
	$content = "\n".'<script language="JavaScript" type="text/javascript">
<!-- Hide script from old browsers.
function bid'.$bid.'_togglelist(img) {
  var ulReturn=img.parentNode.parentNode.parentNode.parentNode.parentNode.getElementsByTagName("ul");

  if (ulReturn[0].style.display == "none") {
    img.src="modules/'.$mod_dirname.'/images/blocks/open.gif";
    ulReturn[0].style.display= "block";
  } else {
    img.src="modules/'.$mod_dirname.'/images/blocks/closed.gif";
    ulReturn[0].style.display= "none";
  }
}
// End -->
</script>'."\n";

	// Retrieve menu.
	eval("function bid{$bid}_list_menu_recursive(&\$content, \$parent = 0, \$depth = 0) {
		global \$db, \$prefix;

		// Retrieve content categories.
		\$result = \$db->sql_query(\"SELECT cid, title, description FROM {\$prefix}_pages_categories{$suffix}
			WHERE parentcid={\$parent}
			ORDER BY title\", FALSE);
		\$numrows = \$db->sql_numrows(\$result);
		\$menuitems = '';
		\$crumb = str_repeat('  ', \$depth);
		if (\$numrows) {
			for (\$i = 0; \$i < \$numrows; \$i++) {
				\$row = \$db->sql_fetchrow(\$result, SQL_ASSOC);

				// Recursively fetch subcategories
				\$rowitems = bid{$bid}_list_menu_recursive(\$content, \$row['cid'], (\$depth + 1));

				if (isset(\$content[\$row['cid']]) && count(\$content[\$row['cid']])) {
					// Print list of active article titles in this category.
					foreach (\$content[\$row['cid']] as \$pid => \$ptitle) {
						\$rowitems .= \"\$crumb    <li><img src=\\\"modules/{$mod_dirname}/images/blocks/arrow.gif\\\" width=\\\"9\\\" height=\\\"9\\\" border=\\\"0\\\" alt=\\\"\\\" />&nbsp;<a href=\\\"\".getlink(\"{$mod_dirname}&amp;pa=showpage&amp;pid={\$pid}\").\"\\\">\$ptitle</a></li>\n\";
					}
				}

				// Skip truly empty subcategories (no content or subcategories).
				if (!empty(\$rowitems)) {
					\$menuitems .= \$crumb.'  <li><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td valign=\"top\">'
						.\"<img src=\\\"modules/{$mod_dirname}/images/blocks/\".((".(int)$expand_all." || (\$depth < $displaydepth)) ? 'open' : 'closed').\".gif\\\" onclick=\\\"bid{$bid}_togglelist(this)\\\" style=\\\"border:0;margin:2px 3px 0 0;width:9px;height:9px;\\\" alt=\\\"\\\" /></td>\"
						.\"<td><b><a href=\\\"\".getlink(\"{$mod_dirname}&amp;pa=category&amp;cid={\$row['cid']}\").\"\\\">{\$row['title']}</a></b></td></tr></table>\n\"
						.\"\$crumb  <ul style=\\\"\".((".(int)$expand_all." || (\$depth < $displaydepth)) ? '' : 'display:none;').\"list-style:none;margin:3px 0 0 10px;padding:0\\\" class=\\\"bid{$bid}_foldinglist\\\">\n\"
						.\$rowitems
						.\"\$crumb  </ul>\n\"
						.\"\$crumb  </li>\n\";
				}
			}

			// Skip truly empty categories (no content or subcategories).
			if (!empty(\$menuitems) && (\$depth == 0)) {
				\$menuitems = \"<ul style=\\\"list-style:none;margin:3px 0 0 0px;padding:0\\\">\n\"
					.\$menuitems
					.\"</ul>\n\";
			}
		}
		\$db->sql_freeresult(\$result);

		return \$menuitems;
	}");
	$func = "bid{$bid}_list_menu_recursive";
	$menu = $func($acc);
	$content .= $menu.((empty($menu)) ? '' : "<br />\n");

	// Take a MD5 hash of the content up to this point so we can tell if the
	// menu has changed between page loads. If it has, we can't restore the
	// menu state.
	$contenthash = md5($content);

	// Avoid polluting the JavaScript namespace by prefixing the
	// function name with the Block ID.
	$content .= "\n".'<script language="JavaScript" type="text/javascript">
<!-- Hide script from old browsers.

function bid'.$bid.'_getCookie(name) {
  // Get cookie routine by Shelley Powers.
  var search = name + "=";

  if (document.cookie.length > 0) {
    offset = document.cookie.indexOf(search);
    // If cookie exists...
    if (offset != -1) { 
      offset += search.length;
      // Set index of beginning of value.
      end = document.cookie.indexOf(";", offset);
      // Set index of end of cookie value.
      if (end == -1) {
        end = document.cookie.length;
      }

      return unescape(document.cookie.substring(offset, end));
    }
  }

  return null;
}

var bid'.$bid.'_foldinglistarray = new Array();

if (document.getElementsByTagName) {
  // Build array of elements.
  for (i = 0; i < document.getElementsByTagName("ul").length; i++) {
    if (document.getElementsByTagName("ul")[i].className == "bid'.$bid.'_foldinglist") {
      // Append element to list.
      bid'.$bid.'_foldinglistarray = bid'.$bid.'_foldinglistarray.concat(document.getElementsByTagName("ul")[i]);
    }
  }
}

// Restore menu state.
if (bid'.$bid.'_foldinglistarray.length) {
  if (bid'.$bid.'_getCookie("bid'.$bid.'_ContentHash") == "'.$contenthash.'") {
    if (bid'.$bid.'_getCookie("bid'.$bid.'_ContentMenu") != null) {
      var opennodes = bid'.$bid.'_getCookie("bid'.$bid.'_ContentMenu").split(" ");

      // Build index key for open nodes.
      var index = new Array();
      for (i = 0; i < opennodes.length; i++) {
	index[opennodes[i]] = true;
      }

      for (i = 0; i < bid'.$bid.'_foldinglistarray.length; i++) {
        if (index[i]) {
          // Set block open.
          bid'.$bid.'_foldinglistarray[i].style.display = "block";
          bid'.$bid.'_foldinglistarray[i].parentNode.firstChild.firstChild.firstChild.firstChild.firstChild.src = "modules/'.$mod_dirname.'/images/blocks/open.gif";
        } else {
          // Set block closed.
          bid'.$bid.'_foldinglistarray[i].style.display = "none";
          bid'.$bid.'_foldinglistarray[i].parentNode.firstChild.firstChild.firstChild.firstChild.firstChild.src = "modules/'.$mod_dirname.'/images/blocks/closed.gif";
        }
      }
    }
  }
}

function bid'.$bid.'_saveState() {
  var opennodes = "";

  for (i = 0; i < bid'.$bid.'_foldinglistarray.length; i++){
    if (bid'.$bid.'_foldinglistarray[i].style.display != "none") {
      opennodes += " " + i;
    }
  }
  document.cookie = "bid'.$bid.'_ContentMenu=" + opennodes + "; path=/";
  document.cookie = "bid'.$bid.'_ContentHash='.$contenthash.'; path=/";
}

// IE doesn\'t support the addEventListener method, so just wrap the
// onunload method to keep compatability with other scripts that
// may be running on the page.
var bid'.$bid.'_oldOnUnload = (window.onunload) ? window.onunload : function () {};
window.onunload = function () { bid'.$bid.'_oldOnUnload(); bid'.$bid.'_saveState(); };
// End -->
</script>';
}

// Retrieve active uncategorized content.
$result = $db->sql_query("SELECT pid, title FROM {$prefix}_pages{$suffix} WHERE active='1' AND cid='0' ORDER BY title", FALSE);
while (list($pid, $ptitle) = $db->sql_fetchrow($result)) {
	// Print list of active article titles in this category.
	$content .= "<img src=\"modules/{$mod_dirname}/images/blocks/arrow.gif\" width=\"9\" height=\"9\" border=\"0\" alt=\"\" />&nbsp;<a href=\"".getlink("{$mod_dirname}&amp;pa=showpage&amp;pid={$pid}").'">'.$ptitle."</a><br />\n";
}
$db->sql_freeresult($result);

if ($content) {
	// Wrap menu in DIV element.
	$content = '<div align="left" style="text-align:left">'.$content.'</div>';

	// Save menu cache.
	Cache::array_save('menu', $mod_dirname, array($content));
} else {
	// Invalidate block menu cache.
	Cache::array_delete('menu', $mod_dirname);

	$content = 'ERROR';
	return trigger_error("Module $mod_dirname returned no content.", E_USER_NOTICE);
}