<?php
/***********************************************************************
  Content (Enhanced) for Dragonfly(TM) CMS
  **********************************************************************
  Content Block
  Copyright (C) 2005-2007 by Dark Grue

  Block for the Content Module that lists Content pages.

  Homepage: http://www.theclenchedfist.com/projects/content/

  $Source: blocks/block-Content.php $
  $Revision: 9.7.11 $
  $Author: darkgrue (darkgrue @ iname.com) $
  $Date: 2007-10-31 $

  Based on:
    Content Module 2.0.1.0
    Copyright (C) 2004-2005 by CPG-Nuke Dev Team
    http://dragonflycms.org

  License:
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307 USA
***********************************************************************/
if (!defined('CPG_NUKE')) { exit; }


// *********************** Module Instantiation ************************
// This block can reference alternative instances of its associated
// module by adding an underscore followed by an integer to the name of
// the file (e.g. "block-Content_2.php"). The block will
// detect this and automagically configure itself.
//
// NOTE:
//	The block will check $blk_basename against its filename.
//	Modules that this block references MUST be configured separately
//	to create/reference the new instance.
$blk_basename = 'block-Content';
$blk_filename = basename(__FILE__);
$mod_basename = 'Content';

$matches = array();
if (preg_match("/^{$blk_basename}(?:_(\d+))?\.php$/", $blk_filename, $matches)) {
	$suffix = (empty($matches[1])) ? '' : "_{$matches[1]}";
	$mod_dirname = $mod_basename.$suffix;
} else {
	$content = 'ERROR';
	return trigger_error("The block filename, <nobr>\"{$blk_filename}\"</nobr>, does not follow the expected instantation syntax of <nobr>\"{$blk_basename}[_<i>&lt;integer&gt;</i>].php\"</nobr>.", E_USER_WARNING);
}

// REQUIRED: $mod_dirname
// REQUIRED: $suffix
// *********************************************************************


if (empty($mod_dirname) || !file_exists(CORE_PATH."../modules/{$mod_dirname}")) {
	$content = 'ERROR';
	return trigger_error('The expected module directory'.((empty($mod_dirname)) ? '' : ", \"{$mod_dirname}\",").' does not exist.', E_USER_WARNING);
}

if (!is_active($mod_dirname)) {
	$content = 'ERROR';
	return trigger_error("The {$mod_dirname} module is inactive.", E_USER_WARNING);
}

global $db, $prefix;

$content = '';

// Retrieve active categorized content.
$result = $db->sql_query("SELECT pid, title FROM {$prefix}_pages{$suffix} WHERE active='1'", FALSE);
while (list($pid, $ptitle) = $db->sql_fetchrow($result)) {
	$content .= "<img src=\"modules/{$mod_dirname}/images/blocks/arrow.gif\" border=\"0\" alt=\"\" />&nbsp;<a href=\"".getlink("{$mod_dirname}&amp;pa=showpage&amp;pid={$pid}")."\">$ptitle</a><br />\n";
}
$db->sql_freeresult($result);