<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/wh_ini.php" );

define( "_DATE_MATCH", "/([0-9]{1,4} [A-Z]{2} [A-Z]{3} [A-Z]{3} [A-Z]{3} [0-9]{1,2} [0-9]{4})/" );

$NOAAMaskZonePath = "http://weather.noaa.gov/pub/data/forecasts/zone/:stabbrev:/:zonefile:.txt";

if(!function_exists('scandir'))
{
  function scandir($directory, $sorting_order=0)
  {
    // php.net/scandir (PHP5)
    if(!is_dir($directory))
	  return FALSE;
		   
    $files = array();
    $fh = opendir($directory);
    while (FALSE !== ($filename = readdir($fh)))
    {
      $files[] = $filename;
    }
    closedir($fh);
	
    if($sorting_order==1)
	  rsort($files);
    else
	  sort($files);
		   
    return $files;
  }
}

/******************************************************************************/
/* function fnCheckWXZoneEntry( $code )                                       */
/* passed variable : $code - corresponds to the code in the weatherstations   */
/* returns true if WXZone is valid for code                                   */
/******************************************************************************/

function fnCheckWXZoneEntry( $code )
{
  global $prefix, $db;

  $return = false;

  $sql = "select fips from ".$prefix."_weatherstations where code='".$code."'";
  $result = $db->sql_query( $sql );

  if ( $result )
  {
    $row = $db->sql_fetchrow( $result );

    if ( strlen( $row['fips'] ) > 0 )
    {
      $return = true;
    }
  }

  $db->sql_freeresult( $result );

  return $return;
}


function fnLatestObstoCache( $latest_obs, $target_file)
{
  global $db, $prefix;
  
  error_reporting(0); //  turn off error reporting, I'm handling for now.

  $old_e_handler = set_error_handler( "WMErrorHandler" );
  
  $wh = new whini();
  
  if ( file_exists($target_file) )
  {
    $NOW = time();
    $LASTUPDATE = filemtime($target_file);
    
    if ($NOW > ($LASTUPDATE + $wh->getcachetimeout()))
	{
	  $return = "";
      $file = fopen($latest_obs, "rb");
	  if ( $file )
	  {
	    while( !feof( $file ) )
	    {
          $return .= fgets($file, 1024);
	    }	
        fclose($file);
	      
	    $file = fopen($target_file, "wb");
        fwrite($file, $return);
        fclose($file);
	  }
	  else
	  {
	    $target_file = "";
	  }	
	}
  }
  else
  {
    $return = "";
    $file = fopen($latest_obs, "rb");
	if ( $file )
	{
	  while( !feof( $file ) )
	  {
        $return .= fgets($file, 1024);
	  }  
      fclose($file);
	
      $file = fopen($target_file, "wb");
      fwrite($file, $return);
      fclose($file);
	}
	else
	{
	  $target_file = "";
	}  
  }
  
  // restore default error handler
  restore_error_handler();
  
  return( $target_file );
}

/******************************************************************************/
/* function fnParseWXZone( $string, $zonename )                               */
/* function to parsse the wxzone string ($string) using the table data in the */
/* array ($zone) matching the weatherzones table                              */
/******************************************************************************/

function fnParseWXZone( $string, $zonename, $getshort )
{
  global $db, $prefix;
  
  $exp_string = fnGetExpires( $string, _EXTENDED_EXPIRES );
  
  $match_pattern = "/^\.{1}([A-Z][A-Z ]*)\.{3}/";
  
  $wh = new whini();
  $daystodisplay = $wh->getefdaysdisplay();
  
  if ( $daystodisplay == "5" )  // this means everything, so set it to a high number
  {
    $daystodisplay = 100;
  }
  
  if ( $getshort == "1" )
  {
    $daystodisplay = 3;
  }
  
  $temp_string = strstr( $string, strtoupper( substr( $zonename, 0, 3 ) ) );
  $temp_string = html_entity_decode( $temp_string );
  $temp_string = ereg_replace( "&&(.*)","",$temp_string);
  $temp_string = ereg_replace( "\\$\\$.*","", $temp_string );
  $temp_string = rtrim( $temp_string );
  // now begin building the table for the data...
  //get string "INCLUDING"
  $including = strstr( $temp_string, strtoupper( "including" ) );
  // if $including == "" check for COASTAL
  if ( $including == "" )
  {
    $including = strstr( $temp_string, strtoupper( "coastal" ) );
  }
  // build including so everything between it and the timestamp is included...
  
	  //get timestamp in following format - 915 AM AST TUE JAN 20 2004
  $timestamp = "";	  
  if ( preg_match( _DATE_MATCH, $temp_string, $buffer ) != 0 )
  {
    $timestamp = $buffer[1];
	// move temp string up to the timestamp...
	$temp_string = strstr( $temp_string, $buffer[1] );
	preg_replace( $timestamp, "", $temp_string );
    trim( $temp_string );

	if ( $including != "" )
      $position = strpos( $including, $buffer[1] );
	else
	  $position = 0;
	    
	if ( $position != 0 )
      $including = substr( $including, 0, $position );
  }
  
  $special_msg = "";
  if ( preg_match( "/\.{3}([A-Z][A-Z ]*)\.{3}/", $temp_string, $buffer ) != 0 )
  {
    $special_msg = $buffer[1];
	$temp_string = preg_replace( "/\.{3}".$buffer[1]."\.{3}/", "", $temp_string );
  }

  $new_string = "<table width=\"98%\" align=\"center\">"
               ."<tr><th>".$including."<br />".$timestamp."<br />".$special_msg."</th></tr>"
			   ."<tr><td align=\"center\">\n";
 
     // get forecast data - find the text first 
  if ( preg_match( "/(\.{1}[A-Z][A-Z ]*)\.{3}/", $temp_string, $buffer ) != 0 )
  {
    $forecast  = strstr( $temp_string, $buffer[1] );
  }  
  else
  {
    return _UNABLE_TO_PARSE_EF;
  }
	
  // split into stings in array
  $array_forecast = preg_split( "/<br \/>/", $forecast, (-1), PREG_SPLIT_DELIM_CAPTURE );

  $t_forecast_array = array();  // used to build the table of extended forecasts
  $b_forecast_array = array();   // ditto...
  
  $which_one = 0;
  $countdaysfound = 0;
  while( ( list( $key, $value) = each( $array_forecast ) ) && ( $countdaysfound++ < ( $daystodisplay * 2 ) ))
  {
    $value = ereg_replace( "<br \/>","",$value);
    // need to capture the lines of the forecast
	do
	{
	  $next_value = current( $array_forecast );  // each moved pointer up, so get current
	  $next_value = preg_replace( "/<br \/>/","",$next_value);

	// check to see if the next_value as a day match in it, if not append to current value
	  if ( $next_value != "" && preg_match( $match_pattern, $next_value, $next_day ) != 1 )  // check for NO match
	  {
        // append strings
        $value = sprintf( "%s %s", $value, $next_value );
        // move pointer of working array
        next( $array_forecast );
      }
	  else  // no match - get out!!!
	  {
	    break;
	  }
	} while( 1 );
		
    $daycaptured = "";
    $imagepath = "";
    if ( preg_match( $match_pattern, $value, $day ) != 0 )
    {
      $value = preg_replace( $match_pattern, "", $value );
      $daycaptured = $day[1];
    }
    // need to figure out the image to display
    if ($daycaptured != "") 
    {
	  $night = ( eregi( "night", $daycaptured ) ? true : false );
	  
      $imagepath = fnGetWeatherImage( $value, $night );
	}
	
	// trim out all whitespace
	$daycaptured = trim( $daycaptured );
	$imagepath = trim( $imagepath );
	$value = trim( $value );
	
	if ( $getshort == 1 )  // abbreviate the extended output (used by center block)
	{
	  $temp = fnFindTemp( $value );
	  $percent = fnFindPercent( $value );
	  $temp = eregi_replace( "in the", " ", $temp );
      $value = $temp."<br />".$percent;
	}
	
	if ( $daycaptured == "" && $imagepath == "" && ( $value == "" || $value == "$$") )
	{
	  continue;
	}
	else
	{
	  if ( $which_one == 0 )  // doing the first one
	  {
	    $which_one = 1;
        $t_forecast_array[] = "<td width=\"14%\"><table><tr><th>".$daycaptured."</th></tr><tr><td>".$imagepath."<br />".$value."</td></tr></table></td>\n";
	  }
	  else  // doing the second one
	  {
	    $which_one = 0;
        $b_forecast_array[] = "<td width=\"14%\"><table><tr><th>".$daycaptured."</th></tr><tr><td>".$imagepath."<br />".$value."</td></tr></table></td>\n";
	  }
	}  
	
  }

  $new_string .= "<table width=\"95%\" align=\"center\"><tr valign=\"top\">\n";
  reset( $t_forecast_array );
  reset( $b_forecast_array );
  
  // build top line first
  while( list( $key, $val ) = each( $t_forecast_array ) )
  {
    $new_string .= $val;  
  }
  
  $new_string .= "</tr><tr valign=\"top\">\n";
  
    // build bottom line next
  while( list( $key, $val ) = each( $b_forecast_array ) )
  {
    $new_string .= $val;  
  }

  if ( $which_one == 1 )  // didn't finish correctly!!! need one more column
  {
    $new_string .= "<td width=\"14%\">&nbsp;</td>\n";  
  }
  
  $new_string .= "</tr></table>\n";
  
  $new_string .= $exp_string."</td></tr></table>\n";

  return $new_string;
}

################################################################################
# fnFindTemp( $segment )
# function will find the simple text of high or lows for the day
################################################################################

function fnFindTemp( $segment )
{
  $temp = "";
  
  if ( eregi( "([low|lows|high|highs][a-z ]*[0-9]{1,2}[.|s.])", $segment, $buffer ) )
  {
    $temp = $buffer[1];
  }
  else if ( eregi( "([low|lows|high|highs][a-z ]*[0-9]{1,2}[a-z ]*[0-9]{1,2}[a-z ]*[.|s.])", $segment, $buffer ) )
  {
    $temp = $buffer[1];
  }
  else if ( eregi( "([low|lows|high|highs] [0-9]{1,2}[a-z ]*[0-9]{1,2}[.|s.])", $segment, $buffer ) )
  {
    $temp = $buffer[1];
  }
  
  return $temp;
}

################################################################################
# fnFindPercent( $segment )
# function will find the simple text for percentage of precipitation chance and return value
################################################################################

function fnFindPercent( $segment )
{
  $temp = "";
  
  if ( eregi( "([0-9]{1,2} percent)", $segment, $buffer ) )
  {
    $temp = _WH_CHANCE.$buffer[1];
  }
  
  return $temp;
}

/******************************************************************************/
/* function fnParseNowWXZone( $string )                                       */
/* function to parse the wxzone string ($string) using the table data in the  */
/* array ($zone) matching the weatherzones table                              */
/******************************************************************************/

function fnParseNowWXZone( $string )
{
  // find the expires and timestamp
  $exp_string = fnGetExpires( $string, _NOWCAST_EXPIRES );
  
  //get string "INCLUDING"
  $including = strstr( $string, strtoupper( "including" ) );
  // build including so everything between it and the timestamp is included...
  
	  //get timestamp in following format - 915 AM AST TUE JAN 20 2004
  $timestamp = "";	  
  if ( preg_match( _DATE_MATCH, $string, $buffer ) != 0 )
  {
    $timestamp = $buffer[1];
	// move temp string up to the timestamp...
	$string = strstr( $string, $buffer[1] );
	
	if ( $including != "" )
      $position = strpos( $including, $buffer[1] );
	else
	  $position = 0;
	    
	if ( $position != 0 )
      $including = substr( $including, 0, $position );
  }
  
  if ( $exp_string === false )
  {
    $ret_string = "<table width=\"95%\" align=\"center\"><tr><th>\n"
                 .$including."<br />".$timestamp
		  	     ."</th></tr><tr><td align=\"center\">\n"
			     ._INV_NOWCAST_DATA."\n"
			     ."</td></tr></table>\n";
  }
  else
  {
  // look for the NOW cast
    $nowcast = strstr( $string, ".NOW..." );
    $nowcast = substr( $nowcast, strlen( ".NOW..." ) );
    $nowcast = ereg_replace( "\\$\\$.*", "", $nowcast );
    $ret_string = "<table width=\"95%\" align=\"center\"><tr><th>\n"
                 .$including."<br />".$timestamp
		  	     ."</th></tr><tr><td align=\"center\">\n"
			     .$nowcast."<br />".$exp_string."\n"
			     ."</td></tr></table>\n";
  }
  				 
  return $ret_string;
}

/******************************************************************************/
/* function fnParseUrgentWXZone( $string )                                    */
/* function will parse the urgent message data                                */
/******************************************************************************/

function fnParseUrgentWXZone( $string )
{ 
 // find the expires and timestamp
  $exp_string = fnGetExpires( $string, _URGENTWX_EXPIRES );
  
  //get string "URGENT"
  $urgent = strstr( $string, strtoupper( "urgent" ) );
  // build including so everything between it and the timestamp is included...
  
	  //get timestamp in following format - 915 AM AST TUE JAN 20 2004
  $timestamp = "";	  
  if ( preg_match( _DATE_MATCH, $string, $buffer ) != 0 )
  {
    $timestamp = $buffer[1];
	// move temp string up to the timestamp...
	$string = strstr( $string, $buffer[1] );
	
	if ( $urgent != "" )
      $position = strpos( $urgent, $buffer[1] );
	else
	  $position = 0;
	    
	if ( $position != 0 )
      $urgent = substr( $urgent, 0, $position );
  }
  
  if ( $exp_string === false )
  {
    $ret_string = "<table width=\"95%\" align=\"center\"><tr><th>\n"
                 .$urgent."<br />".$timestamp
		  	     ."</th></tr><tr><td align=\"center\">\n"
			     ._INV_URGENT_DATA."\n"
			     ."</td></tr></table>\n";
  }
  else
  {
  // look for the NOW cast
    $urg_msg = strstr( $string, $timestamp );
    $urg_msg = substr( $urg_msg, strlen( $timestamp ) );
    $urg_msg = ereg_replace( "\\$\\$.*", "", $urg_msg );
    $ret_string = "<table width=\"95%\" align=\"center\"><tr><th>\n"
                 .$urgent."<br />".$timestamp
		  	     ."</th></tr><tr><td align=\"center\">\n"
			     .$urg_msg."<br />".$exp_string."\n"
			     ."</td></tr></table>\n";
  }
  				 
  return $ret_string;
}

/******************************************************************************/
/* function fnParseStRdUpWXZone( $string )                                    */
/* function will parse the urgent message data                                */
/******************************************************************************/

function fnParseStRdUpWXZone( $string )
{ 
 // find the expires and timestamp
  $exp_string = fnGetExpires( $string, _STRDUPWX_EXPIRES );
  
	  //get timestamp in following format - 915 AM AST TUE JAN 20 2004
  $timestamp = "";	  
  if ( preg_match( _DATE_MATCH, $string, $buffer ) != 0 )
  {
    $timestamp = $buffer[1];
	// move temp string up to the timestamp...
	$string = strstr( $string, $buffer[1] );
	$urgent = isset($_GET['urgent']);
	
	if ( $urgent != "" )
      $position = strpos( $urgent, $buffer[1] );
	else
	  $position = 0;
	    
	if ( $position != 0 )
      $urgent = substr( $urgent, 0, $position );
  }
  
  if ( $exp_string === false )
  {
    $ret_string = "<table width=\"95%\" align=\"center\"><tr><th>\n"
                 .$timestamp
		  	     ."</th></tr><tr><td align=\"center\">\n"
			     ._INV_STRDUP_DATA."\n"
			     ."</td></tr></table>\n";
  }
  else
  {
  // look for the STRDUP data
    if ( preg_match( "/(CITY)/", $string, $buffer ) != 0 )
	{
	  $urg_msg = strstr( $string, $buffer[1] );
	  $urg_msg = preg_replace('/<br( )?(\/)?>/i', "\n", $urg_msg );
	}
	else
	{ 
      $urg_msg = strstr( $string, $timestamp );
      $urg_msg = substr( $urg_msg, strlen( $timestamp ) );
	} 
	
    $urg_msg = ereg_replace( "\\$\\$.*", "", $urg_msg );
    $ret_string = "<table width=\"95%\" align=\"center\"><tr><th>\n"
                 .$timestamp
		  	     ."</th></tr><tr><td align=\"center\">\n"
			     ."<xmp>".$urg_msg."</xmp><br />".$exp_string."\n"
			     ."</td></tr></table>\n";
  }
  				 
  return $ret_string;
}

/******************************************************************************/
/* function fnGetExpires( $string, $prefix )                                  */
/* Just checking the expiration on the zone files, returning status string    */
/******************************************************************************/

function fnGetExpires( $string, $prefix )
{
  $exp_string = "";
  
  if ( preg_match( "/Expires:([0-9]{12})/", $string, $buffer ) )
  {
    $year = substr( $buffer[1], 0, 4 );
	$month = substr( $buffer[1], 4, 2 );
	$day = substr( $buffer[1], 6, 2 );
	$hour = substr( $buffer[1], 8, 2 );
	$min = substr( $buffer[1], 10, 2 );
	
	$timestamp = mktime( $hour, $min, 0, $month, $day, $year );
	$curr_time = time();

    $isexpired = false;
	$out_of_tol = false;	
	if ( $timestamp <= $curr_time )
	{
	  $isexpired = true;
	  $curr_day = date( "j", $curr_time );
	  $curr_month = date( "n", $curr_time );
	  if ( $curr_day != $day || $curr_month != $month )  // not even same day or month
	  {
	    $out_of_tol = true;
	  }
	}
	
	if ( $out_of_tol == true )
	{
	  $exp_string = false;
	}
	else
	{
	  $exp_string = $prefix.strftime( "%a, %b %d, %Y %r", mktime( $hour, $min, 0, $month, $day, $year ) );
	  $exp_string .= "<br />".( $isexpired == true ? "<b>"._EXPIRED."</b>" : "<i>"._NEXPIRED."</i>" );
	}  
  }
  
  return( $exp_string );
}

/******************************************************************************/
/* function fnGetWeatherImage( $value, $night )                               */
/* function returns what image should be displayed                            */
/******************************************************************************/

function fnGetWeatherImage( $value, $night ) {
  global $db, $prefix;
  $wh = new whini();
  $wimages_loc = "modules/WeatherHarvest/images/set".$wh->getimageset()."/";
  $w_image = "";
  
  // figure out any percent chance of rain
  if ( eregi( "([0-9]{2}) percent", $value, $chance ) )
  {
    if ( $chance >= 0 && $chance <= 35 )
	{
      $precip_level = 1;
	}
	else if ( $chance > 35 && $chance <= 65 )
	{
	  $precip_level = 2;
	}
	else if ( $chance > 65 && $chance <= 100 )
	{
	  $precip_level = 3;
	}
	else
	{
	  $precip_level = 0;
	}
  }
  
  if ( eregi( "wind", $value ) )
  {
    $w_image = "23.gif";
  }
    
  if ( eregi( "mostly cloudy|considerable cloud", $value ) )
  {
    $w_image = $night ? "27.gif" : "28.gif";
  }
  else if ( eregi( "(partly cloudy|increasing high clouds)", $value ) )
  {
    $w_image = $night ? "29.gif" : "30.gif";
  }
  else if ( eregi( "cloudy", $value ) )
  {
    $w_image = "26.gif";
  }
  else if ( eregi( "(mostly|partly)( sunny)", $value ) )
  {
    $w_image = "34.gif";
  }
  else if ( eregi( "sunny", $value ) )
  {
    $w_image = "32.gif";
  }	
  else if ( eregi( "mostly clear", $value ) )
  {
    $w_image = $night ? "33.gif" : "34.gif";
  }
  else if ( eregi( "clear", $value ) )
  {
    $w_image = $night ? "31.gif" : "32.gif";
  }
  
  if ( eregi( "rain", $value ) && eregi( "snow", $value ) )
  {
    $w_image = "7.gif";
  }
  else if ( eregi( "snow showers|snow", $value ) )
  {
    if ( $_GET['precip_level'] != 0 )
	{
	  switch( $_GET['precip_level'] )
	  {
	    case 1:
		case 2:
		case 3:
		  $w_image = $night ? "46.gif" : "14.gif";
		  break;
	  }
	}
	else
	{
      $w_image = "14.gif";
	}  
  }
  else if ( eregi( "isolated showers", $value ) )
  {
    $w_image = $night ? "45.gif" : "39.gif";
  }
  else if ( eregi( "scattered showers", $value ) )
  {
    $w_image = $night ? "47.gif" : "38.gif";
  }
  else if ( eregi( "rain|showers", $value ) )
  {
    if ( isset($_GET['precip_level']) != 0 )
	{
      switch( $_GET['precip_level'] )
	  {
	    case 1:
		case 2:
	    case 3:
		  $w_image = $night ? "45.gif" : "39.gif";
		  break;
	  }
    }
    else
    {	
      $w_image = "12.gif";
    }	
  }
  
  if ( eregi( "storm", $value ) )
  {
    if ( isset($_GET['precip_level']) != 0 )
	{
      switch( $_GET['precip_level'] )
	  {
	    case 1:
		  $w_image = $night ? "47.gif" : "37.gif";
		  break;
		  
		case 2:
		  $w_image = $night ? "47.gif" : "38.gif";
		  break;
		
	    case 3:
     	  $w_image = "35.gif";
		  break;
	  }
    }
    else
    {	
      $w_image = "17.gif";
	}  
  }
  
  if ( eregi( "sleet", $value ) && eregi( "snow", $value ) )
  {
    $w_image = "7.gif";
  }
  else if ( eregi("freezing spray", $value ) )
  {
    $w_image = "8.gif";
  }
  else if ( eregi("freezing rain", $value ) )
  {
    $w_image = "10.gif";
  }
  else if ( eregi( "flurries", $value ) )
  {
    $w_image = "13.gif";
  }
  
  if ( $w_image == "" )
  {
    $ret_string = "&nbsp;";
  }
  else
  {
    $ret_string = "<img src=\"".$wimages_loc.$w_image."\" alt=\"\" />";
  }
  
  return $ret_string;	
}
/******************************************************************************/
/* function fnReadFile( $filename )                                           */
/* function to read in a given file ($filename) and return the data as a      */
/* string.  It places a <br /> where CR/LF occur                              */
/******************************************************************************/

function fnReadFile( $filename, $inc_break = true )
{
  $return = "";
  
  if ( $filename != "" )
  {
    $file = fopen($filename, "rb");
    if ( $file )
    {
      while( !feof( $file ) )
      {
        $line = fgets($file, 1024);
		if ( $inc_break == true )
        {
          $line = trim( $line );
          $return .= $line."<br />";
        }
        else
        {
          $return .= $line;
        }
      }  
      fclose($file);
    }
    else
    {
      $return = "";
    }
  }
  else
  {
    $return = "";
  }  
  
  return $return;
}

/************************************************************************/
/* function WMErrorHandler()                                            */
/* Custom error handler so errors are not thrown to the user interface  */
/************************************************************************/

function WMErrorHandler($errno, $errmsg, $filename, $linenum, $vars )
{
    // timestamp for the error entry
    $dt = date("Y-m-d H:i:s (T)");

    // define an assoc array of error string
    // in reality the only entries we should
    // consider are 2,8,256,512 and 1024
    $errortype = array (
                1   =>  "Error",
                2   =>  "Warning",
                4   =>  "Parsing Error",
                8   =>  "Notice",
                16  =>  "Core Error",
                32  =>  "Core Warning",
                64  =>  "Compile Error",
                128 =>  "Compile Warning",
                256 =>  "User Error",
                512 =>  "User Warning",
                1024=>  "User Notice"
                );
    // set of errors for which a var trace will be saved
    $user_errors = array(E_USER_ERROR, E_USER_WARNING, E_USER_NOTICE);
    
    $err = "<errorentry>\n";
    $err .= "\t<datetime>".$dt."</datetime>\n";
    $err .= "\t<errornum>".$errno."</errornum>\n";
    $err .= "\t<errortype>".$errortype[$errno]."</errortype>\n";
    $err .= "\t<errormsg>".$errmsg."</errormsg>\n";
    $err .= "\t<scriptname>".$filename."</scriptname>\n";
    $err .= "\t<scriptlinenum>".$linenum."</scriptlinenum>\n";

    if (in_array($errno, $user_errors))
        $err .= "\t<vartrace>".wddx_serialize_value($vars,"Variables")."</vartrace>\n";
    $err .= "</errorentry>\n\n";
    
    if ($errno == E_USER_ERROR)
        mail("seventhseal@ibdeeming.com","WeatherMagnet: Critical User Error",$err);
}

################################################################################
# function fnGetLatestBuoyObs( $latest_obs )
# returns the data from a latest observation from a buoy
################################################################################

function fnGetLatestBuoyObs( $latest_obs, $target_file )
{
  $return = "";
  
  $target_file = fnLatestObstoCache( $latest_obs, $target_file );
  
  // open the file and dump it to the screen
  if ( $target_file != "" )
  {
    $file = fopen($target_file, "rb");
    if ( $file )
    {
      while( !feof( $file ) )
      {
        $temp = fgets($file, 1024);
		$temp = htmlentities( $temp );
		$return .= $temp;		
	    $return .= "<br />";
      }  
      fclose($file);
    }
    else
    {
      $return .= _NO_DATA_AVAILABLE."<br />";
    }
  }
  else
  {
    $return .= _NO_DATA_AVAILABLE."<br />";
  }  
  
  return( $return );
}

################################################################################
# function fnBuoyStationOptions()
# function will output HTML for a SELECT block (options only!)
################################################################################

function fnBuoyStationOptions()
{
  echo "<option value=\"32301\">"._NAT_DATA_BUOY."</option>\n";
  echo "<option value=\"32301\">32301</option>\n";   
  echo "<option value=\"32302\">32302</option>\n";   
  echo "<option value=\"41001\">41001</option>\n";   
  echo "<option value=\"41002\">41002</option>\n";   
  echo "<option value=\"41003\">41003</option>\n";   
  echo "<option value=\"41004\">41004</option>\n";   
  echo "<option value=\"41005\">41005</option>\n";   
  echo "<option value=\"41006\">41006</option>\n";   
  echo "<option value=\"41007\">41007</option>\n";   
  echo "<option value=\"41008\">41008</option>\n";   
  echo "<option value=\"41009\">41009</option>\n";   
  echo "<option value=\"41010\">41010</option>\n";   
  echo "<option value=\"41011\">41011</option>\n";   
  echo "<option value=\"41012\">41012</option>\n";   
  echo "<option value=\"41013\">41013</option>\n";   
  echo "<option value=\"41015\">41015</option>\n";   
  echo "<option value=\"41016\">41016</option>\n";   
  echo "<option value=\"41017\">41017</option>\n";   
  echo "<option value=\"41018\">41018</option>\n";   
  echo "<option value=\"41021\">41021</option>\n";   
  echo "<option value=\"41022\">41022</option>\n";   
  echo "<option value=\"41023\">41023</option>\n";   
  echo "<option value=\"41025\">41025</option>\n";   
  echo "<option value=\"42001\">42001</option>\n";   
  echo "<option value=\"42002\">42002</option>\n";   
  echo "<option value=\"42003\">42003</option>\n";   
  echo "<option value=\"42004\">42004</option>\n";   
  echo "<option value=\"42005\">42005</option>\n";   
  echo "<option value=\"42006\">42006</option>\n";   
  echo "<option value=\"42007\">42007</option>\n";   
  echo "<option value=\"42008\">42008</option>\n";   
  echo "<option value=\"42009\">42009</option>\n";   
  echo "<option value=\"42010\">42010</option>\n";   
  echo "<option value=\"42011\">42011</option>\n";   
  echo "<option value=\"42012\">42012</option>\n";   
  echo "<option value=\"42015\">42015</option>\n";   
  echo "<option value=\"42016\">42016</option>\n";   
  echo "<option value=\"42017\">42017</option>\n";   
  echo "<option value=\"42018\">42018</option>\n";   
  echo "<option value=\"42019\">42019</option>\n";   
  echo "<option value=\"42020\">42020</option>\n";   
  echo "<option value=\"42025\">42025</option>\n";   
  echo "<option value=\"42035\">42035</option>\n";   
  echo "<option value=\"42036\">42036</option>\n";   
  echo "<option value=\"42037\">42037</option>\n";   
  echo "<option value=\"42039\">42039</option>\n";   
  echo "<option value=\"42040\">42040</option>\n";   
  echo "<option value=\"42041\">42041</option>\n";   
  echo "<option value=\"42042\">42042</option>\n";   
  echo "<option value=\"42053\">42053</option>\n";   
  echo "<option value=\"42054\">42054</option>\n";   
  echo "<option value=\"42534\">42534</option>\n";   
  echo "<option value=\"44001\">44001</option>\n";   
  echo "<option value=\"44003\">44003</option>\n";   
  echo "<option value=\"44004\">44004</option>\n";   
  echo "<option value=\"44005\">44005</option>\n";   
  echo "<option value=\"44006\">44006</option>\n";   
  echo "<option value=\"44007\">44007</option>\n";   
  echo "<option value=\"44008\">44008</option>\n";   
  echo "<option value=\"44009\">44009</option>\n";   
  echo "<option value=\"44010\">44010</option>\n";   
  echo "<option value=\"44011\">44011</option>\n";   
  echo "<option value=\"44012\">44012</option>\n";   
  echo "<option value=\"44013\">44013</option>\n";   
  echo "<option value=\"44014\">44014</option>\n";   
  echo "<option value=\"44015\">44015</option>\n";   
  echo "<option value=\"44017\">44017</option>\n";   
  echo "<option value=\"44018\">44018</option>\n";   
  echo "<option value=\"44019\">44019</option>\n";   
  echo "<option value=\"44023\">44023</option>\n";   
  echo "<option value=\"44025\">44025</option>\n";   
  echo "<option value=\"44026\">44026</option>\n";   
  echo "<option value=\"44027\">44027</option>\n";   
  echo "<option value=\"44028\">44028</option>\n";   
  echo "<option value=\"45001\">45001</option>\n";   
  echo "<option value=\"45002\">45002</option>\n";   
  echo "<option value=\"45003\">45003</option>\n";   
  echo "<option value=\"45004\">45004</option>\n";   
  echo "<option value=\"45005\">45005</option>\n";   
  echo "<option value=\"45006\">45006</option>\n";   
  echo "<option value=\"45007\">45007</option>\n";   
  echo "<option value=\"45008\">45008</option>\n";   
  echo "<option value=\"45009\">45009</option>\n";   
  echo "<option value=\"45010\">45010</option>\n";   
  echo "<option value=\"45011\">45011</option>\n";   
  echo "<option value=\"45012\">45012</option>\n";   
  echo "<option value=\"46001\">46001</option>\n";   
  echo "<option value=\"46002\">46002</option>\n";   
  echo "<option value=\"46003\">46003</option>\n";   
  echo "<option value=\"46005\">46005</option>\n";   
  echo "<option value=\"46006\">46006</option>\n";   
  echo "<option value=\"46007\">46007</option>\n";   
  echo "<option value=\"46008\">46008</option>\n";   
  echo "<option value=\"46009\">46009</option>\n";   
  echo "<option value=\"46010\">46010</option>\n";   
  echo "<option value=\"46011\">46011</option>\n";   
  echo "<option value=\"46012\">46012</option>\n";   
  echo "<option value=\"46013\">46013</option>\n";   
  echo "<option value=\"46014\">46014</option>\n";   
  echo "<option value=\"46015\">46015</option>\n";   
  echo "<option value=\"46016\">46016</option>\n";   
  echo "<option value=\"46017\">46017</option>\n";   
  echo "<option value=\"46018\">46018</option>\n";   
  echo "<option value=\"46019\">46019</option>\n";   
  echo "<option value=\"46020\">46020</option>\n";   
  echo "<option value=\"46021\">46021</option>\n";   
  echo "<option value=\"46022\">46022</option>\n";   
  echo "<option value=\"46023\">46023</option>\n";   
  echo "<option value=\"46024\">46024</option>\n";   
  echo "<option value=\"46025\">46025</option>\n";   
  echo "<option value=\"46026\">46026</option>\n";   
  echo "<option value=\"46027\">46027</option>\n";   
  echo "<option value=\"46028\">46028</option>\n";   
  echo "<option value=\"46029\">46029</option>\n";   
  echo "<option value=\"46032\">46032</option>\n";   
  echo "<option value=\"46033\">46033</option>\n";   
  echo "<option value=\"46034\">46034</option>\n";   
  echo "<option value=\"46035\">46035</option>\n";   
  echo "<option value=\"46037\">46037</option>\n";   
  echo "<option value=\"46038\">46038</option>\n";   
  echo "<option value=\"46039\">46039</option>\n";   
  echo "<option value=\"46040\">46040</option>\n";   
  echo "<option value=\"46041\">46041</option>\n";   
  echo "<option value=\"46042\">46042</option>\n";   
  echo "<option value=\"46043\">46043</option>\n";   
  echo "<option value=\"46045\">46045</option>\n";   
  echo "<option value=\"46047\">46047</option>\n";   
  echo "<option value=\"46048\">46048</option>\n";   
  echo "<option value=\"46050\">46050</option>\n";   
  echo "<option value=\"46051\">46051</option>\n";   
  echo "<option value=\"46053\">46053</option>\n";   
  echo "<option value=\"46054\">46054</option>\n";   
  echo "<option value=\"46059\">46059</option>\n";   
  echo "<option value=\"46060\">46060</option>\n";   
  echo "<option value=\"46061\">46061</option>\n";   
  echo "<option value=\"46062\">46062</option>\n";   
  echo "<option value=\"46063\">46063</option>\n";   echo "<option value=\"46066\">46066</option>\n";   echo "<option value=\"46069\">46069</option>\n";   echo "<option value=\"46072\">46072</option>\n";   echo "<option value=\"46080\">46080</option>\n";   echo "<option value=\"46081\">46081</option>\n";   echo "<option value=\"46082\">46082</option>\n";   echo "<option value=\"46083\">46083</option>\n";   
  echo "<option value=\"46084\">46084</option>\n";   echo "<option value=\"46086\">46086</option>\n";   echo "<option value=\"46401\">46401</option>\n";   echo "<option value=\"46402\">46402</option>\n";   echo "<option value=\"46403\">46403</option>\n";   echo "<option value=\"46404\">46404</option>\n";   echo "<option value=\"46405\">46405</option>\n";   echo "<option value=\"46406\">46406</option>\n";   
  echo "<option value=\"46551\">46551</option>\n";   echo "<option value=\"46553\">46553</option>\n";   echo "<option value=\"46779\">46779</option>\n";   echo "<option value=\"46780\">46780</option>\n";   echo "<option value=\"46781\">46781</option>\n";   echo "<option value=\"46784\">46784</option>\n";   echo "<option value=\"46785\">46785</option>\n";   echo "<option value=\"51001\">51001</option>\n";   
  echo "<option value=\"51002\">51002</option>\n";   echo "<option value=\"51003\">51003</option>\n";   echo "<option value=\"51004\">51004</option>\n";   echo "<option value=\"51005\">51005</option>\n";   echo "<option value=\"51026\">51026</option>\n";   echo "<option value=\"51027\">51027</option>\n";   echo "<option value=\"51028\">51028</option>\n";   echo "<option value=\"52009\">52009</option>\n";   
  echo "<option value=\"91204\">91204</option>\n";   echo "<option value=\"91222\">91222</option>\n";   echo "<option value=\"91251\">91251</option>\n";   echo "<option value=\"91328\">91328</option>\n";   echo "<option value=\"91338\">91338</option>\n";   echo "<option value=\"91343\">91343</option>\n";   echo "<option value=\"91352\">91352</option>\n";   echo "<option value=\"91355\">91355</option>\n";   
  echo "<option value=\"91365\">91365</option>\n";   echo "<option value=\"91374\">91374</option>\n";   echo "<option value=\"91377\">91377</option>\n";   echo "<option value=\"91411\">91411</option>\n";   echo "<option value=\"91442\">91442</option>\n";   echo "<option value=\"aban6\">ABAN6</option>\n";   echo "<option value=\"alrf1\">ALRF1</option>\n";   echo "<option value=\"alsn6\">ALSN6</option>\n";   
  echo "<option value=\"amaa2\">AMAA2</option>\n";   echo "<option value=\"auga2\">AUGA2</option>\n";   echo "<option value=\"blia2\">BLIA2</option>\n";   echo "<option value=\"burl1\">BURL1</option>\n";   echo "<option value=\"busl1\">BUSL1</option>\n";   echo "<option value=\"buzm3\">BUZM3</option>\n";   echo "<option value=\"caro3\">CARO3</option>\n";   echo "<option value=\"cdrf1\">CDRF1</option>\n";   
  echo "<option value=\"chlv2\">CHLV2</option>\n";   echo "<option value=\"clkn7\">CLKN7</option>\n";   echo "<option value=\"csbf1\">CSBF1</option>\n";   echo "<option value=\"dbln6\">DBLN6</option>\n";   echo "<option value=\"desw1\">DESW1</option>\n";   echo "<option value=\"disw3\">DISW3</option>\n";   echo "<option value=\"dpia1\">DPIA1</option>\n";   echo "<option value=\"drfa2\">DRFA2</option>\n";   
  echo "<option value=\"dryf1\">DRYF1</option>\n";   echo "<option value=\"dsln7\">DSLN7</option>\n";   echo "<option value=\"ducn7\">DUCN7</option>\n";   echo "<option value=\"eb43\">EB43</option>\n";    echo "<option value=\"eb53\">EB53</option>\n";    echo "<option value=\"eb61\">EB61</option>\n";    echo "<option value=\"eb62\">EB62</option>\n";    echo "<option value=\"eb70\">EB70</option>\n";    
  echo "<option value=\"eb90\">EB90</option>\n";    echo "<option value=\"eb91\">EB91</option>\n";    echo "<option value=\"eb92\">EB92</option>\n";    echo "<option value=\"fbis1\">FBIS1</option>\n";   echo "<option value=\"ffia2\">FFIA2</option>\n";   echo "<option value=\"fila2\">FILA2</option>\n";   echo "<option value=\"fpsn7\">FPSN7</option>\n";   echo "<option value=\"fwyf1\">FWYF1</option>\n";   
  echo "<option value=\"gbcl1\">GBCL1</option>\n";   echo "<option value=\"gdil1\">GDIL1</option>\n";   echo "<option value=\"glln6\">GLLN6</option>\n";   echo "<option value=\"iosn3\">IOSN3</option>\n";   echo "<option value=\"ktnf1\">KTNF1</option>\n";   echo "<option value=\"lkwf1\">LKWF1</option>\n";   echo "<option value=\"lnel1\">LNEL1</option>\n";   echo "<option value=\"lonf1\">LONF1</option>\n";   
  echo "<option value=\"lpoi1\">LPOI1</option>\n";   echo "<option value=\"lscm4\">LSCM4</option>\n";   echo "<option value=\"mdrm1\">MDRM1</option>\n";   echo "<option value=\"mism1\">MISM1</option>\n";   echo "<option value=\"mlrf1\">MLRF1</option>\n";   echo "<option value=\"mpcl1\">MPCL1</option>\n";   echo "<option value=\"mrka2\">MRKA2</option>\n";   echo "<option value=\"nwpo3\">NWPO3</option>\n";   
  echo "<option value=\"pila2\">PILA2</option>\n";   echo "<option value=\"pilm4\">PILM4</option>\n";   echo "<option value=\"pota2\">POTA2</option>\n";   echo "<option value=\"ptac1\">PTAC1</option>\n";   echo "<option value=\"ptat2\">PTAT2</option>\n";   echo "<option value=\"ptgc1\">PTGC1</option>\n";   echo "<option value=\"roam4\">ROAM4</option>\n";   echo "<option value=\"sanf1\">SANF1</option>\n";   
  echo "<option value=\"sauf1\">SAUF1</option>\n";   echo "<option value=\"sbio1\">SBIO1</option>\n";   echo "<option value=\"sgnw3\">SGNW3</option>\n";   echo "<option value=\"sisw1\">SISW1</option>\n";   echo "<option value=\"sjlf1\">SJLF1</option>\n";   echo "<option value=\"smkf1\">SMKF1</option>\n";   echo "<option value=\"sgof1\">SGOF1</option>\n";   echo "<option value=\"spgf1\">SPGF1</option>\n";   
  echo "<option value=\"srst2\">SRST2</option>\n";   echo "<option value=\"stdm4\">STDM4</option>\n";   echo "<option value=\"supn6\">SUPN6</option>\n";   echo "<option value=\"svls1\">SVLS1</option>\n";   echo "<option value=\"thin6\">THIN6</option>\n";   echo "<option value=\"tplm2\">TPLM2</option>\n";   echo "<option value=\"ttiw1\">TTIW1</option>\n";   echo "<option value=\"venf1\">VENF1</option>\n";   
  echo "<option value=\"wpow1\">WPOW1</option>\n"; 
  echo "<option value=\"44137\">"._CAN_DATA_BUOY."</options>\n";
  echo "<option value=\"44137\">44137</option>\n";   echo "<option value=\"44138\">44138</option>\n";   echo "<option value=\"44139\">44139</option>\n";   echo "<option value=\"44140\">44140</option>\n";   echo "<option value=\"44141\">44141</option>\n";   echo "<option value=\"44142\">44142</option>\n";   echo "<option value=\"44150\">44150</option>\n";   echo "<option value=\"44251\">44251</option>\n";   
  echo "<option value=\"44255\">44255</option>\n";   echo "<option value=\"44258\">44258</option>\n";   echo "<option value=\"45132\">45132</option>\n";   echo "<option value=\"45135\">45135</option>\n";   echo "<option value=\"45136\">45136</option>\n";   echo "<option value=\"45137\">45137</option>\n";   echo "<option value=\"45138\">45138</option>\n";   echo "<option value=\"45139\">45139</option>\n";   
  echo "<option value=\"45140\">45140</option>\n";   echo "<option value=\"45141\">45141</option>\n";   echo "<option value=\"45142\">45142</option>\n";   echo "<option value=\"45143\">45143</option>\n";   echo "<option value=\"45144\">45144</option>\n";   echo "<option value=\"45145\">45145</option>\n";   echo "<option value=\"45147\">45147</option>\n";   echo "<option value=\"45148\">45148</option>\n";   
  echo "<option value=\"45149\">45149</option>\n";   echo "<option value=\"45150\">45150</option>\n";   echo "<option value=\"45151\">45151</option>\n";   echo "<option value=\"45152\">45152</option>\n";   echo "<option value=\"45154\">45154</option>\n";   echo "<option value=\"45159\">45159</option>\n";   echo "<option value=\"45160\">45160</option>\n";   echo "<option value=\"46004\">46004</option>\n";   
  echo "<option value=\"46036\">46036</option>\n";   echo "<option value=\"46131\">46131</option>\n";   echo "<option value=\"46132\">46132</option>\n";   echo "<option value=\"46134\">46134</option>\n";   echo "<option value=\"46145\">46145</option>\n";   echo "<option value=\"46146\">46146</option>\n";   echo "<option value=\"46147\">46147</option>\n";   echo "<option value=\"46181\">46181</option>\n";   
  echo "<option value=\"46183\">46183</option>\n";   echo "<option value=\"46184\">46184</option>\n";   echo "<option value=\"46185\">46185</option>\n";   echo "<option value=\"46204\">46204</option>\n";   echo "<option value=\"46205\">46205</option>\n";   echo "<option value=\"46206\">46206</option>\n";   echo "<option value=\"46207\">46207</option>\n";   echo "<option value=\"46208\">46208</option>\n";   
  echo "<option value=\"46632\">46632</option>\n";   echo "<option value=\"46633\">46633</option>\n";   echo "<option value=\"46634\">46634</option>\n";   echo "<option value=\"46635\">46635</option>\n";   echo "<option value=\"46636\">46636</option>\n";   echo "<option value=\"46637\">46637</option>\n";   echo "<option value=\"46638\">46638</option>\n";   echo "<option value=\"46639\">46639</option>\n";   
  echo "<option value=\"46640\">46640</option>\n";   echo "<option value=\"46641\">46641</option>\n";   echo "<option value=\"46657\">46657</option>\n";   echo "<option value=\"46660\">46660</option>\n";   echo "<option value=\"46661\">46661</option>\n";   echo "<option value=\"46692\">46692</option>\n";   echo "<option value=\"46695\">46695</option>\n";   echo "<option value=\"46698\">46698</option>\n";   
  echo "<option value=\"46700\">46700</option>\n";   echo "<option value=\"46701\">46701</option>\n";   echo "<option value=\"46702\">46702</option>\n";   echo "<option value=\"46705\">46705</option>\n";   echo "<option value=\"46707\">46707</option>\n";   echo "<option value=\"46710\">46710</option>\n";
  echo "<option value=\"42013\">"._COMPS_BUOY."</options>\n";
  echo "<option value=\"42013\">42013</option>\n";   echo "<option value=\"42021\">42021</option>\n";   echo "<option value=\"42022\">42022</option>\n";   echo "<option value=\"42023\">42023</option>\n";   echo "<option value=\"anmf1\">ANMF1</option>\n";   echo "<option value=\"arpf1\">ARPF1</option>\n";   echo "<option value=\"egkf1\">EGKF1</option>\n";   echo "<option value=\"hssf1\">HSSF1</option>\n";
  echo "<option value=\"nfbf1\">NFBF1</option>\n";   echo "<option value=\"ptrf1\">PTRF1</option>\n";   echo "<option value=\"shpf1\">SHPF1</option>\n";   echo "<option value=\"tarf1\">TARF1</option>\n";
  echo "<option value=\"44029\">"._GEMOOS_BUOY."</options>\n";
  echo "<option value=\"44029\">44029</option>\n";   echo "<option value=\"44030\">44030</option>\n";   echo "<option value=\"44031\">44031</option>\n";   echo "<option value=\"44032\">44032</option>\n";   echo "<option value=\"44033\">44033</option>\n";   echo "<option value=\"44034\">44034</option>\n";   echo "<option value=\"44035\">44035</option>\n";   echo "<option value=\"44036\">44036</option>\n";   
  echo "<option value=\"44037\">44037</option>\n";   echo "<option value=\"44038\">44038</option>\n";   
  echo "<option value=\"lkpll\">"._LUMCOM_BUOY."</options>\n";
  echo "<option value=\"lkpl1\">LKPL1</option>\n";   echo "<option value=\"luml1\">LUML1</option>\n";    echo "<option value=\"taml1\">TAML1</option>\n";   echo "<option value=\"trbl1\">TRBL1</option>\n";
  echo "<option value=\"41100\">"._METEO_FR_BUOY."</options>\n";
  echo "<option value=\"41100\">41100</option>\n";   echo "<option value=\"41101\">41101</option>\n";   echo "<option value=\"61001\">61001</option>\n";   echo "<option value=\"61002\">61002</option>\n";   echo "<option value=\"62052\">62052</option>\n";
  echo "<option value=\"44039\">"._MYSOUND_BUOY."</options>\n";
  echo "<option value=\"44039\">44039</option>\n";   echo "<option value=\"44040\">44040</option>\n";   echo "<option value=\"ldlc3\">LDLC3</option>\n";   
  echo "<option value=\"46541\">"._NAVO_BUOY."</options>\n";
  echo "<option value=\"46541\">46541</option>\n";   echo "<option value=\"46968\">46968</option>\n";   echo "<option value=\"46970\">46970</option>\n";   echo "<option value=\"46974\">46974</option>\n";   echo "<option value=\"46977\">46977</option>\n";   echo "<option value=\"46983\">46983</option>\n";   echo "<option value=\"46985\">46985</option>\n";
  echo "<option value=\"spagl\">"._SKIDAWAY_BUOY."</options>\n";
  echo "<option value=\"spag1\">SPAG1</option>\n";   echo "<option value=\"tybg1\">TYBG1</option>\n";
  echo "<option value=\"acmn4\">"._STEVENS_BUOY."</options>\n";
  echo "<option value=\"acmn4\">ACMN4</option>\n";   echo "<option value=\"avan4\">AVAN4</option>\n";   echo "<option value=\"brbn4\">BRBN4</option>\n";    
  echo "<option value=\"42043\">"._TABS_BUOY."</options>\n";
  echo "<option value=\"42043\">42043</option>\n";   echo "<option value=\"42044\">42044</option>\n";   echo "<option value=\"42045\">42045</option>\n";   echo "<option value=\"42046\">42046</option>\n";   echo "<option value=\"42047\">42047</option>\n";
  echo "<option value=\"babt2\">"._TCOON_BUOY."</options>\n";
  echo "<option value=\"babt2\">BABT2</option>\n";   echo "<option value=\"glpt2\">GLPT2</option>\n";   echo "<option value=\"pcnt2\">PCNT2</option>\n";   echo "<option value=\"rsjt2\">RSJT2</option>\n";   echo "<option value=\"rtot2\">RTOT2</option>\n";
  echo "<option value=\"03007\">"._UK_BUOY."</options>\n";
  echo "<option value=\"03007\">03007</option>\n";   echo "<option value=\"03010\">03010</option>\n";   echo "<option value=\"03011\">03011</option>\n";   echo "<option value=\"03014\">03014</option>\n";   echo "<option value=\"62001\">62001</option>\n";   echo "<option value=\"62026\">62026</option>\n";   echo "<option value=\"62029\">62029</option>\n";   echo "<option value=\"62051\">62051</option>\n";   
  echo "<option value=\"62081\">62081</option>\n";   echo "<option value=\"62103\">62103</option>\n";   echo "<option value=\"62105\">62105</option>\n";   echo "<option value=\"62106\">62106</option>\n";   echo "<option value=\"62107\">62107</option>\n";   echo "<option value=\"62108\">62108</option>\n";   echo "<option value=\"62109\">62109</option>\n";   echo "<option value=\"62120\">62120</option>\n";   
  echo "<option value=\"62130\">62130</option>\n";   echo "<option value=\"62141\">62141</option>\n";   echo "<option value=\"62142\">62142</option>\n";   echo "<option value=\"62143\">62143</option>\n";   echo "<option value=\"62144\">62144</option>\n";   echo "<option value=\"62145\">62145</option>\n";   echo "<option value=\"62146\">62146</option>\n";   echo "<option value=\"62147\">62147</option>\n";   
  echo "<option value=\"62155\">62155</option>\n";   echo "<option value=\"62163\">62163</option>\n";   echo "<option value=\"62164\">62164</option>\n";   echo "<option value=\"62166\">62166</option>\n";   echo "<option value=\"62202\">62202</option>\n";   echo "<option value=\"62301\">62301</option>\n";   echo "<option value=\"62303\">62303</option>\n";   echo "<option value=\"62304\">62304</option>\n";   
  echo "<option value=\"62305\">62305</option>\n";   echo "<option value=\"63101\">63101</option>\n";   echo "<option value=\"63104\">63104</option>\n";   echo "<option value=\"63105\">63105</option>\n";   echo "<option value=\"63110\">63110</option>\n";   echo "<option value=\"63112\">63112</option>\n";   echo "<option value=\"63113\">63113</option>\n";   echo "<option value=\"63117\">63117</option>\n";   
  echo "<option value=\"64045\">64045</option>\n";   echo "<option value=\"64046\">64046</option>\n";
}
?>
