<?php
######################################################################
# Weather Harvest
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/wh_ini.php" );
require_once( "modules/$module_name/utils/radarjs.php" );

$NOAAMaskLoopInfo = "http://www.srh.noaa.gov/ridge/RadarImg/:radartype:/:noaaradar:/";  					// Edited to new URL - layingback
$NOAAMaskLoopPath = "http://www.srh.noaa.gov/ridge/RadarImg/:radartype:/:noaaradar:/";						// Edited to new URL - layingback
$NOAAMaskRadarPath = "http://www.srh.noaa.gov/ridge/RadarImg/:radartype:/:noaaradar:_:radartype:_0.gif";	// Edited to new URL - layingback

// The following represent the set of "Overlays" available from NOAA for the Ridge, in Long (248mi) & SHort (124mi) versions
// To remove 1 or more of these backgrouns simple place // at beginning of respective line to comment out that image - layingback

$bkgrndimgS = array(																						// Added  - layingback
					 "http://www.srh.noaa.gov/ridge/Overlays/Topo/Short/:noaaradar:_Topo_Short.jpg"
					,"http://www.srh.noaa.gov/ridge/Overlays/County/Short/:noaaradar:_County_Short.gif"
					,"http://www.srh.noaa.gov/ridge/Overlays/Rivers/Short/:noaaradar:_Rivers_Short.gif"
					,"http://www.srh.noaa.gov/ridge/Overlays/Highways/Short/:noaaradar:_Highways_Short.gif"
					,"http://www.srh.noaa.gov/ridge/Overlays/Cities/Short/:noaaradar:_City_Short.gif"
					,"http://www.srh.noaa.gov/ridge/Warnings/Short/:noaaradar:_Warnings_0.gif"
					);
$bkgrndimgL = array(																						// Added - layingback
					 "http://www.srh.noaa.gov/ridge/Overlays/Topo/Long/:noaaradar:_Topo_Long.jpg"
					,"http://www.srh.noaa.gov/ridge/Overlays/County/Long/:noaaradar:_County_Long.gif"
					,"http://www.srh.noaa.gov/ridge/Overlays/Rivers/Long/:noaaradar:_Rivers_Long.gif"
					,"http://www.srh.noaa.gov/ridge/Overlays/Highways/Long/:noaaradar:_Highways_Long.gif"
					,"http://www.srh.noaa.gov/ridge/Overlays/Cities/Long/:noaaradar:_City_Long.gif"
					);


/******************************************************************************/
/* fnOptionalRadarMenu( $id )                                                 */
/* displays menu option of other radars available (NOAA only!)                */
/******************************************************************************/

function fnOptionalRadarMenu() {
  global $module_name, $db, $prefix;
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');

  $wh = new whini();
  $allow_radarloops = $wh->getradarloops();
  
  echo "<table><tr><th>"._AVAIL_RADARS."</th></tr>\n"
      ."<tr><td>\n";
	  
  echo "<table width=\"100%\"><tr><th colspan=\"2\">"._SHORT_REF_RADAR."</th></tr>\n"
	  ."<tr><td>\n"
      ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RADAR."&amp;id=$id&amp;type="._SHORT_REF."\">"._RADAR_LATEST."</a>\n"
	  ."</td>\n";
  if ( $allow_radarloops == true )
  {
    echo "<td>\n"
	    ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RAD_LOOP."&amp;id=$id&amp;type="._SHORT_REF."\">"._RADAR_LOOP."</a>\n"
	    ."</td>\n";
  }
  else
  {
    echo "<td>&nbsp;</td>";
  }			
  
  echo "</tr></table>\n";
		
	  
  echo "<table width=\"100%\"><tr><th colspan=\"2\">"._LONG_REF_RADAR."</th></tr>\n"
      ."<tr><td>\n"
      ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RADAR."&amp;id=$id&amp;type="._LONG_REF."\">"._RADAR_LATEST."</a>\n"
	  ."</td>";
	  
  if ( $allow_radarloops == true )
  {
    echo "<td>\n"
	    ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RAD_LOOP."&amp;id=$id&amp;type="._LONG_REF."\">"._RADAR_LOOP."</a>\n"
	    ."</td>";
  }
  else
  {
    echo "<td>&nbsp;</td>";
  }
  
  echo "</tr></table>\n";
	  
  echo "<table width=\"100%\"><tr><th colspan=\"2\">"._SHORT_COMP_RADAR."</th></tr>\n"
      ."<tr><td>\n"
      ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RADAR."&amp;id=$id&amp;type="._SHORT_COMP."\">"._RADAR_LATEST."</a>\n"
	  ."</td>";
	  
  if ( $allow_radarloops == true )
  {
    echo "<td>\n"
	    ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RAD_LOOP."&amp;id=$id&amp;type="._SHORT_COMP."\">"._RADAR_LOOP."</a>\n"
	    ."</td>";
  }
  else
  {
    echo "<td>&nbsp;</td>";
  }
  echo "</tr></table>\n";
		
/*  																			//	Dropped - No longer offerred by NOAA - layingback
  echo "<table width=\"100%\"><tr><th colspan=\"2\">"._LONG_COMP_RADAR."</th></tr>\n"
      ."<tr><td>\n"	  
      ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RADAR."&amp;id=$id&amp;type="._LONG_COMP."\">"._RADAR_LATEST."</a>\n"
	  ."</td>";
  if ( $allow_radarloops == true )
  {
    echo "<td>\n"
        ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RAD_LOOP."&amp;id=$id&amp;type="._LONG_COMP."\">"._RADAR_LOOP."</a>\n"
	    ."</td>";
  }
  else
  {
    echo "<td>&nbsp;</td>";
  }
  echo "</tr></table>\n";	*/
  
  echo "<table width=\"100%\"><tr><th colspan=\"2\">"._ONE_HOUR_RADAR."</th></tr>\n"
      ."<tr><td>\n"
      ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RADAR."&amp;id=$id&amp;type="._ONE_HOUR."\">"._RADAR_LATEST."</a>\n"
	  ."</td>";
	  
  if ( $allow_radarloops == true )
  {
    echo "<td>\n"
 	    ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RAD_LOOP."&amp;id=$id&amp;type="._ONE_HOUR."\">"._RADAR_LOOP."</a>\n"
	    ."</td>";
  }
  else
  {
    echo "<td>&nbsp;</td>";
  }
  echo "</tr></table>\n";

  echo "<table width=\"100%\"><tr><th colspan=\"2\">"._STORM_TOTAL_RADAR."</th></tr>\n"
      ."<tr><td>\n"
      ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RADAR."&amp;id=$id&amp;type="._STORM_TOTAL."\">"._RADAR_LATEST."</a>\n"
	  ."</td>";
  if ( $allow_radarloops == true )
  {
    echo "<td>\n"
  	    ."<a href=\"index.php?name=".$module_name."&amp;op="._DIS_REQ_RAD_LOOP."&amp;id=$id&amp;type="._STORM_TOTAL."\">"._RADAR_LOOP."</a>\n"
	    ."</td>";
  }
  else
  {
    echo "<td>&nbsp;</td>";
  }
  echo "</tr></table>\n";
	  
  echo "<tr><td align=\"right\"><img src=\"modules/WeatherHarvest/images/noaa_radar_legend.gif\"></td></tr>";

  echo "</td></tr></table>\n";
  
  
}

/******************************************************************************/
/* function fnCheckRadarEntries( $code )                                      */
/* passed variable : $code - corresponds to code in the weatherstations table */
/* Returns true if any of primaryradar, secondaryradar, userradar contains data*/
/******************************************************************************/

function fnCheckRadarEntries($code) {
//$code = isset($_POST['code'])?$_POST['code']:(isset($_GET['code'])?$_GET['code']:'');
  global $prefix, $db;

  $return = false;

  $sql = "select primaryradar, secondaryradar, userradar from ".$prefix."_weatherstations where code='".$code."'";
  $result = $db->sql_query( $sql );

  if ( $result )
  {
    $row = $db->sql_fetchrow( $result );

    if ( strlen( $row['primaryradar'] ) > 0  || strlen( $row['secondaryradar'] ) > 0 || strlen( $row['userradar'] ) > 0 )
    {
      $return = true;
    }
  }

  $db->sql_freeresult( $result );

  return $return;
}

################################################################################
# function fnGetPrimaryThumb( $id )
# function will get primary radar and return a link to thumbnail of the original
################################################################################

function fnGetPrimaryThumb()
{
  global $prefix, $db, $bkgrndimgS;																			// Added $bkgrndimgS - layingback
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
  $NOAAMaskRadarPath = "http://www.srh.noaa.gov/ridge/RadarImg/:radartype:/:noaaradar:_:radartype:_0.gif";  // Edited to match new filename - layingback

  $wh = new whini();
  
  $sql = "select code, repstation, primaryradar, secondaryradar, userradar from ".$prefix."_weatherstations where id='".$id."'";
  $result = $db->sql_query( $sql );
  if ( $result )
  {
    $row = $db->sql_fetchrow( $result );

    $radarpath = ereg_replace( ":radartype:", _SHORTREFLECTIVITY, $NOAAMaskRadarPath );
  
    if ($row['primaryradar'] != "")
    {
      $primaryradar = ereg_replace( ":noaaradar:", $row['primaryradar'], $radarpath );
    }
    else
    {
      $primaryradar = "";
    }
 
    $code = $row['code'];

    $db->sql_freeresult( $result );

    if ( $primaryradar != "")
    {
      $return = fnmap2cache( $primaryradar, $code, "p"._SHORT_REF, "150", "150" );
      foreach ($bkgrndimgS as $key => $bkgrdpath) {											// Added - layingback
		$radarbkgrnd = ereg_replace( ":noaaradar:", $row['primaryradar'], $bkgrndpath );	// Added - layingback
		$return = fnmap2cache( $radarbkgrnd, $key, "bS", "150", "150", "1" );				// Added - layingback
      }																						// Added - layingback
    }
	else
	{
	  $return = "ERROR - Invalid radar thumb<br />$radarpath<br />$NOAAMaskRadarPath";
	}
  }
  else
  {
    $return = "ERROR -  Unable to retrieve thumbnail";
  }
  
  return( $return );
}

/******************************************************************************/
/* function fnShowAllRadar( $id )                                             */
/* passed variable : $id - corresponds to database line in table weatherstations*/
/* function will display all corresponding defined radars for specified code  */
/******************************************************************************/

function fnShowAllRadar()
{
  global $prefix, $db, $NOAAMaskRadarPath, $bkgrndimgS, $bkgrndimgL;							// Added $bkgrndimgS & L - layingback
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');

  $wh = new whini();
  $radarscale = $wh->getradarscale();									//Add radarscale retrieval - layingback

  $NOAARidgeWidth = "600";												//Current images sizes from NOAA Ridge - layingback
  $NOAARidgeHeight = "550";
  
  $width = round($NOAARidgeWidth * $radarscale / "100");								//Set previously undeclared width & height - layingabck
  $height = round($NOAARidgeHeight * $radarscale / "100");
    
  $sql = "select code, repstation, primaryradar, secondaryradar, userradar from ".$prefix."_weatherstations where id='".$id."'";
  $result = $db->sql_query( $sql );
  $row = $db->sql_fetchrow( $result );

  $repstation = ucwords( $row['repstation'] );

  // set up the type of radar to display
$type = isset($_POST['type'])?$_POST['type']:(isset($_GET['type'])?$_GET['type']:'');
  switch( $type )
  {
    case _SHORT_REF:
      $radarpath = ereg_replace( ":radartype:", _SHORTREFLECTIVITY, $NOAAMaskRadarPath );
      $title = $repstation."<br />"._SHORT_REF_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

    case _LONG_REF:
      $radarpath = ereg_replace( ":radartype:", _LONGREFLECTIVITY, $NOAAMaskRadarPath );
      $title = $repstation."<br />"._LONG_REF_RADAR;
      $bkgrndimg = $bkgrndimgL;														//Short or Long bkgrnds - layingback
      break;

    case _SHORT_COMP:
      $radarpath = ereg_replace( ":radartype:", _SHORTCOMPOSITE, $NOAAMaskRadarPath );
      $title = $repstation."<br />"._SHORT_COMP_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

//  case _LONG_COMP:																	//No longer supported by NOAA - layingback
//    $radarpath = ereg_replace( ":radartype:", _LONGCOMPOSITE, $NOAAMaskRadarPath );
//    $title = $repstation."<br />"._LONG_COMP_RADAR;
//    break;

    case _ONE_HOUR:
      $radarpath = ereg_replace( ":radartype:", _ONEHOURTOTAL, $NOAAMaskRadarPath );
      $title = $repstation."<br />"._ONE_HOUR_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

    case _STORM_TOTAL:
      $radarpath = ereg_replace( ":radartype:", _STORMTOTAL, $NOAAMaskRadarPath );
      $title = $repstation."<br />"._STORM_TOTAL_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

    default:
      $radarpath = ereg_replace( ":radartype:", _SHORTREFLECTIVITY, $NOAAMaskRadarPath );
      $title = $repstation."<br />"._SHORT_REF_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

  }

  if ($row['primaryradar'] != "")
  {
    $primaryradar = ereg_replace( ":noaaradar:", $row['primaryradar'], $radarpath );
  }
  else
  {
    $primaryradar = "";
  }
 
  if ($row['secondaryradar'] != "") 
  {
    $secondaryradar = ereg_replace( ":noaaradar:", $row['secondaryradar'], $radarpath );
  }
  else
  {
    $secondaryradar = "";
  }

  $userradar = $row['userradar'];
  $code = $row['code'];

  $db->sql_freeresult( $result );

  include("header.php");
  OpenTable();

  echo "<table width=\"100%\"><tr><th colspan=\"2\">\n";			//Expand table to 100% - layingback
  echo $title."</th></tr><tr><td valign=\"top\">";

  fnOptionalRadarMenu();

  echo "</td><td width=\"100%\" valign=\"top\"><table width=\"100%\">";		//Expand table to 100% - layingback
  
  if ( $primaryradar != "")
  {
    echo "<tr><th>";
    $return = fnmap2cache( $primaryradar, $code, "p".$type, $width, $height );
    echo _PRI_REPORTING_STATION."</th></tr><tr><td><div style=position:relative>";						// Split & add div container - layingback
    foreach ($bkgrndimg as $key => $bkgrndpath) {														// Added - layingback
	  $radarbkgrnd = ereg_replace( ":noaaradar:", $row['primaryradar'], $bkgrndpath );					// Added - layingback
	  $bkreturn = fnmap2cache( $radarbkgrnd, $key, "bS", $width, $height, "1" );						// Added - layingback
	  echo "<div style=\"z-index:".$key.";position:absolute;top:0px;left:0px\">".$bkreturn."</div>";	// Added - layingback
    }																									// Added - layingback
    echo "<div style=\"z-index:5;position:absolute;top:0px;left:0px\">".$return."</div></div></td></tr>\n";	// Split & added style - layingback
  }

  if ( $secondaryradar != "")
  {
    echo "<tr><th>";
    $return = fnmap2cache( $secondaryradar, $code, "s".$type, $width, $height );	
    echo _SEC_REPORTING_STATION."</th></tr><tr><td><div style=position:relative>";						// Split & add div container - layingback
    foreach ($bkgrndimg as $key => $bkgrndpath) {														// Added - layingback
	  $radarbkgrnd = ereg_replace( ":noaaradar:", $row['primaryradar'], $bkgrndpath );					// Added - layingback
	  $bkreturn = fnmap2cache( $radarbkgrnd, $key, "bS", $width, $height, "1" );						// Added - layingback
	  echo "<div style=\"z-index:".$key.";position:absolute;top:0px;left:0px\">".$bkreturn."</div>";	// Added - layingback
    }																									// Added - layingback
    echo "<div style=\"z-index:5;position:absolute;top:0px;left:0px\">".$return."</div></td></tr>\n";	// Split & added style - layingback
  }

  echo "</table></td></tr>";

  if ( $userradar != "" ) 
  {
    echo "<tr colspan=\"2\"><th>";
    $return = fnmap2cache( $userradar, $code, "u".$type );
    echo _USR_REPORTING_STATION."</th></tr><tr><td><div style=position:relative>";						// Split & add div container - layingback
    foreach ($bkgrndimg as $key => $bkgrndpath) {														// Added - layingback
	  $radarbkgrnd = ereg_replace( ":noaaradar:", $row['primaryradar'], $bkgrndpath );					// Added - layingback
	  $bkreturn = fnmap2cache( $radarbkgrnd, $key, "bS", $width, $height, "1" );						// Added - layingback
	  echo "<div style=\"z-index:".$key.";position:absolute;top:0px;left:0px\">".$bkreturn."</div>";	// Added - layingback
    }																									// Added - layingback
    echo "<div style=\"z-index:5;position:absolute;top:0px;left:0px\">".$return."</div></td></tr>\n";	// Split & added style - layingback
  }

  echo "</table>\n";

  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnmap2cache( $URL, $code, $pre, $width = "", $height = "" )       */
/* function will copy a specified URL image to cache.                         */
/* It will also return the <img...> tag and include any sizing  requested     */
/******************************************************************************/

function fnmap2cache ( $URL, $code, $pre, $width = "", $height = "", $keep = "0" ) {
  global $db, $prefix;

  $wh = new whini();
  $radar_cache = $wh->getrootradarpath();
  $url_img_path = $wh->getnukeradarpath();
  
  $IMGNAME = $pre.$code.substr( $URL, strrpos($URL, "/")+1);
  $target_file = $radar_cache.$IMGNAME;
  $url_target_file = $url_img_path.$IMGNAME;

  if ( file_exists($target_file) )
  {
	if ( $keep != "1" )										//Added $keep to save re-reads of bkgrnd images - layingback
	{
	  $NOW = time();
	  $LASTUPDATE = filemtime($target_file);
	
	  if ($NOW > ($LASTUPDATE + $wh->getcachetimeout()))
	  {
	    $return = "";
	    $MAPIN = fopen($URL, "rb");
	    while( !feof( $MAPIN ) )
	    {
	  	  $return .= fread($MAPIN, 1024);
	    }	
	    fclose($MAPIN);
	
	    $MAPOUT = fopen($target_file, "wb");
		fwrite($MAPOUT, $return);
		fclose($MAPOUT);
	  }
	}
  }
  else
  {
    $return = "";
    $MAPIN = fopen($URL, "rb");
	while( !feof( $MAPIN ) )
	{
      $return .= fread($MAPIN, 1024);
	}  
    fclose($MAPIN);
	
    $MAPOUT = fopen($target_file, "wb");
    fwrite($MAPOUT, $return);
    fclose($MAPOUT);
  }
  
  //$NEWURL = "";

  if ( $width != "" && $height !="" )
  {
    $NEWURL = "<img src=\"".$url_target_file."\" width=\"".$width."\" height=\"".$height."\" />";
  }
  else
  {
    $NEWURL = "<img src=\"".$url_target_file."\" />";
  }	

  return $NEWURL;
}

/***********************************************************************************************/
/* function fnShowLoopRadar( $id, $type )                                                      */
/* this function will loop radar for NOAA radars                                               */
/***********************************************************************************************/

function fnShowLoopRadar() {
  global $prefix, $db, $NOAAMaskLoopPath, $NOAAMaskLoopInfo, $bkgrndimgS, $bkgrndimgL;	//Added $bkgrndimgS & L - layingback;
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');

  $wh = new whini();
  $radarscale = $wh->getradarscale();									//Add radarscale retrieval - layingback

  $NOAARidgeWidth = "600";												//Current images sizes from NOAA Ridge - layingback
  $NOAARidgeHeight = "550";
  
  $width = round($NOAARidgeWidth * $radarscale / "100");								//Set previously undeclared width & height - layingabck
  $height = round($NOAARidgeHeight * $radarscale / "100");

  $sql = "select code, repstation, primaryradar, secondaryradar, userradar from ".$prefix."_weatherstations where id='".$id."'";
  $result = $db->sql_query( $sql );
  $row = $db->sql_fetchrow( $result );

  $repstation = ucwords( $row['repstation'] );
  $code = $row['code'];

  // set up the type of radar to display
$type = isset($_POST['type'])?$_POST['type']:(isset($_GET['type'])?$_GET['type']:'');
  switch( $type )
  {
    case _SHORT_REF:
      $radarpath = ereg_replace( ":radartype:", _SHORTREFLECTIVITY, $NOAAMaskLoopPath );
	  $infopath = ereg_replace( ":radartype:", _SHORTREFLECTIVITY, $NOAAMaskLoopInfo );
      $title = $repstation."<br />"._SHORT_REF_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

    case _LONG_REF:
      $radarpath = ereg_replace( ":radartype:", _LONGREFLECTIVITY, $NOAAMaskLoopPath );
	  $infopath = ereg_replace( ":radartype:", _LONGREFLECTIVITY, $NOAAMaskLoopInfo );
      $title = $repstation."<br />"._LONG_REF_RADAR;
      $bkgrndimg = $bkgrndimgL;														//Short or Long bkgrnds - layingback
      break;

    case _SHORT_COMP:
      $radarpath = ereg_replace( ":radartype:", _SHORTCOMPOSITE, $NOAAMaskLoopPath );
	  $infopath = ereg_replace( ":radartype:", _SHORTCOMPOSITE, $NOAAMaskLoopInfo );
      $title = $repstation."<br />"._SHORT_COMP_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

//  case _LONG_COMP:																//No longer supported by NOAA - layingback
//    $radarpath = ereg_replace( ":radartype:", _LONGCOMPOSITE, $NOAAMaskLoopPath );
//	  $infopath = ereg_replace( ":radartype:", _LONGCOMPOSITE, $NOAAMaskLoopInfo );
//    $title = $repstation."<br />"._LONG_COMP_RADAR;
//    break;

    case _ONE_HOUR:
      $radarpath = ereg_replace( ":radartype:", _ONEHOURTOTAL, $NOAAMaskLoopPath );
	  $infopath = ereg_replace( ":radartype:", _ONEHOURTOTAL, $NOAAMaskLoopInfo );
      $title = $repstation."<br />"._ONE_HOUR_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;

    case _STORM_TOTAL:
      $radarpath = ereg_replace( ":radartype:", _STORMTOTAL, $NOAAMaskLoopPath );
 	  $infopath = ereg_replace( ":radartype:", _STORMTOTAL, $NOAAMaskLoopInfo );
      $title = $repstation."<br />"._STORM_TOTAL_RADAR;
      $bkgrndimg = $bkgrndimgS;														//Short or Long bkgrnds - layingback
      break;
  }

  if ($row['primaryradar'] != "")
  {
    $primaryradar = ereg_replace( ":noaaradar:", $row['primaryradar'], $radarpath );
	$infopath = ereg_replace( ":noaaradar:", strtolower( $row['primaryradar'] ), $infopath );
  }
  else
  {
    $primaryradar = "";
  }
  
  $db->sql_freeresult( $result );
  
  $loop_list = array();
  
  if ( $primaryradar != "" )
  {
    // get the list of images
    error_reporting(0);

    $files = file( $infopath );

    restore_error_handler();

    reset( $files );
    if ( $files !== false ) 
    {
      foreach( $files as $line )
	  {
//	  if ( preg_match( "/(dd\.[0-9]{8}_dt\.[0-9]{6}\..{3})/", $line, $buffer ) != 0 )  // Edited to filename format - layingback
	  if ( preg_match( "/(.{3}_[0-9]{8}_[0-9]{4}_.{3}\..{3})/", $line, $buffer ) != 0 )
	    {
	      $loop_list[] = $buffer[1];
	    }
//	    else if ( preg_match( "/(dd\.[0-9]{8}_dt\.[0-9]{6}_rd\.[0-9]{8}_rt\.[0-9]{6}\..{3})/", $line, $buffer ) != 0 ) // Deleted - layingback
//	    {  
//	      $loop_list[] = $buffer[1];
//	    }
	  }
	
      reset( $loop_list );


      include("header.php");
      OpenTable();

      echo "<table width=\"100%\"><tr><th colspan=\"2\">\n";
      echo $title."</th></tr><tr><td valign=\"top\">";

      fnOptionalRadarMenu();

      echo "</td><td width=\"100%\" valign=\"top\">";

      fnBuildJSLoop( $title, $primaryradar, $loop_list, $row['primaryradar'], $bkgrndimg, $width, $height );

      echo "</td></tr></table>\n";

      CloseTable();
      include("footer.php");
    }
    else
      fnShowAllRadar();
  }
  else
    fnShowAllRadar();
}
?>
