<?php
######################################################################
# Weather Magnet
# ============================================
#
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
#
#
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }
require_once("includes/cmsinit.inc");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/wh_ini.php" );
require_once( "modules/$module_name/wh_utils.php" );

$NOAAMarineZonePath = "http://weather.noaa.gov/pub/data/forecasts/marine/:type:/:stabbrev:/:zonefile:.txt";
/*******************************************************************************************/
/*                                                                                         */
/* function fnSelectWXMarine( $which = "0", $ocean = "")                                   */
/*                                                                                         */
/* Function allows you to select the WX for a region in the marine weather.  This is a do  */
/* it all function - the $which -> 0 = ocean, 1 = region                                   */
/*******************************************************************************************/

function fnSelectWXMarine( $which = "0", $ocean = "" )
{
  global $prefix, $db, $index, $module_name;
  
  $index = 1;
  
  include( "header.php" );
  OpenTable();
  
  switch( $which )
  {
    case "0":
	  echo "<table width=\"100%\"><tr><th>"._EXTENDED_WX_MARINE_OCEAN."</th></tr>\n";
      echo "<tr><td align=\"center\"><form method=\"post\" action=\"index.php?name=$module_name\">\n"
          ."<input type=\"hidden\" name=\"op\" value=\""._DIS_WX_MARINE."\">\n"
		  ."<input type=\"hidden\" name=\"which\" value=\"1\">\n"
          ."<select name=\"ocean\" size=\"20\">\n";

  // query database for all cities that allow extended forecasts
      $sql = "select DISTINCT ocean from ".$prefix."_weathermarine";
      $result = $db->sql_query( $sql );
      if ( $result ) 
      {
        $list = $db->sql_fetchrowset( $result );

        foreach( $list as $row )
        {
          echo "<option value=\"".$row[ocean]."\">".ucwords( $row[ocean] )."</option>\n";
        }
      }

      echo "</select><br /><input type=\"submit\" value=\""._SELECT_OCEAN."\"></form></td></tr>\n";
      echo "</table>\n";
      break;
	  
	case "1":
	  echo "<table width=\"100%\"><tr><th>"._EXTENDED_WX_MARINE_REGION.$ocean."</th></tr>\n";
      echo "<tr><td align=\"center\"><form method=\"post\" action=\"index.php?name=$module_name\">\n"
          ."<input type=\"hidden\" name=\"op\" value=\""._DIS_WXMARINEZONE."\">\n"
          ."<select name=\"id\" size=\"20\">\n";

  // query database for all cities that allow extended forecasts
      $sql = "select id, region from ".$prefix."_weathermarine where ocean ='".$ocean."'";
      $result = $db->sql_query( $sql );
      if ( $result ) 
      {
        $list = $db->sql_fetchrowset( $result );

        foreach( $list as $row )
        {
          echo "<option value=\"".$row[id]."\">".ucwords( $row[region] )."</option>\n";
        }
      }

      echo "</select><br /><input type=\"submit\" value=\""._SHOW_WXZONE."\"></form></td></tr>\n";
      echo "</table>\n";
	  break;  
  }
    
  CloseTable();
  include("footer.php" );
}

/************************************************************************************************************************************/
/*                                                                                                                                  */
/* function fnDisWXMarineZone( $id )                                                                                                  */
/*                                                                                                                                  */
/* function will display the zone information given the $id of the station requested                                                */
/************************************************************************************************************************************/

function fnDisWXMarineZone( $id )
{
  global $prefix, $db, $NOAAMarineZonePath;

  $typearray = array( "C" => "coastal",
                      "O" => "offshore" );

  $wh = new whini();
  $radar_cache = $wh->getrootcachepath();
    
  include( "header.php" );
  OpenTable();

  if ( $id == "" )
  {
    echo _INV_WXZONE_ID;
  }
  else
  {
    $sql = "select * from ".$prefix."_weathermarine where id = '".$id."'";
    $result = $db->sql_query( $sql );
    if ( $result ) 
    {
      $zone = $db->sql_fetchrow( $result );
 
      echo "<table width=\"100%\"><tr><th>"._EXT_FORECAST_FOR.$zone[region]."</th></tr><tr><td>\n";

      $type = $typearray[ $zone[type] ];

	  $zoneoutput = ereg_replace( ":stabbrev:", substr( $zone[wxzone], 0, 2 ), $NOAAMarineZonePath );
      $zoneoutput = ereg_replace( ":type:", $type, $zoneoutput );
	  $zoneoutput = ereg_replace( ":zonefile:", $zone[wxzone], $zoneoutput );
      $target_file = $radar_cache.$zone[wxzone].".txt";  // build the file that goes to cache
	  $target_file = fnLatestObsToCache( $zoneoutput, $target_file );
		  
      $synopsis = ereg_replace( ":stabbrev:", substr( $zone[synopsis], 0, 2 ), $NOAAMarineZonePath );
      $synopsis = ereg_replace( ":type:", $type, $synopsis );
	  $synopsis = ereg_replace( ":zonefile:", $zone[synopsis], $synopsis );
	  $syn_target_file = $radar_cache.$zone[synopsis].".txt";
	  $syn_target_file = fnLatestObsToCache( $synopsis, $syn_target_file );
	  
	  // get synopsis first
	  $return = fnReadFile( $syn_target_file );
	  if ( $return != "" )
	  {
	    $return = fnParseWXMarineSynopsis( $return );
	    echo $return;
	  }  
	
	  // get forecast	  
	  $return = fnReadFile( $target_file );
	  if ( $return == "" )
	  {
	    $return = _NO_DATA_AVAILABLE."<br />";
	  }
	  else
	  {
	    $return = fnParseWXZone( $return, $zone[wxzone], 0 );
	  }
		  
	  echo $return;
	  
      echo "</td></tr></table>\n";
    }
  }

  CloseTable();
  include( "footer.php");
}

/*******************************************************************************************/
/*                                                                                         */
/* function fnParseWXMarineSynopsis( $text )                                               */
/*                                                                                         */
/* function to parse out the synopsis of the weather for the selected marine region        */
/*                                                                                         */
/*******************************************************************************************/

function fnParseWXMarineSynopsis( $text )
{
  $exp_string = fnGetExpires( $text, _SYNOPSIS_EXPIRES );
  
  $temp_string = html_entity_decode( $text );
  $temp_string = ereg_replace( "&&(.*)","",$temp_string);
  $temp_string = ereg_replace( "\\$\\$.*","", $temp_string );
  $temp_string = rtrim( $temp_string );
  $temp_string = strstr( $temp_string, "SYNOPSIS" );
  if ( $temp_string != "" )
    $temp_string = strstr( $temp_string, "SYNOPSIS" );
  else
    $temp_string = _NO_MARINE_SYNOPSIS;
		
  $return_string = "<table width=\"99%\"><tr><td align=\"center\">".$temp_string."<br />".$exp_string."</td></tr></table>\n";
  	
  return ( $return_string );
}

?>
