<?php
######################################################################
# Weather Magnet
# ============================================
#
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
#
#
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }
require_once("includes/cmsinit.inc");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/wh_ini.php" );
require_once( "modules/$module_name/wh_utils.php" );

$NOAAMaskZonePath = "http://weather.noaa.gov/pub/data/forecasts/zone/:stabbrev:/:zonefile:.txt";
$NOAAMaskNowZonePath = "http://weather.noaa.gov/pub/data/forecasts/nowcast/:stabbrev:/:zonefile:.txt";
$NOAAMaskUrgentZonePath = "http://weather.noaa.gov/pub/data/watches_warnings/urgent_weather_message/:stabbrev:/:zonefile:.txt";
$NOAAMaskStRdUpZonePath = "http://weather.noaa.gov/pub/data/observations/state_roundup/:stabbrev:/:zonefile:.txt";

/******************************************************************************/
/* function fnSelectWXCity($which = "0", $country = "", $region = "")         */
/* Function allows you to select a WX for cities supporting extended weather. */
/* A do it all function - the $which -> 0 = COUNTRY, 1 = REGION, 2 = CITY     */
/******************************************************************************/

function fnSelectWXCity( $which = "0", $country = "", $region = "" ) {
  global $prefix, $db, $module_name;

  include("header.php");
  OpenTable();

  switch( $which )
  {
    case "0":
	  echo "<table width=\"100%\"><tr><th>"._EXTENDED_WX_SEL_COUNTRY."</th></tr>\n";
      echo "<tr><td align=\"center\"><form method=\"post\" action=\"index.php?name=$module_name\">\n"
          ."<input type=\"hidden\" name=\"op\" value=\""._DIS_WX_NEW_CITY."\">\n"
		  ."<input type=\"hidden\" name=\"which\" value=\"1\">\n"
          ."<select name=\"country\" size=\"20\">\n";

  // query database for all cities that allow extended forecasts
      $sql = "select DISTINCT country from ".$prefix."_weatherstations where fips != ''";
      $result = $db->sql_query( $sql );
      if ( $result ) 
      {
        $list = $db->sql_fetchrowset( $result );

        foreach( $list as $row )
        {
          $sql = "select * from ".$prefix."_weathercountries where abbrev='".$row['country']."'";
          $result = $db->sql_query( $sql );
          $val = $db->sql_fetchrow( $result );

          echo "<option value=\"".$row['country']."\">".ucwords( $val['name'] )."</option>\n";
        }
      }

      echo "</select><br /><input type=\"submit\" value=\""._SELECT_COUNTRY."\"></form></td></tr>\n";
      echo "</table>\n";
      break;
	  
	case "1":
	  echo "<table width=\"100%\"><tr><th>"._EXTENDED_WX_SEL_REGION.$country."</th></tr>\n";
      echo "<tr><td align=\"center\"><form method=\"post\" action=\"index.php?name=$module_name\">\n"
          ."<input type=\"hidden\" name=\"op\" value=\""._DIS_WX_NEW_CITY."\">\n"
		  ."<input type=\"hidden\" name=\"which\" value=\"2\">\n"
          ."<select name=\"region\" size=\"20\">\n";

  // query database for all cities that allow extended forecasts
      $sql = "select DISTINCT region from ".$prefix."_weatherstations where fips != '' and country='".$country."'";
      $result = $db->sql_query( $sql );
      if ( $result ) 
      {
        $list = $db->sql_fetchrowset( $result );

        foreach( $list as $row )
        {
          echo "<option value=\"".$row['region']."\">".ucwords( $row['region'])."</option>\n";
        }
      }

      echo "</select><br /><input type=\"submit\" value=\""._SELECT_REGION."\"></form></td></tr>\n";
      echo "</table>\n";
      break;
	  
	case "2":
	  echo "<table width=\"100%\"><tr><th>"._EXTENDED_WX_SEL_CITY.$region."</th></tr>\n";
      echo "<tr><td align=\"center\"><form method=\"post\" action=\"index.php?name=$module_name\">\n"
          ."<input type=\"hidden\" name=\"op\" value=\""._DIS_WXZONE."\">\n"
          ."<select name=\"id\" size=\"20\">\n";

  // query database for all cities that allow extended forecasts
      $sql = "select * from ".$prefix."_weatherstations where fips != '' and region ='".$region."'";
      $result = $db->sql_query( $sql );
      if ( $result ) 
      {
        $list = $db->sql_fetchrowset( $result );

        foreach( $list as $row )
        {
          echo "<option value=\"".$row['id']."\">".ucwords( $row['repstation'] )."</option>\n";
        }
      }

      echo "</select><br /><input type=\"submit\" value=\""._SHOW_WXZONE."\"></form></td></tr>\n";
      echo "</table>\n";
	  break;  
  }
  
  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnDisplayWXZone( $id )                                            */
/* function will display zone information given the $id of station requested  */
/******************************************************************************/

function fnDisplayWXZone( ) {
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
  global $prefix, $db, $NOAAMaskZonePath;
  
  $wh = new whini();
  $radar_cache = $wh->getrootcachepath();
    
  include( "header.php" );
  OpenTable();

  if ( $id == "" )
  {
    echo _INV_WXZONE_ID;
  }
  else
  {
    $sql = "select * from ".$prefix."_weatherstations where id = '".$id."'";
    $result = $db->sql_query( $sql );
    if ( $result ) 
    {
      $weatherstation = $db->sql_fetchrow( $result );
 
      echo "<table width=\"100%\"><tr><th>"._EXT_FORECAST_FOR.$weatherstation['repstation']."</th></tr><tr><td>\n";

      $sql = "select * from ".$prefix."_weatherzones where fips='".$weatherstation['fips']."'";
      $result = $db->sql_query( $sql );
	  if ( $result )
	  {
	    $weatherzones = $db->sql_fetchrowset( $result );
		foreach( $weatherzones as $zone )
		{
		  $zoneoutput = ereg_replace( ":stabbrev:", substr( $zone['wxzone'], 0, 2 ), $NOAAMaskZonePath );
		  $zoneoutput = ereg_replace( ":zonefile:", $zone['wxzone'], $zoneoutput );
          $target_file = $radar_cache.$zone['wxzone'].".txt";  // build the file that goes to cache
		  $target_file = fnLatestObsToCache( $zoneoutput, $target_file );
		  
		  // get forecast
		  $return = fnReadFile( $target_file );
		  if ( $return == "" )
		  {
		    $return = _NO_DATA_AVAILABLE."<br />";
		  }
		  else
		  {
		    $return = fnParseWXZone( $return, $zone['wxzone'], 0 );
		  }
		  
		  echo $return;
		}
	  }   
      echo "</td></tr></table>\n";
    }
  }

  CloseTable();
  include( "footer.php");
}

/******************************************************************************/
/* function fnDisplayNowWXZone( $id )                                         */
/* function to display current now cast and any uregne messages for given ID  */
/******************************************************************************/

function fnDisplayNowWXZone() {
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
  global $prefix, $db, $NOAAMaskNowZonePath;

  $wh = new whini();
  $radar_cache = $wh->getrootcachepath();
    
  include( "header.php" );
  OpenTable();

  if ( $id == "" )
  {
    echo _INV_WXZONE_ID;
  }
  else
  {
    $sql = "select * from ".$prefix."_weatherstations where id = '".$id."'";
    $result = $db->sql_query( $sql );
    if ( $result ) 
    {
      $weatherstation = $db->sql_fetchrow( $result );
 
      echo "<table width=\"100%\"><tr><th>"._NOW_FORECAST_FOR.$weatherstation['repstation']."</th></tr><tr><td>\n";

      $sql = "select * from ".$prefix."_weatherzones where fips='".$weatherstation['fips']."'";
      $result = $db->sql_query( $sql );
	  if ( $result )
	  {
	    $weatherzones = $db->sql_fetchrowset( $result );
		foreach( $weatherzones as $zone )
		{
		  $zoneoutput = ereg_replace( ":stabbrev:", substr( $zone['wxzone'], 0, 2 ), $NOAAMaskNowZonePath );
		  $zoneoutput = ereg_replace( ":zonefile:", $zone['wxzone'], $zoneoutput );
          $target_file = $radar_cache.$zone['wxzone']."now.txt";  // build the file that goes to cache
		  $target_file = fnLatestObsToCache( $zoneoutput, $target_file );
		  
		  // get forecast
		  $return = fnReadFile( $target_file );
		  if ( $return == "" )
		  {
		    $return = _NO_DATA_AVAILABLE."<br />";
		  }
		  else
		  {
		    $return = fnParseNowWXZone( $return );
		  }
		  
		  echo $return;
		}
	  }   
      echo "</td></tr></table>\n";
    }
	
    fnDisplayUrgentWXZone( $id );
	
	fnDisplayStRdUpWXZone( $id );
  }
  
  CloseTable();
  include( "footer.php");
}

/*********************************************************************************************************/
/*                                                                                                       */
/* function fnDisplayUrgentWXZone( $id )                                                                 */
/*                                                                                                       */
/* function to display any urgent messages from noaa                                                     */
/*********************************************************************************************************/

function fnDisplayUrgentWXZone( $id ) {
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
  global $db, $prefix, $NOAAMaskUrgentZonePath;
  
  $wh = new whini();
  $radar_cache = $wh->getrootcachepath();
    
  if ( $id == "" )
  {
    echo _INV_WXZONE_ID;
  }
  else
  {
    $sql = "select * from ".$prefix."_weatherstations where id = '".$id."'";
    $result = $db->sql_query( $sql );
    if ( $result ) 
    {
      $weatherstation = $db->sql_fetchrow( $result );
 
      echo "<table width=\"100%\"><tr><th>"._URGENTWX_MESSAGE_FOR.$weatherstation['repstation']."</th></tr><tr><td>\n";

      $sql = "select * from ".$prefix."_weatherzones where fips='".$weatherstation['fips']."'";
      $result = $db->sql_query( $sql );
	  if ( $result )
	  {
	    $weatherzones = $db->sql_fetchrowset( $result );
		foreach( $weatherzones as $zone )
		{
		  $zoneoutput = ereg_replace( ":stabbrev:", substr( $zone['wxzone'], 0, 2 ), $NOAAMaskUrgentZonePath );
		  $zoneoutput = ereg_replace( ":zonefile:", $zone['wxzone'], $zoneoutput );
          $target_file = $radar_cache.$zone['wxzone']."urg.txt";  // build the file that goes to cache
		  $target_file = fnLatestObsToCache( $zoneoutput, $target_file );
		  
		  // get forecast
		  $return = fnReadFile( $target_file );
		  if ( $return == "" )
		  {
		    $return = _NO_DATA_AVAILABLE."<br />";
		  }
		  else
		  {
		    $return = fnParseUrgentWXZone( $return );
		  }
		  
		  echo $return;
		}
	  }   
      echo "</td></tr></table>\n";
    }
  }
}

/*********************************************************************************************************/
/*                                                                                                       */
/* function fnDisplayStRdUpWXZone( $id )                                                                 */
/*                                                                                                       */
/* function to display any urgent messages from noaa                                                     */
/*********************************************************************************************************/

function fnDisplayStRdUpWXZone( $id ) {
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
  global $db, $prefix, $NOAAMaskStRdUpZonePath;
  
  $wh = new whini();
  $radar_cache = $wh->getrootcachepath();
    
  if ( $id == "" )
  {
    echo _INV_WXZONE_ID;
  }
  else
  {
    $sql = "select * from ".$prefix."_weatherstations where id = '".$id."'";
    $result = $db->sql_query( $sql );
    if ( $result ) 
    {
      $weatherstation = $db->sql_fetchrow( $result );
 
      echo "<table width=\"100%\"><tr><th>"._STRDUPWX_MESSAGE_FOR."<br />".$weatherstation['repstation']."&nbsp;".$weatherstation['region']."</th></tr><tr><td>\n";

      $sql = "select * from ".$prefix."_weatherzones where fips='".$weatherstation['fips']."'";
      $result = $db->sql_query( $sql );
	  if ( $result )
	  {
	    $weatherzones = $db->sql_fetchrowset( $result );
		foreach( $weatherzones as $zone )
		{
		  $zoneoutput = ereg_replace( ":stabbrev:", substr( $zone['wxzone'], 0, 2 ), $NOAAMaskStRdUpZonePath );
		  $zoneoutput = ereg_replace( ":zonefile:", $zone['wxzone'], $zoneoutput );
          $target_file = $radar_cache.$zone['wxzone']."strdup.txt";  // build the file that goes to cache
		  $target_file = fnLatestObsToCache( $zoneoutput, $target_file );
		  
		  // get forecast
		  $return = fnReadFile( $target_file );
		  if ( $return == "" )
		  {
		    $return = _NO_DATA_AVAILABLE."<br />";
		  }
		  else
		  {
		    $return = fnParseStRdUpWXZone( $return );
		  }
		  
		  echo $return;
		}
	  }   
      echo "</td></tr></table>\n";
    }
  }
}
?>
