<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }
$module_name = "WeatherHarvest";
get_lang($module_name);
global $db, $prefix;

class whini {
  var $db;
  var $prefix;
  var $miniblock;
  var $userdefcity;
  var $showradar;
  var $radarloops;
  var $zippick;
  var $cachetimeout;
  var $nukecachepath;
  var $nukeradarpath;
  var $imageset;
  var $showbuoy;
  var $extendforecast;
  var $efdaysdisplay;
  var $marineforecast;
  var $radarscale;

	function whini() { // constructor, init all variables
		global $db, $prefix, $modheader, $weatherini;
		$modheader .= "<script type=\"text/javascript\" src=\"modules/WeatherHarvest/utils/animateImages.js\"></script>";

		if (!Cache::array_load('weatherini')) {
			$result = $db->sql_query('SELECT * FROM '.$prefix.'_weatherini');
		   	$row = $db->sql_fetchrow($result, SQL_ASSOC);
		   	foreach ($row as $var => $value) {
		   	    $weatherini[$var] = $value;
		   	}
			Cache::array_save('weatherini');
			$db->sql_freeresult($result);
		}

		if (!empty($weatherini)) {
			$this->setvars($weatherini);
		} else {
			$this->setvars(array( '','','1','Y','modules/WeatherHarvest/cache/','Y','Y','Y','N','1','Y','Y','5','Y','100' ));
		}
	}

  function fnGetIni() {
    return array( "nukecachepath" => $this->nukecachepath,
                  "imageset" => $this->imageset, 
                  "miniblock" => $this->miniblock, 
                  "nukeradarpath" => $this->nukeradarpath, 
                  "radarloops" => $this->radarloops, 
                  "showradar" => $this->showradar, 
                  "userdefcity" => $this->userdefcity, 
                  "zippick" => $this->zippick, 
                  "cachetimeout" => $this->cachetimeout, 
                  "showbuoy" => $this->showbuoy,
                  "extendforecast" => $this->extendforecast,
				  "efdaysdisplay" => $this->efdaysdisplay,
				  "marineforecast" => $this->marineforecast,
				  "radarscale" => $this->radarscale );
  }

  function setvars( $list ) {
   	$this->showbuoy = $list['showbuoy'];
	$this->cachetimeout = $list['cachetimeout'];
	$this->imageset = $list['imageset'];
	$this->miniblock = $list['miniblock'];
	$this->nukeradarpath = $list['nukeradarpath'];
	$this->radarloops = $list['radarloops'];
	$this->nukecachepath = $list['nukecachepath'];
	$this->showradar = $list['showradar'];
	$this->userdefcity = $list['userdefcity'];
	$this->zippick = $list['zippick'];
    $this->extendforecast = $list['extendforecast'];
	$this->efdaysdisplay = $list['efdaysdisplay'];
	$this->marineforecast = $list['marineforecast'];
	$this->radarscale = $list['radarscale'];
  }
  
	function fnUpdIni( $list ) {
		global $db, $prefix;
		$success = false;

		if ( $list ) {
			$this->setvars( $list );
			if ( $this->radarscale < 10 ) {
				$this->radarscale = 10;
				echo _INV_MIN_RADAR_SCALE."<br />";
			} elseif ( $this->radarscale >100 ) {
				$this->radarscale = 100;
				echo _INV_MAX_RADAR_SCALE."<br />";
			}
			$sql = "update ".$prefix."_weatherini set cachetimeout=\"".$this->cachetimeout 
                                                ."\", imageset=\"".$this->imageset
                                                ."\", miniblock=\"".$this->miniblock
                                                ."\", nukeradarpath=\"".$this->nukeradarpath
                                                ."\", radarloops=\"".$this->radarloops
                                                ."\", nukecachepath=\"".$this->nukecachepath
                                                ."\", showradar=\"".$this->showradar
                                                ."\", userdefcity=\"".$this->userdefcity
                                                ."\", zippick=\"".$this->zippick
												."\", showbuoy=\"".$this->showbuoy
                                                ."\", extendforecast=\"".$this->extendforecast
												."\", efdaysdisplay=\"".$this->efdaysdisplay
												."\", marineforecast=\"".$this->marineforecast
												."\", radarscale=\"".$this->radarscale."\"";
			if ( $db->sql_query($sql) ) {
				$success = true;
				echo _SUCCESS_UPD_INI;
				Cache::array_delete('weatherini');
				adminWHMenu();
			} else {
				echo _ERR_UPD_INI;
			}
		} else {
			echo _ERR_UPD_INI;
		}
		return $success;
	}

  function getradarscale() {
    return $this->radarscale;
  }

  function getradarloops() {
    return( $this->radarloops == "Y" ? true : false ); 
  }

  function getrootradarpath() {
    return $this->nukeradarpath;
   // return $_SERVER['DOCUMENT_ROOT']."/".$this->nukeradarpath;
  }

  function getimageset() {
    return $this->imageset;
  }

  function getminiblock() {
    return($this->miniblock == "Y" ? true : false );
  }

  function getnukeradarpath() {
    return $this->nukeradarpath;
  }

  function getconvertstrings() {
    return( $this->radarloops == "Y" ? true : false); 
  }

  function getrootcachepath() {
    return $this->nukecachepath;
    // return $_SERVER['DOCUMENT_ROOT']."/".$this->nukecachepath;
  }

  function getnukecachepath() {
    return $this->nukecachepath;
  }

  function getcachetimeout() {
    switch( $this->cachetimeout ) {
	  case 0:
	    $ret = 999999;  // essentially turned off...
		break;
		
      case 1:
	    $ret = 15 * 60;
		break;
		
	  case 2:
	    $ret = 30 * 60;
		break;
		
	  case 3:
	    $ret = 45 * 60;
		break;
		
	  case 4:
	    $ret = 60 * 60;
		break;
	}
    return $ret;
  }

  function getcachetimeout_raw()
  {
    return $this->cachetimeout;
  }

  function getshowradar()
  {
    return( $this->showradar == "Y" ? true : false ); 
  }
  
  function getuserdefcity()
  {
    return( $this->userdefcity == "Y" ? true : false );
  }
  
  function getzippick()
  {
    return $this->zippick;
  }

  function getshowbuoy()
  {
    return( $this->showbuoy == "Y" ? true : false );
  }

  function getextendforecast()
  {
    return( $this->extendforecast == "Y" ? true : false );
  }
  
  function getmarineforecast()
  {
    return( $this->marineforecast == "Y" ? true : false );
  }
  
  function getefdaysdisplay()
  {
    return( $this->efdaysdisplay );
  }
}

/********************************************************************************************/
/* function YesNoForm()                                                                     */
/* Draw simple Yes No form                                                                  */
/********************************************************************************************/

function YesNoForm( $value, $titletext, $selectname ) {
  $Yes = "";
  $No = "";

  if ($value == "Y") {
    $Yes = "SELCTED";
  } else {
    $No = "SELECTED";
  }

  echo $titletext."&nbsp;<select name=\"".$selectname."\">\n"
      ."<option value=\"Y\" ".$Yes.">"._YES."</option>\n"
      ."<option value=\"N\" ".$No.">"._NO."</option>\n"
      ."</select>\n";
}
?>
