<?php
######################################################################
# Weather Harvest
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/wh_radar.php" );
require_once( "modules/$module_name/wh_ini.php" );
require_once( "modules/$module_name/utils/radarjs.php" );

define("MAXT","MaxT"); // max temp
define("MINT","MinT"); // min temp
define("POP","PoP12");  // probability of precip
define("TWIND","T");  // current temp and wind
define("TDEW","Td");  // current dewpoint
define("WX","Wx");  // current weather
define("SKY","Sky"); // sky cover
define("WAVEH","WaveHeight"); // Wave height - good for great lakes and coasts

################################################################################
# replace :state: with the lowercase name of the state
# replace :graphic: with the define from above, the ordinal (count), and '_statename' in lowercase
################################################################################
define( "NOAAMaskDigiPath", "http://www.nws.noaa.gov/forecasts/graphical/images/:state:/:graphic:.png" );
define( "NOAAMaskDigiConus", "http://www.nws.noaa.gov/forecasts/graphical/images/conus/:which:_conus.png" );
define( "NOAAMaskThumbConus", "http://www.nws.noaa.gov/forecasts/graphical/images/thumbnail/Thumbnail_:which:_conus.png" );

###################################################################################
# function fnAltDigitalMenu( $id, $which )
# function gives the user another menu to view the other digital graphics available
###################################################################################

function fnAltDigitalMenu() {
  global $module_name;
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');

  echo "<table width=\"95%\"><tr><th>"._DIGITAL_MAPS."</th></tr><tr><td align=\"left\">\n";

$conus = isset($_POST['conus'])?$_POST['conus']:(isset($_GET['conus'])?$_GET['conus']:'');
  switch( $conus ) {
    case 0:
	  $op = _DIS_DIGITAL;
	  break;
	  
	case 1:
	  $op = _DIS_DIGITAL_CONUS;
	  break;  
  }
  
$which = isset($_POST['which'])?$_POST['which']:(isset($_GET['which'])?$_GET['which']:'');
  switch( $which ) {
    case MAXT:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case MINT:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case POP:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case TWIND:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case TDEW:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case WX:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case SKY:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WAVEH."\">"._WAVE_HEIGHT."</a><br />\n";
	  break;
	  
	case WAVEH:
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MAXT."\">"._MAX_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".MINT."\">"._MIN_TEMP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".POP."\">"._PROB_PRECIP."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TWIND."\">"._TEMP_WIND."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".TDEW."\">"._TEMP_DEWPT."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".WX."\">"._WEATHER_CONDITION."</a><br />\n";
      echo "<a href=\"index.php?name=".$module_name."&amp;op=".$op."&amp;id=".$id."&amp;which=".SKY."\">"._SKY_COVER."</a><br />\n";
	  break;              
  }	  
  
  echo "</td></tr></table>\n";
}

#############################################################################################
# function fnGetDigitalThumb( $id, $which )
# function will get the primary radar and return a link to a thumbnail of the original 
#############################################################################################

function fnGetDigitalThumb() {
  global $prefix, $db;
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');

  $wh = new whini();

  $sql = "select region from ".$prefix."_weatherstations where id='".$id."'";
  $result = $db->sql_query( $sql );
  if ( $result ) {
    $row = $db->sql_fetchrow( $result );
 // build the path to the radar image
    $lowcasestate = strtolower( $row['region'] );
	$lowcasestate = ereg_replace( " ", "", $lowcasestate );
	
	// check for special cases...
	// texas
	// california
	if ( $lowcasestate == "texas" )
	{
	  $lowcasestate = "southplains";
	}
	else if ( $lowcasestate == "california" )
	{
	  $lowcasestate = "pacsouthwest";
	}
	else if ( $lowcasestate == "alaska" || $lowcasestate == "hawaii" )
	{
	  return( "" );
	}
	
    $radarpath = ereg_replace( ":state:", $lowcasestate, NOAAMaskDigiPath );
    $radarpath = ereg_replace( ":graphic:", $which."1_".$lowcasestate, $radarpath );
	
    $db->sql_freeresult( $result );

    $return = fnmap2cache( $radarpath, "", "", "105", "147" );
  }
  else
  {
    $return = "ERROR -  Unable to retrieve digital thumbnail";
  }
  
  return( $return );
}
/******************************************************************************/
/* function fnShowDigital( $id, $which )                                      */
/* passed variable : $id - corresponds to database line in table weatherstations*/
/* function will display all corresponding defined radars for specified code  */
/******************************************************************************/

function fnShowDigital() {
  global $prefix, $db, $module_name;
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
$which = isset($_POST['which'])?$_POST['which']:(isset($_GET['which'])?$_GET['which']:'');

  $wh = new whini();

  $sql = "select region, repstation from ".$prefix."_weatherstations where id='".$id."'";
  $result = $db->sql_query( $sql );
  $row = $db->sql_fetchrow( $result );

  $repstation = $row['repstation'];
  $region = $row['region'];
  
 // build the path to the radar image
  $lowcasestate = strtolower( $region );
  $lowcasestate = ereg_replace( " ", "", $lowcasestate );
	
	// check for special cases...
	// texas
	// california
  if ( $lowcasestate == "texas" )
  {	
    $lowcasestate = "southplains";
  }
  else if ( $lowcasestate == "california" )
  {
    $lowcasestate = "pacsouthwest";
  }
  
  $radarpath = ereg_replace( ":state:", $lowcasestate, NOAAMaskDigiPath );
  $radarpath = ereg_replace( ":graphic:", $which."1_".$lowcasestate, $radarpath );

// get the conus graphic (thumbnail image)
  $conuspath = ereg_replace( ":which:", $which."1", NOAAMaskThumbConus );
  	
  $db->sql_freeresult( $result );

  $return = fnmap2cache( $radarpath, "", "", "", "" );
  $retconus = fnmap2cache( $conuspath, "", "", "", "" );
  
  switch( $which )
  {
    case MAXT:
	default:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation."<br />"._MAX_TEMP;
	  break;
	  
	case MINT:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation."<br />"._MIN_TEMP;
	  break;
	  
	case POP:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation.", ".$region."<br />"._PROB_PRECIP;
	  break;
	  
	case TWIND:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation.", ".$region."<br />"._TEMP_WIND;
	  break;
	  
	case TDEW:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation.", ".$region."<br />"._TEMP_DEWPT;
	  break;  
	  
	case WX:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation.", ".$region."<br />"._WEATHER_CONDITION;
	  break;
	  
	case SKY:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation.", ".$region."<br />"._SKY_COVER;
	  break;    

 	case WAVEH:
	  $title = _DIGITAL_WEATHER_TITLE."<br />".$repstation.", ".$region."<br />"._WAVE_HEIGHT;
	  break;    
 }	      

  include("header.php");
  OpenTable();

  echo "<table><tr><th colspan=\"2\">\n";
  echo $title."</th></tr><tr><td valign=\"top\">";
  echo "<a href=\"index.php?name=".$module_name."&amp;op="._DIS_DIGITAL_CONUS."&amp;id=".$id."&amp;which=$which\">".$retconus."</a>\n";
  fnAltDigitalMenu( $id, $which, 0 );
  echo "</td><td valign=\"top\"><table>";
  
  echo "<tr><td>".$return."</td></tr>\n";
  echo "</table></td></tr>";

  if ( isset($_GET['userradar']) != "" ) 
  {
    echo "<tr colspan=\"2\"><th>";
    $return = fnmap2cache( $_GET['userradar'], $code, "u".$type );
    echo _USR_REPORTING_STATION."</th></tr><tr><td>".$return."</td></tr>\n";
  }

  echo "</table>\n";

  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnShowDigitalConus( $id, $which )                                 */
/* passed variable : $id - corresponds to database line in table weatherstations*/
/* function will display all corresponding defined radars for specified code  */
/******************************************************************************/

function fnShowDigitalConus() {
  global $prefix, $db, $module_name;
$id = isset($_POST['id'])?$_POST['id']:(isset($_GET['id'])?$_GET['id']:'');
$which = isset($_POST['which'])?$_POST['which']:(isset($_GET['which'])?$_GET['which']:'');

  $wh = new whini();

  $sql = "select region, repstation from ".$prefix."_weatherstations where id='".$id."'";
  $result = $db->sql_query( $sql );
  $row = $db->sql_fetchrow( $result );

  $repstation = $row['repstation'];
  $region = $row['region'];
  
 // build the path to the radar image
  $lowcasestate = strtolower( $region );
  $lowcasestate = ereg_replace( " ", "", $lowcasestate );
	
	// check for special cases...
	// texas
	// california
  if ( $lowcasestate == "texas" )
  {
    $lowcasestate = "southplains";
  }
  else if ( $lowcasestate == "california" )
  {
    $lowcasestate = "pacsouthwest";
  }
	
  $radarpath = ereg_replace( ":state:", $lowcasestate, NOAAMaskDigiPath );
  $radarpath = ereg_replace( ":graphic:", $which."1_".$lowcasestate, $radarpath );

// get the conus graphic (thumbnail image)
  $conuspath = ereg_replace( ":which:", $which."1", NOAAMaskDigiConus );
  	
  $db->sql_freeresult( $result );

  $return = fnmap2cache( $radarpath, "", "", "105", "147" );
  $retconus = fnmap2cache( $conuspath, "", "", "", "" );
  
  switch($which) {
    case MAXT:
	default:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation."<br />"._MAX_TEMP;
	  break;
	  
	case MINT:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation."<br />"._MIN_TEMP;
	  break;
	  
	case POP:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation.", ".$region."<br />"._PROB_PRECIP;
	  break;
	  
	case TWIND:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation.", ".$region."<br />"._TEMP_WIND;
	  break;
	  
	case TDEW:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation.", ".$region."<br />"._TEMP_DEWPT;
	  break;  
	  
	case WX:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation.", ".$region."<br />"._WEATHER_CONDITION;
	  break;
	  
	case SKY:
	  $title = _DIGITAL_WEATHER_TITLE."<br />"._CONUS_DIGITAL."<br />".$repstation.", ".$region."<br />"._SKY_COVER;
	  break;    
  }	      

  include("header.php");
  OpenTable();

  echo "<table><tr><th colspan=\"2\">\n";
  echo $title."</th></tr><tr><td valign=\"top\">";
  echo "<a href=\"index.php?name=".$module_name."&amp;op="._DIS_DIGITAL."&amp;id=".$id."&amp;which=$which\">".$return."</a>\n";
  fnAltDigitalMenu( $id, $which, 1 );
  echo "</td><td valign=\"top\"><table>";
  
  echo "<tr><td>".$retconus."</td></tr>\n";
  echo "</table></td></tr>";

  if ( isset($_GET['userradar']) != "" ) 
  {
    echo "<tr colspan=\"2\"><th>";
    $return = fnmap2cache( $_GET['userradar'], $code, "u".$type );
    echo _USR_REPORTING_STATION."</th></tr><tr><td>".$return."</td></tr>\n";
  }

  echo "</table>\n";

  CloseTable();
  include("footer.php");
}

?>