<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################

class whblock {
	var $db;
	var $prefix;
	var $timedisplay;  // 0 - 12 hour, 1 - 24 hour
	var $datedisplay;  // 0 - MM/DD/YYYY, 1 - DD/MM/YYYY, 2 - YYYY/MM/DD
	var $yeardisplay; // 0 - YYYY, 1 - YY
	var $timezone; // display timezone flag
	var $timepos; // T = top, B = bottom
	var $fontsize; // small, medium, or large
	var $showregion; // yes, no
	var $showcountry; // yes, no
	var $blockwidth; // normal, slim
	var $measuretype; // both, standard, metric
	var $dawntime; // military number rounded to hour 100 - 2400
	var $dusktime; // military number rounded to hour 100 - 2400
	var $radarlink;  // yes, no
	var $stationlink; // yes, no
	var $summarylink; // yes, no
	var $wxzonelink; // yes, no
	var $nowwxzonelink; // yes, no - this is the now cast as in right now conditions...
	// the following are for the display of digital weather images in the block
	var $maxtemp; // yes, no
	var $mintemp; // yes, no
	var $pop; // yes, no
	var $twind; // yes, no
	var $tdew; // yes, no
	var $wx; // yes, no
	var $sky; // yes, no
	var $waveh;  // yes, no

	function whblock() { // constructor, init all variables
		global $db, $prefix, $weatherblock;

		if (!Cache::array_load('weatherblock')) {
			$result = $db->sql_query('SELECT * FROM '.$prefix.'_weatherblock');
		   	$row = $db->sql_fetchrow($result, SQL_ASSOC);
		   	foreach ($row as $var => $value) {
		   	    $weatherblock[$var] = $value;
		   	}
			Cache::array_save('weatherblock');
			$db->sql_freeresult($result);
		}
//		$this->setvars($weatherblock);

		if (!empty($weatherblock)) {
			$this->setvars($weatherblock);
		} else {
			$this->timedisplay = "1";  // 0 = 12 hour, 1 = 24 hour
			$this->datedisplay = "0"; // 0 = MMM DD, YYYY, 1 = DD MMM, YYYY, 2 = YYYY, MMM DD
			$this->yeardisplay = "0"; // 0 = YYYY, 1 = YY
			$this->timezone = "N"; // Y = yes, N = no
			$this->timepos = "T";  // T = top, B = bottom
			$this->fontsize = "M";  // S = small, M = medium, L = large
			$this->showregion = "Y"; // Y = yes, N = no
			$this->showcountry = "Y"; // Y = yes, N = no
			$this->blockwidth = "0"; // 0 = normal, 1 = narrow
			$this->measuretype = "0"; // 0 = both, 1 = standard, 2 = metric
			$this->dawntime = "600";
			$this->dusktime = "1800";
			$this->radarlink = "Y"; // Y = yes, N = no
			$this->stationlink = "Y"; // Y = yes, N = no
			$this->summarylink = "Y"; // Y = yes, N = no
			$this->wxzonelink = "Y"; // Y = yes, N = no
			$this->nowwxzonelink = "Y"; // Y = yes, N = no
			$this->maxtemp = "Y"; // Y = yes, N = no
			$this->mintemp = "Y"; // Y = yes, N = no
			$this->pop = "Y"; // Y = yes, N = no
			$this->twind = "Y"; // Y = yes, N = no
			$this->tdew = "Y"; // Y = yes, N = no
			$this->wx = "Y"; // Y = yes, N = no
			$this->sky = "Y"; // Y = yes, N = no 
			$this->waveh = "Y"; // Y = yes, N = no
		}
	}
/*
	$sql = "SELECT * FROM ".$prefix."_weatherblock";
    $result = $db->sql_query( $sql );
    if ($result) {
      $row = $db->sql_fetchrow( $result );
      $this->timedisplay = $row['timedisplay'];
      $this->datedisplay = $row['datedisplay'];
      $this->yeardisplay = $row['yeardisplay'];
	  $this->timezone = $row['timezone'];
	  $this->timepos = $row['timepos'];
      $this->fontsize = $row['fontsize'];
	  $this->showregion = $row['showregion'];
	  $this->showcountry = $row['showcountry'];
	  $this->blockwidth = $row['blockwidth'];
	  $this->measuretype = $row['measuretype'];
	  $this->dawntime = $row['dawntime'];
	  $this->dusktime = $row['dusktime'];
      $this->radarlink = $row['radarlink'];
      $this->stationlink = $row['stationlink'];
      $this->summarylink = $row['summarylink'];
      $this->wxzonelink = $row['wxzonelink'];
	  $this->nowwxzonelink = $row['nowwxzonelink'];
	  $this->maxtemp = $row['maxtemp'];
	  $this->mintemp = $row['mintemp'];
	  $this->pop = $row['pop'];
      $this->twind = $row['twind'];
      $this->tdew = $row['tdew'];
      $this->wx = $row['wx'];
      $this->sky = $row['sky']; 
      $this->waveh = $row['waveh'];  // yes, no
	} else {
      $this->timedisplay = "1";  // 0 = 12 hour, 1 = 24 hour
      $this->datedisplay = "0"; // 0 = MMM DD, YYYY, 1 = DD MMM, YYYY, 2 = YYYY, MMM DD
      $this->yeardisplay = "0"; // 0 = YYYY, 1 = YY
      $this->timezone = "N"; // Y = yes, N = no
	  $this->timepos = "T";  // T = top, B = bottom
      $this->fontsize = "M";  // S = small, M = medium, L = large
	  $this->showregion = "Y"; // Y = yes, N = no
	  $this->showcountry = "Y"; // Y = yes, N = no
	  $this->blockwidth = "0"; // 0 = normal, 1 = narrow
	  $this->measuretype = "0"; // 0 = both, 1 = standard, 2 = metric
	  $this->dawntime = "600";
	  $this->dusktime = "1800";
      $this->radarlink = "Y"; // Y = yes, N = no
      $this->stationlink = "Y"; // Y = yes, N = no
      $this->summarylink = "Y"; // Y = yes, N = no
      $this->wxzonelink = "Y"; // Y = yes, N = no
	  $this->nowwxzonelink = "Y"; // Y = yes, N = no
	  $this->maxtemp = "Y"; // Y = yes, N = no
	  $this->mintemp = "Y"; // Y = yes, N = no
	  $this->pop = "Y"; // Y = yes, N = no
      $this->twind = "Y"; // Y = yes, N = no
      $this->tdew = "Y"; // Y = yes, N = no
      $this->wx = "Y"; // Y = yes, N = no
      $this->sky = "Y"; // Y = yes, N = no 
      $this->waveh = "Y"; // Y = yes, N = no
    }
    $db->sql_freeresult( $result );
  }
*/
	function setvars( $list ) {
		$this->timedisplay = $list['timedisplay'];
		$this->datedisplay = $list['datedisplay'];
		$this->yeardisplay = $list['yeardisplay'];
		$this->timezone = $list['timezone'];
		$this->timepos = $list['timepos'];
		$this->fontsize = $list['fontsize'];
		$this->showregion = $list['showregion'];
		$this->showcountry = $list['showcountry'];
		$this->blockwidth = $list['blockwidth'];
		$this->measuretype = $list['measuretype'];
		$this->dawntime = $list['dawntime'];
		$this->dusktime = $list['dusktime'];
		$this->radarlink = $list['radarlink'];
		$this->stationlink = $list['stationlink'];
		$this->summarylink = $list['summarylink'];
		$this->wxzonelink = $list['wxzonelink'];
		$this->nowwxzonelink = $list['nowwxzonelink'];
		$this->maxtemp = $list['maxtemp'];
		$this->mintemp = $list['mintemp'];
		$this->pop = $list['pop'];
		$this->twind = $list['twind'];
		$this->tdew = $list['tdew'];
		$this->wx = $list['wx'];
		$this->sky = $list['sky']; 
		$this->waveh = $list['waveh'];
	}

	function fnUpdBlock( $list ) {
		global $db, $prefix;
		$success = false;

		if ( $list ) {
			$this->setvars( $list );
			$sql = "update ".$prefix."_weatherblock set timedisplay=\"".$this->timedisplay 
                                                ."\", datedisplay=\"".$this->datedisplay
                                                ."\", yeardisplay=\"".$this->yeardisplay
	                                            ."\", timezone=\"".$this->timezone
                                                ."\", timepos=\"".$this->timepos
                                                ."\", fontsize=\"".$this->fontsize
                                                ."\", showregion=\"".$this->showregion
                                                ."\", showcountry=\"".$this->showcountry
												."\", blockwidth=\"".$this->blockwidth
												."\", measuretype=\"".$this->measuretype
												."\", dawntime=\"".$this->dawntime
												."\", dusktime=\"".$this->dusktime
                                                ."\", radarlink=\"".$this->radarlink
                                                ."\", stationlink=\"".$this->stationlink
                                                ."\", summarylink=\"".$this->summarylink
                                                ."\", wxzonelink=\"".$this->wxzonelink
												."\", nowwxzonelink=\"".$this->nowwxzonelink
												."\", maxtemp=\"".$this->maxtemp = $list['maxtemp']
	                                            ."\", mintemp=\"".$this->mintemp = $list['mintemp']
	                                            ."\", pop=\"".$this->pop = $list['pop']
                                                ."\", twind=\"".$this->twind = $list['twind']
                                                ."\", tdew=\"".$this->tdew = $list['tdew']
                                                ."\", wx=\"".$this->wx = $list['wx']
                                                ."\", sky=\"".$this->sky = $list['sky'] 
                                                ."\", waveh=\"".$this->waveh = $list['waveh']
												."\"";
			if ( $db->sql_query( $sql ) ) {
				$success = true;
				echo _SUCCESS_UPD_BLOCK;
				Cache::array_delete('weatherblock');
				adminWHMenu();
			} else {
				echo _ERR_UPD_BLOCK;
			}
		} else {
			echo _ERR_UPD_BLOCK;
		}
		return $success;
	}

	function getmaxtemp() {
		return( $this->maxtemp == "Y" ? true : false );
	}

  function getmintemp()
  {
    return( $this->mintemp == "Y" ? true : false );
  }
  
  function getpop()
  {
    return( $this->pop == "Y" ? true : false );
  }
  
  function gettwind()
  {	
    return( $this->twind == "Y" ? true : false );
  }
  	
  function gettdew()
  {
    return( $this->tdew == "Y" ? true : false );
  }
  
  function getwx()
  {
    return( $this->wx == "Y" ? true : false );
  }
  
  function getsky()
  {
    return( $this->sky == "Y" ? true : false );
  }
  
  function getwaveh()
  {
    return( $this->waveh == "Y" ? true : false );
  }	

  function getnowwxzonelink()
  {
    return($this->nowwxzonelink == "Y" ? true : false );
  }
  
  function getwxzonelink()
  {
    return($this->wxzonelink == "Y" ? true : false );
  }

  function getradarlink()
  {
    return($this->radarlink == "Y" ? true : false );
  }

  function getstationlink()
  {
    return($this->stationlink == "Y" ? true : false );
  }

  function getsummarylink()
  {
    return($this->summarylink == "Y" ? true : false );
  }

  function gettimedisplay()
  {
    return $this->timedisplay;
  }
  
  function getdatedisplay()
  {
    return $this->datedisplay;
  }

  function getyeardisplay()
  {
    return $this->yeardisplay;
  }

  function gettimezone()
  {
    return( $this->timezone == "Y" ? true : false);
  }
  
  function getfontsize()
  {
    return $this->fontsize;
  }
  
  function gettimepos()
  {
    return $this->timepos;
  }
  
  function getshowregion()
  {
    return( $this->showregion == "Y" ? true : false);
  }
  
  function getshowcountry()
  {
    return( $this->showcountry == "Y" ? true : false);
  }
  
  function getblockwidth()
  {
    return $this->blockwidth;
  }
  
  function getdawntime()
  {
    return $this->dawntime;
  }
  
  function getdusktime()
  {
    return $this->dusktime;
  }
  
  function getmeasuretype()
  {
    return $this->measuretype;
  }
}

?>