<?php
######################################################################
# Weather Harvest
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }
$module_name = "WeatherHarvest";
get_lang($module_name);

require_once("modules/$module_name/wh_block.php");

function fnBuildJSLoop( $title, $filepath, $loop_list, $station, $bkgrndimg, $width, $height )
{
  global $db, $prefix;
  $anibtnpath = "modules/WeatherHarvest/images/anibtns";

// echo $filepath; print_r($loop_list); echo $station, print_r($bkgrndimg);

  echo "<div style=position:relative>";
    foreach ($bkgrndimg as $key => $bkgrndpath) {														// Added - layingback
	  $radarbkgrnd = ereg_replace( ":noaaradar:", $station, $bkgrndpath );								// Added - layingback
	  $bkreturn = fnmap2cache( $radarbkgrnd, $key, "bS", $width, $height, "1" );									// Added - layingback
	  echo "<div style=\"z-index:".$key.";position:absolute;top:68px;left:8px\">".$bkreturn."</div>";	// Added - layingback
    }																									// Added - layingback
  echo "<div style=\"z-index:5;position:absolute;top:0px;left:0px\"><noscript>\n";
  echo "  <hr WIDTH=\"80%\">\n"; 
  echo "  <br />\n";
  echo "  <p><img name=\"animation\" src=\"".$filepath."/".current( $loop_list )."\" alt=\"".$title."\" border=\"0\"\" width=\"".$width."\" height=\"".$height."\" /></div><br />\n";
  echo _NOSCRIPT_LOOP_MSG;
  echo "<br /></div>";

  foreach( $loop_list as $filename )
  {
    echo "<a href=\"".$filepath."/".$filename.">".$filename."</a>\n";   
    echo "<br />\n";
  }

  reset( $loop_list );
  echo "</noscript>\n";

  echo "<script type=\"text/javascript\">\n";
  echo "var preloadedImages=new Array();\n";
  echo "function preloadimages()\n"
      ."{\n"
      ."  for( i = 0; i < preloadimages.arguments.length; i++ )\n"
      ."  {\n"
      ."    preloadedImages[i]=new Image();\n"
      ."    preloadedImages[i].src=preloadimages.arguments[i];\n"
      ."  }\n"
      ."}\n";

  echo "// maxPause: repeat final frame n times before restarting loop\n";
  echo "maxPause = 10;\n"
      ."numberOfSpeeds = 20;\n"
      ."// initSpeed: initial animation speed\n"
      ."initSpeed = 16;\n"
      ."speed = initSpeed;\n"
      ."delay=400;\n";

  $numitems = count( $loop_list );
  $oneless = $numitems - 1;

  echo "numInitImages=".$numitems.";\n"
      ."index_startTime = ".$oneless.";\n"
      ."index_endTime = ".$oneless.";\n"
      ."startSelectedIndex = 0;\n"
      ."endSelectedIndex = 0;\n"
      ."icon_dir = '".$anibtnpath."';\n"
      ."lang = 'en';\n"
      ."imageTot=1;\n"
      ."var a_frames = new Array();\n";

  $cntr = 0;
  $wh = new whblock();

  foreach( $loop_list as $filename )
  {
    // get the date out of the name
    $formatted = "";

//	if ( preg_match( "/dd\.([0-9]{4})([0-9]{2})([0-9]{2})_dt\.([0-9]{2})([0-9]{2})([0-9]{2})/", $filename, $buffer ) )  // edited to new filename - layingback
	if ( preg_match( "/([0-9]{4})([0-9]{2})([0-9]{2})_([0-9]{2})([0-9]{2})_.{3}\..{3}/", $filename, $buffer ) )
    {
      $year = $buffer[1];
      $month = $buffer[2];
      $day = $buffer[3];
      $utc_hour = $buffer[4];
      $utc_min = $buffer[5];
      $utc_sec = $buffer[6];
      
      $timeofday = gettimeofday();
      $dst = ( $timeofday[dsttime] == 0 ? 0 : 1 );
      $ztime = gmmktime( $utc_hour, $utc_min, $utc_sec, $month, $day, $year, $dst );
      $timezonestr = ( $wh->gettimezone() === true ? " %Z" : "" );
      $formatted = "";
      $yearDone = false;


      switch( $wh->getdatedisplay() )  // Get date format
      {
        case "0": // MMM DD,
        default:
          $formatted = strftime( "%b %d, ", $ztime );
          break;

        case "1":  // DD MMM,
          $formatted = strftime( "%d %b, ", $ztime );
          break;

        case "2": // , MMM DD
          $yearDone = true;
          switch( $wh->getyeardisplay() )
          {
            case "0": // YYYY
            default:
              $formatted = strftime( "%Y ", $ztime );
              break;

            case "1": // YY
              $formatted = strftime( "%y ", $ztime );
              break;	
          }
          $formatted .= strftime( ", %b %d", $ztime );
          break;			
      }

      if ( $yearDone == false )
      {
        switch( $wh->getyeardisplay() )  // get year format
        {
          case "0": // YYYY
          default:
            $formatted .= strftime( "%Y ", $ztime );
            break;

          case "1": // YY
            $formatted .= strftime( "%y ", $ztime );
            break;	
        }
      }

      switch( $wh->gettimedisplay() )  // get time format
      {
        case "0":  // 12 hour
          $formatted .= strftime( "%H:%M".$timezonestr, $ztime );
          break;

        case "1": // 24 hour
        default:
          $formatted .= strftime( "%I:%M %p".$timezonestr, $ztime );
          break;
      }			
    }
    else
    {
      $formatted = $filename;
    }

    echo "theImagesComplete[$cntr]=\"".$filepath."/".$filename."\";\n";
    echo "a_frames[$cntr] = new Object();\n";
    echo "a_frames[$cntr].path = \"".$filepath."/".$filename."\";\n";
    echo "a_frames[$cntr].date = \"$formatted\";\n\n";
    $cntr++;
  }
  
  echo "function startup()\n"
      ."{\n"
      ."  //\n"
      ."  // startup: update the speed and frame text widgets\n"
      ."  //\n"
      ."  updateSpeedText();\n"
      ."  if (document.myform.TimeFrameStart)\n"
      ."  {\n"
      ."    document.myform.TimeFrameStart.selectedIndex = ".$oneless.";\n"
      ."    document.myform.TimeFrameEnd.selectedIndex = ".$oneless.";\n"
      ."  }\n"
      ."  else\n"
      ."  {\n"
      ."    startSelectedIndex = ".$oneless.";\n"
      ."    endSelectedIndex = ".$oneless.";\n"
      ."  }\n"
      ."  set_theImages(0);\n"
      ."  setDelay();\n"
      ."  preloadimages('".$anibtnpath."/slowdown_over.gif','".$anibtnpath."/speedup_over.gif', '".$anibtnpath."/speedreset_en_over.gif','".$anibtnpath."/speedreset_fr_over.gif','".$anibtnpath."/play_over.gif', '".$anibtnpath."/pause_over.gif', '".$anibtnpath."/first_over.gif', '".$anibtnpath."/prev_over.gif', '".$anibtnpath."/next_over.gif', '".$anibtnpath."/last_over.gif');\n"
      ."}\n\n";

  echo "function drawImageTextbox()\n"
      ."{\n"
      ."  tmp = '';\n"
      ."  tmp = '<div align=\"center\">';\n"
      ."  tmp += 'Image Date:&nbsp;'\n"
      ."  tmp += '<input type=\"hidden\" SIZE=\"7\"  Name=\"FrameText\" Value=\"\" onChange=\"updateFrameText()\" >';\n"
      ."  tmp += '<input type=\"text\" SIZE=\"22\" MAXLENGTH=\"30\" Name=\"ImageText\" Value=\"\" onChange=\"updateImageText()\" >';\n"
      ."  tmp += '</div>';\n"
      ."  return tmp;\n"
      ."}\n\n";

  echo "function setMouseOver(img)\n"
      ."{\n"
      ."  if (click_play == 1)\n"
      ."  {\n"
      ."     img.src='".$anibtnpath."/' + img.name + '_over.gif';\n"
      ."  }\n"
      ."  else\n"
      ."  {\n"
      ."    img.src='".$anibtnpath."/' + img.name + '_greyed.gif';\n"
      ."  }\n"
      ."}\n\n";

  echo "function setMouseOut(img)\n"
      ."{\n"
      ."  if (click_play == 1)\n"
      ."  {\n"
      ."    img.src='".$anibtnpath."/' + img.name + '.gif';\n"
      ."  }\n"
      ."  else\n"
      ."  {\n"
      ."    img.src='".$anibtnpath."/' + img.name + '_greyed.gif';\n"
      ."  }\n"
      ."}\n\n"; 

  echo "function drawButton(name, alt, clickFunction, over_img)\n"
      ."{\n"
      ."  // NS 4 doesn't support image button\n"
      ."  var browser = navigator.appName;\n"
      ."  var version = parseInt(navigator.appVersion);\n"
      ."  //alert(browser);\n"
      ."  //alert(version);\n"
      ."  if ((browser=='Netscape') &&  (version == 4))\n"
      ."  {\n"
      ."    if(name == 'play')\n"
      ."    {\n"
      ."      tmp = '<td><a href=\"javascript:'+ clickFunction+ '\"><img name=\"' + name + '\" src=\"".$anibtnpath."/' + name + '.gif\" alt=\"' + alt + '\" ';\n"
      ."      tmp += 'onMouseOver=document.myform.' + name + '.src=\"".$anibtnpath."/' + name + '_over.gif\" ';\n"
      ."      tmp += 'onMouseOut=document.myform.' + name + '.src=\"".$anibtnpath."/' + name + '.gif\" ';\n"
      ."    }\n"
      ."    else\n"
      ."    {\n"
      ."      tmp = '<td><a href=\"javascript:'+ clickFunction+ '\"><img name=\"' + name + '\" src=\"".$anibtnpath."/' + name + '_greyed.gif\" alt=\"' + alt + '\" ';\n"
      ."    }\n"
      ."    tmp += 'onClick=\"' + clickFunction + '\" border=\"0\" /></a></td>';\n"
      ."  }\n"
      ."  else\n"
      ."  {\n"
      ."    if(name == 'play')\n"
      ."    {\n"
      ."      tmp = '<td><img name=\"' + name + '\" src=\"".$anibtnpath."/' + name + '.gif\" alt=\"' + alt + '\" ';\n"
      ."      tmp += 'onMouseOver=document.myform.' + name + '.src=\"".$anibtnpath."/' + name + '_over.gif\" ';\n"
      ."      tmp += 'onMouseOut=document.myform.' + name + '.src=\"".$anibtnpath."/' + name + '.gif\" ';\n"
      ."    }\n"
      ."    else\n"
      ."    {\n"
      ."      tmp = '<td><img name=\"' + name + '\" src=\"".$anibtnpath."/' + name + '_greyed.gif\" alt=\"' + alt + '\"';\n"
      ."      tmp += 'onMouseOver=\"javascript:setMouseOver(this)\"; ';\n"
      ."      tmp += 'onMouseOut=\"javascript:setMouseOut(this)\"; ';\n"
      ."    }\n"
      ."    tmp += 'onClick=\"' + clickFunction + '\" /></td>';\n"
      ."  }\n"
      ."  return tmp;\n"
      ."}\n\n";

  echo "function drawControlButtons()\n"
      ."{\n"
      ."  tmp = '<table border=\"0\">';\n"
      ."  tmp += '<tr>';\n"
      ."  tmp += drawButton('play', 'Play', 'startPlay()');\n"
      ."  tmp += drawButton('pause', 'Pause', 'stopPlay()');\n"
      ."  tmp += drawButton('first', 'First image', 'firstImage()');\n"
      ."  tmp += drawButton('prev', 'Previous image', 'stepBackward()');\n"
      ."  tmp += drawButton('next', 'Next image', 'stepForward()');\n"
      ."  tmp += drawButton('last', 'Last image', 'lastImage()');\n"
      ."  tmp += '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Speed:</td>';\n"
      ."  tmp += drawButton('slowdown', 'Slower', 'slower()');\n"
      ."  tmp += drawButton('speedup', 'Faster', 'faster()');\n"
      ."  tmp += drawButton('speedreset_en', 'Reset', 'speedReset()');\n"
      ."  tmp += '<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>';\n"
      ."  tmp += '<td>';\n"
      ."  tmp += drawImageTextbox();\n"
      ."  tmp += '</td>';\n"
      ."  tmp += '</tr>';\n"
      ."  tmp += '</table>';\n"
      ."  tmp += '<br />';\n"
      ."  return tmp;\n"
      ."}\n\n";      

  echo "function drawControlButtons2()\n"
      ."{\n"
      ."  tmp = '<br />';\n"
      ."  tmp += '<div align=\"center\">';\n"
      ."  tmp += 'Speed:';\n"
      ."  tmp += '<input type=\"button\" Value=\" - \" onClick=\"slower()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" + \" onClick=\"faster()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\"\" onClick=\"speedReset()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" Play \" onClick=\"startPlay()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" Stop \" onClick=\"stopPlay()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" | < \" onClick=\"firstImage()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" < \" onClick=\"stepBackward()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" > \" onClick=\"stepForward()\">';\n"
      ."  tmp += '<input type=\"button\" Value=\" > | \" onClick=\"lastImage()\">';\n"
      ."  tmp += '</div>';\n"
      ."  tmp += '<br />';\n"
      ."  return tmp;\n"
      ."}\n\n";  

  echo "function drawForwardReverseRadio()\n"
      ."{\n"
      ."  return tmp;\n"
      ."}\n\n";

  reset( $loop_list );
  echo "function drawImage()\n"
      ."{\n"
      ."  tmp = '<P>';\n"
      ."  tmp += '<img name=\"animation\" src=\"".$filepath."/".current( $loop_list )."\" alt=\"$title\" border=\"0\"\" width=\"".$width."\" height=\"".$height."\" '\n"
      ."  tmp += ' />'\n"
      ."  tmp += '<br />';\n"
      ."  return tmp;\n"
      ."}\n\n"; 

  echo "function drawTimeFrameRadio()\n"
      ."{\n"
      ."  return tmp;\n"
      ."}\n\n";     

  echo "function drawTimeFrameSelect()\n"
      ."{\n"
      ."  return tmp;\n"
      ."}\n\n";


  echo "Temp = '<p><form name=\"myform\">';\n"
      ."Temp += drawControlButtons();\n"
      ."Temp += drawImage();\n"
      ."Temp += '</form></p>';\n";

  echo "document.write (Temp);\n"
      ."startPlay();\n"
      ."</script>\n";
}
?>
