<?php
//////////////////////////////////////////////////////////////
///  phpThumb() by James Heinrich <info@silisoftware.com>   //
//        available at http://www.silisoftware.com         ///
//////////////////////////////////////////////////////////////
//                                                          //
//         This code is released under the GNU GPL:         //
//           http://www.gnu.org/copyleft/gpl.html           //
//                                                          //
//    +-----------------------------------------------+     //
//    | If you do use this code somewhere, send me    |     //
//    | an email and tell me how/where you used it.   |     //
//    |                                               |     //
//    | phpThumb() is free to use according to the    |     //
//    | terms of the GPL. Donations also gratefully   |     //
//    | accepted from happy users :)                  |     //
//    | Please see http://www.silisoftware.com        |     //
//    |                                               |     //
//    | If you like phpThumb(), please consider       |     //
//    | writing a review at HotScripts.com:           |     //
//    | http://www.hotscripts.com/Detailed/25654.html |     //
//    +-----------------------------------------------+     //
//                                                          //
//////////////////////////////////////////////////////////////
///                                                         //
define('PHPTHUMB_VERSION', '1.3.0');                        //
// v1.3.0 - January 27, 2004                                //
//   * Added watermarking option to overlay thumbnails with //
//     a semi-transparent watermark image (copied from a    //
//     seperate source watermark image)                     //
//     (thanks arsyanarsyan*com)                           //
//   * Added option for absolute filenames (on both Windows //
//     and *nix) outside the DOCUMENT_ROOT directory        //
//   * Added debug output dump for diagnosing problems)     //
//                                                          //
// v1.2.8 - January 19, 2004                                //
//   * added ability to specify relative pathnames as well  //
//     as absolute pathnames (pathname is relative to the   //
//     location of phpThumb.php if the passed source does   //
//     not begin with "/"                                   //
//                                                          //
// v1.2.7 - January 7, 2004                                 //
//   * Added patch to allow use of PHP older than 4.1.0     //
//       (or GD without PNG support) for non-GD GIF support //
//       (thanks hostwebserverhotmail*com                  //
//                                                          //
// v1.2.6 - January 4, 2004                                 //
//   * Added patch to allow use of PHP older than 4.1.0     //
//     (without the superglobals arrays)                    //
//                                                          //
// v1.2.5 - December 26, 2003                               //
//   * Added configuration options for default output image //
//     format and max width/height                          //
//                                                          //
// v1.2.4 - December 20, 2003                               //
//   * Bugfix: temp directory for non-native GD support not //
//     always returning valid directory                     //
//   * Caching feature reintroduced (see configuration)     //
//                                                          //
// v1.2.3 - December 19, 2003                               //
//   * Added anti-hotlink code so the thumbnail script on   //
//     one domain cannot be used by another domain. The     //
//     list of allowed domains defaults to the current      //
//     domain but is configurable below as                  //
//     $config_nohotlink_valid_domains. The message, text   //
//     size, colors and whether to blank the image or not   //
//     are also configurable                                //
//   * Bugfix: URL image sources were not able to use the   //
//     non-GD GIF-reading functions                         //
//                                                          //
// v1.2.2 - December 17, 2003                               //
//   * Added option to use http:// URL as image source      //
//                                                          //
// v1.2.1 - December 11, 2003                               //
//   * Added option to get source data from a database      //
//     rather than a physical file                          //
//   * Bugfix: resize not proportional when wide image      //
//     limited more by max height than max width            //
//     Thanks mathias_strassergmx*net                      //
//   * Removed caching code                                 //
//                                                          //
// v1.2.0 - December 10, 2003                               //
//   * Added GIF support for versions of GD that do not     //
//     have built-in GIF support (v1.6.x) via the "GIF      //
//     Util" class by Fabien Ezber (www.yamasoft.com)       //
//     GD's built-in GIF-reading functions are faster, and  //
//     are present in PHP v4.3.0 or newer, but all versions //
//     of GD can display resized GIF thumbnails now.        //
//                                                          //
// v1.1.2 - October 26, 2003                                //
//   * check for source image existance to prevent text     //
//     error messages                                       //
//   * if GD not available, a GIF saying "no GD" is shown   //
//     instead of showing the original image                //
//                                                          //
// v1.1.1 - September 28, 2003                              //
//   * better resize code by sfisher10cox*net              //
//                                                          //
// v1.1.0 - September 1, 2003                               //
//   * initial public release                               //
//   * thumbnails can now be larger than source image       //
//   * graphical error messages                             //
//                                                          //
// v1.0.0 - January 7, 2002                                 //
//   * initial private release                              //
//                                                         ///
//////////////////////////////////////////////////////////////
///                                                         //
// Description:                                             //
//                                                          //
// phpThumb() uses the GD library to create thumbnails from //
// images (GIF, PNG or JPEG) on the fly. The output size is //
// configurable (can be larger or smaller than the source), //
// and the source may be the entire image or only a portion //
// of the original image. True color and resampling is used //
// if GD v2.0+ is available, otherwise low-color and simple //
// resizing is used.                                        //
// Source image can be a physical file on the server or can //
// be retrieved from a database                             //
// GIFs are supported on all versions of GD (even if GD     //
// does not have native GIF support) thanks to Fabien       //
// Ezber's GIF Util class.                                  //
// AntiHotlinking feature prevents other people from using  //
// your server to resize their thumbnails.                  //
// Caching feature reduces server load.                     //
//                                                          //
//                                                          //
// Usage:                                                   //
//                                                          //
// Call phpThumb() just like you would a normal image.      //
// Examples: <IMG SRC="phpThumb.php?src=/image.jpg&w=100">  //
// <IMG SRC="phpThumb.php?src=http://example.com/foo.jpg">  //
// (see www.silisoftware.com for more usage examples)       //
//                                                          //
// To use a database rather than physical files, you will   //
// need to configure the $SQLquery variable as well as the  //
// username/password/database. Sample code is included for  //
// MySQL, but it should be easy to subtitute for another.   //
// The sample code uses 'src' as the primary key in query.  //
// For example, to show the image for productID #123:       //
//  <IMG SRC="phpThumb.php?src=123&w=100">                  //
//                                                          //
//                                                          //
// Parameters:                                              //
//   w  = max width of output thumbnail in pixels           //
//   h  = max height of output thumbnail in pixels          //
//   f  = output image format ('jpeg', 'png', or 'gif')     //
//   q  = JPEG compression (1=worst, 99=best, 75=default)   //
//   sx = left side of source rectangle (default = 0)       //
//   sy = top side of source rectangle (default = 0)        //
//   sw = width of source rectangle (default = fullwidth)   //
//   sh = height of source rectangle (default = fullheight) //
//  wmf = filename of watermark image (default = none)      //
//  wmp = % opacity of watermark image (default = 50)       //
//  wmm = % margin to watermark image (default = 5)         //
//  wma = watermark alignment (default = BR = bottom-right) //
//        one of: BR, BL, TR, TL, C, R, L, T, B, *          //
//        B=bottom,T=top,L=left,R=right,C=centre,*=tile     //
//                                                          //
// Notes:                                                   //
// * Thumbnails will be scaled proportionately to fit in a  //
//   box of at most (width * height) pixels                 //
// * Thumbnail caching for URL or database sources requires //
//   an absolute directory name for $config_cache_directory //
//   Physical file cached thumbnails will be recreated if   //
//   the source file changes, but remote/database files     //
//   cannot (modification time isn't readily available)     //
// * If you need a GUI interface for a user to specify crop //
//   settings you can investigate 12cropimage:              //
//   http://one-two.net/12cropimage                         //
// * phpThumb() should work with PHP v4.0.6+, but seems to  //
//   have a few quirks before v4.1.0                        //
// * phpThumb() works fine with GD v1.x, but works better   //
//   with GD v2.0+ because of the true-color image support  //
//   and ImageCopyResampled(). Also, there appears to be a  //
//   bug in ImageCopyResized() which is used with GD v1.x   //
//   where the bottom and/or right line of pixels is set to //
//   the background color (due to a rounding error?)        //
//                                                         ///
//////////////////////////////////////////////////////////////

// this script relies on the superglobal arrays, fake it here for old PHP versions
if (phpversion() < '4.1.0') {
	$_SERVER  = $HTTP_SERVER_VARS;
	$_REQUEST = $HTTP_GET_VARS;
}

//////////////////////////////////////////////////////////////
// CONFIGURATION:

// * Default output configuration:
$config_output_format    = 'jpeg';                                 // default output format ('jpeg', 'png' or 'gif') - thumbnail will be output in this format (if available in your version of GD). This is always overridden by ?f=___ GETstring parameter
$config_output_maxwidth  = 0;                                      // default maximum thumbnail width.  If this is zero then default width  is the width  of the source image. This is always overridden by ?w=___ GETstring parameter
$config_output_maxheight = 0;                                      // default maximum thumbnail height. If this is zero then default height is the height of the source image. This is always overridden by ?h=___ GETstring parameter

// * Caching Configuration:
//$config_cache_directory = './cache/';                            // set the cache directory relative to the source image - must start with '.' (will not work to cache URL- or database-sourced images, use the absolute directory name below)
//$config_cache_directory = $_SERVER['DOCUMENT_ROOT'].'/cache/';   // set the cache directory to an absolute directory for all source images (must be used to cache URL- or database-sourced images)
$config_cache_directory = './';                                      // disable thumbnail caching

// * Anti-Hotlink Configuration:
$config_nohotlink_enabled       = true;                            // If false will allow thumbnailing from any source domain
$config_nohotlink_valid_domains = array(@$_SERVER['HTTP_HOST']);   // This is the list of domains for which thumbnails are allowed to be created. The default value of the current domain should be fine in most cases, but if neccesary you can add more domains in here, in the format 'www.example.com'
$config_nohotlink_erase_image   = true;                            // if true, thumbnail is covered up with $config_nohotlink_fill_color before text is applied
$config_nohotlink_fill_hexcolor = 'CCCCCC';                        // background color - usual HTML-style hex color notation
$config_nohotlink_text_hexcolor = 'FF0000';                        // text color       - usual HTML-style hex color notation
$config_nohotlink_text_message  = 'Hotlinking is not allowed!';    // Say whatever you want here
$config_nohotlink_text_fontsize = 3;                               // 1 is smallest, 5 is largest
//////////////////////////////////////////////////////////////

if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
	define('PHPTHUMB_ISWINDOWS', true);
	define('PHPTHUMB_OSSLASH',   '\\');
} else {
	define('PHPTHUMB_ISWINDOWS', false);
	define('PHPTHUMB_OSSLASH',   '/');
}


if (!function_exists('gd_info')) {
	// built into PHP v4.3.0+ (with bundled GD2 library)
	function gd_info() {
		ob_start();
		phpinfo();
		$phpinfo = ob_get_contents();
		ob_end_clean();

		// based on code by johnschaefer at gmx dot de
		// from PHP help on gd_info()
		$gd_info = array(
			'GD Version'         => '',
			'FreeType Support'   => false,
			'FreeType Support'   => false,
			'FreeType Linkage'   => '',
			'T1Lib Support'      => false,
			'GIF Read Support'   => false,
			'GIF Create Support' => false,
			'JPG Support'        => false,
			'PNG Support'        => false,
			'WBMP Support'       => false,
			'XBM Support'        => false
		);
		foreach(explode("\n", $phpinfo) as $line) {
			foreach ($gd_info as $key => $value) {
				if (strpos($line, $key) !== false) {
					$newvalue = trim(str_replace($key, '', strip_tags($line)));
					$gd_info[$key] = (($newvalue == 'enabled') ? true : $newvalue);
				}
			}
		}
		return $gd_info;
	}
}

function gd_version($fullstring=false) {
	$gd_info = gd_info();
	if (substr($gd_info['GD Version'], 0, strlen('bundled (')) == 'bundled (') {
		if ($fullstring) {
			return $gd_info['GD Version']; // e.g. "1.6.2 or higher"
		}
		return (float) substr($gd_info['GD Version'], strlen('bundled ('), 3); // "2.0" (not "bundled (2.0.15 compatible)")
	}
	if ($fullstring) {
		return $gd_info['GD Version']; // e.g. "1.6.2 or higher"
	}
	return (float) substr($gd_info['GD Version'], 0, 3);     // e.g. "1.6" (not "1.6.2 or higher")
}

function ImageHexColorAllocate(&$img, $HexColorString) {
	$R = hexdec(substr($HexColorString, 0, 2));
	$G = hexdec(substr($HexColorString, 2, 2));
	$B = hexdec(substr($HexColorString, 4, 2));
	return ImageColorAllocate($img, $R, $G, $B);
}

function ErrorImage($text, $width=400, $height=100, $bgcolor='CCCCFF', $textcolor='FF0000') {
	$fontsize = 1;

	$LinesOfText = explode("\n", wordwrap($text, floor($width / ImageFontWidth($fontsize)), "\n", true));
	$height = max($height, count($LinesOfText) * ImageFontHeight($fontsize));

	if ($errorimg = ImageCreate($width, $height)) {

		$background_color = ImageHexColorAllocate($errorimg, $bgcolor);
		$text_color       = ImageHexColorAllocate($errorimg, $textcolor);

		ImageFilledRectangle($errorimg, 0, 0, $width, $height, $background_color);
		$lineYoffset = 0;
		foreach ($LinesOfText as $line) {
			ImageString($errorimg, $fontsize, 2, $lineYoffset, $line, $text_color);
			$lineYoffset += ImageFontHeight($fontsize);
		}
		$imagetypes = imagetypes();
		if ($imagetypes & IMG_PNG) {
			header('Content-type: image/png');
			ImagePNG($errorimg);
		} elseif ($imagetypes & IMG_GIF) {
			header('Content-type: image/gif');
			ImageGIF($errorimg);
		} elseif ($imagetypes & IMG_JPG) {
			header('Content-type: image/jpeg');
			ImageJPEG($errorimg);
		} else {
			echo $text;
		}
		ImageDestroy($errorimg);

	} else {

		echo $text;

	}
	ImageDestroy($errorimg);
	exit;
	return true;
}

// Set default output format based on what image types are available
$imagetypes = imagetypes();
$AvailableImageOutputFormats = array();
if ($imagetypes & IMG_GIF) {
	$thumbnailFormat               = 'gif';
	$AvailableImageOutputFormats[] = 'gif';
}
if ($imagetypes & IMG_PNG) {
	$thumbnailFormat               = 'png';
	$AvailableImageOutputFormats[] = 'png';
}
if ($imagetypes & IMG_JPG) {
	$thumbnailFormat               = 'jpeg';
	$AvailableImageOutputFormats[] = 'jpeg';
}
if (in_array($config_output_format, $AvailableImageOutputFormats)) {
	// set output format to config default if that format is available
	$thumbnailFormat = $config_output_format;
}
if (!empty($_REQUEST['f']) && (in_array($_REQUEST['f'], $AvailableImageOutputFormats))) {
	// override output format if $_REQUEST['f'] is set and that format is available
	$thumbnailFormat = $_REQUEST['f'];
}

// for JPEG images, quality 0 (worst) to 100 (best)
// quality < 25 is nasty, with not much size savings - not recommended
// problems with 100 - invalid JPEG?
$thumbnailQuality = max(1, min(99, (!empty($_REQUEST['q']) ? $_REQUEST['q'] : 75)));

if (!empty($_REQUEST['src'])) {

	////////////////////////////////////////////////////////////////
	// Optional thumbnail caching - see configuration above
	$cache_filename = '';
	if (!empty($config_cache_directory)) {
		if (PHPTHUMB_ISWINDOWS) {
			$config_cache_directory = str_replace(PHPTHUMB_OSSLASH, '/', $config_cache_directory);
		}
		if (($config_cache_directory{0} == '.') && (substr($_REQUEST['src'], 0, 1) == '/')) {
			// resolve relative cache directory to source image
			$config_cache_directory = realpath(dirname($_SERVER['DOCUMENT_ROOT'].$_REQUEST['src']).'/'.$config_cache_directory);
		}
		if (substr($config_cache_directory, -1) == '/') {
			$config_cache_directory = substr($config_cache_directory, 0, -1);
		}
		if (is_dir($config_cache_directory) && is_writable($config_cache_directory)) {
			$cache_filename  = $config_cache_directory.'/phpThumb_cache';
			$cache_filename .= '.'.urlencode($_REQUEST['src']);
			$cache_filename .= '.'.intval(@$_REQUEST['h']);
			$cache_filename .= '.'.intval(@$_REQUEST['w']);
			$cache_filename .= '.'.intval(@$_REQUEST['sx']);
			$cache_filename .= '.'.intval(@$_REQUEST['sy']);
			$cache_filename .= '.'.intval(@$_REQUEST['sw']);
			$cache_filename .= '.'.intval(@$_REQUEST['sh']);
			$cache_filename .= '.'.intval(@filemtime($_SERVER['DOCUMENT_ROOT'].$_REQUEST['src']));
			$cache_filename .= '.'.$thumbnailQuality;
			$cache_filename .= '.'.$thumbnailFormat;

			if (is_file($cache_filename)) {
				header('Content-type: image/'.$thumbnailFormat);
				readfile($cache_filename);
				exit;
			}
		}
	}
	////////////////////////////////////////////////////////////////

	// You may want to pull data from a database rather than a physical file
	// If so, uncomment the following $SQLquery line (modified to suit your database)

	//$SQLquery = 'SELECT `Picture` FROM `products` WHERE (ProductID = "'.mysql_escape_string($_REQUEST['src']).'")';
	if (!empty($SQLquery)) {

		// change this information to match your server
		$server   = 'localhost';
		$username = 'user';
		$password = 'password';
		$database = 'database';
		if ($cid = mysql_connect($server, $username, $password)) {
			if (mysql_select_db($database, $cid)) {
				$result = mysql_query($SQLquery, $cid);
				if ($row = @mysql_fetch_array($result)) {
					$OriginalImageData = $row[0];
				} else {
					ErrorImage('no matching data in database', 400, 50);
				}
			} else {
				ErrorImage('cannot select MySQL database', 400, 50);
			}
		} else {
			ErrorImage('cannot connect to MySQL server', 400, 50);
		}

	} elseif (substr($_REQUEST['src'], 0, strlen('http://')) == 'http://') {

		if ($fp = @fopen($_REQUEST['src'], 'rb')) {

			$OriginalImageData = '';
			do {
				$buffer = fread($fp, 8192);
				if (strlen($buffer) == 0) {
					break;
				}
				$OriginalImageData .= $buffer;
			} while (true);
			fclose($fp);

		} else {

			if (ini_get('allow_url_fopen')) {
				ErrorImage('cannot open '.$_REQUEST['src'], 400, 50);
			} else {
				ErrorImage('"allow_url_fopen" disabled', 400, 50);
			}

		}

	} else {

		if (PHPTHUMB_ISWINDOWS && (substr($_REQUEST['src'], 1, 1) == ':')) {
			// absolute pathname under windows
			$AbsoluteFilename = $_REQUEST['src'];
		} elseif (substr($_REQUEST['src'], 0, 1) == '/') {
			if (!file_exists($_SERVER['DOCUMENT_ROOT'].$_REQUEST['src']) && file_exists($_REQUEST['src'])) {
				// absolute filename under *nix
				$AbsoluteFilename = $_REQUEST['src'];
			} else {
				// relative filename under any OS
				$AbsoluteFilename = $_SERVER['DOCUMENT_ROOT'].$_REQUEST['src'];
			}
		} else {
			$AbsoluteFilename = $_SERVER['DOCUMENT_ROOT'].dirname($_SERVER['PHP_SELF']).'/'.$_REQUEST['src'];
		}
		if ($fp = @fopen($AbsoluteFilename, 'rb')) {

			$OriginalImageData = fread($fp, filesize($AbsoluteFilename));
			fclose($fp);

		} else {

			ErrorImage('cannot open "'.$AbsoluteFilename.'"', 400, 50);

		}

	}

	if (function_exists('ImageCreateFromString')) {
		if ($src = @ImageCreateFromString($OriginalImageData)) {
			// PHP's GD library before v1.5 can read (and write) GIFs
			// PHP's GD library after v2.0.(?) can read (not write) GIFs - bundled with PHP v4.3.0+
		} else {
			// PHP's GD library v1.6.x cannot read GIFs, so use "GIF Util" library by Fabien Ezber
			while (true) {
				if (@include_once('modules/WeatherHarvest/admin/phpThumb.gif.php')) {
					if (substr($_REQUEST['src'], 0, strlen('http://')) == 'http://') {
						// gif_loadFileToGDimageResource() cannot read from URLs, copy locally first
						if ($tempfilename = tempnam('*', '')) {
							if ($fp_tempfile = @fopen($tempfilename, 'wb')) {
								fwrite($fp_tempfile, $OriginalImageData);
								fclose($fp_tempfile);
								$src = gif_loadFileToGDimageResource($tempfilename);
								unlink($tempfilename);
								break;
							}
						}
					}
					$src = gif_loadFileToGDimageResource($AbsoluteFilename);
				}
				break;
			}
		}
		if ($src) {

			// all is good - source data read in and appears OK
			$width  = ImageSX($src);
			$height = ImageSY($src);

		} else {

			// cannot create image from string (unsupported image format)
			// simply output original (not resized/cropped) data and exit
			switch (substr($OriginalImageData, 0, 3)) {
				case 'GIF':
					header('Content-type: image/gif');
					break;
				case "\xFF\xD8\xFF":
					header('Content-type: image/jpeg');
					break;
				case "\x89".'PN':
					header('Content-type: image/png');
					break;
			}
			echo $OriginalImageData;
			exit;
		}

	} else { // GD functions not available

		// base64-encoded error images in GIF format
		$ERROR_NOGD = 'R0lGODlhIAAgALMAAAAAABQUFCQkJDY2NkZGRldXV2ZmZnJycoaGhpSUlKWlpbe3t8XFxdXV1eTk5P7+/iwAAAAAIAAgAAAE/vDJSau9WILtTAACUinDNijZtAHfCojS4W5H+qxD8xibIDE9h0OwWaRWDIljJSkUJYsN4bihMB8th3IToAKs1VtYM75cyV8sZ8vygtOE5yMKmGbO4jRdICQCjHdlZzwzNW4qZSQmKDaNjhUMBX4BBAlmMywFSRWEmAI6b5gAlhNxokGhooAIK5o/pi9vEw4Lfj4OLTAUpj6IabMtCwlSFw0DCKBoFqwAB04AjI54PyZ+yY3TD0ss2YcVmN/gvpcu4TOyFivWqYJlbAHPpOntvxNAACcmGHjZzAZqzSzcq5fNjxFmAFw9iFRunD1epU6tsIPmFCAJnWYE0FURk7wJDA0MTKpEzoWAAskiAAA7';
		header('Content-type: image/gif');
		echo base64_decode($ERROR_NOGD);
		exit;

	}

	$thumbnailSourceX      = (!empty($_REQUEST['sx']) ? $_REQUEST['sx'] : 0);
	$thumbnailSourceY      = (!empty($_REQUEST['sy']) ? $_REQUEST['sy'] : 0);
	$thumbnailSourceWidth  = (!empty($_REQUEST['sw']) ? $_REQUEST['sw'] : $width);
	$thumbnailSourceHeight = (!empty($_REQUEST['sh']) ? $_REQUEST['sh'] : $height);

	// limit source area to original image area
	$thumbnailSourceWidth  = min($thumbnailSourceWidth,  $width  - $thumbnailSourceX);
	$thumbnailSourceHeight = min($thumbnailSourceHeight, $height - $thumbnailSourceY);

	// default new width and height to source area
	$newwidth  = $thumbnailSourceWidth;
	$newheight = $thumbnailSourceHeight;
	if (($config_output_maxwidth > 0) && ($newwidth > $config_output_maxwidth)) {
		$maxwidth = $config_output_maxwidth;
		$newwidth = $maxwidth;
		$newheight = round($thumbnailSourceHeight * $newwidth / $thumbnailSourceWidth);
	}

	// if user sets width, save as max width
	// and compute new height based on source area aspect ratio
	if (!empty($_REQUEST['w'])) {
		$maxwidth = $_REQUEST['w'];
		$newwidth = $maxwidth;
		$newheight = round($thumbnailSourceHeight * $newwidth / $thumbnailSourceWidth);
	}

	// if user sets height, save as max height
	// if the max width has already been set and the new image is too tall,
	// compute new width based on source area aspect ratio
	// otherwise, use max height and compute new width
	if (!empty($_REQUEST['h']) || ($config_output_maxheight > 0)) {
		$maxheight = (!empty($_REQUEST['h']) ? $_REQUEST['h'] : $config_output_maxheight);
		if (isset($maxwidth)) {
			if ($newheight > $maxheight) {
				$newwidth = round($thumbnailSourceWidth * $maxheight / $thumbnailSourceHeight);
				$newheight = $maxheight;
			}
		} else {
			$newheight = $maxheight;
			$newwidth = round($thumbnailSourceWidth * $newheight / $thumbnailSourceHeight);
		}
	}

	if (gd_version() >= 2.0) {
		$im = ImageCreateTrueColor($newwidth, $newheight);
		ImageCopyResampled($im, $src, 0, 0, $thumbnailSourceX, $thumbnailSourceY, $newwidth, $newheight, $thumbnailSourceWidth, $thumbnailSourceHeight);
	} else {
		$im = ImageCreate($newwidth, $newheight);
		ImageCopyResized($im, $src, 0, 0, $thumbnailSourceX, $thumbnailSourceY, $newwidth, $newheight, $thumbnailSourceWidth, $thumbnailSourceHeight);
	}

	////////////////////////////////////////////////////////////////
	// Optional anti-offsite hijacking of the thumbnail script
	if ($config_nohotlink_enabled && (substr($_REQUEST['src'], 0, strlen('http://')) == 'http://')) {
		$parsed_url = parse_url($_REQUEST['src']);
		if (!in_array(@$parsed_url['host'], $config_nohotlink_valid_domains)) {
			// This domain is not allowed
			$config_nohotlink_fill_color = ImageHexColorAllocate($im, $config_nohotlink_fill_hexcolor);
			$config_nohotlink_text_color = ImageHexColorAllocate($im, $config_nohotlink_text_hexcolor);

			$config_nohotlink_text_array = explode("\n", wordwrap($config_nohotlink_text_message, floor($newwidth / ImageFontWidth($config_nohotlink_text_fontsize)), "\n"));
			if ($config_nohotlink_erase_image) {
				ImageFilledRectangle($im, 0, 0, $newwidth, $newheight, $config_nohotlink_fill_color);
			}
			$rowcounter = 0;
			foreach ($config_nohotlink_text_array as $textline) {
				ImageString($im, $config_nohotlink_text_fontsize, 2, $rowcounter++ * ImageFontHeight($config_nohotlink_text_fontsize), $textline, $config_nohotlink_text_color);
			}
		}
	}
	////////////////////////////////////////////////////////////////


	////////////////////////////////////////////////////////////////
	// Optional watermarking
	if (!empty($_REQUEST['wmf'])) {
		if (PHPTHUMB_ISWINDOWS && (substr($_REQUEST['wmf'], 1, 1) == ':')) {
			// absolute pathname under windows
			$WatermarkFilename = $_REQUEST['wmf'];
		} elseif (substr($_REQUEST['wmf'], 0, 1) == '/') {
			if (!file_exists($_SERVER['DOCUMENT_ROOT'].$_REQUEST['wmf']) && file_exists($_REQUEST['wmf'])) {
				// absolute filename under *nix
				$WatermarkFilename = $_REQUEST['wmf'];
			} else {
				// relative filename under any OS
				$WatermarkFilename = $_SERVER['DOCUMENT_ROOT'].$_REQUEST['wmf'];
			}
		} else {
			$WatermarkFilename = $_SERVER['DOCUMENT_ROOT'].dirname($_SERVER['PHP_SELF']).'/'.$_REQUEST['wmf'];
		}
		if (is_readable($WatermarkFilename)) {
			if ($fp_watermark = @fopen($WatermarkFilename, 'rb')) {
				$WatermarkImageData = fread($fp_watermark, filesize($WatermarkFilename));
				fclose($fp_watermark);
				if ($img_watermark = @ImageCreateFromString($WatermarkImageData)) {
					$src_x  = 0;
					$src_y  = 0;
					$src_w  = ImageSX($img_watermark);
					$src_h  = ImageSY($img_watermark);
					$pct    = (!empty($_REQUEST['wmp']) ? $_REQUEST['wmp'] : 50);
					$margin = (100 - (!empty($_REQUEST['wmm']) ? $_REQUEST['wmm'] : 5)) / 100;
					switch (@$_REQUEST['wma']) {
						case '*':
							if (gd_version() >= 2.0) {
								$img_tiledwatermark = ImageCreateTrueColor($newwidth, $newheight);
							} else {
								$img_tiledwatermark = ImageCreate($newwidth, $newheight);
							}
							// set the tiled image transparent color to whatever the untiled image transparency index is
							ImageColorTransparent($img_tiledwatermark, ImageColorTransparent($img_watermark));

							// tile the image as many times as can fit
							for ($x = round((1 - $margin) * $newwidth); $x < ($newwidth + $src_w); $x += round($src_w + ((1 - $margin) * $newwidth))) {
								for ($y = round((1 - $margin) * $newheight); $y < ($newheight + $src_h); $y += round($src_h + ((1 - $margin) * $newheight))) {
									ImageCopyMerge($img_tiledwatermark, $img_watermark, $x, $y, 0, 0, $src_w, $src_h, 99);

								}
							}
							$src_w  = ImageSX($img_tiledwatermark);
							$src_h  = ImageSY($img_tiledwatermark);
							$dest_x = 0;
							$dest_y = 0;
							ImageDestroy($img_watermark);
							$img_watermark = $img_tiledwatermark;
							break;
						case 'T':
							$dest_x = round((($newwidth  / 2) - ($src_w / 2)) + $margin);
							$dest_y = round((1 - $margin) * $newheight);
							break;
						case 'B':
							$dest_x = round((($newwidth  / 2) - ($src_w / 2)) + $margin);
							$dest_y = round(($newheight - $src_h) * $margin);
							break;
						case 'L':
							$dest_x = round((1 - $margin) * $newwidth);
							$dest_y = round((($newheight / 2) - ($src_h / 2)) + $margin);
							break;
						case 'R':
							$dest_x = round(($newwidth - $src_w)  * $margin);
							$dest_y = round((($newheight / 2) - ($src_h / 2)) + $margin);
							break;
						case 'C':
							$dest_x = round((($newwidth  / 2) - ($src_w / 2)) + $margin);
							$dest_y = round((($newheight / 2) - ($src_h / 2)) + $margin);
							break;
						case 'TL':
							$dest_x = round((1 - $margin) * $newwidth);
							$dest_y = round((1 - $margin) * $newheight);
							break;
						case 'TR':
							$dest_x = round(($newwidth - $src_w)  * $margin);
							$dest_y = round((1 - $margin) * $newheight);
							break;
						case 'BL':
							$dest_x = round((1 - $margin) * $newwidth);
							$dest_y = round(($newheight - $src_h) * $margin);
							break;
						case 'BR':
						default:
							$dest_x = round(($newwidth - $src_w)  * $margin);
							$dest_y = round(($newheight - $src_h) * $margin);
							break;
					}
					ImageCopyMerge($im, $img_watermark, $dest_x, $dest_y, $src_x, $src_y, $src_w, $src_h, $pct);
				}
			}
		}
	}
	////////////////////////////////////////////////////////////////


	////////////////////////////////////////////////////////////////
	// Debug output, to try and help me diagnose problems
	if (!empty($_REQUEST['phpThumbDebug'])) {
		$DebugOutput = array();
		$DebugOutput[] = 'phpThumb() version: '.PHPTHUMB_VERSION;
		$DebugOutput[] = 'gd_version() = '.gd_version(true);
		$DebugOutput[] = 'phpversion() = '.phpversion();
		$DebugOutput[] = 'PHP_OS = '.PHP_OS;
		$DebugOutput[] = '$thumbnailFormat = '.@$thumbnailFormat;
		$DebugOutput[] = '$thumbnailSourceX = '.@$thumbnailSourceX;
		$DebugOutput[] = '$thumbnailSourceY = '.@$thumbnailSourceY;
		$DebugOutput[] = '$newwidth = '.@$newwidth;
		$DebugOutput[] = '$newheight = '.@$newheight;
		$DebugOutput[] = '$thumbnailSourceWidth = '.@$thumbnailSourceWidth;
		$DebugOutput[] = '$thumbnailSourceHeight = '.@$thumbnailSourceHeight;
		$DebugOutput[] = '$WatermarkFilename = '.@$WatermarkFilename;
		$DebugOutput[] = '$AbsoluteFilename = '.@$AbsoluteFilename;
		$DebugOutput[] = '$SQLquery = '.@$SQLquery;
		$REQUESTarrayVars = array('src','w','h','f','q','sx','sy','sw','sh','wmf','wmp','wmm','wma');
		foreach ($REQUESTarrayVars as $value) {
			$DebugOutput[] = '$_REQUEST['.$value.'] = '.@$_REQUEST[$value];
		}
		ErrorImage(implode("\n", $DebugOutput));
	}
	////////////////////////////////////////////////////////////////


	ImageInterlace($im, 1);
	switch ($thumbnailFormat) {
		case 'jpeg':
			if ($cache_filename) {
				@ImageJPEG($im, $cache_filename, $thumbnailQuality);
			}
			header('Content-type: image/jpeg');
			ImageJPEG($im, '', $thumbnailQuality);
			break;
		case 'png':
			if ($cache_filename) {
				@ImagePNG($im, $cache_filename);
			}
			header('Content-type: image/png');
			ImagePNG($im);
			break;
		case 'gif':
			if ($cache_filename) {
				@ImageGIF($im, $cache_filename);
			}
			header('Content-type: image/gif');
			ImageGIF($im);
			break;
	}
	ImageDestroy($im);

} else {

	ErrorImage('Usage: '.$_SERVER['PHP_SELF'].'?src=/path/and/filename.jpg', 400, 50);

}

?>