<?php
######################################################################
# Weather Magnet
# ============================================
#
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
#
#
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('CPG_NUKE')) { exit; }
require_once("includes/cmsinit.inc");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/d_config.php");

/*********************************************************************************************************************************************/
/*                                                                                                                                           */
/* function fnSelectCountry()                                                                                                                */
/*                                                                                                                                           */
/* This function displays a list of countries a user can choose from.  It then calls the fnSelectRegion                                      */
/*********************************************************************************************************************************************/

function fnSelectCountry()
{
  global $module_name;

  include( "header.php" );

  OpenTable();
  global $db, $prefix;
  echo "<table width=\"100%\"><tr><td align=\"center\"><table><th align=\"center\">"._WEATHER_HARVEST
      ."</th><tr><td align=\"center\">"._PLS_SEL_COUNTRY."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
      ."<form METHOD=\"POST\" ACTION=\"index.php?name=$module_name\">\n"
      ."<input type=\"hidden\" name=\"op\" value=\""._SEL_REGION."\">\n"
      ."<select name=\"country\" size=\"20\">\n";

  $sql = "select DISTINCT country from ".$prefix."_weatherstations";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );

  foreach( $list as $row )
  {
    $sql = "select * from ".$prefix."_weathercountries where abbrev='".$row['country']."'";
    $result = $db->sql_query( $sql );
    $val = $db->sql_fetchrow( $result );

    echo "<option value=\"".$row['country']."\">".ucwords( $val['name'] )."</option>\n";
  }

  echo "</select><br /><input type=\"submit\" value=\""._SELECT_COUNTRY."\"></form>\n";
  echo "</form></td></tr></table></td></tr></table>\n";  
  CloseTable();

  include( "footer.php" );
}

/*********************************************************************************************************************************************/
/*                                                                                                                                           */
/* function fnSelectRegion                                                                                                                    */
/*                                                                                                                                           */
/* This function displays a list of states a user can choose from.  It then takes them to the select city function.                          */
/*********************************************************************************************************************************************/

function fnSelectRegion( $country )
{
  global $module_name, $db, $prefix;
  
  $sql = "select * from ".$prefix."_weathercountries where abbrev='".$country."'";
  $result = $db->sql_query( $sql );
  $val = $db->sql_fetchrow( $result );

  $sql = "select DISTINCT region from ".$prefix."_weatherstations where country='".$country."'";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );
  $db->sql_freeresult( $result );

  // check to see if region is filled in (could be blank for some countries)
  $fNoRegion = false;
  foreach( $list as $row )
  {
    if ( $row[region] == "" )
    {
      $fNoRegion = true;
      break;
    }
  }

  include( "header.php" );
  OpenTable();

  if ( $fNoRegion == false )
  {
    echo "<table width=\"100%\"><tr><td align=\"center\"><table><th align=\"center\">"._WEATHER_HARVEST
        ."</th><tr><td align=\"center\">"._PLS_SEL_ST.ucwords( $val['name'] )."</td></tr></table></td></tr>\n";
    echo "<tr><td><table align=\"center\">\n"
        ."<tr><td align=\"center\">"
	    ."<form METHOD=\"POST\" ACTION=\"index.php?name=$module_name\">\n"
        ."<input type=\"hidden\" name=\"op\" value=\""._SEL_CITY."\">\n"
        ."<select name=\"state\" size=\"20\">\n";
	  
    foreach( $list as $row )
    {
      echo "<option value=\"".$row['region']."\">".ucwords( $row['region'] )."</option>\n";
    }
  
    echo "</select><br /><input type=\"submit\" value=\""._SELECT_CITY."\"></form>\n";
    echo "</form></td></tr></table></td></tr></table>\n";  
  }
  else  // no region, so just display all cities for the country
  {

    echo "<table width=\"100%\"><tr><td align=\"center\"><table><th align=\"center\">"._WEATHER_HARVEST."</th>"
        ."<tr><td align=\"center\">"._PLS_SEL_CITY.ucwords( $val[name] )."</td></tr></table></td></tr>\n";
    echo "<tr><td><table align=\"center\">\n"
        ."<tr><td align=\"center\">"
        ."<form METHOD=\"POST\" ACTION=\"index.php?name=$module_name\">\n"
        ."<input type=\"hidden\" name=\"op\" value=\""._UPD_CITY."\">\n"
        ."<select name=\"code\" size=\"20\">\n";

    $sql = "select repstation, code from ".$prefix."_weatherstations where country='".$country."' order by repstation";
    $result = $db->sql_query($sql);
    $list = $db->sql_fetchrowset( $result );

    foreach( $list as $row )
    {
      echo "<option value=\"".$row['code']."\">".ucwords( $row['repstation'] )."</option>\n";
    }

    echo "</select><br /><input type=\"submit\" value=\""._SAVE_CITY."\"></form>\n";
    echo "</form></td></tr></table></td></tr></table>\n";  
  }

  CloseTable();
  include( "footer.php" );
}
/*************************************************************************************************************************************************/
/*                                                                                                                                               */
/* function fnSelectCity                                                                                                                         */
/* passed in variables: $region                                                                                                                  */
/*                                                                                                                                               */
/* This function requires a region to be passed in.  A list of cities, based on the region code are generated.  The user selects a city and the  */
/* database entry for the unique user will be updated.                                                                                           */
/*************************************************************************************************************************************************/

function fnSelectCity( $region )
{
  global $module_name;
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><td align=\"center\"><table><th align=\"center\">"._WEATHER_HARVEST."</th>"
      ."<tr><td align=\"center\">"._PLS_SEL_CITY.ucwords( $region )."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
	  ."<form METHOD=\"POST\" ACTION=\"index.php?name=$module_name\">\n"
      ."<input type=\"hidden\" name=\"op\" value=\""._UPD_CITY."\">\n"
	  ."<select name=\"code\" size=\"20\">\n";
	  
  $sql = "select repstation, code from ".$prefix."_weatherstations where region='".$region."' order by repstation";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );
   			 
  foreach( $list as $row )
  {
	echo "<option value=\"".$row['code']."\">".ucwords( $row['repstation'] )."</option>\n";
  }
  
  echo "</select><br /><input type=\"submit\" value=\""._SAVE_CITY."\"></form>\n";
  echo "</form></td></tr></table></td></tr></table>\n";  

  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnSaveDefaultCity                                                 */
/* variables passed in : $code                                                */
/* This function will save the code to the unique user.  Each time the user   */
/* is logged in, the block will use the users selection to generate the       */
/* weather report for their selected city.                                    */
/******************************************************************************/

function fnSaveDefaultCity( $code )
{
  global $db, $userinfo, $prefix;
  
  include( "header.php" );
  OpenTable();
  
  // validate the user
  if ( is_user() )
  {
      $uid = $userinfo["user_id"];
	
	// check to see if user is already in table
	$sql = "select * from ".$prefix."_weatherdefaults where uid='".$uid."'";
	$result = $db->sql_query( $sql );
	if ( $db->sql_numrows($result) == false )  // user does not exist
	{
	  $sql = "INSERT INTO ".$prefix."_weatherdefaults (`uid`, `code`) VALUES ('".$uid."', '".$code."');";
	  $result = $db->sql_query( $sql );
	}
	else // user does exist
	{
	  $sql = "update ".$prefix."_weatherdefaults set code='".$code."' where uid='".$uid."'";
	  $result = $db->sql_query( $sql );
	}
	
	if ( $result )
	{
	  echo $userinfo['username']._USER_DATA_SAVED;
	}
	else
	{
	  echo $userinfo['username']._USER_DATA_NOT_SAVED;
	}
  }
  else
  {
    echo _INV_USER_DATA;
  }
  
  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnSelectBuoy                                                      */
/* User selects a buoy and the database entry for the user will be updated.   */
/******************************************************************************/

function fnSelectBuoy( )
{
  global $module_name;
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><td align=\"center\"><table><th align=\"center\">"._WEATHER_HARVEST."</th>"
      ."<tr><td align=\"center\">"._PLS_SEL_BUOY."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
	  ."<form METHOD=\"POST\" ACTION=\"index.php?name=$module_name\">\n"
      ."<input type=\"hidden\" name=\"op\" value=\""._UPD_BUOY."\">\n"
	  ."<select name=\"buoy\" size=\"40\">\n";
	  
  fnBuoyStationOptions();
   
  echo "</select><br /><input type=\"submit\" value=\""._SAVE_BUOY."\"></form>\n";
  echo "</form></td></tr></table></td></tr></table>\n";  

  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnSaveDefaultBuoy                                                 */
/* variables passed in : $buoy                                                */
/* This function will save the buoy to the unique user.  Each time the user   */
/* is logged in, the block will use the users selection to generate the       */
/* weather report for their selected buoy.                                    */
/******************************************************************************/

function fnSaveDefaultBuoy( $buoy )
{
  global $db, $userinfo, $prefix;
  
  include( "header.php" );
  OpenTable();
  
  // validate the user
  if ( is_user() )
  {
      $uid = $userinfo["user_id"];
	
	// check to see if user is already in table
	$sql = "select * from ".$prefix."_weatherdefaults where uid='".$uid."'";
	$result = $db->sql_query( $sql );
	if ( $db->sql_numrows($result) == false )  // user does not exist
	{
	  $sql = "INSERT INTO ".$prefix."_weatherdefaults (`uid`, `buoy`) VALUES ('".$uid."', '".$buoy."');";
	  $result = $db->sql_query( $sql );
	}
	else // user does exist
	{
	  $sql = "update ".$prefix."_weatherdefaults set buoy='".$buoy."' where uid='".$uid."'";
	  $result = $db->sql_query( $sql );
	}
	
	if ( $result )
	{
	  echo $userinfo['username']._USER_DATA_SAVED;
	}
	else
	{
	  echo $userinfo['username']._USER_DATA_NOT_SAVED;
	}
  }
  else
  {
    echo _INV_USER_DATA;
  }
  
  CloseTable();
  include( "footer.php" );
}

?>