<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
#
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################

if (!defined('CPG_NUKE')) { exit; }
$module_name = basename(dirname(__FILE__));

require_once("modules/$module_name/user.php");
require_once("modules/$module_name/wh_utils.php");
require_once("modules/$module_name/wh_ini.php");
require_once("modules/$module_name/buoy.php");
require_once("modules/$module_name/summaries.php");
require_once("modules/$module_name/wh_marine.php");
require_once("modules/$module_name/wh_land.php");
require_once("modules/$module_name/wh_radar.php");
require_once("modules/$module_name/wh_digifc.php");

global $db, $prefix;

/******************************************************************************/
/* function fnDisplayRadarCountry()                                           */
/* function displays the avaiable countries                                   */
/******************************************************************************/

function fnDisplayRadarCountry()
{
  global $module_name;

  include( "header.php" );

  OpenTable();
  global $db, $prefix;
  echo "<table width=\"100%\"><tr><td align=\"center\"><table><tr><th align=\"center\">"._WH_RADAR_COUNTRY
      ."</th></tr><tr><td align=\"center\">"._PLS_SEL_COUNTRY."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
      ."<form method=\"post\" action=\"".getlink($module_name)."\">\n"
      ."<input type=\"hidden\" name=\"op\" value=\""._DIS_RADAR_REGION."\" />\n"
      ."<select name=\"country\" size=\"20\">\n";

  $sql = "select DISTINCT country from ".$prefix."_weatherstations";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );

  foreach( $list as $row ) {
    $sql = "select * from ".$prefix."_weathercountries where abbrev='".$row['country']."'";
    $result = $db->sql_query( $sql );
    $val = $db->sql_fetchrow( $result );

    echo "<option value=\"".$row['country']."\">".ucwords( $val['name'] )."</option>\n";
  }

  echo "</select><br /><input type=\"submit\" value=\""._SELECT_COUNTRY."\" /></form>\n";
  echo "</td></tr></table></td></tr></table>\n";  
  CloseTable();

}

/******************************************************************************/
/* function fnDisplayRadarRegion()                                            */
/* Function displays the available regions to choose from                     */
/******************************************************************************/

function fnDisplayRadarRegion( $country )
{
  global $module_name, $db, $prefix;

  $sql = "select * from ".$prefix."_weathercountries where abbrev='".$country."'";
  $result = $db->sql_query( $sql );
  $val = $db->sql_fetchrow( $result );
  
  include( "header.php" );

  OpenTable();
  
  echo "<table width=\"100%\"><tr><td align=\"center\"><table><tr><th align=\"center\">"._WH_RADAR_REGION
      ."</th></tr><tr><td align=\"center\">"._PLS_SEL_ST.ucwords( $val['name'])."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
      ."<form method=\"post\" action=\"".getlink($module_name)."\">\n"
      ."<input type=\"hidden\" name=\"op\" value=\""._DIS_RADAR_LIST."\">\n"
      ."<select name=\"region\" size=\"20\">\n";

  $sql = "select DISTINCT region from ".$prefix."_weatherstations where country='".$country."'";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );

  foreach( $list as $row )
  {
    echo "<option value=\"".$row['region']."\">".ucwords( $row['region'])."</option>\n";
  }

  echo "</select><br /><input type=\"submit\" value=\""._SELECT_REGION."\"></form>\n";
  echo "</td></tr></table></td></tr></table>\n";  
  CloseTable();

}

/******************************************************************************************************************************************/
/*                                                                                                                                        */
/* function fnDisplayRadarList()                                                                                                          */
/*                                                                                                                                        */
/* Function to display the list of available radars from the database                                                                     */
/******************************************************************************************************************************************/

function fnDisplayRadarList()
{
  global $module_name, $db, $prefix;
	$region = $_POST['region'];
	
  include( "header.php" );
  OpenTable();

  echo "<table width=\"100%\"><tr><td align=\"center\"><table><tr><th align=\"center\">"._WH_RADAR_STATION."</th></tr>"
      ."<tr><td align=\"center\">"._PLS_SEL_CITY."$region</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
	  ."<form method=\"post\" action=\"".getlink($module_name)."\">\n"
      ."<input type=\"hidden\" name=\"op\" value=\""._DIS_RADAR."\">\n"
	  ."<select name=\"id\" size=\"20\">\n";
	  
  $sql = "select id, repstation, primaryradar, secondaryradar, userradar from ".$prefix."_weatherstations where region='".$region."' order by repstation";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );
   			 
  foreach( $list as $row )
  {
    if ($row['primaryradar'] != "" || $row['secondaryradar'] != "" || $row['userradar'] != "" )
    {
      echo "<option value=\"".$row['id']."\">".ucwords( $row['repstation'])."</option>\n";
    }
  }
  
  echo "</select><br /><input type=\"submit\" value=\""._WSHOW_RADAR."\">\n";
  echo "</form></td></tr></table></td></tr></table>\n";  
  
  CloseTable();
}

$op = isset($_POST['op']) ? $_POST['op'] : (isset($_GET['op']) ? $_GET['op'] : '');
switch($op) {
  case _DIS_DIGITAL_CONUS:
//    if ( $_POST['id'] != "" && $_POST['which'] != "" )
//	{
//	  fnShowDigitalConus( $_POST['id'], $_POST['which'] );
	  fnShowDigitalConus();
//	}
    break;
	
  case _DIS_DIGITAL:
//    if ( $_GET['id'] != "" && $_GET['which'] != "" )
//	{
//	  fnShowDigital( $_GET['id'], $_GET['which'] );
	  fnShowDigital();
//	}
    break;
	
  case _DIS_WXMARINEZONE:
    fnDisWXMarineZone( $_POST['id'] );
    break;
	
  case _DIS_WX_MARINE:
    if ( $_POST['ocean'] != "" && $_POST['which'] == 1 )
      fnSelectWXMarine( $_POST['which'], $_POST['ocean'] );
	else
	  fnSelectWXMarine();  
    break;
	
  case _DIS_WX_NEW_CITY:
    if ( $_POST['country'] != "" && $_POST['which'] == 1)
	  fnSelectWXCity( $_POST['which'], $_POST['country'] );
	else if ( $_POST['region'] != "" && $_POST['which'] == 2)
	  fnSelectWXCity( $_POST['which'], "", $_POST['region'] );
	else
	  fnSelectWXCity();
	break;

  case _DIS_NOWWXZONE:
    fnDisplayNowWXZone( isset($_POST['id']) );
    break;
	
  case _DIS_WXZONE:
    fnDisplayWXZone( isset($_POST['id']) );
    break;

  case _UPD_CITY:
    if ( $_POST['code'] != "" )
	{
	  fnSaveDefaultCity( $_POST['code'] );
	}
    break;
	
  case _SEL_BUOY:
    fnSelectBuoy();
    break;
	
  case _UPD_BUOY:
    if ( $_POST['buoy'] != "" )
	{
	  fnSaveDefaultBuoy( $_POST['buoy'] );
	}
	break;	
	
  case _SEL_COUNTRY:
    fnSelectCountry();
	break;
		
  case _SEL_CITY:
    if ( $_POST['state'] != "" )
	{
      fnSelectCity( $_POST['state'] );
	}  
    break;

  case _SEL_REGION:
    if ( $_POST['country'] != "" )
	{
      fnSelectRegion( $_POST['country'] );
	}  
    break;
	
  case _DIS_RADAR_COUNTRY:
    fnDisplayRadarCountry();
    break;

  case _DIS_RADAR_REGION:
    if ($_POST['country'] != "") 
    {
      fnDisplayRadarRegion( $_POST['country'] );
    }
    break;

  case _DIS_RADAR_LIST:
    if ( $_POST['region'] != "")
    {
      fnDisplayRadarList( $_POST['region'] );
    }
    break;
		
  case _DIS_RADAR:
//  case _SHOW_RADAR:
      fnShowAllRadar();
    break;

  case _DIS_REQ_RADAR:
      fnShowAllRadar();
    break;

  case _DIS_REQ_RAD_LOOP:
    if ( $_GET['id'] != "" && $_GET['type'] != "")
	{
	  fnShowLoopRadar( $_GET['id'], $_GET['type'] );
	}
    break;
	
  case _DIS_BUOY_WEATHER:
    fnDisplayBuoyWorldMap();
    break;

  case _DIS_SELECTED_BUOY_REGION:
	  fnDisplayBuoyRegionMap();
    break;
	
  case _DIS_SELECTED_BUOY_DATA:
	  fnDisplayBuoyData();
    break;
	
  case _DIS_BUOY_FIVEDAY:
	  fnDisplayBuoyFiveDay();
    break;

  case _DIS_SUMMARY_REGION:
    if ( $_POST['id'] != "" )
	{
	  fnDisplaySummary( $_POST['id'] );
	}
    break;

  case _WEATHER_SUMMARIES:
    fnDisplaySummariesList();
    break;

  default:
    $wh = new whini();
    $fgotoptions = false;

    include( "header.php" );

	OpenTable();
    echo "<table width=\"100%\"><tr><th>"._WEATHER_HARVEST_MAIN_MENU."</th></tr>\n";
    echo "<tr><td>\n";
    echo "<ul>";

    echo "<li>"._GENERAL_WEATHER."<ul>\n";
    echo "<li><a href=\"".getlink($module_name."&amp;op="._WEATHER_SUMMARIES)."\">"._DISPLAY_WEATHER_SUMMARIES."</a></li>\n";
	echo "</ul></li>\n";

	echo "<li>"._LAND_WEATHER."<ul>\n";
	if ($wh->getuserdefcity() == true) {
      if (is_user()) {
        echo "<li><a href=\"".getlink($module_name."&amp;op="._SEL_COUNTRY)."\">"._SEL_REPORTING_STATION."</a></li>\n";
      }
    }

    if ( $wh->getextendforecast() == true ) {
      echo "<li><a href=\"".getlink($module_name."&amp;op="._DIS_WX_NEW_CITY)."\">"._WX_NEW_CITY."</a></li>\n";
    }
    echo "</ul></li>\n";

	echo "<li>"._BUOY_WEATHER."<ul>\n";
	if ($wh->getuserdefcity() == true) {
      if (is_user()) {
        echo "<li><a href=\"".getlink($module_name."&amp;op="._SEL_BUOY)."\">"._SEL_BUOY_STATION."</a></li>\n";
      }
    }

    if ($wh->getshowbuoy() == true ) {
	  echo "<li><a href=\"".getlink($module_name."&amp;op="._DIS_BUOY_WEATHER)."\">"._DISPLAY_BUOY_WEATHER."</a></li>\n";
	}

	if ( $wh->getmarineforecast() == true ) {
	  echo "<li><a href=\"".getlink($module_name."&amp;op="._DIS_WX_MARINE)."\">"._WX_MARINE."</a></li>\n";
	}
	echo "</ul></li>\n";

	echo "<li>"._SAT_WEATHER."<ul>\n";
    if ($wh->getshowradar() == true ) {
      echo "<li><a href=\"".getlink($module_name."&amp;op="._DIS_RADAR_COUNTRY)."\">"._DISPLAY_RADAR_IMAGE."</a></li>\n";
    }
    echo "</ul></li>\n";

    echo "</ul></td></tr>\n";
    echo "</table>\n";
    CloseTable();
	echo '<div align="right">';
	echo '<a href="javascript:void(0);" onclick=\'window.open("'.getlink($module_name.'&amp;file=copyright').'", "Copyright", "toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=300")\'>Weather Harvest</a>';
	echo ' &copy;</div>';
    break;
}
?>
