<?php
######################################################
# File to install Amazilla module
# This file is called automatically by Admin->Modules
######################################################
if (!defined('ADMIN_MOD_INSTALL')) { exit; }

class WeatherHarvest {
    var $radmin;
    var $version;
    var $modname;
    var $description;
    var $author;
    var $website;

    function WeatherHarvest() {
		$this->radmin = true;
		$this->version = '9.1.0';
        $this->modname = 'WeatherHarvest';
        $this->description = 'Your own Weather Station - original module from seventhseal, radar fix by layingback.';
        $this->author = 'Phoenix (port)';
        $this->website = 'nukebiz.com';
        $this->dbtables = array('weatherblock', 'weathercountries', 'weatherdefaults',
        'weatherini', 'weathermarine', 'weathersummaries', 'weatherstations', 'weatherzones');
    }

    function install() {
        global $installer;
		$installer->add_query('CREATE', 'weatherblock', "
  timedisplay enum('0','1') NOT NULL default '1',
  datedisplay enum('0','1','2') NOT NULL default '0',
  yeardisplay enum('0','1') NOT NULL default '0',
  timezone set('Y','N') NOT NULL default 'N',
  timepos set('T','B') NOT NULL default 'T',
  fontsize set('S','M','L') NOT NULL default 'M',
  showregion set('Y','N') NOT NULL default 'Y',
  showcountry set('Y','N') NOT NULL default 'Y',
  blockwidth enum('0','1') NOT NULL default '0',
  measuretype enum('0','1','2') NOT NULL default '0',
  dawntime smallint(6) NOT NULL default '600',
  dusktime smallint(6) NOT NULL default '1800',
  radarlink enum('Y','N') NOT NULL default 'Y',
  stationlink enum('Y','N') NOT NULL default 'Y',
  summarylink enum('Y','N') NOT NULL default 'Y',
  wxzonelink enum('Y','N') NOT NULL default 'Y',
  nowwxzonelink enum('Y','N') NOT NULL default 'Y',
  maxtemp enum('Y','N') NOT NULL default 'Y',
  mintemp enum('Y','N') NOT NULL default 'Y',
  pop enum('Y','N') NOT NULL default 'Y',
  twind enum('Y','N') NOT NULL default 'Y',
  tdew enum('Y','N') NOT NULL default 'Y',
  wx enum('Y','N') NOT NULL default 'Y',
  sky enum('Y','N') NOT NULL default 'Y',
  waveh enum('Y','N') NOT NULL default 'Y'
  ", 'weatherblock');

        $installer->add_query('INSERT', 'weatherblock', "'0', '1', '0', 'Y', 'B', 'M', 'N', 'Y', '1', '1', 700, 1900, 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'Y', 'Y', 'N'");

		$installer->add_query('CREATE', 'weathercountries', "
  abbrev char(2) NOT NULL default '',
  name varchar(255) NOT NULL default '',
  PRIMARY KEY  (abbrev)
  ", 'weathercountries');

        $installer->add_query('INSERT', 'weathercountries', "'af', 'afghanistan'");
        $installer->add_query('INSERT', 'weathercountries', "'al', 'albania'");
        $installer->add_query('INSERT', 'weathercountries', "'dz', 'algeria'");
        $installer->add_query('INSERT', 'weathercountries', "'ao', 'angola'");
        $installer->add_query('INSERT', 'weathercountries', "'aq', 'antarctica'");
        $installer->add_query('INSERT', 'weathercountries', "'ag', 'antigua and barbuda'");
        $installer->add_query('INSERT', 'weathercountries', "'ar', 'argentina'");
        $installer->add_query('INSERT', 'weathercountries', "'am', 'armenia'");
        $installer->add_query('INSERT', 'weathercountries', "'aw', 'aruba'");
        $installer->add_query('INSERT', 'weathercountries', "'au', 'australia'");
        $installer->add_query('INSERT', 'weathercountries', "'at', 'austria'");
        $installer->add_query('INSERT', 'weathercountries', "'az', 'azerbaijan'");
        $installer->add_query('INSERT', 'weathercountries', "'bs', 'bahamas'");
        $installer->add_query('INSERT', 'weathercountries', "'bh', 'bahrain'");
        $installer->add_query('INSERT', 'weathercountries', "'bd', 'bangladesh'");
        $installer->add_query('INSERT', 'weathercountries', "'bb', 'barbados'");
        $installer->add_query('INSERT', 'weathercountries', "'by', 'belarus'");
        $installer->add_query('INSERT', 'weathercountries', "'be', 'belgium'");
        $installer->add_query('INSERT', 'weathercountries', "'bz', 'belize'");
        $installer->add_query('INSERT', 'weathercountries', "'bj', 'benin'");
        $installer->add_query('INSERT', 'weathercountries', "'bm', 'bermuda'");
        $installer->add_query('INSERT', 'weathercountries', "'bo', 'bolivia'");
        $installer->add_query('INSERT', 'weathercountries', "'ba', 'bosnia and herzegovina'");
        $installer->add_query('INSERT', 'weathercountries', "'bw', 'botswana'");
        $installer->add_query('INSERT', 'weathercountries', "'br', 'brazil'");
        $installer->add_query('INSERT', 'weathercountries', "'io', 'british indian ocean territory'");
        $installer->add_query('INSERT', 'weathercountries', "'bn', 'brunei darussalam'");
        $installer->add_query('INSERT', 'weathercountries', "'bg', 'bulgaria'");
        $installer->add_query('INSERT', 'weathercountries', "'bf', 'burkina faso'");
        $installer->add_query('INSERT', 'weathercountries', "'bi', 'burundi'");
        $installer->add_query('INSERT', 'weathercountries', "'kh', 'cambodia'");
        $installer->add_query('INSERT', 'weathercountries', "'cm', 'cameroon'");
        $installer->add_query('INSERT', 'weathercountries', "'ca', 'canada'");
        $installer->add_query('INSERT', 'weathercountries', "'cv', 'cape verde'");
        $installer->add_query('INSERT', 'weathercountries', "'ky', 'cayman islands'");
        $installer->add_query('INSERT', 'weathercountries', "'cf', 'central african republic'");
        $installer->add_query('INSERT', 'weathercountries', "'td', 'chad'");
        $installer->add_query('INSERT', 'weathercountries', "'cl', 'chile'");
        $installer->add_query('INSERT', 'weathercountries', "'cn', 'china'");
        $installer->add_query('INSERT', 'weathercountries', "'cx', 'christmas island'");
        $installer->add_query('INSERT', 'weathercountries', "'co', 'colombia'");
        $installer->add_query('INSERT', 'weathercountries', "'km', 'comoros'");
        $installer->add_query('INSERT', 'weathercountries', "'cg', 'congo'");
        $installer->add_query('INSERT', 'weathercountries', "'ck', 'cook islands'");
        $installer->add_query('INSERT', 'weathercountries', "'cr', 'costa rica'");
        $installer->add_query('INSERT', 'weathercountries', "'ci', 'cote divoire'");
        $installer->add_query('INSERT', 'weathercountries', "'hr', 'croatia'");
        $installer->add_query('INSERT', 'weathercountries', "'cu', 'cuba'");
        $installer->add_query('INSERT', 'weathercountries', "'cy', 'cyprus'");
        $installer->add_query('INSERT', 'weathercountries', "'cz', 'czech republic'");
        $installer->add_query('INSERT', 'weathercountries', "'dk', 'denmark'");
        $installer->add_query('INSERT', 'weathercountries', "'dj', 'djibouti'");
        $installer->add_query('INSERT', 'weathercountries', "'do', 'dominican republic'");
        $installer->add_query('INSERT', 'weathercountries', "'dm', 'dominica'");
        $installer->add_query('INSERT', 'weathercountries', "'tp', 'east timor'");
        $installer->add_query('INSERT', 'weathercountries', "'ec', 'ecuador'");
        $installer->add_query('INSERT', 'weathercountries', "'eg', 'egypt'");
        $installer->add_query('INSERT', 'weathercountries', "'sv', 'el salvador'");
        $installer->add_query('INSERT', 'weathercountries', "'gq', 'equatorial guinea'");
        $installer->add_query('INSERT', 'weathercountries', "'ee', 'estonia'");
        $installer->add_query('INSERT', 'weathercountries', "'et', 'ethiopia'");
        $installer->add_query('INSERT', 'weathercountries', "'fk', 'falkland islands (malvinas)'");
        $installer->add_query('INSERT', 'weathercountries', "'fj', 'fiji'");
        $installer->add_query('INSERT', 'weathercountries', "'fi', 'finland'");
        $installer->add_query('INSERT', 'weathercountries', "'fr', 'france'");
        $installer->add_query('INSERT', 'weathercountries', "'gf', 'french guiana'");
        $installer->add_query('INSERT', 'weathercountries', "'pf', 'french polynesia'");
        $installer->add_query('INSERT', 'weathercountries', "'ga', 'gabon'");
        $installer->add_query('INSERT', 'weathercountries', "'gm', 'gambia'");
        $installer->add_query('INSERT', 'weathercountries', "'ge', 'georgia'");
        $installer->add_query('INSERT', 'weathercountries', "'de', 'germany'");
        $installer->add_query('INSERT', 'weathercountries', "'gh', 'ghana'");
        $installer->add_query('INSERT', 'weathercountries', "'gi', 'gibraltar'");
        $installer->add_query('INSERT', 'weathercountries', "'gr', 'greece'");
        $installer->add_query('INSERT', 'weathercountries', "'gl', 'greenland'");
        $installer->add_query('INSERT', 'weathercountries', "'gd', 'grenada'");
        $installer->add_query('INSERT', 'weathercountries', "'gp', 'guadeloupe'");
        $installer->add_query('INSERT', 'weathercountries', "'gt', 'guatemala'");
        $installer->add_query('INSERT', 'weathercountries', "'gw', 'guinea-bissau'");
        $installer->add_query('INSERT', 'weathercountries', "'gn', 'guinea'");
        $installer->add_query('INSERT', 'weathercountries', "'gy', 'guyana'");
        $installer->add_query('INSERT', 'weathercountries', "'ht', 'haiti'");
        $installer->add_query('INSERT', 'weathercountries', "'hn', 'honduras'");
        $installer->add_query('INSERT', 'weathercountries', "'hk', 'hong kong'");
        $installer->add_query('INSERT', 'weathercountries', "'hu', 'hungary'");
        $installer->add_query('INSERT', 'weathercountries', "'is', 'iceland'");
        $installer->add_query('INSERT', 'weathercountries', "'in', 'india'");
        $installer->add_query('INSERT', 'weathercountries', "'id', 'indonesia'");
        $installer->add_query('INSERT', 'weathercountries', "'ir', 'iran, islamic republic of'");
        $installer->add_query('INSERT', 'weathercountries', "'iq', 'iraq'");
        $installer->add_query('INSERT', 'weathercountries', "'ie', 'ireland'");
        $installer->add_query('INSERT', 'weathercountries', "'il', 'israel'");
        $installer->add_query('INSERT', 'weathercountries', "'it', 'italy'");
        $installer->add_query('INSERT', 'weathercountries', "'jm', 'jamaica'");
        $installer->add_query('INSERT', 'weathercountries', "'jp', 'japan'");
        $installer->add_query('INSERT', 'weathercountries', "'jo', 'jordan'");
        $installer->add_query('INSERT', 'weathercountries', "'kz', 'kazakhstan'");
        $installer->add_query('INSERT', 'weathercountries', "'ke', 'kenya'");
        $installer->add_query('INSERT', 'weathercountries', "'ki', 'kiribati'");
        $installer->add_query('INSERT', 'weathercountries', "'kp', 'korea, democratic peoples republic of'");
        $installer->add_query('INSERT', 'weathercountries', "'kr', 'korea, republic of'");
        $installer->add_query('INSERT', 'weathercountries', "'kw', 'kuwait'");
        $installer->add_query('INSERT', 'weathercountries', "'kg', 'kyrgyzstan'");
        $installer->add_query('INSERT', 'weathercountries', "'la', 'lao peoples democratic republic'");
        $installer->add_query('INSERT', 'weathercountries', "'lv', 'latvia'");
        $installer->add_query('INSERT', 'weathercountries', "'lb', 'lebanon'");
        $installer->add_query('INSERT', 'weathercountries', "'ls', 'lesotho'");
        $installer->add_query('INSERT', 'weathercountries', "'lr', 'liberia'");
        $installer->add_query('INSERT', 'weathercountries', "'ly', 'libyan arab jamahiriya'");
        $installer->add_query('INSERT', 'weathercountries', "'lt', 'lithuania'");
        $installer->add_query('INSERT', 'weathercountries', "'lu', 'luxembourg'");
        $installer->add_query('INSERT', 'weathercountries', "'mo', 'macau'");
        $installer->add_query('INSERT', 'weathercountries', "'mk', 'macedonia, the former yugoslav republic of'");
        $installer->add_query('INSERT', 'weathercountries', "'mg', 'madagascar'");
        $installer->add_query('INSERT', 'weathercountries', "'mw', 'malawi'");
        $installer->add_query('INSERT', 'weathercountries', "'my', 'malaysia'");
        $installer->add_query('INSERT', 'weathercountries', "'mv', 'maldives'");
        $installer->add_query('INSERT', 'weathercountries', "'ml', 'mali'");
        $installer->add_query('INSERT', 'weathercountries', "'mt', 'malta'");
        $installer->add_query('INSERT', 'weathercountries', "'mh', 'marshall islands'");
        $installer->add_query('INSERT', 'weathercountries', "'mq', 'martinique'");
        $installer->add_query('INSERT', 'weathercountries', "'mr', 'mauritania'");
        $installer->add_query('INSERT', 'weathercountries', "'mu', 'mauritius'");
        $installer->add_query('INSERT', 'weathercountries', "'mx', 'mexico'");
        $installer->add_query('INSERT', 'weathercountries', "'fm', 'micronesia, federated states of'");
        $installer->add_query('INSERT', 'weathercountries', "'md', 'moldova, republic of'");
        $installer->add_query('INSERT', 'weathercountries', "'mn', 'mongolia'");
        $installer->add_query('INSERT', 'weathercountries', "'ma', 'morocco'");
        $installer->add_query('INSERT', 'weathercountries', "'mz', 'mozambique'");
        $installer->add_query('INSERT', 'weathercountries', "'mm', 'myanmar'");
        $installer->add_query('INSERT', 'weathercountries', "'na', 'namibia'");
        $installer->add_query('INSERT', 'weathercountries', "'nr', 'nauru'");
        $installer->add_query('INSERT', 'weathercountries', "'np', 'nepal'");
        $installer->add_query('INSERT', 'weathercountries', "'an', 'netherlands antilles'");
        $installer->add_query('INSERT', 'weathercountries', "'nl', 'netherlands'");
        $installer->add_query('INSERT', 'weathercountries', "'nc', 'new caledonia'");
        $installer->add_query('INSERT', 'weathercountries', "'nz', 'new zealand'");
        $installer->add_query('INSERT', 'weathercountries', "'ni', 'nicaragua'");
        $installer->add_query('INSERT', 'weathercountries', "'ng', 'nigeria'");
        $installer->add_query('INSERT', 'weathercountries', "'ne', 'niger'");
        $installer->add_query('INSERT', 'weathercountries', "'no', 'norway'");
        $installer->add_query('INSERT', 'weathercountries', "'om', 'oman'");
        $installer->add_query('INSERT', 'weathercountries', "'pk', 'pakistan'");
        $installer->add_query('INSERT', 'weathercountries', "'pw', 'palau'");
        $installer->add_query('INSERT', 'weathercountries', "'pa', 'panama'");
        $installer->add_query('INSERT', 'weathercountries', "'pg', 'papua new guinea'");
        $installer->add_query('INSERT', 'weathercountries', "'py', 'paraguay'");
        $installer->add_query('INSERT', 'weathercountries', "'pe', 'peru'");
        $installer->add_query('INSERT', 'weathercountries', "'ph', 'philippines'");
        $installer->add_query('INSERT', 'weathercountries', "'pl', 'poland'");
        $installer->add_query('INSERT', 'weathercountries', "'pt', 'portugal'");
        $installer->add_query('INSERT', 'weathercountries', "'pr', 'puerto rico'");
        $installer->add_query('INSERT', 'weathercountries', "'qa', 'qatar'");
        $installer->add_query('INSERT', 'weathercountries', "'re', 'reunion'");
        $installer->add_query('INSERT', 'weathercountries', "'ro', 'romania'");
        $installer->add_query('INSERT', 'weathercountries', "'ru', 'russian federation'");
        $installer->add_query('INSERT', 'weathercountries', "'rw', 'rwanda'");
        $installer->add_query('INSERT', 'weathercountries', "'sh', 'saint helena'");
        $installer->add_query('INSERT', 'weathercountries', "'kn', 'saint kitts and nevis'");
        $installer->add_query('INSERT', 'weathercountries', "'lc', 'saint lucia'");
        $installer->add_query('INSERT', 'weathercountries', "'pm', 'saint pierre and miquelon'");
        $installer->add_query('INSERT', 'weathercountries', "'vc', 'saint vincent and the grenadines'");
        $installer->add_query('INSERT', 'weathercountries', "'ws', 'samoa'");
        $installer->add_query('INSERT', 'weathercountries', "'st', 'sao tome and principe'");
        $installer->add_query('INSERT', 'weathercountries', "'sa', 'saudi arabia'");
        $installer->add_query('INSERT', 'weathercountries', "'sn', 'senegal'");
        $installer->add_query('INSERT', 'weathercountries', "'sc', 'seychelles'");
        $installer->add_query('INSERT', 'weathercountries', "'sl', 'sierra leone'");
        $installer->add_query('INSERT', 'weathercountries', "'sg', 'singapore'");
        $installer->add_query('INSERT', 'weathercountries', "'sk', 'slovakia'");
        $installer->add_query('INSERT', 'weathercountries', "'si', 'slovenia'");
        $installer->add_query('INSERT', 'weathercountries', "'sb', 'solomon islands'");
        $installer->add_query('INSERT', 'weathercountries', "'so', 'somalia'");
        $installer->add_query('INSERT', 'weathercountries', "'za', 'south africa'");
        $installer->add_query('INSERT', 'weathercountries', "'gs', 'south georgia and the south sandwich islands'");
        $installer->add_query('INSERT', 'weathercountries', "'es', 'spain'");
        $installer->add_query('INSERT', 'weathercountries', "'lk', 'sri lanka'");
        $installer->add_query('INSERT', 'weathercountries', "'sd', 'sudan'");
        $installer->add_query('INSERT', 'weathercountries', "'sr', 'suriname'");
        $installer->add_query('INSERT', 'weathercountries', "'sz', 'swaziland'");
        $installer->add_query('INSERT', 'weathercountries', "'se', 'sweden'");
        $installer->add_query('INSERT', 'weathercountries', "'ch', 'switzerland'");
        $installer->add_query('INSERT', 'weathercountries', "'sy', 'syrian arab republic'");
        $installer->add_query('INSERT', 'weathercountries', "'tw', 'taiwan'");
        $installer->add_query('INSERT', 'weathercountries', "'tj', 'tajikistan'");
        $installer->add_query('INSERT', 'weathercountries', "'tz', 'tanzania, united republic of'");
        $installer->add_query('INSERT', 'weathercountries', "'th', 'thailand'");
        $installer->add_query('INSERT', 'weathercountries', "'tg', 'togo'");
        $installer->add_query('INSERT', 'weathercountries', "'to', 'tonga'");
        $installer->add_query('INSERT', 'weathercountries', "'tt', 'trinidad and tobago'");
        $installer->add_query('INSERT', 'weathercountries', "'tn', 'tunisia'");
        $installer->add_query('INSERT', 'weathercountries', "'tr', 'turkey'");
        $installer->add_query('INSERT', 'weathercountries', "'tm', 'turkmenistan'");
        $installer->add_query('INSERT', 'weathercountries', "'tv', 'tuvalu'");
        $installer->add_query('INSERT', 'weathercountries', "'ug', 'uganda'");
        $installer->add_query('INSERT', 'weathercountries', "'ua', 'ukraine'");
        $installer->add_query('INSERT', 'weathercountries', "'ae', 'united arab emirates'");
        $installer->add_query('INSERT', 'weathercountries', "'gb', 'united kingdom'");
        $installer->add_query('INSERT', 'weathercountries', "'um', 'united states minor outlying islands'");
        $installer->add_query('INSERT', 'weathercountries', "'us', 'united states'");
        $installer->add_query('INSERT', 'weathercountries', "'uy', 'uruguay'");
        $installer->add_query('INSERT', 'weathercountries', "'uz', 'uzbekistan'");
        $installer->add_query('INSERT', 'weathercountries', "'vu', 'vanuatu'");
        $installer->add_query('INSERT', 'weathercountries', "'ve', 'venezuela'");
        $installer->add_query('INSERT', 'weathercountries', "'vn', 'Vietnam'");
        $installer->add_query('INSERT', 'weathercountries', "'vg', 'virgin islands, british'");
        $installer->add_query('INSERT', 'weathercountries', "'vi', 'virgin islands, united states'");
        $installer->add_query('INSERT', 'weathercountries', "'wi', 'western sahara'");
        $installer->add_query('INSERT', 'weathercountries', "'ye', 'yemen'");
        $installer->add_query('INSERT', 'weathercountries', "'yu', 'yugoslavia'");
        $installer->add_query('INSERT', 'weathercountries', "'cd', 'zaire'");
        $installer->add_query('INSERT', 'weathercountries', "'zm', 'zambia'");
        $installer->add_query('INSERT', 'weathercountries', "'zw', 'zimbabwe'");

		$installer->add_query('CREATE', 'weatherdefaults', "
  uid int(11) NOT NULL default '0',
  code char(4) NOT NULL default '',
  buoy char(5) NOT NULL default '',
  PRIMARY KEY (uid)
  ", 'weatherdefaults');

        $installer->add_query('INSERT', 'weatherdefaults', "0, 'KLXT', '41012'");
        $installer->add_query('INSERT', 'weatherdefaults', "2, 'KDVT', ''");


		$installer->add_query('CREATE', 'weatherini', "
  nukecachepath varchar(255) NOT NULL default '',
  nukeradarpath varchar(255) NOT NULL default '',
  userdefcity set('Y','N') NOT NULL default 'Y',
  showradar set('Y','N') NOT NULL default 'Y',
  radarloops set('Y','N') NOT NULL default 'N',
  cachetimeout set('0','1','2','3','4') NOT NULL default '1',
  imageset set('1','2','3') NOT NULL default '1',
  zippick set('Y','N') NOT NULL default 'N',
  miniblock set('Y','N') NOT NULL default 'Y',
  showbuoy set('Y','N') NOT NULL default 'Y',
  extendforecast set('Y','N') NOT NULL default 'Y',
  efdaysdisplay set('1','2','3','4','5') NOT NULL default '5',
  marineforecast set('Y','N') NOT NULL default 'N',
  radarscale int(3) NOT NULL default '100',
  FULLTEXT KEY rootcachepath (nukecachepath,nukeradarpath)
  ", 'weatherini');

        $installer->add_query('INSERT', 'weatherini', "'modules/WeatherHarvest/cache/', 'modules/WeatherHarvest/cache/', 'Y', 'Y', 'Y', '1', '1', 'N', 'N', 'Y', 'Y', '3', 'Y', 75");

		$installer->add_query('CREATE', 'weathermarine', "
  id int(11) NOT NULL auto_increment,
  type set('C','O','H') NOT NULL default 'C',
  ocean varchar(25) NOT NULL default '',
  region varchar(100) NOT NULL default '',
  wxzone varchar(6) NOT NULL default '',
  synopsis varchar(6) NOT NULL default '',
  code varchar(4) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY ocean (ocean)
  ", 'weathermarine');

		$installer->add_query('CREATE', 'weathersummaries', "
  id tinyint(4) NOT NULL auto_increment,
  descrip varchar(100) NOT NULL default '',
  path varchar(255) NOT NULL default '',
  filename varchar(50) NOT NULL default '',
  PRIMARY KEY  (id),
  FULLTEXT KEY descrip (descrip)
  ", 'weathersummaries');

        $installer->add_query('INSERT', 'weathersummaries', "1, 'Central United States', 'http://weather.noaa.gov/pub/data/summaries/selected_cities/current/', 'central_us.txt'");
        $installer->add_query('INSERT', 'weathersummaries', "2, 'Eastern United States', 'http://weather.noaa.gov/pub/data/summaries/selected_cities/current/', 'eastern_us.txt'");
        $installer->add_query('INSERT', 'weathersummaries', "3, 'International Cities', 'http://weather.noaa.gov/pub/data/summaries/selected_cities/current/', 'international.txt'");
        $installer->add_query('INSERT', 'weathersummaries', "4, 'Latin America', 'http://weather.noaa.gov/pub/data/summaries/selected_cities/current/', 'latin_america.txt'");
        $installer->add_query('INSERT', 'weathersummaries', "5, 'North America (Canada and Carribean)', 'http://weather.noaa.gov/pub/data/summaries/selected_cities/current/', 'north_america.txt'");
        $installer->add_query('INSERT', 'weathersummaries', "6, 'Western United States', 'http://weather.noaa.gov/pub/data/summaries/selected_cities/current/', 'western_us.txt'");

		$installer->add_query('CREATE', 'weatherstations', "
  id int(11) NOT NULL auto_increment,
  country char(2) NOT NULL default '',
  region char(50) NOT NULL default '',
  repstation char(100) NOT NULL default '',
  code char(4) NOT NULL default '',
  fips char(5) NOT NULL default '',
  primaryradar char(4) NOT NULL default '',
  secondaryradar char(4) NOT NULL default '',
  userradar char(255) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY code (code),
  FULLTEXT KEY region (region,repstation),
  FULLTEXT KEY country (country),
  FULLTEXT KEY primaryradar (primaryradar),
  FULLTEXT KEY secondaryradar (secondaryradar),
  FULLTEXT KEY userradar (userradar)
  ", 'weatherstations');

		$installer->add_query('CREATE', 'weatherzones', "
  weatherzones int(11) NOT NULL auto_increment,
  fips varchar(5) NOT NULL default '',
  wxzone varchar(6) NOT NULL default '',
  PRIMARY KEY  (weatherzones),
  KEY fips (fips),
  KEY wxzone (wxzone)
  ", 'weatherzones');

        return true;
    }

    function uninstall() {
        global $installer;
		$installer->add_query('DROP', 'weatherblock');
		$installer->add_query('DROP', 'weathercountries');
		$installer->add_query('DROP', 'weatherdefaults');
		$installer->add_query('DROP', 'weatherini');
		$installer->add_query('DROP', 'weathermarine');
		$installer->add_query('DROP', 'weathersummaries');
		$installer->add_query('DROP', 'weatherstations');
		$installer->add_query('DROP', 'weatherzones');

		return true;
    }

	function upgrade($prev_version) {
		global $installer;

		return true;
	}
}
?>