<?php
######################################################################
# Weather Magnet
# ============================================
#
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
#
#
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################

if (!defined('CPG_NUKE')) { exit; }
require_once("includes/cmsinit.inc");

$module_name = basename(dirname(__FILE__));
get_lang($module_name);

require_once( "modules/$module_name/wh_ini.php" );
require_once( "modules/$module_name/wh_utils.php" );
require_once( "modules/$module_name/buoy_utils.php" );

global $db, $prefix;

$BUOY_SITE = "http://www.ndbc.noaa.gov/data/latest_obs/";
$BUOY_FORECAST = "http://www.ndbc.noaa.gov/data/DAB_Forecasts/";
$BUOY_FIVEDAY = "http://www.ndbc.noaa.gov/data/5day/";

function fnDisplayBuoyWorldMap() {
  global $module_name;
  
  include("header.php");
  OpenTable();
  echo "<table align=\"center\"><tr><th>"._DISPLAY_BUOY_WEATHER."</th></tr><tr><td>\n";
  
  echo "<img src=\"modules/$module_name/images/world.jpg\" width=\"535\" height=\"340\" border=\"0\" alt=\"Recent Marine Data\" usemap=\"#WorldMap1\" />\n"
      ."<map name=\"WorldMap1\">\n"
	  ."<area shape=\"rect\" alt=\""._B_FRANCE."\" coords=\"428,159,494,185\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_FRANCE."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_WESTERN_GL."\" coords=\"233,151,253,187\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_WGL."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_EASTERN_GL."\" coords=\"256,152,281,188\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_EGL."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_SOUTHWEST."\" coords=\"14,191,182,222\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_SWUS."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_NORTHWEST."\" coords=\"15,128,161,188\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_NWUS."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_ALASKA."\" coords=\"14,52,162,127\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_ALASKA."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_HAWAII."\" coords=\"46,225,86,309\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_HAWAII."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_CARIBBEAN."\" coords=\"283,242,331,270\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_CARIB."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_WESTERN_GOM."\" coords=\"216,212,246,244\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_WGOM."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_EASTERN_GOM_FLORIDA."\" coords=\"248,212,276,244\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_EGOM."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_SOUTHEAST."\" coords=\"261,189,297,211\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_SEUS."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_NORTHEAST."\" coords=\"283,165,309,187\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_NEUS."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_NOVASCOTIA."\" coords=\"285,139,344,163\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_NOVA."\">\n"
	  ."<area shape=\"rect\" alt=\""._B_UNITED_KINGDOM."\" coords=\"426,105,490,157\" href=\"index.php?name=$module_name&amp;op="._DIS_SELECTED_BUOY_REGION."&amp;item="._ITEM_UK."\">\n"
	  ."</map>\n";
	
  echo "</td></tr><tr><td>"._WORLD_BUOY_DIRECTIONS."</td></tr></table>\n";
  	  
  CloseTable();
  include("footer.php");
}

################################################################################
# function fnDisplayBuoyRegionMap( $item )
# function to display the graphical map of Buoy regions
################################################################################

function fnDisplayBuoyRegionMap( $item ) {
$item = isset($_POST['item'])?$_POST['item']:(isset($_GET['item'])?$_GET['item']:'');
  global $module_name;
  
  include("header.php");
  OpenTable();
  
  fnEchoBuoyRegionMap( $item );
  
  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnDisplayBuoyData( $buoy )                                        */
/* Function will display the associated Buoy information from                 */
/* http://www.ndbc.noaa.gov/data.  It relies on the buoy identifier passed in.*/
/******************************************************************************/

function fnDisplayBuoyData() {
  global $module_name, $BUOY_FORECAST, $BUOY_SITE, $prefix, $db;
  $item = $_GET['item'];
  $buoy = $_GET ['buoy'];
  
  include( "header.php" );
  OpenTable();
  
  fnEchoBuoyMenu( $buoy, $item );
  
  fnEchoBuoyRegionMap( $item );  // draw the map that they picked a particular buoy from
  
  $buoy = strtolower( $buoy );  // must be lower case
  
  $wh = new whini();
  $radar_cache = $wh->getrootcachepath();
    
  $return = "<table align=\"center\"><tr><th width=\"33%\">"._LATEST_OBSERVATIONS."</th><th>"._LATEST_FORECAST."</th></tr><tr><td width=\"33%\">";
  
  $latest_obs = $BUOY_SITE.$buoy.".txt";  // build the string
  $target_file = $radar_cache.$buoy.".txt";  // build the file that goes to cache
  
  $return .= fnGetLatestBuoyObs( $latest_obs, $target_file );
    
  $latest_forecast = $BUOY_FORECAST.$buoy."fc.html";
  $target_forecast = $radar_cache.$buoy."fc.html";
  
  $target_forecast = fnLatestObstoCache( $latest_forecast, $target_forecast );
  
  $return .= "</td><td>";

    // open the file and dump it to the screen
  if ( $target_forecast != "" )
  {
    $temp_return = fnReadFile( $target_forecast );
	if ( $temp_return == "" )
	{
	  $temp_return = _NO_DATA_AVAILABLE."<br />";
	}
	
	// need to get rid of <HEAD>, <BODY>, <TITLE>, <HTML>, <A> tags
	$temp_return = strip_tags($temp_return, "<a><html><title><body><head>");
	$return .= $temp_return;
  }
  else
  {
    $return .= _NO_DATA_AVAILABLE."<br />";
  }
  
  $return .= "</td></tr></table>";
  
  echo $return;
  	
  CloseTable();
  include("footer.php");
}


function fnDisplayBuoyFiveDay() {
  global $module_name, $BUOY_FIVEDAY, $prefix, $db;
  $item = $_GET['item'];
  $buoy = $_GET ['buoy'];
  
  include( "header.php" );
  OpenTable();
  
  fnEchoBuoyMenu( $buoy, $item );
  
  fnEchoBuoyRegionMap( $item );  // draw the map that they picked a particular buoy from
  
  $buoy = strtolower( $buoy );  // must be lower case
  
  $wh = new whini( $db, $prefix );
  $radar_cache = $wh->getrootcachepath();
    
  $latest_obs = $BUOY_FIVEDAY.$buoy."_5day.txt";  // build the string
  $target_file = $radar_cache.$buoy."_5day.txt";  // build the file that goes to cache
  
  // get the file to cache
  $target_file = fnLatestObstoCache( $latest_obs, $target_file );
  
  $return = "";
  
  // open the file and dump it to the screen
  if ( $target_file != "" )
  {
    $file = fopen($target_file, "rb");
    if ( $file )
    {
	  $return = "<table align=\"center\"><tr><th colspan=\"18\">"._FIVEDAY_BUOY."</th></tr>";
	  
      while( !feof( $file ) )
      {
	    $return .= "<tr>";
        // get a single line
		$line = fgets($file, 1024);
		
		// strip any HTML out
		$line = strip_tags( $line );
		
		// now split the string into words
		$split_line = preg_split( "/[\s,]+/", $line);
		$cnt=0;
		while( $cnt < 18 )
		{
		  $return .= "<td>".$split_line[$cnt]."</td>";
		  $cnt++;
		}
		
	    $return .= "</tr>";
      }  
	 
      fclose($file);
      $return .= "</table>";
    }
    else
    {
      $return .= _NO_DATA_AVAILABLE."<br />";
    }
  }
  else
  {
    $return .= _NO_DATA_AVAILABLE."<br />";
  }  
  
  echo $return;
  	
  CloseTable();
  include("footer.php");
}
?>