<?php
/*************************************************************************
* File to add WeatherHarvest Records for Stations, Zones and Marine
* This file is called automatically by Admin->Modules
*************************************************************************/
if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin('weatherharvest')) { exit; }

global $db, $prefix, $op;
require_once("modules/$op/admin/wh_functions.inc" );

	include_once('header.php');
	OpenTable();
	echo adminWHMenu().'<br />
	<span class="genmed"><strong>Insert Records</strong></span><br />
	Processing additional WeatherHarvest records:<br />';

	$queries[] = "TRUNCATE ".$prefix."_weathermarine";
	$queries[] = "TRUNCATE ".$prefix."_weatherstations";
	$queries[] = "TRUNCATE ".$prefix."_weatherzones";

	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (1, 'C', 'North Atlantic', 'Eastport ME to Stonington ME', 'anz050', 'anz005', 'KCAR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (2, 'C', 'North Atlantic', 'Stonington ME to Merrimack River MA', 'anz150', 'anz100', 'K2B8')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (3, 'C', 'North Atlantic', 'Merrimack River MA to Plymouth MA', 'anz250', 'anz200', 'KTAN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (4, 'C', 'North Atlantic', 'Boston Harbor', 'anz230', 'anz200', 'KBOS')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (5, 'C', 'North Atlantic', 'Cape Cod Bay', 'anz231', 'anz200', 'KTAN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (6, 'C', 'North Atlantic', 'Provincetown MA to Chatham MA to Nantucket MA', 'anz254', 'anz200', 'KCHH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (7, 'C', 'North Atlantic', 'Nantucket Sound', 'anz232', 'anz200', 'KACK')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (8, 'C', 'North Atlantic', 'Vineyard Sound', 'anz233', 'anz200', 'KMVY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (9, 'C', 'North Atlantic', 'Buzzards Bay', 'anz234', 'anz200', 'KMVY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (10, 'C', 'North Atlantic', 'Narragansett Bay', 'anz236', 'anz200', 'KTAN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (11, 'C', 'North Atlantic', 'Rhode Island Sound', 'anz235', 'anz200', 'KTAN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (12, 'C', 'North Atlantic', 'Block Island Sound', 'anz237', 'anz200', 'KTAN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (13, 'C', 'North Atlantic', 'Nantucket MA to Marthas Vineyard MA to Block Island RI to Montauk NY', 'anz255', 'anz200', 'KTAN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (14, 'C', 'North Atlantic', 'Long Island Sound West of New Haven CT', 'anz335', 'anz300', 'KHVN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (15, 'C', 'North Atlantic', 'Long Island Sound East of New Haven CT', 'anz330', 'anz300', 'KN11')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (16, 'C', 'North Atlantic', 'Moriches Inlet NY to Montauk Point NY', 'anz350', 'anz300', 'KMTP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (17, 'C', 'North Atlantic', 'Fire Island Inlet NY to Moriches Inlet NY', 'anz353', 'anz300', 'KJFK')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (18, 'C', 'North Atlantic', 'Sandy Hook NJ to Fire Island Inlet NY', 'anz355', 'anz300', 'K56N')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (19, 'C', 'North Atlantic', 'New York Harbor', 'anz338', 'anz300', 'KJFK')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (20, 'C', 'North Atlantic', 'Sandy Hook NJ to Manasquan Inlet NJ', 'anz450', 'anz400', 'KVAY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (21, 'C', 'North Atlantic', 'Manasquan Inlet NJ to Little Egg Inlet NJ', 'anz451', 'anz400', 'KVAY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (22, 'C', 'North Atlantic', 'Little Egg Inlet NJ to Great Egg Inlet NJ', 'anz452', 'anz400', 'KVAY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (23, 'C', 'North Atlantic', 'Great Egg Inlet NJ to Cape May NJ', 'anz453', 'anz400', 'KVAY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (24, 'C', 'North Atlantic', 'Cape May NJ to Cape Henlopen DE', 'anz454', 'anz400', 'KVAY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (25, 'C', 'North Atlantic', 'Cape Henlopen DE to Fenwick Island DE', 'anz455', 'anz400', 'KILG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (26, 'C', 'North Atlantic', 'Delaware Bay South of East Point NJ to Slaughter Beach DE', 'anz431', 'anz400', 'KILG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (27, 'C', 'North Atlantic', 'Delaware Bay North of East Point NJ to Slaughter Beach DE', 'anz430', 'anz400', 'KPHL')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (28, 'C', 'North Atlantic', 'Chesapeake Bay North of Pooles Island MD', 'anz530', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (29, 'C', 'North Atlantic', 'Chesapeake Bay from Pooles Island to Sandy Point MD', 'anz531', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (30, 'C', 'North Atlantic', 'Chesapeake Bay from Sandy Point to North Beach MD', 'anz532', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (31, 'C', 'North Atlantic', 'Chesapeake Bay from North Beach to Drum Point MD', 'anz533', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (32, 'C', 'North Atlantic', 'Chesapeake Bay from Drum Point MD to Smith Point VA', 'anz534', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (33, 'C', 'North Atlantic', 'Tidal Patomac from Key Bridge to Indian Head MD', 'anz535', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (34, 'C', 'North Atlantic', 'Tidal Patomac from Indian Head to Cobb Island MD', 'anz536', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (35, 'C', 'North Atlantic', 'Tidal Patomac from Cobb Island MD to Smith Point VA', 'anz537', 'anz500', 'KBWI')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (36, 'C', 'North Atlantic', 'Chesapeake Bay from Smith Point to Windmill Point VA', 'anz630', 'anz600', 'KAKQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (37, 'C', 'North Atlantic', 'Chesapeake Bay from Windmill Point to New Point Comfort VA', 'anz631', 'anz600', 'KAKQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (38, 'C', 'North Atlantic', 'Chesapeake Bay from New Point Comfort to Cape Henry VA', 'anz632', 'anz600', 'KAKQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (39, 'C', 'North Atlantic', 'Fenwick Island DE to Chincoteague VA', 'anz650', 'anz600', 'KAKQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (40, 'C', 'North Atlantic', 'Chincoteague to Parramore Island VA', 'anz652', 'anz600', 'KAKQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (41, 'C', 'North Atlantic', 'Parramore Island to Cape Charles Light VA', 'anz654', 'anz600', 'KW51')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (42, 'C', 'North Atlantic', 'Cape Charles Light VA to NC/VA Border', 'anz656', 'anz600', 'KW51')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (43, 'C', 'North Atlantic', 'NC/VA Border to Currituck Beach Light NC', 'anz658', 'anz600', 'K77W')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (44, 'C', 'North Atlantic', 'Currituck Sound NC', 'anz633', 'anz600', 'K77W')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (45, 'C', 'Mid Atlantic', 'Albemarle Sound NC', 'amz130', 'amz100', 'KMHZ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (46, 'C', 'Mid Atlantic', 'Currituck Beach Light to Oregon Inlet NC', 'amz150', 'amz100', 'KMHX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (47, 'C', 'Mid Atlantic', 'Oregon Inlet to Cape Hatteras NC', 'amz152', 'amz100', 'KHAT')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (48, 'C', 'Mid Atlantic', 'Pamlico Sound NC', 'amz135', 'amz100', 'KHAT')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (49, 'C', 'Mid Atlantic', 'Cape Hatteras to Ocracoke Inlet NC', 'amz154', 'amz100', 'KHAT')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (50, 'C', 'Mid Atlantic', 'Ocracoke Inlet to Cape Lookout NC', 'amz156', 'amz100', 'K77W')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (51, 'C', 'Mid Atlantic', 'Cape Lookout to Surf City NC', 'amz158', 'amz100', 'K77W')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (52, 'C', 'Mid Atlantic', 'Surf City to Cape Fear NC', 'amz250', 'amz200', 'KILM')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (53, 'C', 'Mid Atlantic', 'Cape Fear NC to Little River Inlet SC', 'amz252', 'amz200', 'KILM')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (54, 'C', 'Mid Atlantic', 'Little River Inlet to Murrells Inlet SC', 'amz254', 'amz200', 'KMYR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (55, 'C', 'Mid Atlantic', 'Murrells Inlet to South Santee River SC', 'amz256', 'amz200', 'KMYR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (56, 'C', 'Mid Atlantic', 'South Santee River to Edisto Beach SC', 'amz350', 'amz300', 'KMYR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (57, 'C', 'Mid Atlantic', 'Charleston Harbor SC', 'amz330', 'amz300', 'KCHS')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (58, 'C', 'Mid Atlantic', 'Edisto Beach SC to Savannah GA', 'amz352', 'amz300', 'KSAV')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (59, 'C', 'Mid Atlantic', 'Savannah to Altamaha Sound GA out 20NM', 'amz354', 'amz300', 'KSAV')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (60, 'C', 'Mid Atlantic', 'Savannah to Altamaha Sound GA from 20 NM to 60 NM', 'amz374', 'amz300', 'KSAV')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (61, 'C', 'Mid Atlantic', 'Altamaha Sound GA to Fernandina Beach FL to 20 NM', 'amz450', 'amz400', 'KJAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (62, 'C', 'Mid Atlantic', 'Altamaha Sound GA to Fernandina Beach FL from 20 NM to 60 NM', 'amz470', 'amz400', 'KJAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (63, 'C', 'Mid Atlantic', 'Port of Jacksonville FL', 'amz435', 'amz400', 'KJAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (64, 'C', 'Mid Atlantic', 'Fernandina Beach to St. Augustine FL to 20 NM', 'amz452', 'amz400', 'KJAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (65, 'C', 'Mid Atlantic', 'Fernandina Beach to St. Augustine FL from 20 NM to 60 NM', 'amz472', 'amz400', 'KJAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (66, 'C', 'Mid Atlantic', 'St. Augustine to Flagler Beach FL. to 20 NM', 'amz454', 'amz400', 'KSGJ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (67, 'C', 'Mid Atlantic', 'St. Augustine to Flagler Beach FL. from 20 NM to 60 NM', 'amz474', 'amz400', 'KSGJ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (68, 'C', 'Mid Atlantic', 'Flagler Beach to Cocoa Beach FL to 20 NM', 'amz550', 'amz500', 'KCOF')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (69, 'C', 'Mid Atlantic', 'Flagler Beach to Cocoa Beach FL from 20 NM to 60 NM', 'amz570', 'amz500', 'KCOF')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (70, 'C', 'Mid Atlantic', 'Cocoa Beach to Jupiter Inlet FL to 20 NM', 'amz555', 'amz500', 'KX80')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (71, 'C', 'Mid Atlantic', 'Cocoa Beach to Jupiter Inlet FL from 20 NM to 60 NM', 'amz575', 'amz500', 'KX80')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (72, 'C', 'Mid Atlantic', 'Lake Okeechobee', 'amz610', 'amz600', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (73, 'C', 'Mid Atlantic', 'Jupiter Inlet to Deerfield Beach FL to 20 NM', 'amz650', 'amz600', 'KX80')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (74, 'C', 'Mid Atlantic', 'Jupiter Inlet to Deerfield Beach FL from 20 NM to 60 NM', 'amz670', 'amz600', 'KX80')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (75, 'C', 'Mid Atlantic', 'Biscayne Bay', 'amz630', 'amz600', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (76, 'C', 'Mid Atlantic', 'Deerfield Beach to Ocean Reef FL to 20 NM', 'amz651', 'amz600', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (77, 'C', 'Mid Atlantic', 'Deerfield Beach to Ocean Reef FL from 20 NM to 60 NM', 'amz671', 'amz600', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (78, 'C', 'Gulf of Mexico', 'East Cape Sable to Chokoloskee FL to 20 NM', 'gmz657', 'gmz606', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (79, 'C', 'Gulf of Mexico', 'Chokoloskee to Bonita Beach FL to 20 NM', 'gmz656', 'gmz606', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (80, 'C', 'Gulf of Mexico', 'Chokoloskee to Bonita Beach FL from 20 NM to 60 NM', 'gmz676', 'gmz606', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (81, 'C', 'Gulf of Mexico', 'Florida Bay', 'gmz031', 'gmz005', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (82, 'C', 'Gulf of Mexico', 'Ocean Reef to Craig Key FL to 20 NM', 'gmz052', 'gmz005', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (83, 'C', 'Gulf of Mexico', 'Ocean Reef to Craig Key FL from 20 NM to 60 NM', 'gmz072', 'gmz005', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (84, 'C', 'Gulf of Mexico', 'Craig Key to the West end of 7 mile bridge to 20 NM', 'gmz053', 'gmz005', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (85, 'C', 'Gulf of Mexico', 'Craig Key to the west end of 7 mile bridge from 20 NM to 60 NM', 'gmz073', 'gmz005', 'KMIA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (86, 'C', 'Gulf of Mexico', 'West end of 7 mile bridge to Key West FL to 20 NM', 'gmz054', 'gmz005', 'KEYW')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (87, 'C', 'Gulf of Mexico', 'West end of 7 mile bridge to Key West FL from 20 NM to 60 NM', 'gmz074', 'gmz005', 'KEYW')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (88, 'C', 'Gulf of Mexico', 'Key West to 20 NM North, 20 NM West and 60 NM South of Dry Tortugas', 'gmz075', 'gmz005', 'KEYW')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (89, 'C', 'Gulf of Mexico', 'East of Cape Sable to Chokoloskee FL from 20 NM to 60 NM', 'gmz033', 'gmz005', 'KEYW')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (90, 'C', 'Gulf of Mexico', 'Bonita Beach to Englewood FL to 20 NM', 'gmz856', 'gmz800', 'KTBW')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (91, 'C', 'Gulf of Mexico', 'Bonita Beach to Englewood FL from 20 NM to 60 NM', 'gmz873', 'gmz800', 'KTPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (92, 'C', 'Gulf of Mexico', 'Tampa Bay', 'gmz830', 'gmz800', 'KTPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (93, 'C', 'Gulf of Mexico', 'Englewood to Tarpon Springs FL to 20 NM', 'gmz853', 'gmz800', 'KTPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (94, 'C', 'Gulf of Mexico', 'Englewood to Tarpon Springs FL from 20 NM to 60 NM', 'gmz870', 'gmz800', 'KTPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (95, 'C', 'Gulf of Mexico', 'Tarpon Springs to Suwannee River FL to 20 NM', 'gmz850', 'gmz800', 'KTPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (96, 'C', 'Gulf of Mexico', 'Tarpon Springs to Suwannee River FL from 20 NM to 60 NM', 'gmz876', 'gmz800', 'KTPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (97, 'C', 'Gulf of Mexico', 'Suwannee River to Apalachicola FL to 20 NM', 'gmz755', 'gmz700', 'KTLH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (98, 'C', 'Gulf of Mexico', 'Suwannee River to Apalachicola FL from 20 NM to 60 NM', 'gmz775', 'gmz700', 'KTLH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (99, 'C', 'Gulf of Mexico', 'Apalachicola to Destin FL to 20 NM', 'gmz750', 'gmz700', 'KTLH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (100, 'C', 'Gulf of Mexico', 'Apalachicola to Destin FL from 20 NM to 60 NM', 'gmz770', 'gmz700', 'KTLH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (101, 'O', 'North Atlantic Offshore', 'Gulf of Maine', 'anz081', 'anz080', 'K2B8')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (102, 'O', 'North Atlantic Offshore', 'Georges Bank', 'anz082', 'anz080', 'K2B8')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (103, 'O', 'North Atlantic Offshore', 'South of New England', 'anz083', 'anz080', 'KLGA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (104, 'O', 'North Atlantic Offshore', 'Hudson Canyon to Baltimore Canyon', 'anz084', 'anz080', 'KLGA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (105, 'O', 'North Atlantic Offshore', 'Baltimore Canyon to Hatteras Canyon', 'anz085', 'anz089', 'KHSE')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (106, 'O', 'North Atlantic Offshore', 'Hatteras Canyon to Cape Fear', 'anz086', 'anz089', 'KHAT')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (107, 'O', 'North Atlantic Offshore', 'Cape Fear to 31 N', 'anz088', 'anz089', 'K85J')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (108, 'O', 'Mid Atlantic Offshore', 'South of 31 N - West of 65 West', 'amz080', 'amz088', 'KJAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (109, 'O', 'Mid Atlantic Offshore', 'From 7 N to 22 N Between 55 W and 65 W', 'amz087', 'amz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (110, 'O', 'Mid Atlantic Offshore', '75 W to the Leeward and Windward Islands', 'amz086', 'amz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (111, 'O', 'Mid Atlantic Offshore', 'South of 15 N West of 75 W', 'amz084', 'amz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (112, 'O', 'Mid Atlantic Offshore', 'North of 15 N West of 75 W', 'amz082', 'amz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (113, 'O', 'Gulf of Mexico Offshore', 'East Gulf Between 81 W and 85 W', 'gmz086', 'gmz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (114, 'O', 'Gulf of Mexico Offshore', 'Middle Gulf Between 85 W and 90 W', 'gmz084', 'gmz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (115, 'O', 'Gulf of Mexico Offshore', 'NW Gulf North of 25 N W of 90 W Inc Flower Garden Banks National Marine Sanctuary', 'gmz080', 'gmz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (116, 'O', 'Gulf of Mexico Offshore', 'SW Gulf South of 25 N West of 90 W', 'gmz082', 'gmz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (117, 'O', 'East Pacific Offshore', 'Point Conception to Guadalupe Island', 'pzz085', 'pzz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (118, 'O', 'East Pacific Offshore', 'Point Arena to Point Conception', 'pzz084', 'pzz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (119, 'O', 'East Pacific Offshore', 'Point Saint George to Point Arena', 'pzz083', 'pzz089', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (120, 'O', 'East Pacific Offshore', 'Point Lookout to Point Saint George', 'pzz082', 'pzz080', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (121, 'O', 'East Pacific Offshore', 'Cape Flattery to Cape Lookout', 'pzz081', 'pzz080', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (122, 'O', 'Gulf of Alaska', 'North of 55 N to East of 144 W', 'pkz310', 'pkz398', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (123, 'O', 'Gulf of Alaska', 'North of 55 N and West of 144 W', 'pkz350', 'pkz399', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (124, 'O', 'S Central Bering Sea Off', 'East of the International Date Line', 'pkz410', 'pkz499', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (125, 'O', 'Mid Pacific Offshore', 'Within 240 NM of Hawaii', 'phz180', 'phz105', 'PHNL')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (126, 'C', 'Mid Atlantic', 'Rio Guajataca eastward to Cabo San Juan, eastward to Culebra, St. Thomas, St. John', 'amz720', 'amz700', 'KSJU')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (127, 'C', 'Mid Atlantic', 'northward to 19.5 N and between 68 W and 64 W, from northwest coast of Puerto Rico at Punta Caden', 'amz710', 'amz700', 'KSJU')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (128, 'C', 'Mid Atlantic', 'Punta Viento, north to Cabo San Juan, southward to 17 N and eastward to 64 W', 'amz730', 'amz700', 'KSJU')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (129, 'C', 'Mid Atlantic', 'west coast from Punta Cadena to Punta Melones', 'amz750', 'amz700', 'KSJU')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (130, 'C', 'Mid Atlantic', 'Punta Viento to Punta Melones, outside of 12 nautical miles Punta Melones to Punta Cadena', 'amz740', 'amz700', 'KSJU')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (131, 'C', 'Mid Pacific', 'Hawaiian Coastal Waters', 'phz150', 'phz100', 'PHNL')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (132, 'C', 'Mid Pacific', 'Channels between Hawaiian Islands', 'phz130', 'phz100', 'PHNL')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (133, 'C', 'Mid Pacific', 'Guam', 'pmz151', 'pmz150', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (134, 'C', 'Mid Pacific', 'Northern Mariana Islands - Rota', 'pmz152', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (135, 'C', 'Mid Pacific', 'Northern Mariana Islands - Tinian', 'pmz153', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (136, 'C', 'Mid Pacific', 'Northern Mariana Islands - Saipan', 'pmz154', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (137, 'C', 'Mid Pacific', 'Republic of Palau - Koror Palau', 'pmz161', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (138, 'C', 'Mid Pacific', 'Federated States of Micronesia - Yap', 'pmz171', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (139, 'C', 'Mid Pacific', 'Federated States of Micronesia - Chuuk', 'pmz172', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (140, 'C', 'Mid Pacific', 'Federated States of Micronesia - Pohnpei', 'pmz173', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (141, 'C', 'Mid Pacific', 'Federated States of Micronesia - Kosrae', 'pmz174', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (142, 'C', 'Mid Pacific', 'Republic of the Marshall Islands - Majuro', 'pmz181', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (143, 'C', 'South Pacific', 'Coastal Waters of Tututila and Aunuu Islands', 'psz150', 'psz100', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (144, 'C', 'South Pacific', 'Coastal Waters of Manua Islands', 'psz151', 'psz100', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (145, 'C', 'South Pacific', 'Coastal Waters of Swains Island', 'psz152', 'psz100', '')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (146, 'C', 'Gulf of Mexico', 'Destin to Pensacola FL to 20 NM', 'gmz655', 'gmz600', 'KNPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (147, 'C', 'Gulf of Mexico', 'Destin to Pensacola FL from 20 NM to 60 NM', 'gmz675', 'gmz600', 'KNPA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (148, 'C', 'Gulf of Mexico', 'Pensacola FL to Pascagoula MS from 20 NM to 60 NM', 'gmz670', 'gmz600', 'KBFM')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (149, 'C', 'Gulf of Mexico', 'Pensacola FL to Pascagoula MS to 20 NM', 'gmz650', 'gmz600', 'KBFM')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (150, 'C', 'Gulf of Mexico', 'Mobile Bay', 'gmz630', 'gmz600', 'KBFM')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (151, 'C', 'Gulf of Mexico', 'Pascagoula MS to Mississippi River to 20 NM', 'gmz555', 'gmz500', 'KNBG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (152, 'C', 'Gulf of Mexico', 'Pascagoula MS to Mississippi River from 20 NM to 60 NM', 'gmz575', 'gmz500', 'KNBG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (153, 'C', 'Gulf of Mexico', 'Lake Pontchartrain/Lake Maurepas', 'gmz530', 'gmz500', 'KNBG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (154, 'C', 'Gulf of Mexico', 'Mississippi River to Atchafalaya River to 20 NM', 'gmz550', 'gmz501', 'KNBG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (155, 'C', 'Gulf of Mexico', 'Mississippi River to Atchafalaya River from 20 NM to 60 NM', 'gmz570', 'gmz501', 'KNBG')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (156, 'C', 'Gulf of Mexico', 'Atchafalaya River to Cameron LA to 20 NM', 'gmz455', 'gmz400', 'KLCH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (157, 'C', 'Gulf of Mexico', 'Atchafalaya River to Cameron LA from 20 NM to 60 NM', 'gmz475', 'gmz400', 'KLCH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (158, 'C', 'Gulf of Mexico', 'Cameron LA to High Island TX to 20 NM', 'gmz450', 'gmz400', 'KLCH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (159, 'C', 'Gulf of Mexico', 'Cameron LA to High Island TX from 20 NM to 60 NM', 'gmz470', 'gmz400', 'KLCH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (160, 'C', 'Gulf of Mexico', 'Galveston Bay TX', 'gmz335', 'gmz300', 'K9R0')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (161, 'C', 'Gulf of Mexico', 'High Island to Freeport TX to 20 NM', 'gmz355', 'gmz300', 'K9R0')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (162, 'C', 'Gulf of Mexico', 'High Island to Freeport TX from 20 NM to 60 NM', 'gmz375', 'gmz300', 'K9R0')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (163, 'C', 'Gulf of Mexico', 'Matagorda Bay TX', 'gmz330', 'gmz300', 'KIAH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (164, 'C', 'Gulf of Mexico', 'Freeport to Matagorda Ship Channel to 20 NM', 'gmz350', 'gmz300', 'KIAH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (165, 'C', 'Gulf of Mexico', 'Freeport to Matagorda Ship Channel from 20 NM to 60 NM', 'gmz370', 'gmz300', 'KIAH')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (166, 'C', 'Gulf of Mexico', 'Waterways from Port Aransas to Port O\'Connor', 'gmz235', 'gmz200', 'KNGP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (167, 'C', 'Gulf of Mexico', 'Waterways from Baffin Bay to Port Aransas TX', 'gmz230', 'gmz200', 'KNGP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (168, 'C', 'Gulf of Mexico', 'Port Aransas to Matagorda Ship Channel to 20 NM', 'gmz255', 'gmz200', 'KNGP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (169, 'C', 'Gulf of Mexico', 'Port Aransas to Matagorda Ship Channel from 20 NM to 60 NM', 'gmz275', 'gmz200', 'KNGP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (170, 'C', 'Gulf of Mexico', 'Baffin Bay to Port Aransas TX to 20 NM', 'gmz250', 'gmz200', 'KNGP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (171, 'C', 'Gulf of Mexico', 'Baffin Bay to Port Aransas TX from 20 NM to 60 NM', 'gmz270', 'gmz200', 'KNGP')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (172, 'C', 'Gulf of Mexico', 'Laguna Madre Bay TX', 'gmz130', 'gmz100', 'KBRO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (173, 'C', 'Gulf of Mexico', 'Baffin Bay to Port Mansfield TX to 20 NM', 'gmz155', 'gmz100', 'KBRO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (174, 'C', 'Gulf of Mexico', 'Baffin Bay to Port Mansfield TX from 20 NM to 60 NM', 'gmz175', 'gmz100', 'KBRO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (175, 'C', 'Gulf of Mexico', 'Port Mansfield TX to Rio Grande to 20 NM', 'gmz150', 'gmz100', 'KBRO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (176, 'C', 'Gulf of Mexico', 'Port Mansfield TX to Rio Grande from 20 NM to 60 NM', 'gmz170', 'gmz100', 'KBRO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (177, 'C', 'East Pacific', 'San Mateo CA to Mexican Border to 30 NM', 'pzz750', 'pzz700', 'KNZY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (178, 'C', 'East Pacific', 'San Mateo CA to Mexican Border from 30 NM to 60 NM', 'pzz775', 'pzz700', 'KNZY')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (179, 'C', 'East Pacific', 'Point Mugu to San Mateo Pt. CA including Santa Catalina and Santa Barbara', 'pzz655', 'pzz600', 'KLAZ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (180, 'C', 'East Pacific', 'Santa Cruz to San Clemente CA to 60 NM', 'pzz676', 'pzz600', 'KLAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (181, 'C', 'East Pacific', 'Santa Barbara Channel from Pt. Mugu to Santa Cruz CA', 'pzz650', 'pzz600', 'KLAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (182, 'C', 'East Pacific', 'Pt. Arguello to Santa Cruz Island CA to 60 NM', 'pzz673', 'pzz600', 'KLAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (183, 'C', 'East Pacific', 'Pt. Piedras Blancas to Pt. Arguello to 60 NM', 'pzz670', 'pzz600', 'KLAX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (184, 'C', 'East Pacific', 'Monterey Bay CA', 'pzz535', 'pzz500', 'KSFO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (185, 'C', 'East Pacific', 'Pt. Piedras Blancas to Pigeon Pt. to 20 NM', 'pzz555', 'pzz500', 'KSFO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (186, 'C', 'East Pacific', 'Pt. Piedras Blancas to Pigeon Pt. from 20 NM to 60 NM', 'pzz575', 'pzz500', 'KSFO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (187, 'C', 'East Pacific', 'San Francisco, San Pablo, Suisan bays and West Delta CA', 'pzz530', 'pzz500', 'KSFO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (188, 'C', 'East Pacific', 'Pigeon Pt. to Pt. Arena CA to 20 NM', 'pzz550', 'pzz500', 'KSFO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (189, 'C', 'East Pacific', 'Pigeon Pt. to Pt. Arena CA from 20 NM to 60 NM', 'pzz570', 'pzz500', 'KSFO')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (190, 'C', 'East Pacific', 'Point Arena to Cape Mendocino CA to 20 NM', 'pzz455', 'pzz400', 'KEKA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (191, 'C', 'East Pacific', 'Point Arena to Cape Mendocino CA from 20 NM to 60 NM', 'pzz475', 'pzz400', 'KEKA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (192, 'C', 'East Pacific', 'Cape Mendocino to Pt. St. George CA to 20 NM', 'pzz450', 'pzz400', 'KEKA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (193, 'C', 'East Pacific', 'Cape Mendocino to Pt. St. George CA from 20 NM to 60 NM', 'pzz470', 'pzz400', 'KEKA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (194, 'C', 'East Pacific', 'Pt. St. George CA to Cape Blanco OR to 20 NM', 'pzz356', 'pzz300', 'KMFR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (195, 'C', 'East Pacific', 'Pt. St. George CA to Cape Blanco OR from 20 NM to 60 NM', 'pzz376', 'pzz300', 'KMFR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (196, 'C', 'East Pacific', 'Cape Blanco to Cape Arago OR to 20 NM', 'pzz353', 'pzz300', 'KMFR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (197, 'C', 'East Pacific', 'Cape Blanco to Cape Arago OR from 20 NM to 60 NM', 'pzz373', 'pzz300', 'KMFR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (198, 'C', 'East Pacific', 'Cape Arago to Florence OR to 20 NM', 'pzz350', 'pzz300', 'KMFR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (199, 'C', 'East Pacific', 'Cape Arago to Florence OR from 20 NM to 60 NM', 'pzz370', 'pzz300', 'KMFR')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (200, 'C', 'East Pacific', 'Florence to Cascade Head OR to 20 NM', 'pzz255', 'pzz200', 'KPDX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (201, 'C', 'East Pacific', 'Florence to Cascade Head OR from 20 NM to 60 NM', 'pzz275', 'pzz200', 'KPDX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (202, 'C', 'East Pacific', 'Cascade Head OR to Cape Shoalwater WA to 20 NM', 'pzz250', 'pzz200', 'KPDX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (203, 'C', 'East Pacific', 'Cascade Head OR to Cape Shoalwater WA from 20 NM to 60 NM', 'pzz270', 'pzz200', 'KPDX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (204, 'C', 'East Pacific', 'Columbia River Bar WA', 'pzz210', 'pzz200', 'KPDX')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (205, 'C', 'East Pacific', 'Gray Harbor Bar WA', 'pzz110', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (206, 'C', 'East Pacific', 'Cape Shoalwater to Pt. Grenville WA to 20 NM', 'pzz156', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (207, 'C', 'East Pacific', 'Cape Shoalwater to Pt. Grenville WA from 20 NM to 60 NM', 'pzz176', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (208, 'C', 'East Pacific', 'Pt. Grenville to James Island WA to 20 NM', 'pzz153', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (209, 'C', 'East Pacific', 'Grenville to James Island WA from 20 NM to 60 NM', 'pzz173', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (210, 'C', 'East Pacific', 'James Island to Cape Flattery WA to 20 NM', 'pzz150', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (211, 'C', 'East Pacific', 'James Island to Cape Flattery WA from 20 NM to 60 NM', 'pzz170', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (212, 'C', 'East Pacific', 'Strait of Juan de Fuca from Cape Flattery to Slip Point WA', 'pzz130', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (213, 'C', 'East Pacific', 'Strait of Juan de Fuca from Slip Point to New Dungeness Light WA', 'pzz131', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (214, 'C', 'East Pacific', 'Puget Sound and Hood Canal WA', 'pzz135', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (215, 'C', 'East Pacific', 'Admiralty Inlet from Admiralty head to Foulweather Bluff WA', 'pzz134', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (216, 'C', 'East Pacific', 'Strait of Juan de Fuca from New Dungeness Light to Whidbey Island', 'pzz132', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (217, 'C', 'East Pacific', 'Northern Inland Waters Camano Island to Pt. Roberts inc. San Juan Island', 'pzz133', 'pzz100', 'KSEA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (218, 'C', 'North Pacific', 'Glacier Bay AK', 'pkz011', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (219, 'C', 'North Pacific', 'Northern Lynn Canal AK', 'pkz012', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (220, 'C', 'North Pacific', 'Southern Lynn Canal AK', 'pkz013', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (221, 'C', 'North Pacific', 'Icy Strait AK', 'pkz021', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (222, 'C', 'North Pacific', 'Cross Sound AK', 'pkz022', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (223, 'C', 'North Pacific', 'Stephens Passage AK', 'pkz031', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (224, 'C', 'North Pacific', 'Northern Chatham Strait AK', 'pkz032', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (225, 'C', 'North Pacific', 'Southern Chatham Strait AK', 'pkz033', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (226, 'C', 'North Pacific', 'Fredrick Sound AK', 'pkz034', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (227, 'C', 'North Pacific', 'Fredrick Sound AK', 'pkz035', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (228, 'C', 'North Pacific', 'Clarence Strait AK', 'pkz036', 'pkz098', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (229, 'C', 'North Pacific', 'Dixon Entrance to Cape Decision, AK', 'pkz041', 'pkz099', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (230, 'C', 'North Pacific', 'Cape Decision to Cape Edgecumbe, AK', 'pkz042', 'pkz099', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (231, 'C', 'North Pacific', 'Cape Edgecumbe to Cape Fairweather, AK', 'pkz043', 'pkz099', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (232, 'C', 'North Pacific', 'Cape Fairweather to Icy Cape, AK', 'pkz051', 'pkz099', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (233, 'C', 'North Pacific', 'Icy Cape to Cape Suckling, AK', 'pkz052', 'pkz099', 'PAJN')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (234, 'C', 'North Pacific', 'Yakutat Bay AK', 'pkz053', 'pkz097', 'KYAK')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (235, 'C', 'Gulf of Alaska', 'Cape Suckling to Gore Point, AK', 'pkz120', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (236, 'C', 'Gulf of Alaska', 'Resurrection Bay AK', 'pkz121', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (237, 'C', 'Gulf of Alaska', 'Prince William Sound, AK', 'pkz125', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (238, 'C', 'Gulf of Alaska', 'Passage Canal, AK', 'pkz129', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (239, 'C', 'Gulf of Alaska', 'Barren Island and Kamishak Bay AK', 'pkz130', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (240, 'C', 'Gulf of Alaska', 'Kodiak Island Waters Gore Pt to Sitkinik AK', 'pkz132', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (241, 'C', 'Gulf of Alaska', 'Shelikof Strait, AK', 'pkz138', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (242, 'C', 'Gulf of Mexico', 'Cook Inlet, north of Kamishak Bay and English Bay AK', 'pkz140', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (243, 'C', 'Gulf of Alaska', 'Kachemak Bay AK', 'pkz141', 'pkz197', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (244, 'C', 'Gulf of Alaska', 'Port Valdez AK', 'pkz126', 'pkz196', 'PAVD')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (245, 'C', 'Gulf of Alaska', 'Valdez Narrows AK', 'pkz127', 'pkz196', 'PAVD')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (246, 'C', 'Gulf of Alaska', 'Valdez Arm AK', 'pkz128', 'pkz196', 'PAVD')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (247, 'C', 'Gulf of Alaska', 'Chiniak Bay AK', 'pkz136', 'pkz198', 'PADQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (248, 'C', 'Gulf of Alaska', 'Marmot Bay AK', 'pkz137', 'pkz198', 'PADQ')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (249, 'C', 'North Pacific', 'Coastal waters from South of Alaska Peninsula, Sitkinak to Castle Cape, AK', 'pkz150', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (250, 'C', 'North Pacific', 'Coastal waters from South of Alaska Peninsula, Castle Cape to Cape Sarichef, AK', 'pkz155', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (251, 'C', 'North Pacific', 'Bristol Bay, north portion from Cape Newenham to Port Heiden AK', 'pkz160', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (252, 'C', 'North Pacific', 'Bristol Bay, south portion from Port Heiden to Cape Sarichef AK', 'pkz165', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (253, 'C', 'North Pacific', 'Cape Newenham to Dall Point AK', 'pkz180', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (254, 'C', 'North Pacific', 'Eastern Aleutian Islands, Cape Sarichef to Nikolski, AK', 'pkz170', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (255, 'C', 'North Pacific', 'Unalaska Bay AK', 'pkz171', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (256, 'C', 'North Pacific', 'Eastern Aleutian Islands, Nikolski to Adak, AK', 'pkz172', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (257, 'C', 'North Pacific', 'Western Aleutian Islands, Adak to Kiska, AK', 'pkz175', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (258, 'C', 'North Pacific', 'Western Aleutian Islands, Kiska to Attu, AK', 'pkz176', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (259, 'C', 'North Pacific', 'Pribilof Islands Nearshore within 5 nm of Islands AK', 'pkz179', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (260, 'C', 'North Pacific', 'St. Matthews Island waters AK', 'pkz185', 'pkz199', 'PANC')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (261, 'C', 'S Central Bering Sea', 'Norton Sound, Sledge Island to Nunaktuk Island AK', 'pkz290', 'pkz299', 'PAFA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (262, 'C', 'S Central Bering Sea', 'Dall Point to Wales, AK', 'pkz295', 'pkz299', 'PAFA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (263, 'C', 'S Central Bering Sea', 'Wales to Cape Lisburne, AK', 'pkz205', 'pkz299', 'PAFA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (264, 'C', 'S Central Bering Sea', 'Western Artic Coast, Cape Lisburne to Cape Halkett, AK', 'pkz210', 'pkz299', 'PAFA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (265, 'C', 'S Central Bering Sea', 'Eastern Arctic Coast, Cape Halkett to Demarcation Point, AK', 'pkz215', 'pkz299', 'PAFA')";
	$queries[] = "INSERT INTO ".$prefix."_weathermarine VALUES (266, 'C', 'S Central Bering Sea', 'Kotzebue Sound East of Cape Espenburg & Cape Krusenstern, AK', 'pkz200', 'pkz299', 'PAFA')";

	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1, 'us', 'Alabama', 'Alabaster, Shelby County Airport', 'KEET', '01117', 'kbmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2, 'us', 'Alabama', 'Alexander City, Thomas C Russell Field Airport', 'KALX', '01123', 'kmxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3, 'us', 'Alabama', 'Andalusia, Andalusia-Opp Municipal Airport', 'K79J', '01039', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4, 'us', 'Alabama', 'Anniston, Anniston Metropolitan Airport', 'KANB', '01015', 'kbmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (5, 'us', 'Alabama', 'Auburn-Opelika Airport', 'KAUO', '01081', 'kmxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (6, 'us', 'Alabama', 'Birmingham, Birmingham International Airport', 'KBHM', '01117', 'kbmx', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (7, 'us', 'Alabama', 'Cairns Army Air Field / Ozark', 'KOZR', '', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (8, 'us', 'Alabama', 'Decatur, Pryor Field', 'KDCU', '01103', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (9, 'us', 'Alabama', 'Dothan, Dothan Regional Airport', 'KDHN', '01069', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (10, 'us', 'Alabama', 'Evergreen, Middleton Field', 'KGZH', '01035', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (11, 'us', 'Alabama', 'Gadsden Municipal Automatic Weather Observing / Reporting System', 'KGAD', '01055', 'khtx', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (12, 'us', 'Alabama', 'Huntsville, Huntsville International / Jones Field', 'KHSV', '01089', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (13, 'us', 'Alabama', 'Huntsville, Madison County Executive Airport', 'KMDQ', '01089', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (14, 'us', 'Alabama', 'Maxwell Air Force Base / Montgomery', 'KMXF', '', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (15, 'us', 'Alabama', 'Mobile, Mobile Downtown Airport', 'KBFM', '01097', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (16, 'us', 'Alabama', 'Mobile, Mobile Regional Airport', 'KMOB', '01097', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (17, 'us', 'Alabama', 'Montgomery, Dannelly Field', 'KMGM', '01101', 'kmxx', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (18, 'us', 'Alabama', 'Muscle Shoals, North West Alabama Regional Airport', 'KMSL', '01033', 'kgwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (19, 'us', 'Alabama', 'Troy, Troy Municipal Airport', 'KTOI', '01109', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (20, 'us', 'Alabama', 'Tuscaloosa, Tuscaloosa Municipal Airport', 'KTCL', '01125', 'kbmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (21, 'us', 'Alaska', 'Adak, Naval Air Station', 'PADK', '02016', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (22, 'us', 'Alaska', 'Ambler, Ambler Airport', 'PAFM', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (23, 'us', 'Alaska', 'Anaktuvuk Pass', 'PAKP', '02185', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (24, 'us', 'Alaska', 'Anchorage / Elmendorf Air Force Base', 'PAED', '02020', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (25, 'us', 'Alaska', 'Anchorage, Ted Stevens Anchorage International Airport', 'PANC', '02020', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (26, 'us', 'Alaska', 'Aniak', 'PANI', '02050', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (27, 'us', 'Alaska', 'Annette Island', 'PANT', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (28, 'us', 'Alaska', 'Annik Airport', 'PANV', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (29, 'us', 'Alaska', 'Arctic Village', 'PARC', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (30, 'us', 'Alaska', 'Atka, Atka Airport', 'PAAK', '02016', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (31, 'us', 'Alaska', 'Barrow, Post Rogers Memorial Airport', 'PABR', '02185', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (32, 'us', 'Alaska', 'Barter Island', 'PABA', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (33, 'us', 'Alaska', 'Bethel / Bethel Airport', 'PABE', '02050', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (34, 'us', 'Alaska', 'Bettles, Bettles Airport', 'PABT', '02290', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (35, 'us', 'Alaska', 'Big River Lake', 'PALV', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (36, 'us', 'Alaska', 'Birchwood', 'PABV', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (37, 'us', 'Alaska', 'Buckland, Buckland Airport', 'PABL', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (38, 'us', 'Alaska', 'Cantwell', 'PATW', '02068', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (39, 'us', 'Alaska', 'Cape Lisburne Airways Facilities Sector', 'PALU', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (40, 'us', 'Alaska', 'Cape Newenham Airways Facilities Sector', 'PAEH', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (41, 'us', 'Alaska', 'Cape Romanzoff Airways Facilities Sector', 'PACZ', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (42, 'us', 'Alaska', 'Central, Central Airport', 'PARL', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (43, 'us', 'Alaska', 'Chandalar Lake', 'PALR', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (44, 'us', 'Alaska', 'Chignik, Chignik Airport', 'PAJC', '02164', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (45, 'us', 'Alaska', 'Chulitna', 'PAEC', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (46, 'us', 'Alaska', 'Cold Bay, Cold Bay Airport', 'PACD', '02013', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (47, 'us', 'Alaska', 'Cordova, Merle K. Smith Airport', 'PACV', '02261', 'paih', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (48, 'us', 'Alaska', 'Deadhorse, Alpine Airstrip', 'PALP', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (49, 'us', 'Alaska', 'Deadhorse, Deadhorse Airport', 'PASC', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (50, 'us', 'Alaska', 'Deering, Deering Airport', 'PADE', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (51, 'us', 'Alaska', 'dillingham municipal, ak', 'PADL', '02070', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (52, 'us', 'Alaska', 'Dutch Harbor', 'PADU', '02016', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (53, 'us', 'Alaska', 'Eagle, Eagle Airport', 'PAEG', '02240', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (54, 'us', 'Alaska', 'Egegik Automatic Weather Observing / Reporting System', 'PAII', '02164', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (55, 'us', 'Alaska', 'Elfin Cove Seaplane', 'PAEL', '02232', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (56, 'us', 'Alaska', 'Emmonak', 'PAEM', '02270', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (57, 'us', 'Alaska', 'Eureka, Skelton Airport', 'PAZK', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (58, 'us', 'Alaska', 'Fairbanks / Eielson Air Force Base', 'PAEI', '02090', 'papd', 'pahg', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (59, 'us', 'Alaska', 'Fairbanks, Fairbanks International Airport', 'PAFA', '02090', 'papd', 'pahg', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (60, 'us', 'Alaska', 'Farewell Lake, Farewell Lake Seaplane Base', 'PAFK', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (61, 'us', 'Alaska', 'Fort Greely / Allen U. S. Army Airfield, Ak', 'PABI', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (62, 'us', 'Alaska', 'Fort Yukon', 'PFYU', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (63, 'us', 'Alaska', 'Galbraith Lake', 'PAGB', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (64, 'us', 'Alaska', 'Galena, Edward G. Pitka Sr. Airport', 'PAGA', '02290', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (65, 'us', 'Alaska', 'Gambell Automatic Weather Observing / Reporting System', 'PAGM', '02180', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (66, 'us', 'Alaska', 'Golovin, Golovin Airport', 'PAGL', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (67, 'us', 'Alaska', 'Gulkana, Gulkana Airport', 'PAGK', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (68, 'us', 'Alaska', 'Gustavus', 'PAGS', '02232', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (69, 'us', 'Alaska', 'Haines, Haines Airport', 'PAHN', '02100', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (70, 'us', 'Alaska', 'Hayes River', 'PAHZ', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (71, 'us', 'Alaska', 'Healy River Airport', 'PAHV', '', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (72, 'us', 'Alaska', 'Homer', 'PAHO', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (73, 'us', 'Alaska', 'Hoonah Seaplane', 'PAOH', '02232', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (74, 'us', 'Alaska', 'hooper bay automatic weather observing / reporting system', 'PAHP', '02270', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (75, 'us', 'Alaska', 'Huslia', 'PAHS', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (76, 'us', 'Alaska', 'Hydaburg Seaplane', 'PAHY', '02201', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (77, 'us', 'Alaska', 'Iliamna / Iliamna Airport', 'PAIL', '02164', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (78, 'us', 'Alaska', 'Indian Mountain Airways Facilities Sector', 'PAIM', '02020', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (79, 'us', 'Alaska', 'Juneau, Juneau International Airport', 'PAJN', '02110', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (80, 'us', 'Alaska', 'Kake, Seabase Plane / Kake Airport', 'PAFE', '02280', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (81, 'us', 'Alaska', 'Kaltag, Kaltag Airport', 'PAKV', '02290', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (82, 'us', 'Alaska', 'Kenai, Kenai Municipal Airport', 'PAEN', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (83, 'us', 'Alaska', 'Ketchikan, Ketchikan International Airport', 'PAKT', '02130', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (84, 'us', 'Alaska', 'King Salmon, King Salmon Airport', 'PAKN', '02060', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (85, 'us', 'Alaska', 'Kivalina, Kivalina Airport', 'PAVL', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (86, 'us', 'Alaska', 'Klawock, Klawock Airport', 'PAKW', '02201', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (87, 'us', 'Alaska', 'Kodiak', 'PADQ', '02150', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (88, 'us', 'Alaska', 'Kotzebue, Wien Memorial Airport', 'PAOT', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (89, 'us', 'Alaska', 'Koyuk, Koyuk Airport', 'PAKK', '02180', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (90, 'us', 'Alaska', 'Kuparuk Airport', 'PAKU', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (91, 'us', 'Alaska', 'Lake Hood Seaplane', 'PALH', '02020', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (92, 'us', 'Alaska', 'Manley Hot Springs', 'PAML', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (93, 'us', 'Alaska', 'McCarthy', 'PAMX', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (94, 'us', 'Alaska', 'McGrath, McGrath Airport', 'PAMC', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (95, 'us', 'Alaska', 'McKinley Park, McKinley National Park Airport', 'PAIN', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (96, 'us', 'Alaska', 'Mekoryuk', 'PAMY', '02050', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (97, 'us', 'Alaska', 'Merrill Field', 'PAMR', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (98, 'us', 'Alaska', 'Merrill Pass West', 'PAER', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (99, 'us', 'Alaska', 'Metlakatla, Metlakatla Seaplane Base', 'PAMM', '02201', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (100, 'us', 'Alaska', 'Middleton Island, Ak', 'PAMD', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (101, 'us', 'Alaska', 'Minchumina', 'PAMH', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (102, 'us', 'Alaska', 'Nabesna / Devil Mountain', 'PABN', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (103, 'us', 'Alaska', 'Nenana / Mun.', 'PANN', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (104, 'us', 'Alaska', 'Noatak', 'PAWN', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (105, 'us', 'Alaska', 'Nome, Nome Airport', 'PAOM', '02180', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (106, 'us', 'Alaska', 'Northway, Northway Airport', 'PAOR', '02240', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (107, 'us', 'Alaska', 'Nuiqsut, Nuiqsut Airport', 'PAQT', '02185', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (108, 'us', 'Alaska', 'Palmer', 'PAAQ', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (109, 'us', 'Alaska', 'Paxson', 'PAXK', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (110, 'us', 'Alaska', 'Petersburg', 'PAPG', '02280', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (111, 'us', 'Alaska', 'Point Hope Automatic Weather Observing / Reporting System', 'PAPO', '02185', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (112, 'us', 'Alaska', 'Point Lay', 'PPIZ', '02185', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (113, 'us', 'Alaska', 'Port Alexander', 'PAAP', '02280', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (114, 'us', 'Alaska', 'Port Alsworth', 'PALJ', '02164', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (115, 'us', 'Alaska', 'Port Heiden', 'PAPH', '02164', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (116, 'us', 'Alaska', 'Portage, Portage Visitor Center', 'PATO', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (117, 'us', 'Alaska', 'Puntilla', 'PAPT', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (118, 'us', 'Alaska', 'Red Dog, Red Dog Airport', 'PARD', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (119, 'us', 'Alaska', 'Saint Mary\'s Automatic Weather Observing / Reporting System', 'PASM', '02270', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (120, 'us', 'Alaska', 'Saint Paul', 'PASN', '02016', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (121, 'us', 'Alaska', 'Sand Point', 'PASD', '02013', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (122, 'us', 'Alaska', 'Savoonga Airport', 'PASA', '02180', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (123, 'us', 'Alaska', 'Selawik', 'PASK', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (124, 'us', 'Alaska', 'Seldovia, Seldovia Airport', 'PASO', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (125, 'us', 'Alaska', 'Seward', 'PAWD', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (126, 'us', 'Alaska', 'Sheep Mountain, Sheep Mountain Airport', 'PASP', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (127, 'us', 'Alaska', 'Shemya, Eareckson As', 'PASY', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (128, 'us', 'Alaska', 'Shishmaref Automatic Weather Observing / Reporting System', 'PASH', '02180', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (129, 'us', 'Alaska', 'Sitka, Sitka Airport', 'PASI', '02220', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (130, 'us', 'Alaska', 'Skagway', 'PAGY', '02232', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (131, 'us', 'Alaska', 'Skwentna', 'PASW', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (132, 'us', 'Alaska', 'Slana Airport', 'PADT', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (133, 'us', 'Alaska', 'Sleetmute', 'PASL', '02050', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (134, 'us', 'Alaska', 'Snowshoe Lake', 'PALK', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (135, 'us', 'Alaska', 'Soldotna', 'PASX', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (136, 'us', 'Alaska', 'Sparrevohn Airways Facilities Sector', 'PASV', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (137, 'us', 'Alaska', 'St. George, St. George Airport', 'PAPB', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (138, 'us', 'Alaska', 'Sutton', 'PAJV', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (139, 'us', 'Alaska', 'Talkeetna, Talkeetna Airport', 'PATK', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (140, 'us', 'Alaska', 'Tanana, Calhoun Memorial Airport', 'PATA', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (141, 'us', 'Alaska', 'Tatalina Automatic Weather Observing / Reporting System', 'PATL', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (142, 'us', 'Alaska', 'Tin City Airways Facilities Sector', 'PATC', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (143, 'us', 'Alaska', 'Togiac Village Automatic Weather Observing / Reporting System', 'PATG', '02070', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (144, 'us', 'Alaska', 'Unalakleet', 'PAUN', '02180', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (145, 'us', 'Alaska', 'Valdez 2', 'PAVD', '02261', 'paih', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (146, 'us', 'Alaska', 'Valdez Weather Station Office', 'PAVW', '02261', 'paih', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (147, 'us', 'Alaska', 'Wainwright U. S. Army Airfield', 'PAFB', '02185', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (148, 'us', 'Alaska', 'Wainwright, Wainwright Airport', 'PAWI', '02185', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (149, 'us', 'Alaska', 'Wasilla, Wasilla Airport', 'PAWS', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (150, 'us', 'Alaska', 'Whittier', 'PAWR', '02261', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (151, 'us', 'Alaska', 'Willow Airport', 'PAUO', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (152, 'us', 'Alaska', 'Wrangell', 'PAWG', '02280', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (153, 'us', 'Alaska', 'Yakutat', 'PAYA', '02282', 'paih', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (154, 'us', 'Arizona', 'Ajo Municipal', 'KP01', '', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (155, 'us', 'Arizona', 'Bullhead City', 'KP06', '04015', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (156, 'us', 'Arizona', 'Bullhead City, Laughlin/Bullhead International Airport', 'KIFP', '04015', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (157, 'us', 'Arizona', 'Casa Granda Automatic Weather Observing / Reporting System', 'KCGZ', '04021', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (158, 'us', 'Arizona', 'Davis-Monthan Air Force Base', 'KDMA', '', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (159, 'us', 'Arizona', 'douglas bisbee, bisbee douglas international airport', 'KDUG', '04003', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (160, 'us', 'Arizona', 'Flagstaff, Flagstaff Pulliam Airport', 'KFLG', '04005', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (161, 'us', 'Arizona', 'Fort Huachuca', 'KFHU', '04009', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (162, 'us', 'Arizona', 'Gila Bend U. S. Army Airfield', 'KGBN', '04007', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (163, 'us', 'Arizona', 'Glendale, Glendale Municipal Airport', 'KGEU', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (164, 'us', 'Arizona', 'Goodyear Municipal', 'KGYR', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (165, 'us', 'Arizona', 'Grand Canyon, Grand Canyon National Park Airport', 'KGCN', '04005', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (166, 'us', 'Arizona', 'Grand Canyon, Valle Airport', 'K40G', '04005', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (167, 'us', 'Arizona', 'Kingman, Kingman Airport', 'KIGM', '04015', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (168, 'us', 'Arizona', 'Lake Havasu Automatic Weather Observing / Reporting System', 'KLHU', '04025', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (169, 'us', 'Arizona', 'Luke Air Force Base / Phoenix', 'KLUF', '', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (170, 'us', 'Arizona', 'Lukeville', 'KP65', '04019', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (171, 'us', 'Arizona', 'Mesa / Falcon Field', 'KFFZ', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (172, 'us', 'Arizona', 'Mesa, Williams Gateway Airport', 'KIWA', '', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (173, 'us', 'Arizona', 'Nogales Automatic Meteorological Observing System', 'K13A', '04023', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (174, 'us', 'Arizona', 'Nogales, Nogales International Airport', 'KOLS', '04023', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (175, 'us', 'Arizona', 'Page, Page Municipal Airport', 'KPGA', '', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (176, 'us', 'Arizona', 'Payson', 'KPJB', '04007', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (177, 'us', 'Arizona', 'Phoenix, Phoenix Sky Harbor International Airport', 'KPHX', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (178, 'us', 'Arizona', 'Phoenix, Phoenix-Deer Valley Municipal Airport', 'KDVT', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (179, 'us', 'Arizona', 'Prescott, Love Field', 'KPRC', '04025', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (180, 'us', 'Arizona', 'Safford Automatic Meteorological Observing System', 'KE74', '04009', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (181, 'us', 'Arizona', 'Safford, Safford Municipal Airport', 'KSAD', '04009', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (182, 'us', 'Arizona', 'Scottsdale, Scottsdale Airport', 'KSDL', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (183, 'us', 'Arizona', 'Sedona Airport', 'KSEZ', '04005', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (184, 'us', 'Arizona', 'Show Low Municipal', 'KSOW', '04017', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (185, 'us', 'Arizona', 'St. Johns, St. Johns Industrial Airpark', 'KSJN', '', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (186, 'us', 'Arizona', 'Tucson, Tucson International Airport', 'KTUS', '04019', 'kemx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (187, 'us', 'Arizona', 'Window Rock, Window Rock Airport', 'KRQE', '04001', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (188, 'us', 'Arizona', 'Winslow, Winslow Municipal Airport', 'KINW', '04017', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (189, 'us', 'Arizona', 'Yuma / Yuma International', 'KYUM', '04027', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (190, 'us', 'Arizona', 'Yuma, Marine Corps Air Station', 'KNYL', '', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (191, 'us', 'Arkansas', 'Batesville Automatic Weather Observing / Reporting System', 'KBVX', '05127', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (192, 'us', 'Arkansas', 'Bentonville Automatic Weather Observing / Reporting System', 'KVBT', '05125', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (193, 'us', 'Arkansas', 'Blytheville, Blytheville Municipal Airport', 'KHKA', '05093', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (194, 'us', 'Arkansas', 'Camden / Harrell Field', 'KCDH', '05103', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (195, 'us', 'Arkansas', 'De Queen, Helms Sevier County Airport', 'KDEQ', '05133', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (196, 'us', 'Arkansas', 'Eaker Air Force Base', 'KBYH', '', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (197, 'us', 'Arkansas', 'el dorado, south arkansas regional at goodwin field airport', 'KELD', '05139', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (198, 'us', 'Arkansas', 'Fayetteville, Drake Field', 'KFYV', '05143', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (199, 'us', 'Arkansas', 'Fayetteville/Springdale, Northwest Arkansas Regional Airport', 'KXNA', '05143', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (200, 'us', 'Arkansas', 'Flippin Automatic Weather Observing / Reporting System', 'KFLP', '05089', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (201, 'us', 'Arkansas', 'Fort Smith, Fort Smith Regional Airport', 'KFSM', '05131', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (202, 'us', 'Arkansas', 'Harrison, Boone County Airport', 'KHRO', '05009', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (203, 'us', 'Arkansas', 'Hot Springs, Memorial Field', 'KHOT', '', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (204, 'us', 'Arkansas', 'Jonesboro, Jonesboro Municipal Airport', 'KJBR', '05031', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (205, 'us', 'Arkansas', 'Little Rock Air Force Base', 'KLRF', '05119', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (206, 'us', 'Arkansas', 'Little Rock, Adams Field', 'KLIT', '05119', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (207, 'us', 'Arkansas', 'Monticello, Monticello Municipal Airport', 'KLLQ', '05043', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (208, 'us', 'Arkansas', 'Mount Ida', 'KMWT', '05033', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (209, 'us', 'Arkansas', 'Mount Ida, Ouachita Seed Orchard', 'KM39', '05033', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (210, 'us', 'Arkansas', 'Mountain Home, Baxter County Regional Airport', 'KBPK', '05033', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (211, 'us', 'Arkansas', 'North Little Rock / Municipal Airport, Ar.', 'KLZK', '05119', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (212, 'us', 'Arkansas', 'Pine Bluff, Grider Field', 'KPBF', '05069', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (213, 'us', 'Arkansas', 'Rogers Automatic Weather Observing / Reporting System', 'KROG', '05007', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (214, 'us', 'Arkansas', 'Russellville, Russellville Municipal Airport', 'KRUE', '05145', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (215, 'us', 'Arkansas', 'Siloam Springs Automatic Weather Observing / Reporting System', 'KSLG', '05007', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (216, 'us', 'Arkansas', 'Springdale Municipal', 'KASG', '05029', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (217, 'us', 'Arkansas', 'Stuttgart Automatic Weather Observing / Reporting System', 'KSGT', '05001', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (218, 'us', 'Arkansas', 'Texarkana, Texarkana Regional-Webb Field', 'KTXK', '05091', 'kshv', 'ksrx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (219, 'us', 'Arkansas', 'Walnut Ridge Automatic Weather Observing / Reporting System', 'KARG', '05075', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (220, 'us', 'California', 'Alameda Naval Air Station', 'KNGZ', '06001', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (221, 'us', 'California', 'Alturas', 'KAAT', '06049', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (222, 'us', 'California', 'Anacapa Island', 'KL46', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (223, 'us', 'California', 'Apple Valley', 'KAPV', '06061', 'keyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (224, 'us', 'California', 'Arcata / Eureka, Arcata Airport', 'KACV', '06023', 'kbhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (225, 'us', 'California', 'Avalon, Catalina Airport', 'KAVX', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (226, 'us', 'California', 'Bakersfield, Meadows Field', 'KBFL', '06071', 'kesx', 'khnx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (227, 'us', 'California', 'Beale Air Force Base / Marysvile', 'KBAB', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (228, 'us', 'California', 'Beaumont', 'KBUO', '06065', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (229, 'us', 'California', 'Bicycle Lake U. S. Army Airfield, Ca', 'KBYS', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (230, 'us', 'California', 'Bishop, Bishop Airport', 'KBIH', '06027', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (231, 'us', 'California', 'Blunts Reef Coast Guard Station', 'K84Q', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (232, 'us', 'California', 'Blythe, Blythe Airport', 'KBLH', '06065', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (233, 'us', 'California', 'Bodega Bay Coast Guard Light Station', 'K92Q', '06097', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (234, 'us', 'California', 'Burbank, Burbank-Glendale-Pasadena Airport', 'KBUR', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (235, 'us', 'California', 'Burney', 'KBNY', '06089', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (236, 'us', 'California', 'Cabrillo Beach', 'KL14', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (237, 'us', 'California', 'Camarillo, Camarillo Airport', 'KCMA', '06111', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (238, 'us', 'California', 'Camp San Luis Airport', 'KCSL', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (239, 'us', 'California', 'Campo', 'KCZZ', '06073', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (240, 'us', 'California', 'Carlsbad, McClellan-Palomar Airport', 'KCRQ', '06073', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (241, 'us', 'California', 'Castroville / Moss', 'K54Q', '06053', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (242, 'us', 'California', 'Chico Municipal', 'KCIC', '06007', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (243, 'us', 'California', 'China Lake, Naval Air Facility', 'KNID', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (244, 'us', 'California', 'Chino, Chino Airport', 'KCNO', '06071', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (245, 'us', 'California', 'Concord, Buchanan Field', 'KCCR', '06013', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (246, 'us', 'California', 'Crescent City, jack mcnamara field airport', 'KCEC', '06063', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (247, 'us', 'California', 'Crows Landing Naval Auxiliary Landing Field', 'KNRC', '06099', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (248, 'us', 'California', 'Cuddleback Gunnery Range', 'K4CB', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (249, 'us', 'California', 'Daggett, Barstow-Daggett Airport', 'KDAG', '06071', 'keyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (250, 'us', 'California', 'Dana Point', 'K9L0', '06059', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (251, 'us', 'California', 'Davis Point Aviation Weather Reporting Station', 'K52Q', '06113', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (252, 'us', 'California', 'Edwards Air Force Base', 'KEDW', '06029', 'keyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (253, 'us', 'California', 'El Capitan Beach', 'KL98', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (254, 'us', 'California', 'El Centro, Naval Air Facility', 'KNJK', '06013', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (255, 'us', 'California', 'El Monte', 'KEMT', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (256, 'us', 'California', 'Emigrant Gap, Blue Canyon Nyack Airport', 'KBLU', '06061', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (257, 'us', 'California', 'Eureka', 'KEKA', '06023', 'kbhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (258, 'us', 'California', 'Eureka NEXRAD', 'KBHX', '06023', 'kbhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (259, 'us', 'California', 'Fairfield / Travis Air Force Base', 'KSUU', '06095', 'kdax', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (260, 'us', 'California', 'Farallon Island', 'K50Q', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (261, 'us', 'California', 'Fort Bragg', 'KO64', '06093', 'kbhx', 'kbhx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (262, 'us', 'California', 'Fresno, Fresno Air Terminal', 'KFAT', '06019', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (263, 'us', 'California', 'Fresno-Chandler', 'KFCH', '06019', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (264, 'us', 'California', 'Fullerton, Fullerton Municipal Airport', 'KFUL', '06059', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (265, 'us', 'California', 'George Air Force Base / Victorvi', 'KVCV', '06017', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (266, 'us', 'California', 'Golden Gate Bridge', 'KGGB', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (267, 'us', 'California', 'Hamilton U. S. Army Airfield', 'KSRF', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (268, 'us', 'California', 'Hanford, Hanford Municipal Airport', 'KO18', '06031', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (269, 'us', 'California', 'Hawthorne, Hawthorne Municipal Airport', 'KHHR', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (270, 'us', 'California', 'Hayward, Hayward Air Terminal', 'KHWD', '06001', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (271, 'us', 'California', 'Hermosa Beach Pier', 'K4L7', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (272, 'us', 'California', 'Huntington B. Oil', 'K2H1', '06037', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (273, 'us', 'California', 'Huntington Beach', 'K6L9', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (274, 'us', 'California', 'Imperial Beach, Naval Auxiliary Landing Field', 'KNRS', '06025', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (275, 'us', 'California', 'Imperial, Imperial County Airport', 'KIPL', '06025', 'kyux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (276, 'us', 'California', 'Inyokern', 'KIYK', '06029', 'keyx', 'khnx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (277, 'us', 'California', 'La Verne / Brackett', 'KPOC', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (278, 'us', 'California', 'lancaster, general william j. fox airfield airport', 'KWJF', '06037', 'keyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (279, 'us', 'California', 'Lemoore, Naval Air Station', 'KNLC', '06031', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (280, 'us', 'California', 'Livermore, Livermore Municipal Airport', 'KLVK', '06001', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (281, 'us', 'California', 'Lompoc Automatic Weather Observing / Reporting System', 'KLPC', '06083', 'kvbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (282, 'us', 'California', 'Long Beach', 'K5L8', '06037', 'ksox', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (283, 'us', 'California', 'Long Beach, Long Beach Airport', 'KLGB', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (284, 'us', 'California', 'Los Alamitos U. S. Army Airfield', 'KSLI', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (285, 'us', 'California', 'Los Angeles / USC Campus Downtown', 'KCQT', '06037', 'ksox', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (286, 'us', 'California', 'Los Angeles Nexrad', 'KVTX', '06037', 'ksox', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (287, 'us', 'California', 'Los Angeles, Los Angeles International Airport', 'KLAX', '06037', 'ksox', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (288, 'us', 'California', 'Madera, Madera Municipal Airport', 'KMAE', '06039', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (289, 'us', 'California', 'Malibu Beach', 'KL55', '06037', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (290, 'us', 'California', 'Mammoth / June Lakes', 'KMMH', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (291, 'us', 'California', 'Marina Del Rey', 'K2L6', '06053', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (292, 'us', 'California', 'Marysville, Yuba County Airport', 'KMYV', '06115', 'kbbx', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (293, 'us', 'California', 'Mather Field', 'KMHR', '06067', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (294, 'us', 'California', 'McClellan Air Force Base', 'KMCC', '', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (295, 'us', 'California', 'Merced / Castle Air Force Base', 'KMER', '06047', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (296, 'us', 'California', 'Merced, Merced Municipal Airport', 'KMCE', '06047', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (297, 'us', 'California', 'Mission Beach', 'KL58', '06059', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (298, 'us', 'California', 'Modesto, Modesto City-County-Sham Field', 'KMOD', '06099', 'kmux', 'kmux', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (299, 'us', 'California', 'Mojave', 'KMHV', '06029', 'keyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (300, 'us', 'California', 'Montague', 'K1O5', '06081', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (301, 'us', 'California', 'Montague / Siskiyou', 'KSIY', '06081', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (302, 'us', 'California', 'Monterey NEXRAD', 'KMUX', '06053', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (303, 'us', 'California', 'Monterey, Monterey Peninsula Airport', 'KMRY', '06053', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (304, 'us', 'California', 'Mount Shasta', 'KMHS', '06085', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (305, 'us', 'California', 'Mount Wilson', 'KMWS', '06085', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (306, 'us', 'California', 'Mountain View, Moffett Field', 'KNUQ', '06085', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (307, 'us', 'California', 'Napa, Napa County Airport', 'KAPC', '', 'kdax', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (308, 'us', 'California', 'Needles Airport', 'KEED', '06071', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (309, 'us', 'California', 'Newport Beach', 'K3L3', '06059', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (310, 'us', 'California', 'Norton Air Force Base / San Bern', 'KSBD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (311, 'us', 'California', 'Oakland, Metro Oakland International Airport', 'KOAK', '06001', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (312, 'us', 'California', 'Oceanside Harbor', 'KL34', '06073', 'kvtx', 'knkx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (313, 'us', 'California', 'Oceanside, Camp Pendleton, Marine Corps Air Station', 'KNFG', '06073', 'kvtx', 'knkx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (314, 'us', 'California', 'Oceanside, Oceanside Municipal Airport', 'KOKH', '06073', 'kvtx', 'knkx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (315, 'us', 'California', 'Ontario, Ontario International Airport', 'KONT', '06071', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (316, 'us', 'California', 'Oroville, Oroville Municipal Airport', 'KOVE', '06007', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (317, 'us', 'California', 'Oxnard / Channel Island', 'KL79', '06111', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (318, 'us', 'California', 'Oxnard, Oxnard Airport', 'KOXR', '06111', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (319, 'us', 'California', 'Palm Springs, Palm Springs Regional Airport', 'KPSP', '06065', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (320, 'us', 'California', 'Palm Springs, Thermal Airport', 'KTRM', '06065', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (321, 'us', 'California', 'Palmdale, Palmdale Production Flight Plant', 'KPMD', '06037', 'kvtx', 'keyx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (322, 'us', 'California', 'Palo Alto Airport', 'KPAO', '06025', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (323, 'us', 'California', 'Paso Robles, Paso Robles Municipal Airport', 'KPRB', '06079', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (324, 'us', 'California', 'Pigeon Point Coast Guard Light Station', 'K93Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (325, 'us', 'California', 'Pillar Pt / El Granda', 'K53Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (326, 'us', 'California', 'Point Arena Coast Guard Light Station', 'K89Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (327, 'us', 'California', 'Point Blunt Coast Guard Light Station', 'K91Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (328, 'us', 'California', 'Point Bonita Coast Guard Light Station', 'K94Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (329, 'us', 'California', 'Point Cabrillo', 'KO72', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (330, 'us', 'California', 'Point Loma / Cabrillo', 'KL13', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (331, 'us', 'California', 'Point Mugu, Naval Air Warfare Center', 'KNTD', '', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (332, 'us', 'California', 'Point Piedras Blanca', 'K87Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (333, 'us', 'California', 'Point Pinos Coast Guard Light Station', 'K95Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (334, 'us', 'California', 'Point Reyes Coast Guard Station', 'K97Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (335, 'us', 'California', 'Point Sur', 'KNNZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (336, 'us', 'California', 'Point Vincente', 'KL97', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (337, 'us', 'California', 'Port Chicago', 'K99Q', '06111', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (338, 'us', 'California', 'Porterville Automatic Weather Observing / Reporting System', 'KPTV', '06107', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (339, 'us', 'California', 'Ramona, Ramona Airport', 'KRNM', '06073', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (340, 'us', 'California', 'Red Bluff, Red Bluff Municipal Airport', 'KRBL', '06103', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (341, 'us', 'California', 'Redding, Redding Municipal Airport', 'KRDD', '06089', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (342, 'us', 'California', 'Rio Vista Coast Guard Light Station', 'K98Q', '06095', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (343, 'us', 'California', 'Riverside / March Air Force Base', 'KRIV', '06065', 'kvtx', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (344, 'us', 'California', 'Riverside, Riverside Municipal Airport', 'KRAL', '06065', 'kvtx', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (345, 'us', 'California', 'Sacramento Nexrad', 'KDAX', '06067', 'kdax', 'kbbx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (346, 'us', 'California', 'Sacramento, Sacramento Executive Airport', 'KSAC', '06067', 'kdax', 'kbbx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (347, 'us', 'California', 'Sacramento, Sacramento International Airport', 'KSMF', '06067', 'kdax', 'kbbx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (348, 'us', 'California', 'Salinas, Salinas Municipal Airport', 'KSNS', '06053', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (349, 'us', 'California', 'Samoa / Humboldt Bay', 'K88Q', '06023', 'kbhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (350, 'us', 'California', 'San Carlos Airport', 'KSQL', '06059', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (351, 'us', 'California', 'San Clemente', 'KL10', '06059', 'ksox', 'knkx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (352, 'us', 'California', 'San Clemente, Naval Auxiliary Landing Field', 'KNUC', '06059', 'kvtx', 'knkx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (353, 'us', 'California', 'San Diego / Gillespie', 'KSEE', '06037', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (354, 'us', 'California', 'San Diego, Brown Field Municipal Airport', 'KSDM', '06037', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (355, 'us', 'California', 'San Diego, Miramar, Naval Air Station', 'KNKX', '06037', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (356, 'us', 'California', 'San Diego, Montgomery Field', 'KMYF', '06037', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (357, 'us', 'California', 'San Diego, North Island, Naval Air Station', 'KNZY', '06037', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (358, 'us', 'California', 'San Diego, San Diego International-Lindbergh Field', 'KSAN', '06037', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (359, 'us', 'California', 'San Francisco Pbs', 'K51Q', '06081', 'kmux', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (360, 'us', 'California', 'San Francisco, San Francisco International Airport', 'KSFO', '06081', 'kmux', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (361, 'us', 'California', 'San Jose / Reid / Hillv', 'KRHV', '06059', 'kmux', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (362, 'us', 'California', 'San Jose, San Jose International Airport', 'KSJC', '06059', 'kmux', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (363, 'us', 'California', 'San Luis Obispo, San Luis Obispo County-Mc Chesney Field', 'KSBP', '06073', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (364, 'us', 'California', 'San Nicholas Island', 'KNSI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (365, 'us', 'California', 'Sandberg', 'KSDB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (366, 'us', 'California', 'Santa Ana, John Wayne Airport-Orange County Airport', 'KSNA', '06073', 'kvtx', 'ksox', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (367, 'us', 'California', 'Santa Barbara Harbor', 'KP44', '06073', 'kvtx', 'keyx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (368, 'us', 'California', 'Santa Barbara, Santa Barbara Municipal Airport', 'KSBA', '06073', 'kvtx', 'keyx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (369, 'us', 'California', 'Santa Catalina Island', 'KL27', '06073', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (370, 'us', 'California', 'Santa Cruz Harbor', 'K85Q', '06073', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (371, 'us', 'California', 'Santa Cruz Island', 'KSZN', '06073', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (372, 'us', 'California', 'Santa Maria, Santa Maria Public Airport', 'KSMX', '06073', 'kvbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (373, 'us', 'California', 'Santa Monica Pier', 'K1L2', '06073', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (374, 'us', 'California', 'Santa Monica, Santa Monica Municipal Airport', 'KSMO', '06073', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (375, 'us', 'California', 'Santa Rosa, Santa Rosa Sonoma County Airport', 'KSTS', '06073', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (376, 'us', 'California', 'Santa Ynez, Santa Ynez Airport', 'KIZA', '06073', 'kvbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (377, 'us', 'California', 'Scripps Pier / La Jol', 'KL21', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (378, 'us', 'California', 'Shelter Cove', 'KO87', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (379, 'us', 'California', 'Solana Beach', 'K2L7', '06095', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (380, 'us', 'California', 'South Lake Tahoe, Lake Tahoe Airport', 'KTVL', '06081', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (381, 'us', 'California', 'St George Reef Coast Guard Light Station', 'K86Q', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (382, 'us', 'California', 'Stockton, Stockton Metropolitan Airport', 'KSCK', '06077', 'kbbx', 'kdax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (383, 'us', 'California', 'Superior Valley Gunnery Range', 'K4SU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (384, 'us', 'California', 'Susanville Municipal', 'KSVE', '06035', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (385, 'us', 'California', 'Terminal Island', 'KL82', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (386, 'us', 'California', 'Torrance Municipal', 'KTOA', '06037', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (387, 'us', 'California', 'Treasure Island', 'K3O6', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (388, 'us', 'California', 'Trinidad Head Coast Guard Light Station', 'K96Q', '06105', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (389, 'us', 'California', 'Truckee-Tahoe', 'KTRK', '06057', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (390, 'us', 'California', 'Twenty-Nine Palms, Marine Corps Air-Ground Combat Center', 'KNXP', '06071', 'ksox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (391, 'us', 'California', 'Ukiah Municipal Automatic Weather Observing / Reporting System', 'KUKI', '06045', 'kbbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (392, 'us', 'California', 'Vacaville, Nut Tree Airport', 'KVCB', '06095', 'kdax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (393, 'us', 'California', 'Van Nuys, Van Nuys Airport', 'KVNY', '06037', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (394, 'us', 'California', 'Vandenberg Air Force Base', 'KVBG', '', 'kvbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (395, 'us', 'California', 'Vandenberg Range', 'KXVW', '', 'kvbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (396, 'us', 'California', 'Ventura Harbor', 'KP43', '06111', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (397, 'us', 'California', 'Visalia Municipal Automatic Weather Observing / Reporting System', 'KVIS', '06107', 'khnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (398, 'us', 'California', 'Watsonville, Watsonville Municipal Airport', 'KWVI', '06087', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (399, 'us', 'California', 'Zuma Beach', 'K0L3', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (400, 'us', 'Colorado', 'Air Force Academy', 'KAFF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (401, 'us', 'Colorado', 'Akron, Akron-Washington County Airport', 'KAKO', '08121', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (402, 'us', 'Colorado', 'Alamosa, San Luis Valley Regional Airport', 'KALS', '08003', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (403, 'us', 'Colorado', 'Aspen, Aspen-Pitkin County Airport', 'KASE', '08097', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (404, 'us', 'Colorado', 'Broomfield / Jeffco', 'KBJC', '08013', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (405, 'us', 'Colorado', 'Buckley Air National Guard Base / Denver', 'KBKF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (406, 'us', 'Colorado', 'Burlington, Carson County Airport', 'KITR', '08063', 'kgld', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (407, 'us', 'Colorado', 'Colorado Springs, City Of Colorado Springs Municipal Airport', 'KCOS', '08041', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (408, 'us', 'Colorado', 'Cortez, Cortez-Montezuma County Airport', 'KCEZ', '08083', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (409, 'us', 'Colorado', 'Craig, Craig-Moffat Airport', 'KCAG', '08081', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (410, 'us', 'Colorado', 'Denver / Stapleton International, Co.', 'KDNR', '08031', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (411, 'us', 'Colorado', 'Denver Nexrad', 'KFTG', '08031', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (412, 'us', 'Colorado', 'Denver, Centennial Airport', 'KAPA', '08031', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (413, 'us', 'Colorado', 'Denver, Denver International Airport', 'KDEN', '08031', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (414, 'us', 'Colorado', 'Durango Aviation Weather Reporting Station', 'K4V5', '08067', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (415, 'us', 'Colorado', 'Durango, Durango-La Plata County Airport', 'KDRO', '08067', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (416, 'us', 'Colorado', 'Eagle County Regional', 'KEGE', '08037', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (417, 'us', 'Colorado', 'Fort Carson', 'KFCS', '08087', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (418, 'us', 'Colorado', 'Fort Collins Automatic Weather Observing / Reporting System', 'KFNL', '08087', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (419, 'us', 'Colorado', 'Fort Collins Supplementary Aviation Weather Reporting Station', 'KFCL', '08087', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (420, 'us', 'Colorado', 'Grand Junction, Walker Field', 'KGJT', '08049', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (421, 'us', 'Colorado', 'Greeley / Weld Automatic Weather Observing / Reporting System', 'KGXY', '08123', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (422, 'us', 'Colorado', 'Gunnison Automatic Weather Observing / Reporting System', 'KGUC', '08051', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (423, 'us', 'Colorado', 'Gunnison Aviation Weather Reporting Station', 'K2V9', '08051', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (424, 'us', 'Colorado', 'Hayden / Yampa Automatic Weather Observing / Reporting System', 'KHDN', '08107', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (425, 'us', 'Colorado', 'La Junta, La Junta Municipal Airport', 'KLHX', '08089', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (426, 'us', 'Colorado', 'Lamar, Lamar Municipal Airport', 'KLAA', '08099', 'kpux', '', 'kgld')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (427, 'us', 'Colorado', 'Leadville, Lake County Airport', 'KLXV', '08065', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (428, 'us', 'Colorado', 'Limon, Limon Municipal Airport', 'KLIC', '08073', 'kftg', '', 'kgld')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (429, 'us', 'Colorado', 'Meeker, Meeker Airport', 'KEEO', '08103', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (430, 'us', 'Colorado', 'Montrose, Montrose Regional Airport', 'KMTJ', '08085', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (431, 'us', 'Colorado', 'Peterson Air Force Base', 'KPEF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (432, 'us', 'Colorado', 'Pueblo NEXRAD', 'KPUX', '08101', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (433, 'us', 'Colorado', 'Pueblo, Pueblo Memorial Airport', 'KPUB', '08101', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (434, 'us', 'Colorado', 'Rifle Aviation Weather Reporting Station', 'K1V1', '08045', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (435, 'us', 'Colorado', 'Rifle, Garfield County Regional Airport', 'KRIL', '08045', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (436, 'us', 'Colorado', 'Salida', 'KS29', '08015', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (437, 'us', 'Colorado', 'Springfield, Comanche National Grassland', 'KSPD', '08009', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (438, 'us', 'Colorado', 'Steamboat Springs', 'KSBS', '08107', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (439, 'us', 'Colorado', 'telluride, telluride regional airport', 'KTEX', '08113', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (440, 'us', 'Colorado', 'Trinidad / Animas Co.', 'KTAD', '08071', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (441, 'us', 'Colorado', 'Winter Park Resort', 'KC96', '08049', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (442, 'us', 'Connecticut', 'Bridgeport, Sikorsky Memorial Airport', 'KBDR', '09005', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (443, 'us', 'Connecticut', 'Danbury, Danbury Municipal Airport', 'KDXR', '09001', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (444, 'us', 'Connecticut', 'Faulkner Island Coast Guard Light Station', 'K30N', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (445, 'us', 'Connecticut', 'Groton / New London, Groton / New London Airport', 'KGON', '09011', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (446, 'us', 'Connecticut', 'Hartford, Hartford-Brainard Airport', 'KHFD', '09003', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (447, 'us', 'Connecticut', 'Little Gulf Island Light Station', 'K32N', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (448, 'us', 'Connecticut', 'Meriden, Meriden Markham Municipal Airport', 'KMMK', '09009', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (449, 'us', 'Connecticut', 'New Haven Coast Guard Station', 'KN11', '09009', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (450, 'us', 'Connecticut', 'New Haven, Tweed-New Haven Airport', 'KHVN', '09009', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (451, 'us', 'Connecticut', 'New London Ledge Coast Guard Station', 'K18N', '09011', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (452, 'us', 'Connecticut', 'Oxford Automatic Weather Observing / Reporting System', 'KOXC', '09009', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (453, 'us', 'Connecticut', 'Willimantic, Windham Airport', 'KIJD', '09013', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (454, 'us', 'Connecticut', 'Windsor Locks, Bradley International Airport', 'KBDL', '09003', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (455, 'us', 'Delaware', 'Dover Air Force Base', 'KDOV', '10001', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (456, 'us', 'Delaware', 'Georgetown, Sussex County Airport', 'KGED', '10005', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (457, 'us', 'Delaware', 'Indian River Coast Guard Station', 'K61N', '', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (458, 'us', 'Delaware', 'Wilmington, New Castle County Airport', 'KILG', '10003', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (459, 'us', 'Florida', 'Apalachicola, Apalachicola', 'KAQQ', '12037', 'ktlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (460, 'us', 'Florida', 'Astor, Bombing Range Detachment Astor', 'KNAE', '12069', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (461, 'us', 'Florida', 'Avon Park Gunnery Range', 'KAGR', '12055', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (462, 'us', 'Florida', 'Bartow Municipal', 'KBOW', '12105', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (463, 'us', 'Florida', 'Brooksville, Hernando County Airport', 'KBKV', '12053', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (464, 'us', 'Florida', 'Cape Kennedy', 'KXMR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (465, 'us', 'Florida', 'Cape San Blas Coast Guard Station', 'K1J4', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (466, 'us', 'Florida', 'Cecil, Naval Air Station', 'KNZC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (467, 'us', 'Florida', 'Clewiston', 'KX53', '12051', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (468, 'us', 'Florida', 'Cocoa / Patrick Air Force Base', 'KCOF', '12009', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (469, 'us', 'Florida', 'Crestview, Sikes Airport', 'KCEW', '12091', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (470, 'us', 'Florida', 'Cross City, Cross City Airport', 'KCTY', '12029', 'kvax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (471, 'us', 'Florida', 'Daytona Beach, Daytona Beach Regional Airport', 'KDAB', '12127', 'kvax', 'kmlb', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (472, 'us', 'Florida', 'Destin, Destin-Ft. Walton Beach Airport', 'KDTS', '12091', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (473, 'us', 'Florida', 'Duke Field / Eglin Auxiliary', 'KEGI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (474, 'us', 'Florida', 'Egmont Key Coast Guard Station', 'KX91', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (475, 'us', 'Florida', 'Fort Lauderdale, Fort Lauderdale / Hollywood International Airport', 'KFLL', '12023', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (477, 'us', 'Florida', 'Fort Myers, Page Field', 'KFMY', '12023', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (478, 'us', 'Florida', 'Fort Myers, Southwest Florida International Airport', 'KRSW', '12023', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (479, 'us', 'Florida', 'Fort Pierce Coast Guard Station', 'KX82', '12023', 'kmlb', 'kamx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (480, 'us', 'Florida', 'Fort Pierce, St. Lucie County International Airport', 'KFPR', '12023', 'kmlb', 'kamx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (481, 'us', 'Florida', 'Fowey Rocks Coast Guard Station', 'KX86', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (482, 'us', 'Florida', 'Ft. Myers Beach Coast Guard Station', 'KX89', '', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (483, 'us', 'Florida', 'Gainesville, Gainesville Regional Airport', 'KGNV', '12001', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (484, 'us', 'Florida', 'Hollywood, North Perry Airport', 'KHWO', '12011', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (485, 'us', 'Florida', 'Homestead Air Force Base', 'KHST', '12025', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (486, 'us', 'Florida', 'Hurlburt Field', 'KHRT', '12091', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (487, 'us', 'Florida', 'Islamorada Coast Guard Station', 'KX84', '12087', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (488, 'us', 'Florida', 'Jacksonville, Craig Municipal Airport', 'KCRG', '12109', 'kjax', 'kvax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (489, 'us', 'Florida', 'Jacksonville, Jacksonville International Airport', 'KJAX', '12109', 'kjax', 'kvax', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (490, 'us', 'Florida', 'Jacksonville, Naval Air Station', 'KNIP', '12109', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (491, 'us', 'Florida', 'Jupiter Inlet Coast Guard Station', 'KX80', '12099', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (492, 'us', 'Florida', 'Key West, Key West International Airport', 'KEYW', '12087', 'kbyx', 'kamx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (493, 'us', 'Florida', 'Key West, Naval Air Station', 'KNQX', '12087', 'kbyx', 'kamx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (494, 'us', 'Florida', 'Lake Worth Inlet', 'KX81', '12099', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (495, 'us', 'Florida', 'Lakeland Regional', 'KLAL', '12105', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (496, 'us', 'Florida', 'Leesburg, Leesburg Municipal Airport', 'KLEE', '12069', 'kvax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (497, 'us', 'Florida', 'Macdill Air Force Base, Fl.', 'KMCF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (498, 'us', 'Florida', 'Marathon Coast Guard Station', 'KX88', '12087', 'kbyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (499, 'us', 'Florida', 'Marathon, Marathon Airport', 'KMTH', '12087', 'kbyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (500, 'us', 'Florida', 'Marianna, Marianna Municipal Airport', 'KMAI', '12063', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (501, 'us', 'Florida', 'Mayport, Naval Air Facility', 'KNRB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (502, 'us', 'Florida', 'Melbourne, Melbourne International Airport', 'KMLB', '12009', 'kmlb', 'ktbw', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (503, 'us', 'Florida', 'Miami Beach Coast Guard Station', 'KX87', '12086', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (504, 'us', 'Florida', 'Miami Nexrad', 'KAMX', '12086', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (505, 'us', 'Florida', 'Miami, Kendall-Tamiami Executive Airport', 'KTMB', '12086', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (506, 'us', 'Florida', 'Miami, Miami International Airport', 'KMIA', '12086', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (507, 'us', 'Florida', 'Miami, Opa Locka Airport', 'KOPF', '12086', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (508, 'us', 'Florida', 'Milton, Choctaw Pensacola, Naval Auxiliary Landing Field', 'KNFJ', '12113', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (509, 'us', 'Florida', 'Milton, Whiting Field North', 'KNSE', '12113', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (510, 'us', 'Florida', 'Milton, Whiting Field South', 'KNDZ', '12113', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (511, 'us', 'Florida', 'NASA Shuttle Facility', 'KTTS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (512, 'us', 'Florida', 'Naples Municipal', 'KAPF', '12021', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (513, 'us', 'Florida', 'New Port Richey, Tampa Bay Executive Airport', 'KRRF', '12101', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (514, 'us', 'Florida', 'Ocala Municipal Automatic Weather Observing / Reporting System', 'KOCF', '12083', 'kjax', 'ktbw', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (515, 'us', 'Florida', 'Orlando / Sanford Airport', 'KSFB', '12009', 'kmlb', 'kmlb', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (516, 'us', 'Florida', 'Orlando, Orlando Executive Airport', 'KORL', '12009', 'kmlb', 'kmlb', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (517, 'us', 'Florida', 'Orlando, Orlando International Airport', 'KMCO', '12009', 'kmlb', 'kmlb', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (518, 'us', 'Florida', 'Panama City, Panama City-Bay County International Airport', 'KPFN', '12005', 'kevx', 'ktlh', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (519, 'us', 'Florida', 'Pensacola, Naval Air Station', 'KNPA', '12033', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (520, 'us', 'Florida', 'Pensacola, Pensacola Regional Airport', 'KPNS', '12033', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (521, 'us', 'Florida', 'Perry-Foley, Perry-Foley Airport', 'K40J', '12123', 'ktlh', 'ktlh', 'kvax')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (522, 'us', 'Florida', 'Pompano Beach, Pompano Beach Airpark', 'KPMP', '12011', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (523, 'us', 'Florida', 'Ponce De Leon Inlet', 'K1J3', '12127', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (524, 'us', 'Florida', 'Punta Gorda, Charlotte County Airport', 'KPGD', '12015', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (525, 'us', 'Florida', 'Santa Rosa Coast Guard Station', 'K1J5', '12113', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (526, 'us', 'Florida', 'Sarasota / Bradenton, Sarasota-Bradenton International Airport', 'KSRQ', '12115', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (527, 'us', 'Florida', 'St. Augustine, St. Augustine Airport', 'KSGJ', '12109', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (528, 'us', 'Florida', 'St. Petersburg / Clearwater, St. Petersburg / Clearwater International Airport', 'KPIE', '12103', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (529, 'us', 'Florida', 'St. Petersburg, Whitted Airport', 'KSPG', '12103', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (530, 'us', 'Florida', 'Tallahassee, Tallahassee Regional Airport', 'KTLH', '12129', 'ktlh', 'ktlh', 'kvax')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (531, 'us', 'Florida', 'Tampa Bay Area', 'KTBW', '12057', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (532, 'us', 'Florida', 'Tampa, Tampa International Airport', 'KTPA', '12057', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (533, 'us', 'Florida', 'Titusville', 'KTIX', '12009', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (534, 'us', 'Florida', 'Tyndall Air Force Base', 'KPAM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (535, 'us', 'Florida', 'Valparaiso / Eglin Air Force Base', 'KVPS', '12091', 'kevx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (536, 'us', 'Florida', 'Venice Long Range Navigation', 'KX90', '12115', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (537, 'us', 'Florida', 'Vero Beach, Vero Beach Municipal Airport', 'KVRB', '12061', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (538, 'us', 'Florida', 'West Palm Beach, Palm Beach International Airport', 'KPBI', '12099', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (539, 'us', 'Florida', 'Winter Haven, Winter Havens Gilbert Airport', 'KGIF', '12117', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (540, 'us', 'Georgia', 'Albany, Southwest Georgia Regional Airport', 'KABY', '13095', 'keox', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (541, 'us', 'Georgia', 'Alma, Bacon County Airport', 'KAMG', '', 'kvax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (542, 'us', 'Georgia', 'Athens, Athens Airport', 'KAHN', '13059', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (543, 'us', 'Georgia', 'Atlanta, De Kalb-Peachtree Airport', 'KPDK', '13089', 'kffc', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (544, 'us', 'Georgia', 'Atlanta, Fulton County Airport-Brown Field', 'KFTY', '13089', 'kffc', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (545, 'us', 'Georgia', 'Atlanta, Hartsfield Atlanta International Airport', 'KATL', '13089', 'kffc', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (546, 'us', 'Georgia', 'Atlanta, Peachtree City-Falcon Field', 'KFFC', '13089', 'kffc', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (547, 'us', 'Georgia', 'Augusta, Bush Field', 'KAGS', '13245', 'kcae', 'kjgx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (548, 'us', 'Georgia', 'Augusta, Daniel Field', 'KDNL', '13245', 'kcae', 'kjgx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (549, 'us', 'Georgia', 'Brunswick / Glynco', 'KBQK', '13127', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (550, 'us', 'Georgia', 'Brunswick, Malcolm McKinnon Airport', 'KSSI', '13127', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (551, 'us', 'Georgia', 'Cartersville, Cartersville Airport', 'KVPC', '13015', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (552, 'us', 'Georgia', 'Columbus, Columbus Metropolitan Airport', 'KCSG', '13215', 'kmxx', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (553, 'us', 'Georgia', 'Dalton, Dalton Municipal Airport', 'KDNN', '13313', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (554, 'us', 'Georgia', 'Fort Benning', 'KLSF', '13225', 'kmxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (555, 'us', 'Georgia', 'Ft. Stewart', 'KLHW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (556, 'us', 'Georgia', 'Gainesville, Gilmer Memorial Airport', 'KGVL', '13139', 'kffc', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (557, 'us', 'Georgia', 'Hunter U. S. Army Airfield', 'KSVN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (558, 'us', 'Georgia', 'Kings Bay, Naval Station', 'KNBQ', '13015', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (559, 'us', 'Georgia', 'Macon, Middle Georgia Regional Airport', 'KMCN', '13021', 'kjgx', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (560, 'us', 'Georgia', 'Marietta / Dobbins Air Force Base', 'KMGE', '13067', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (561, 'us', 'Georgia', 'Moody Air Force Base', 'KVAD', '', 'kvax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (562, 'us', 'Georgia', 'Newnan, Newnan Coweta County Airport', 'KCCO', '13077', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (563, 'us', 'Georgia', 'Plains / Peterson Field', 'K7A9', '13129', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (564, 'us', 'Georgia', 'Rome, R. B. Russell Airport', 'KRMG', '', 'khtx', 'kffc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (565, 'us', 'Georgia', 'Saint Simon Island Coast Guard Station', 'K1J1', '13127', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (566, 'us', 'Georgia', 'Savannah, Savannah International Airport', 'KSAV', '13051', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (567, 'us', 'Georgia', 'Tybee Coast Guard Station', 'K1J2', '13051', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (568, 'us', 'Georgia', 'Valdosta Regional', 'KVLD', '13185', 'kvax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (569, 'us', 'Georgia', 'Vidalia, Vidalia Municipal Airport', 'KVDI', '13279', 'kjgx', 'kjgx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (570, 'us', 'Georgia', 'Warner Robins Air Force Base', 'KWRB', '13153', 'kjgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (571, 'us', 'Georgia', 'Waycross / Ware County, Ga', 'KAYS', '13299', 'kvax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (572, 'us', 'Hawaii', 'Bradshaw Army Air Field / Hawaii', 'PHSF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (573, 'us', 'Hawaii', 'Hickam Air Force Base / Oahu', 'PHIK', '', 'phki', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (574, 'us', 'Hawaii', 'Hilo, Hilo International Airport', 'PHTO', '', 'phkm', 'phwa', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (575, 'us', 'Hawaii', 'Honolulu, Honolulu International Airport', 'PHNL', '15003', 'phmo', 'phmo', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (576, 'us', 'Hawaii', 'Kahului, Kahului Airport', 'PHOG', '15009', 'phmo', 'phmo', 'phwa')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (577, 'us', 'Hawaii', 'Kailua / Kona, Keahole Airport', 'PHKO', '15003', 'phmo', 'phmo', 'phwa')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (578, 'us', 'Hawaii', 'Kaneohe, Marine Corps Air Station', 'PHNG', '15003', 'phmo', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (579, 'us', 'Hawaii', 'Kaunakakai, Molokai Airport', 'KMKK', '15009', 'phmo', 'phmo', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (580, 'us', 'Hawaii', 'Kekaha, Pacific Missile Test Facility Barking Sands', 'PHBK', '15007', 'phki', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (581, 'us', 'Hawaii', 'Lahaina / West Maui', 'PHJH', '15009', 'phmo', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (582, 'us', 'Hawaii', 'Lanai City Airport', 'PHNY', '15009', 'phmo', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (583, 'us', 'Hawaii', 'Lihue, Lihue Airport', 'PHLI', '15007', 'phki', 'phmo', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (584, 'us', 'Hawaii', 'Midway Island Naval Air Facility', 'PMDY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (585, 'us', 'Hawaii', 'Molokai Automatic Meteorological Observing System', 'PHMK', '', 'phkm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (586, 'us', 'Hawaii', 'Oahu, Kalaeloa Airport', 'PHJR', '', 'phki', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (587, 'us', 'Hawaii', 'South Kona / Hawaii', 'PHWH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (588, 'us', 'Hawaii', 'Waimea-Kohala Airport', 'PHMU', '15007', 'phki', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (589, 'us', 'Hawaii', 'Wheeler Air Force Base / Oahu', 'PHHI', '15003', 'phki', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (590, 'us', 'Indiana', 'Anderson Municipal', 'KAID', '18095', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (591, 'us', 'Indiana', 'Bloomington, Monroe County Airport', 'KBMG', '18105', 'kind', 'klvx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (592, 'us', 'Indiana', 'Columbus / Balkalar', 'KBAK', '18005', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (593, 'us', 'Indiana', 'Elkhart Municipal', 'KEKM', '18039', 'kiwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (594, 'us', 'Indiana', 'Evansville, Evansville Regional Airport', 'KEVV', '18163', 'khpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (595, 'us', 'Indiana', 'Fort Wayne, Fort Wayne International Airport', 'KFWA', '18003', 'kiwx', 'kind', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (596, 'us', 'Indiana', 'Gary Regional', 'KGYY', '18089', 'klot', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (597, 'us', 'Indiana', 'Goshen, Goshen Municipal Airport', 'KGSH', '18039', 'kiwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (598, 'us', 'Indiana', 'Grissom Air Force Base / Peru', 'KGUS', '18103', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (599, 'us', 'Indiana', 'Huntingburg', 'KHNB', '18069', 'klvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (600, 'us', 'Indiana', 'Indianapolis, Eagle Creek Airpark', 'KEYE', '18097', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (601, 'us', 'Indiana', 'Indianapolis, Indianapolis International Airport', 'KIND', '18097', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (602, 'us', 'Indiana', 'Kokomo Automatic Weather Observing / Reporting System', 'KOKK', '18067', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (603, 'us', 'Indiana', 'Lafayette, Purdue University Airport', 'KLAF', '18157', 'kind', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (604, 'us', 'Indiana', 'Michigan City Coast Guard Station', 'K18C', '18023', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (605, 'us', 'Indiana', 'Muncie, Delaware County-Johnson Field', 'KMIE', '18035', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (606, 'us', 'Indiana', 'Shelbyville, Shelbyville Municipal Airport', 'KGEZ', '18089', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (607, 'us', 'Indiana', 'South Bend, Michiana Regional Airport', 'KSBN', '18183', 'kiwx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (608, 'us', 'Indiana', 'Terre Haute, Terre Haute International Airport - Hulman Field', 'KHUF', '18167', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (610, 'us', 'Idaho', 'Boise, Boise Air Terminal', 'KBOI', '16001', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (611, 'us', 'Idaho', 'Burley, Burley Municipal Airport', 'KBYI', '16031', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (612, 'us', 'Idaho', 'Caldwell Automatic Weather Observing / Reporting System', 'KEUL', '16027', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (613, 'us', 'Idaho', 'Challis, Challis Airport', 'KU15', '16037', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (614, 'us', 'Idaho', 'Coeur D\'Alene Automatic Weather Observing / Reporting System', 'KCOE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (615, 'us', 'Idaho', 'Grangeville', 'KS80', '16049', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (616, 'us', 'Idaho', 'Hailey / Friedman Memorial', 'KSUN', '16013', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (617, 'us', 'Idaho', 'Idaho Falls, Fanning Field', 'KIDA', '16019', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (618, 'us', 'Idaho', 'Jerome, Jerome County Airport', 'KU73', '16053', 'ksfx', 'ksfx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (619, 'us', 'Idaho', 'Lewiston, Lewiston-Nez Perce County Airport', 'KLWS', '16051', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (620, 'us', 'Idaho', 'Lowell', 'KP69', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (621, 'us', 'Idaho', 'Malad City', 'KMLD', '16071', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (622, 'us', 'Idaho', 'Malta', 'K77M', '16031', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (623, 'us', 'Idaho', 'McCall, McCall Airport', 'KMYL', '', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (624, 'us', 'Idaho', 'Mountain Home Air Force Base', 'KMUO', '16039', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (625, 'us', 'Idaho', 'Mullan Aviation Weather Reporting Station', 'KS06', '16079', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (626, 'us', 'Idaho', 'Mullan Pass, Mullan Pass Vor', 'KMLP', '16079', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (627, 'us', 'Idaho', 'Pocatello, Pocatello Regional Airport', 'KPIH', '16005', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (628, 'us', 'Idaho', 'Rexburg, Rexburg-Madison County Airport', 'KRXE', '16065', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (629, 'us', 'Idaho', 'Salmon', 'K27U', '16059', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (630, 'us', 'Idaho', 'Salmon / Lemhi Automatic Weather Observing / Reporting System', 'KSMN', '16059', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (631, 'us', 'Idaho', 'Soda Springs / Tigert', 'KU78', '16029', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (632, 'us', 'Idaho', 'Spencer', 'KS14', '16033', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (633, 'us', 'Idaho', 'Stanley', 'KSNT', '16037', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (634, 'us', 'Idaho', 'Stanley, Stanley Ranger Station', 'K2U7', '16037', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (635, 'us', 'Idaho', 'Strevell', 'K4SV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (636, 'us', 'Idaho', 'Twin Falls, Joslin Field-Magic Valley Regional Airport', 'KTWF', '16083', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (637, 'us', 'Illinois', 'Alton / St. Louis Regional', 'KALN', '17119', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (638, 'us', 'Illinois', 'Aurora, Aurora Municipal Airport', 'KARR', '17043', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (639, 'us', 'Illinois', 'Bloomington / Normal', 'KBMI', '17113', 'kilx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (640, 'us', 'Illinois', 'Bradford / Rinkenberg', 'KBDF', '17175', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (641, 'us', 'Illinois', 'Cahokia / St. Louis, St. Louis Downtown-Parks Airport', 'KCPS', '17163', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (642, 'us', 'Illinois', 'Carbondale / Murphysboro, Southern Illinois Airport', 'KMDH', '17077', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (643, 'us', 'Illinois', 'Champaign / Urbana, University Of Illinois-Willard Airport', 'KCMI', '17019', 'kilx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (644, 'us', 'Illinois', 'Chicago / Calumet Coast Guard Station', 'K63G', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (645, 'us', 'Illinois', 'Chicago / Meigs', 'KCGX', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (646, 'us', 'Illinois', 'Chicago / Waukegan, Waukegan Regional Airport', 'KUGN', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (647, 'us', 'Illinois', 'Chicago / West Chicago, Dupage Airport', 'KDPA', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (648, 'us', 'Illinois', 'Chicago / Wheeling, Pal-Waukee Airport', 'KPWK', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (649, 'us', 'Illinois', 'Chicago Nexrad', 'KLOT', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (650, 'us', 'Illinois', 'Chicago Weather Service Forecast Office', 'KCHI', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (651, 'us', 'Illinois', 'Chicago, Chicago Midway Airport', 'KMDW', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (652, 'us', 'Illinois', 'Chicago, Chicago-OHare International Airport', 'KORD', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (653, 'us', 'Illinois', 'Danville, Vermilion County Airport', 'KDNV', '17183', 'kind', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (654, 'us', 'Illinois', 'Decatur, Decatur Airport', 'KDEC', '17115', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (655, 'us', 'Illinois', 'Dixon / Walgreen Field', 'KC73', '17103', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (656, 'us', 'Illinois', 'Joliet Park District', 'KJOT', '17197', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (657, 'us', 'Illinois', 'Lawrenceville, Lawrenceville-Vincennes International Airport', 'KLWV', '17101', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (658, 'us', 'Illinois', 'Marion Regional', 'KMWA', '17199', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (659, 'us', 'Illinois', 'Marseilles Island', 'KMMO', '17099', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (660, 'us', 'Illinois', 'Mattoon / Charleston, Coles County Memorial Airport', 'KMTO', '17029', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (661, 'us', 'Illinois', 'Moline, Quad-City Airport', 'KMLI', '17161', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (662, 'us', 'Illinois', 'Mount Vernon Automatic Weather Observing / Reporting System', 'KMVN', '17081', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (663, 'us', 'Illinois', 'Peoria, Greater Peoria Regional Airport', 'KPIA', '17143', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (664, 'us', 'Illinois', 'Quincy Municipal / Baldwin', 'KUIN', '17001', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (665, 'us', 'Illinois', 'Rockford, Greater Rockford Airport', 'KRFD', '17201', 'kmkx', 'kdvn', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (666, 'us', 'Illinois', 'Salem-Leckrone', 'KSLO', '17121', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (667, 'us', 'Illinois', 'Scott Air Force Base / Belleville', 'KBLV', '17117', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (668, 'us', 'Illinois', 'Springfield, Capital Airport', 'KSPI', '17167', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (669, 'us', 'Illinois', 'Sterling Rockfalls', 'KSQI', '17195', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (670, 'us', 'Illinois', 'Wilmette Marines', 'K62G', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (671, 'us', 'Iowa', 'Algona', 'KAXA', '19109', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (672, 'us', 'Iowa', 'Ames, Ames Municipal Airport', 'KAMW', '', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (673, 'us', 'Iowa', 'Ankeny, Ankeny Regional Airport', 'KIKV', '19153', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (674, 'us', 'Iowa', 'Atlantic', 'KAIO', '19029', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (675, 'us', 'Iowa', 'Audubon, Audubon County Airport', 'KADU', '19009', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (676, 'us', 'Iowa', 'Boone Municipal', 'KBNW', '19015', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (677, 'us', 'Iowa', 'Burlington, Burlington Regional Airport', 'KBRL', '19057', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (678, 'us', 'Iowa', 'Carroll', 'KCIN', '19027', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (679, 'us', 'Iowa', 'Cedar Rapids, Cedar Rapids Municipal Airport', 'KCID', '19123', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (680, 'us', 'Iowa', 'Chariton', 'KCNC', '19117', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (681, 'us', 'Iowa', 'Charles City', 'KCCY', '19045', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (682, 'us', 'Iowa', 'Clarinda', 'KICL', '19197', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (683, 'us', 'Iowa', 'Clarion', 'KCAV', '19197', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (684, 'us', 'Iowa', 'Clinton Municipal Automatic Weather Observing / Reporting System', 'KCWI', '19045', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (685, 'us', 'Iowa', 'Council Bluffs', 'KCBF', '19155', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (686, 'us', 'Iowa', 'Creston', 'KCSQ', '19175', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (687, 'us', 'Iowa', 'Davenport, Davenport Municipal Airport', 'KDVN', '19163', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (688, 'us', 'Iowa', 'Decorah', 'KDEH', '19191', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (689, 'us', 'Iowa', 'Denison', 'KDNS', '19047', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (690, 'us', 'Iowa', 'Des Moines Nexrad', 'KDMX', '19153', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (691, 'us', 'Iowa', 'Des Moines, Des Moines International Airport', 'KDSM', '19153', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (692, 'us', 'Iowa', 'Dubuque, Dubuque Regional Airport', 'KDBQ', '19061', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (693, 'us', 'Iowa', 'Estherville, Estherville Municipal Airport', 'KEST', '19063', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (694, 'us', 'Iowa', 'Fair Field', 'KFFL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (695, 'us', 'Iowa', 'Fort Dodge', 'KFOD', '19111', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (696, 'us', 'Iowa', 'Fort Madison', 'KFSW', '19111', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (697, 'us', 'Iowa', 'Iowa City, Iowa City Municipal Airport', 'KIOW', '19083', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (698, 'us', 'Iowa', 'Keokuk Municipal', 'KEOK', '19111', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (699, 'us', 'Iowa', 'Knoxville', 'KOXV', '19125', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (700, 'us', 'Iowa', 'Lamoni', 'K3OI', '19019', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (701, 'us', 'Iowa', 'Lamoni, Lamoni Municipal Airport', 'KLWD', '19019', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (702, 'us', 'Iowa', 'Le Marine Aviation Reporting Station', 'KLRJ', '19149', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (703, 'us', 'Iowa', 'Marshalltown, Marshalltown Municipal Airport', 'KMIW', '19127', 'kdmx', 'kdmx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (704, 'us', 'Iowa', 'Mason City, Mason City Municipal Airport', 'KMCW', '19055', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (705, 'us', 'Iowa', 'Monticello Municipal', 'KMXO', '19105', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (706, 'us', 'Iowa', 'Muscatine', 'KMUT', '19139', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (708, 'us', 'Iowa', 'Oelwen', 'KOLZ', '19065', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (709, 'us', 'Iowa', 'Orange City', 'KORC', '19167', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (710, 'us', 'Iowa', 'Ottumwa, Ottumwa Industrial Airport', 'KOTM', '19179', 'kdmx', 'kdmx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (711, 'us', 'Iowa', 'Red Oak', 'KRDK', '19137', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (713, 'us', 'Iowa', 'Shenandoah Municipal', 'KSDA', '19145', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (715, 'us', 'Iowa', 'Spencer', 'K3SE', '19041', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (718, 'us', 'Iowa', 'Washington', 'KAWG', '19183', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (719, 'us', 'Iowa', 'Waterloo, Waterloo Municipal Airport', 'KALO', '19005', 'kdmx', 'kdvn', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (720, 'us', 'Iowa', 'Webster City', 'KEBS', '19107', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (721, 'us', 'Kansas', 'Chanute, Chanute Martin Johnson Airport', 'KCNU', '20133', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (722, 'us', 'Kansas', 'Coffeyville, Coffeyville Municipal Airport', 'KCFV', '20125', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (723, 'us', 'Kansas', 'Concordia, Blosser Municipal Airport', 'KCNK', '20029', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (724, 'us', 'Kansas', 'Dodge City, Dodge City Regional Airport', 'KDDC', '20057', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (725, 'us', 'Kansas', 'Elkhart / Elkhart-Morton County Airport', 'K1K5', '20129', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (726, 'us', 'Kansas', 'Elkhart Automatic Weather Observing / Reporting System', 'KEHA', '20129', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (727, 'us', 'Kansas', 'Emporia, Emporia Municipal Airport', 'KEMP', '20111', 'ktwx', 'kict', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (728, 'us', 'Kansas', 'Fort Leavenworth', 'KFLV', '20011', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (729, 'us', 'Kansas', 'Fort Riley', 'KFRI', '20011', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (730, 'us', 'Kansas', 'Garden City, Garden City Regional Airport', 'KGCK', '20173', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (731, 'us', 'Kansas', 'Goodland, Renner Field', 'KGLD', '20181', 'kgld', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (732, 'us', 'Kansas', 'Great Bend Automatic Weather Observing / Reporting System', 'KGBD', '20009', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (733, 'us', 'Kansas', 'Hays Municipal Automatic Weather Observing / Reporting System', 'KHYS', '20051', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (734, 'us', 'Kansas', 'Hill City, Hill City Municipal Airport', 'KHLC', '20065', 'kgld', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (735, 'us', 'Kansas', 'Hutchinson, Hutchinson Municipal Airport', 'KHUT', '20155', 'kict', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (736, 'us', 'Kansas', 'Lawrence, Lawrence Municipal Airport', 'KLWC', '20045', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (737, 'us', 'Kansas', 'Liberal Municipal Automatic Weather Observing / Reporting System', 'KLBL', '20125', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (738, 'us', 'Kansas', 'Manhattan, Manhattan Municipal Airport', 'KMHK', '20161', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (739, 'us', 'Kansas', 'McConnell Air Force Base', 'KIAB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (740, 'us', 'Kansas', 'Medicine Lodge, Medicine Lodge', 'KP28', '20007', 'kvnx', 'kict', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (741, 'us', 'Kansas', 'Newton Automatic Weather Observing / Reporting System', 'KEWK', '20079', 'kict', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (742, 'us', 'Kansas', 'Olathe, Johnson County Executive Airport', 'KOJC', '20091', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (743, 'us', 'Kansas', 'Olathe, New Century Aircenter', 'KIXD', '20091', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (744, 'us', 'Kansas', 'Parsons, Tri-City Airport', 'KPPF', '20099', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (745, 'us', 'Kansas', 'Pratt Municipal', 'KPTT', '20151', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (746, 'us', 'Kansas', 'Russell, Russell Municipal Airport', 'KRSL', '20167', 'kddc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (749, 'us', 'Kansas', 'Topeka, Forbes Field', 'KFOE', '20177', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (751, 'us', 'Kansas', 'Wichita, Colonel James Jabara Airport', 'KAAO', '20173', 'kict', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (752, 'us', 'Kansas', 'Wichita, Wichita Mid-Continent Airport', 'KICT', '20173', 'kict', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (754, 'us', 'Kentucky', 'Bowling Green, Bowling Green-Warren County Regional Airport', 'KBWG', '21227', 'khpx', 'klvx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (755, 'us', 'Kentucky', 'Covington / Cincinnati, Cincinnati / Northern Kentucky International Airport', 'KCVG', '21117', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (756, 'us', 'Kentucky', 'Fort Campbell U. S. Army Airfield', 'KHOP', '21117', 'khpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (757, 'us', 'Kentucky', 'Fort Knox', 'KFTK', '21117', 'klvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (758, 'us', 'Kentucky', 'Frankfort, Capital City Airport', 'KFFT', '21213', 'klvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (759, 'us', 'Kentucky', 'Henderson City', 'KEHR', '21101', 'khpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (761, 'us', 'Kentucky', 'Lexington / Creech', 'KLSD', '21067', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (762, 'us', 'Kentucky', 'Lexington, Blue Grass Airport', 'KLEX', '21067', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (763, 'us', 'Kentucky', 'London, London-Corbin Airport-Magee Field', 'KLOZ', '21125', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (764, 'us', 'Kentucky', 'Louisville Nexrad', 'KLVX', '21111', 'klvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (765, 'us', 'Kentucky', 'Louisville, Bowman Field', 'KLOU', '21111', 'klvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (766, 'us', 'Kentucky', 'Louisville, Standiford Field', 'KSDF', '21111', 'klvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (767, 'us', 'Kentucky', 'Owensboro / Daviess', 'KOWB', '21059', 'klvx', 'klvx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (768, 'us', 'Kentucky', 'Paducah, Barkley Regional Airport', 'KPAH', '21145', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (769, 'us', 'Kentucky', 'Pikeville Remote Automatic Meteorological Observing System', 'K5I3', '21195', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (771, 'us', 'Louisiana', 'Alexandria, Alexandria Esler Regional Airport', 'KESF', '22079', 'kpoe', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (772, 'us', 'Louisiana', 'Alexandria, Alexandria International Airport', 'KAEX', '22079', 'kpoe', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (773, 'us', 'Louisiana', 'Amelia / Lake Palourd', 'K7R3', '22101', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (774, 'us', 'Louisiana', 'Barksdale Air Force Base', 'KBAD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (775, 'us', 'Louisiana', 'Baton Rouge, Baton Rouge Metropolitan, Ryan Field', 'KBTR', '22033', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (776, 'us', 'Louisiana', 'Boothville', 'KBVE', '22075', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (777, 'us', 'Louisiana', 'Boothville Heliport', 'K1B7', '22075', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (778, 'us', 'Louisiana', 'Butte La Rose', 'KBCG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (779, 'us', 'Louisiana', 'Calcasieu Coast Guard Station', 'K8R6', '22019', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (780, 'us', 'Louisiana', 'Cameron Heliport', 'K7R5', '22023', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (781, 'us', 'Louisiana', 'Chenault Airpark', 'KCWF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (782, 'us', 'Louisiana', 'Claiborne Range, Airways Facilities Sector', 'K01R', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (783, 'us', 'Louisiana', 'Eugene Island', 'KVUW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (784, 'us', 'Louisiana', 'Eugene Island 330', 'K3B6', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (785, 'us', 'Louisiana', 'Fort Polk', 'KPOE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (786, 'us', 'Louisiana', 'Fourchon Supplementary Aviation Weather Reporting Station', 'K9F2', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (787, 'us', 'Louisiana', 'Grand Isle B95', 'KP26', '22051', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (788, 'us', 'Louisiana', 'Grand Isle Coast Guard Station', 'K8R5', '22051', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (789, 'us', 'Louisiana', 'Grand Isle Supplementary Aviation Weather Reporting Station', 'KAXO', '22051', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (790, 'us', 'Louisiana', 'Green Canyon 184', 'KXCN', '22017', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (791, 'us', 'Louisiana', 'Grncyn Blk52 Supplementary Aviation Weather Reporting Station', 'K28K', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (792, 'us', 'Louisiana', 'High Island', 'K01T', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (793, 'us', 'Louisiana', 'High Island 264C', 'KH08', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (794, 'us', 'Louisiana', 'High Island A489b', 'KL40', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (795, 'us', 'Louisiana', 'High Island A572c', 'KH39', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (796, 'us', 'Louisiana', 'Houma-Terrebonne', 'KHUM', '22109', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (797, 'us', 'Louisiana', 'Intracoastal City', 'K7R4', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (798, 'us', 'Louisiana', 'Lafayette, Lafayette Regional Airport', 'KLFT', '22055', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (799, 'us', 'Louisiana', 'Lake Charles, Lake Charles Regional Airport', 'KLCH', '22035', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (800, 'us', 'Louisiana', 'Leeville', 'K7R2', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (801, 'us', 'Louisiana', 'Main Pass B68', 'KP21', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (802, 'us', 'Louisiana', 'Mississippi Canyon', 'K1G7', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (803, 'us', 'Louisiana', 'Monroe, Monroe Regional Airport', 'KMLU', '22073', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (804, 'us', 'Louisiana', 'New Iberia, Acadiana Regional Airport', 'KARA', '22045', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (805, 'us', 'Louisiana', 'New Orleans, Naval Air Station', 'KNBG', '22051', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (806, 'us', 'Louisiana', 'New Orleans, New Orleans International Airport', 'KMSY', '22051', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (807, 'us', 'Louisiana', 'New Orleans, New Orleans Lakefront Airport', 'KNEW', '22051', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (808, 'us', 'Louisiana', 'Patterson Memorial', 'KPTN', '22101', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (809, 'us', 'Louisiana', 'Salt Point', 'KP92', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (810, 'us', 'Louisiana', 'Ship Shoal 198g', 'KS65', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (811, 'us', 'Louisiana', 'Ship Shoal B224a', 'KS02', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (812, 'us', 'Louisiana', 'Ship Shoal Platform', 'K19R', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (813, 'us', 'Louisiana', 'Shreveport, Shreveport Downtown Airport', 'KDTN', '22017', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (814, 'us', 'Louisiana', 'Shreveport, Shreveport Regional Airport', 'KSHV', '22017', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (815, 'us', 'Louisiana', 'Slidell', 'KLIX', '22103', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (816, 'us', 'Louisiana', 'Slidell Radar Site', 'KSIL', '22103', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (817, 'us', 'Louisiana', 'Slidell, Slidell Airport', 'KASD', '22103', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (818, 'us', 'Louisiana', 'South Marsh 268A', 'KSRN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (819, 'us', 'Louisiana', 'South Marsh Island', 'K7R8', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (820, 'us', 'Louisiana', 'South Timbalier', 'KS58', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (821, 'us', 'Louisiana', 'Southwest Pass Coast Guard Station', 'K8R3', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (822, 'us', 'Louisiana', 'Tenneco Platform', 'KP00', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (823, 'us', 'Louisiana', 'Venice Heliport', 'K3V8', '22075', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (824, 'us', 'Louisiana', 'Venice, Venice Heliport', 'K7R1', '22075', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (825, 'us', 'Louisiana', 'Vermilion B131', 'KP22', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (826, 'us', 'Louisiana', 'Vermilion B215', 'KP25', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (827, 'us', 'Louisiana', 'Vermillion Area', 'KVRX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (828, 'us', 'Louisiana', 'Vicksburg, Vicksburg / Tallulah Regional Airport', 'KTVR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (829, 'us', 'Louisiana', 'West Cameron', 'KP30', '22073', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (830, 'us', 'Louisiana', 'West Cameron 587A', 'K7B5', '22073', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (831, 'us', 'Louisiana', 'West Cameron B522', 'KW76', '22073', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (832, 'us', 'Maine', 'Auburn-Lewiston', 'KLEW', '23001', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (833, 'us', 'Maine', 'Augusta, Augusta State Airport', 'KAUG', '23011', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (834, 'us', 'Maine', 'Bangor, Bangor International Airport', 'KBGR', '23019', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (835, 'us', 'Maine', 'Bar Harbor Automatic Weather Observing / Reporting System', 'KBHB', '23009', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (836, 'us', 'Maine', 'Bear Island Coast Guard Station', 'K9B5', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (837, 'us', 'Maine', 'Brunswick, Naval Air Station', 'KNHZ', '23005', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (838, 'us', 'Maine', 'Cape Neddick Coast Guard Light Station', 'K27B', '23031', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (839, 'us', 'Maine', 'Caribou, Caribou Municipal Airport', 'KCAR', '23003', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (840, 'us', 'Maine', 'Clayton Lake', 'K40B', '23003', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (841, 'us', 'Maine', 'Eastport', 'KEPO', '23029', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (842, 'us', 'Maine', 'Egg Rock Light Station', 'K8B9', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (843, 'us', 'Maine', 'Frenchville, Northern Aroostook Regional Airport', 'KFVE', '23003', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (844, 'us', 'Maine', 'Fryeburg, Eastern Slopes Regional Airport', 'KIZG', '23017', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (845, 'us', 'Maine', 'Goat Island Remote Automatic Meteorological Observing System', 'K0B9', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (846, 'us', 'Maine', 'Great Duck Island Coast Guard Light Station', 'K14B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (847, 'us', 'Maine', 'Greenville', 'KGNR', '23017', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (848, 'us', 'Maine', 'Greenville, Greenville Municipal Airport', 'K3B1', '23017', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (849, 'us', 'Maine', 'Halfway Rock Coast Guard Light Station', 'K15B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (850, 'us', 'Maine', 'Heron Neck Coast Guard Light Station', 'K16B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (851, 'us', 'Maine', 'Houlton, Houlton International Airport', 'KHUL', '23003', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (852, 'us', 'Maine', 'Loring Air Force Base / Limeston', 'KLIZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (853, 'us', 'Maine', 'Millinocket, Millinocket Municipal Airport', 'KMLT', '23019', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (854, 'us', 'Maine', 'Monhegan / Manana Island', 'K18B', '23015', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (855, 'us', 'Maine', 'Old Town / Dewitt Field', 'KOLD', '23019', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (856, 'us', 'Maine', 'Owls Head Light Station', 'K96B', '23013', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (857, 'us', 'Maine', 'Portland Head Coast Guard Light Station', 'K2B8', '23005', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (858, 'us', 'Maine', 'Portland, Portland International Jetport', 'KPWM', '23005', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (859, 'us', 'Maine', 'Presque Isle', 'KPQI', '23003', 'kcbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (860, 'us', 'Maine', 'Rockland / Knox Automatic Weather Observing / Reporting System', 'KRKD', '23013', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (861, 'us', 'Maine', 'Rockland Coast Guard Station', 'K20B', '23013', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (862, 'us', 'Maine', 'Rumford', 'KRUM', '23017', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (864, 'us', 'Maine', 'Seguin Island Coast Guard Light Station', 'K23B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (865, 'us', 'Maine', 'Southwest Harbor', 'KH32', '23009', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (867, 'us', 'Maine', 'West Jonesport Coast Guard Station', 'K20J', '23009', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (868, 'us', 'Maine', 'West Quoddy Head Coast Guard Light Station', 'K24B', '23009', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (869, 'us', 'Maine', 'Wiscasset, Wiscasset Airport', 'KIWI', '23015', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (870, 'us', 'Maine', 'Wood Island Light Station', 'K94B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (871, 'us', 'Maryland', 'Annapolis Coast Guard Station', 'K61W', '24003', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (872, 'us', 'Maryland', 'Annapolis, United States Naval Academy', 'KNAK', '24003', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (873, 'us', 'Maryland', 'Baltimore / DC Nexrad', 'KLWX', '24003', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (874, 'us', 'Maryland', 'Baltimore / Martin', 'KMTN', '24003', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (875, 'us', 'Maryland', 'Baltimore, Baltimore-Washington International Airport', 'KBWI', '24003', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (876, 'us', 'Maryland', 'Baltimore, Inner Harbor', 'KDMH', '24003', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (877, 'us', 'Maryland', 'Camp Springs / Andrews Air Force Base', 'KADW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (878, 'us', 'Maryland', 'Cove Point Coast Guard Light Station', 'K66W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (879, 'us', 'Maryland', 'Easton / Newman Field', 'KESN', '24041', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (880, 'us', 'Maryland', 'Fort Meade / Tipton', 'KFME', '24033', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (881, 'us', 'Maryland', 'Fort Ritchie', 'KJWX', '24033', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (882, 'us', 'Maryland', 'Hagerstown, Washington County Regional Airport', 'KHGR', '24043', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (883, 'us', 'Maryland', 'Ocean City', 'KW30', '24047', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (884, 'us', 'Maryland', 'Ocean City, Ocean City Municipal Airport', 'KOXB', '24047', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (885, 'us', 'Maryland', 'Patuxent River, Naval Air Station', 'KNHK', '24037', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (886, 'us', 'Maryland', 'Phillips Army Air Field / Aberdeen', 'KAPG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (887, 'us', 'Maryland', 'Salisbury, Salisbury-Wicomico County Regional Airport', 'KSBY', '24045', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (888, 'us', 'Maryland', 'St. Inigoes, Webster Field, Naval Electronic Systems Engineering Activity', 'KNUI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (889, 'us', 'Maryland', 'Stillpond Coast Guard Station', 'K67W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (890, 'us', 'Maryland', 'Thomas Point Coast Guard Station', 'K65W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (891, 'us', 'Massachusetts', 'Bedford, Hanscom Field', 'KBED', '25017', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (892, 'us', 'Massachusetts', 'Beverly, Beverly Municipal Airport', 'KBVY', '25009', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (893, 'us', 'Massachusetts', 'Boston / Hull Coast Guard Light Station', 'K29B', '25025', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (894, 'us', 'Massachusetts', 'Boston Nexrad', 'KBOS', '25025', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (895, 'us', 'Massachusetts', 'Boston, Logan International Airport', 'KBOS', '25025', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (896, 'us', 'Massachusetts', 'Brant Point Coast Guard Station', 'K45B', '25023', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (897, 'us', 'Massachusetts', 'Buzzards Bay Coast Guard Light Station', 'K33B', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (898, 'us', 'Massachusetts', 'Chatham', 'KCHH', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (899, 'us', 'Massachusetts', 'Chatham Coast Guard Station', 'K31B', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (900, 'us', 'Massachusetts', 'Chatham, Chatham Municipal Airport', 'KCQX', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (901, 'us', 'Massachusetts', 'Chicopee Falls / Westover Air Force Base', 'KCEF', '25013', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (902, 'us', 'Massachusetts', 'East Milton', 'KMQE', '25023', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (903, 'us', 'Massachusetts', 'Fitchburg, Fitchburg Municipal Airport', 'KFIT', '25027', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (904, 'us', 'Massachusetts', 'Fort Devens / Ayer', 'KAYE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (905, 'us', 'Massachusetts', 'Gloucester Coast Guard Station', 'K34B', '25009', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (906, 'us', 'Massachusetts', 'Hyannis, Barnstable Municipal-Boardman Airport', 'KHYA', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (907, 'us', 'Massachusetts', 'Lawrence, Lawrence Municipal Airport', 'KLWM', '25009', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (908, 'us', 'Massachusetts', 'Marshfield Airport', 'K3B2', '25023', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (909, 'us', 'Massachusetts', 'Merrimac River Coast Guard Station', 'K35B', '25009', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (910, 'us', 'Massachusetts', 'Nantucket, Nantucket Memorial Airport', 'KACK', '25019', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (911, 'us', 'Massachusetts', 'New Bedford, New Bedford Regional Airport', 'KEWB', '25027', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (912, 'us', 'Massachusetts', 'North Adams, Harriman-And-West Airport', 'KAQW', '25011', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (913, 'us', 'Massachusetts', 'Norwood, Norwood Memorial Airport', 'KOWD', '25021', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (914, 'us', 'Massachusetts', 'Orange, Orange Municipal Airport', 'KORE', '25011', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (915, 'us', 'Massachusetts', 'Otis Air National Guard Base', 'KFMH', '25003', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (916, 'us', 'Massachusetts', 'Pittsfield, Pittsfield Municipal Airport', 'KPSF', '25003', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (917, 'us', 'Massachusetts', 'Plymouth, Plymouth Municipal Airport', 'KPYM', '25023', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (918, 'us', 'Massachusetts', 'Provincetown Automatic Weather Observing / Reporting System', 'KPVC', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (919, 'us', 'Massachusetts', 'Race Point Coast Guard Station', 'K36B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (920, 'us', 'Massachusetts', 'Sandwich Coast Guard Station', 'K30B', '25001', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (921, 'us', 'Massachusetts', 'Scituate Coast Guard Station', 'K37B', '25023', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (922, 'us', 'Massachusetts', 'Taunton, Taunton Municipal Airport', 'KTAN', '25005', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (923, 'us', 'Massachusetts', 'Vineyard Haven, Marthas Vineyard Airport', 'KMVY', '25007', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (924, 'us', 'Massachusetts', 'Westfield, Barnes Municipal Airport', 'KBAF', '25017', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (925, 'us', 'Massachusetts', 'Worcester, Worcester Regional Airport', 'KORH', '25027', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (926, 'us', 'Michigan', 'Adrian, Lenawee County Airport', 'KADG', '26091', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (927, 'us', 'Michigan', 'Alma, Gratiot Community Airport', 'KAMN', '', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (928, 'us', 'Michigan', 'Alpena, Alpena County Regional Airport', 'KAPN', '26007', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (929, 'us', 'Michigan', 'Ann Arbor, Ann Arbor Municipal Airport', 'KARB', '26161', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (930, 'us', 'Michigan', 'Bad Axe, Huron County Memorial Airport', 'KBAX', '26063', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (931, 'us', 'Michigan', 'Bath', 'K41G', '26037', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (932, 'us', 'Michigan', 'Battle Creek, Kellogg Airport', 'KBTL', '26025', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (933, 'us', 'Michigan', 'Bellaire, Antrim County Airport', 'KACB', '26009', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (934, 'us', 'Michigan', 'Belle Isle Coast Guard Station', 'K31G', '26045', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (935, 'us', 'Michigan', 'Benton Harbor, Southwest Michigan Regional Airport', 'KBEH', '26021', 'kiwx', 'klot', 'kiwx')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (936, 'us', 'Michigan', 'Big Rapids, Roben-Hood Airport', 'KRQB', '26107', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (937, 'us', 'Michigan', 'Cadillac / Wexford County', 'KCAD', '26165', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (938, 'us', 'Michigan', 'Chippewa International Automatic Weather Observing / Reporting System', 'KCIU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (939, 'us', 'Michigan', 'Coldwater, Branch County Memorial Airport', 'KOEB', '26023', 'kiwx', 'kiwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (940, 'us', 'Michigan', 'Copper Harbor', 'KP59', '26083', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (941, 'us', 'Michigan', 'Detroit NEXRAD', 'KDTX', '26163', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (942, 'us', 'Michigan', 'Detroit, Detroit City Airport', 'KDET', '26163', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (943, 'us', 'Michigan', 'Detroit, Detroit Metropolitan Wayne County Airport', 'KDTW', '26163', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (944, 'us', 'Michigan', 'Detroit, Willow Run Airport', 'KYIP', '26163', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (945, 'us', 'Michigan', 'Detroit/Grosse Ile, Grosse Ile Airport', 'KONZ', '26163', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (946, 'us', 'Michigan', 'Eagle Harbor Coast Guard Light Station', 'K31Y', '26037', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (947, 'us', 'Michigan', 'Escanaba', 'KESC', '26041', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (948, 'us', 'Michigan', 'Flint, Bishop International Airport', 'KFNT', '26049', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (949, 'us', 'Michigan', 'Frankfort Coast Guard Station', 'K14C', '26125', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (950, 'us', 'Michigan', 'Gaylord, Otsego County Airport', 'KGLR', '26137', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (951, 'us', 'Michigan', 'Grand Marais Coast Guard Station', 'K27Y', '26081', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (952, 'us', 'Michigan', 'Grand Rapids, Kent County International Airport', 'KGRR', '26081', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (953, 'us', 'Michigan', 'Graying Air Force Range', 'K3RN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (954, 'us', 'Michigan', 'Gwinn, Sawyer Airport', 'KSAW', '26103', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (955, 'us', 'Michigan', 'Hancock, Houghton County Memorial Airport', 'KCMX', '26061', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (956, 'us', 'Michigan', 'Hillsdale, Hillsdale Municipal Airport', 'KJYM', '26059', 'kiwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (957, 'us', 'Michigan', 'Holland / Tulip City', 'KC19', '26139', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (958, 'us', 'Michigan', 'Holland, Tulip City Airport', 'KBIV', '26139', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (959, 'us', 'Michigan', 'Houghton Lake, Roscommon County Airport', 'KHTL', '26061', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (960, 'us', 'Michigan', 'Howell', 'K3HE', '26093', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (961, 'us', 'Michigan', 'Howell, Livingston County Airport', 'KOZW', '26093', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (962, 'us', 'Michigan', 'Iron Mountain / Kingsford, Ford Airport', 'KIMT', '26071', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (963, 'us', 'Michigan', 'Ironwood Automatic Weather Observing / Reporting System', 'KIWD', '26053', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (964, 'us', 'Michigan', 'jackson, jackson county-reynolds field airport', 'KJXN', '26075', 'kdtx', 'kiwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (965, 'us', 'Michigan', 'Kalamazoo, Kalamazoo / Battle Creek International Airport', 'KAZO', '26077', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (966, 'us', 'Michigan', 'Lansing, Capital City Airport', 'KLAN', '26065', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (967, 'us', 'Michigan', 'Ludington Coast Guard Station', 'K17C', '26105', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (968, 'us', 'Michigan', 'Ludington, Mason County Airport', 'KLDM', '26105', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (969, 'us', 'Michigan', 'Macinac Island, Mackinac Island Airport', 'KMCD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (970, 'us', 'Michigan', 'Manistee Automatic Weather Observing / Reporting System', 'KMBL', '26153', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (971, 'us', 'Michigan', 'Manistique', 'KP75', '26153', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (972, 'us', 'Michigan', 'Manistique, Schoolcraft County Airport', 'KISQ', '26153', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (973, 'us', 'Michigan', 'Marquette', 'KMQT', '26103', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (974, 'us', 'Michigan', 'Marquette Coast Guard Light Station', 'K34Y', '26103', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (975, 'us', 'Michigan', 'Marshall, Brooks Field Airport', 'KRMY', '26025', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (976, 'us', 'Michigan', 'Mason, Mason Jewett Field Airport', 'KTEW', '26065', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (977, 'us', 'Michigan', 'Menominee Automatic Weather Observing / Reporting System', 'KMNM', '26109', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (978, 'us', 'Michigan', 'Monroe, Custer Airport', 'KTTF', '26115', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (979, 'us', 'Michigan', 'Mount Pleasant, Mount Pleasant Municipal Airport', 'KMOP', '26073', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (980, 'us', 'Michigan', 'Muskegon Coast Guard Station', 'K19C', '26121', 'kgrr', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (981, 'us', 'Michigan', 'Muskegon, Muskegon County Airport', 'KMKG', '26121', 'kgrr', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (982, 'us', 'Michigan', 'Newberry, Luce County Airport', 'KERY', '26095', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (983, 'us', 'Michigan', 'North Manitou Shoal', 'K28Y', '26163', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (984, 'us', 'Michigan', 'Pellston, Pellston Regional Airport', 'KPLN', '26047', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (985, 'us', 'Michigan', 'Point Betsie / Frankfort', 'K36Y', '26097', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (986, 'us', 'Michigan', 'Pontiac, Oakland County International Airport', 'KPTK', '26125', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (987, 'us', 'Michigan', 'Port Hope', 'KP58', '26151', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (988, 'us', 'Michigan', 'Port Huron Coast Guard Station', 'K33G', '26151', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (989, 'us', 'Michigan', 'Portage Coast Guard Station', 'K32Y', '26077', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (990, 'us', 'Michigan', 'Presque Isle / Rogers', 'KPZQ', '26141', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (991, 'us', 'Michigan', 'Saginaw River Coast Guard Station', 'K30G', '26145', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (992, 'us', 'Michigan', 'Saginaw, MBSy International Airport', 'KMBS', '26145', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (993, 'us', 'Michigan', 'Saint Ignace', 'K38Y', '26057', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (994, 'us', 'Michigan', 'Saint Joseph Coast Guard Station', 'K20C', '26057', 'kiwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (995, 'us', 'Michigan', 'Sault Ste. Marie', 'KANJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (996, 'us', 'Michigan', 'Sault Ste. Marie Coast Guard Station', 'K44Y', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (997, 'us', 'Michigan', 'Selfridge Air National Guard Base', 'KMTC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (998, 'us', 'Michigan', 'St. Clair County International', 'KPHN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (999, 'us', 'Michigan', 'Sturgis, Kirsch Municipal Airport', 'KIRS', '26149', 'kiwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1000, 'us', 'Michigan', 'Tawas Point Coast Guard Station', 'K39Y', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1001, 'us', 'Michigan', 'Thunder Bay Island', 'K40Y', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1002, 'us', 'Michigan', 'Traverse City, Cherry Capital Airport', 'KTVC', '26055', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1003, 'us', 'Michigan', 'Wurtsmith Air Force Base', 'KOSC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1004, 'us', 'Minnesota', 'Airlake', 'KY12', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1005, 'us', 'Minnesota', 'Aitkin NDB Automatic Weather Observing / Reporting System', 'KAIT', '27001', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1006, 'us', 'Minnesota', 'Albert Lea Automatic Weather Observing / Reporting System', 'KAEL', '27171', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1007, 'us', 'Minnesota', 'Alexandria, Chandler Field', 'KAXN', '27041', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1008, 'us', 'Minnesota', 'Appleton, Appleton Municipal Airport', 'KAQP', '27151', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1009, 'us', 'Minnesota', 'Austin Municipal', 'KAUM', '27099', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1010, 'us', 'Minnesota', 'Baudette, Baudette International Airport', 'KBDE', '27077', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1011, 'us', 'Minnesota', 'Bemidji', 'KBJI', '27007', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1012, 'us', 'Minnesota', 'Benson Municipal', 'KBBB', '27151', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1013, 'us', 'Minnesota', 'Bigfork, Bigfork Municipal Airport', 'KFOZ', '27061', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1014, 'us', 'Minnesota', 'Brainerd, Brainerd-Crow Wing County Regional Airport', 'KBRD', '27035', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1015, 'us', 'Minnesota', 'Cambridge Municipal', 'KCBG', '27059', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1016, 'us', 'Minnesota', 'Cloquet Automatic Weather Observing / Reporting System', 'KCOQ', '27017', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1017, 'us', 'Minnesota', 'Cook, Cook Municipal Airport', 'KCQM', '', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1018, 'us', 'Minnesota', 'Crane Lake Automatic Weather Observing / Reporting System', 'K8Y8', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1019, 'us', 'Minnesota', 'Crane Lake, Scotts Seaplane Base', 'KCDD', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1020, 'us', 'Minnesota', 'Crookston Municipal Field', 'KCKN', '27119', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1021, 'us', 'Minnesota', 'Detroit Lakes Automatic Weather Observing / Reporting System', 'KDTL', '27005', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1022, 'us', 'Minnesota', 'Dodge Center, Dodge Center Airport', 'KTOB', '27039', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1023, 'us', 'Minnesota', 'Duluth Harbor Coast Guard Station', 'K30Y', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1024, 'us', 'Minnesota', 'Duluth, Duluth International Airport', 'KDLH', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1025, 'us', 'Minnesota', 'Duluth, Sky Harbor Airport', 'KDYT', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1026, 'us', 'Minnesota', 'Ely Municipal Automatic Weather Observing / Reporting System', 'KELO', '', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1027, 'us', 'Minnesota', 'Eveleth Municipal Automatic Weather Observing / Reporting System', 'KEVM', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1028, 'us', 'Minnesota', 'Fairmont Municipal Automatic Weather Observing / Reporting System', 'KFRM', '27091', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1029, 'us', 'Minnesota', 'Faribault Municipal Automatic Weather Observing / Reporting System', 'KFBL', '27131', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1030, 'us', 'Minnesota', 'Fergus Falls Automatic Weather Observing / Reporting System', 'KFFM', '27111', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1031, 'us', 'Minnesota', 'Fosston Automatic Weather Observing / Reporting System', 'KFSE', '27119', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1032, 'us', 'Minnesota', 'Glencoe, Glencoe Municipal Airport', 'KGYL', '27085', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1033, 'us', 'Minnesota', 'Glenwood', 'K53D', '27121', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1034, 'us', 'Minnesota', 'Glenwood Automatic Surface Observing System', 'KGHW', '27121', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1035, 'us', 'Minnesota', 'Grand Marais', 'KP61', '27059', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1036, 'us', 'Minnesota', 'Grand Marais, Grand Marais/Cook County Airport', 'KCKC', '27059', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1037, 'us', 'Minnesota', 'Grand Marais, The Bay of Grand Marais', 'KGNA', '27059', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1038, 'us', 'Minnesota', 'Grand Rapids Automatic Weather Observing / Reporting System', 'KGPZ', '27059', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1039, 'us', 'Minnesota', 'Hallock', 'K03Y', '27069', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1040, 'us', 'Minnesota', 'Hallock, Hallock Municipal Airport', 'KHCO', '27069', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1041, 'us', 'Minnesota', 'Hibbing, Chisholm-Hibbing Airport', 'KHIB', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1042, 'us', 'Minnesota', 'Hutchinson Automatic Weather Observing / Reporting System', 'KHCD', '27085', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1043, 'us', 'Minnesota', 'International Falls, Falls International Airport', 'KINL', '27071', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1044, 'us', 'Minnesota', 'Jackson Municipal Automatic Weather Observing / Reporting System', 'KMJQ', '27063', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1045, 'us', 'Minnesota', 'Litchfield Municipal', 'K43F', '27093', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1046, 'us', 'Minnesota', 'Litchfield, Litchfield Municipal Airport', 'KLJF', '27093', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1047, 'us', 'Minnesota', 'Little Falls Automatic Weather Observing / Reporting System', 'KLXL', '27071', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1048, 'us', 'Minnesota', 'Longville, Longville Municipal Airport', 'KXVG', '27021', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1049, 'us', 'Minnesota', 'Madison, Madison-Lac Qui Parle County Airport', 'KDXX', '27073', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1050, 'us', 'Minnesota', 'Mankato Automatic Weather Observing / Reporting System', 'KMKT', '27013', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1051, 'us', 'Minnesota', 'Maple Lake, Maple Lake Municipal Airport', 'KMGG', '27013', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1052, 'us', 'Minnesota', 'Marshall / Ryan Automatic Weather Observing / Reporting System', 'KMML', '27083', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1053, 'us', 'Minnesota', 'Minneapolis / Blaine', 'KANE', '27053', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1054, 'us', 'Minnesota', 'Minneapolis, Airlake Airport', 'KLVN', '27053', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1055, 'us', 'Minnesota', 'Minneapolis, Crystal Airport', 'KMIC', '27053', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1056, 'us', 'Minnesota', 'Minneapolis, Flying Cloud Airport', 'KFCM', '27053', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1057, 'us', 'Minnesota', 'Minneapolis, Minneapolis-St. Paul International Airport', 'KMSP', '27053', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1058, 'us', 'Minnesota', 'Montevideo Automatic Weather Observing / Reporting System', 'KMVE', '27023', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1059, 'us', 'Minnesota', 'Moorhead, Moorhead Municipal Airport', 'K99M', '27027', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1060, 'us', 'Minnesota', 'Moose Lake, Moose Lake Carlton County Airport', 'KMZH', '27017', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1061, 'us', 'Minnesota', 'Mora Municipal Automatic Weather Observing / Reporting System', 'K19D', '27065', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1062, 'us', 'Minnesota', 'Mora, Mora Municipal Airport', 'KJMR', '', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1063, 'us', 'Minnesota', 'Morris Municipal Automatic Weather Observing / Reporting System', 'KMOX', '27149', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1064, 'us', 'Minnesota', 'New Ulm Municipal Automatic Weather Observing / Reporting System', 'KULM', '27015', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1065, 'us', 'Minnesota', 'Orr', 'KORB', '27137', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1066, 'us', 'Minnesota', 'Ortonville, Ortonville Muncipal-Martinson Field Airport', 'KVVV', '27011', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1067, 'us', 'Minnesota', 'Owatonna Automatic Weather Observing / Reporting System', 'KOWA', '27147', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1068, 'us', 'Minnesota', 'Park Rapids, Park Rapids Municipal Airport', 'KPKD', '27057', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1069, 'us', 'Minnesota', 'Pequot Lake', 'KP39', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1070, 'us', 'Minnesota', 'Pine River, Pine River Regional Airport', 'KPWC', '27021', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1071, 'us', 'Minnesota', 'Pipestone Automatic Weather Observing / Reporting System', 'KPQN', '27117', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1072, 'us', 'Minnesota', 'Princeton', 'KPNM', '27095', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1073, 'us', 'Minnesota', 'Red Wing, Red Wing Municipal Airport', 'KRGK', '27049', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1074, 'us', 'Minnesota', 'Redwood Falls, Redwood Falls Municipal Airport', 'KRWF', '27127', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1075, 'us', 'Minnesota', 'Rochester, Rochester Municipal Airport', 'KRST', '27109', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1076, 'us', 'Minnesota', 'Roseau Municipal Automatic Weather Observing / Reporting System', 'KROX', '27135', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1077, 'us', 'Minnesota', 'Rush City, Rush City Regional Airport', 'KROS', '27025', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1078, 'us', 'Minnesota', 'Silver Bay', 'KBFW', '27085', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1079, 'us', 'Minnesota', 'South St. Paul Municipal', 'KD97', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1080, 'us', 'Minnesota', 'South St. Paul, South St. Paul Municipal-Richard E. Fleming Field Airport', 'KSGS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1081, 'us', 'Minnesota', 'St. Cloud, St. Cloud Municipal Airport', 'KSTC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1082, 'us', 'Minnesota', 'St. James, St. James Municipal Airport', 'KJYG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1083, 'us', 'Minnesota', 'St. Paul, St. Paul Downtown Holman Field', 'KSTP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1084, 'us', 'Minnesota', 'Staples, Staples Municipal Airport', 'KSAZ', '27153', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1085, 'us', 'Minnesota', 'Thief River Automatic Weather Observing / Reporting System', 'KTVF', '27113', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1086, 'us', 'Minnesota', 'Two Harbors', 'KTWM', '27075', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1087, 'us', 'Minnesota', 'Warroad', 'KD45', '27135', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1088, 'us', 'Minnesota', 'Warroad Automatic Weather Observing / Reporting System', 'KRAD', '27135', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1089, 'us', 'Minnesota', 'Warroad, Warroad International-Swede Carlston Field', 'KRRT', '27135', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1090, 'us', 'Minnesota', 'Waskish, Waskish Municipal Airport', 'KVWU', '27007', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1091, 'us', 'Minnesota', 'Wheaton NDB Automatic Weather Observing / Reporting System', 'KETH', '27155', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1092, 'us', 'Minnesota', 'Willmar / Rice Automatic Weather Observing / Reporting System', 'KILL', '27067', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1093, 'us', 'Minnesota', 'Windom, Windom Municipal Airport', 'KMWM', '27033', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1094, 'us', 'Minnesota', 'Winona Municipal Automatic Weather Observing / Reporting System', 'KONA', '27169', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1095, 'us', 'Minnesota', 'Worthington Automatic Weather Observing / Reporting System', 'KOTG', '27105', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1096, 'us', 'Mississippi', 'Biloxi, Keesler Air Force Base, Navu', 'BIX3', '28047', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1097, 'us', 'Mississippi', 'Columbus Air Force Base', 'KCBM', '28087', 'kgwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1098, 'us', 'Mississippi', 'Golden Tri Automatic Weather Observing / Reporting System', 'KGTR', '28057', 'kgwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1099, 'us', 'Mississippi', 'Greenville, Greenville Municipal Airport', 'KGLH', '28083', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1100, 'us', 'Mississippi', 'Greenwood, Greenwood-LeFlore Airport', 'KGWO', '28083', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1101, 'us', 'Mississippi', 'Gulfport, Gulfport-Biloxi Regional Airport', 'KGPT', '28047', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1102, 'us', 'Mississippi', 'hattiesburg, bobby l chain municipal airport', 'KHBG', '28035', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1103, 'us', 'Mississippi', 'Jackson, Hawkins Field', 'KHKS', '28121', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1104, 'us', 'Mississippi', 'Jackson, Jackson International Airport', 'KJAN', '28121', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1105, 'us', 'Mississippi', 'Keesler Air Force Base / Biloxi', 'KBIX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1106, 'us', 'Mississippi', 'McComb, McComb / Pike County Airport', 'KMCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1107, 'us', 'Mississippi', 'Meridian Range, B', 'KNJW', '28075', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1108, 'us', 'Mississippi', 'Meridian, Key Field', 'KMEI', '28075', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1109, 'us', 'Mississippi', 'Meridian, Naval Air Station', 'KNMM', '28075', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1110, 'us', 'Mississippi', 'Natchez / Hardy Automatic Weather Observing / Reporting System', 'KHEZ', '28001', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1111, 'us', 'Mississippi', 'Pascagoula / Jackson', 'KPGL', '28059', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1112, 'us', 'Mississippi', 'Pascagoula Coast Guard Station', 'K8R0', '28059', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1113, 'us', 'Mississippi', 'Pascagoula, Lott International Airport', 'KPQL', '28059', 'kmob', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1114, 'us', 'Mississippi', 'Picayune / Pearl River', 'KPCU', '28109', 'klix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1115, 'us', 'Mississippi', 'Pine Belt Regional Automatic Weather Observing / Reporting System', 'KPIB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1116, 'us', 'Mississippi', 'Tupelo, Tupelo Municipal-Lemons Airport', 'KTUP', '28081', 'kgwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1117, 'us', 'Mississippi', 'Vicksburg Municipal', 'KVKS', '28149', 'kjan', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1118, 'us', 'Missouri', 'Cape Girardeau, Cape Girardeau Regional Airport', 'KCGI', '29031', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1119, 'us', 'Missouri', 'Chillicothe, Chillicothe Agri-Science Center', 'KCDJ', '29117', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1120, 'us', 'Missouri', 'Columbia, Columbia Regional Airport', 'KCOU', '29019', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1121, 'us', 'Missouri', 'Farmington Airport', 'KFAM', '29187', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1122, 'us', 'Missouri', 'Fort Leonard Wood', 'KTBN', '29169', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1123, 'us', 'Missouri', 'Jefferson City, Jefferson City Memorial Airport', 'KJEF', '29099', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1124, 'us', 'Missouri', 'Joplin', 'KJLN', '29097', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1125, 'us', 'Missouri', 'Kaiser Memorial Automatic Weather Observing / Reporting System', 'KAIZ', '29131', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1126, 'us', 'Missouri', 'Kansas City, Kansas City Downtown Airport', 'KMKC', '29095', 'keax', 'ktwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1127, 'us', 'Missouri', 'Kansas City, Kansas City International Airport', 'KMCI', '29095', 'keax', 'ktwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1128, 'us', 'Missouri', 'Kansas City, Richards-Gebaur Airport', 'KGVW', '29095', 'keax', 'ktwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1129, 'us', 'Missouri', 'Kirksville, Kirksville Regional Airport', 'KIRK', '29001', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1130, 'us', 'Missouri', 'Pleasant NEXRAD', 'KEAX', '29037', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1131, 'us', 'Missouri', 'Poplar Bluff, Mo.', 'KP02', '29023', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1132, 'us', 'Missouri', 'Poplar Bluff, Poplar Bluff Municipal Airport', 'KPOF', '29023', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1133, 'us', 'Missouri', 'Rolla / Vichy, Rolla National Airport', 'KVIH', '29161', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1134, 'us', 'Missouri', 'Sedalia, Sedalia Memorial Airport', 'KDMO', '29159', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1135, 'us', 'Missouri', 'Spickard', 'KP35', '29079', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1136, 'us', 'Missouri', 'Springfield, Springfield Regional Airport', 'KSGF', '29077', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1137, 'us', 'Missouri', 'St. Charles, St. Charles County Smartt Airport', 'KSET', '29183', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1138, 'us', 'Missouri', 'St. Joseph, Rosecrans Memorial Airport', 'KSTJ', '29021', 'keax', 'ktwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1139, 'us', 'Missouri', 'St. Louis, Lambert-St. Louis International Airport', 'KSTL', '29510', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1140, 'us', 'Missouri', 'St. Louis, Spirit Of St. Louis Airport', 'KSUS', '29510', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1141, 'us', 'Missouri', 'West Plains, West Plains Municipal Airport', 'KUNO', '29091', 'ksgf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1142, 'us', 'Missouri', 'Whiteman Air Force Base', 'KSZL', '29101', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1143, 'us', 'Montana', 'Baker, Baker Municipal Airport', 'KBHK', '30025', 'kggw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1144, 'us', 'Montana', 'Billing Yell Nexrad', 'KBLX', '30111', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1145, 'us', 'Montana', 'Billings, Billings Logan International Airport', 'KBIL', '30111', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1146, 'us', 'Montana', 'Bozeman, Gallatin Field', 'KBZN', '30031', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1147, 'us', 'Montana', 'Broadus', 'K4BQ', '30007', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1148, 'us', 'Montana', 'Butte, Bert Mooney Airport', 'KBTM', '30093', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1149, 'us', 'Montana', 'Cut Bank Automatic Weather Observing / Reporting System', 'KCTB', '30035', 'ktfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1150, 'us', 'Montana', 'Dillon, Dillon Airport', 'KDLN', '30001', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1151, 'us', 'Montana', 'Drummond', 'K3DU', '30039', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1152, 'us', 'Montana', 'Glasgow, Glasgow International Airport', 'KGGW', '30105', 'kggw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1153, 'us', 'Montana', 'Glendive Automatic Weather Observing / Reporting System', 'KGDV', '30021', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1154, 'us', 'Montana', 'Great Falls Nexrad', 'KTFX', '30013', 'ktfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1155, 'us', 'Montana', 'Great Falls, Great Falls International Airport', 'KGTF', '30013', 'ktfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1156, 'us', 'Montana', 'Hamilton / Ravalli County', 'KHMM', '30081', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1157, 'us', 'Montana', 'Harlowton', 'K3HT', '30107', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1158, 'us', 'Montana', 'Havre, Havre City-County Airport', 'KHVR', '30041', 'ktfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1159, 'us', 'Montana', 'Helena, Helena Regional Airport', 'KHLN', '30049', 'ktfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1160, 'us', 'Montana', 'Jordan, Jordan Airport', 'KJDN', '30033', 'kggw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1161, 'us', 'Montana', 'Kalispell, Glacier Park International Airport', 'KFCA', '30029', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1162, 'us', 'Montana', 'Leeds', 'KLDS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1163, 'us', 'Montana', 'Lewistown Municipal', 'KLWT', '30027', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1164, 'us', 'Montana', 'Livingston, Mission Field', 'KLVM', '30067', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1165, 'us', 'Montana', 'Malmstrom Air Force Base', 'KGFA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1166, 'us', 'Montana', 'miles city, frank wiley field airport', 'KMLS', '30017', 'kggw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1167, 'us', 'Montana', 'Missoula NEXRAD', 'KMSX', '30063', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1168, 'us', 'Montana', 'Missoula, Missoula International Airport', 'KMSO', '30063', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1169, 'us', 'Montana', 'Monida', 'KMQM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1170, 'us', 'Montana', 'Red Lodge', 'KRED', '30009', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1171, 'us', 'Montana', 'Sidney-Richland', 'KSDY', '30083', 'kggw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1172, 'us', 'Montana', 'Thompson Falls', 'K3TH', '30089', 'kmsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1173, 'us', 'Montana', 'West Yellowstone', 'KWYS', '30031', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1174, 'us', 'Montana', 'Wolf Point, Clayton Airport', 'KOLF', '30085', 'kggw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1175, 'us', 'Nebraska', 'Ainsworth Municipal', 'KANW', '31017', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1176, 'us', 'Nebraska', 'Alliance, Alliance Municipal Airport', 'KAIA', '31013', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1177, 'us', 'Nebraska', 'Aurora, Aurora Municipal Airport', 'KAUH', '31081', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1178, 'us', 'Nebraska', 'Beatrice Municipal', 'KBIE', '31067', 'koax', 'ktwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1179, 'us', 'Nebraska', 'Brewster Field Airport', 'KHDE', '31009', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1180, 'us', 'Nebraska', 'Broken Bow, Broken Bow Municipal Airport', 'KBBW', '31041', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1181, 'us', 'Nebraska', 'Chadron, Chadron Municipal Airport', 'KCDR', '31045', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1182, 'us', 'Nebraska', 'Columbus Municipal Automatic Weather Observing / Reporting System', 'KOLU', '31141', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1183, 'us', 'Nebraska', 'Cozad Municipal', 'KCZD', '31047', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1184, 'us', 'Nebraska', 'falls city, brenner field airport', 'KFNB', '31147', 'ktwx', 'ktwx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1185, 'us', 'Nebraska', 'Fremont Municipal Airport', 'KFET', '31053', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1186, 'us', 'Nebraska', 'Gordon Municipal', 'KGRN', '31161', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1187, 'us', 'Nebraska', 'Grand Island Nexrad', 'KUEX', '31079', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1188, 'us', 'Nebraska', 'Grand Island, Central Nebraska Regional Airport', 'KGRI', '31079', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1189, 'us', 'Nebraska', 'Hastings, Hastings Municipal Airport', 'KHSI', '31001', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1190, 'us', 'Nebraska', 'Imperial Municipal', 'KIML', '31029', 'kgld', 'kgld', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1191, 'us', 'Nebraska', 'Kearney Municipal Automatic Weather Observing / Reporting System', 'KEAR', '31019', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1192, 'us', 'Nebraska', 'Lexington, Jim Kelly Field Airport', 'KLXN', '31047', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1193, 'us', 'Nebraska', 'Lincoln, Lincoln Municipal Airport', 'KLNK', '31109', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1194, 'us', 'Nebraska', 'McCook, McCook Municipal Airport', 'KMCK', '', '', 'kgld', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1195, 'us', 'Nebraska', 'Mullen / Hooker County', 'KMHN', '31091', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1196, 'us', 'Nebraska', 'Norfolk, Stefan Memorial Airport', 'KOFK', '31119', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1197, 'us', 'Nebraska', 'North Platte, North Platte Regional Airport', 'KLBF', '31111', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1198, 'us', 'Nebraska', 'O\'Neill / Baker Field', 'KONL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1199, 'us', 'Nebraska', 'Ogallala, Searle Field Airport', 'KOGA', '31101', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1200, 'us', 'Nebraska', 'Omaha / Offutt Air Force Base', 'KOFF', '31055', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1201, 'us', 'Nebraska', 'Omaha, Eppley Airfield', 'KOMA', '31055', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1202, 'us', 'Nebraska', 'ord, evelyn sharp field airport', 'KODX', '', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1203, 'us', 'Nebraska', 'Scottsbluff, Heilig Field', 'KBFF', '31157', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1204, 'us', 'Nebraska', 'Sidney, Sidney Municipal Airport', 'KSNY', '31033', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1205, 'us', 'Nebraska', 'Tekamah, Tekamah Municipal Airport', 'KTQE', '31021', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1206, 'us', 'Nebraska', 'Valentine, Miller Field', 'KVTN', '31031', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1207, 'us', 'Nebraska', 'Valley', 'KOAX', '31055', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1208, 'us', 'Nevada', 'Austin', 'KU31', '32015', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1209, 'us', 'Nevada', 'Battle Mountain', 'KB23', '32015', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1210, 'us', 'Nevada', 'Caliente', 'KP38', '32017', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1211, 'us', 'Nevada', 'Elko Nexrad', 'KLRX', '32007', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1212, 'us', 'Nevada', 'Elko, Elko Municipal-Harris Field', 'KEKO', '', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1213, 'us', 'Nevada', 'Ely, Ely Airport', 'KELY', '', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1214, 'us', 'Nevada', 'Eureka', 'KP68', '32011', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1215, 'us', 'Nevada', 'Fallon, Naval Air Station', 'KNFL', '32001', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1216, 'us', 'Nevada', 'Hawthorne Municipal', 'KHTH', '32021', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1217, 'us', 'Nevada', 'Indian Springs Gunnery Range', 'KINS', '32003', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1218, 'us', 'Nevada', 'Las Vegas Nexrad', 'KESX', '32003', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1219, 'us', 'Nevada', 'Las Vegas, McCarran International Airport', 'KLAS', '32003', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1220, 'us', 'Nevada', 'Las Vegas, North Las Vegas Airport', 'KVGT', '32003', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1221, 'us', 'Nevada', 'Lovelock, Derby Field', 'KLOL', '32027', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1222, 'us', 'Nevada', 'Mercury, Desert Rock Airport', 'KDRA', '32023', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1223, 'us', 'Nevada', 'Nellis Air Force Base', 'KLSV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1224, 'us', 'Nevada', 'Owyhee', 'KOWY', '32007', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1225, 'us', 'Nevada', 'Reno NEXRAD', 'KRGX', '32031', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1226, 'us', 'Nevada', 'Reno, Reno Tahoe International Airport', 'KRNO', '', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1227, 'us', 'Nevada', 'Tonopah Test Range', 'KTNX', '32023', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1228, 'us', 'Nevada', 'Tonopah, Tonopah Airport', 'KTPH', '32023', 'krgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1229, 'us', 'Nevada', 'Wells', 'K9BB', '32007', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1230, 'us', 'Nevada', 'Wildhorse Reservation / Elko', 'KAWH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1231, 'us', 'Nevada', 'Winnemucca, Winnemucca Municipal Airport', 'KWMC', '32013', 'klrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1232, 'us', 'New Hampshire', 'Berlin, Berlin Municipal Airport', 'KBML', '33007', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1233, 'us', 'New Hampshire', 'Concord, Concord Municipal Airport', 'KCON', '33013', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1234, 'us', 'New Hampshire', 'Isle Of Shoals Coast Guard Station', 'K26B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1235, 'us', 'New Hampshire', 'Jaffrey, Jaffrey Municipal-Silver Ranch Airport', 'KAFN', '33005', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1236, 'us', 'New Hampshire', 'Keene / Dillant Automatic Weather Observing / Reporting System', 'KEEN', '33005', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1237, 'us', 'New Hampshire', 'Laconia Municipal Automatic Weather Observing / Reporting System', 'KLCI', '33001', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1238, 'us', 'New Hampshire', 'Lebanon, Lebanon Municipal Airport', 'KLEB', '33009', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1239, 'us', 'New Hampshire', 'Manchester, Manchester Airport', 'KMHT', '33011', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1240, 'us', 'New Hampshire', 'Mount Washington', 'KMWN', '33007', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1241, 'us', 'New Hampshire', 'Nashua / Boire Field', 'KASH', '33011', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1242, 'us', 'New Hampshire', 'New Castles Coast Guard Light Station', 'K12B', '33015', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1243, 'us', 'New Hampshire', 'Pease Air Force Base / Portsmouth', 'KPSM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1244, 'us', 'New Hampshire', 'Portsmouth Harbor', 'K25B', '33015', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1245, 'us', 'New Hampshire', 'Rochester, Skyhaven Airport', 'KDAW', '33017', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1246, 'us', 'New Hampshire', 'Whitefield, Mount Washington Regional Airport', 'KHIE', '33007', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1247, 'us', 'New Jersey', 'Andover, Aeroflex-Andover Airport', 'K12N', '34037', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1248, 'us', 'New Jersey', 'Atlantic City Coast Guard Station', 'K55N', '34025', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1249, 'us', 'New Jersey', 'Atlantic City, Atlantic City International Airport', 'KACY', '34025', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1250, 'us', 'New Jersey', 'Barnegat Coast Guard Station', 'KN78', '34029', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1251, 'us', 'New Jersey', 'Belmar-Farmdale', 'KBLM', '34025', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1252, 'us', 'New Jersey', 'Caldwell, Essex County Airport', 'KCDW', '34013', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1253, 'us', 'New Jersey', 'Cape May Coast Guard Station', 'KN91', '34009', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1254, 'us', 'New Jersey', 'Lakehurst Naval Air Station', 'KNEL', '34029', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1255, 'us', 'New Jersey', 'Manasquan Inl Coast Guard Station', 'K54N', '34025', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1256, 'us', 'New Jersey', 'Mcguire Air Force Base', 'KWRI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1257, 'us', 'New Jersey', 'Millville, Millville Municipal Airport', 'KMIV', '34011', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1258, 'us', 'New Jersey', 'Morristown Municipal', 'KMMU', '34027', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1259, 'us', 'New Jersey', 'Mount Holly, South Jersey Regional Airport', 'KVAY', '34039', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1260, 'us', 'New Jersey', 'Newark, Newark International Airport', 'KEWR', '34013', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1261, 'us', 'New Jersey', 'Sandy Hook Coast Guard Station', 'K56N', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1262, 'us', 'New Jersey', 'Somerville, Somerset Airport', 'KSMQ', '34035', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1263, 'us', 'New Jersey', 'Sussex, Sussex Airport', 'KFWN', '34037', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1264, 'us', 'New Jersey', 'Teterboro, Teterboro Airport', 'KTEB', '34003', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1265, 'us', 'New Jersey', 'Trenton, Mercer County Airport', 'KTTN', '34005', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1266, 'us', 'New Jersey', 'Wildwood', 'K52N', '34009', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1267, 'us', 'New Jersey', 'Wildwood Automatic Weather Observing / Reporting System', 'KWWD', '34009', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1268, 'us', 'New Mexico', 'Alamogordo-White', 'KALM', '35035', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1269, 'us', 'New Mexico', 'Albuquerque Nexrad', 'KABX', '35001', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1270, 'us', 'New Mexico', 'Albuquerque Radar Site', 'KZAB', '35001', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1271, 'us', 'New Mexico', 'Albuquerque, Albuquerque International Airport', 'KABQ', '35001', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1272, 'us', 'New Mexico', 'Albuquerque, Double Eagle II Airport', 'KAEG', '35001', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1273, 'us', 'New Mexico', 'Artesia, Artesia Municipal Airport', 'KATS', '35015', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1274, 'us', 'New Mexico', 'Cannon Air Force Base / Clovis', 'KCVS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1275, 'us', 'New Mexico', 'Carlsbad, Cavern City Air Terminal', 'KCNM', '35015', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1276, 'us', 'New Mexico', 'Chama', 'KE33', '35039', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1277, 'us', 'New Mexico', 'Clayton, Clayton Municipal Airpark', 'KCAO', '35059', 'kama', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1278, 'us', 'New Mexico', 'Clines Corners', 'KCQC', '35057', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1279, 'us', 'New Mexico', 'Clovis Municipal Automatic Weather Observing / Reporting System', 'KCVN', '35009', 'kfdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1280, 'us', 'New Mexico', 'Corona / Lincoln', 'K4CR', '35027', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1281, 'us', 'New Mexico', 'Deming, Deming Municipal Airport', 'KDMN', '35029', 'kepz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1282, 'us', 'New Mexico', 'Farmington, Four Corners Regional Airport', 'KFMN', '35045', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1283, 'us', 'New Mexico', 'Gallup, Gallup Municipal Airport', 'KGUP', '35031', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1284, 'us', 'New Mexico', 'Grants, Grants-Milan Municipal Airport', 'KGNT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1285, 'us', 'New Mexico', 'Hobbs / Lea County', 'KHOB', '35025', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1286, 'us', 'New Mexico', 'Holloman Air Force Base', 'KHMN', '35035', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1287, 'us', 'New Mexico', 'Kirtland, Kirtland Air Force Base Auxiliary Field', 'KIKR', '35045', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1288, 'us', 'New Mexico', 'Las Cruces International', 'KLRU', '35013', 'kepz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1289, 'us', 'New Mexico', 'Las Vegas, Las Vegas Municipal Airport', 'KLVS', '35047', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1290, 'us', 'New Mexico', 'Los Alamos', 'KLAM', '35028', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1291, 'us', 'New Mexico', 'Melrose Gunnery Range', 'K4MR', '35009', 'kfdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1292, 'us', 'New Mexico', 'Moriarty', 'K4MY', '35057', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1293, 'us', 'New Mexico', 'Northrup Landing Strip', 'KE28', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1294, 'us', 'New Mexico', 'Raton, Raton Municipal  Crews Field Airport', 'KRTN', '35007', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1295, 'us', 'New Mexico', 'Roswell, Roswell Industrial Air Center Airport', 'KROW', '35005', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1296, 'us', 'New Mexico', 'Ruidoso Regional', 'KSRR', '35027', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1297, 'us', 'New Mexico', 'Santa Fe, Santa Fe County Municipal Airport', 'KSAF', '35013', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1298, 'us', 'New Mexico', 'Santa Teresa', 'KEPZ', '35013', 'kepz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1299, 'us', 'New Mexico', 'Silver City / Grant', 'KSVC', '35017', 'kepz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1300, 'us', 'New Mexico', 'Socorro Municipal', 'KONM', '35053', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1301, 'us', 'New Mexico', 'Taos Municipal Airport Automatic Weather Observing / Reporting System', 'KSKX', '35055', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1302, 'us', 'New Mexico', 'Torreon', 'K4SL', '35057', 'kabx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1303, 'us', 'New Mexico', 'Truth Or Consequences, Truth Or Consequences Municipal Airport', 'KTCS', '35051', 'khdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1304, 'us', 'New Mexico', 'Tucumcari, Tucumcari Municipal Airport', 'KTCC', '35037', 'kfdx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1305, 'us', 'New Mexico', 'White Sands', 'K2C2', '35015', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1306, 'us', 'New York', 'Albany NEXRAD', 'KENX', '36001', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1307, 'us', 'New York', 'Albany, Albany County Airport', 'KALB', '36001', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1308, 'us', 'New York', 'Ambrose / Ft. Tilden', 'KN28', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1309, 'us', 'New York', 'Bay Shore / Fire Island', 'K45N', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1310, 'us', 'New York', 'Binghamton, Binghamton Regional Airport', 'KBGM', '36007', 'kbgm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1311, 'us', 'New York', 'Bronx / Execution Coast Guard Station', 'KN84', '36005', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1312, 'us', 'New York', 'Buffalo Coast Guard Station', 'K19G', '36029', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1313, 'us', 'New York', 'Buffalo, Greater Buffalo International Airport', 'KBUF', '36029', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1314, 'us', 'New York', 'Calverton / Grumman', 'KCTO', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1315, 'us', 'New York', 'Cape Vincent Marine Aviation Reporting Station', 'K95B', '36045', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1316, 'us', 'New York', 'Dansville, Dansville Municipal Airport', 'KDSV', '36051', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1317, 'us', 'New York', 'Dunkirk, Chautauqua County / Dunkirk Airport', 'KDKK', '36013', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1318, 'us', 'New York', 'East Hampton, East Hampton Airport', 'KHTO', '36077', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1319, 'us', 'New York', 'East Moriches Coast Guard Station', 'K49N', '36077', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1320, 'us', 'New York', 'Eatons Neck Coast Guard Station', 'K34N', '36053', 'kbgm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1321, 'us', 'New York', 'Elmira, Elmira / Corning Regional Airport', 'KELM', '36015', 'kbgm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1322, 'us', 'New York', 'Farmingdale, Republic Airport', 'KFRG', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1323, 'us', 'New York', 'Fort Drum / Wheeler-Sack U. S. Army Airfield', 'KGTB', '36057', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1324, 'us', 'New York', 'Fulton, Oswego County Airport', 'KN00', '36075', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1325, 'us', 'New York', 'Glens Falls, Warren County Airport', 'KGFL', '36113', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1326, 'us', 'New York', 'Griffiss Air Force Base / Rome', 'KRME', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1327, 'us', 'New York', 'Islip, Long Island Mac Arthur Airport', 'KISP', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1328, 'us', 'New York', 'Ithaca / Tompkins County', 'KITH', '36109', 'kbgm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1329, 'us', 'New York', 'Jamestown Automatic Weather Observing / Reporting System', 'KJHW', '36067', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1330, 'us', 'New York', 'Massena, Massena International-Richards Field', 'KMSS', '36089', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1331, 'us', 'New York', 'Millbrook / Sky Acres', 'K44N', '36027', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1332, 'us', 'New York', 'Montauk Point Coast Guard Light Station', 'K48N', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1333, 'us', 'New York', 'Montauk, Montauk Airport', 'KMTP', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1334, 'us', 'New York', 'Montgomery, Orange County Airport', 'KMGJ', '36071', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1335, 'us', 'New York', 'Monticello Automatic Weather Observing / Reporting System', 'KMSV', '36105', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1336, 'us', 'New York', 'N. Y. City NEXRAD', 'KOKX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1337, 'us', 'New York', 'New York City, Central Park', 'KNYC', '36061', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1338, 'us', 'New York', 'New York, Kennedy International Airport', 'KJFK', '36061', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1339, 'us', 'New York', 'New York, La Guardia Airport', 'KLGA', '36061', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1340, 'us', 'New York', 'Newburgh / Stewart', 'KSWF', '36071', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1341, 'us', 'New York', 'Niagara Coast Guard Station', 'K13G', '36063', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1342, 'us', 'New York', 'Niagara Falls, Niagara Falls International Airport', 'KIAG', '36063', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1343, 'us', 'New York', 'Ogdensburg International', 'KOGS', '36089', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1344, 'us', 'New York', 'Olean Municipal', 'KOLE', '36009', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1345, 'us', 'New York', 'Oswego Coast Guard Station', 'K28G', '36075', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1346, 'us', 'New York', 'Penn Yan, Penn Yan Airport', 'KPEO', '36123', 'kbgm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1347, 'us', 'New York', 'Plattsburgh Air Force Base', 'KPBG', '36019', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1348, 'us', 'New York', 'Plattsburgh, Clinton County Airport', 'KPLB', '36019', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1349, 'us', 'New York', 'Poughkeepsie, Dutchess County Airport', 'KPOU', '36027', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1350, 'us', 'New York', 'Rochester Coast Guard Light Station', 'K26G', '36055', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1351, 'us', 'New York', 'Rochester, Greater Rochester International Airport', 'KROC', '36055', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1352, 'us', 'New York', 'Rockaway Coast Guard Station', 'K50N', '36081', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1353, 'us', 'New York', 'Saranac Lake, Adirondack Regional Airport', 'KSLK', '36019', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1354, 'us', 'New York', 'Schenectady Airport', 'KSCH', '36077', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1355, 'us', 'New York', 'Shirley, Brookhaven Airport', 'KHWV', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1356, 'us', 'New York', 'Short Beach Coast Guard Station', 'K51N', '36069', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1357, 'us', 'New York', 'Syracuse, Syracuse Hancock International Airport', 'KSYR', '36067', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1358, 'us', 'New York', 'Utica, Oneida County Airport', 'KUCA', '36065', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1359, 'us', 'New York', 'Watertown, Watertown International Airport', 'KART', '36001', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1360, 'us', 'New York', 'Wellsville, Wellsville Municipal Airport', 'KELZ', '36041', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1361, 'us', 'New York', 'Westhampton Beach, The Gabreski Airport', 'KFOK', '36103', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1362, 'us', 'New York', 'White Plains, Westchester County Airport', 'KHPN', '36003', 'kokx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1363, 'us', 'North Carolina', 'Ahoskie, Tri-County Airport', 'KASJ', '37091', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1364, 'us', 'North Carolina', 'Andrews, Andrews-Murphy Airport', 'K6A3', '37039', 'kmrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1365, 'us', 'North Carolina', 'Asheboro, Asheboro Municipal Airport', 'KW44', '37151', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1366, 'us', 'North Carolina', 'Asheville, Asheville Regional Airport', 'KAVL', '37021', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1367, 'us', 'North Carolina', 'Atlantic, Atlantic Field Outlying Landing Field', 'KNLT', '37031', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1368, 'us', 'North Carolina', 'Beaufort, Smith Field', 'KMRH', '37031', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1369, 'us', 'North Carolina', 'Burlington, Burlington Alamance Regional Airport', 'KBUY', '37001', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1370, 'us', 'North Carolina', 'Cape Hatteras', 'KHAT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1371, 'us', 'North Carolina', 'Cape Lookout Coast Guard Station', 'K77W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1372, 'us', 'North Carolina', 'Chapel Hill, Williams Airport', 'KIGX', '37135', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1373, 'us', 'North Carolina', 'Charlotte, Charlotte / Douglas International Airport', 'KCLT', '37119', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1374, 'us', 'North Carolina', 'Cherry Point, Marine Corps Air Station', 'KNKT', '37071', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1375, 'us', 'North Carolina', 'Dare County Gunnery Range', 'K2DP', '37055', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1376, 'us', 'North Carolina', 'Diamond Shoals Coast Guard Station', 'K44W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1377, 'us', 'North Carolina', 'Edenton, Northeastern Regional Airport', 'KEDE', '37041', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1378, 'us', 'North Carolina', 'Elizabeth City, Elizabeth City Coast Guard Air Station', 'KECG', '37017', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1379, 'us', 'North Carolina', 'Erwin, Harnett County Airport', 'KHRJ', '37085', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1380, 'us', 'North Carolina', 'Fayetteville, Fayetteville Regional Airport', 'KFAY', '37051', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1381, 'us', 'North Carolina', 'Fort Bragg / Simmons Army Airfield', 'KFBG', '37051', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1382, 'us', 'North Carolina', 'Gastonia, Gastonia Municipal Airport', 'KAKH', '37131', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1383, 'us', 'North Carolina', 'Greensboro, Piedmont Triad International Airport', 'KGSO', '37147', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1384, 'us', 'North Carolina', 'Hatteras, Mitchell Field', 'KHSE', '37055', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1385, 'us', 'North Carolina', 'Hickory, Hickory Regional Airport', 'KHKY', '37035', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1386, 'us', 'North Carolina', 'Hot Springs Aviation Weather Reporting Station', 'KHSS', '37115', 'kmrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1387, 'us', 'North Carolina', 'Jacksonville Automatic Weather Observing / Reporting System', 'KOAJ', '37131', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1388, 'us', 'North Carolina', 'Jacksonville, New River, Marine Corps Air Station', 'KNCA', '37131', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1389, 'us', 'North Carolina', 'Jefferson, Ashe County Airport', 'KGEV', '37009', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1390, 'us', 'North Carolina', 'Kenansville, Duplin County Airport', 'KDPL', '37061', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1391, 'us', 'North Carolina', 'Kinston / Stallings', 'KISO', '37107', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1392, 'us', 'North Carolina', 'Lumberton, Lumberton Municipal Airport', 'KLBT', '37155', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1393, 'us', 'North Carolina', 'Mackall U. S. Army Airfield', 'KHFF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1394, 'us', 'North Carolina', 'Manteo / Dare County Regional', 'KMQI', '37055', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1395, 'us', 'North Carolina', 'Maxton, Laurinburg-Maxton Airport', 'KMEB', '37155', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1396, 'us', 'North Carolina', 'Monroe, Monroe Airport', 'KEQY', '37179', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1397, 'us', 'North Carolina', 'Morganton, Morganton-Lenior Airport', 'KMRN', '37023', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1398, 'us', 'North Carolina', 'Mount Airy, Mount Airy/Surry County Airport', 'KMWK', '37089', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1399, 'us', 'North Carolina', 'New Bern, Craven County Regional Airport', 'KEWN', '37049', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1400, 'us', 'North Carolina', 'Newport', 'KMHX', '37031', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1401, 'us', 'North Carolina', 'North Wilkesboro, Wilkes County Airport', 'KUKF', '37131', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1402, 'us', 'North Carolina', 'Oracoke Coast Guard Station', 'K45W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1403, 'us', 'North Carolina', 'Oregon Inlet Coast Guard Station', 'K79W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1404, 'us', 'North Carolina', 'Piney Island, Bt-11 Bombing Range', 'KNBT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1405, 'us', 'North Carolina', 'Pitt-Greenville Airport', 'KPGV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1406, 'us', 'North Carolina', 'Pope Air Force Base', 'KPOB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1407, 'us', 'North Carolina', 'Raleigh / Durham, Raleigh-Durham International Airport', 'KRDU', '37183', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1408, 'us', 'North Carolina', 'Raleigh NEXRAD', 'KRAX', '37183', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1409, 'us', 'North Carolina', 'Roanoke Rapids, Halifax County Airport', 'KRZZ', '37083', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1410, 'us', 'North Carolina', 'Rocky Mount, Rocky Mount-Wilson Airport', 'KRWI', '37141', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1411, 'us', 'North Carolina', 'Rutherfordton, Rutherford County-Marchman Field Airport', 'KFQD', '37161', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1412, 'us', 'North Carolina', 'Salisbury, Rowan County Airport', 'KRUQ', '37159', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1413, 'us', 'North Carolina', 'Sanford, Sanford-Lee County Brick Field Airport', 'KW77', '37105', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1414, 'us', 'North Carolina', 'Seymour-Johnson Air Force Base', 'KGSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1415, 'us', 'North Carolina', 'South Port / Oak Island Coast Guard Station', 'K78W', '37019', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1416, 'us', 'North Carolina', 'Southern Pines Automatic Weather Observing / Reporting System', 'KSOP', '37019', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1417, 'us', 'North Carolina', 'Statesville, Statesville Municipal Airport', 'KSVH', '37097', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1418, 'us', 'North Carolina', 'Swansboro / Bogue', 'K3W4', '37133', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1419, 'us', 'North Carolina', 'Swansboro, Bogue Field, Marine Corps Auxiliary Landing Field', 'KNJM', '37133', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1420, 'us', 'North Carolina', 'Washington, Warren Field Airport', 'KOCW', '37013', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1421, 'us', 'North Carolina', 'Wilmington Nexrad', 'KLTX', '37129', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1422, 'us', 'North Carolina', 'Wilmington, New Hanover International Airport', 'KILM', '37129', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1423, 'us', 'North Carolina', 'Winston Salem, Smith Reynolds Airport', 'KINT', '37067', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1424, 'us', 'North Carolina', 'Wrightsville Beach', 'K1W9', '37129', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1425, 'us', 'North Dakota', 'Bismarck, Bismarck Municipal Airport', 'KBIS', '38015', 'kbis', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1426, 'us', 'North Dakota', 'Devils Lake', 'KP11', '38071', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1427, 'us', 'North Dakota', 'Devils Lake Automatic Weather Observing / Reporting System', 'KDVL', '38071', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1428, 'us', 'North Dakota', 'Dickinson, Dickinson Municipal Airport', 'KDIK', '38089', 'kbis', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1429, 'us', 'North Dakota', 'Fargo, Hector International Airport', 'KFAR', '38017', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1430, 'us', 'North Dakota', 'Garrison', 'KN60', '38055', 'kmbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1431, 'us', 'North Dakota', 'Grand Forks Air Force Base', 'KRDR', '38017', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1432, 'us', 'North Dakota', 'Grand Forks, Grand Forks International Airport', 'KGFK', '38017', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1433, 'us', 'North Dakota', 'Hettinger, Hettinger Municipal Airport', 'KHEI', '38001', 'kbis', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1434, 'us', 'North Dakota', 'Jamestown, Jamestown Municipal Airport', 'KJMS', '38093', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1435, 'us', 'North Dakota', 'Lidgerwood Remote Automatic Meteorological Observing System', 'KP67', '38077', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1436, 'us', 'North Dakota', 'Minot Air Force Base', 'KMIB', '38101', 'kmbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1437, 'us', 'North Dakota', 'Minot, Minot International Airport', 'KMOT', '38101', 'kmbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1438, 'us', 'North Dakota', 'Roseglen', 'KP24', '38055', 'kmbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1439, 'us', 'North Dakota', 'Williston, Sloulin Field International Airport', 'KISN', '38105', 'kmbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1440, 'us', 'Ohio', 'Akron, Akron Fulton International Airport', 'KAKR', '39153', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1441, 'us', 'Ohio', 'Akron, Akron-Canton Regional Airport', 'KCAK', '39153', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1442, 'us', 'Ohio', 'Ashtabula Coast Guard Station', 'K20G', '39007', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1443, 'us', 'Ohio', 'Ashtabula, Ashtabula County Airport', 'KSHI', '39007', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1444, 'us', 'Ohio', 'Cincinnati, Cincinnati Municipal Airport Lunken Field', 'KLUK', '39015', 'kiln', 'klvx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1445, 'us', 'Ohio', 'Cleveland / Cuyahoga', 'KCGF', '39061', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1446, 'us', 'Ohio', 'Cleveland Harbor Coast Guard Station', 'K23G', '39061', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1447, 'us', 'Ohio', 'Cleveland, Burke Lakefront Airport', 'KBKL', '39061', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1448, 'us', 'Ohio', 'Cleveland, Cleveland-Hopkins International Airport', 'KCLE', '39061', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1449, 'us', 'Ohio', 'Columbus / Bolton Field', 'K2I4', '39049', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1450, 'us', 'Ohio', 'Columbus, Bolton Field Airport', 'KTZR', '39049', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1451, 'us', 'Ohio', 'Columbus, Ohio State University Airport', 'KOSU', '39049', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1452, 'us', 'Ohio', 'Columbus, Port Columbus International Airport', 'KCMH', '39049', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1453, 'us', 'Ohio', 'Dayton / Wright-Patterson Air Force Base', 'KFFO', '39037', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1454, 'us', 'Ohio', 'Dayton, Cox Dayton International Airport', 'KDAY', '39037', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1455, 'us', 'Ohio', 'Dayton, Dayton General Airport South Airport', 'KMGY', '39037', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1456, 'us', 'Ohio', 'Defiance, Defiance Memorial Airport', 'KDFI', '39039', 'kiwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1457, 'us', 'Ohio', 'Findlay Automatic Weather Observing / Reporting System', 'KFDY', '39063', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1458, 'us', 'Ohio', 'Hamilton, Butler County Regional Airport', 'KHAO', '39017', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1459, 'us', 'Ohio', 'Lancaster, Fairfield County Airport', 'KLHQ', '39045', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1460, 'us', 'Ohio', 'Lima, Lima Allen County Airport', 'KAOH', '', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1461, 'us', 'Ohio', 'Lorain / Elyria, Lorain County Regional Airport', 'KLPR', '39093', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1462, 'us', 'Ohio', 'Lorain Coast Guard Station', 'K27G', '39093', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1463, 'us', 'Ohio', 'Mansfield, Mansfield Lahm Municipal Airport', 'KMFD', '39139', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1464, 'us', 'Ohio', 'Marblehead Coast Guard Station', 'K21G', '39123', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1465, 'us', 'Ohio', 'Marion, Marion Municipal Airport', 'KMNN', '39101', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1466, 'us', 'Ohio', 'New Philadelphia, Harry Clever Field', 'KPHD', '39163', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1467, 'us', 'Ohio', 'Newark, Newark Heath Airport', 'KVTA', '39089', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1468, 'us', 'Ohio', 'Ravenna / Portage County', 'K29G', '39133', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1469, 'us', 'Ohio', 'Rickenbacker Air National Guard Base', 'KLCK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1470, 'us', 'Ohio', 'Smithville / Wooster', 'KSLW', '39169', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1471, 'us', 'Ohio', 'Springfield Municipal', 'KSGH', '39023', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1472, 'us', 'Ohio', 'Toledo Coast Guard Station', 'K24G', '39095', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1473, 'us', 'Ohio', 'Toledo, Metcalf Field', 'KTDZ', '39095', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1474, 'us', 'Ohio', 'Toledo, Toledo Express Airport', 'KTOL', '39095', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1475, 'us', 'Ohio', 'Willoughby', 'KLNN', '39085', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1476, 'us', 'Ohio', 'Wilmington, Airborne Airpark Airport', 'KILN', '39027', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1477, 'us', 'Ohio', 'Wooster, Wayne County Airport', 'KBJJ', '39169', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1478, 'us', 'Ohio', 'Youngstown, Youngstown-Warren Regional Airport', 'KYNG', '39099', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1479, 'us', 'Ohio', 'Zanesville, Zanesville Municipal Airport', 'KZZV', '39119', 'kiln', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1480, 'us', 'Oklahoma', 'Altus Air Force Base', 'KLTS', '40065', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1481, 'us', 'Oklahoma', 'Ardmore Municipal', 'KADM', '40019', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1482, 'us', 'Oklahoma', 'Ardmore, Ardmore Downtown Executive Airport', 'K1F0', '40019', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1483, 'us', 'Oklahoma', 'Bartlesville, Bartlesville Municipal Airport', 'KBVO', '40147', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1484, 'us', 'Oklahoma', 'Clinton, Clinton-Sherman Airport', 'KCSM', '40039', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1485, 'us', 'Oklahoma', 'Enid / Woodring Municipal', 'KWDG', '40047', 'kvnx', 'kddc', 'kict')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1486, 'us', 'Oklahoma', 'Fort Sill', 'KFSI', '40023', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1487, 'us', 'Oklahoma', 'Frederick, Frederick Municipal Airport', 'KFDR', '40141', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1488, 'us', 'Oklahoma', 'Gage, Gage Airport', 'KGAG', '', 'kvnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1489, 'us', 'Oklahoma', 'Guthrie, Guthrie Municipal Airport', 'KGOK', '40083', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1490, 'us', 'Oklahoma', 'Guymon / Guymon Municipal Airport', 'KGUY', '40139', 'kama', 'kddc', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1491, 'us', 'Oklahoma', 'Henryetta Municipal', 'KF10', '40111', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1492, 'us', 'Oklahoma', 'Hobart, Hobart Municipal Airport', 'KHBR', '40075', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1493, 'us', 'Oklahoma', 'Hominy Municipal', 'KH92', '40113', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1494, 'us', 'Oklahoma', 'Lawton, Lawton Municipal Airport', 'KLAW', '40031', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1495, 'us', 'Oklahoma', 'McAlester, McAlester Regional Airport', 'KMLC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1496, 'us', 'Oklahoma', 'Muskogee, Davis Field', 'KMKO', '40101', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1497, 'us', 'Oklahoma', 'Norman / Max Westheimer', 'KOUN', '40027', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1498, 'us', 'Oklahoma', 'Oklahoma City Nexrad', 'KTLX', '40109', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1499, 'us', 'Oklahoma', 'Oklahoma City, Wiley Post Airport', 'KPWA', '40109', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1500, 'us', 'Oklahoma', 'Oklahoma City, Will Rogers World Airport', 'KOKC', '40109', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1501, 'us', 'Oklahoma', 'Ponca City, Ponca City Municipal Airport', 'KPNC', '40071', 'kvnx', 'kict', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1502, 'us', 'Oklahoma', 'Stillwater, Stillwater Municipal Airport', 'KSWO', '40119', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1503, 'us', 'Oklahoma', 'Sulphur Municipal', 'KF30', '40099', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1504, 'us', 'Oklahoma', 'Tinker Air Force Base', 'KTIK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1505, 'us', 'Oklahoma', 'Tulsa Nexrad', 'KINX', '40037', 'kinx', 'kict', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1506, 'us', 'Oklahoma', 'Tulsa, Jones Jr. Airport', 'KRVS', '40037', 'kinx', 'kict', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1507, 'us', 'Oklahoma', 'Tulsa, Tulsa International Airport', 'KTUL', '40037', 'kinx', 'kict', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1508, 'us', 'Oklahoma', 'Vance Air Force Base / Enid', 'KEND', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1509, 'us', 'Oklahoma', 'West Woodward', 'KWWR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1510, 'us', 'Oregon', 'Astoria, Astoria Regional Airport', 'KAST', '41007', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1511, 'us', 'Oregon', 'Aurora State', 'K3S2', '41047', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1512, 'us', 'Oregon', 'Aurora, Aurora State Airport', 'KUAO', '41047', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1513, 'us', 'Oregon', 'Baker, Baker Municipal Airport', 'KBKE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1514, 'us', 'Oregon', 'Brookings', 'K4BK', '41015', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1515, 'us', 'Oregon', 'Burns, Burns Municipal Airport', 'KBNO', '41025', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1516, 'us', 'Oregon', 'Cape Blanco Coast Guard Station', 'K92S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1517, 'us', 'Oregon', 'Cascade Locks State', 'KCZK', '41043', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1518, 'us', 'Oregon', 'Chetco River Coast Guard Station', 'KP47', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1519, 'us', 'Oregon', 'Coos Bay Coast Guard Station', 'K83S', '41011', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1520, 'us', 'Oregon', 'Corvallis Municipal Automatic Weather Observing / Reporting System', 'KCVO', '41003', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1521, 'us', 'Oregon', 'Eugene, Mahlon Sweet Field', 'KEUG', '41039', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1522, 'us', 'Oregon', 'Hermiston, Hermiston Municipal Airport', 'KHRI', '41059', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1523, 'us', 'Oregon', 'John Day, John Day State Airport', 'K5J0', '41023', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1524, 'us', 'Oregon', 'Klamath Falls, Klamath Falls International Airport', 'KLMT', '41035', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1525, 'us', 'Oregon', 'La Grande Automatic Weather Observing / Reporting System', 'KLGD', '41061', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1526, 'us', 'Oregon', 'Lakeview', 'K4LW', '41037', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1527, 'us', 'Oregon', 'Lakeview Automatic Weather Observing / Reporting System', 'KLKV', '41037', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1528, 'us', 'Oregon', 'McMinnville, McMinnville Municipal Airport', 'KMMV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1529, 'us', 'Oregon', 'Meacham, Meacham', 'KMEH', '41059', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1530, 'us', 'Oregon', 'Medford Nexrad', 'KMAX', '41029', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1531, 'us', 'Oregon', 'Medford, Rogue Valley International Airport', 'KMFR', '41029', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1532, 'us', 'Oregon', 'Newport', 'KJNW', '41041', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1533, 'us', 'Oregon', 'Newport Municipal', 'KONP', '41041', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1534, 'us', 'Oregon', 'North Bend Automatic Weather Observing / Reporting System', 'KOTH', '41061', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1535, 'us', 'Oregon', 'Ontario, Ontario Municipal Airport', 'KONO', '41045', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1536, 'us', 'Oregon', 'Pacific City State', 'KPFC', '41057', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1537, 'us', 'Oregon', 'Pendleton, Eastern Oregon Regional At Pendleton Airport', 'KPDT', '41059', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1538, 'us', 'Oregon', 'Portland NEXRAD', 'KRTX', '41005', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1539, 'us', 'Oregon', 'Portland, Portland International Airport', 'KPDX', '41005', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1540, 'us', 'Oregon', 'Portland, Portland-Hillsboro Airport', 'KHIO', '41005', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1541, 'us', 'Oregon', 'Portland, Portland-Troutdale Airport', 'KTTD', '41005', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1542, 'us', 'Oregon', 'Redmond Automatic Weather Observing / Reporting System', 'KRDM', '41017', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1543, 'us', 'Oregon', 'Rome Automatic Meteorological Observing System', 'KP88', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1544, 'us', 'Oregon', 'Rome, Rome', 'KREO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1545, 'us', 'Oregon', 'Roseburg, Roseburg Regional Airport', 'KRBG', '41019', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1546, 'us', 'Oregon', 'Salem, McNary Field', 'KSLE', '41053', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1547, 'us', 'Oregon', 'Scappoose, Scappoose Industrial Airpark', 'KSPB', '41009', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1548, 'us', 'Oregon', 'Sexton Summit', 'KSXT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1549, 'us', 'Oregon', 'Siuslaw River Coast Guard Station', 'K85S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1550, 'us', 'Oregon', 'Sunriver', 'KS21', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1551, 'us', 'Oregon', 'The Dalles, The Dalles Municipal Airport', 'KDLS', '41065', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1552, 'us', 'Oregon', 'Tilamook', 'KS47', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1553, 'us', 'Oregon', 'Tillamook Bay Coast Guard Station', 'K88S', '41057', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1554, 'us', 'Oregon', 'Umpqua River Coast Guard Station', 'K90S', '41019', 'kmax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1555, 'us', 'Oregon', 'Yaquina Bay Coast Guard Station', 'K95S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1556, 'us', 'Pennsylvania', 'Allentown, Lehigh Valley International Airport', 'KABE', '42119', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1557, 'us', 'Pennsylvania', 'Altoona, Altoona-Blair County Airport', 'KAOO', '42013', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1558, 'us', 'Pennsylvania', 'Beaver Falls Airport', 'KBVI', '42007', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1559, 'us', 'Pennsylvania', 'Bradford, Bradford Regional Airport', 'KBFD', '42083', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1560, 'us', 'Pennsylvania', 'Butler County Automatic Weather Observing / Reporting System', 'KBTP', '42019', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1561, 'us', 'Pennsylvania', 'Chester County Airport', 'K40N', '42051', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1562, 'us', 'Pennsylvania', 'Clearfield, Clearfield-Lawrence Airport', 'KFIG', '42009', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1563, 'us', 'Pennsylvania', 'Doylestown, Doylestown Airport', 'KDYL', '42017', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1564, 'us', 'Pennsylvania', 'Du Bois Automatic Weather Observing / Reporting System', 'KDUJ', '42033', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1565, 'us', 'Pennsylvania', 'Erie Coast Guard Station', 'K25G', '42049', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1566, 'us', 'Pennsylvania', 'Erie, Erie International Airport', 'KERI', '42049', 'kbuf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1567, 'us', 'Pennsylvania', 'Franklin Automatic Weather Observing / Reporting System', 'KFKL', '42013', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1568, 'us', 'Pennsylvania', 'Harrisburg, Capital City Airport', 'KCXY', '42019', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1569, 'us', 'Pennsylvania', 'Harrisburg, Harrisburg International Airport', 'KMDT', '42019', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1570, 'us', 'Pennsylvania', 'Indiana / Stewart Field', 'KIDI', '', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1571, 'us', 'Pennsylvania', 'Johnstown, Johnstown-Cambria County Airport', 'KJST', '42021', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1572, 'us', 'Pennsylvania', 'Lancaster, Lancaster Airport', 'KLNS', '42071', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1573, 'us', 'Pennsylvania', 'Latrobe / Westmorland', 'KLBE', '42129', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1574, 'us', 'Pennsylvania', 'Meadville, Port Meadville Airport', 'KGKJ', '42039', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1575, 'us', 'Pennsylvania', 'Mount Pocono, Pocono Mountains Municipal Airport', 'KMPO', '42071', 'kbgm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1576, 'us', 'Pennsylvania', 'Muir Army Air Field / Indiantown', 'KMUI', '42107', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1577, 'us', 'Pennsylvania', 'Philadelphia NEXRAD', 'KDIX', '42101', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1578, 'us', 'Pennsylvania', 'Philadelphia, Northeast Philadelphia Airport', 'KPNE', '42101', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1579, 'us', 'Pennsylvania', 'Philadelphia, Philadelphia International Airport', 'KPHL', '42101', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1580, 'us', 'Pennsylvania', 'Pittsburgh Nexrad', 'KPBZ', '42079', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1581, 'us', 'Pennsylvania', 'Pittsburgh, Allegheny County Airport', 'KAGC', '42079', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1582, 'us', 'Pennsylvania', 'Pittsburgh, Pittsburgh International Airport', 'KPIT', '42079', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1583, 'us', 'Pennsylvania', 'Pottstown, Pottstown Limerick Airport', 'KPTW', '42107', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1584, 'us', 'Pennsylvania', 'Reading, Reading Regional Airport', 'KRDG', '42011', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1585, 'us', 'Pennsylvania', 'Reedsville / Mifflin', 'KRVL', '42087', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1586, 'us', 'Pennsylvania', 'Selinsgrove, Penn Valley Airport', 'KSEG', '42109', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1587, 'us', 'Pennsylvania', 'State College', 'KUNV', '42055', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1588, 'us', 'Pennsylvania', 'State College Nexrad', 'KCCX', '42055', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1589, 'us', 'Pennsylvania', 'Washington Automatic Weather Observing / Reporting System', 'KAFJ', '42125', 'kpbz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1590, 'us', 'Pennsylvania', 'Wilkes-Barre - Scranton, Wilkes-Barre / Scranton International Airport', 'KAVP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1591, 'us', 'Pennsylvania', 'Williamsport, Williamsport-Lycoming County Airport', 'KIPT', '42029', 'kccx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1592, 'us', 'Pennsylvania', 'Willow Grove, Naval Air Station', 'KNXX', '42071', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1593, 'us', 'Pennsylvania', 'York, York Airport', 'KTHV', '', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1594, 'us', 'Puerto Rico', 'Roosevelt Roads, Naval Station', 'TJNR', '72037', 'tjua', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1595, 'us', 'Puerto Rico', 'San Juan, Marin International Airport', 'KSJU', '72127', 'tjua', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1596, 'us', 'Rhode Island', 'Block Island Automatic Weather Observing / Reporting System', 'KBID', '44009', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1597, 'us', 'Rhode Island', 'Castle Hill Coast Guard Station', 'K67B', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1598, 'us', 'Rhode Island', 'N. Kingston / Quonset', 'KOQU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1599, 'us', 'Rhode Island', 'Newport, Newport State Airport', 'KUUU', '44005', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1600, 'us', 'Rhode Island', 'Pawtucket Automatic Weather Observing / Reporting System', 'KSFZ', '44007', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1601, 'us', 'Rhode Island', 'Point Judith Coast Guard Station', 'KPJI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1602, 'us', 'Rhode Island', 'Providence, Green State Airport', 'KPVD', '44007', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1603, 'us', 'Rhode Island', 'Westerly, Westerly State Airport', 'KWST', '44009', 'kbox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1604, 'us', 'South Carolina', 'Anderson, Anderson County Airport', 'KAND', '45007', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1605, 'us', 'South Carolina', 'Beaufort, Marine Corps Air Station', 'KNBC', '45013', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1606, 'us', 'South Carolina', 'Charleston Air Force Base', 'KIGC', '45019', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1607, 'us', 'South Carolina', 'Charleston Nise', 'KNEX', '45019', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1608, 'us', 'South Carolina', 'Charleston, Charleston Air Force Base', 'KCHS', '45019', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1609, 'us', 'South Carolina', 'Charleston, Navelexcen', 'NEXC', '45019', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1610, 'us', 'South Carolina', 'Clemson, Clemson-Oconee County Airport', 'KCEU', '45077', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1611, 'us', 'South Carolina', 'Columbia, Columbia Metropolitan Airport', 'KCAE', '45079', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1612, 'us', 'South Carolina', 'Columbia, Columbia Owens Downtown Airport', 'KCUB', '45079', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1613, 'us', 'South Carolina', 'Florence, Florence Regional Airport', 'KFLO', '45041', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1614, 'us', 'South Carolina', 'Folly Beach Long Range Navigation', 'K84J', '45019', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1615, 'us', 'South Carolina', 'Georgetown Coast Guard Light Station', 'K85J', '45043', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1616, 'us', 'South Carolina', 'Greenville, Greenville Downtown Airport', 'KGMU', '45047', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1617, 'us', 'South Carolina', 'Greenwood, Greenwood County Airport', 'KGRD', '45047', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1618, 'us', 'South Carolina', 'Greer, Greenville-Spartanburg Airport', 'KGSP', '45045', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1619, 'us', 'South Carolina', 'Hilton Head Automatic Weather Observing / Reporting System', 'KHXD', '45013', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1620, 'us', 'South Carolina', 'Manning / Cooper Regional', 'KMNI', '45027', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1621, 'us', 'South Carolina', 'McEntire Air National Guard Weather Facility Base', 'KMMT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1622, 'us', 'South Carolina', 'Myrtle Beach Air Force Base', 'KMYR', '45051', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1623, 'us', 'South Carolina', 'North Myrtle Beach, Grand Strand Airport', 'KCRE', '45075', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1624, 'us', 'South Carolina', 'Orangeburg, Orangeburg Municipal Airport', 'KOGB', '45075', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1625, 'us', 'South Carolina', 'Poinsett Range, Sumpter', 'K2PJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1626, 'us', 'South Carolina', 'Rock Hill, Rock Hill - York County Airport', 'KUZA', '45091', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1627, 'us', 'South Carolina', 'Shaw Air Force Base', 'KSSC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1628, 'us', 'South Carolina', 'Sullivans Island Coast Guard Station', 'K86J', '45019', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1629, 'us', 'South Carolina', 'Spartanburg Memorial', 'KSPA', '45083', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1630, 'us', 'South Dakota', 'Aberdeen, Aberdeen Regional Airport', 'KABR', '46013', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1631, 'us', 'South Dakota', 'Belle Fourche, Belle Fourche Municipal Airport', 'KEFC', '46019', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1632, 'us', 'South Dakota', 'Brookings Automatic Weather Observing / Reporting System', 'KBKX', '46011', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1633, 'us', 'South Dakota', 'Buffalo', 'K2WX', '46063', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1634, 'us', 'South Dakota', 'Chamberlain, Chamberlain Municipal Airport', 'K9V9', '46015', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1635, 'us', 'South Dakota', 'Custer, Custer County Airport', 'KCUT', '46033', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1636, 'us', 'South Dakota', 'Ellsworth Air Force Base', 'KRCA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1637, 'us', 'South Dakota', 'Faith', 'KD07', '46093', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1638, 'us', 'South Dakota', 'Huron, Huron Regional Airport', 'KHON', '46005', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1639, 'us', 'South Dakota', 'Lemmon', 'KY22', '46105', 'kbis', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1640, 'us', 'South Dakota', 'Mitchell, Mitchell Municipal Airport', 'KMHE', '46035', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1641, 'us', 'South Dakota', 'Mobridge', 'KY26', '46129', 'kbis', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1642, 'us', 'South Dakota', 'Mobridge, Mobridge Municipal Airport', 'KMBG', '46129', 'kbis', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1643, 'us', 'South Dakota', 'Philip, Philip Airport', 'KPHP', '46055', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1644, 'us', 'South Dakota', 'Pierre, Pierre Regional Airport', 'KPIR', '46065', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1645, 'us', 'South Dakota', 'Pine Ridge, Pine Ridge Airport', 'KIEN', '46113', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1646, 'us', 'South Dakota', 'Rapid City, Rapid City Regional Airport', 'KRAP', '46103', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1647, 'us', 'South Dakota', 'Sioux Falls, Foss Field', 'KFSD', '46099', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1648, 'us', 'South Dakota', 'Sisseton, Sisseton Municipal Airport', 'K8D3', '46109', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1649, 'us', 'South Dakota', 'Spearfish / Clyde Ice', 'KSPF', '46081', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1650, 'us', 'South Dakota', 'Watertown, Watertown Municipal Airport', 'KATY', '46029', 'kabr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1651, 'us', 'South Dakota', 'Winner - Bob Wiley Field', 'KSFD', '46123', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1652, 'us', 'South Dakota', 'Winner, Wiley Field', 'KNED', '46123', 'klnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1653, 'us', 'South Dakota', 'Yankton Automatic Weather Observing / Reporting System', 'KYKN', '46135', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1654, 'us', 'Tennessee', 'Bristol / Johnson / Kingsport, Tri-City Regional Airport', 'KTRI', '47163', 'kmrx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1655, 'us', 'Tennessee', 'Chattanooga / Daisy', 'KCQN', '47065', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1656, 'us', 'Tennessee', 'Chattanooga, Lovell Field', 'KCHA', '47065', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1657, 'us', 'Tennessee', 'Clarksville, Outlaw Field', 'KCKV', '47125', 'khpx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1658, 'us', 'Tennessee', 'Columbia / Maury County', 'KMRC', '47119', 'kohx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1659, 'us', 'Tennessee', 'Crossville, Crossville Memorial-whitson field Airport', 'KCSV', '47035', 'kohx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1660, 'us', 'Tennessee', 'Dyersburg Automatic Weather Observing / Reporting System', 'KDYR', '47045', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1661, 'us', 'Tennessee', 'Jackson, McKellar-Sipes Regional Airport', 'KMKL', '47113', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1662, 'us', 'Tennessee', 'Knoxville Downtown', 'KDKX', '47093', 'kmrx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1663, 'us', 'Tennessee', 'Knoxville, McGhee Tyson Airport', 'KTYS', '47093', 'kmrx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1664, 'us', 'Tennessee', 'Memphis, Memphis International Airport', 'KMEM', '47157', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1665, 'us', 'Tennessee', 'Millington, Millington Municipal Airport', 'KNQA', '47157', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1666, 'us', 'Tennessee', 'Morristown Nexrad', 'KMRX', '47063', 'kmrx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1667, 'us', 'Tennessee', 'Nashville NEXRAD', 'KOHX', '47037', 'kohx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1668, 'us', 'Tennessee', 'Nashville, Nashville International Airport', 'KBNA', '47037', 'kohx', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1669, 'us', 'Tennessee', 'Oak Ridge', 'KOQT', '47001', 'kmrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1670, 'us', 'Tennessee', 'Smyrna', 'KMQY', '47149', 'kohx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1671, 'us', 'Texas', 'Abilene, Abilene Regional Airport', 'KABI', '48441', 'kdyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1672, 'us', 'Texas', 'Abilene, Dyess Air Force Base', 'KDYS', '48441', 'kdyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1673, 'us', 'Texas', 'Alice, Alice International Airport', 'KALI', '48249', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1674, 'us', 'Texas', 'Amarillo, Amarillo International Airport', 'KAMA', '48381', 'kama', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1675, 'us', 'Texas', 'Angleton / Lake Jackson, Brazoria County Airport', 'KLBX', '48039', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1676, 'us', 'Texas', 'Arlington, Arlington Municipal Airport', 'KGKY', '48439', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1677, 'us', 'Texas', 'Beaumont / Port Arthur, Jefferson County Airport', 'KBPT', '48245', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1678, 'us', 'Texas', 'Bergstrom, Austin-Bergstrom International Airport', 'KAUS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1679, 'us', 'Texas', 'Biggs Army Air Field / Ft. Bliss', 'KBIF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1680, 'us', 'Texas', 'Borger, Hutchinson County Airport', 'KBGD', '48233', 'kama', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1681, 'us', 'Texas', 'Brownsville, Brownsville / South Padre Island International Airport', 'KBRO', '48049', 'kbro', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1682, 'us', 'Texas', 'Brownwood Municipal', 'KBWD', '48049', 'kdyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1683, 'us', 'Texas', 'Burnet, Burnet Municipal Craddock Field', 'KBMQ', '48053', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1684, 'us', 'Texas', 'Camp Mabry / Austin City', 'KATT', '48385', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1685, 'us', 'Texas', 'Canadian / Hemphill', 'KHHF', '48211', 'kama', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1686, 'us', 'Texas', 'Childress, Childress Municipal Airport', 'KCDS', '48075', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1687, 'us', 'Texas', 'College Station, Easterwood Field', 'KCLL', '48439', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1688, 'us', 'Texas', 'Conroe, Montgomery County Airport', 'KCXO', '48339', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1689, 'us', 'Texas', 'Corpus Christi, Cabiness Field, Naval Auxiliary Landing Field', 'KNGW', '48355', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1690, 'us', 'Texas', 'Corpus Christi, Corpus Christi International Airport', 'KCRP', '48355', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1691, 'us', 'Texas', 'Corpus Christi, Naval Air Station', 'KNGP', '48355', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1692, 'us', 'Texas', 'Corpus Christi, Waldron Outlying Landing Field', 'KNVT', '48355', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1693, 'us', 'Texas', 'Corsicana, Campbell Field-Corsicana Municipal Airport', 'KCRS', '48349', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1694, 'us', 'Texas', 'Cotulla, Cotulla-La Salle County Airport', 'KCOT', '48283', 'kdfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1695, 'us', 'Texas', 'Dalhart, Dalhart Municipal Airport', 'KDHT', '48111', 'kama', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1696, 'us', 'Texas', 'Dallas / Addison Airport', 'KADS', '48113', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1697, 'us', 'Texas', 'Dallas / Fort Worth, Dallas / Fort Worth International Airport', 'KDFW', '48113', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1698, 'us', 'Texas', 'Dallas United States Naval Air Station', 'KNBE', '48113', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1699, 'us', 'Texas', 'Dallas, Dallas Love Field', 'KDAL', '48113', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1700, 'us', 'Texas', 'Dallas, Redbird Airport', 'KRBD', '48113', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1701, 'us', 'Texas', 'Del Rio, Del Rio International Airport', 'KDRT', '48465', 'kdfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1702, 'us', 'Texas', 'Denton, Denton Municipal Airport', 'KDTO', '48121', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1703, 'us', 'Texas', 'DFW Nexrad', 'KFWS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1704, 'us', 'Texas', 'Dryden, Terrel County Airport', 'K6R6', '48443', 'kdfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1705, 'us', 'Texas', 'East Addition B323', 'K5R0', '48481', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1706, 'us', 'Texas', 'El Paso, El Paso International Airport', 'KELP', '48141', 'kepz', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1707, 'us', 'Texas', 'Fort Hood', 'KHLR', '48439', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1708, 'us', 'Texas', 'Fort Hood / Gray U. S. Army Airfield', 'KGRK', '48439', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1709, 'us', 'Texas', 'Fort Stockton, Fort Stockton-Pecos County Airport', 'KFST', '48439', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1710, 'us', 'Texas', 'Fort Worth', 'KFWD', '48439', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1711, 'us', 'Texas', 'Fort Worth, Fort Worth Alliance Airport', 'KAFW', '48439', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1712, 'us', 'Texas', 'Fort Worth, Meacham International Airport', 'KFTW', '48439', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1713, 'us', 'Texas', 'Fort Worth, Naval Air Station', 'KNFW', '48439', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1714, 'us', 'Texas', 'Freeport Coast Guard Station', 'K8R8', '48039', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1715, 'us', 'Texas', 'Freeport Supplementary Aviation Weather Reporting Station', 'KFOQ', '48039', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1716, 'us', 'Texas', 'Galveston Coast Guard Station', 'K9R0', '48167', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1717, 'us', 'Texas', 'Galveston, Scholes Field', 'KGLS', '48167', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1718, 'us', 'Texas', 'Georgetown Automatic Weather Observing / Reporting System', 'KGTU', '48491', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1719, 'us', 'Texas', 'Greenville / Majors', 'KGVT', '48497', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1720, 'us', 'Texas', 'Harlingen, Rio Grande Valley International Airport', 'KHRL', '48061', 'kbro', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1721, 'us', 'Texas', 'Hondo, Hondo Municipal Airport', 'KHDO', '48325', 'kdfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1722, 'us', 'Texas', 'Houston / Ellington', 'KEFD', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1723, 'us', 'Texas', 'Houston / Galviston Nexrad', 'KHGX', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1724, 'us', 'Texas', 'Houston, Clover Field', 'KLVJ', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1725, 'us', 'Texas', 'Houston, Hooks Memorial Airport', 'KDWH', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1726, 'us', 'Texas', 'Houston, Houston Hobby Airport', 'KHOU', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1727, 'us', 'Texas', 'Houston, Houston Intercontinental Airport', 'KIAH', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1728, 'us', 'Texas', 'Houston, Sugar Land Municipal/Hull Field Airport', 'KSGR', '48201', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1729, 'us', 'Texas', 'Huntsville, Huntsville Municipal Airport', 'KUTS', '48471', 'kdfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1730, 'us', 'Texas', 'Junction, Kimble County Airport', 'KJCT', '48267', 'ksjt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1731, 'us', 'Texas', 'Kelly Air Force Base', 'KSKF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1732, 'us', 'Texas', 'Kerrville Municipal', 'KERV', '48265', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1733, 'us', 'Texas', 'Killeen Municipal Automatic Weather Observing / Reporting System', 'KILE', '48027', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1734, 'us', 'Texas', 'Kingsville, Naval Air Station', 'KNQI', '48273', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1735, 'us', 'Texas', 'Laredo International Airport', 'KLRD', '48479', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1736, 'us', 'Texas', 'Laughlin, Laughlin Air Force Base Auxiliary Airfield', 'KDLF', '', 'kdfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1737, 'us', 'Texas', 'Longview, Gregg County Airport', 'KGGG', '48183', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1738, 'us', 'Texas', 'Lubbock, Lubbock International Airport', 'KLBB', '48303', 'klbb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1739, 'us', 'Texas', 'Lufkin, Angelina County Airport', 'KLFK', '48005', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1740, 'us', 'Texas', 'Marfa', 'KMRF', '48377', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1741, 'us', 'Texas', 'Mc Gregor Automatic Weather Observing / Reporting System', 'KPWG', '48309', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1742, 'us', 'Texas', 'McAllen, Miller International Airport', 'KMFE', '', 'kbro', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1743, 'us', 'Texas', 'McKinney, McKinney Municipal Airport', 'KTKI', '', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1744, 'us', 'Texas', 'McMullen, McMullen Target Site', 'KNMT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1745, 'us', 'Texas', 'Midland, Midland International Airport', 'KMAF', '48329', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1746, 'us', 'Texas', 'Mineral Wells, Mineral Wells Airport', 'KMWL', '48025', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1747, 'us', 'Texas', 'Nacogdoches Automatic Weather Observing / Reporting System', 'KOCH', '48347', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1748, 'us', 'Texas', 'New Braunfels, New Braunfels Municipal Airport', 'KBAZ', '48091', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1749, 'us', 'Texas', 'Odessa, Odessa-Schlemeyer Field', 'KODO', '48135', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1750, 'us', 'Texas', 'Orange Grove, Naval Auxiliary Landing Field', 'KNOG', '48361', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1751, 'us', 'Texas', 'Palacios Municipal', 'KPSX', '48321', 'khgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1752, 'us', 'Texas', 'Paris / Cox Field', 'KPRX', '48277', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1754, 'us', 'Texas', 'Port Aransas Coast Guard Station', 'K9R1', '48057', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1755, 'us', 'Texas', 'Port Isabel, Port Isabel-Cameron County Airport', 'KPIL', '48057', 'kbro', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1756, 'us', 'Texas', 'Randolph Air Force Base', 'KRND', '48147', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1757, 'us', 'Texas', 'Reese Air Force Base / Lubbock', 'KREE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1758, 'us', 'Texas', 'Rockport, Aransas County Airport', 'KRKP', '48007', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1759, 'us', 'Texas', 'Sabine Pass', 'KRPE', '48245', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1760, 'us', 'Texas', 'Sabine Pass Coast Guard Station', 'K8R7', '48245', 'klch', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1761, 'us', 'Texas', 'San Angelo, Mathis Field', 'KSJT', '48405', 'ksjt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1762, 'us', 'Texas', 'San Antonio Nexrad', 'KSAT', '48405', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1763, 'us', 'Texas', 'San Antonio, San Antonio International Airport', 'KSAT', '48405', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1764, 'us', 'Texas', 'San Antonio, Stinson Municipal Airport', 'KSSF', '48405', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1765, 'us', 'Texas', 'San Marcos Automatic Weather Observing / Reporting System', 'KRJO', '48209', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1766, 'us', 'Texas', 'San Marcos, San Marcos Municipal Airport', 'KHYI', '48209', 'kewx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1767, 'us', 'Texas', 'Sanderson', 'KP07', '48443', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1768, 'us', 'Texas', 'Sheppard Air Force Base', 'KSHP', '', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1769, 'us', 'Texas', 'Sherman-Denison', 'KF39', '48181', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1770, 'us', 'Texas', 'South Brazos A70', 'KT46', '48181', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1771, 'us', 'Texas', 'Stephenville / Clark Field Municipal, Tx.', 'KSEP', '48143', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1772, 'us', 'Texas', 'Temple / Miller Automatic Weather Observing / Reporting System', 'KTPL', '48027', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1773, 'us', 'Texas', 'Terrell, Terrell Municipal Airport', 'KTRL', '48257', 'kfws', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1774, 'us', 'Texas', 'Tyler, Tyler Pounds Field', 'KTYR', '48423', 'kshv', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1775, 'us', 'Texas', 'Victoria, Victoria Regional Airport', 'KVCT', '48469', 'kcrp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1776, 'us', 'Texas', 'Waco, Waco Regional Airport', 'KACT', '', 'kgrk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1777, 'us', 'Texas', 'West Houston / Lakeside', 'KIWS', '48309', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1778, 'us', 'Texas', 'Wichita Falls, Sheppard Air Force Base', 'KSPS', '48485', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1779, 'us', 'Texas', 'Wink, Winkler County Airport', 'KINK', '', 'kmaf', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1780, 'us', 'Utah', 'Blanding', 'K4BL', '49037', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1781, 'us', 'Utah', 'Bryce Canyon, Bryce Canyon Airport', 'KBCE', '49017', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1782, 'us', 'Utah', 'Bullfrog Marina', 'KU17', '49037', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1783, 'us', 'Utah', 'Cedar City, Cedar City Municipal Airport', 'KCDC', '49049', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1784, 'us', 'Utah', 'Delta', 'KU24', '49027', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1785, 'us', 'Utah', 'Dugway Proving Grounds', 'KDPG', '49045', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1786, 'us', 'Utah', 'Eagle Range', 'KU16', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1787, 'us', 'Utah', 'Green River Range', 'KU28', '49031', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1788, 'us', 'Utah', 'Hanksville', 'K4HV', '49055', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1789, 'us', 'Utah', 'Hill Air Force Base / Ogden', 'KHIF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1790, 'us', 'Utah', 'Logan, Logan-Cache Airport', 'KLGU', '49005', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1791, 'us', 'Utah', 'Milford, Milford Municipal Airport', 'KMLF', '49001', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1792, 'us', 'Utah', 'Moab, Canyonlands Field', 'KCNY', '', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1793, 'us', 'Utah', 'Ogden, Ogden-Hinckley Airport', 'KOGD', '49057', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1794, 'us', 'Utah', 'Price, Carbon County Airport', 'KPUC', '49007', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1795, 'us', 'Utah', 'Provo Municipal Automatic Weather Observing / Reporting System', 'KPVU', '49049', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1796, 'us', 'Utah', 'Roosevelt', 'KU67', '49013', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1797, 'us', 'Utah', 'Saint George Automatic Weather Observing / Reporting System', 'KSGU', '49053', 'kicx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1798, 'us', 'Utah', 'Salt Lake City', 'KZLC', '', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1799, 'us', 'Utah', 'Salt Lake City, Salt Lake City International Airport', 'KSLC', '', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1800, 'us', 'Utah', 'Salt Lake Nexrad', 'KMTX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1801, 'us', 'Utah', 'Tooele', 'KT62', '49045', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1802, 'us', 'Utah', 'Vernal', 'KU71', '49047', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1803, 'us', 'Utah', 'Vernal, Vernal Airport', 'KVEL', '49047', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1804, 'us', 'Utah', 'Wendover / Air Force Auxillary Field', 'KENV', '49045', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1805, 'us', 'U.S. Virgin Islands', 'Charlotte Amalie, King Airport', 'KSTT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1806, 'us', 'U.S. Virgin Islands', 'Christiansted, Hamilton Airport', 'KSTX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1807, 'us', 'Vermont', 'Barre / Montpelier, Knapp State Airport', 'KMPV', '50023', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1808, 'us', 'Vermont', 'Bennington, Bennington Morse State Airport', 'KDDH', '50003', 'kenx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1809, 'us', 'Vermont', 'Burlington, Burlington International Airport', 'KBTV', '50007', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1810, 'us', 'Vermont', 'Morrisville, Morrisville-Stowe State Airport', 'KMVL', '50015', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1811, 'us', 'Vermont', 'Newport', 'K9B2', '50019', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1812, 'us', 'Vermont', 'Rutland State Automatic Weather Observing / Reporting System', 'KRUT', '50021', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1813, 'us', 'Vermont', 'Saint Johnsbury', 'K1V4', '50005', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1814, 'us', 'Vermont', 'Springfield, Hartness State Springfield Airport', 'KVSF', '50027', 'kcxx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1815, 'us', 'Virginia', 'Abingdon', 'KVJI', '51191', 'kmrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1816, 'us', 'Virginia', 'Ashland, Hanover County Municipal Airport', 'KOFP', '51085', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1817, 'us', 'Virginia', 'Cape Charles Coast Guard Station', 'KW51', '', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1818, 'us', 'Virginia', 'Cape Henry Coast Guard Light Station', 'K62W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1819, 'us', 'Virginia', 'Charlottesville, Charlottesville-Albemarle Airport', 'KCHO', '51540', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1820, 'us', 'Virginia', 'Chesapeake, Chesapeake Municipal Airport', 'KCPK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1821, 'us', 'Virginia', 'Chincoteague', 'K0W8', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1822, 'us', 'Virginia', 'Clarksville / Marks', 'KW63', '51117', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1823, 'us', 'Virginia', 'Culpeper, Culpeper County Airport', 'KCJR', '51047', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1824, 'us', 'Virginia', 'Danville, Danville Regional Airport', 'KDAN', '51590', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1825, 'us', 'Virginia', 'Dublin / New River Valley', 'KPSK', '51155', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1826, 'us', 'Virginia', 'Farmville', 'KFVX', '51147', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1827, 'us', 'Virginia', 'Fentress, Naval Auxiliary Landing Field', 'KNFE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1828, 'us', 'Virginia', 'Fort Belvoir', 'KDAA', '51171', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1829, 'us', 'Virginia', 'Fort Eustis / Felker', 'KFAF', '51171', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1830, 'us', 'Virginia', 'Franklin / J B Rose', 'KFKN', '51131', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1831, 'us', 'Virginia', 'Ft. Pickett / Blackstone', 'KBKT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1832, 'us', 'Virginia', 'Hillsville', 'KHLX', '51035', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1833, 'us', 'Virginia', 'Hot Springs / Ingalls', 'KHSP', '51017', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1834, 'us', 'Virginia', 'Langley Air Force Base', 'KLFI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1835, 'us', 'Virginia', 'Leesburg / Godfrey', 'KJYO', '51107', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1836, 'us', 'Virginia', 'Lynchburg, Lynchburg Regional Airport', 'KLYH', '51680', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1837, 'us', 'Virginia', 'Manassas Municipal Automatic Weather Observing / Reporting System', 'KHEF', '51685', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1838, 'us', 'Virginia', 'Marion / Wytheville', 'KMKJ', '51173', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1839, 'us', 'Virginia', 'Martinsville', 'KMTV', '51690', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1840, 'us', 'Virginia', 'Melfa / Accomack Airport', 'KMFV', '51001', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1841, 'us', 'Virginia', 'Milford Haven Coast Guard Station', 'K63W', '51033', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1842, 'us', 'Virginia', 'Newport News, Newport News / Williamsburg International Airport', 'KPHF', '51071', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1843, 'us', 'Virginia', 'Norfolk / Chesapeak', 'KW39', '51810', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1844, 'us', 'Virginia', 'Norfolk, Naval Air Station', 'KNGU', '51810', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1845, 'us', 'Virginia', 'Norfolk, Norfolk International Airport', 'KORF', '51810', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1846, 'us', 'Virginia', 'Parramore Beach', 'K64W', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1847, 'us', 'Virginia', 'Petersburg Automatic Weather Observing / Reporting System', 'KPTB', '51730', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1848, 'us', 'Virginia', 'Quantico, Marine Corps Air Facility', 'KNYG', '51153', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1849, 'us', 'Virginia', 'Richmond, Richmond International Airport', 'KRIC', '51760', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1850, 'us', 'Virginia', 'Roanoke NEXRAD', 'KFCX', '51770', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1851, 'us', 'Virginia', 'Roanoke, Roanoke Regional Airport', 'KROA', '51770', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1852, 'us', 'Virginia', 'Shannon Airport', 'KEZF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1853, 'us', 'Virginia', 'Smith Point / Sunnybank', 'KW71', '51093', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1854, 'us', 'Virginia', 'South Hill, Mecklenburg-Brunswick Regional Airport', 'KAVC', '51175', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1855, 'us', 'Virginia', 'Staunton / Shenandoah', 'KSHD', '51790', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1856, 'us', 'Virginia', 'Suffolk, Suffolk Municipal Airport', 'KSFQ', '51800', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1857, 'us', 'Virginia', 'Virginia Beach, Oceana, Naval Air Station', 'KNTU', '', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1858, 'us', 'Virginia', 'Virginia Tech Airport', 'KBCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1859, 'us', 'Virginia', 'Volens', 'KVQN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1860, 'us', 'Virginia', 'Wakefield, Wakefield Municipal Airport', 'KAKQ', '51183', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1861, 'us', 'Virginia', 'Wallops Island, Wallops Flight Facility Airport', 'KWAL', '51001', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1862, 'us', 'Virginia', 'Washington DC, Reagan National Airport', 'KDCA', '51157', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1863, 'us', 'Virginia', 'Washington DC, Washington-Dulles International Airport', 'KIAD', '51157', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1864, 'us', 'Virginia', 'Weirwood / Kellam Field', 'KW08', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1865, 'us', 'Virginia', 'Winchester Regional', 'KOKV', '51840', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1866, 'us', 'Virginia', 'Wise / Lonesome Pine', 'KLNP', '51195', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1867, 'us', 'Washington', 'Alki Point Coast Guard Light Station', 'K91S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1868, 'us', 'Washington', 'Arlington Automatic Weather Observing / Reporting System', 'KS88', '53061', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1869, 'us', 'Washington', 'Arlington Municipal', 'KAWO', '53061', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1870, 'us', 'Washington', 'Auburn', 'KZSE', '53033', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1871, 'us', 'Washington', 'Bellingham, Bellingham International Airport', 'KBLI', '53073', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1872, 'us', 'Washington', 'Bremerton National Automatic Weather Observing / Reporting System', 'KPWT', '53035', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1873, 'us', 'Washington', 'Burlington / Mt Vern', 'K75S', '53057', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1874, 'us', 'Washington', 'Burrows Island', 'KS38', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1875, 'us', 'Washington', 'Cape Disappointment', 'K82S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1876, 'us', 'Washington', 'Cape Flattery Coast Guard Light Station', 'K93S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1877, 'us', 'Washington', 'Colville Municipal', 'KCQV', '53065', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1878, 'us', 'Washington', 'Coupeville, Outlying Landing Field', 'KNRA', '53029', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1879, 'us', 'Washington', 'Deer Park, Deer Park Airport', 'KDEW', '53063', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1880, 'us', 'Washington', 'Destruction Island', 'KS53', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1881, 'us', 'Washington', 'Ellensburg, Ellensburg Bowers Field', 'KELN', '53037', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1882, 'us', 'Washington', 'Ephrata, Ephrata Municipal Airport', 'KEPH', '53025', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1883, 'us', 'Washington', 'Everett, Snohomish County Airport', 'KPAE', '53061', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1884, 'us', 'Washington', 'Fairchild Air Force Base', 'KSKA', '53063', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1885, 'us', 'Washington', 'Fort Lewis / Gray U. S. Army Airfield', 'KGRF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1886, 'us', 'Washington', 'Friday Harbor, Friday Harbor Airport', 'KFHR', '53055', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1887, 'us', 'Washington', 'Grays Harbor Coast Guard Station', 'K84S', '53069', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1888, 'us', 'Washington', 'Hanford', 'KHMS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1889, 'us', 'Washington', 'Hoquiam, Bowerman Airport', 'KHQM', '53027', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1890, 'us', 'Washington', 'Kelso-Longview Automatic Weather Observing / Reporting System', 'KKLS', '53015', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1891, 'us', 'Washington', 'Moses Lake, Grant County Airport', 'KMWH', '53025', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1892, 'us', 'Washington', 'New Dungeness Coast Guard Station', 'K96S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1893, 'us', 'Washington', 'Oak Harbor Airpark', 'K76S', '53029', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1894, 'us', 'Washington', 'Olympia, Olympia Airport', 'KOLM', '53067', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1895, 'us', 'Washington', 'Omak', 'K4OM', '53047', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1896, 'us', 'Washington', 'Omak, Omak Airport', 'KOMK', '', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1897, 'us', 'Washington', 'Pasco, Tri-Cities Airport', 'KPSC', '53021', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1898, 'us', 'Washington', 'Point No Point Coast Guard Station', 'K97S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1899, 'us', 'Washington', 'Point Robinson Coast Guard Light Station', 'K99S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1900, 'us', 'Washington', 'Point Wilson Coast Guard Light Station', 'K53S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1901, 'us', 'Washington', 'Port Angeles Coast Guard Air Station', 'KNOW', '53031', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1902, 'us', 'Washington', 'Port Angeles, William R. Fairchild International Airport', 'KCLM', '53031', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1903, 'us', 'Washington', 'Pullman / Moscow, Pullman / Moscow Regional Airport', 'KPUW', '53075', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1904, 'us', 'Washington', 'Quillayute River Coast Guard Light Station', 'K87S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1905, 'us', 'Washington', 'Quillayute, Quillayute State Airport', 'KUIL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1906, 'us', 'Washington', 'Renton, Renton Municipal Airport', 'KRNT', '53033', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1907, 'us', 'Washington', 'Seattle NEXRAD', 'KATX', '53033', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1908, 'us', 'Washington', 'Seattle, Seattle Boeing Field', 'KBFI', '53033', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1909, 'us', 'Washington', 'Seattle, Seattle-Tacoma International Airport', 'KSEA', '53033', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1910, 'us', 'Washington', 'Shelton, Shelton Sanderson Field', 'KSHN', '53045', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1911, 'us', 'Washington', 'Smith Island Coast Guard Light Station', 'K86S', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1912, 'us', 'Washington', 'Spokane, Felts Field', 'KSFF', '53063', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1913, 'us', 'Washington', 'Spokane, Spokane International Airport', 'KGEG', '53063', 'kotx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1914, 'us', 'Washington', 'Stampede Pass', 'KSMP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1915, 'us', 'Washington', 'Tacoma / McChord Air Force Base', 'KTCM', '53053', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1916, 'us', 'Washington', 'Tacoma, Tacoma Narrows Airport', 'KTIW', '53053', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1917, 'us', 'Washington', 'Toledo-Winlock Memorial', 'KTDO', '53041', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1918, 'us', 'Washington', 'Vancouver, Pearson Airpark', 'KVUO', '53011', 'krtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1919, 'us', 'Washington', 'Walla Walla, Walla Walla Regional Airport', 'KALW', '53071', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1920, 'us', 'Washington', 'Wenatchee, Pangborn Memorial Airport', 'KEAT', '53007', 'katx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1921, 'us', 'Washington', 'West Point Coast Guard Light Station', 'K43S', '53005', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1922, 'us', 'Washington', 'Whidbey Island, Naval Air Station', 'KNUW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1923, 'us', 'Washington', 'Willapa Harbor', 'K2S9', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1924, 'us', 'Washington', 'Yakima, Yakima Air Terminal', 'KYKM', '53077', 'kpdt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1925, 'us', 'West Virginia', 'Beckley, Raleigh County Memorial Airport', 'KBKW', '54081', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1926, 'us', 'West Virginia', 'Bluefield, Mercer County Airport', 'KBLF', '54055', '', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1927, 'us', 'West Virginia', 'Charleston', 'KRLX', '54019', '', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1928, 'us', 'West Virginia', 'Charleston, Yeager Airport', 'KCRW', '54019', '', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1929, 'us', 'West Virginia', 'Clarksburg, Clarksburg Benedum Airport', 'KCKB', '54033', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1930, 'us', 'West Virginia', 'Elkins, Elkins-Randolph County-Jennings Randolph Field', 'KEKN', '54083', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1931, 'us', 'West Virginia', 'Huntington, Tri-State Airport', 'KHTS', '54011', '', 'khpx', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1932, 'us', 'West Virginia', 'Lewisburg / Greenbrier', 'KLWB', '54025', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1933, 'us', 'West Virginia', 'Martinsburg, Eastern West Virginia Regional Airport', 'KMRB', '54003', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1934, 'us', 'West Virginia', 'Morgantown, Morgantown Municipal-Hart Field', 'KMGW', '54061', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1935, 'us', 'West Virginia', 'parkersburg, wood county airport / gill robb wilson field airport', 'KPKB', '54107', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1936, 'us', 'West Virginia', 'Petersburg, Grant County Airport', 'KW99', '54063', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1937, 'us', 'West Virginia', 'Wheeling, Wheeling Ohio County Airport', 'KHLG', '54069', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1938, 'us', 'West Virginia', 'White Sulphur Sprng', 'KSSU', '54005', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1939, 'us', 'Wisconsin', 'Antigo - Lang Automatic Weather Observing / Reporting System', 'KAIG', '55067', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1940, 'us', 'Wisconsin', 'Appleton / Outagamie', 'KATW', '55087', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1941, 'us', 'Wisconsin', 'Ashland, Kennedy Memorial Airport', 'KASX', '55003', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1942, 'us', 'Wisconsin', 'Baraboo, Baraboo Wisconsin Dells Airport', 'KDLL', '55111', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1943, 'us', 'Wisconsin', 'Boscobel, Boscobel Airport', 'KOVS', '55043', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1944, 'us', 'Wisconsin', 'Clintonville, Clintonville Municipal Airport', 'KCLI', '55105', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1945, 'us', 'Wisconsin', 'Devils Island Light Station', 'K29Y', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1946, 'us', 'Wisconsin', 'Eagle River, Eagle River Union Airport', 'KEGV', '55133', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1947, 'us', 'Wisconsin', 'Eau Claire County Airport', 'KEAU', '55035', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1948, 'us', 'Wisconsin', 'Fond Du Lac, Fond Du Lac County Airport', 'KFLD', '55039', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1949, 'us', 'Wisconsin', 'Green Bay, Austin Straubel International Airport', 'KGRB', '55019', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1950, 'us', 'Wisconsin', 'Hayward, Hayward Municipal Airport', 'KHYR', '55113', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1951, 'us', 'Wisconsin', 'Janesville / Rock County', 'KJVL', '55105', 'kmkx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1952, 'us', 'Wisconsin', 'Juneau, Dodge County Airport', 'KUNU', '55027', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1953, 'us', 'Wisconsin', 'Kenosha Coast Guard Station', 'K16C', '55059', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1954, 'us', 'Wisconsin', 'Kenosha, Kenosha Regional Airport', 'KENW', '55059', 'kmkx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1955, 'us', 'Wisconsin', 'La Crosse, La Crosse Municipal Airport', 'KLSE', '55063', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1956, 'us', 'Wisconsin', 'Lone Rock, Tri-County Regional Airport', 'KLNR', '55103', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1957, 'us', 'Wisconsin', 'Madison, Dane County Regional-Truax Field', 'KMSN', '55025', 'kmkx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1958, 'us', 'Wisconsin', 'Manitowoc Municipal Automatic Weather Observing / Reporting System', 'KMTW', '55071', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1959, 'us', 'Wisconsin', 'Marshfield, Marshfield Municipal Airport', 'KMFI', '55141', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1960, 'us', 'Wisconsin', 'McCoy United States Army Air Field', 'KCMY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1961, 'us', 'Wisconsin', 'Medford, Taylor County Airport', 'KMDZ', '55119', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1962, 'us', 'Wisconsin', 'Merrill, Merrill Municipal Airport', 'KRRL', '55111', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1963, 'us', 'Wisconsin', 'Milwaukee / Timmerman', 'KMWC', '55079', 'kmkx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1964, 'us', 'Wisconsin', 'Milwaukee Coast Guard Light Station', 'K15C', '55079', 'kmkx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1965, 'us', 'Wisconsin', 'Milwaukee NEXRAD', 'KMKX', '55079', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1966, 'us', 'Wisconsin', 'Milwaukee, General Mitchell International Airport', 'KMKE', '55079', 'kmkx', 'klot', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1967, 'us', 'Wisconsin', 'Mineral Point, Iowa County Airport', 'KMRJ', '55049', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1968, 'us', 'Wisconsin', 'Minocqua / Woodruff', 'KARV', '55085', 'kmqt', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1969, 'us', 'Wisconsin', 'Monroe, Monroe Municipal Airport', 'KEFT', '55045', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1970, 'us', 'Wisconsin', 'Mosinee / Central Wisconsin', 'KCWA', '55073', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1971, 'us', 'Wisconsin', 'Neenah', 'KEEW', '55139', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1972, 'us', 'Wisconsin', 'New Richmond, New Richmond Municipal Airport', 'KRNH', '55109', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1973, 'us', 'Wisconsin', 'Osceola, L O Simenstad Municipal Airport', 'KOEO', '55095', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1974, 'us', 'Wisconsin', 'Oshkosh, Wittman Regional Airport', 'KOSH', '55139', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1975, 'us', 'Wisconsin', 'Park Falls', 'KPKF', '55099', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1976, 'us', 'Wisconsin', 'Phillips / Price County', 'KPBH', '55099', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1977, 'us', 'Wisconsin', 'Prairie Du Chien, Prairie Du Chien Municipal Airport', 'KPDC', '55005', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1978, 'us', 'Wisconsin', 'Racine, Batten International Airport', 'KRAC', '55101', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1979, 'us', 'Wisconsin', 'Rhinelander, Rhinelander-Oneida County Airport', 'KRHI', '55085', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1980, 'us', 'Wisconsin', 'Rice Lake Municipal', 'KRIE', '55005', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1981, 'us', 'Wisconsin', 'Rice Lake, Rice Lake Regional-Carls Field Airport', 'KRPD', '55005', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1982, 'us', 'Wisconsin', 'Sheboygan Coast Guard Station', 'K21C', '55117', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1983, 'us', 'Wisconsin', 'Sheboygan, Sheboygan County Memorial Airport', 'KSBM', '55117', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1984, 'us', 'Wisconsin', 'Stevens Point, Stevens Point Municipal Airport', 'KSTE', '55097', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1985, 'us', 'Wisconsin', 'Sturgeon Bay', 'KSUE', '55029', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1986, 'us', 'Wisconsin', 'Superior, Richard I. Bong Airport', 'KSUW', '55031', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1987, 'us', 'Wisconsin', 'Two Rivers Coast Guard Station', 'KC58', '55071', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1988, 'us', 'Wisconsin', 'Volk / Camp Douglas', 'KVOK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1989, 'us', 'Wisconsin', 'Watertown', 'KRYV', '55055', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1990, 'us', 'Wisconsin', 'Waukesha', 'KSKC', '55133', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1991, 'us', 'Wisconsin', 'Waukesha, Waukesha County Airport', 'KUES', '55133', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1992, 'us', 'Wisconsin', 'Wausau, Wausau Downtown Airport', 'KAUW', '55073', 'kgrb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1993, 'us', 'Wisconsin', 'West Bend, West Bend Municipal Airport', 'KETB', '55063', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1994, 'us', 'Wisconsin', 'Wisconsin Rapids, Alexander Field South Wood County Airport', 'KISW', '55141', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1995, 'us', 'Wyoming', 'Big Piney, Big Piney-Marbleton Airport', 'KBPI', '56035', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1996, 'us', 'Wyoming', 'Buffalo, Buffalo Johnson County Airport', 'KBYG', '56019', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1997, 'us', 'Wyoming', 'Casper, Natrona County International Airport', 'KCPR', '56025', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1998, 'us', 'Wyoming', 'Cheyenne, Cheyenne Airport', 'KCYS', '56021', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (1999, 'us', 'Wyoming', 'Cody', 'KCOD', '56029', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2000, 'us', 'Wyoming', 'Douglas', 'K4DG', '56009', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2001, 'us', 'Wyoming', 'Douglas, Converse County Airport', 'KDGW', '56009', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2002, 'us', 'Wyoming', 'Evanston, Evanston-Uninta County Burns Field', 'KEVW', '56025', 'kmtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2003, 'us', 'Wyoming', 'Gillette, Gillette-Campbell County Airport', 'KGCC', '56005', 'kudx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2004, 'us', 'Wyoming', 'Greybull, South Big Horn County Airport', 'KGEY', '56003', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2005, 'us', 'Wyoming', 'Jackson Hole Automatic Weather Observing / Reporting System', 'KJAC', '56039', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2006, 'us', 'Wyoming', 'Lander', 'KLND', '56013', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2007, 'us', 'Wyoming', 'Laramie, Laramie Regional Airport', 'KLAR', '56001', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2008, 'us', 'Wyoming', 'Rawlins Municipal', 'KRWL', '56007', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2009, 'us', 'Wyoming', 'Riverton, Riverton Regional Airport', 'KRIW', '56013', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2010, 'us', 'Wyoming', 'Rock Springs', 'KRKS', '56037', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2011, 'us', 'Wyoming', 'Sheridan, Sheridan County Airport', 'KSHR', '56033', 'kblx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2012, 'us', 'Wyoming', 'Torrington, Torrington Municipal Airport', 'KTOR', '56015', 'kcys', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2013, 'us', 'Wyoming', 'Worland, Worland Municipal Airport', 'KWRL', '56043', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2014, 'us', 'Wyoming', 'Yellowstone Lake', 'KP60', '56029', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2016, 'us', 'Wyoming', 'bordeaux', 'KBRX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2021, 'us', 'Alaska', 'bettles, bettles airport (alternate)', 'KBTT', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2026, 'us', 'Wisconsin', 'burlington, burlington municipal airport', 'KBUU', '55101', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2031, 'us', 'Wyoming', 'beaver rim', 'KBVR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2042, 'us', 'Illinois', 'morris, morris municipal-james r washburn field airport', 'KC09', '17063', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2044, 'us', 'Wisconsin', 'burlington, burlington municipal airport (alternate)', 'KC52', '55101', 'kmkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2047, 'us', 'Illinois', 'lacon, marshall county airport', 'KC75', '17123', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2061, 'us', 'Colorado', 'copper mountain, red cliff pass', 'KCCU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2070, 'us', 'Alaska', 'cordova, smith airport (alternate)', 'KCDV', '02261', 'paih', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2083, 'us', 'Arizona', 'chandler, chandler municipal airport', 'KCHD', '04013', 'kiwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2086, 'us', 'Oklahoma', 'chickasha, chickasha municipal airport', 'KCHK', '40051', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2096, 'us', 'Alabama', 'centreville', 'KCKL', '01007', 'khtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2107, 'us', 'Wyoming', 'cemetery separa', 'KCMS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2109, 'us', 'Wisconsin', 'sparta, sparta / fort mccoy airport', 'KCMY', '55081', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2124, 'us', 'North Carolina', 'whiteville, columbus county municipal airport', 'KCPC', '37047', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2128, 'us', 'Colorado', 'pagosa springs, wolf creek pass', 'KCPW', '08007', 'kgjx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2129, 'us', 'Oklahoma', 'chandler, chandler municipal airport', 'KCQB', '40081', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2141, 'us', 'Colorado', 'nederland mountain, corona pass', 'KCRV', '08013', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2149, 'us', 'Wyoming', 'continental div', 'KCTD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2152, 'us', 'North Carolina', 'clinton, sampson county airport', 'KCTZ', '37163', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2159, 'us', 'Michigan', 'charlevoix, charlevoix municipal airport', 'KCVX', '26045', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2186, 'us', 'Alaska', 'deering, deering airport (alternate)', 'KDEE', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2196, 'us', 'Wyoming', 'dead horse', 'KDHS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2200, 'us', 'Illinois', 'de kalb, de kalb taylor municipal airport', 'KDKB', '17037', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2223, 'us', 'Wyoming', 'deer creek', 'KDRC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2234, 'us', 'Oklahoma', 'durant, eaker field airport', 'KDUA', '40013', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2235, 'us', 'Oklahoma', 'duncan, halliburton field airport', 'KDUC', '40137', 'kfdr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2237, 'us', 'Michigan', 'lambertville, toledo suburban airport', 'KDUH', '26115', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2249, 'us', 'Louisianna', 'east cameron 345', 'KE12', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2253, 'us', 'Alaska', 'eagle, eagle airport (alternate)', 'KEAA', '02240', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2288, 'us', 'Virginia', 'emporia, emporia-greensville regional airport', 'KEMV', '51595', 'kakq', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2289, 'us', 'Oklahoma', 'vance air force base / enid', 'KEND', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2290, 'us', 'Illinois', 'centralia, centralia municipal airport', 'KENL', '17121', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2291, 'us', 'Alaska', 'nenana, nenana municipal airport', 'KENN', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2320, 'us', 'North Carolina', 'lexington, davidson county airport', 'KEXX', '37057', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2322, 'us', 'North Carolina', 'elizabethtown, curtis l brown jr. field airport', 'KEYF', '37017', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2341, 'us', 'Maryland', 'frederick, frederick municipal airport', 'KFDK', '24021', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2343, 'us', 'Ohio', 'findlay, findlay airport', 'KFDY', '39063', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2344, 'us', 'Illinois', 'freeport, albertus airport', 'KFEP', '17177', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2352, 'us', 'Minnesota', 'flag island', 'KFGN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2356, 'us', 'Wyoming', 'first divide', 'KFIR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2358, 'us', 'Minnesota', 'preston, fillmore county airport', 'KFKA', '27045', 'karx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2374, 'us', 'Illinois', 'flora, flora municipal airport', 'KFOA', '17025', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2380, 'us', 'Michigan', 'charlotte, fitch h beach airport', 'KFPK', '26045', 'kgrr', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2400, 'us', 'Illinois', 'fairfield, fairfield municipal airport', 'KFWC', '17191', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2404, 'us', 'Florida', 'fort lauderdale, fort lauderdale executive airport', 'KFXE', '12023', 'kamx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2406, 'us', 'New York', 'fulton, oswego county airport (alternate)', 'KFZY', '36075', 'ktyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2410, 'us', 'Illinois', 'galesburg, galesburg municipal airport', 'KGBG', '17095', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2414, 'us', 'Oklahoma', 'claremore, claremore regional airport', 'KGCM', '40131', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2416, 'us', 'Texas', 'pine springs, guadalupe mountains national park', 'KGDP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2434, 'us', 'Alaska', 'gulkana, gulkana airport (alternate)', 'KGKN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2437, 'us', 'Texas', 'gainesville, gainesville municipal airport', 'KGLE', '48097', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2441, 'us', 'Oklahoma', 'grove, grove municipal airport', 'KGMJ', '40041', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2449, 'us', 'Michigan', 'grayling, grayling army airfield', 'KGOV', '26039', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2450, 'us', 'Texas', 'grand prairie, grand prairie municipal airport', 'KGPM', '48251', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2462, 'us', 'Louisianna', 'ship shoal 207a', 'KGSM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2477, 'us', 'North Carolina', 'goldsboro, goldsboro-wayne municipal airport', 'KGWW', '37037', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2490, 'us', 'North Carolina', 'asheboro, asheboro municipal airport (alternate)', 'KHBI', '37151', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2494, 'us', 'Louisianna', 'hammond, hammond municipal airport', 'KHDC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2500, 'us', 'Alabama', 'hanchey ahp / ozark', 'KHEY', '', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2512, 'us', 'California', 'hanford, hanford municipal airport (alternate)', 'KHJO', '06031', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2517, 'us', 'Wyoming', 'hiland', 'KHLD', '56025', 'kriw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2526, 'us', 'Nevada', 'las vegas, henderson airport', 'KHND', '32003', 'kesx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2527, 'us', 'Iowa', 'harlan, harlan municipal airport', 'KHNR', '19155', 'koax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2528, 'us', 'Alaska', 'haines, haines airport (alternate)', 'KHNS', '02100', 'pacg', '', '')";
	
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2529, 'us', 'North Carolina', 'oxford, henderson-oxford airport', 'KHNZ', '37077', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2531, 'us', 'Alaska', 'homer, homer airport', 'KHOM', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2543, 'us', 'Mississippi', 'bay st. louis, stennis international airport', 'KHSA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2544, 'us', 'Illinois', 'harrisburg, harrisburg-raleigh airport', 'KHSB', '17115', 'kpah', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2569, 'us', 'Michigan', 'saginaw, saginaw county h.w. browne airport', 'KHYX', '26145', 'kdtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2570, 'us', 'Ohio', 'ashtabula, ashtabula county airport (alternate)', 'KHZY', '39007', 'kcle', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2579, 'us', 'Wyoming', 'i-25 divide', 'KIDV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2581, 'us', 'Louisianna', 'natchitoches, natchitoches regional airport', 'KIER', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2585, 'us', 'Illinois', 'chicago, lansing municipal airport', 'KIGQ', '17031', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2587, 'us', 'Iowa', 'independence, independence municipal airport', 'KIIB', '19019', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2588, 'us', 'Georgia', 'washington, washington-wilkes county airport', 'KIIY', '13317', 'kjgx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2590, 'us', 'Illinois', 'jacksonville, jacksonville municipal airport', 'KIJX', '17137', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2591, 'us', 'Wyoming', 'inyan kara', 'KIKA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2592, 'us', 'Illinois', 'kankakee, greater kankakee airport', 'KIKK', '17091', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2597, 'us', 'Alaska', 'iliamna, iliamna airport (alternate)', 'KILI', '02164', 'pakc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2611, 'us', 'North Carolina', 'lincolnton, lincolnton-lincoln county regional airport', 'KIPJ', '37109', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2616, 'us', 'Florida', 'orlando, kissimmee municipal airport', 'KISM', '12009', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2634, 'us', 'Texas', 'jasper, jasper county-bell field airport', 'KJAS', '48241', 'kpoe', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2640, 'us', 'Idaho', 'jerome, jerome county airport (alternate)', 'KJER', '16053', 'ksfx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2643, 'us', 'Minnesota', 'moorhead, moorhead municipal airport', 'KJKJ', '27027', 'kmvx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2644, 'us', 'Kentucky', 'jackson, carroll airport', 'KJKL', '21025', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2649, 'us', 'North Carolina', 'smithfield, johnston county airport', 'KJNX', '37101', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2651, 'us', 'North Carolina', 'concord, concord regional airport', 'KJQF', '37025', 'kgsp', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2653, 'us', 'Oklahoma', 'sallisaw, sallisaw municipal airport', 'KJSV', '40135', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2655, 'us', 'Oklahoma', 'watonga, watonga airport', 'KJWG', '40011', 'kvnx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2661, 'us', 'Nebraska', 'york, york municipal airport', 'KJYR', '', 'kuex', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2662, 'us', 'Alaska', 'kaltag, kaltag airport (alternate)', 'KKAL', '02290', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2664, 'us', 'Alaska', 'kivalina, kivalina airport (alternate)', 'KKVL', '02188', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2708, 'us', 'Georgia', 'la grange, callaway airport', 'KLGC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2711, 'us', 'Alaska', 'anchorage, lake hood sea plane base', 'KLHD', '02020', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2716, 'us', 'North Carolina', 'louisburg, franklin county airport', 'KLHZ', '37069', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2722, 'us', 'Virginia', 'louisa, louisa county / freeman field airport', 'KLKU', '51109', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2724, 'us', 'Idaho', 'challis, challis airport (alternate)', 'KLLJ', '16037', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2734, 'us', 'Pennsylvania', 'philadelphia, wings field airport', 'KLOM', '42101', 'kdix', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2735, 'us', 'Alabama', 'fort rucker, lowe army heliport', 'KLOR', '01045', 'keox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2751, 'us', 'North Carolina', 'wilmington nexrad', 'KLTE', '37129', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2770, 'us', 'Missouri', 'Lees Summit', 'KLXT', '29095', 'keax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2774, 'us', 'Georgia', 'lawrenceville, gwinnett county-briscoe field airport', 'KLZU', '13135', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2788, 'us', 'Alaska', 'mcgrath, mcgrath airport (alternate)', 'KMCG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2813, 'us', 'Michigan', 'harbor springs, harbor springs airport', 'KMGN', '26047', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2856, 'us', 'Colorado', 'elbert mountain, monument pass', 'KMNH', '08039', 'kftg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2867, 'us', 'Iowa', 'mount pleasant, mount pleasant municipal airport', 'KMPZ', '19113', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2868, 'us', 'Illinois', 'macomb, macomb municipal airport', 'KMQB', '17109', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2878, 'us', 'Alaska', 'anchorage, merrill field', 'KMRI', '02020', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2890, 'us', 'Louisianna', 'new orleans, new orleans international airport', 'KMSY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2897, 'us', 'California', 'monterey', 'KMTR', '06053', 'kmux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2922, 'us', 'Colorado', 'salida mountain, monarch pass', 'KMYP', '08015', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2931, 'us', 'Maryland', 'ocean city, ocean city municipal airport (alternate)', 'KN80', '24047', 'kdox', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2939, 'us', 'Alabama', 'barin, barin field, naval air facility', 'KNBJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (2961, 'us', 'North Carolina', 'cherry point, marine corps air station (alternate)', 'KNIS', '37071', 'kmhx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3021, 'us', 'California', 'oceanside, oceanside municipal airport (alternate)', 'KOKB', '06073', 'kvtx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3025, 'us', 'Oklahoma', 'okmulgee, okmulgee municipal airport', 'KOKM', '40111', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3034, 'us', 'Mississippi', 'olive branch, olive branch airport', 'KOLV', '28033', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3035, 'us', 'Illinois', 'olney-noble, olney-noble airport', 'KOLY', '17159', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3038, 'us', 'Virginia', 'orange, orange county airport', 'KOMH', '51137', 'klwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3048, 'us', 'Georgia', 'thomaston, thomaston-upson county airport', 'KOPN', '13275', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3066, 'us', 'Minnesota', 'olivia, olivia regional airport', 'KOVL', '27129', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3112, 'us', 'Alaska', 'palmer, palmer municipal airport', 'KPAQ', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3113, 'us', 'Wyoming', 'pathfinder hill', 'KPAT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3118, 'us', 'Alaska', 'st. george island, new st. george airport', 'KPBV', '02016', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3125, 'us', 'Iowa', 'pella, pella municipal airport', 'KPEA', '19125', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3145, 'us', 'Wyoming', 'piney creek', 'KPIN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3161, 'us', 'Illinois', 'pontiac, pontiac municipal airport', 'KPNT', '17105', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3168, 'us', 'Illinois', 'pittsfield, pittsfield penstone municipal airport', 'KPPQ', '17149', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3174, 'us', 'Illinois', 'paris, edgar county airport', 'KPRG', '17045', 'kind', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3190, 'us', 'Wyoming', 'pumpkin vine', 'KPUM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3195, 'us', 'Oklahoma', 'pauls valley, pauls valley municipal airport', 'KPVJ', '40049', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3204, 'us', 'Texas', 'perryton, perryton ochiltree county airport', 'KPYX', '48145', 'kama', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3238, 'us', 'Oklahoma', 'poteau, robert s kerr airport', 'KRKR', '40079', 'ksrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3257, 'us', 'Illinois', 'rochelle, rochelle municipal-koritz field airport', 'KRPJ', '17167', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3264, 'us', 'Louisianna', 'ruston, ruston regional airport', 'KRSN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3280, 'us', 'Georgia', 'marietta, cobb county-mccollum field airport', 'KRYY', '13067', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3281, 'us', 'Wisconsin', 'siren, burnett county airport', 'KRZN', '55013', 'kdlh', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3299, 'us', 'Illinois', 'sparta, sparta community-hunter field airport', 'KSAR', '17157', 'klsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3323, 'us', 'Alabama', 'craig field / selma', 'KSEM', '01047', 'kbmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3330, 'us', 'Maine', 'sanford municipal automatic weather observing / reporting system', 'KSFM', '23031', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3343, 'us', 'Iowa', 'sheldon', 'KSHL', '19141', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3347, 'us', 'Louisianna', 'shreveport, shreveport regional airport', 'KSHV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3348, 'us', 'Wyoming', 'sibley peak', 'KSIB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3349, 'us', 'Louisianna', 'slidell radar site', 'KSIL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3355, 'us', 'Michigan', 'beaver island, beaver island airport', 'KSJX', '26051', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3360, 'us', 'Iowa', 'storm lake', 'KSLB', '19021', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3364, 'us', 'Michigan', 'cheboygan, cheboygan county airport', 'KSLH', '26031', 'kapx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3367, 'us', 'Kansas', 'salina, salina municipal airport', 'KSLN', '20169', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3370, 'us', 'Kentucky', 'somerset automatic weather observing / reporting system', 'KSME', '21199', 'kjkl', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3378, 'us', 'Oklahoma', 'shawnee, shawnee municipal airport', 'KSNL', '40125', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3379, 'us', 'Alaska', 'st. paul island, st. paul island airport', 'KSNP', '02016', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3381, 'us', 'Idaho', 'stanley, stanley ranger station (alternate)', 'KSNT', '16037', 'kcbx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3384, 'us', 'Alaska', 'seldovia, seldovia airport (alternate)', 'KSOV', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3393, 'us', 'Iowa', 'spencer, spencer municipal airport', 'KSPW', '19041', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3396, 'us', 'Arkansas', 'searcy, searcy municipal airport', 'KSRC', '05145', 'klzk', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3398, 'us', 'Louisianna', 'south marsh 268a', 'KSRN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3413, 'us', 'Florida', 'stuart, witham field airport', 'KSUA', '12085', 'kmlb', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3417, 'us', 'North Carolina', 'oak island, brunswick county airport', 'KSUT', '37019', 'kltx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3420, 'us', 'Iowa', 'sioux city, sioux gateway airport', 'KSUX', '19021', 'kfsd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3425, 'us', 'Alaska', 'seward, seward airport (alternate)', 'KSWD', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3428, 'us', 'Texas', 'sweetwater, avenger field airport', 'KSWW', '48353', 'kdyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3434, 'us', 'Texas', 'big spring, big spring mcmahon-wrinkle airport', 'KT49', '48227', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3436, 'us', 'Texas', 'weslaco, mid valley airport', 'KT65', '48215', 'kbro', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3437, 'us', 'Texas', 'fredericksburg, gillespie county airport', 'KT82', '48171', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3441, 'us', 'Illinois', 'taylorville, taylorville municipal airport', 'KTAZ', '17021', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3443, 'us', 'Georgia', 'statesboro, statesboro-bulloch county airport', 'KTBR', '13031', 'kclx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3449, 'us', 'North Carolina', 'roxboro, person county airport', 'KTDF', '37145', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3457, 'us', 'Oklahoma', 'tinker air force base', 'KTIK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3458, 'us', 'Illinois', 'rantoul, rantoul national aviation center airport-frank elliott field', 'KTIP', '17019', 'kilx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3461, 'us', 'Alaska', 'talkeetna, talkeetna airport (alternate)', 'KTKA', '02170', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3464, 'us', 'Oklahoma', 'oklahoma city nexrad', 'KTLX', '40109', 'ktlx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3466, 'us', 'Wyoming', '20 mile hill', 'KTMH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3467, 'us', 'North Carolina', 'boone, watauga county hospital heliport', 'KTNB', '37189', 'kfcx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3468, 'us', 'Iowa', 'newton municipal', 'KTNU', '19099', 'kdmx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3474, 'us', 'Kansas', 'topeka, philip billard municipal airport', 'KTOP', '20177', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3480, 'us', 'Oklahoma', 'tahlequah, tahlequah municipal airport', 'KTQH', '40021', 'kinx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3484, 'us', 'California', 'thermal, desert resorts thermal regional airport', 'KTRM', '06065', 'knkx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3485, 'us', 'North Carolina', 'sanford, sanford-lee county regional airport', 'KTTA', '37105', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3496, 'us', 'Louisianna', 'vicksburg, vicksburg / tallulah regional airport', 'KTVR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3499, 'us', 'Kansas', 'topeka nexrad', 'KTWX', '20177', 'ktwx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3502, 'us', 'Tennessee', 'Knoxville, mcghee tyson airport', 'KTYS', '47093', 'kmrx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3516, 'us', 'South Carolina', 'darlington, darlington county jetport airport', 'KUDG', '45031', 'kcae', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3528, 'us', 'Mississippi', 'oxford, university-oxford airport', 'KUOX', '28071', 'knqa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3539, 'us', 'Florida', 'tampa, vandenberg airport', 'KVDF', '12057', 'ktbw', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3541, 'us', 'Wyoming', 'vedauwoo', 'KVDW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3553, 'us', 'Indiana', 'valparaiso, porter county municipal airport', 'KVPZ', '18127', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3555, 'us', 'Florida', 'jacksonville, cecil field airport', 'KVQQ', '12109', 'kjax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3560, 'us', 'Iowa', 'vinton, vinton veterans memorial airpark airport', 'KVTI', '19011', 'kdvn', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3562, 'us', 'Colorado', 'la veta mountain, la veta pass', 'KVTP', '08055', 'kpux', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3564, 'us', 'North Carolina', 'albemarle, stanly county airport', 'KVUJ', '37167', 'krax', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3567, 'us', 'Florida', 'the villages', 'KVVG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3570, 'us', 'Illinois', 'peru, illinois valley regional-walter a duncan field airport', 'KVYS', '', 'klot', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3576, 'us', 'Louisianna', 'west cameron 560', 'KW60', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3579, 'us', 'Louisianna', 'west cameron b522', 'KW76', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3584, 'us', 'Georgia', 'winder, winder-barrow airport', 'KWDR', '13013', 'kffc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3586, 'us', 'California', 'la / whiteman', 'KWHP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3588, 'us', 'Kansas', 'winfield / arkansas city, strother field', 'KWLD', '20035', 'kict', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3594, 'us', 'Arizona', 'whiteriver, whiteriver airport', 'KWTR', '04017', 'kfsx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3596, 'us', 'Maine', 'waterville automatic weather observing / reporting system', 'KWVL', '23011', 'kgyx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3619, 'us', 'Minnesota', 'olivia, olivia regional airport (alternate)', 'KY39', '27129', 'kmpx', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3620, 'us', 'Alaska', 'yakutat, yakutat airport', 'KYAK', '02282', 'paih', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3635, 'us', 'Alaska', 'big delta arctic weather', 'PABG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3643, 'us', 'Alaska', 'clear', 'PACL', '02068', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3644, 'us', 'Alaska', 'cape saint elias', 'PACP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3645, 'us', 'Alaska', 'circle city airport', 'PACR', '02290', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3646, 'us', 'Alaska', 'cape sarichef airport', 'PACS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3648, 'us', 'Alaska', 'yakataga', 'PACY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3668, 'us', 'Alaska', 'farewell lake', 'PAFW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3670, 'us', 'Alaska', 'ft. richardson / bryant u. s. army heliport, ak', 'PAFR', '02020', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3677, 'us', 'Alaska', 'angoon', 'PAJN', '02232', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3679, 'us', 'Alaska', 'nightmute', 'PAGT', '02050', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3681, 'us', 'Alaska', 'homer / municipal', 'PAHD', '02122', 'pahg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3690, 'us', 'Alaska', 'kinana / bob baker me', 'PAIK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3694, 'us', 'Alaska', 'lazy mtn / wolverine', 'PAIZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3695, 'us', 'Alaska', 'biorka island supplementary aviation weather reporting station', 'PAJB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3698, 'us', 'Alaska', 'johnstone point', 'PAJO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3702, 'us', 'Alaska', 'nikolski', 'PAKO', '02016', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3726, 'us', 'Alaska', 'funter bay seaplane', 'PANR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3734, 'us', 'Alaska', 'port clarence', 'PAPC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3737, 'us', 'Alaska', 'platinum', 'PAPM', '02050', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3739, 'us', 'Alaska', 'prospect creek, prospect creek airport', 'PAPR', '', 'pabc', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3748, 'us', 'Alaska', 'skagway, skagway airport', 'PASG', '02232', 'pacg', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3764, 'us', 'Alaska', 'tok', 'PATJ', '02240', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3769, 'us', 'Alaska', 'umiat', 'PAUM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3777, 'us', 'Alaska', 'wainwright distant early warning', 'PAWI', '02185', 'paec', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3784, 'us', 'Alaska', 'barter island distant early warning', 'PBTI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3788, 'us', 'Hawaii', 'hana, hana airport', 'PHHN', '', 'phkm', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3795, 'us', 'Hawaii', 'kamuela, waimea-kohala airport', 'PHMU', '15001', 'phwa', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3804, 'us', 'Alaska', 'oliktok distant early warning', 'POLI', '', 'papd', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3805, 'ca', 'British Columbia', 'Abbotsford', 'CYXX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3806, 'ca', 'Quebec', 'Aeroport de Wemindji', 'CYNC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3807, 'ca', 'Northwest Territories', 'Aklavik Airport', 'CYKD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3808, 'ca', 'Quebec', 'Akulivik Airport', 'CYKO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3809, 'ca', 'Nunavut', 'Alert Airport', 'CYLT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3810, 'ca', 'Northwest Territories', 'Arviat Airport', 'CYEK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3811, 'ca', 'Quebec', 'Aupaluk', 'CYLA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3812, 'ca', 'Quebec', 'Bagotville', 'CYBG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3813, 'ca', 'Quebec', 'Baie Comeau', 'CYBC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3814, 'ca', 'Northwest Territories', 'Baker Lake', 'CYBK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3815, 'ca', 'New Brunswick', 'Bathurst Airport Aviation Weather Reporting Station', 'CZBF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3816, 'ca', 'British Columbia', 'Beaver Creek Airport', 'CYXQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3817, 'ca', 'British Columbia', 'Bella Coola Airport', 'CYBD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3818, 'ca', 'Manitoba', 'Berens River Airport', 'CYBV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3819, 'ca', 'Ontario', 'Big Trout Lake', 'CYTL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3820, 'ca', 'Quebec', 'Blanc Sablon', 'CYBX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3821, 'ca', 'British Columbia', 'Blue River', 'CYCP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3822, 'ca', 'Ontario', 'Borden', 'CYBN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3823, 'ca', 'Manitoba', 'Brandon', 'CYBR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3824, 'ca', 'Nunavut', 'Brevoort Island', 'CWOB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3825, 'ca', 'Northwest Territories', 'Broughton Island Airport', 'CYVM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3826, 'ca', 'Saskatchewan', 'Buffalo Narrows Man', 'CYVT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3827, 'ca', 'Yukon Territories', 'Burwash Airport', 'CYDB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3828, 'ca', 'Alberta', 'Calgary / Springbank', 'CYBW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3829, 'ca', 'Alberta', 'Calgary International, Alta.', 'CYYC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3830, 'ca', 'Northwest Territories', 'Cambridge Bay', 'CYCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3831, 'ca', 'British Columbia', 'Campbell River Airport', 'CYBL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3832, 'ca', 'Northwest Territories', 'Cape Dorset', 'CYTE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3833, 'ca', 'Northwest Territories', 'Cape Dyer', 'CWFD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3834, 'ca', 'New Foundland', 'Cape Kakkiviak', 'CWKW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3835, 'ca', 'New Foundland', 'Cape Kiglapait', 'CWYK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3836, 'ca', 'Northwest Territories', 'Cape Parry', 'CZCP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3837, 'ca', 'New Foundland', 'Cartwright', 'CWCA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3838, 'ca', 'British Columbia', 'Castlegar Airport', 'CYCG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3839, 'ca', 'Ontario', 'Chapleau', 'CYLD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3840, 'ca', 'Prince Edward Island', 'Charlottetown', 'CYYG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3841, 'ca', 'Quebec', 'Chatham Can-Mil', 'CYCH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3842, 'ca', 'Nunavut', 'Chesterfield Inlet', 'CYCS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3843, 'ca', 'British Columbia', 'Chetwynd Airport', 'CYCQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3844, 'ca', 'Quebec', 'Chibougamau-Chapais', 'CYMT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3845, 'ca', 'New Foundland', 'Churchill Falls', 'CZUM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3846, 'ca', 'Manitoba', 'Churchill', 'CYYQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3847, 'ca', 'British Columbia', 'Clinton', 'CWCL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3848, 'ca', 'Northwest Territories', 'Clyde', 'CYCY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3849, 'ca', 'Alberta', 'Cold Lake, Alta.', 'CYOD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3850, 'ca', 'British Columbia', 'Comox', 'CYQQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3851, 'ca', 'Northwest Territories', 'Coppermine', 'CYCO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3852, 'ca', 'Northwest Territories', 'Coral Harbour', 'CYZS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3853, 'ca', 'British Columbia', 'Cranbrook', 'CYXC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3854, 'ca', 'Northwest Territories', 'Croker River', 'CWXR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3855, 'ca', 'Manitoba', 'Dauphin', 'CYDN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3856, 'ca', 'British Columbia', 'Dawson Creek Airport', 'CYDQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3857, 'ca', 'Yukon Territories', 'Dawson', 'CYDA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3858, 'ca', 'British Columbia', 'Dease Lake', 'CWDL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3859, 'ca', 'New Foundland', 'Deer Lake', 'CYDF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3860, 'ca', 'Northwest Territories', 'Dewar Lakes', 'CWUW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3861, 'ca', 'Ontario', 'Dryden Airport', 'CYHD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3862, 'ca', 'Ontario', 'Earlton', 'CYXR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3864, 'ca', 'Quebec', 'Eastmain River Airport', 'CZEM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3865, 'ca', 'Alberta', 'Edmonton International, Alta.', 'CYEG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3866, 'ca', 'Alberta', 'Edmonton Municipal Alta.', 'CYXD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3867, 'ca', 'Alberta', 'Edmonton Namao Alta.', 'CYED', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3868, 'ca', 'Alberta', 'Edson, Alta.', 'CYET', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3869, 'ca', 'Northwest Territories', 'Ekati', 'CYOA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3870, 'ca', 'Ontario', 'Elliot Lake Supplementary Aviation Weather Reporting Station', 'CYEL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3871, 'ca', 'Saskatchewan', 'Estevan', 'CYEN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3872, 'ca', 'Northwest Territories', 'Eureka', 'CWEU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3873, 'ca', 'Yukon Territories', 'Faro Airport', 'CZFA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3875, 'ca', 'Manitoba', 'Flin Flon Airport', 'CYFO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3876, 'ca', 'Alberta', 'Fort Chipewyan', 'CYPY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3877, 'ca', 'Northwest Territories', 'Fort Franklin Airport', 'CYWJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3878, 'ca', 'Northwest Territories', 'Fort Good Hope Airport', 'CYGH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3879, 'ca', 'Northwest Territories', 'Fort Liard Airport', 'CYJF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3880, 'ca', 'Alberta', 'Fort Mcmurray, Alta.', 'CYMM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3881, 'ca', 'Northwest Territories', 'Fort Mcpherson Airport', 'CZFM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3882, 'ca', 'British Columbia', 'Fort Nelson', 'CYYE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3883, 'ca', 'Northwest Territories', 'Fort Norman Airport', 'CZFN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3884, 'ca', 'Northwest Territories', 'Fort Resolution', 'CYFR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3885, 'ca', 'Northwest Territories', 'Fort Simpson', 'CYFS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3886, 'ca', 'Northwest Territories', 'Fort Smith', 'CYSM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3887, 'ca', 'British Columbia', 'Fort St John', 'CYXJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3888, 'ca', 'New Brunswick', 'Fredericton', 'CYFC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3889, 'ca', 'New Brunswick', 'Gagetown Can-Mil', 'CYCX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3890, 'ca', 'New Foundland', 'Gander Int. Airport', 'CYQX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3891, 'ca', 'Quebec', 'Gaspe', 'CYGP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3892, 'ca', 'Quebec', 'Gatineau Airport', 'CYND', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3893, 'ca', 'Ontario', 'Geraldton', 'CYGQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3895, 'ca', 'Manitoba', 'Gillam', 'CYGX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3896, 'ca', 'Nunavut', 'Gjoa Haven Airport', 'CYHK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3897, 'ca', 'British Columbia', 'Golden Airport', 'CYGE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3898, 'ca', 'New Foundland', 'Goose', 'CYYR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3899, 'ca', 'Ontario', 'Gore Bay', 'CYZE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3900, 'ca', 'Alberta', 'Grande Prairie', 'CYQU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3901, 'ca', 'Nova Scotia', 'Greenwood', 'CYZX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3902, 'ca', 'Nunavut', 'Grise Fiord Airport', 'CWGZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3903, 'ca', 'Nova Scotia', 'Halifax International Airport', 'CYHZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3904, 'ca', 'Northwest Territories', 'Hall Beach', 'CYUX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3905, 'ca', 'Ontario', 'Hamilton Airport', 'CYHM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3906, 'ca', 'Quebec', 'Havre St Pierre', 'CYGV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3907, 'ca', 'Northwest Territories', 'Hay River', 'CYHY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3908, 'ca', 'Alberta', 'High Level', 'CYOJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3909, 'ca', 'Northwest Territories', 'Holman Island Airport', 'CYHI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3910, 'ca', 'British Columbia', 'Hope', 'CYHE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3911, 'ca', 'Nunavut', 'Igloolik Airport', 'CYGT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3912, 'ca', 'Quebec', 'Iles De La Madeleineque', 'CYGR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3913, 'ca', 'British Columbia', 'Ingenika Point', 'CWWU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3914, 'ca', 'Quebec', 'Inukjuak Airport Supplementary Aviation Weather Reporting Station', 'CYPH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3915, 'ca', 'Northwest Territories', 'Inuvik', 'CYEV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3916, 'ca', 'Northwest Territories', 'Iqaluit', 'CYFB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3917, 'ca', 'Manitoba', 'Island Lake', 'CYIV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3918, 'ca', 'Quebec', 'Ivujivik Airport Supplementary Aviation Weather Reporting Station', 'CYIK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3919, 'ca', 'Ontario', 'Jimmy Lake', 'CWHN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3920, 'ca', 'British Columbia', 'Kamloops', 'CYKA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3921, 'ca', 'Quebec', 'Kangiksualujjuaq A', 'CYLU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3922, 'ca', 'Quebec', 'Kangiqsujuaq Supplementary Aviation Weather Reporting Station', 'CYKG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3923, 'ca', 'Quebec', 'Kangirsuk Supplementary Aviation Weather Reporting Station', 'CYAS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3924, 'ca', 'Ontario', 'Kapuskasing', 'CYYU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3925, 'ca', 'British Columbia', 'Kelowna Airport', 'CYLW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3926, 'ca', 'Ontario', 'Kenora', 'CYQK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3927, 'ca', 'Saskatchewan', 'Key Lake', 'CYKJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3928, 'ca', 'Nunavut', 'Kimmirut A Nwt', 'CYLC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3929, 'ca', 'Saskatchewan', 'Kindersley', 'CYKY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3930, 'ca', 'Ontario', 'Kingston', 'CYGK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3931, 'ca', 'Quebec', 'Kuujjuaq', 'CYVP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3932, 'ca', 'Quebec', 'Kuujjuarapik', 'CYGW', '', '', '', '')";
	
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3933, 'ca', 'Quebec', 'La Grande Iii Supplementary Aviation Weather Reporting Station', 'CYAD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3934, 'ca', 'Quebec', 'La Grande Iv', 'CYAH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3935, 'ca', 'Quebec', 'La Grande Riviere', 'CYGL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3936, 'ca', 'Saskatchewan', 'La Ronge', 'CYVC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3937, 'ca', 'Alberta', 'Lethbridge', 'CYQL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3938, 'ca', 'Northwest Territories', 'Liverpool Bay', 'CWLI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3939, 'ca', 'Alberta', 'Lloydminister', 'CYLL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3940, 'ca', 'Ontario', 'London', 'CYXU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3941, 'ca', 'Northwest Territories', 'Longstaff Bluff', 'CWLX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3942, 'ca', 'Northwest Territories', 'Lupin Airport Supplementary Aviation Weather Reporting Station', 'CYWO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3943, 'ca', 'Northwest Territories', 'Lutsel KE', 'CYLK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3944, 'ca', 'Manitoba', 'Lynn Lake', 'CYYL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3945, 'ca', 'British Columbia', 'Lytton', 'CWLY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3946, 'ca', 'British Columbia', 'Mackenzie', 'CYZY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3947, 'ca', 'New Foundland', 'Makkovik Airport', 'CYFT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3948, 'ca', 'New Foundland', 'Mary\'s Harbour', 'CYMH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3949, 'ca', 'Quebec', 'Matagami', 'CYNM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3950, 'ca', 'Yukon Territories', 'Mayo Airport', 'CYMA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3951, 'ca', 'Saskatchewan', 'Meadow Lake', 'CYLJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3952, 'ca', 'Alberta', 'Medicine Hat', 'CYXH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3953, 'ca', 'New Brunswick', 'Moncton', 'CYQM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3954, 'ca', 'Quebec', 'Mont Joli', 'CYYY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3955, 'ca', 'Quebec', 'Montreal / Dorval International', 'CYUL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3956, 'ca', 'Quebec', 'Montreal / Mirabel', 'CYMX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3957, 'ca', 'Saskatchewan', 'Moose Jaw', 'CYMJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3958, 'ca', 'Ontario', 'Moosonee', 'CYMO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3959, 'ca', 'Ontario', 'Muskoka', 'CYQA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3960, 'ca', 'New Foundland', 'Nain', 'CYDP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3961, 'ca', 'British Columbia', 'Nanaimo Airport', 'CYCD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3962, 'ca', 'Nunavut', 'Nanisivik Airport', 'CYSR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3963, 'ca', 'Quebec', 'Natashquan', 'CYNA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3964, 'ca', 'Quebec', 'Nemiscau Airport Supplementary Aviation Weather Reporting Station', 'CYHH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3965, 'ca', 'Saskatchewan', 'Nipawin', 'CYBU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3966, 'ca', 'Northwest Territories', 'Norman Wells', 'CYVQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3967, 'ca', 'Saskatchewan', 'North Battleford', 'CYQW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3968, 'ca', 'Ontario', 'North Bay', 'CYYB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3969, 'ca', 'Manitoba', 'Norway House', 'CYNE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3970, 'ca', 'Yukon Territories', 'Old Crow Airport', 'CYOC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3971, 'ca', 'Ontario', 'Ottawa Int\'L', 'CYOW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3972, 'ca', 'Northwest Territories', 'Pangnirtung Airport', 'CYXP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3973, 'ca', 'Northwest Territories', 'Paulatuk Airport', 'CYPC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3974, 'ca', 'Alberta', 'Peace River', 'CYPE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3975, 'ca', 'Northwest Territories', 'Pelly Bay Airport', 'CYBB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3976, 'ca', 'British Columbia', 'Penticton', 'CYYF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3977, 'ca', 'Ontario', 'Petawawa', 'CYWA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3978, 'ca', 'Ontario', 'Peterborough Airport', 'CYPQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3979, 'ca', 'Manitoba', 'Pickle Lake', 'CYPL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3980, 'ca', 'Alberta', 'Pincher Creek Airport', 'CZPC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3981, 'ca', 'Northwest Territories', 'Pond Inlet', 'CYIO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3982, 'ca', 'British Columbia', 'Port Hardy', 'CYZT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3983, 'ca', 'Manitoba', 'Portage Southport A', 'CYPG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3984, 'ca', 'Quebec', 'Povungnituq', 'CYPX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3985, 'ca', 'British Columbia', 'Powell River Airport', 'CYPW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3986, 'ca', 'Saskatchewan', 'Prince Albert', 'CYPA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3987, 'ca', 'British Columbia', 'Prince George', 'CYXS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3988, 'ca', 'British Columbia', 'Prince Rupert', 'CYPR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3989, 'ca', 'Quebec', 'Quaqtaq Airport', 'CYHA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3990, 'ca', 'Quebec', 'Quebec', 'CYQB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3991, 'ca', 'British Columbia', 'Quesnel Airport', 'CYQZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3992, 'ca', 'Northwest Territories', 'Rankin Inlet', 'CYRT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3993, 'ca', 'Alberta', 'Red Deer', 'CYQF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3994, 'ca', 'Ontario', 'Red Lake', 'CYRL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3995, 'ca', 'Saskatchewan', 'Regina', 'CYQR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3996, 'ca', 'Yukon Territories', 'Repulse Bay Airport', 'CYUT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3997, 'ca', 'Northwest Territories', 'Resolute', 'CYRB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3998, 'ca', 'British Columbia', 'Revelstoke', 'CYRV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (3999, 'ca', 'Quebec', 'Roberval', 'CYRJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4000, 'ca', 'Quebec', 'Rouyn Airport', '', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4001, 'ca', 'Nova Scotia', 'Sable Island', 'CWSA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4002, 'ca', 'Northwest Territories', 'Sachs Harbour Airport', 'CYSY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4003, 'ca', 'New Foundland', 'Saglek Bay', 'CWZZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4004, 'ca', 'New Foundland', 'Saint Anthony Airport', 'CYAY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4005, 'ca', 'Ontario', 'Saint Catharines Airport', 'CYSN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4006, 'ca', 'Quebec', 'Saint Hubert Airport', 'CYHU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4007, 'ca', 'New Brunswick', 'Saint John', 'CYSJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4008, 'ca', 'New Brunswick', 'Saint Leonard Airport', 'CYSL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4009, 'ca', 'Quebec', 'Salliut Airport Supplementary Aviation Weather Reporting Station', 'CYZG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4010, 'ca', 'British Columbia', 'Sandspit', 'CYZP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4011, 'ca', 'Nunavut', 'Sanikiluaq Airport', 'CYSK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4012, 'ca', 'Ontario', 'Sarnia Airport', 'CYZR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4013, 'ca', 'Saskatchewan', 'Saskatoon', 'CYXE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4014, 'ca', 'Ontario', 'Sault Ste Marie', 'CYAM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4015, 'ca', 'Quebec', 'Schefferville', 'CYKL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4016, 'ca', 'Quebec', 'Sept-Iles', 'CYZV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4017, 'ca', 'Nova Scotia', 'Shearwater', 'CYAW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4018, 'ca', 'Northwest Territories', 'Shepherd Bay', 'CYUS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4019, 'ca', 'Quebec', 'Sherbrooke', 'CYSC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4020, 'ca', 'Yukon Territories', 'Shingle Point', 'CYUA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4021, 'ca', 'Ontario', 'Sioux Lookout', 'CYXL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4022, 'ca', 'Alberta', 'Slave Lake', 'CYZH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4023, 'ca', 'British Columbia', 'Smithers', 'CYYD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4024, 'ca', 'British Columbia', 'Sparwood / Elk Valley', 'CWSW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4025, 'ca', 'Northwest Territories', 'Spence Bay Airport', 'CYYH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4026, 'ca', 'New Foundland', 'St. John\'s', 'CYYT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4027, 'ca', 'New Foundland', 'Stephenville', 'CYJT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4028, 'ca', 'British Columbia', 'Stewart Airport', 'CZST', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4029, 'ca', 'British Columbia', 'Stony Rapids Airport', 'CYSF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4030, 'ca', 'Ontario', 'Sudbury', 'CYSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4031, 'ca', 'Alberta', 'Suffield Airport', 'CYSD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4032, 'ca', 'Saskatchewan', 'Swift Current', 'CYYN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4033, 'ca', 'Nova Scotia', 'Sydney', 'CYQY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4034, 'ca', 'Nunavut', 'Tasiujaq A', 'CYTQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4035, 'ca', 'British Columbia', 'Terrace Bay Supplementary Aviation Weather Reporting Station', 'CYTJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4036, 'ca', 'British Columbia', 'Terrace', 'CYXT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4037, 'ca', 'Yukon Territories', 'Teslin', 'CYZW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4038, 'ca', 'Manitoba', 'The Pas', 'CYQD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4039, 'ca', 'Manitoba', 'Thompson Weather Office', 'CYTH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4040, 'ca', 'Ontario', 'Thunder Bay', 'CYQT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4041, 'ca', 'Ontario', 'Timmins', 'CYTS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4042, 'ca', 'British Columbia', 'Tofino Airport', 'CYAZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4043, 'ca', 'Ontario', 'Toronto Buttonville', 'CYKZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4044, 'ca', 'Ontario', 'Toronto Island Airport Automated Reporting Station', 'CYTZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4045, 'ca', 'Ontario', 'Toronto Pearson Int\'L', 'CYYZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4046, 'ca', 'Ontario', 'Trenton', 'CYTR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4047, 'ca', 'New Foundland', 'Tukialik Bay', 'CWTU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4048, 'ca', 'Northwest Territories', 'Tuktoyaktuk', 'CYUB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4049, 'ca', 'Quebec', 'Umiujaq', 'CYMU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4050, 'ca', 'Quebec', 'Val D\'Or', 'CYVO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4051, 'ca', 'Quebec', 'Valcartier Airport', 'CYOY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4052, 'ca', 'British Columbia', 'Vancouver International Air-Port', 'CYVR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4053, 'ca', 'British Columbia', 'Victoria Harbour', 'CYWH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4054, 'ca', 'British Columbia', 'Victoria Int. Airport', 'CYYJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4055, 'ca', 'New Foundland', 'Wabush Lake', 'CYWK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4056, 'ca', 'Quebec', 'Waskaganish Airport', 'CYKQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4057, 'ca', 'Ontario', 'Waterloo Well', 'CYKF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4058, 'ca', 'Yukon Territories', 'Watson Lake', 'CYQH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4059, 'ca', 'Ontario', 'Wawa', 'CYXZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4060, 'ca', 'Nunavut', 'Whale Cove Airport', 'CYXN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4061, 'ca', 'British Columbia', 'Whistler', 'CWAE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4062, 'ca', 'Alberta', 'Whitecourt', 'CYZU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4063, 'ca', 'Yukon Territories', 'Whitehorse', 'CYXY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4064, 'ca', 'Ontario', 'Wiarton', 'CYVV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4067, 'ca', 'Ontario', 'Windsor', 'CYQG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4066, 'ca', 'British Columbia', 'Williams Lake', 'CYWL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4068, 'ca', 'Manitoba', 'Winnipeg Int. Airportman', 'CYWG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4069, 'ca', 'Northwest Territories', 'Wrigley Airport', 'CYWY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4070, 'ca', 'Nova Scotia', 'Yarmouth', 'CYQI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4071, 'ca', 'Northwest Territories', 'Yellowknife', 'CYZF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4072, 'ca', 'Saskatchewan', 'Yorkton', 'CYQV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4073, 'af', '', 'Kabul Airport', 'OAKB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4074, 'al', 'Tirana', 'Tirana', 'LATI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4075, 'cn', 'Beijing', 'Beijing', 'ZBAA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4076, 'cn', 'Anhui', 'Hefei', 'ZSOF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4077, 'cn', 'Chongqing', 'Chongqing', 'ZUCK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4078, 'cn', 'Jilin', 'Changchun', 'ZYCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4079, 'cn', 'Hunan', 'Changsha', 'ZGHA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4080, 'cn', 'Sichuan', 'Chengdu', 'ZUUU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4081, 'cn', 'Liaoning', 'Dalian', 'ZYTL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4082, 'cn', 'Fujian', 'Fuzhou', 'ZSFZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4083, 'cn', 'Guangdong', 'Guangzhou', 'ZGGG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4084, 'cn', 'Guangxi Zhuang Autonomous', 'Guilin', 'ZGKL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4085, 'cn', 'Zhejiang', 'Hangzhou', 'ZSHC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4086, 'cn', 'Heilongjiang', 'Harbin', 'ZYHB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4087, 'cn', 'Anhui', 'Hefei', 'ZSOF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4088, 'cn', 'Beijing', 'Hohhot', 'ZBHH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4089, 'cn', 'Xinjiang Uygur Autonomous', 'Kashi', 'ZWSH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4090, 'cn', 'Yunnan', 'Kunming', 'ZPPP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4091, 'cn', 'Gansu', 'Lanzhou / Zhongchuan', 'ZLLL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4092, 'cn', 'Jiangxi', 'Nanchang', 'ZSCN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4093, 'cn', 'Jiangsu', 'Nanjing', 'ZSNJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4094, 'cn', 'Guangxi Zhuang Autonomous', 'Nanning', 'ZGNN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4095, 'cn', 'Shandong', 'Qingdao', 'ZSQD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4096, 'cn', 'Hainan', 'Sanya/Fenghuang', 'ZJSY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4097, 'cn', 'Sheng-Hai', 'Shanghai / Hongqiao', 'ZSSS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4098, 'cn', 'Sheng-Hai', 'Shanghai / Pudong', 'ZSPD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4099, 'cn', 'Guangdong', 'Shantou', 'ZGOW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4100, 'cn', 'Liaoning', 'Shenyang / Taokian', 'ZYTX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4101, 'cn', 'Guangdong', 'Shenzhen', 'ZGSZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4102, 'cn', 'Shanxi', 'Taiyuan', 'ZBYN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4103, 'cn', 'Tianjin Municipality', 'Tianjin / Zhangguizhu', 'ZBTJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4104, 'cn', 'Tibet Autonomous', 'Urum-Qi / Diwopu', 'ZWWW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4105, 'cn', 'Hubei', 'Wuhan', 'ZHHH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4106, 'cn', 'Fujian', 'Xiamen', 'ZSAM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4107, 'cn', 'Shaanxi and Henan', 'Xian/Xianyang', 'ZLXY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4108, 'eg', 'Western Desert', 'Alexandria / Nouzha', 'HEAX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4109, 'eg', 'Western Desert', 'Alexandria Borg El Arab', 'HEBA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4110, 'eg', 'Eastern Desert', 'Aswan', 'HESN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4111, 'eg', 'Eastern Desert', 'Cairo Airport', 'HECA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4112, 'eg', 'Eastern Desert', 'Hurghada', 'HEGN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4113, 'eg', 'Eastern Desert', 'Luxor', 'HELX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4114, 'eg', 'Western Desert', 'Mersa Matruh', 'HEMM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4115, 'eg', 'Sinai', 'Port Said', 'HEPS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4116, 'eg', 'Sinai', 'Sharm El Sheikhintl', 'HESH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4117, 'eg', 'Sinai', 'Taba', 'HETB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4118, 'ae', '', 'Abu Dhabi International Airport', 'OMAA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4119, 'ae', '', 'Al Ain International Airport', 'OMAL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4120, 'ae', '', 'Dubai International Airport', 'OMDB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4121, 'ae', '', 'Fujairah', 'OMFJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4122, 'ae', '', 'Ras Al Khaimah International Airport', 'OMRK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4123, 'ae', '', 'Sharjah International Airport', 'OMSJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4124, 'kw', '', 'Kuwait International Airport', 'OKBK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4125, 'sa', '', 'Abha', 'OEAB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4126, 'sa', '', 'Al Ahsa', 'OEAH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4127, 'sa', '', 'Al Baha', 'OEBA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4128, 'sa', '', 'Al Qaysumah', 'OEPA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4129, 'sa', '', 'Al-Jouf', 'OESK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4130, 'sa', '', 'Arar', 'OERR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4131, 'sa', '', 'Bisha', 'OEBH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4132, 'sa', '', 'Dammam-King Fahd International Airport', 'OEDF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4133, 'sa', '', 'Dawadmi', 'OEDW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4134, 'sa', '', 'Dhahran', 'OEDR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4135, 'sa', '', 'Gassim', 'OEGS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4136, 'sa', '', 'Gizan', 'OEGN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4137, 'sa', '', 'Guriat', 'OEGT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4138, 'sa', '', 'Hafr Al-Batin', 'OEKK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4139, 'sa', '', 'Hail', 'OEHL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4140, 'sa', '', 'Jeddah King Abdul Aziz International Airport', 'OEJN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4141, 'sa', '', 'Khamis Mushait', 'OEKM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4142, 'sa', '', 'King Khaled International Airport', 'OERK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4143, 'sa', '', 'Madinah', 'OEMA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4144, 'sa', '', 'Makkah', 'OEMK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4145, 'sa', '', 'Najran', 'OENG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4146, 'sa', '', 'Rafha', 'OERF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4147, 'sa', '', 'Riyadh', 'OERY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4148, 'sa', '', 'Sharurah', 'OESH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4149, 'sa', '', 'Tabuk', 'OETB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4150, 'sa', '', 'Taif', 'OETF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4151, 'sa', '', 'Turaif', 'OETR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4152, 'sa', '', 'Wadi Al Dawasser Airport', 'OEWD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4153, 'sa', '', 'Wejh', 'OEWJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4154, 'sa', '', 'Yenbo', 'OEYN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4155, 'gb', 'Scotland', 'Aberdeen / Dyce', 'EGPD', '', '', '', 'http://www.bbc.co.uk/weather/live/brradar1.jpg')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4156, 'gb', 'England', 'Alderney, Channel Island', 'EGJA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4157, 'gb', 'England', 'Barkston Heath Royal Air Force Base', 'EGYE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4158, 'gb', 'Ireland', 'Belfast / Aldergrove Airport', 'EGAA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4159, 'gb', 'Ireland', 'Belfast / Harbour', 'EGAC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4160, 'gb', 'Scotland', 'Benbecula', 'EGPL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4161, 'gb', 'England', 'Benson', 'EGUB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4162, 'gb', 'England', 'Biggin Hill', 'EGKB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4163, 'gb', 'England', 'Birmingham / Airport', 'EGBB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4164, 'gb', 'Scotland', 'Blackpool Airport', 'EGNH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4165, 'gb', 'Scotland', 'Boscombe Down', 'EGDM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4166, 'gb', 'Ireland', 'Bournemouth Airport', 'EGHH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4167, 'gb', 'England', 'Bristol / Lulsgate', 'EGGD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4168, 'gb', 'Scotland', 'Brize Norton', 'EGVN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4169, 'gb', 'England', 'Cambridge', 'EGSC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4170, 'gb', 'England', 'Campbeltown', 'EGEC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4171, 'gb', 'Wales', 'Cardiff-Wales Airport', 'EGFF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4172, 'gb', 'Wales', 'Carlisle', 'EGNC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4173, 'gb', 'England', 'Church Fenton', 'EGXG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4174, 'gb', 'England', 'Colerne', 'EGUO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4175, 'gb', 'England', 'Coltishall', 'EGYC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4176, 'gb', 'England', 'Coningsby Royal Air Force Base', 'EGXC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4177, 'gb', 'England', 'Cosford Royal Air Force Base', 'EGWC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4178, 'gb', 'England', 'Cottesmore', 'EGXJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4179, 'gb', 'England', 'Coventry Airport', 'EGBE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4180, 'gb', 'England', 'Cranfield', 'EGTC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4181, 'gb', 'England', 'Cranwell', 'EGYD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4182, 'gb', 'England', 'Culdrose', 'EGDR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4183, 'gb', 'England', 'Disforth', 'EGXD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4184, 'gb', 'Ireland', 'Dundee / Riverside', 'EGPN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4185, 'gb', 'England', 'East Midlands', 'EGNX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4186, 'gb', 'Scotland', 'Edinburgh Airport', 'EGPH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4187, 'gb', 'Scotland', 'Eglinton / Londonderr', 'EGAE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4188, 'gb', 'Scotland', 'Exeter Airport', 'EGTE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4189, 'gb', 'Scotland', 'Farnborough', 'EGLF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4190, 'gb', 'England', 'Filton Private', 'EGTG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4191, 'gb', 'Scotland', 'Glasgow Airport', 'EGPF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4192, 'gb', 'Scotland', 'Guernsey Airport', 'EGJB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4193, 'gb', 'England', 'Hawarden', 'EGNR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4194, 'gb', 'England', 'Holbeach', 'EGYH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4195, 'gb', 'England', 'Humberside', 'EGNJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4196, 'gb', 'England', 'Inverness / Dalcross', 'EGPE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4197, 'gb', 'England', 'Islay', 'EGPI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4198, 'gb', 'England', 'Isle Of Man / Ronaldsway Airport', 'EGNS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4199, 'gb', 'England', 'Jersey Airport', 'EGJJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4200, 'gb', 'England', 'Kinloss', 'EGQK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4201, 'gb', 'England', 'Kirkwall Airport', 'EGPA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4202, 'gb', 'England', 'Lakenheath Royal Air Force Base', 'EGUL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4203, 'gb', 'England', 'Leeds And Bradford', 'EGNM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4204, 'gb', 'England', 'Leeming', 'EGXE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4205, 'gb', 'England', 'Leuchars', 'EGQL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4206, 'gb', 'England', 'Linton-On-Ouse', 'EGXU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4207, 'gb', 'England', 'Liverpool Airport', 'EGGP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4208, 'gb', 'Wales', 'Llanbedr', 'EGOD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4209, 'gb', 'England', 'London / Gatwick Airport', 'EGKK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4210, 'gb', 'England', 'London / Heathrow Airport', 'EGLL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4211, 'gb', 'England', 'London City Airport', 'EGLC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4212, 'gb', 'Ireland', 'Lossiemouth', 'EGQS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4213, 'gb', 'England', 'Luton Airport', 'EGGW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4214, 'gb', 'Scotland', 'Lyneham', 'EGDL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4215, 'gb', 'England', 'Manchester Airport', 'EGCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4216, 'gb', 'Scotland', 'Manston, South East', 'EGMH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4217, 'gb', 'England', 'Marham', 'EGYM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4218, 'gb', 'England', 'Middle Wallop', 'EGVP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4219, 'gb', 'England', 'Mildenhall Royal Air Force Base', 'EGUN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4220, 'gb', 'England', 'Newcastle', 'EGNT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4221, 'gb', 'England', 'Northolt', 'EGWU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4222, 'gb', 'England', 'Norwich Weather Centre', 'EGSH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4223, 'gb', 'England', 'Odiham', 'EGVO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4224, 'gb', 'Wales', 'Pembrey Sands', 'EGOP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4225, 'gb', 'Wales', 'Plymouth / Roborough', 'EGHD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4226, 'gb', 'Wales', 'Prestwick Airport', 'EGPK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4227, 'gb', 'England', 'Saint Mawgan', 'EGDG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4228, 'gb', 'England', 'Scampton', 'EGXP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4229, 'gb', 'Scotland', 'Scatsa / Shetland Island', 'EGPM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4230, 'gb', 'Scotland', 'Scilly, Saint Mary\'S', 'EGHE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4231, 'gb', 'England', 'Shawbury', 'EGOS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4232, 'gb', 'England', 'Shoreham Airport', 'EGKA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4233, 'gb', 'England', 'Southampton / Weather Centre', 'EGHI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4234, 'gb', 'England', 'Southend-On-Sea', 'EGMC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4235, 'gb', 'England', 'Spadeadam', 'EGOM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4236, 'gb', 'England', 'St Athan Royal Air Force Base', 'EGDX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4237, 'gb', 'England', 'Stansted Airport', 'EGSS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4238, 'gb', 'England', 'Staverton Private', 'EGBJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4239, 'gb', 'England', 'Stornoway', 'EGPO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4240, 'gb', 'England', 'Sumburgh Cape', 'EGPB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4241, 'gb', 'England', 'Tain Range', 'EGQA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4242, 'gb', 'England', 'Tees-Side', 'EGNV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4243, 'gb', 'Ireland', 'Tiree', 'EGPU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4244, 'gb', 'England', 'Topcliffe Royal Air Force Base', 'EGXZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4245, 'gb', 'Ireland', 'Valley', 'EGOV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4246, 'gb', 'England', 'Waddington', 'EGXW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4247, 'gb', 'England', 'Wainfleet', 'EGYW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4248, 'gb', 'England', 'Wattisham', 'EGUW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4249, 'gb', 'England', 'Wick', 'EGPC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4250, 'gb', 'England', 'Wittering', 'EGXT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4251, 'gb', 'England', 'Woodvale', 'EGOW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4252, 'gb', 'England', 'Wyton Royal Air Force Base', 'EGUY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4253, 'gb', 'England', 'Yeovilton', 'EGDY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4254, 'au', 'South Australia', 'Adelaide Airport', 'YPAD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4255, 'au', 'Northern Territory', 'Alice Springs Aerodrome', 'YBAS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4256, 'au', 'New South Wales', 'Avalon, Avalon Airport', 'YMAV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4257, 'au', 'Northern Territory', 'Ayers Rock', 'YAYE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4258, 'au', 'Western Australia', 'Belmont Perth Airport', 'YPPH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4259, 'au', 'Queensland', 'Brisbane International', 'YBBN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4260, 'au', 'Western Australia', 'Broome Airport', 'YBRM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4261, 'au', 'Western Australia', 'Bullsbrook Pearce Amo', 'YPEA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4262, 'au', 'Queensland', 'Cairns Airport', 'YBCS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4263, 'au', 'New South Wales', 'Canberra', 'YSCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4264, 'au', 'Queensland', 'Coolangatta Airport Aws', 'YBCG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4265, 'au', 'Northern Territory', 'Darwin Airport', 'YPDN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4266, 'au', 'New South Wales', 'Dubbo', 'YSDU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4267, 'au', 'Tasmania', 'Hobart Airport', 'YMHB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4268, 'au', 'Western Australia', 'Kununurra Kununurra Aws', 'YPKU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4269, 'au', 'Western Australia', 'Learmonth Airport', 'YPLM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4270, 'au', 'Victoria', 'Melbourne Airport', 'YMML', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4271, 'au', 'Queensland', 'Mount Isa Amo', 'YBMA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4272, 'au', 'Oceania', 'Norfolk Island Airport', 'YSNF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4273, 'au', 'Western Australia', 'Port Hedland Pardoo', 'YPPD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4274, 'au', 'Tasmania', 'Richmond Aus-Afb', 'YSRI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4275, 'au', 'Queensland', 'Rockhampton Airport', 'YBRK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4276, 'au', 'New South Wales', 'Sydney Airport', 'YSSY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4277, 'au', 'New South Wales', 'Tamworth Airport', 'YSTW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4278, 'au', 'Northern Territory', 'Tindal / Katherine', 'YPTN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4279, 'au', 'Queensland', 'Townsville Amo', 'YBTL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4280, 'au', 'New South Wales', 'Wagga Airport', 'YSWG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4281, 'iq', '', 'Baghdad', 'ORBB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4282, 'iq', '', 'Mosul', 'ORBM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4283, 'iq', '', 'Saddam Irq-AFB / CIV', 'ORBS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4284, 'iq', '', 'Shaibah / Basrah', 'ORMS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4285, 'fr', '', 'Agen', 'LFBA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4286, 'fr', '', 'Ajaccio', 'LFKJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4287, 'fr', '', 'Avord', 'LFOA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4288, 'fr', '', 'Bale-Mulhouse', 'LFSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4289, 'fr', '', 'Bastia', 'LFKB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4290, 'fr', '', 'Beauvais', 'LFOB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4291, 'fr', '', 'Bergerac', 'LFBE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4292, 'fr', '', 'Beziers / Vias', 'LFMU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4293, 'fr', '', 'Biarritz', 'LFBZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4294, 'fr', '', 'Bordeaux / Merignac', 'LFBD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4295, 'fr', '', 'Bourges', 'LFLD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4296, 'fr', '', 'Brest', 'LFRB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4297, 'fr', '', 'Caen', 'LFRK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4298, 'fr', '', 'Calvi', 'LFKC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4299, 'fr', '', 'Cambrai', 'LFQI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4300, 'fr', '', 'Cannes', 'LFMD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4301, 'fr', '', 'Carcassonne', 'LFMK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4302, 'fr', '', 'Cazaux', 'LFBC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4303, 'fr', '', 'Chalons-Vatry', 'LFOK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4304, 'fr', '', 'Chambery / Aix-Les-Bains', 'LFLB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4305, 'fr', '', 'Chateauroux', 'LFLX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4306, 'fr', '', 'Cherbourg / Maupertus', 'LFRC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4307, 'fr', '', 'Clermont-Ferrand', 'LFLC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4308, 'fr', '', 'Cognac', 'LFBG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4309, 'fr', '', 'Colmar', 'LFSC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4310, 'fr', '', 'Dijon', 'LFSD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4311, 'fr', '', 'Dinard', 'LFRD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4312, 'fr', '', 'Dole Tavaux', 'LFGJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4313, 'fr', '', 'Evreux', 'LFOE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4314, 'fr', '', 'Figari', 'LFKF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4315, 'fr', '', 'Grenoble / St. Geoirs', 'LFLS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4316, 'fr', '', 'Hyeres', 'LFTH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4317, 'fr', '', 'Istres', 'LFMI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4318, 'fr', '', 'La Rochelle', 'LFBH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4319, 'fr', '', 'Lann Bihoue', 'LFRH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4320, 'fr', '', 'Lannion / Servel', 'LFRO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4321, 'fr', '', 'Le Mans', 'LFRM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4322, 'fr', '', 'Lille', 'LFQQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4323, 'fr', '', 'Limoges', 'LFBL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4324, 'fr', '', 'Luxeuil', 'LFSX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4325, 'fr', '', 'Lyon / Bron', 'LFLY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4326, 'fr', '', 'Lyon / Satolas', 'LFLL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4327, 'fr', '', 'Marseille / Marignane', 'LFML', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4328, 'fr', '', 'Metz / Frescaty', 'LFSF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4329, 'fr', '', 'Metz-Nancy-Lorraine', 'LFJL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4330, 'fr', '', 'Mont-De-Marsan', 'LFBM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4331, 'fr', '', 'Montpellier', 'LFMT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4332, 'fr', '', 'Nancy / Ochey', 'LFSO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4333, 'fr', '', 'Nantes', 'LFRS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4334, 'fr', '', 'Nice', 'LFMN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4335, 'fr', '', 'Nimes / Garons', 'LFTW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4336, 'fr', '', 'Orange', 'LFMO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4337, 'fr', '', 'Orleans', 'LFOJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4338, 'fr', '', 'Paris / Le Bourget', 'LFPB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4339, 'fr', '', 'Paris-Aeroport Charles De Gaulle', 'LFPG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4340, 'fr', '', 'Paris-Orly', 'LFPO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4341, 'fr', '', 'Pau', 'LFBP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4342, 'fr', '', 'Perpignan', 'LFMP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4343, 'fr', '', 'Poitiers', 'LFBI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4344, 'fr', '', 'Quimper', 'LFRQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4345, 'fr', '', 'Reims', 'LFSR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4346, 'fr', '', 'Rennes', 'LFRN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4347, 'fr', '', 'Rodez', 'LFCR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4348, 'fr', '', 'Rouen', 'LFOP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4349, 'fr', '', 'Saint-Brieuc', 'LFRT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4350, 'fr', '', 'St-Dizier', 'LFSI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4351, 'fr', '', 'St-Etienne Boutheon', 'LFMH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4352, 'fr', '', 'St-Nazaire', 'LFRZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4353, 'fr', '', 'Strasbourg', 'LFST', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4354, 'fr', '', 'Tarbes / Ossun', 'LFBT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4355, 'fr', '', 'Toulouse / Blagnac', 'LFBO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4356, 'fr', '', 'Tours', 'LFOT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4357, 'fr', '', 'Toussus Le Noble', 'LFPN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4358, 'fr', '', 'Troyes', 'LFQB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4359, 'fr', '', 'Vichy', 'LFLV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4360, 'fr', '', 'Villacoublay', 'LFPV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4361, 'be', '', 'Antwerpen / Deurne', 'EBAW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4362, 'be', '', 'Beauvechain', 'EBBE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4363, 'be', '', 'Bierset', 'EBLG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4364, 'be', '', 'Brasschaat', 'EBBT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4365, 'be', '', 'Bruxelles National', 'EBBR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4366, 'be', '', 'Charleroi / Gosselies', 'EBCI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4367, 'be', '', 'Chievres', 'EBCV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4368, 'be', '', 'Elsenborn', 'EBLB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4369, 'be', '', 'Florennes', 'EBFS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4370, 'be', '', 'Kleine Brogel', 'EBBL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4372, 'be', '', 'Koksijde', 'EBFN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4373, 'be', '', 'Oostende Airport', 'EBOS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4374, 'be', '', 'Schaffen', 'EBDT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4375, 'co', '', 'Apartado / Los Cedros', 'SKLC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4376, 'co', '', 'Arauca / Santiago Perez', 'SKUC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4377, 'co', '', 'Armenia / El Eden', 'SKAR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4378, 'co', '', 'Barranquilla / Ernestocortissoz', 'SKBQ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4379, 'co', '', 'Bogota / Eldorado', 'SKBO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4380, 'co', '', 'Bucaramanga / Palonegro', 'SKBG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4381, 'co', '', 'Cali / Alfonso Bonillaaragon', 'SKCL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4382, 'co', '', 'Cartagena / Rafael Nunez', 'SKCG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4383, 'co', '', 'Cucuta / Camilo Daza', 'SKCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4384, 'co', '', 'Ibague / Perales', 'SKIB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4385, 'co', '', 'Ipiales / San Luis', 'SKIP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4386, 'co', '', 'Leticia / Vasquez Cobo', 'SKLT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4387, 'co', '', 'Medellin / Olaya Herrera', 'SKMD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4388, 'co', '', 'Monteria / Los Garzones', 'SKMR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4389, 'co', '', 'Neiva / Benito Salas', 'SKNV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4390, 'co', '', 'Pasto / Antonio Narin', 'SKPS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4391, 'co', '', 'Pereira / Matecana', 'SKPE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4392, 'co', '', 'Quibdo / El Carano', 'SKUI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4393, 'co', '', 'Riohacha / Almirante Padilla', 'SKRH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4394, 'co', '', 'Rionegro / J. M. Cordova', 'SKRG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4395, 'co', '', 'San Andres Isla / Sesquicentenario', 'SKSP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4396, 'co', '', 'Santa Marta / Simon Bolivar', 'SKSM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4397, 'co', '', 'Valledupar / Alfonso Lopez', 'SKVP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4398, 'co', '', 'Villavicencio / Vanguardia', 'SKVV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4399, 'nl', '', 'Amsterdam Airport Schiphol', 'EHAM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4400, 'nl', '', 'De Kooy', 'EHKD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4401, 'nl', '', 'Deelen', 'EHDL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4402, 'nl', '', 'Eindhoven', 'EHEH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4403, 'nl', '', 'Gilze-Rijen', 'EHGR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4404, 'nl', '', 'Groningen Airport Eelde', 'EHGG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4405, 'nl', '', 'Leeuwarden', 'EHLW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4406, 'nl', '', 'Lelystad', 'EHLE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4407, 'nl', '', 'Maastricht Airport Zuid Limburg', 'EHBK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4408, 'nl', '', 'Rotterdam Airport Zestienhoven', 'EHRD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4409, 'nl', '', 'Soesterberg', 'EHSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4410, 'nl', '', 'Twenthe', 'EHTW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4411, 'nl', '', 'Valkenburg', 'EHVB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4412, 'nl', '', 'Vlieland', 'EHVL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4413, 'nl', '', 'Volkel', 'EHVK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4414, 'nl', '', 'Woensdrecht', 'EHWO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4415, 'an', '', 'Flamingo Airport, Bonaire', 'TNCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4416, 'an', '', 'Hato Airport, Curacao', 'TNCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4417, 'an', '', 'Juliana Airport, Saint Maarten', 'TNCM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4418, 'an', '', 'Roosevelt Airport Saint Eustatius', 'TNCE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4419, 'il', '', 'Ben-Gurion International Airport', 'LLBG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4420, 'il', '', 'Eilat', 'LLET', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4421, 'il', '', 'Galilee / Pina', 'LLIB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4422, 'il', '', 'Ovda', 'LLOV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4423, 'il', '', 'Tel Aviv / Sde-Dov Airport', 'LLSD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4424, 'mx', '', 'Acapulco / G. Alvarez', 'MMAA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4425, 'mx', '', 'Aerop. Internacional Monterrey, N. L.', 'MMAN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4426, 'mx', '', 'Aguascalientes, Ags.', 'MMAS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4427, 'mx', '', 'Bahias De Huatulco', 'MMBT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4428, 'mx', '', 'Campeche, Camp.', 'MMCP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4429, 'mx', '', 'Cancun International Airport', 'MMUN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4430, 'mx', '', 'Chetumal, Q. Roo', 'MMCM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4431, 'mx', '', 'Chichen-Itza', 'MMCT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4432, 'mx', '', 'Chihuahua International Airport', 'MMCU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4433, 'mx', '', 'Ciudad Del Carmen', 'MMCE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4434, 'mx', '', 'Ciudad Juarez International', 'MMCS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4435, 'mx', '', 'Ciudad Victoria Airport', 'MMCV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4436, 'mx', '', 'Colima', 'MMIA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4437, 'mx', '', 'Cozumel Civ / Mil', 'MMCZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4438, 'mx', '', 'Cuernavaca, Mor.', 'MMCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4439, 'mx', '', 'Culiacan, Sin.', 'MMCL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4440, 'mx', '', 'Del Bajio / Leon', 'MMLO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4441, 'mx', '', 'Don Miguel / Guadalaj', 'MMGL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4442, 'mx', '', 'Durango Airport', 'MMDO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4443, 'mx', '', 'Guaymas International Airport', 'MMGM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4444, 'mx', '', 'Hermosillo, Son.', 'MMHO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4445, 'mx', '', 'Ixtapa-Zihuatanejo', 'MMZH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4446, 'mx', '', 'Ixtepec Ox', 'MMIT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4447, 'mx', '', 'La Paz International Airport', 'MMLP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4448, 'mx', '', 'Loreto, B. C. S.', 'MMLT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4449, 'mx', '', 'Los Mochis Airport', 'MMLM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4450, 'mx', '', 'Manzanillo International', 'MMZO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4451, 'mx', '', 'Matamoros International', 'MMMA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4452, 'mx', '', 'Mazatlan / G. Buelna', 'MMMZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4453, 'mx', '', 'Merida / lic Manuel Crecencio', 'MMMD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4454, 'mx', '', 'Mexicali International Airport', 'MMML', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4455, 'mx', '', 'Mexico City / Licenci', 'MMMX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4456, 'mx', '', 'Minatitlan', 'MMMT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4457, 'mx', '', 'Monclova, Coah.', 'MMMV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4458, 'mx', '', 'Monterrey / Gen Maria', 'MMMY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4459, 'mx', '', 'Morelia New', 'MMMM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4460, 'mx', '', 'Nuevo Laredo International', 'MMNL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4461, 'mx', '', 'Oaxaca / Xoxocotlan', 'MMOX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4462, 'mx', '', 'Piedras Negras, Coah.', 'MMPG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4463, 'mx', '', 'Poza Rica / Palizada', 'MMPA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4464, 'mx', '', 'Puebla, Pue.', 'MMPB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4465, 'mx', '', 'Puerto Escondido', 'MMPS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4466, 'mx', '', 'Puerto Vallarta / Lic', 'MMPR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4467, 'mx', '', 'Queretaro, Qro.', 'MMQT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4468, 'mx', '', 'Reynosa International Airport', 'MMRX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4469, 'mx', '', 'Saltillo, Coah.', 'MMIO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4470, 'mx', '', 'San Jose Del Cabo', 'MMSD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4471, 'mx', '', 'San Luis Potosi, S. L. P.', 'MMSP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4472, 'mx', '', 'Santa Rosalia, B. C. S.', 'MMCN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4473, 'mx', '', 'Tampico / Gen Fj Mina', 'MMTM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4474, 'mx', '', 'Tapachula', 'MMTP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4475, 'mx', '', 'Tepic, Nay.', 'MMEP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4476, 'mx', '', 'Tijuana International Airport', 'MMTJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4477, 'mx', '', 'Toluca / Jose Maria', 'MMTO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4478, 'mx', '', 'Torreon, Coah.', 'MMTC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4479, 'mx', '', 'Tuxtla Gutierrez, Chis.', 'MMTG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4480, 'mx', '', 'Uruapan / Gen Rayon', 'MMPN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4481, 'mx', '', 'Veracruz / Las Bajadas / General Heriberto Jara', 'MMVR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4482, 'mx', '', 'Villahermosa', 'MMVA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4483, 'mx', '', 'Zacatecas Airport', 'MMZC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4484, 'th', '', 'Chiang Mai', 'VTCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4485, 'th', '', 'Don Muang', 'VTBD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4486, 'th', '', 'Hat Yai', 'VTSS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4487, 'th', '', 'Phuket Airport', 'VTSP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4488, 'th', '', 'Rayong', 'VTBU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4489, 'my', '', 'Bintulu', 'WBGB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4490, 'my', '', 'Johore Bharu / Senai', 'WMKJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4491, 'my', '', 'Kota Kinabalu', 'WBKK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4492, 'my', '', 'Kuching', 'WBGG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4493, 'my', '', 'Kudat', 'WBKT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4494, 'my', '', 'Labuan', 'WBKL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4495, 'my', '', 'Miri', 'WBGR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4496, 'my', '', 'Penang / Bayan Lepas', 'WMKP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4497, 'my', '', 'Sandakan', 'WBKS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4498, 'my', '', 'Sebang/KL International Airport', 'WMKK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4499, 'my', '', 'Sibu', 'WBGS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4500, 'my', '', 'Subang/Sultan Abdul Aziz Shah Airport', 'WMSA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4501, 'my', '', 'Tawau', 'WBKW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4502, 'vn', '', 'Da Nang', 'VVDN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4503, 'vn', '', 'Ha Noi', 'VVNB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4504, 'vn', '', 'Ho Chi Minh', 'VVTS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4505, 'kh', '', 'Phnom-Penh / Pochentong', 'VDPP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4506, 'de', '', 'Altenburg Nobitz', 'EDAC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4507, 'de', '', 'Altenstadt', 'ETHA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4508, 'de', '', 'Augsburg', 'EDMA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4509, 'de', '', 'Baden Wurttemberg, Neuostheim', 'EDFM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4510, 'de', '', 'Bayreuth', 'EDQD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4511, 'de', '', 'Berlin-Schoenefeld', 'EDDB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4512, 'de', '', 'Berlin-Tegel', 'EDDT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4513, 'de', '', 'Berlin-Tempelhof', 'EDDI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4514, 'de', '', 'Braunschweig', 'EDVE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4515, 'de', '', 'Bremen', 'EDDW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4516, 'de', '', 'Buechel', 'ETSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4517, 'de', '', 'Bueckeburg', 'ETHB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4518, 'de', '', 'Celle', 'ETHC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4519, 'de', '', 'Diepholz', 'ETND', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4520, 'de', '', 'Donaueschingen / Villingen', 'EDTD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4521, 'de', '', 'Dortmund / Wickede', 'EDLW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4522, 'de', '', 'Dresden-Klotzsche', 'EDDC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4523, 'de', '', 'Duesseldorf', 'EDDL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4524, 'de', '', 'Eggebek', 'ETME', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4525, 'de', '', 'Erding', 'ETSE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4526, 'de', '', 'Erfurt-Bindersleben', 'EDDE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4527, 'de', '', 'Fassberg', 'ETHS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4528, 'de', '', 'Frankfurt / M-Flughafen', 'EDDF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4529, 'de', '', 'Friedrichshafen', 'EDNY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4530, 'de', '', 'Fritzlar', 'ETHF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4531, 'de', '', 'Gluecksburg / Meierwik', 'ETGG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4532, 'de', '', 'Guetersloh', 'ETUO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4533, 'de', '', 'Hahn', 'EDFH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4534, 'de', '', 'Hamburg-Finkenwerder', 'EDHI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4535, 'de', '', 'Hamburg-Fuhlsbuettel', 'EDDH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4536, 'de', '', 'Hannover', 'EDDV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4537, 'de', '', 'Heringsdorf', 'EDAH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4538, 'de', '', 'Hessen', 'EDGS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4539, 'de', '', 'Hof', 'EDQM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4540, 'de', '', 'Hohn', 'ETNH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4541, 'de', '', 'Holzdorf', 'ETSH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4542, 'de', '', 'Hopsten', 'ETNP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4543, 'de', '', 'Ingolstadt', 'ETSI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4544, 'de', '', 'Jever', 'ETNJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4545, 'de', '', 'Kalkar', 'ETGY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4546, 'de', '', 'Karlsruhe, Baden Wurttemberg', 'EDSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4547, 'de', '', 'Kassel / Calden', 'EDVK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4548, 'de', '', 'Kiel / Holtenau Civilian', 'EDHK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4549, 'de', '', 'Koeln / Bonn', 'EDDK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4550, 'de', '', 'Laage', 'ETNL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4551, 'de', '', 'Lahr, CAN-AFB', 'EDTL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4552, 'de', '', 'Landsberg', 'ETSA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4553, 'de', '', 'Laupheim', 'ETHL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4554, 'de', '', 'Lechfeld', 'ETSL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4555, 'de', '', 'Leipzig-Schkeuditz', 'EDDP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4556, 'de', '', 'Luebeck-Blankensee', 'EDHL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4557, 'de', '', 'Magdeburg, Sachsen-Anhalt', 'EDBM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4558, 'de', '', 'Mecklenburg-Vorpommern, Parchim', 'EDOP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4559, 'de', '', 'Mendig', 'ETHM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4560, 'de', '', 'Meppen-Mil', 'ETWM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4561, 'de', '', 'Messstetten', 'ETGZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4562, 'de', '', 'Monchengladbach', 'EDLN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4563, 'de', '', 'Muenster / Osnabrueck', 'EDDG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4564, 'de', '', 'Munchen', 'EDDM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4565, 'de', '', 'Neuburg / Donau', 'ETSN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4566, 'de', '', 'Niederrhein', 'EDLV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4567, 'de', '', 'Niederstetten', 'ETHN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4568, 'de', '', 'Noervenich', 'ETNN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4569, 'de', '', 'Nordholz', 'ETMN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4570, 'de', '', 'Nuernberg', 'EDDN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4571, 'de', '', 'Oberpfaffenhofen', 'EDMO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4572, 'de', '', 'Paderborn / Lippstadt', 'EDLP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4573, 'de', '', 'Ramstein', 'ETAR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4574, 'de', '', 'Rheine-Bentlage', 'ETHE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4575, 'de', '', 'Roth', 'ETHR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4576, 'de', '', 'Saarbruecken / Ensheim', 'EDDR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4577, 'de', '', 'Schleswig-Jagel', 'ETNS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4578, 'de', '', 'Spangdahlem', 'ETAD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4579, 'de', '', 'Stuttgart-Echterdingen', 'EDDS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4580, 'de', '', 'Trollenhagen', 'ETNU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4581, 'de', '', 'Westerland / Sylt', 'EDXW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4582, 'de', '', 'Wiesbaden', 'ETOU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4583, 'de', '', 'Wittmundhaven', 'ETNT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4584, 'de', '', 'Wunstorf', 'ETNW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4585, 'de', '', 'Zweibrucken, Rheinland-Pfalz', 'EDRZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4589, 'jp', '', 'Akeno Ab', 'RJOE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4590, 'jp', '', 'Akita Airport', 'RJSK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4591, 'jp', '', 'Amami Airport', 'RJKA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4592, 'jp', '', 'Aomori Airport', 'RJSA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4593, 'jp', '', 'Asahikawa Ab', 'RJCA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4594, 'jp', '', 'Asahikawa Airport', 'RJEC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4595, 'jp', '', 'Ashiya Ab', 'RJFA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4596, 'jp', '', 'Atsugi United States Naval Air Station', 'RJTA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4597, 'jp', '', 'Chitose Ab', 'RJCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4598, 'jp', '', 'Chitose Japanese Air Self Defense Force', 'RJCJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4599, 'jp', '', 'Chofu Airport', 'RJTF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4600, 'jp', '', 'Fuji Ab', 'RJAT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4601, 'jp', '', 'Fukue Airport', 'RJFE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4602, 'jp', '', 'Fukui Airport', 'RJNF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4603, 'jp', '', 'Fukuoka Airport', 'RJFF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4604, 'jp', '', 'Fukushima Airport', 'RJSF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4605, 'jp', '', 'Gifu Ab', 'RJNG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4606, 'jp', '', 'Hachijojima Airport', 'RJTH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4607, 'jp', '', 'Hachinohe Ab', 'RJSH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4608, 'jp', '', 'Hakodate Airport', 'RJCH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4609, 'jp', '', 'Hamamatsu Ab', 'RJNH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4610, 'jp', '', 'Hanamaki Airport', 'RJSI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4611, 'jp', '', 'Hiroshima Airport', 'RJOA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4612, 'jp', '', 'Hiroshimanishi', 'RJBH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4613, 'jp', '', 'Hofu Ab', 'RJOF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4614, 'jp', '', 'Hyakuri Ab', 'RJAH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4615, 'jp', '', 'Iki Airport', 'RJDB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4616, 'jp', '', 'Iruma Ab', 'RJTJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4617, 'jp', '', 'Ishigakijima', 'ROIG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4618, 'jp', '', 'Iwakuni Marine Corps Air Station', 'RJOI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4619, 'jp', '', 'Iwami Airport', 'RJOW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4620, 'jp', '', 'Iwojima', 'RJAW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4621, 'jp', '', 'Izumo Airport', 'RJOC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4622, 'jp', '', 'Kadena Ab', 'RODN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4623, 'jp', '', 'Kagoshima Airport', 'RJFK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4624, 'jp', '', 'Kanoya Ab', 'RJFY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4625, 'jp', '', 'Kansai International Airport', 'RJBB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4626, 'jp', '', 'Kasumigaura Ab', 'RJAK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4627, 'jp', '', 'Kasuminome Ab', 'RJSU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4628, 'jp', '', 'Kisarazu Ab', 'RJTK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4629, 'jp', '', 'Kitakyushu Airport', 'RJFR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4630, 'jp', '', 'Kochi Airport', 'RJOK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4631, 'jp', '', 'Komatsu Ab', 'RJNK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4632, 'jp', '', 'Komatsujima Ab', 'RJOP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4633, 'jp', '', 'Kumamoto Airport', 'RJFT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4634, 'jp', '', 'Kumejima', 'ROKJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4635, 'jp', '', 'Kushiro Airport', 'RJCK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4636, 'jp', '', 'Matsumoto Airport', 'RJAF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4637, 'jp', '', 'Matsushima Ab', 'RJST', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4638, 'jp', '', 'Matsuyama Airport', 'RJOM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4639, 'jp', '', 'Memambetsu Airport', 'RJCM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4640, 'jp', '', 'Metabaru Ab', 'RJDM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4641, 'jp', '', 'Miho Ab', 'RJOH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4642, 'jp', '', 'Misawa Ab', 'RJSM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4643, 'jp', '', 'Miyakojima', 'ROMY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4644, 'jp', '', 'Miyazaki Airport', 'RJFM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4645, 'jp', '', 'Mombetsu Airport', 'RJEB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4646, 'jp', '', 'Nagasaki Airport', 'RJFU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4647, 'jp', '', 'Nagoya Airport', 'RJNN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4648, 'jp', '', 'Naha Airport', 'ROAH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4649, 'jp', '', 'Nakashibetsu Airport', 'RJCN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4650, 'jp', '', 'Nankishirahama Airport', 'RJBD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4651, 'jp', '', 'New Tokyo Inter-National Airport', 'RJAA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4652, 'jp', '', 'Niigata Airport', 'RJSN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4653, 'jp', '', 'Nyutabaru Ab', 'RJFN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4654, 'jp', '', 'Obihiro Airport', 'RJCB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4655, 'jp', '', 'Odate-Noshiro Airport', 'RJSR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4656, 'jp', '', 'Oita Airport', 'RJFO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4657, 'jp', '', 'Okayama Airport', 'RJOB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4658, 'jp', '', 'Oki Airport', 'RJNO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4659, 'jp', '', 'Okinoerabu', 'RJKB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4660, 'jp', '', 'Ominato Ab', 'RJSO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4661, 'jp', '', 'Osaka International Airport', 'RJOO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4662, 'jp', '', 'Oshima Airport', 'RJTO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4663, 'jp', '', 'Ozuki Ab', 'RJOZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4664, 'jp', '', 'Saga Airport', 'RJFS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4665, 'jp', '', 'Sapporo Ab', 'RJCO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4666, 'jp', '', 'Sendai Airport', 'RJSS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4667, 'jp', '', 'Shimofusa Ab', 'RJTL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4668, 'jp', '', 'Shimoji-Shima Island', 'RORS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4669, 'jp', '', 'Shizuhama Ab', 'RJNY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4670, 'jp', '', 'Shonai', 'RJSY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4671, 'jp', '', 'Tachikawa Ab', 'RJTC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4672, 'jp', '', 'Tajima', 'RJBT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4673, 'jp', '', 'Takamatsu Airport', 'RJOT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4674, 'jp', '', 'Tanegashima Airport', 'RJFG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4675, 'jp', '', 'Tateyama Ab', 'RJTE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4676, 'jp', '', 'Tokachi Japanese Ground Self Defense Force', 'RJCT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4677, 'jp', '', 'Tokushima Ab', 'RJOS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4678, 'jp', '', 'Tokyo Heliport', 'RJTI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4679, 'jp', '', 'Tokyo International Airport', 'RJTT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4680, 'jp', '', 'Tottori Airport', 'RJOR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4681, 'jp', '', 'Toyama Airport', 'RJNT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4682, 'jp', '', 'Tsuiki Ab', 'RJFZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4683, 'jp', '', 'Tsushima Airport', 'RJDT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4684, 'jp', '', 'Utsunomiya Ab', 'RJTU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4685, 'jp', '', 'Wakkanai Airport', 'RJCW', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4686, 'jp', '', 'Yakushima', 'RJFC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4687, 'jp', '', 'Yamagata Airport', 'RJSC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4688, 'jp', '', 'Yamaguchi Ube Airport', 'RJDC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4689, 'jp', '', 'Yao Airport', 'RJOY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4690, 'jp', '', 'Yokosuka Fwf', 'RJTX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4691, 'jp', '', 'Yokota Ab', 'RJTY', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4692, 'jp', '', 'Yonaguni Airport', 'ROYN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4693, 'jp', '', 'Zama Airfield', 'RJTR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4694, 'nz', '', 'Auckland Airport', 'NZAA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4695, 'nz', '', 'Christchurch', 'NZCH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4696, 'nz', '', 'Ohakea', 'NZOH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4697, 'nz', '', 'Wellington Airport', 'NZWN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4698, 'nz', '', 'Williams Field, Antarctic', 'NZWD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4699, 'vg', '', 'Beef Island, Tortola', 'TUPJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4700, 'vg', '', 'Charlotte Amalie St. Thomas, Cyril E. King Airport', 'TIST', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4701, 'vg', '', 'Christiansted, Henry E. Rohlsen Airport', 'TISX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4702, 'bm', '', 'Bermuda', 'TXKF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4703, 'cu', '', 'Aeropuerto Jose Marti, Rancho-Boyeros, Habana', 'MUHA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4704, 'cu', '', 'Camaguey Aeropuerto', 'MUCM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4705, 'cu', '', 'Cayo Coco / Jardines Del Ray', 'MUCC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4706, 'cu', '', 'Cayo Largo Del Sur', 'MUCL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4707, 'cu', '', 'Cienfuegos, Las Villas', 'MUCF', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4708, 'cu', '', 'Guantanamo, Oriente', 'MUGM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4709, 'cu', '', 'Holguin Civ / Mil', 'MUHG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4710, 'cu', '', 'Santiago De Cuba, Oriente', 'MUCU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4711, 'cu', '', 'Varadero, Matanzas', 'MUVR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4712, 'cu', '', 'Venezuela, Ciego De Avila', 'MUCA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4713, 'jm', '', 'Kingston / Norman Manley', 'MKJP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4714, 'jm', '', 'Montego Bay / Sangster', 'MKJS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4715, 'ug', '', 'Arua', 'HUAR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4716, 'ug', '', 'Entebbe Airport', 'HUEN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4717, 'ug', '', 'Fort Portal', 'HUFP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4718, 'ug', '', 'Gulu', 'HUGU', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4719, 'ug', '', 'Jinja', 'HUJI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4720, 'ug', '', 'Kabale', 'HUKB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4721, 'ug', '', 'Kasese', 'HUKS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4722, 'ug', '', 'Lira', 'HULI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4723, 'ug', '', 'Mbarara', 'HUMA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4724, 'ug', '', 'Masindi', 'HUMI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4725, 'ug', '', 'Moroto', 'HUMO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4726, 'ug', '', 'Soroti', 'HUSO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4727, 'ug', '', 'Tororo', 'HUTO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4728, 'hu', '', 'Budapest / Ferihegy', 'LHBP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4729, 'hu', '', 'Debrecen', 'LHDC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4730, 'hu', '', 'Kecskemet', 'LHKE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4731, 'hu', '', 'Pecs / Pogany', 'LHPP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4732, 'hu', '', 'Szeged', 'LHUD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4733, 'hu', '', 'Szentkiralyszabadja', 'LHSA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4734, 'hu', '', 'Szolnok', 'LHSN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4735, 'hu', '', 'Taszar', 'LHTA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4736, 'ro', '', 'Arad', 'LRAR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4737, 'ro', '', 'Bacau', 'LRBC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4738, 'ro', '', 'Baia Mare', 'LRBM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4739, 'ro', '', 'Bucuresti / Imh', 'LRBS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4740, 'ro', '', 'Bucuresti Otopeni', 'LROP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4741, 'ro', '', 'Caransebes', 'LRCS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4742, 'ro', '', 'Cluj-Napoca', 'LRCL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4743, 'ro', '', 'Craiova', 'LRCV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4744, 'ro', '', 'Iasi', 'LRIA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4745, 'ro', '', 'Kogalniceanu', 'LRCK', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4746, 'ro', '', 'Oradea', 'LROD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4747, 'ro', '', 'Satu Mare', 'LRSM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4748, 'ro', '', 'Sibiu', 'LRSB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4749, 'ro', '', 'Suceava / Salcea', 'LRSV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4750, 'ro', '', 'Timisoara', 'LRTR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4751, 'ro', '', 'Tirgu Mures', 'LRTM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4752, 'ro', '', 'Tulcea', 'LRTC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4753, 'es', '', 'Albacete / Los Llanos', 'LEAB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4754, 'es', '', 'Alicante / El Altet', 'LEAL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4755, 'es', '', 'Almeria / Aeropuerto', 'LEAM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4756, 'es', '', 'Asturias / Aviles', 'LEAS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4757, 'es', '', 'Badajoz / Talavera La Real', 'LEBZ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4758, 'es', '', 'Barcelona / Aeropuerto', 'LEBL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4759, 'es', '', 'Bilbao / Sondica', 'LEBB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4760, 'es', '', 'Cordoba / Aeropuerto', 'LEBA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4761, 'es', '', 'Fuerteventura / Aeropuerto', 'GCFV', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4762, 'es', '', 'Gerona / Costa Brava', 'LEGE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4763, 'es', '', 'Granada / Aeropuerto', 'LEGR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4764, 'es', '', 'Granada / Armilla', 'LEGA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4765, 'es', '', 'Hierro / Aeropuerto', 'GCHI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4766, 'es', '', 'Ibiza / Es Codola', 'LEIB', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4767, 'es', '', 'Jerez De La Fronteraaeropuerto', 'LEJR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4768, 'es', '', 'La Coruna / Alvedro', 'LECO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4769, 'es', '', 'La Palma / Aeropuerto', 'GCLA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4770, 'es', '', 'Lanzarote / Aeropuerto', 'GCRR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4771, 'es', '', 'Las Palmas De Gran Canaria / Gando', 'GCLP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4772, 'es', '', 'Leon / Virgen Del Camino', 'LELN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4773, 'es', '', 'Madrid / Barajas', 'LEMD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4774, 'es', '', 'Madrid / Cuatro Vientos', 'LEVS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4775, 'es', '', 'Madrid / Getafe', 'LEGT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4776, 'es', '', 'Madrid / Torrejon', 'LETO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4777, 'es', '', 'Malaga / Aeropuerto', 'LEMG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4778, 'es', '', 'Melilla', 'GEML', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4779, 'es', '', 'Menorca / Mahon', 'LEMH', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4780, 'es', '', 'Moron De La Frontera', 'LEMO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4781, 'es', '', 'Murcia / Alcantarilla', 'LERI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4782, 'es', '', 'Murcia / San Javier', 'LELC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4783, 'es', '', 'Palma De Mallorca / Son San Juan', 'LEPA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4784, 'es', '', 'Pamplona / Noain', 'LEPP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4785, 'es', '', 'Reus / Aeropuerto', 'LERS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4786, 'es', '', 'Rota', 'LERT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4787, 'es', '', 'Salamanca / Matacan', 'LESA', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4788, 'es', '', 'San Sebastian / Fuenterrabia', 'LESO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4789, 'es', '', 'Santander / Parayas', 'LEXJ', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4790, 'es', '', 'Santiago / Labacolla', 'LEST', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4791, 'es', '', 'Sevilla / San Pablo', 'LEZL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4792, 'es', '', 'Tenerife / Los Rodeos', 'GCXO', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4793, 'es', '', 'Tenerife Sur', 'GCTS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4794, 'es', '', 'Valencia / Aeropuerto', 'LEVC', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4795, 'es', '', 'Valladolid / Villanubla', 'LEVD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4796, 'es', '', 'Vigo / Peinador', 'LEVX', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4797, 'es', '', 'Vitoria', 'LEVT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4798, 'es', '', 'Zaragoza / Aeropuerto', 'LEZG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4799, 'za', '', 'Bloemfontein J. B. M. Hertzog', 'FABL', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4800, 'za', '', 'Cape Town D. F. Malan', 'FACT', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4801, 'za', '', 'Durban Louis Botha', 'FADN', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4802, 'za', '', 'George Airport', 'FAGG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4803, 'za', '', 'Johannesburg, Johannesburg International Airport', 'FAJS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4804, 'za', '', 'Kimberley', 'FAKM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4805, 'za', '', 'Klerksdorp', 'FAKD', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4806, 'za', '', 'Mmabatho Airport', 'FAMM', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4807, 'za', '', 'Port Elizabeth', 'FAPE', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4808, 'za', '', 'Potchefstroom', 'FAPS', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4809, 'za', '', 'Rustenburg', 'FARG', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4810, 'za', '', 'Springs', 'FASI', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4811, 'za', '', 'Standerton', 'FASR', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4812, 'za', '', 'Upington', 'FAUP', '', '', '', '')";
	$queries[] = "INSERT INTO ".$prefix."_weatherstations VALUES (4813, 'za', '', 'Vereeniging', 'FAVV', '', '', '', '')";
	
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1, '01001', 'alz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2, '01003', 'alz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3, '01003', 'alz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4, '01005', 'alz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (5, '01007', 'alz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (6, '01009', 'alz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (7, '01011', 'alz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (8, '01013', 'alz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (9, '01015', 'alz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (10, '01017', 'alz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (11, '01019', 'alz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (12, '01021', 'alz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (13, '01023', 'alz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (14, '01025', 'alz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (15, '01027', 'alz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (16, '01029', 'alz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (17, '01031', 'alz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (18, '01033', 'alz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (19, '01035', 'alz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (20, '01037', 'alz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (21, '01039', 'alz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (22, '01041', 'alz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (23, '01043', 'alz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (24, '01045', 'alz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (25, '01047', 'alz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (26, '01049', 'alz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (27, '01051', 'alz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (28, '01053', 'alz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (29, '01055', 'alz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (30, '01057', 'alz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (31, '01059', 'alz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (32, '01061', 'alz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (33, '01063', 'alz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (34, '01065', 'alz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (35, '01067', 'alz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (36, '01069', 'alz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (37, '01071', 'alz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (38, '01073', 'alz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (39, '01075', 'alz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (40, '01077', 'alz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (41, '01079', 'alz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (42, '01081', 'alz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (43, '01083', 'alz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (44, '01085', 'alz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (45, '01087', 'alz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (46, '01089', 'alz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (47, '01091', 'alz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (48, '01093', 'alz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (49, '01095', 'alz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (50, '01097', 'alz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (51, '01097', 'alz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (52, '01099', 'alz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (53, '01101', 'alz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (54, '01103', 'alz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (55, '01105', 'alz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (56, '01107', 'alz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (57, '01109', 'alz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (58, '01111', 'alz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (59, '01113', 'alz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (60, '01115', 'alz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (61, '01117', 'alz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (62, '01119', 'alz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (63, '01121', 'alz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (64, '01123', 'alz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (65, '01125', 'alz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (66, '01127', 'alz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (67, '01129', 'alz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (68, '01131', 'alz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (69, '01133', 'alz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (70, '02013', 'akz181')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (71, '02013', 'akz185')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (72, '02016', 'akz181')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (73, '02016', 'akz185')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (74, '02016', 'akz191')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (75, '02016', 'akz195')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (76, '02020', 'akz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (77, '02020', 'akz111')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (78, '02020', 'akz125')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (79, '02020', 'akz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (80, '02020', 'akz145')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (81, '02050', 'akz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (82, '02050', 'akz155')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (83, '02050', 'akz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (84, '02050', 'akz214')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (85, '02050', 'akz215')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (86, '02060', 'akz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (87, '02068', 'akz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (88, '02068', 'akz145')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (89, '02068', 'akz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (90, '02068', 'akz221')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (91, '02068', 'akz223')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (92, '02068', 'akz225')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (93, '02068', 'akz226')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (94, '02070', 'akz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (95, '02070', 'akz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (96, '02090', 'akz220')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (97, '02090', 'akz221')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (98, '02090', 'akz222')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (99, '02090', 'akz223')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (100, '02090', 'akz224')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (101, '02100', 'akz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (102, '02100', 'akz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (103, '02100', 'akz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (104, '02122', 'akz121')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (105, '02122', 'akz125')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (106, '02122', 'akz145')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (107, '02122', 'akz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (108, '02122', 'akz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (109, '02122', 'akz171')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (110, '02150', 'akz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (111, '02150', 'akz171')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (112, '02150', 'akz185')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (113, '02164', 'akz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (114, '02164', 'akz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (115, '02164', 'akz171')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (116, '02164', 'akz181')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (117, '02170', 'akz111')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (118, '02170', 'akz125')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (119, '02170', 'akz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (120, '02170', 'akz145')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (121, '02180', 'akz207')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (122, '02180', 'akz210')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (123, '02180', 'akz211')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (124, '02180', 'akz212')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (125, '02180', 'akz213')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (126, '02180', 'akz214')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (127, '02180', 'akz215')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (128, '02185', 'akz201')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (129, '02185', 'akz202')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (130, '02185', 'akz203')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (131, '02185', 'akz204')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (132, '02185', 'akz205')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (133, '02185', 'akz206')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (134, '02185', 'akz207')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (135, '02185', 'akz208')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (136, '02185', 'akz217')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (137, '02185', 'akz218')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (138, '02188', 'akz205')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (139, '02188', 'akz207')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (140, '02188', 'akz208')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (141, '02188', 'akz209')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (142, '02188', 'akz210')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (143, '02188', 'akz216')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (144, '02188', 'akz217')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (145, '02188', 'akz218')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (146, '02188', 'akz219')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (147, '02201', 'akz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (148, '02201', 'akz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (149, '02201', 'akz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (150, '02201', 'akz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (151, '02210', 'akz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (152, '02210', 'akz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (153, '02220', 'akz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (154, '02220', 'akz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (155, '02220', 'akz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (156, '02232', 'akz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (157, '02232', 'akz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (158, '02232', 'akz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (159, '02232', 'akz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (160, '02240', 'akz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (161, '02240', 'akz223')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (162, '02240', 'akz224')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (163, '02240', 'akz226')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (164, '02261', 'akz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (165, '02261', 'akz125')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (166, '02261', 'akz131')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (167, '02261', 'akz135')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (168, '02261', 'akz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (169, '02261', 'akz224')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (170, '02261', 'akz226')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (171, '02270', 'akz155')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (172, '02270', 'akz212')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (173, '02270', 'akz214')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (174, '02270', 'akz215')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (175, '02280', 'akz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (176, '02280', 'akz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (177, '02280', 'akz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (178, '02280', 'akz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (179, '02280', 'akz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (180, '02280', 'akz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (181, '02282', 'akz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (182, '02290', 'akz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (183, '02290', 'akz205')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (184, '02290', 'akz206')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (185, '02290', 'akz210')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (186, '02290', 'akz212')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (187, '02290', 'akz215')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (188, '02290', 'akz216')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (189, '02290', 'akz217')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (190, '02290', 'akz218')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (191, '02290', 'akz219')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (192, '02290', 'akz220')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (193, '02290', 'akz221')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (194, '02290', 'akz222')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (195, '02290', 'akz223')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (196, '02290', 'akz224')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (197, '04001', 'azz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (198, '04001', 'azz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (199, '04001', 'azz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (200, '04001', 'azz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (201, '04001', 'azz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (202, '04001', 'azz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (203, '04003', 'azz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (204, '04005', 'azz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (205, '04005', 'azz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (206, '04005', 'azz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (207, '04005', 'azz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (208, '04005', 'azz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (209, '04005', 'azz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (210, '04005', 'azz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (211, '04005', 'azz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (212, '04005', 'azz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (213, '04005', 'azz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (214, '04007', 'azz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (215, '04007', 'azz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (216, '04009', 'azz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (217, '04011', 'azz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (218, '04011', 'azz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (219, '04012', 'azz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (220, '04012', 'azz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (221, '04012', 'azz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (222, '04013', 'azz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (223, '04013', 'azz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (224, '04013', 'azz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (225, '04013', 'azz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (226, '04015', 'azz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (227, '04015', 'azz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (228, '04015', 'azz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (229, '04015', 'azz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (230, '04017', 'azz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (231, '04017', 'azz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (232, '04017', 'azz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (233, '04017', 'azz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (234, '04017', 'azz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (235, '04017', 'azz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (236, '04017', 'azz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (237, '04019', 'azz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (238, '04019', 'azz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (239, '04019', 'azz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (240, '04021', 'azz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (241, '04021', 'azz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (242, '04021', 'azz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (243, '04023', 'azz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (244, '04025', 'azz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (245, '04025', 'azz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (246, '04025', 'azz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (247, '04025', 'azz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (248, '04027', 'azz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (249, '04027', 'azz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (250, '05001', 'arz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (251, '05003', 'arz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (252, '05005', 'arz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (253, '05007', 'arz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (254, '05009', 'arz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (255, '05011', 'arz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (256, '05013', 'arz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (257, '05015', 'arz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (258, '05017', 'arz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (259, '05019', 'arz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (260, '05021', 'arz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (261, '05023', 'arz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (262, '05025', 'arz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (263, '05027', 'arz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (264, '05029', 'arz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (265, '05031', 'arz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (266, '05033', 'arz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (267, '05035', 'arz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (268, '05037', 'arz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (269, '05039', 'arz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (270, '05041', 'arz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (271, '05043', 'arz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (272, '05045', 'arz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (273, '05047', 'arz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (274, '05049', 'arz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (275, '05051', 'arz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (276, '05053', 'arz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (277, '05055', 'arz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (278, '05057', 'arz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (279, '05059', 'arz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (280, '05061', 'arz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (281, '05063', 'arz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (282, '05065', 'arz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (283, '05067', 'arz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (284, '05069', 'arz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (285, '05071', 'arz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (286, '05073', 'arz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (287, '05075', 'arz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (288, '05077', 'arz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (289, '05079', 'arz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (290, '05081', 'arz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (291, '05083', 'arz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (292, '05085', 'arz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (293, '05087', 'arz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (294, '05089', 'arz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (295, '05091', 'arz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (296, '05093', 'arz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (297, '05095', 'arz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (298, '05097', 'arz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (299, '05099', 'arz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (300, '05101', 'arz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (301, '05103', 'arz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (302, '05105', 'arz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (303, '05107', 'arz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (304, '05109', 'arz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (305, '05111', 'arz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (306, '05113', 'arz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (307, '05115', 'arz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (308, '05117', 'arz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (309, '05119', 'arz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (310, '05121', 'arz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (311, '05123', 'arz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (312, '05125', 'arz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (313, '05127', 'arz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (314, '05129', 'arz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (315, '05131', 'arz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (316, '05133', 'arz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (317, '05135', 'arz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (318, '05137', 'arz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (319, '05139', 'arz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (320, '05141', 'arz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (321, '05143', 'arz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (322, '05145', 'arz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (323, '05147', 'arz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (324, '05149', 'arz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (325, '06001', 'caz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (326, '06003', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (327, '06003', 'caz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (328, '06005', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (329, '06005', 'caz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (330, '06005', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (331, '06005', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (332, '06007', 'caz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (333, '06007', 'caz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (334, '06007', 'caz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (335, '06009', 'caz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (336, '06009', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (337, '06009', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (338, '06011', 'caz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (339, '06011', 'caz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (340, '06013', 'caz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (341, '06015', 'caz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (342, '06015', 'caz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (343, '06017', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (344, '06017', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (345, '06017', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (346, '06017', 'caz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (347, '06019', 'caz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (348, '06019', 'caz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (349, '06019', 'caz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (350, '06019', 'caz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (351, '06021', 'caz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (352, '06021', 'caz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (353, '06023', 'caz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (354, '06023', 'caz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (355, '06023', 'caz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (356, '06023', 'caz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (357, '06025', 'caz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (358, '06025', 'caz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (359, '06027', 'caz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (360, '06027', 'caz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (361, '06029', 'caz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (362, '06029', 'caz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (363, '06029', 'caz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (364, '06029', 'caz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (365, '06029', 'caz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (366, '06031', 'caz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (367, '06033', 'caz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (368, '06033', 'caz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (369, '06035', 'caz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (370, '06035', 'caz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (371, '06037', 'caz041')";
	
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (372, '06037', 'caz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (373, '06037', 'caz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (374, '06037', 'caz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (375, '06037', 'caz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (376, '06037', 'caz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (377, '06037', 'caz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (378, '06039', 'caz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (379, '06039', 'caz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (380, '06039', 'caz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (381, '06041', 'caz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (382, '06043', 'caz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (383, '06043', 'caz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (384, '06043', 'caz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (385, '06045', 'caz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (386, '06045', 'caz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (387, '06045', 'caz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (388, '06047', 'caz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (389, '06047', 'caz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (390, '06049', 'caz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (391, '06049', 'caz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (392, '06049', 'caz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (393, '06051', 'caz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (394, '06053', 'caz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (395, '06053', 'caz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (396, '06055', 'caz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (397, '06057', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (398, '06057', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (399, '06057', 'caz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (400, '06059', 'caz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (401, '06059', 'caz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (402, '06061', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (403, '06061', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (404, '06061', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (405, '06061', 'caz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (406, '06063', 'caz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (407, '06063', 'caz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (408, '06065', 'caz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (409, '06065', 'caz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (410, '06065', 'caz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (411, '06065', 'caz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (412, '06065', 'caz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (413, '06065', 'caz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (414, '06065', 'caz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (415, '06065', 'caz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (416, '06067', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (417, '06067', 'caz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (418, '06069', 'caz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (419, '06071', 'caz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (420, '06071', 'caz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (421, '06071', 'caz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (422, '06071', 'caz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (423, '06071', 'caz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (424, '06071', 'caz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (425, '06073', 'caz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (426, '06073', 'caz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (427, '06073', 'caz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (428, '06073', 'caz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (429, '06073', 'caz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (430, '06075', 'caz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (431, '06077', 'caz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (432, '06077', 'caz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (433, '06079', 'caz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (434, '06079', 'caz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (435, '06079', 'caz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (436, '06081', 'caz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (437, '06083', 'caz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (438, '06083', 'caz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (439, '06083', 'caz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (440, '06083', 'caz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (441, '06083', 'caz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (442, '06085', 'caz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (443, '06087', 'caz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (444, '06089', 'caz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (445, '06089', 'caz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (446, '06089', 'caz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (447, '06089', 'caz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (448, '06089', 'caz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (449, '06089', 'caz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (450, '06091', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (451, '06091', 'caz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (452, '06093', 'caz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (453, '06093', 'caz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (454, '06093', 'caz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (455, '06093', 'caz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (456, '06093', 'caz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (457, '06095', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (458, '06095', 'caz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (459, '06097', 'caz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (460, '06099', 'caz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (461, '06101', 'caz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (462, '06101', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (463, '06103', 'caz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (464, '06103', 'caz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (465, '06103', 'caz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (466, '06103', 'caz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (467, '06105', 'caz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (468, '06105', 'caz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (469, '06107', 'caz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (470, '06107', 'caz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (471, '06107', 'caz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (472, '06109', 'caz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (473, '06109', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (474, '06109', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (475, '06109', 'caz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (476, '06111', 'caz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (477, '06111', 'caz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (478, '06111', 'caz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (479, '06111', 'caz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (480, '06113', 'caz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (481, '06115', 'caz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (482, '06115', 'caz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (483, '06115', 'caz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (484, '08001', 'coz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (485, '08001', 'coz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (486, '08003', 'coz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (487, '08003', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (488, '08003', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (489, '08005', 'coz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (490, '08005', 'coz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (491, '08005', 'coz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (492, '08007', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (493, '08007', 'coz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (494, '08009', 'coz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (495, '08011', 'coz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (496, '08013', 'coz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (497, '08013', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (498, '08013', 'coz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (499, '08013', 'coz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (500, '08014', 'coz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (501, '08014', 'coz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (502, '08015', 'coz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (503, '08015', 'coz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (504, '08015', 'coz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (505, '08015', 'coz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (506, '08015', 'coz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (507, '08015', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (508, '08015', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (509, '08017', 'coz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (510, '08019', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (511, '08019', 'coz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (512, '08021', 'coz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (513, '08021', 'coz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (514, '08021', 'coz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (515, '08023', 'coz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (516, '08023', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (517, '08023', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (518, '08023', 'coz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (519, '08023', 'coz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (520, '08025', 'coz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (521, '08027', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (522, '08027', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (523, '08027', 'coz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (524, '08027', 'coz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (525, '08027', 'coz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (526, '08027', 'coz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (527, '08029', 'coz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (528, '08029', 'coz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (529, '08029', 'coz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (530, '08029', 'coz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (531, '08031', 'coz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (532, '08033', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (533, '08033', 'coz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (534, '08033', 'coz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (535, '08035', 'coz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (536, '08035', 'coz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (537, '08035', 'coz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (538, '08037', 'coz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (539, '08037', 'coz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (540, '08037', 'coz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (541, '08039', 'coz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (542, '08039', 'coz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (543, '08039', 'coz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (544, '08041', 'coz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (545, '08041', 'coz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (546, '08041', 'coz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (547, '08041', 'coz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (548, '08043', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (549, '08043', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (550, '08043', 'coz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (551, '08043', 'coz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (552, '08043', 'coz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (553, '08043', 'coz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (554, '08043', 'coz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (555, '08043', 'coz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (556, '08045', 'coz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (557, '08045', 'coz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (558, '08045', 'coz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (559, '08045', 'coz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (560, '08045', 'coz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (561, '08045', 'coz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (562, '08045', 'coz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (563, '08045', 'coz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (564, '08047', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (565, '08047', 'coz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (566, '08049', 'coz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (567, '08049', 'coz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (568, '08049', 'coz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (569, '08049', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (570, '08051', 'coz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (571, '08051', 'coz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (572, '08051', 'coz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (573, '08051', 'coz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (574, '08053', 'coz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (575, '08053', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (576, '08055', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (577, '08055', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (578, '08055', 'coz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (579, '08055', 'coz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (580, '08055', 'coz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (581, '08055', 'coz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (582, '08055', 'coz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (583, '08055', 'coz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (584, '08057', 'coz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (585, '08057', 'coz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (586, '08057', 'coz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (587, '08059', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (588, '08059', 'coz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (589, '08059', 'coz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (590, '08061', 'coz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (591, '08061', 'coz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (592, '08063', 'coz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (593, '08065', 'coz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (594, '08065', 'coz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (595, '08065', 'coz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (596, '08067', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (597, '08067', 'coz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (598, '08069', 'coz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (599, '08069', 'coz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (600, '08069', 'coz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (601, '08071', 'coz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (602, '08071', 'coz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (603, '08071', 'coz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (604, '08071', 'coz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (605, '08073', 'coz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (606, '08073', 'coz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (607, '08075', 'coz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (608, '08077', 'coz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (609, '08077', 'coz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (610, '08077', 'coz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (611, '08077', 'coz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (612, '08077', 'coz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (613, '08077', 'coz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (614, '08077', 'coz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (615, '08079', 'coz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (616, '08079', 'coz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (617, '08079', 'coz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (618, '08081', 'coz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (619, '08081', 'coz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (620, '08081', 'coz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (621, '08081', 'coz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (622, '08083', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (623, '08083', 'coz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (624, '08085', 'coz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (625, '08085', 'coz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (626, '08085', 'coz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (627, '08085', 'coz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (628, '08085', 'coz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (629, '08085', 'coz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (630, '08087', 'coz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (631, '08089', 'coz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (632, '08091', 'coz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (633, '08091', 'coz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (634, '08093', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (635, '08093', 'coz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (636, '08093', 'coz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (637, '08095', 'coz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (638, '08097', 'coz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (639, '08097', 'coz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (640, '08099', 'coz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (641, '08101', 'coz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (642, '08101', 'coz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (643, '08101', 'coz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (644, '08103', 'coz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (645, '08103', 'coz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (646, '08103', 'coz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (647, '08103', 'coz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (648, '08105', 'coz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (649, '08105', 'coz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (650, '08105', 'coz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (651, '08105', 'coz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (652, '08105', 'coz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (653, '08105', 'coz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (654, '08107', 'coz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (655, '08107', 'coz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (656, '08107', 'coz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (657, '08107', 'coz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (658, '08109', 'coz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (659, '08109', 'coz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (660, '08109', 'coz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (661, '08109', 'coz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (662, '08109', 'coz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (663, '08109', 'coz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (664, '08109', 'coz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (665, '08111', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (666, '08113', 'coz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (667, '08113', 'coz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (668, '08113', 'coz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (669, '08113', 'coz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (670, '08113', 'coz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (671, '08115', 'coz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (672, '08117', 'coz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (673, '08117', 'coz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (674, '08119', 'coz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (675, '08119', 'coz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (676, '08119', 'coz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (677, '08121', 'coz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (678, '08123', 'coz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (679, '08123', 'coz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (680, '08123', 'coz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (681, '08125', 'coz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (682, '09001', 'ctz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (683, '09001', 'ctz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (684, '09003', 'ctz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (685, '09005', 'ctz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (686, '09005', 'ctz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (687, '09007', 'ctz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (688, '09007', 'ctz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (689, '09009', 'ctz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (690, '09009', 'ctz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (691, '09011', 'ctz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (692, '09011', 'ctz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (693, '09013', 'ctz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (694, '09015', 'ctz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (695, '10001', 'dez002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (696, '10003', 'dez001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (697, '10005', 'dez003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (698, '10005', 'dez004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (699, '11001', 'dcz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (700, '12001', 'flz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (701, '12003', 'flz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (702, '12005', 'flz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (703, '12007', 'flz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (704, '12009', 'flz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (705, '12009', 'flz147')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (706, '12011', 'flz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (707, '12011', 'flz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (708, '12013', 'flz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (709, '12015', 'flz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (710, '12017', 'flz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (711, '12019', 'flz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (712, '12021', 'flz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (713, '12021', 'flz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (714, '12023', 'flz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (715, '12027', 'flz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (716, '12029', 'flz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (717, '12031', 'flz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (718, '12033', 'flz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (719, '12033', 'flz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (720, '12035', 'flz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (721, '12037', 'flz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (722, '12039', 'flz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (723, '12041', 'flz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (724, '12043', 'flz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (725, '12045', 'flz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (726, '12047', 'flz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (727, '12049', 'flz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (728, '12051', 'flz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (729, '12053', 'flz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (730, '12055', 'flz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (731, '12057', 'flz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (732, '12059', 'flz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (733, '12061', 'flz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (734, '12063', 'flz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (735, '12065', 'flz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (736, '12067', 'flz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (737, '12069', 'flz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (738, '12069', 'flz144')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (739, '12071', 'flz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (740, '12073', 'flz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (741, '12075', 'flz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (742, '12077', 'flz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (743, '12079', 'flz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (744, '12081', 'flz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (745, '12083', 'flz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (746, '12085', 'flz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (747, '12086', 'flz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (748, '12086', 'flz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (749, '12087', 'flz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (750, '12087', 'flz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (751, '12087', 'flz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (752, '12087', 'flz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (753, '12089', 'flz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (754, '12091', 'flz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (755, '12091', 'flz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (756, '12093', 'flz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (757, '12095', 'flz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (758, '12097', 'flz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (759, '12099', 'flz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (760, '12099', 'flz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (761, '12101', 'flz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (762, '12103', 'flz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (763, '12105', 'flz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (764, '12107', 'flz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (765, '12109', 'flz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (766, '12111', 'flz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (767, '12113', 'flz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (768, '12113', 'flz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (769, '12115', 'flz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (770, '12117', 'flz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (771, '12119', 'flz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (772, '12121', 'flz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (773, '12123', 'flz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (774, '12125', 'flz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (775, '12127', 'flz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (776, '12127', 'flz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (777, '12129', 'flz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (778, '12131', 'flz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (779, '12131', 'flz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (780, '12133', 'flz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (781, '13001', 'gaz135')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (782, '13003', 'gaz149')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (783, '13005', 'gaz134')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (784, '13007', 'gaz144')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (785, '13009', 'gaz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (786, '13011', 'gaz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (787, '13013', 'gaz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (788, '13015', 'gaz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (789, '13017', 'gaz130')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (790, '13019', 'gaz148')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (791, '13021', 'gaz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (792, '13023', 'gaz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (793, '13025', 'gaz152')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (794, '13027', 'gaz159')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (795, '13029', 'gaz116')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (796, '13029', 'gaz117')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (797, '13031', 'gaz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (798, '13033', 'gaz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (799, '13035', 'gaz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (800, '13037', 'gaz123')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (801, '13039', 'gaz165')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (802, '13039', 'gaz166')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (803, '13043', 'gaz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (804, '13045', 'gaz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (805, '13047', 'gaz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (806, '13049', 'gaz164')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (807, '13051', 'gaz118')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (808, '13051', 'gaz119')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (809, '13053', 'gaz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (810, '13055', 'gaz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (811, '13057', 'gaz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (812, '13059', 'gaz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (813, '13061', 'gaz121')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (814, '13063', 'gaz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (815, '13065', 'gaz163')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (816, '13067', 'gaz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (817, '13069', 'gaz132')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (818, '13071', 'gaz146')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (819, '13073', 'gaz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (820, '13075', 'gaz147')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (821, '13077', 'gaz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (822, '13079', 'gaz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (823, '13081', 'gaz106')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (824, '13083', 'gaz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (825, '13085', 'gaz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (826, '13087', 'gaz156')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (827, '13089', 'gaz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (828, '13091', 'gaz109')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (829, '13093', 'gaz105')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (830, '13095', 'gaz125')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (831, '13097', 'gaz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (832, '13099', 'gaz142')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (833, '13101', 'gaz162')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (834, '13103', 'gaz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (835, '13105', 'gaz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (836, '13107', 'gaz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (837, '13109', 'gaz115')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (838, '13111', 'gaz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (839, '13113', 'gaz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (840, '13115', 'gaz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (841, '13117', 'gaz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (842, '13119', 'gaz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (843, '13121', 'gaz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (844, '13121', 'gaz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (845, '13123', 'gaz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (846, '13125', 'gaz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (847, '13127', 'gaz153')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (848, '13127', 'gaz154')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (849, '13129', 'gaz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (850, '13131', 'gaz157')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (851, '13133', 'gaz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (852, '13135', 'gaz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (853, '13137', 'gaz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (854, '13139', 'gaz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (855, '13141', 'gaz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (856, '13143', 'gaz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (857, '13145', 'gaz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (858, '13147', 'gaz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (859, '13149', 'gaz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (860, '13151', 'gaz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (861, '13153', 'gaz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (862, '13155', 'gaz131')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (863, '13157', 'gaz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (864, '13159', 'gaz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (865, '13161', 'gaz133')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (866, '13163', 'gaz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (867, '13165', 'gaz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (868, '13167', 'gaz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (869, '13169', 'gaz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (870, '13171', 'gaz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (871, '13173', 'gaz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (872, '13175', 'gaz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (873, '13177', 'gaz126')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (874, '13179', 'gaz138')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (875, '13179', 'gaz139')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (876, '13181', 'gaz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (877, '13183', 'gaz137')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (878, '13185', 'gaz160')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (879, '13187', 'gaz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (880, '13189', 'gaz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (881, '13191', 'gaz140')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (882, '13191', 'gaz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (883, '13193', 'gaz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (884, '13195', 'gaz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (885, '13197', 'gaz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (886, '13199', 'gaz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (887, '13201', 'gaz143')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (888, '13205', 'gaz145')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (889, '13207', 'gaz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (890, '13209', 'gaz112')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (891, '13211', 'gaz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (892, '13213', 'gaz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (893, '13215', 'gaz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (894, '13217', 'gaz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (895, '13219', 'gaz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (896, '13221', 'gaz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (897, '13223', 'gaz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (898, '13225', 'gaz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (899, '13227', 'gaz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (900, '13229', 'gaz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (901, '13231', 'gaz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (902, '13233', 'gaz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (903, '13235', 'gaz107')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (904, '13237', 'gaz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (905, '13239', 'gaz120')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (906, '13241', 'gaz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (907, '13243', 'gaz122')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (908, '13245', 'gaz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (909, '13247', 'gaz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (910, '13249', 'gaz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (911, '13251', 'gaz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (912, '13253', 'gaz155')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (913, '13255', 'gaz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (914, '13257', 'gaz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (915, '13259', 'gaz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (916, '13261', 'gaz104')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (917, '13263', 'gaz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (918, '13265', 'gaz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (919, '13267', 'gaz114')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (920, '13269', 'gaz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (921, '13271', 'gaz110')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (922, '13273', 'gaz124')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (923, '13275', 'gaz158')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (924, '13277', 'gaz129')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (925, '13279', 'gaz113')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (926, '13281', 'gaz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (927, '13283', 'gaz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (928, '13285', 'gaz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (929, '13287', 'gaz128')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (930, '13289', 'gaz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (931, '13291', 'gaz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (932, '13293', 'gaz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (933, '13295', 'gaz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (934, '13297', 'gaz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (935, '13299', 'gaz150')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (936, '13301', 'gaz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (937, '13303', 'gaz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (938, '13305', 'gaz136')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (939, '13307', 'gaz103')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (940, '13309', 'gaz111')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (941, '13311', 'gaz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (942, '13313', 'gaz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (943, '13315', 'gaz108')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (944, '13317', 'gaz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (945, '13319', 'gaz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (946, '13321', 'gaz127')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (947, '15001', 'hiz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (948, '15001', 'hiz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (949, '15001', 'hiz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (950, '15003', 'hiz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (951, '15007', 'hiz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (952, '15009', 'hiz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (953, '15009', 'hiz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (954, '15009', 'hiz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (955, '16001', 'idz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (956, '16003', 'idz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (957, '16005', 'idz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (958, '16005', 'idz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (959, '16007', 'idz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (960, '16009', 'idz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (961, '16009', 'idz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (962, '16011', 'idz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (963, '16011', 'idz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (964, '16011', 'idz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (965, '16013', 'idz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (966, '16013', 'idz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (967, '16015', 'idz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (968, '16017', 'idz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (969, '16019', 'idz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (970, '16019', 'idz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (971, '16021', 'idz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (972, '16023', 'idz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (973, '16023', 'idz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (974, '16025', 'idz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (975, '16025', 'idz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (976, '16027', 'idz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (977, '16029', 'idz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (978, '16031', 'idz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (979, '16031', 'idz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (980, '16033', 'idz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (981, '16035', 'idz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (982, '16035', 'idz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (983, '16037', 'idz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (984, '16037', 'idz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (985, '16039', 'idz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (986, '16039', 'idz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (987, '16039', 'idz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (988, '16041', 'idz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (989, '16041', 'idz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (990, '16043', 'idz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (991, '16043', 'idz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (992, '16045', 'idz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (993, '16045', 'idz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (994, '16047', 'idz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (995, '16049', 'idz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (996, '16049', 'idz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (997, '16049', 'idz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (998, '16051', 'idz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (999, '16053', 'idz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1000, '16055', 'idz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1001, '16055', 'idz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1002, '16055', 'idz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1003, '16057', 'idz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1004, '16057', 'idz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1005, '16059', 'idz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1006, '16059', 'idz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1007, '16061', 'idz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1008, '16063', 'idz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1009, '16065', 'idz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1010, '16065', 'idz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1011, '16067', 'idz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1012, '16069', 'idz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1013, '16069', 'idz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1014, '16071', 'idz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1015, '16073', 'idz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1016, '16073', 'idz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1017, '16073', 'idz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1018, '16073', 'idz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1019, '16075', 'idz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1020, '16077', 'idz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1021, '16077', 'idz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1022, '16079', 'idz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1023, '16081', 'idz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1024, '16083', 'idz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1025, '16083', 'idz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1026, '16085', 'idz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1027, '16087', 'idz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1028, '16087', 'idz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1029, '17001', 'ilz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1030, '17003', 'ilz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1031, '17005', 'ilz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1032, '17007', 'ilz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1033, '17009', 'ilz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1034, '17011', 'ilz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1035, '17013', 'ilz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1036, '17015', 'ilz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1037, '17017', 'ilz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1038, '17019', 'ilz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1039, '17021', 'ilz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1040, '17023', 'ilz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1041, '17025', 'ilz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1042, '17027', 'ilz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1043, '17029', 'ilz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1044, '17031', 'ilz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1045, '17033', 'ilz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1046, '17035', 'ilz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1047, '17037', 'ilz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1048, '17039', 'ilz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1049, '17041', 'ilz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1050, '17043', 'ilz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1051, '17045', 'ilz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1052, '17047', 'ilz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1053, '17049', 'ilz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1054, '17051', 'ilz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1055, '17053', 'ilz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1056, '17055', 'ilz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1057, '17057', 'ilz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1058, '17059', 'ilz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1059, '17061', 'ilz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1060, '17063', 'ilz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1061, '17065', 'ilz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1062, '17067', 'ilz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1063, '17069', 'ilz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1064, '17071', 'ilz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1065, '17073', 'ilz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1066, '17075', 'ilz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1067, '17077', 'ilz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1068, '17079', 'ilz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1069, '17081', 'ilz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1070, '17083', 'ilz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1071, '17085', 'ilz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1072, '17087', 'ilz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1073, '17089', 'ilz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1074, '17091', 'ilz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1075, '17093', 'ilz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1076, '17095', 'ilz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1077, '17097', 'ilz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1078, '17099', 'ilz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1079, '17101', 'ilz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1080, '17103', 'ilz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1081, '17105', 'ilz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1082, '17107', 'ilz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1083, '17109', 'ilz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1084, '17111', 'ilz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1085, '17113', 'ilz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1086, '17115', 'ilz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1087, '17117', 'ilz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1088, '17119', 'ilz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1089, '17121', 'ilz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1090, '17123', 'ilz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1091, '17125', 'ilz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1092, '17127', 'ilz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1093, '17129', 'ilz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1094, '17131', 'ilz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1095, '17133', 'ilz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1096, '17135', 'ilz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1097, '17137', 'ilz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1098, '17139', 'ilz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1099, '17141', 'ilz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1100, '17143', 'ilz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1101, '17145', 'ilz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1102, '17147', 'ilz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1103, '17149', 'ilz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1104, '17151', 'ilz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1105, '17153', 'ilz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1106, '17155', 'ilz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1107, '17157', 'ilz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1108, '17159', 'ilz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1109, '17161', 'ilz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1110, '17163', 'ilz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1111, '17165', 'ilz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1112, '17167', 'ilz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1113, '17169', 'ilz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1114, '17171', 'ilz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1115, '17173', 'ilz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1116, '17175', 'ilz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1117, '17177', 'ilz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1118, '17179', 'ilz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1119, '17181', 'ilz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1120, '17183', 'ilz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1121, '17185', 'ilz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1122, '17187', 'ilz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1123, '17189', 'ilz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1124, '17191', 'ilz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1125, '17193', 'ilz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1126, '17195', 'ilz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1127, '17197', 'ilz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1128, '17199', 'ilz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1129, '17201', 'ilz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1130, '17203', 'ilz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1131, '18001', 'inz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1132, '18003', 'inz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1133, '18005', 'inz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1134, '18007', 'inz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1135, '18009', 'inz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1136, '18011', 'inz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1137, '18013', 'inz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1138, '18015', 'inz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1139, '18017', 'inz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1140, '18019', 'inz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1141, '18021', 'inz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1142, '18023', 'inz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1143, '18025', 'inz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1144, '18027', 'inz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1145, '18029', 'inz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1146, '18031', 'inz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1147, '18033', 'inz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1148, '18035', 'inz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1149, '18037', 'inz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1150, '18039', 'inz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1151, '18041', 'inz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1152, '18043', 'inz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1153, '18045', 'inz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1154, '18047', 'inz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1155, '18049', 'inz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1156, '18051', 'inz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1157, '18053', 'inz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1158, '18055', 'inz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1159, '18057', 'inz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1160, '18059', 'inz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1161, '18061', 'inz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1162, '18063', 'inz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1163, '18065', 'inz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1164, '18067', 'inz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1165, '18069', 'inz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1166, '18071', 'inz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1167, '18073', 'inz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1168, '18075', 'inz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1169, '18077', 'inz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1170, '18079', 'inz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1171, '18081', 'inz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1172, '18083', 'inz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1173, '18085', 'inz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1174, '18087', 'inz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1175, '18089', 'inz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1176, '18091', 'inz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1177, '18093', 'inz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1178, '18095', 'inz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1179, '18097', 'inz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1180, '18099', 'inz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1181, '18101', 'inz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1182, '18103', 'inz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1183, '18105', 'inz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1184, '18107', 'inz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1185, '18109', 'inz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1186, '18111', 'inz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1187, '18113', 'inz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1188, '18115', 'inz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1189, '18117', 'inz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1190, '18119', 'inz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1191, '18121', 'inz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1192, '18123', 'inz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1193, '18125', 'inz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1194, '18127', 'inz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1195, '18129', 'inz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1196, '18131', 'inz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1197, '18133', 'inz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1198, '18135', 'inz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1199, '18137', 'inz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1200, '18139', 'inz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1201, '18141', 'inz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1202, '18143', 'inz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1203, '18145', 'inz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1204, '18147', 'inz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1205, '18149', 'inz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1206, '18151', 'inz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1207, '18153', 'inz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1208, '18155', 'inz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1209, '18157', 'inz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1210, '18159', 'inz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1211, '18161', 'inz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1212, '18163', 'inz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1213, '18165', 'inz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1214, '18167', 'inz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1215, '18169', 'inz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1216, '18171', 'inz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1217, '18173', 'inz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1218, '18175', 'inz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1219, '18177', 'inz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1220, '18179', 'inz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1221, '18181', 'inz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1222, '18183', 'inz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1223, '19001', 'iaz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1224, '19003', 'iaz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1225, '19005', 'iaz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1226, '19007', 'iaz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1227, '19009', 'iaz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1228, '19011', 'iaz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1229, '19013', 'iaz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1230, '19015', 'iaz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1231, '19017', 'iaz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1232, '19019', 'iaz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1233, '19021', 'iaz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1234, '19023', 'iaz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1235, '19025', 'iaz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1236, '19027', 'iaz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1237, '19029', 'iaz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1238, '19031', 'iaz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1239, '19033', 'iaz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1240, '19035', 'iaz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1241, '19037', 'iaz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1242, '19039', 'iaz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1243, '19041', 'iaz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1244, '19043', 'iaz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1245, '19045', 'iaz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1246, '19047', 'iaz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1247, '19049', 'iaz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1248, '19051', 'iaz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1249, '19053', 'iaz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1250, '19055', 'iaz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1251, '19057', 'iaz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1252, '19059', 'iaz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1253, '19061', 'iaz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1254, '19063', 'iaz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1255, '19065', 'iaz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1256, '19067', 'iaz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1257, '19069', 'iaz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1258, '19071', 'iaz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1259, '19073', 'iaz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1260, '19075', 'iaz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1261, '19077', 'iaz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1262, '19079', 'iaz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1263, '19081', 'iaz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1264, '19083', 'iaz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1265, '19085', 'iaz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1266, '19087', 'iaz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1267, '19089', 'iaz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1268, '19091', 'iaz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1269, '19093', 'iaz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1270, '19095', 'iaz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1271, '19097', 'iaz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1272, '19099', 'iaz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1273, '19101', 'iaz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1274, '19103', 'iaz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1275, '19105', 'iaz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1276, '19107', 'iaz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1277, '19109', 'iaz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1278, '19111', 'iaz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1279, '19113', 'iaz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1280, '19115', 'iaz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1281, '19117', 'iaz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1282, '19119', 'iaz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1283, '19121', 'iaz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1284, '19123', 'iaz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1285, '19125', 'iaz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1286, '19127', 'iaz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1287, '19129', 'iaz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1288, '19131', 'iaz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1289, '19133', 'iaz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1290, '19135', 'iaz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1291, '19137', 'iaz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1292, '19139', 'iaz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1293, '19141', 'iaz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1294, '19143', 'iaz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1295, '19145', 'iaz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1296, '19147', 'iaz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1297, '19149', 'iaz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1298, '19151', 'iaz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1299, '19153', 'iaz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1300, '19155', 'iaz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1301, '19157', 'iaz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1302, '19159', 'iaz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1303, '19161', 'iaz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1304, '19163', 'iaz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1305, '19165', 'iaz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1306, '19167', 'iaz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1307, '19169', 'iaz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1308, '19171', 'iaz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1309, '19173', 'iaz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1310, '19175', 'iaz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1311, '19177', 'iaz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1312, '19179', 'iaz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1313, '19181', 'iaz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1314, '19183', 'iaz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1315, '19185', 'iaz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1316, '19187', 'iaz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1317, '19189', 'iaz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1318, '19191', 'iaz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1319, '19193', 'iaz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1320, '19195', 'iaz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1321, '19197', 'iaz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1322, '20001', 'ksz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1323, '20003', 'ksz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1324, '20005', 'ksz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1325, '20007', 'ksz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1326, '20009', 'ksz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1327, '20011', 'ksz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1328, '20013', 'ksz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1329, '20015', 'ksz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1330, '20017', 'ksz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1331, '20019', 'ksz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1332, '20021', 'ksz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1333, '20023', 'ksz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1334, '20025', 'ksz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1335, '20027', 'ksz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1336, '20029', 'ksz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1337, '20031', 'ksz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1338, '20033', 'ksz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1339, '20035', 'ksz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1340, '20037', 'ksz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1341, '20039', 'ksz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1342, '20041', 'ksz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1343, '20043', 'ksz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1344, '20045', 'ksz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1345, '20047', 'ksz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1346, '20049', 'ksz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1347, '20051', 'ksz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1348, '20053', 'ksz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1349, '20055', 'ksz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1350, '20057', 'ksz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1351, '20059', 'ksz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1352, '20061', 'ksz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1353, '20063', 'ksz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1354, '20065', 'ksz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1355, '20067', 'ksz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1356, '20069', 'ksz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1357, '20071', 'ksz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1358, '20073', 'ksz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1359, '20075', 'ksz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1360, '20077', 'ksz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1361, '20079', 'ksz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1362, '20081', 'ksz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1363, '20083', 'ksz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1364, '20085', 'ksz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1365, '20087', 'ksz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1366, '20089', 'ksz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1367, '20091', 'ksz105')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1368, '20093', 'ksz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1369, '20095', 'ksz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1370, '20097', 'ksz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1371, '20099', 'ksz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1372, '20101', 'ksz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1373, '20103', 'ksz103')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1374, '20105', 'ksz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1375, '20107', 'ksz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1376, '20109', 'ksz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1377, '20111', 'ksz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1378, '20113', 'ksz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1379, '20115', 'ksz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1380, '20117', 'ksz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1381, '20119', 'ksz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1382, '20121', 'ksz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1383, '20123', 'ksz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1384, '20125', 'ksz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1385, '20127', 'ksz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1386, '20129', 'ksz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1387, '20131', 'ksz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1388, '20133', 'ksz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1389, '20135', 'ksz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1390, '20137', 'ksz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1391, '20139', 'ksz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1392, '20141', 'ksz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1393, '20143', 'ksz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1394, '20145', 'ksz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1395, '20147', 'ksz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1396, '20149', 'ksz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1397, '20151', 'ksz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1398, '20153', 'ksz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1399, '20155', 'ksz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1400, '20157', 'ksz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1401, '20159', 'ksz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1402, '20161', 'ksz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1403, '20163', 'ksz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1404, '20165', 'ksz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1405, '20167', 'ksz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1406, '20169', 'ksz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1407, '20171', 'ksz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1408, '20173', 'ksz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1409, '20175', 'ksz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1410, '20177', 'ksz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1411, '20179', 'ksz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1412, '20181', 'ksz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1413, '20183', 'ksz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1414, '20185', 'ksz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1415, '20187', 'ksz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1416, '20189', 'ksz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1417, '20191', 'ksz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1418, '20193', 'ksz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1419, '20195', 'ksz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1420, '20197', 'ksz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1421, '20199', 'ksz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1422, '20201', 'ksz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1423, '20203', 'ksz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1424, '20205', 'ksz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1425, '20207', 'ksz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1426, '20209', 'ksz104')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1427, '21001', 'kyz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1428, '21003', 'kyz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1429, '21005', 'kyz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1430, '21007', 'kyz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1431, '21009', 'kyz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1432, '21011', 'kyz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1433, '21013', 'kyz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1434, '21015', 'kyz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1435, '21017', 'kyz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1436, '21019', 'kyz103')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1437, '21021', 'kyz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1438, '21023', 'kyz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1439, '21025', 'kyz112')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1440, '21027', 'kyz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1441, '21029', 'kyz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1442, '21031', 'kyz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1443, '21033', 'kyz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1444, '21035', 'kyz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1445, '21037', 'kyz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1446, '21039', 'kyz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1447, '21041', 'kyz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1448, '21043', 'kyz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1449, '21045', 'kyz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1450, '21047', 'kyz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1451, '21049', 'kyz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1452, '21051', 'kyz116')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1453, '21053', 'kyz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1454, '21055', 'kyz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1455, '21057', 'kyz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1456, '21059', 'kyz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1457, '21061', 'kyz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1458, '21063', 'kyz104')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1459, '21065', 'kyz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1460, '21067', 'kyz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1461, '21069', 'kyz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1462, '21071', 'kyz110')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1463, '21073', 'kyz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1464, '21075', 'kyz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1465, '21077', 'kyz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1466, '21079', 'kyz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1467, '21081', 'kyz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1468, '21083', 'kyz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1469, '21085', 'kyz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1470, '21087', 'kyz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1471, '21089', 'kyz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1472, '21091', 'kyz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1473, '21093', 'kyz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1474, '21095', 'kyz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1475, '21097', 'kyz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1476, '21099', 'kyz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1477, '21101', 'kyz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1478, '21103', 'kyz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1479, '21105', 'kyz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1480, '21107', 'kyz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1481, '21109', 'kyz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1482, '21111', 'kyz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1483, '21113', 'kyz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1484, '21115', 'kyz107')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1485, '21117', 'kyz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1486, '21119', 'kyz113')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1487, '21121', 'kyz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1488, '21123', 'kyz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1489, '21125', 'kyz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1490, '21127', 'kyz105')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1491, '21129', 'kyz111')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1492, '21131', 'kyz117')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1493, '21133', 'kyz118')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1494, '21135', 'kyz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1495, '21137', 'kyz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1496, '21139', 'kyz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1497, '21141', 'kyz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1498, '21143', 'kyz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1499, '21145', 'kyz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1500, '21147', 'kyz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1501, '21149', 'kyz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1502, '21151', 'kyz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1503, '21153', 'kyz109')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1504, '21155', 'kyz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1505, '21157', 'kyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1506, '21159', 'kyz119')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1507, '21161', 'kyz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1508, '21163', 'kyz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1509, '21165', 'kyz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1510, '21167', 'kyz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1511, '21169', 'kyz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1512, '21171', 'kyz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1513, '21173', 'kyz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1514, '21175', 'kyz106')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1515, '21177', 'kyz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1516, '21179', 'kyz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1517, '21181', 'kyz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1518, '21183', 'kyz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1519, '21185', 'kyz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1520, '21187', 'kyz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1521, '21189', 'kyz114')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1522, '21191', 'kyz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1523, '21193', 'kyz115')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1524, '21195', 'kyz120')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1525, '21197', 'kyz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1526, '21199', 'kyz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1527, '21201', 'kyz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1528, '21203', 'kyz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1529, '21205', 'kyz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1530, '21207', 'kyz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1531, '21209', 'kyz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1532, '21211', 'kyz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1533, '21213', 'kyz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1534, '21215', 'kyz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1535, '21217', 'kyz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1536, '21219', 'kyz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1537, '21221', 'kyz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1538, '21223', 'kyz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1539, '21225', 'kyz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1540, '21227', 'kyz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1541, '21229', 'kyz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1542, '21231', 'kyz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1543, '21233', 'kyz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1544, '21235', 'kyz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1545, '21237', 'kyz108')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1546, '21239', 'kyz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1547, '22001', 'laz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1548, '22003', 'laz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1549, '22005', 'laz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1550, '22007', 'laz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1551, '22009', 'laz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1552, '22011', 'laz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1553, '22013', 'laz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1554, '22015', 'laz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1555, '22017', 'laz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1556, '22019', 'laz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1557, '22021', 'laz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1558, '22023', 'laz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1559, '22025', 'laz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1560, '22027', 'laz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1561, '22029', 'laz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1562, '22031', 'laz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1563, '22033', 'laz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1564, '22035', 'laz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1565, '22037', 'laz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1566, '22039', 'laz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1567, '22041', 'laz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1568, '22043', 'laz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1569, '22045', 'laz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1570, '22047', 'laz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1571, '22049', 'laz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1572, '22051', 'laz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1573, '22051', 'laz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1574, '22053', 'laz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1575, '22055', 'laz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1576, '22057', 'laz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1577, '22057', 'laz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1578, '22059', 'laz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1579, '22061', 'laz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1580, '22063', 'laz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1581, '22065', 'laz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1582, '22067', 'laz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1583, '22069', 'laz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1584, '22071', 'laz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1585, '22073', 'laz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1586, '22075', 'laz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1587, '22075', 'laz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1588, '22077', 'laz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1589, '22079', 'laz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1590, '22081', 'laz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1591, '22083', 'laz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1592, '22085', 'laz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1593, '22087', 'laz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1594, '22087', 'laz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1595, '22089', 'laz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1596, '22091', 'laz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1597, '22093', 'laz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1598, '22095', 'laz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1599, '22097', 'laz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1600, '22099', 'laz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1601, '22099', 'laz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1602, '22101', 'laz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1603, '22103', 'laz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1604, '22105', 'laz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1605, '22107', 'laz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1606, '22109', 'laz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1607, '22109', 'laz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1608, '22111', 'laz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1609, '22113', 'laz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1610, '22115', 'laz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1611, '22117', 'laz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1612, '22119', 'laz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1613, '22121', 'laz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1614, '22123', 'laz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1615, '22125', 'laz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1616, '22127', 'laz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1617, '23001', 'mez020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1618, '23003', 'mez001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1619, '23003', 'mez002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1620, '23003', 'mez006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1621, '23005', 'mez019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1622, '23005', 'mez024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1623, '23007', 'mez008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1624, '23007', 'mez013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1625, '23009', 'mez016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1626, '23009', 'mez029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1627, '23011', 'mez021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1628, '23013', 'mez027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1629, '23015', 'mez026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1630, '23017', 'mez007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1631, '23017', 'mez012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1632, '23019', 'mez005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1633, '23019', 'mez011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1634, '23019', 'mez015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1635, '23021', 'mez004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1636, '23021', 'mez010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1637, '23021', 'mez031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1638, '23023', 'mez025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1639, '23025', 'mez003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1640, '23025', 'mez009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1641, '23025', 'mez014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1642, '23027', 'mez022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1643, '23027', 'mez028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1644, '23029', 'mez017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1645, '23029', 'mez030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1646, '23029', 'mez032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1647, '23031', 'mez018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1648, '23031', 'mez023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1649, '24001', 'mdz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1650, '24003', 'mdz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1651, '24005', 'mdz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1652, '24005', 'mdz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1653, '24009', 'mdz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1654, '24011', 'mdz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1655, '24013', 'mdz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1656, '24015', 'mdz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1657, '24017', 'mdz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1658, '24019', 'mdz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1659, '24021', 'mdz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1660, '24023', 'mdz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1661, '24025', 'mdz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1662, '24027', 'mdz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1663, '24029', 'mdz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1664, '24031', 'mdz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1665, '24033', 'mdz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1666, '24035', 'mdz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1667, '24037', 'mdz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1668, '24039', 'mdz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1669, '24041', 'mdz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1670, '24043', 'mdz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1671, '24045', 'mdz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1672, '24047', 'mdz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1673, '24047', 'mdz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1674, '24510', 'mdz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1675, '25001', 'maz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1676, '25003', 'maz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1677, '25003', 'maz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1678, '25005', 'maz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1679, '25005', 'maz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1680, '25007', 'maz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1681, '25009', 'maz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1682, '25009', 'maz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1683, '25011', 'maz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1684, '25011', 'maz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1685, '25013', 'maz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1686, '25013', 'maz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1687, '25015', 'maz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1688, '25015', 'maz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1689, '25017', 'maz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1690, '25017', 'maz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1691, '25017', 'maz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1692, '25019', 'maz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1693, '25021', 'maz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1694, '25021', 'maz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1695, '25021', 'maz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1696, '25021', 'maz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1697, '25023', 'maz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1698, '25023', 'maz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1699, '25023', 'maz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1700, '25025', 'maz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1701, '25027', 'maz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1702, '25027', 'maz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1703, '26001', 'miz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1704, '26003', 'miz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1705, '26005', 'miz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1706, '26007', 'miz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1707, '26009', 'miz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1708, '26011', 'miz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1709, '26013', 'miz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1710, '26015', 'miz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1711, '26017', 'miz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1712, '26019', 'miz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1713, '26021', 'miz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1714, '26023', 'miz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1715, '26025', 'miz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1716, '26027', 'miz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1717, '26029', 'miz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1718, '26031', 'miz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1719, '26033', 'miz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1720, '26035', 'miz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1721, '26037', 'miz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1722, '26039', 'miz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1723, '26041', 'miz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1724, '26043', 'miz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1725, '26045', 'miz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1726, '26047', 'miz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1727, '26049', 'miz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1728, '26051', 'miz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1729, '26053', 'miz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1730, '26055', 'miz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1731, '26057', 'miz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1732, '26059', 'miz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1733, '26061', 'miz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1734, '26061', 'miz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1735, '26063', 'miz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1736, '26065', 'miz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1737, '26067', 'miz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1738, '26069', 'miz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1739, '26071', 'miz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1740, '26073', 'miz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1741, '26075', 'miz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1742, '26077', 'miz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1743, '26079', 'miz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1744, '26081', 'miz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1745, '26083', 'miz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1746, '26085', 'miz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1747, '26087', 'miz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1748, '26089', 'miz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1749, '26091', 'miz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1750, '26093', 'miz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1751, '26095', 'miz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1752, '26097', 'miz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1753, '26099', 'miz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1754, '26101', 'miz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1755, '26103', 'miz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1756, '26105', 'miz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1757, '26107', 'miz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1758, '26109', 'miz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1759, '26111', 'miz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1760, '26113', 'miz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1761, '26115', 'miz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1762, '26117', 'miz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1763, '26119', 'miz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1764, '26121', 'miz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1765, '26123', 'miz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1766, '26125', 'miz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1767, '26127', 'miz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1768, '26129', 'miz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1769, '26131', 'miz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1770, '26133', 'miz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1771, '26135', 'miz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1772, '26137', 'miz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1773, '26139', 'miz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1774, '26141', 'miz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1775, '26143', 'miz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1776, '26145', 'miz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1777, '26147', 'miz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1778, '26149', 'miz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1779, '26151', 'miz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1780, '26153', 'miz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1781, '26153', 'miz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1782, '26155', 'miz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1783, '26157', 'miz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1784, '26159', 'miz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1785, '26161', 'miz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1786, '26163', 'miz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1787, '26165', 'miz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1788, '27001', 'mnz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1789, '27001', 'mnz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1790, '27003', 'mnz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1791, '27005', 'mnz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1792, '27005', 'mnz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1793, '27007', 'mnz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1794, '27007', 'mnz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1795, '27009', 'mnz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1796, '27011', 'mnz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1797, '27013', 'mnz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1798, '27015', 'mnz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1799, '27017', 'mnz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1800, '27019', 'mnz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1801, '27021', 'mnz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1802, '27021', 'mnz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1803, '27023', 'mnz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1804, '27025', 'mnz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1805, '27027', 'mnz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1806, '27029', 'mnz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1807, '27029', 'mnz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1808, '27031', 'mnz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1809, '27031', 'mnz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1810, '27033', 'mnz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1811, '27035', 'mnz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1812, '27037', 'mnz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1813, '27039', 'mnz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1814, '27041', 'mnz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1815, '27043', 'mnz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1816, '27045', 'mnz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1817, '27047', 'mnz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1818, '27049', 'mnz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1819, '27051', 'mnz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1820, '27053', 'mnz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1821, '27055', 'mnz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1822, '27057', 'mnz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1823, '27059', 'mnz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1824, '27061', 'mnz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1825, '27061', 'mnz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1826, '27063', 'mnz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1827, '27065', 'mnz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1828, '27067', 'mnz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1829, '27069', 'mnz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1830, '27071', 'mnz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1831, '27073', 'mnz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1832, '27075', 'mnz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1833, '27075', 'mnz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1834, '27077', 'mnz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1835, '27079', 'mnz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1836, '27081', 'mnz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1837, '27083', 'mnz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1838, '27085', 'mnz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1839, '27087', 'mnz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1840, '27089', 'mnz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1841, '27089', 'mnz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1842, '27091', 'mnz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1843, '27093', 'mnz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1844, '27095', 'mnz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1845, '27097', 'mnz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1846, '27099', 'mnz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1847, '27101', 'mnz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1848, '27103', 'mnz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1849, '27105', 'mnz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1850, '27107', 'mnz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1851, '27109', 'mnz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1852, '27111', 'mnz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1853, '27111', 'mnz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1854, '27113', 'mnz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1855, '27115', 'mnz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1856, '27117', 'mnz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1857, '27119', 'mnz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1858, '27119', 'mnz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1859, '27121', 'mnz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1860, '27123', 'mnz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1861, '27125', 'mnz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1862, '27127', 'mnz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1863, '27129', 'mnz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1864, '27131', 'mnz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1865, '27133', 'mnz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1866, '27135', 'mnz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1867, '27137', 'mnz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1868, '27137', 'mnz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1869, '27137', 'mnz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1870, '27137', 'mnz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1871, '27139', 'mnz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1872, '27141', 'mnz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1873, '27143', 'mnz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1874, '27145', 'mnz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1875, '27147', 'mnz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1876, '27149', 'mnz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1877, '27151', 'mnz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1878, '27153', 'mnz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1879, '27155', 'mnz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1880, '27157', 'mnz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1881, '27159', 'mnz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1882, '27161', 'mnz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1883, '27163', 'mnz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1884, '27165', 'mnz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1885, '27167', 'mnz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1886, '27169', 'mnz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1887, '27171', 'mnz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1888, '27173', 'mnz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1889, '28001', 'msz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1890, '28003', 'msz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1891, '28005', 'msz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1892, '28007', 'msz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1893, '28009', 'msz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1894, '28011', 'msz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1895, '28013', 'msz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1896, '28015', 'msz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1897, '28017', 'msz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1898, '28019', 'msz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1899, '28021', 'msz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1900, '28023', 'msz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1901, '28025', 'msz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1902, '28027', 'msz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1903, '28029', 'msz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1904, '28031', 'msz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1905, '28033', 'msz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1906, '28035', 'msz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1907, '28037', 'msz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1908, '28039', 'msz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1909, '28041', 'msz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1910, '28043', 'msz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1911, '28045', 'msz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1912, '28047', 'msz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1913, '28049', 'msz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1914, '28051', 'msz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1915, '28053', 'msz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1916, '28055', 'msz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1917, '28057', 'msz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1918, '28059', 'msz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1919, '28061', 'msz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1920, '28063', 'msz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1921, '28065', 'msz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1922, '28067', 'msz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1923, '28069', 'msz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1924, '28071', 'msz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1925, '28073', 'msz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1926, '28075', 'msz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1927, '28077', 'msz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1928, '28079', 'msz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1929, '28081', 'msz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1930, '28083', 'msz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1931, '28085', 'msz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1932, '28087', 'msz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1933, '28089', 'msz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1934, '28091', 'msz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1935, '28093', 'msz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1936, '28095', 'msz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1937, '28097', 'msz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1938, '28099', 'msz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1939, '28101', 'msz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1940, '28103', 'msz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1941, '28105', 'msz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1942, '28107', 'msz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1943, '28109', 'msz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1944, '28111', 'msz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1945, '28113', 'msz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1946, '28115', 'msz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1947, '28117', 'msz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1948, '28119', 'msz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1949, '28121', 'msz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1950, '28123', 'msz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1951, '28125', 'msz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1952, '28127', 'msz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1953, '28129', 'msz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1954, '28131', 'msz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1955, '28133', 'msz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1956, '28135', 'msz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1957, '28137', 'msz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1958, '28139', 'msz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1959, '28141', 'msz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1960, '28143', 'msz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1961, '28145', 'msz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1962, '28147', 'msz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1963, '28149', 'msz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1964, '28151', 'msz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1965, '28153', 'msz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1966, '28155', 'msz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1967, '28157', 'msz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1968, '28159', 'msz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1969, '28161', 'msz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1970, '28163', 'msz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1971, '29001', 'moz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1972, '29003', 'moz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1973, '29005', 'moz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1974, '29007', 'moz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1975, '29009', 'moz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1976, '29011', 'moz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1977, '29013', 'moz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1978, '29015', 'moz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1979, '29017', 'moz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1980, '29019', 'moz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1981, '29021', 'moz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1982, '29023', 'moz109')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1983, '29025', 'moz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1984, '29027', 'moz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1985, '29029', 'moz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1986, '29031', 'moz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1987, '29033', 'moz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1988, '29035', 'moz107')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1989, '29037', 'moz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1990, '29039', 'moz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1991, '29041', 'moz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1992, '29043', 'moz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1993, '29045', 'moz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1994, '29047', 'moz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1995, '29049', 'moz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1996, '29051', 'moz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1997, '29053', 'moz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1998, '29055', 'moz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (1999, '29057', 'moz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2000, '29059', 'moz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2001, '29061', 'moz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2002, '29063', 'moz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2003, '29065', 'moz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2004, '29067', 'moz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2005, '29069', 'moz113')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2006, '29071', 'moz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2007, '29073', 'moz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2008, '29075', 'moz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2009, '29077', 'moz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2010, '29079', 'moz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2011, '29081', 'moz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2012, '29083', 'moz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2013, '29085', 'moz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2014, '29087', 'moz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2015, '29089', 'moz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2016, '29091', 'moz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2017, '29093', 'moz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2018, '29095', 'moz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2019, '29097', 'moz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2020, '29099', 'moz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2021, '29101', 'moz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2022, '29103', 'moz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2023, '29105', 'moz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2024, '29107', 'moz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2025, '29109', 'moz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2026, '29111', 'moz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2027, '29113', 'moz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2028, '29115', 'moz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2029, '29117', 'moz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2030, '29119', 'moz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2031, '29121', 'moz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2032, '29123', 'moz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2033, '29125', 'moz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2034, '29127', 'moz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2035, '29129', 'moz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2036, '29131', 'moz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2037, '29133', 'moz112')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2038, '29135', 'moz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2039, '29137', 'moz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2040, '29139', 'moz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2041, '29141', 'moz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2042, '29143', 'moz114')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2043, '29145', 'moz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2044, '29147', 'moz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2045, '29149', 'moz106')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2046, '29151', 'moz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2047, '29153', 'moz105')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2048, '29155', 'moz115')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2049, '29157', 'moz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2050, '29159', 'moz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2051, '29161', 'moz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2052, '29163', 'moz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2053, '29165', 'moz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2054, '29167', 'moz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2055, '29169', 'moz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2056, '29171', 'moz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2057, '29173', 'moz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2058, '29175', 'moz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2059, '29177', 'moz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2060, '29179', 'moz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2061, '29181', 'moz108')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2062, '29183', 'moz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2063, '29185', 'moz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2064, '29186', 'moz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2065, '29187', 'moz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2066, '29189', 'moz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2067, '29195', 'moz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2068, '29197', 'moz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2069, '29199', 'moz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2070, '29201', 'moz111')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2071, '29203', 'moz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2072, '29205', 'moz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2073, '29207', 'moz110')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2074, '29209', 'moz103')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2075, '29211', 'moz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2076, '29213', 'moz104')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2077, '29215', 'moz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2078, '29217', 'moz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2079, '29219', 'moz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2080, '29221', 'moz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2081, '29223', 'moz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2082, '29225', 'moz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2083, '29227', 'moz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2084, '29229', 'moz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2085, '29510', 'moz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2086, '30001', 'mtz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2087, '30003', 'mtz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2088, '30003', 'mtz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2089, '30005', 'mtz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2090, '30007', 'mtz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2091, '30009', 'mtz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2092, '30009', 'mtz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2093, '30011', 'mtz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2094, '30013', 'mtz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2095, '30015', 'mtz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2096, '30017', 'mtz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2097, '30019', 'mtz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2098, '30021', 'mtz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2099, '30023', 'mtz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2100, '30025', 'mtz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2101, '30027', 'mtz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2102, '30029', 'mtz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2103, '30029', 'mtz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2104, '30029', 'mtz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2105, '30031', 'mtz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2106, '30033', 'mtz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2107, '30035', 'mtz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2108, '30035', 'mtz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2109, '30037', 'mtz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2110, '30039', 'mtz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2111, '30039', 'mtz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2112, '30039', 'mtz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2113, '30041', 'mtz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2114, '30043', 'mtz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2115, '30045', 'mtz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2116, '30047', 'mtz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2117, '30047', 'mtz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2118, '30047', 'mtz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2119, '30049', 'mtz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2120, '30049', 'mtz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2121, '30051', 'mtz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2122, '30053', 'mtz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2123, '30053', 'mtz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2124, '30055', 'mtz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2125, '30057', 'mtz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2126, '30059', 'mtz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2127, '30061', 'mtz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2128, '30063', 'mtz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2129, '30063', 'mtz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2130, '30063', 'mtz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2131, '30063', 'mtz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2132, '30065', 'mtz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2133, '30067', 'mtz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2134, '30069', 'mtz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2135, '30071', 'mtz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2136, '30071', 'mtz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2137, '30071', 'mtz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2138, '30073', 'mtz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2139, '30073', 'mtz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2140, '30075', 'mtz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2141, '30077', 'mtz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2142, '30077', 'mtz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2143, '30079', 'mtz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2144, '30081', 'mtz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2145, '30081', 'mtz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2146, '30083', 'mtz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2147, '30085', 'mtz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2148, '30085', 'mtz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2149, '30087', 'mtz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2150, '30087', 'mtz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2151, '30089', 'mtz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2152, '30089', 'mtz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2153, '30089', 'mtz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2154, '30091', 'mtz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2155, '30093', 'mtz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2156, '30095', 'mtz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2157, '30097', 'mtz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2158, '30099', 'mtz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2159, '30099', 'mtz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2160, '30101', 'mtz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2161, '30103', 'mtz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2162, '30105', 'mtz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2163, '30105', 'mtz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2164, '30107', 'mtz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2165, '30109', 'mtz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2166, '30111', 'mtz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2167, '30113', 'mtz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2168, '31001', 'nez075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2169, '31003', 'nez016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2170, '31005', 'nez035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2171, '31007', 'nez020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2172, '31009', 'nez026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2173, '31011', 'nez030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2174, '31013', 'nez003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2175, '31015', 'nez007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2176, '31017', 'nez008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2177, '31019', 'nez061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2178, '31021', 'nez034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2179, '31023', 'nez050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2180, '31025', 'nez067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2181, '31027', 'nez012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2182, '31029', 'nez069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2183, '31031', 'nez005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2184, '31031', 'nez094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2185, '31033', 'nez055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2186, '31035', 'nez076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2187, '31037', 'nez043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2188, '31039', 'nez033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2189, '31041', 'nez038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2190, '31043', 'nez014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2191, '31045', 'nez002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2192, '31047', 'nez060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2193, '31049', 'nez056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2194, '31051', 'nez013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2195, '31053', 'nez044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2196, '31055', 'nez052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2197, '31057', 'nez079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2198, '31059', 'nez077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2199, '31061', 'nez084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2200, '31063', 'nez071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2201, '31065', 'nez082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2202, '31067', 'nez089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2203, '31069', 'nez022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2204, '31071', 'nez028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2205, '31073', 'nez072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2206, '31075', 'nez023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2207, '31077', 'nez040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2208, '31079', 'nez062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2209, '31081', 'nez063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2210, '31083', 'nez083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2211, '31085', 'nez070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2212, '31087', 'nez080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2213, '31089', 'nez010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2214, '31091', 'nez024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2215, '31093', 'nez047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2216, '31095', 'nez088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2217, '31097', 'nez090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2218, '31099', 'nez074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2219, '31101', 'nez057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2220, '31103', 'nez006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2221, '31105', 'nez054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2222, '31107', 'nez011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2223, '31109', 'nez066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2224, '31111', 'nez059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2225, '31113', 'nez037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2226, '31115', 'nez027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2227, '31117', 'nez036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2228, '31119', 'nez031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2229, '31121', 'nez048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2230, '31123', 'nez021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2231, '31125', 'nez041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2232, '31127', 'nez091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2233, '31129', 'nez086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2234, '31131', 'nez068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2235, '31133', 'nez092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2236, '31135', 'nez058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2237, '31137', 'nez073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2238, '31139', 'nez017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2239, '31141', 'nez042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2240, '31143', 'nez049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2241, '31145', 'nez081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2242, '31147', 'nez093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2243, '31149', 'nez009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2244, '31151', 'nez078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2245, '31153', 'nez053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2246, '31155', 'nez051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2247, '31157', 'nez019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2248, '31159', 'nez065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2249, '31161', 'nez004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2250, '31163', 'nez046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2251, '31165', 'nez001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2252, '31167', 'nez032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2253, '31169', 'nez087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2254, '31171', 'nez025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2255, '31173', 'nez015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2256, '31175', 'nez039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2257, '31177', 'nez045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2258, '31179', 'nez018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2259, '31181', 'nez085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2260, '31183', 'nez029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2261, '31185', 'nez064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2262, '32001', 'nvz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2263, '32003', 'nvz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2264, '32003', 'nvz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2265, '32003', 'nvz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2266, '32003', 'nvz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2267, '32003', 'nvz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2268, '32003', 'nvz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2269, '32003', 'nvz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2270, '32005', 'nvz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2271, '32005', 'nvz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2272, '32007', 'nvz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2273, '32007', 'nvz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2274, '32007', 'nvz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2275, '32007', 'nvz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2276, '32009', 'nvz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2277, '32011', 'nvz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2278, '32011', 'nvz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2279, '32013', 'nvz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2280, '32015', 'nvz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2281, '32015', 'nvz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2282, '32017', 'nvz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2283, '32017', 'nvz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2284, '32019', 'nvz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2285, '32019', 'nvz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2286, '32019', 'nvz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2287, '32021', 'nvz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2288, '32023', 'nvz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2289, '32023', 'nvz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2290, '32023', 'nvz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2291, '32023', 'nvz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2292, '32027', 'nvz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2293, '32029', 'nvz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2294, '32031', 'nvz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2295, '32031', 'nvz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2296, '32031', 'nvz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2297, '32031', 'nvz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2298, '32033', 'nvz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2299, '32033', 'nvz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2300, '32510', 'nvz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2301, '32510', 'nvz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2302, '33001', 'nhz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2303, '33003', 'nhz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2304, '33003', 'nhz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2305, '33005', 'nhz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2306, '33007', 'nhz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2307, '33007', 'nhz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2308, '33009', 'nhz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2309, '33009', 'nhz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2310, '33011', 'nhz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2311, '33011', 'nhz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2312, '33013', 'nhz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2313, '33015', 'nhz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2314, '33015', 'nhz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2315, '33017', 'nhz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2316, '33019', 'nhz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2317, '34001', 'njz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2318, '34001', 'njz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2319, '34003', 'njz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2320, '34005', 'njz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2321, '34005', 'njz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2322, '34007', 'njz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2323, '34009', 'njz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2324, '34009', 'njz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2325, '34011', 'njz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2326, '34013', 'njz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2327, '34015', 'njz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2328, '34017', 'njz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2329, '34019', 'njz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2330, '34021', 'njz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2331, '34023', 'njz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2332, '34025', 'njz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2333, '34025', 'njz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2334, '34027', 'njz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2335, '34029', 'njz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2336, '34029', 'njz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2337, '34031', 'njz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2338, '34031', 'njz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2339, '34033', 'njz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2340, '34035', 'njz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2341, '34037', 'njz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2342, '34039', 'njz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2343, '34041', 'njz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2344, '35001', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2345, '35001', 'nmz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2346, '35001', 'nmz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2347, '35003', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2348, '35003', 'nmz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2349, '35005', 'nmz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2350, '35005', 'nmz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2351, '35006', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2352, '35006', 'nmz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2353, '35007', 'nmz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2354, '35007', 'nmz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2355, '35007', 'nmz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2356, '35009', 'nmz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2357, '35011', 'nmz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2358, '35013', 'nmz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2359, '35013', 'nmz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2360, '35015', 'nmz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2361, '35015', 'nmz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2362, '35017', 'nmz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2363, '35017', 'nmz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2364, '35019', 'nmz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2365, '35021', 'nmz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2366, '35023', 'nmz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2367, '35023', 'nmz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2368, '35025', 'nmz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2369, '35025', 'nmz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2370, '35025', 'nmz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2371, '35027', 'nmz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2372, '35027', 'nmz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2373, '35028', 'nmz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2374, '35028', 'nmz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2375, '35029', 'nmz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2376, '35031', 'nmz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2377, '35031', 'nmz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2378, '35031', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2379, '35033', 'nmz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2380, '35033', 'nmz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2381, '35035', 'nmz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2382, '35035', 'nmz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2383, '35037', 'nmz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2384, '35039', 'nmz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2385, '35039', 'nmz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2386, '35039', 'nmz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2387, '35041', 'nmz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2388, '35043', 'nmz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2389, '35043', 'nmz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2390, '35043', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2391, '35043', 'nmz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2392, '35045', 'nmz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2393, '35045', 'nmz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2394, '35045', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2395, '35047', 'nmz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2396, '35047', 'nmz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2397, '35047', 'nmz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2398, '35047', 'nmz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2399, '35049', 'nmz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2400, '35049', 'nmz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2401, '35049', 'nmz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2402, '35049', 'nmz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2403, '35049', 'nmz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2404, '35051', 'nmz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2405, '35051', 'nmz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2406, '35053', 'nmz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2407, '35053', 'nmz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2408, '35053', 'nmz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2409, '35053', 'nmz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2410, '35053', 'nmz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2411, '35055', 'nmz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2412, '35057', 'nmz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2413, '35057', 'nmz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2414, '35059', 'nmz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2415, '35059', 'nmz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2416, '35061', 'nmz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2417, '35061', 'nmz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2418, '36001', 'nyz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2419, '36001', 'nyz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2420, '36003', 'nyz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2421, '36005', 'nyz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2422, '36007', 'nyz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2423, '36009', 'nyz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2424, '36011', 'nyz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2425, '36011', 'nyz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2426, '36013', 'nyz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2427, '36015', 'nyz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2428, '36017', 'nyz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2429, '36019', 'nyz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2430, '36019', 'nyz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2431, '36021', 'nyz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2432, '36021', 'nyz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2433, '36023', 'nyz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2434, '36025', 'nyz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2435, '36027', 'nyz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2436, '36027', 'nyz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2437, '36029', 'nyz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2438, '36029', 'nyz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2439, '36031', 'nyz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2440, '36031', 'nyz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2441, '36033', 'nyz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2442, '36033', 'nyz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2443, '36035', 'nyz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2444, '36035', 'nyz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2445, '36037', 'nyz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2446, '36039', 'nyz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2447, '36039', 'nyz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2448, '36041', 'nyz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2449, '36043', 'nyz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2450, '36043', 'nyz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2451, '36045', 'nyz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2452, '36047', 'nyz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2453, '36049', 'nyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2454, '36051', 'nyz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2455, '36053', 'nyz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2456, '36055', 'nyz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2457, '36057', 'nyz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2458, '36059', 'nyz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2459, '36061', 'nyz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2460, '36063', 'nyz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2461, '36065', 'nyz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2462, '36065', 'nyz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2463, '36067', 'nyz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2464, '36069', 'nyz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2465, '36071', 'nyz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2466, '36073', 'nyz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2467, '36075', 'nyz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2468, '36077', 'nyz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2469, '36079', 'nyz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2470, '36081', 'nyz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2471, '36083', 'nyz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2472, '36083', 'nyz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2473, '36085', 'nyz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2474, '36087', 'nyz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2475, '36089', 'nyz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2476, '36089', 'nyz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2477, '36089', 'nyz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2478, '36091', 'nyz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2479, '36091', 'nyz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2480, '36093', 'nyz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2481, '36093', 'nyz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2482, '36095', 'nyz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2483, '36097', 'nyz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2484, '36099', 'nyz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2485, '36101', 'nyz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2486, '36103', 'nyz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2487, '36103', 'nyz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2488, '36103', 'nyz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2489, '36103', 'nyz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2490, '36105', 'nyz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2491, '36107', 'nyz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2492, '36109', 'nyz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2493, '36111', 'nyz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2494, '36111', 'nyz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2495, '36113', 'nyz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2496, '36113', 'nyz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2497, '36115', 'nyz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2498, '36115', 'nyz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2499, '36117', 'nyz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2500, '36119', 'nyz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2501, '36119', 'nyz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2502, '36121', 'nyz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2503, '36123', 'nyz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2504, '37001', 'ncz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2505, '37003', 'ncz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2506, '37005', 'ncz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2507, '37007', 'ncz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2508, '37009', 'ncz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2509, '37011', 'ncz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2510, '37013', 'ncz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2511, '37015', 'ncz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2512, '37017', 'ncz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2513, '37019', 'ncz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2514, '37021', 'ncz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2515, '37023', 'ncz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2516, '37025', 'ncz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2517, '37027', 'ncz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2518, '37029', 'ncz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2519, '37031', 'ncz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2520, '37033', 'ncz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2521, '37035', 'ncz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2522, '37037', 'ncz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2523, '37039', 'ncz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2524, '37041', 'ncz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2525, '37043', 'ncz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2526, '37045', 'ncz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2527, '37047', 'ncz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2528, '37049', 'ncz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2529, '37051', 'ncz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2530, '37053', 'ncz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2531, '37053', 'ncz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2532, '37055', 'ncz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2533, '37055', 'ncz103')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2534, '37057', 'ncz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2535, '37059', 'ncz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2536, '37061', 'ncz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2537, '37063', 'ncz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2538, '37065', 'ncz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2539, '37067', 'ncz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2540, '37069', 'ncz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2541, '37071', 'ncz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2542, '37073', 'ncz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2543, '37075', 'ncz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2544, '37077', 'ncz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2545, '37079', 'ncz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2546, '37081', 'ncz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2547, '37083', 'ncz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2548, '37085', 'ncz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2549, '37087', 'ncz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2550, '37089', 'ncz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2551, '37091', 'ncz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2552, '37093', 'ncz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2553, '37095', 'ncz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2554, '37095', 'ncz104')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2555, '37097', 'ncz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2556, '37099', 'ncz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2557, '37099', 'ncz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2558, '37101', 'ncz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2559, '37103', 'ncz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2560, '37105', 'ncz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2561, '37107', 'ncz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2562, '37109', 'ncz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2563, '37111', 'ncz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2564, '37113', 'ncz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2565, '37115', 'ncz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2566, '37117', 'ncz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2567, '37119', 'ncz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2568, '37121', 'ncz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2569, '37123', 'ncz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2570, '37125', 'ncz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2571, '37127', 'ncz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2572, '37129', 'ncz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2573, '37131', 'ncz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2574, '37133', 'ncz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2575, '37135', 'ncz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2576, '37137', 'ncz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2577, '37139', 'ncz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2578, '37141', 'ncz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2579, '37143', 'ncz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2580, '37145', 'ncz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2581, '37147', 'ncz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2582, '37149', 'ncz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2583, '37151', 'ncz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2584, '37153', 'ncz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2585, '37155', 'ncz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2586, '37157', 'ncz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2587, '37159', 'ncz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2588, '37161', 'ncz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2589, '37163', 'ncz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2590, '37165', 'ncz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2591, '37167', 'ncz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2592, '37169', 'ncz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2593, '37171', 'ncz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2594, '37173', 'ncz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2595, '37175', 'ncz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2596, '37177', 'ncz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2597, '37179', 'ncz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2598, '37181', 'ncz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2599, '37183', 'ncz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2600, '37185', 'ncz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2601, '37187', 'ncz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2602, '37189', 'ncz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2603, '37191', 'ncz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2604, '37193', 'ncz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2605, '37195', 'ncz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2606, '37197', 'ncz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2607, '37199', 'ncz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2608, '38001', 'ndz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2609, '38003', 'ndz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2610, '38005', 'ndz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2611, '38007', 'ndz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2612, '38009', 'ndz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2613, '38011', 'ndz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2614, '38013', 'ndz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2615, '38015', 'ndz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2616, '38017', 'ndz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2617, '38019', 'ndz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2618, '38021', 'ndz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2619, '38023', 'ndz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2620, '38025', 'ndz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2621, '38027', 'ndz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2622, '38029', 'ndz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2623, '38031', 'ndz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2624, '38033', 'ndz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2625, '38035', 'ndz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2626, '38037', 'ndz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2627, '38039', 'ndz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2628, '38041', 'ndz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2629, '38043', 'ndz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2630, '38045', 'ndz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2631, '38047', 'ndz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2632, '38049', 'ndz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2633, '38051', 'ndz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2634, '38053', 'ndz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2635, '38055', 'ndz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2636, '38057', 'ndz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2637, '38059', 'ndz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2638, '38061', 'ndz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2639, '38063', 'ndz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2640, '38065', 'ndz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2641, '38067', 'ndz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2642, '38069', 'ndz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2643, '38071', 'ndz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2644, '38073', 'ndz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2645, '38075', 'ndz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2646, '38077', 'ndz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2647, '38079', 'ndz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2648, '38081', 'ndz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2649, '38083', 'ndz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2650, '38085', 'ndz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2651, '38087', 'ndz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2652, '38089', 'ndz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2653, '38091', 'ndz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2654, '38093', 'ndz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2655, '38095', 'ndz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2656, '38097', 'ndz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2657, '38099', 'ndz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2658, '38099', 'ndz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2659, '38101', 'ndz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2660, '38103', 'ndz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2661, '38105', 'ndz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2662, '39001', 'ohz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2663, '39003', 'ohz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2664, '39005', 'ohz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2665, '39007', 'ohz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2666, '39007', 'ohz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2667, '39009', 'ohz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2668, '39011', 'ohz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2669, '39013', 'ohz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2670, '39015', 'ohz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2671, '39017', 'ohz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2672, '39019', 'ohz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2673, '39021', 'ohz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2674, '39023', 'ohz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2675, '39025', 'ohz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2676, '39027', 'ohz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2677, '39029', 'ohz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2678, '39031', 'ohz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2679, '39033', 'ohz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2680, '39035', 'ohz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2681, '39037', 'ohz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2682, '39039', 'ohz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2683, '39041', 'ohz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2684, '39043', 'ohz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2685, '39045', 'ohz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2686, '39047', 'ohz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2687, '39049', 'ohz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2688, '39051', 'ohz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2689, '39053', 'ohz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2690, '39055', 'ohz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2691, '39057', 'ohz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2692, '39059', 'ohz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2693, '39061', 'ohz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2694, '39063', 'ohz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2695, '39065', 'ohz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2696, '39067', 'ohz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2697, '39069', 'ohz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2698, '39071', 'ohz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2699, '39073', 'ohz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2700, '39075', 'ohz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2701, '39077', 'ohz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2702, '39079', 'ohz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2703, '39081', 'ohz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2704, '39083', 'ohz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2705, '39085', 'ohz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2706, '39087', 'ohz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2707, '39089', 'ohz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2708, '39091', 'ohz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2709, '39093', 'ohz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2710, '39095', 'ohz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2711, '39097', 'ohz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2712, '39099', 'ohz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2713, '39101', 'ohz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2714, '39103', 'ohz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2715, '39105', 'ohz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2716, '39107', 'ohz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2717, '39109', 'ohz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2718, '39111', 'ohz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2719, '39113', 'ohz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2720, '39115', 'ohz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2721, '39117', 'ohz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2722, '39119', 'ohz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2723, '39121', 'ohz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2724, '39123', 'ohz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2725, '39125', 'ohz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2726, '39127', 'ohz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2727, '39129', 'ohz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2728, '39131', 'ohz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2729, '39133', 'ohz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2730, '39135', 'ohz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2731, '39137', 'ohz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2732, '39139', 'ohz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2733, '39141', 'ohz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2734, '39143', 'ohz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2735, '39145', 'ohz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2736, '39147', 'ohz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2737, '39149', 'ohz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2738, '39151', 'ohz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2739, '39153', 'ohz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2740, '39155', 'ohz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2741, '39157', 'ohz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2742, '39159', 'ohz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2743, '39161', 'ohz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2744, '39163', 'ohz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2745, '39165', 'ohz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2746, '39167', 'ohz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2747, '39169', 'ohz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2748, '39171', 'ohz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2749, '39173', 'ohz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2750, '39175', 'ohz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2751, '40001', 'okz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2752, '40003', 'okz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2753, '40005', 'okz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2754, '40007', 'okz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2755, '40009', 'okz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2756, '40011', 'okz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2757, '40013', 'okz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2758, '40015', 'okz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2759, '40017', 'okz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2760, '40019', 'okz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2761, '40021', 'okz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2762, '40023', 'okz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2763, '40025', 'okz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2764, '40027', 'okz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2765, '40029', 'okz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2766, '40031', 'okz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2767, '40033', 'okz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2768, '40035', 'okz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2769, '40037', 'okz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2770, '40039', 'okz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2771, '40041', 'okz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2772, '40043', 'okz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2773, '40045', 'okz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2774, '40047', 'okz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2775, '40049', 'okz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2776, '40051', 'okz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2777, '40053', 'okz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2778, '40055', 'okz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2779, '40057', 'okz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2780, '40059', 'okz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2781, '40061', 'okz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2782, '40063', 'okz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2783, '40065', 'okz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2784, '40067', 'okz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2785, '40069', 'okz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2786, '40071', 'okz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2787, '40073', 'okz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2788, '40075', 'okz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2789, '40077', 'okz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2790, '40079', 'okz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2791, '40081', 'okz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2792, '40083', 'okz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2793, '40085', 'okz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2794, '40087', 'okz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2795, '40089', 'okz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2796, '40091', 'okz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2797, '40093', 'okz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2798, '40095', 'okz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2799, '40097', 'okz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2800, '40099', 'okz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2801, '40101', 'okz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2802, '40103', 'okz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2803, '40105', 'okz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2804, '40107', 'okz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2805, '40109', 'okz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2806, '40111', 'okz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2807, '40113', 'okz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2808, '40115', 'okz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2809, '40117', 'okz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2810, '40119', 'okz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2811, '40121', 'okz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2812, '40123', 'okz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2813, '40125', 'okz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2814, '40127', 'okz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2815, '40129', 'okz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2816, '40131', 'okz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2817, '40133', 'okz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2818, '40135', 'okz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2819, '40137', 'okz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2820, '40139', 'okz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2821, '40141', 'okz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2822, '40143', 'okz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2823, '40145', 'okz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2824, '40147', 'okz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2825, '40149', 'okz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2826, '40151', 'okz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2827, '40153', 'okz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2828, '41001', 'orz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2829, '41003', 'orz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2830, '41003', 'orz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2831, '41005', 'orz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2832, '41005', 'orz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2833, '41005', 'orz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2834, '41005', 'orz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2835, '41007', 'orz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2836, '41007', 'orz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2837, '41009', 'orz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2838, '41009', 'orz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2839, '41009', 'orz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2840, '41011', 'orz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2841, '41011', 'orz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2842, '41013', 'orz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2843, '41013', 'orz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2844, '41015', 'orz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2845, '41015', 'orz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2846, '41015', 'orz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2847, '41017', 'orz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2848, '41019', 'orz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2849, '41019', 'orz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2850, '41019', 'orz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2851, '41019', 'orz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2852, '41021', 'orz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2853, '41021', 'orz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2854, '41023', 'orz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2855, '41023', 'orz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2856, '41025', 'orz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2857, '41027', 'orz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2858, '41027', 'orz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2859, '41029', 'orz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2860, '41029', 'orz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2861, '41029', 'orz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2862, '41031', 'orz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2863, '41033', 'orz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2864, '41033', 'orz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2865, '41035', 'orz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2866, '41035', 'orz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2867, '41035', 'orz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2868, '41035', 'orz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2869, '41037', 'orz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2870, '41037', 'orz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2871, '41039', 'orz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2872, '41039', 'orz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2873, '41039', 'orz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2874, '41039', 'orz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2875, '41039', 'orz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2876, '41041', 'orz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2877, '41041', 'orz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2878, '41043', 'orz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2879, '41043', 'orz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2880, '41043', 'orz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2881, '41045', 'orz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2882, '41045', 'orz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2883, '41047', 'orz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2884, '41047', 'orz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2885, '41047', 'orz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2886, '41049', 'orz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2887, '41049', 'orz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2888, '41049', 'orz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2889, '41051', 'orz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2890, '41051', 'orz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2891, '41051', 'orz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2892, '41051', 'orz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2893, '41053', 'orz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2894, '41053', 'orz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2895, '41055', 'orz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2896, '41055', 'orz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2897, '41057', 'orz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2898, '41057', 'orz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2899, '41059', 'orz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2900, '41059', 'orz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2901, '41059', 'orz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2902, '41061', 'orz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2903, '41061', 'orz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2904, '41061', 'orz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2905, '41063', 'orz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2906, '41063', 'orz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2907, '41065', 'orz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2908, '41065', 'orz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2909, '41067', 'orz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2910, '41067', 'orz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2911, '41069', 'orz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2912, '41069', 'orz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2913, '41071', 'orz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2914, '41071', 'orz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2915, '42001', 'paz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2916, '42003', 'paz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2917, '42005', 'paz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2918, '42007', 'paz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2919, '42009', 'paz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2920, '42011', 'paz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2921, '42013', 'paz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2922, '42015', 'paz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2923, '42017', 'paz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2924, '42019', 'paz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2925, '42021', 'paz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2926, '42023', 'paz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2927, '42025', 'paz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2928, '42027', 'paz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2929, '42027', 'paz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2930, '42029', 'paz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2931, '42031', 'paz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2932, '42033', 'paz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2933, '42035', 'paz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2934, '42035', 'paz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2935, '42037', 'paz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2936, '42039', 'paz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2937, '42041', 'paz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2938, '42043', 'paz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2939, '42045', 'paz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2940, '42047', 'paz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2941, '42049', 'paz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2942, '42049', 'paz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2943, '42051', 'paz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2944, '42053', 'paz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2945, '42055', 'paz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2946, '42057', 'paz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2947, '42059', 'paz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2948, '42061', 'paz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2949, '42063', 'paz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2950, '42065', 'paz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2951, '42067', 'paz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2952, '42069', 'paz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2953, '42071', 'paz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2954, '42073', 'paz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2955, '42075', 'paz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2956, '42077', 'paz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2957, '42079', 'paz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2958, '42081', 'paz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2959, '42081', 'paz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2960, '42083', 'paz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2961, '42085', 'paz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2962, '42087', 'paz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2963, '42089', 'paz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2964, '42091', 'paz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2965, '42093', 'paz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2966, '42095', 'paz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2967, '42097', 'paz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2968, '42099', 'paz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2969, '42101', 'paz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2970, '42103', 'paz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2971, '42105', 'paz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2972, '42107', 'paz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2973, '42109', 'paz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2974, '42111', 'paz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2975, '42113', 'paz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2976, '42115', 'paz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2977, '42117', 'paz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2978, '42119', 'paz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2979, '42121', 'paz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2980, '42123', 'paz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2981, '42125', 'paz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2982, '42127', 'paz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2983, '42127', 'paz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2984, '42129', 'paz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2985, '42131', 'paz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2986, '42133', 'paz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2987, '44001', 'riz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2988, '44003', 'riz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2989, '44003', 'riz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2990, '44005', 'riz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2991, '44007', 'riz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2992, '44007', 'riz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2993, '44009', 'riz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2994, '44009', 'riz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2995, '45001', 'scz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2996, '45003', 'scz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2997, '45005', 'scz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2998, '45007', 'scz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (2999, '45009', 'scz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3000, '45011', 'scz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3001, '45013', 'scz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3002, '45015', 'scz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3003, '45017', 'scz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3004, '45019', 'scz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3005, '45021', 'scz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3006, '45023', 'scz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3007, '45025', 'scz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3008, '45027', 'scz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3009, '45029', 'scz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3010, '45029', 'scz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3011, '45031', 'scz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3012, '45033', 'scz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3013, '45035', 'scz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3014, '45037', 'scz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3015, '45039', 'scz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3016, '45041', 'scz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3017, '45043', 'scz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3018, '45045', 'scz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3019, '45045', 'scz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3020, '45047', 'scz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3021, '45049', 'scz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3022, '45051', 'scz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3023, '45053', 'scz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3024, '45053', 'scz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3025, '45055', 'scz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3026, '45057', 'scz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3027, '45059', 'scz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3028, '45061', 'scz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3029, '45063', 'scz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3030, '45065', 'scz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3031, '45067', 'scz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3032, '45069', 'scz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3033, '45071', 'scz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3034, '45073', 'scz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3035, '45073', 'scz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3036, '45075', 'scz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3037, '45077', 'scz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3038, '45077', 'scz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3039, '45079', 'scz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3040, '45081', 'scz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3041, '45083', 'scz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3042, '45085', 'scz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3043, '45087', 'scz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3044, '45089', 'scz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3045, '45091', 'scz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3046, '46003', 'sdz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3047, '46005', 'sdz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3048, '46007', 'sdz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3049, '46009', 'sdz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3050, '46011', 'sdz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3051, '46013', 'sdz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3052, '46015', 'sdz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3053, '46017', 'sdz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3054, '46019', 'sdz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3055, '46019', 'sdz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3056, '46021', 'sdz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3057, '46023', 'sdz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3058, '46025', 'sdz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3059, '46027', 'sdz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3060, '46029', 'sdz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3061, '46031', 'sdz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3062, '46033', 'sdz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3063, '46033', 'sdz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3064, '46033', 'sdz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3065, '46035', 'sdz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3066, '46037', 'sdz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3067, '46039', 'sdz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3068, '46041', 'sdz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3069, '46043', 'sdz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3070, '46045', 'sdz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3071, '46047', 'sdz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3072, '46047', 'sdz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3073, '46049', 'sdz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3074, '46051', 'sdz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3075, '46053', 'sdz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3076, '46055', 'sdz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3077, '46057', 'sdz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3078, '46059', 'sdz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3079, '46061', 'sdz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3080, '46063', 'sdz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3081, '46065', 'sdz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3082, '46067', 'sdz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3083, '46069', 'sdz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3084, '46071', 'sdz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3085, '46073', 'sdz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3086, '46075', 'sdz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3087, '46077', 'sdz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3088, '46079', 'sdz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3089, '46081', 'sdz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3090, '46081', 'sdz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3091, '46083', 'sdz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3092, '46085', 'sdz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3093, '46087', 'sdz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3094, '46089', 'sdz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3095, '46091', 'sdz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3096, '46093', 'sdz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3097, '46093', 'sdz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3098, '46093', 'sdz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3099, '46093', 'sdz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3100, '46093', 'sdz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3101, '46095', 'sdz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3102, '46097', 'sdz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3103, '46099', 'sdz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3104, '46101', 'sdz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3105, '46103', 'sdz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3106, '46103', 'sdz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3107, '46103', 'sdz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3108, '46105', 'sdz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3109, '46107', 'sdz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3110, '46109', 'sdz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3111, '46111', 'sdz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3112, '46113', 'sdz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3113, '46115', 'sdz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3114, '46117', 'sdz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3115, '46119', 'sdz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3116, '46121', 'sdz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3117, '46123', 'sdz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3118, '46125', 'sdz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3119, '46127', 'sdz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3120, '46129', 'sdz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3121, '46135', 'sdz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3122, '46137', 'sdz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3123, '47001', 'tnz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3124, '47003', 'tnz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3125, '47005', 'tnz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3126, '47007', 'tnz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3127, '47009', 'tnz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3128, '47009', 'tnz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3129, '47011', 'tnz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3130, '47013', 'tnz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3131, '47015', 'tnz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3132, '47017', 'tnz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3133, '47019', 'tnz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3134, '47019', 'tnz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3135, '47021', 'tnz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3136, '47023', 'tnz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3137, '47025', 'tnz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3138, '47027', 'tnz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3139, '47029', 'tnz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3140, '47029', 'tnz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3141, '47031', 'tnz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3142, '47033', 'tnz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3143, '47035', 'tnz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3144, '47037', 'tnz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3145, '47039', 'tnz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3146, '47041', 'tnz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3147, '47043', 'tnz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3148, '47045', 'tnz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3149, '47047', 'tnz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3150, '47049', 'tnz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3151, '47051', 'tnz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3152, '47053', 'tnz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3153, '47055', 'tnz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3154, '47057', 'tnz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3155, '47059', 'tnz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3156, '47059', 'tnz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3157, '47061', 'tnz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3158, '47063', 'tnz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3159, '47065', 'tnz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3160, '47067', 'tnz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3161, '47069', 'tnz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3162, '47071', 'tnz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3163, '47073', 'tnz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3164, '47075', 'tnz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3165, '47077', 'tnz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3166, '47079', 'tnz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3167, '47081', 'tnz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3168, '47083', 'tnz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3169, '47085', 'tnz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3170, '47087', 'tnz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3171, '47089', 'tnz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3172, '47091', 'tnz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3173, '47093', 'tnz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3174, '47095', 'tnz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3175, '47097', 'tnz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3176, '47099', 'tnz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3177, '47101', 'tnz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3178, '47103', 'tnz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3179, '47105', 'tnz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3180, '47107', 'tnz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3181, '47109', 'tnz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3182, '47111', 'tnz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3183, '47113', 'tnz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3184, '47115', 'tnz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3185, '47117', 'tnz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3186, '47119', 'tnz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3187, '47121', 'tnz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3188, '47123', 'tnz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3189, '47123', 'tnz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3190, '47125', 'tnz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3191, '47127', 'tnz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3192, '47129', 'tnz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3193, '47131', 'tnz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3194, '47133', 'tnz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3195, '47135', 'tnz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3196, '47137', 'tnz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3197, '47139', 'tnz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3198, '47139', 'tnz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3199, '47141', 'tnz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3200, '47143', 'tnz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3201, '47145', 'tnz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3202, '47147', 'tnz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3203, '47149', 'tnz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3204, '47151', 'tnz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3205, '47153', 'tnz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3206, '47155', 'tnz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3207, '47155', 'tnz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3208, '47157', 'tnz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3209, '47159', 'tnz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3210, '47161', 'tnz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3211, '47163', 'tnz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3212, '47165', 'tnz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3213, '47167', 'tnz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3214, '47169', 'tnz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3215, '47171', 'tnz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3216, '47173', 'tnz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3217, '47175', 'tnz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3218, '47177', 'tnz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3219, '47179', 'tnz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3220, '47181', 'tnz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3221, '47183', 'tnz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3222, '47185', 'tnz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3223, '47187', 'tnz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3224, '47189', 'tnz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3225, '48001', 'txz148')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3226, '48003', 'txz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3227, '48005', 'txz165')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3228, '48007', 'txz245')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3229, '48009', 'txz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3230, '48011', 'txz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3231, '48013', 'txz220')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3232, '48015', 'txz211')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3233, '48017', 'txz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3234, '48019', 'txz187')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3235, '48021', 'txz193')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3236, '48023', 'txz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3237, '48025', 'txz232')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3238, '48027', 'txz158')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3239, '48029', 'txz205')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3240, '48031', 'txz190')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3241, '48033', 'txz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3242, '48035', 'txz144')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3243, '48037', 'txz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3244, '48039', 'txz237')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3245, '48041', 'txz196')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3246, '48043', 'txz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3247, '48043', 'txz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3248, '48045', 'txz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3249, '48047', 'txz250')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3250, '48049', 'txz140')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3251, '48051', 'txz195')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3252, '48053', 'txz172')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3253, '48055', 'txz208')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3254, '48057', 'txz247')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3255, '48059', 'txz128')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3256, '48061', 'txz255')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3257, '48061', 'txz257')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3258, '48063', 'txz110')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3259, '48065', 'txz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3260, '48067', 'txz112')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3261, '48069', 'txz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3262, '48071', 'txz214')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3263, '48073', 'txz149')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3264, '48075', 'txz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3265, '48077', 'txz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3266, '48079', 'txz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3267, '48081', 'txz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3268, '48083', 'txz139')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3269, '48085', 'txz104')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3270, '48087', 'txz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3271, '48089', 'txz210')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3272, '48091', 'txz206')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3273, '48093', 'txz141')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3274, '48095', 'txz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3275, '48097', 'txz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3276, '48099', 'txz157')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3277, '48101', 'txz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3278, '48103', 'txz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3279, '48105', 'txz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3280, '48107', 'txz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3281, '48109', 'txz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3282, '48109', 'txz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3283, '48109', 'txz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3284, '48109', 'txz258')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3285, '48111', 'txz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3286, '48113', 'txz119')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3287, '48115', 'txz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3288, '48117', 'txz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3289, '48119', 'txz106')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3290, '48121', 'txz103')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3291, '48123', 'txz224')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3292, '48125', 'txz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3293, '48127', 'txz228')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3294, '48129', 'txz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3295, '48131', 'txz240')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3296, '48133', 'txz129')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3297, '48135', 'txz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3298, '48137', 'txz184')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3299, '48139', 'txz134')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3300, '48141', 'txz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3301, '48143', 'txz130')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3302, '48145', 'txz160')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3303, '48147', 'txz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3304, '48149', 'txz209')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3305, '48151', 'txz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3306, '48153', 'txz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3307, '48155', 'txz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3308, '48157', 'txz227')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3309, '48159', 'txz108')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3310, '48161', 'txz147')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3311, '48163', 'txz219')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3312, '48165', 'txz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3313, '48167', 'txz238')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3314, '48169', 'txz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3315, '48171', 'txz188')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3316, '48173', 'txz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3317, '48175', 'txz233')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3318, '48177', 'txz223')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3319, '48179', 'txz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3320, '48181', 'txz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3321, '48183', 'txz137')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3322, '48185', 'txz198')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3323, '48187', 'txz207')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3324, '48189', 'txz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3325, '48191', 'txz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3326, '48193', 'txz143')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3327, '48195', 'txz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3328, '48197', 'txz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3329, '48199', 'txz201')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3330, '48201', 'txz213')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3331, '48203', 'txz138')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3332, '48205', 'txz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3333, '48207', 'txz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3334, '48209', 'txz191')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3335, '48211', 'txz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3336, '48213', 'txz135')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3337, '48215', 'txz253')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3338, '48217', 'txz145')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3339, '48219', 'txz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3340, '48221', 'txz131')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3341, '48223', 'txz107')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3342, '48225', 'txz163')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3343, '48227', 'txz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3344, '48229', 'txz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3345, '48231', 'txz105')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3346, '48233', 'txz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3347, '48235', 'txz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3348, '48237', 'txz101')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3349, '48239', 'txz235')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3350, '48241', 'txz181')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3351, '48243', 'txz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3352, '48243', 'txz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3353, '48245', 'txz215')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3354, '48247', 'txz249')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3355, '48249', 'txz241')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3356, '48251', 'txz133')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3357, '48253', 'txz113')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3358, '48255', 'txz222')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3359, '48257', 'txz121')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3360, '48259', 'txz189')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3361, '48261', 'txz251')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3362, '48263', 'txz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3363, '48265', 'txz186')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3364, '48267', 'txz169')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3365, '48269', 'txz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3366, '48271', 'txz202')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3367, '48273', 'txz242')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3368, '48275', 'txz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3369, '48277', 'txz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3370, '48279', 'txz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3371, '48281', 'txz156')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3372, '48283', 'txz229')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3373, '48285', 'txz225')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3374, '48287', 'txz194')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3375, '48289', 'txz162')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3376, '48291', 'txz200')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3377, '48293', 'txz161')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3378, '48295', 'txz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3379, '48297', 'txz231')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3380, '48299', 'txz171')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3381, '48301', 'txz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3382, '48303', 'txz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3383, '48305', 'txz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3384, '48307', 'txz154')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3385, '48309', 'txz159')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3386, '48311', 'txz230')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3387, '48313', 'txz176')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3388, '48315', 'txz126')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3389, '48317', 'txz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3390, '48319', 'txz170')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3391, '48321', 'txz236')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3392, '48323', 'txz217')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3393, '48325', 'txz204')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3394, '48327', 'txz168')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3395, '48329', 'txz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3396, '48331', 'txz174')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3397, '48333', 'txz142')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3398, '48335', 'txz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3399, '48337', 'txz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3400, '48339', 'txz199')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3401, '48341', 'txz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3402, '48343', 'txz111')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3403, '48345', 'txz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3404, '48347', 'txz152')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3405, '48349', 'txz146')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3406, '48351', 'txz182')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3407, '48353', 'txz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3408, '48355', 'txz243')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3409, '48357', 'txz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3410, '48359', 'txz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3411, '48361', 'txz216')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3412, '48363', 'txz116')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3413, '48365', 'txz151')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3414, '48367', 'txz117')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3415, '48369', 'txz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3416, '48371', 'txz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3417, '48373', 'txz179')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3418, '48375', 'txz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3419, '48377', 'txz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3420, '48377', 'txz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3421, '48379', 'txz123')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3422, '48381', 'txz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3423, '48383', 'txz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3424, '48385', 'txz185')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3425, '48387', 'txz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3426, '48389', 'txz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3427, '48389', 'txz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3428, '48391', 'txz246')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3429, '48393', 'txz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3430, '48395', 'txz175')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3431, '48397', 'txz120')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3432, '48399', 'txz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3433, '48401', 'txz150')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3434, '48403', 'txz167')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3435, '48405', 'txz166')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3436, '48407', 'txz178')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3437, '48409', 'txz244')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3438, '48411', 'txz155')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3439, '48413', 'txz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3440, '48415', 'txz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3441, '48417', 'txz114')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3442, '48419', 'txz153')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3443, '48421', 'txz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3444, '48423', 'txz136')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3445, '48425', 'txz132')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3446, '48427', 'txz252')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3447, '48429', 'txz115')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3448, '48431', 'txz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3449, '48433', 'txz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3450, '48435', 'txz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3451, '48437', 'txz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3452, '48439', 'txz118')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3453, '48441', 'txz127')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3454, '48443', 'txz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3455, '48445', 'txz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3456, '48447', 'txz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3457, '48449', 'txz109')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3458, '48451', 'txz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3459, '48453', 'txz192')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3460, '48455', 'txz164')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3461, '48457', 'txz180')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3462, '48459', 'txz125')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3463, '48461', 'txz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3464, '48463', 'txz203')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3465, '48465', 'txz183')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3466, '48467', 'txz122')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3467, '48469', 'txz234')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3468, '48471', 'txz177')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3469, '48473', 'txz212')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3470, '48475', 'txz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3471, '48477', 'txz197')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3472, '48479', 'txz239')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3473, '48481', 'txz226')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3474, '48483', 'txz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3475, '48485', 'txz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3476, '48487', 'txz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3477, '48489', 'txz254')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3478, '48489', 'txz256')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3479, '48491', 'txz173')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3480, '48493', 'txz221')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3481, '48495', 'txz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3482, '48497', 'txz102')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3483, '48499', 'txz124')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3484, '48501', 'txz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3485, '48503', 'txz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3486, '48505', 'txz248')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3487, '48507', 'txz218')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3488, '49001', 'utz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3489, '49001', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3490, '49003', 'utz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3491, '49003', 'utz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3492, '49003', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3493, '49005', 'utz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3494, '49005', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3495, '49007', 'utz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3496, '49007', 'utz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3497, '49009', 'utz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3498, '49011', 'utz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3499, '49011', 'utz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3500, '49011', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3501, '49013', 'utz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3502, '49013', 'utz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3503, '49013', 'utz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3504, '49015', 'utz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3505, '49015', 'utz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3506, '49015', 'utz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3507, '49015', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3508, '49017', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3509, '49017', 'utz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3510, '49017', 'utz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3511, '49017', 'utz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3512, '49019', 'utz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3513, '49019', 'utz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3514, '49019', 'utz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3515, '49021', 'utz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3516, '49021', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3517, '49023', 'utz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3518, '49023', 'utz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3519, '49023', 'utz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3520, '49023', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3521, '49025', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3522, '49025', 'utz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3523, '49025', 'utz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3524, '49027', 'utz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3525, '49027', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3526, '49029', 'utz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3527, '49029', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3528, '49031', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3529, '49033', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3530, '49035', 'utz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3531, '49035', 'utz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3532, '49035', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3533, '49035', 'utz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3534, '49037', 'utz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3535, '49037', 'utz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3536, '49037', 'utz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3537, '49037', 'utz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3538, '49039', 'utz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3539, '49039', 'utz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3540, '49039', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3541, '49041', 'utz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3542, '49041', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3543, '49043', 'utz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3544, '49043', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3545, '49043', 'utz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3546, '49043', 'utz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3547, '49045', 'utz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3548, '49045', 'utz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3549, '49045', 'utz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3550, '49047', 'utz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3551, '49047', 'utz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3552, '49047', 'utz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3553, '49049', 'utz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3554, '49049', 'utz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3555, '49049', 'utz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3556, '49051', 'utz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3557, '49051', 'utz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3558, '49051', 'utz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3559, '49051', 'utz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3560, '49053', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3561, '49053', 'utz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3562, '49053', 'utz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3563, '49055', 'utz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3564, '49055', 'utz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3565, '49057', 'utz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3566, '49057', 'utz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3567, '49057', 'utz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3568, '50001', 'vtz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3569, '50001', 'vtz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3570, '50003', 'vtz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3571, '50005', 'vtz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3572, '50007', 'vtz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3573, '50007', 'vtz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3574, '50009', 'vtz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3575, '50011', 'vtz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3576, '50011', 'vtz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3577, '50013', 'vtz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3578, '50015', 'vtz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3579, '50017', 'vtz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3580, '50019', 'vtz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3581, '50021', 'vtz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3582, '50021', 'vtz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3583, '50023', 'vtz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3584, '50025', 'vtz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3585, '50025', 'vtz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3586, '50027', 'vtz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3587, '51001', 'vaz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3588, '51003', 'vaz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3589, '51005', 'vaz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3590, '51007', 'vaz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3591, '51009', 'vaz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3592, '51011', 'vaz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3593, '51013', 'vaz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3594, '51015', 'vaz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3595, '51017', 'vaz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3596, '51019', 'vaz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3597, '51021', 'vaz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3598, '51023', 'vaz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3599, '51025', 'vaz079')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3600, '51027', 'vaz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3601, '51029', 'vaz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3602, '51031', 'vaz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3603, '51033', 'vaz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3604, '51035', 'vaz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3605, '51036', 'vaz082')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3606, '51037', 'vaz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3607, '51041', 'vaz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3608, '51043', 'vaz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3609, '51045', 'vaz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3610, '51047', 'vaz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3611, '51049', 'vaz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3612, '51051', 'vaz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3613, '51053', 'vaz080')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3614, '51057', 'vaz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3615, '51059', 'vaz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3616, '51061', 'vaz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3617, '51063', 'vaz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3618, '51065', 'vaz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3619, '51067', 'vaz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3620, '51069', 'vaz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3621, '51071', 'vaz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3622, '51073', 'vaz084')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3623, '51075', 'vaz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3624, '51077', 'vaz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3625, '51079', 'vaz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3626, '51081', 'vaz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3627, '51083', 'vaz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3628, '51085', 'vaz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3629, '51087', 'vaz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3630, '51089', 'vaz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3631, '51091', 'vaz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3632, '51093', 'vaz093')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3633, '51095', 'vaz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3634, '51097', 'vaz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3635, '51099', 'vaz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3636, '51101', 'vaz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3637, '51103', 'vaz078')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3638, '51105', 'vaz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3639, '51107', 'vaz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3640, '51109', 'vaz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3641, '51111', 'vaz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3642, '51113', 'vaz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3643, '51115', 'vaz086')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3644, '51117', 'vaz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3645, '51119', 'vaz085')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3646, '51121', 'vaz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3647, '51125', 'vaz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3648, '51127', 'vaz083')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3649, '51131', 'vaz100')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3650, '51133', 'vaz077')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3651, '51135', 'vaz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3652, '51137', 'vaz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3653, '51139', 'vaz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3654, '51141', 'vaz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3655, '51143', 'vaz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3656, '51145', 'vaz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3657, '51147', 'vaz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3658, '51149', 'vaz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3659, '51153', 'vaz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3660, '51155', 'vaz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3661, '51157', 'vaz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3662, '51159', 'vaz076')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3663, '51161', 'vaz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3664, '51163', 'vaz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3665, '51165', 'vaz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3666, '51167', 'vaz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3667, '51169', 'vaz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3668, '51171', 'vaz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3669, '51173', 'vaz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3670, '51175', 'vaz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3671, '51177', 'vaz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3672, '51179', 'vaz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3673, '51181', 'vaz089')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3674, '51183', 'vaz088')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3675, '51185', 'vaz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3676, '51187', 'vaz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3677, '51191', 'vaz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3678, '51193', 'vaz075')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3679, '51195', 'vaz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3680, '51197', 'vaz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3681, '51199', 'vaz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3682, '51510', 'vaz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3683, '51515', 'vaz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3684, '51520', 'vaz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3685, '51530', 'vaz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3686, '51540', 'vaz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3687, '51550', 'vaz097')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3688, '51560', 'vaz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3689, '51570', 'vaz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3690, '51580', 'vaz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3691, '51590', 'vaz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3692, '51595', 'vaz087')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3693, '51600', 'vaz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3694, '51610', 'vaz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3695, '51620', 'vaz092')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3696, '51630', 'vaz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3697, '51640', 'vaz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3698, '51650', 'vaz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3699, '51660', 'vaz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3700, '51670', 'vaz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3701, '51678', 'vaz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3702, '51680', 'vaz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3703, '51683', 'vaz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3704, '51685', 'vaz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3705, '51690', 'vaz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3706, '51700', 'vaz094')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3707, '51710', 'vaz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3708, '51720', 'vaz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3709, '51730', 'vaz081')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3710, '51735', 'vaz091')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3711, '51740', 'vaz095')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3712, '51750', 'vaz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3713, '51760', 'vaz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3714, '51770', 'vaz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3715, '51775', 'vaz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3716, '51790', 'vaz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3717, '51800', 'vaz096')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3718, '51810', 'vaz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3719, '51820', 'vaz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3720, '51830', 'vaz090')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3721, '51840', 'vaz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3722, '53001', 'waz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3723, '53001', 'waz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3724, '53003', 'waz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3725, '53003', 'waz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3726, '53005', 'waz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3727, '53007', 'waz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3728, '53007', 'waz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3729, '53009', 'waz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3730, '53009', 'waz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3731, '53009', 'waz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3732, '53009', 'waz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3733, '53011', 'waz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3734, '53011', 'waz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3735, '53011', 'waz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3736, '53011', 'waz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3737, '53011', 'waz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3738, '53013', 'waz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3739, '53013', 'waz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3740, '53015', 'waz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3741, '53015', 'waz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3742, '53015', 'waz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3743, '53015', 'waz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3744, '53017', 'waz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3745, '53017', 'waz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3746, '53017', 'waz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3747, '53017', 'waz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3748, '53019', 'waz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3749, '53021', 'waz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3750, '53023', 'waz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3751, '53023', 'waz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3752, '53025', 'waz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3753, '53025', 'waz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3754, '53025', 'waz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3755, '53027', 'waz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3756, '53027', 'waz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3757, '53027', 'waz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3758, '53029', 'waz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3759, '53031', 'waz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3760, '53031', 'waz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3761, '53031', 'waz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3762, '53031', 'waz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3763, '53031', 'waz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3764, '53033', 'waz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3765, '53033', 'waz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3766, '53033', 'waz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3767, '53035', 'waz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3768, '53037', 'waz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3769, '53037', 'waz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3770, '53039', 'waz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3771, '53039', 'waz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3772, '53039', 'waz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3773, '53041', 'waz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3774, '53041', 'waz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3775, '53041', 'waz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3776, '53043', 'waz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3777, '53043', 'waz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3778, '53045', 'waz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3779, '53045', 'waz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3780, '53045', 'waz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3781, '53047', 'waz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3782, '53047', 'waz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3783, '53047', 'waz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3784, '53047', 'waz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3785, '53049', 'waz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3786, '53049', 'waz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3787, '53051', 'waz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3788, '53053', 'waz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3789, '53053', 'waz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3790, '53053', 'waz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3791, '53055', 'waz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3792, '53057', 'waz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3793, '53057', 'waz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3794, '53057', 'waz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3795, '53059', 'waz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3796, '53059', 'waz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3797, '53059', 'waz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3798, '53061', 'waz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3799, '53061', 'waz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3800, '53061', 'waz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3801, '53061', 'waz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3802, '53063', 'waz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3803, '53063', 'waz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3804, '53063', 'waz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3805, '53065', 'waz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3806, '53067', 'waz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3807, '53067', 'waz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3808, '53069', 'waz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3809, '53069', 'waz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3810, '53069', 'waz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3811, '53071', 'waz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3812, '53071', 'waz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3813, '53071', 'waz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3814, '53073', 'waz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3815, '53073', 'waz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3816, '53075', 'waz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3817, '53077', 'waz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3818, '53077', 'waz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3819, '54001', 'wvz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3820, '54003', 'wvz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3821, '54005', 'wvz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3822, '54007', 'wvz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3823, '54009', 'wvz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3824, '54011', 'wvz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3825, '54013', 'wvz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3826, '54015', 'wvz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3827, '54017', 'wvz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3828, '54019', 'wvz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3829, '54021', 'wvz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3830, '54023', 'wvz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3831, '54025', 'wvz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3832, '54027', 'wvz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3833, '54029', 'wvz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3834, '54031', 'wvz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3835, '54033', 'wvz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3836, '54035', 'wvz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3837, '54037', 'wvz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3838, '54039', 'wvz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3839, '54041', 'wvz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3840, '54043', 'wvz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3841, '54045', 'wvz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3842, '54047', 'wvz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3843, '54049', 'wvz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3844, '54051', 'wvz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3845, '54053', 'wvz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3846, '54055', 'wvz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3847, '54057', 'wvz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3848, '54059', 'wvz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3849, '54061', 'wvz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3850, '54063', 'wvz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3851, '54065', 'wvz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3852, '54067', 'wvz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3853, '54069', 'wvz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3854, '54071', 'wvz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3855, '54073', 'wvz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3856, '54075', 'wvz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3857, '54077', 'wvz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3858, '54079', 'wvz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3859, '54081', 'wvz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3860, '54083', 'wvz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3861, '54085', 'wvz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3862, '54087', 'wvz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3863, '54089', 'wvz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3864, '54091', 'wvz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3865, '54093', 'wvz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3866, '54095', 'wvz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3867, '54097', 'wvz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3868, '54099', 'wvz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3869, '54101', 'wvz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3870, '54103', 'wvz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3871, '54105', 'wvz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3872, '54107', 'wvz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3873, '54109', 'wvz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3874, '55001', 'wiz044')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3875, '55003', 'wiz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3876, '55005', 'wiz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3877, '55007', 'wiz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3878, '55009', 'wiz039')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3879, '55011', 'wiz032')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3880, '55013', 'wiz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3881, '55015', 'wiz049')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3882, '55017', 'wiz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3883, '55019', 'wiz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3884, '55021', 'wiz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3885, '55023', 'wiz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3886, '55025', 'wiz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3887, '55027', 'wiz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3888, '55029', 'wiz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3889, '55031', 'wiz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3890, '55033', 'wiz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3891, '55035', 'wiz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3892, '55037', 'wiz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3893, '55039', 'wiz051')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3894, '55041', 'wiz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3895, '55043', 'wiz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3896, '55045', 'wiz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3897, '55047', 'wiz047')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3898, '55049', 'wiz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3899, '55051', 'wiz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3900, '55053', 'wiz034')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3901, '55055', 'wiz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3902, '55057', 'wiz043')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3903, '55059', 'wiz072')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3904, '55061', 'wiz040')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3905, '55063', 'wiz041')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3906, '55065', 'wiz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3907, '55067', 'wiz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3908, '55069', 'wiz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3909, '55071', 'wiz050')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3910, '55073', 'wiz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3911, '55075', 'wiz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3912, '55075', 'wiz073')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3913, '55077', 'wiz046')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3914, '55078', 'wiz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3915, '55079', 'wiz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3916, '55081', 'wiz042')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3917, '55083', 'wiz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3918, '55083', 'wiz074')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3919, '55085', 'wiz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3920, '55087', 'wiz038')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3921, '55089', 'wiz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3922, '55091', 'wiz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3923, '55093', 'wiz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3924, '55095', 'wiz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3925, '55097', 'wiz036')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3926, '55099', 'wiz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3927, '55101', 'wiz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3928, '55103', 'wiz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3929, '55105', 'wiz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3930, '55107', 'wiz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3931, '55109', 'wiz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3932, '55111', 'wiz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3933, '55113', 'wiz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3934, '55115', 'wiz031')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3935, '55117', 'wiz052')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3936, '55119', 'wiz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3937, '55121', 'wiz033')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3938, '55123', 'wiz053')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3939, '55125', 'wiz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3940, '55127', 'wiz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3941, '55129', 'wiz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3942, '55131', 'wiz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3943, '55133', 'wiz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3944, '55135', 'wiz037')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3945, '55137', 'wiz045')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3946, '55139', 'wiz048')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3947, '55141', 'wiz035')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3948, '56001', 'wyz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3949, '56001', 'wyz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3950, '56001', 'wyz065')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3951, '56001', 'wyz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3952, '56003', 'wyz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3953, '56003', 'wyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3954, '56003', 'wyz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3955, '56005', 'wyz054')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3956, '56005', 'wyz055')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3957, '56007', 'wyz061')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3958, '56007', 'wyz062')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3959, '56007', 'wyz063')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3960, '56009', 'wyz059')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3961, '56009', 'wyz064')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3962, '56011', 'wyz056')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3963, '56011', 'wyz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3964, '56011', 'wyz071')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3965, '56013', 'wyz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3966, '56013', 'wyz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3967, '56013', 'wyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3968, '56013', 'wyz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3969, '56013', 'wyz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3970, '56013', 'wyz016')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3971, '56013', 'wyz017')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3972, '56013', 'wyz018')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3973, '56013', 'wyz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3974, '56013', 'wyz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3975, '56015', 'wyz068')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3976, '56017', 'wyz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3977, '56017', 'wyz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3978, '56017', 'wyz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3979, '56019', 'wyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3980, '56019', 'wyz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3981, '56019', 'wyz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3982, '56019', 'wyz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3983, '56021', 'wyz066')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3984, '56021', 'wyz069')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3985, '56021', 'wyz070')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3986, '56023', 'wyz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3987, '56023', 'wyz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3988, '56023', 'wyz023')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3989, '56023', 'wyz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3990, '56023', 'wyz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3991, '56023', 'wyz027')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3992, '56025', 'wyz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3993, '56025', 'wyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3994, '56025', 'wyz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3995, '56025', 'wyz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3996, '56025', 'wyz020')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3997, '56025', 'wyz022')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3998, '56027', 'wyz060')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (3999, '56029', 'wyz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4000, '56029', 'wyz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4001, '56029', 'wyz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4002, '56029', 'wyz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4003, '56031', 'wyz067')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4004, '56033', 'wyz098')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4005, '56033', 'wyz099')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4006, '56035', 'wyz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4007, '56035', 'wyz014')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4008, '56035', 'wyz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4009, '56035', 'wyz024')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4010, '56035', 'wyz025')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4011, '56035', 'wyz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4012, '56037', 'wyz019')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4013, '56037', 'wyz026')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4014, '56037', 'wyz028')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4015, '56037', 'wyz029')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4016, '56037', 'wyz030')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4017, '56039', 'wyz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4018, '56039', 'wyz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4019, '56039', 'wyz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4020, '56039', 'wyz015')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4021, '56041', 'wyz021')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4022, '56043', 'wyz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4023, '56043', 'wyz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4024, '56043', 'wyz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4025, '56045', 'wyz057')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4026, '56045', 'wyz058')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4027, '66010', 'guz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4028, '69100', 'mpz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4029, '69110', 'mpz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4030, '69120', 'mpz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4031, '72001', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4032, '72003', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4033, '72005', 'prz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4034, '72007', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4035, '72009', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4036, '72011', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4037, '72013', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4038, '72015', 'prz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4039, '72017', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4040, '72019', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4041, '72021', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4042, '72023', 'prz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4043, '72025', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4044, '72027', 'prz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4045, '72029', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4046, '72031', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4047, '72033', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4048, '72035', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4049, '72037', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4050, '72039', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4051, '72041', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4052, '72043', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4053, '72045', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4054, '72047', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4055, '72049', 'prz012')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4056, '72051', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4057, '72053', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4058, '72054', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4059, '72055', 'prz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4060, '72057', 'prz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4061, '72059', 'prz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4062, '72061', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4063, '72063', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4064, '72065', 'prz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4065, '72067', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4066, '72069', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4067, '72071', 'prz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4068, '72073', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4069, '72075', 'prz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4070, '72077', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4071, '72079', 'prz011')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4072, '72081', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4073, '72083', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4074, '72085', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4075, '72087', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4076, '72089', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4077, '72091', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4078, '72093', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4079, '72095', 'prz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4080, '72097', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4081, '72099', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4082, '72101', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4083, '72103', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4084, '72105', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4085, '72107', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4086, '72109', 'prz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4087, '72111', 'prz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4088, '72113', 'prz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4089, '72115', 'prz008')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4090, '72117', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4091, '72119', 'prz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4092, '72121', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4093, '72123', 'prz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4094, '72125', 'prz010')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4095, '72127', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4096, '72129', 'prz004')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4097, '72131', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4098, '72133', 'prz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4099, '72135', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4100, '72137', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4101, '72139', 'prz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4102, '72141', 'prz009')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4103, '72143', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4104, '72145', 'prz005')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4105, '72147', 'prz013')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4106, '72149', 'prz006')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4107, '72151', 'prz003')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4108, '72153', 'prz007')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4109, '78010', 'viz002')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4110, '78020', 'viz001')";
	$queries[] = "INSERT INTO ".$prefix."_weatherzones VALUES (4111, '78030', 'viz001')";

	$i = 0;
	foreach($queries AS $query) {
		$i++;
		$result = $db->sql_query($query, true);
		if (!$result) {
			$this->description = '<b>MySQL Error</b> while executing:<br/>'.$query.'<br/><br/>'.mysql_error();
			return false;
		}
		if ($i == 100) { echo '.'; $i = 0; }
	}

	echo '<br />Database updated - have fun!';
	CloseTable();
	include('footer.php');
