<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################

if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin('weatherharvest')) { exit; }

$module_name = "WeatherHarvest";
require_once("modules/$module_name/admin/wh_stations.php");
require_once("modules/$module_name/admin/wh_db_marine.php");

/******************************************************************************/
/* function fnSelectWHDB()                                                    */
/* This function allows you to select the database to manage                  */
/******************************************************************************/

function fnSelectWHDB() {

  include( "header.php" );
	adminWHMenu();
  OpenTable();
  fnDBManageMenu();
  CloseTable();
  include("footer.php");
}

function fnDBManageMenu() {
  echo "<table align=\"center\" width=\"100%\"><tr><th>"._ADMIN_WH_DB_MANAGEMENT."</th></tr>\n";
  echo '<tr><td><ul>';
  echo "<li><b>INSERT</b> Extra Database Records (before using the module)\n";
  echo "<ul>\n";
  echo "<li><span style=\"color:red;\">Clicking this link will add data to 3 WeatherHarvest database tables!</span><br /><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBinsert")."\">Insert Weather Stations &amp; Zones and Marine Buoys</a><br />This is a large file, but the records are needed, so please wait patiently after you click.<br />(It can also be used to restore your records should any of the following actions go awry)<br /><br /></li>\n";
  echo "</ul>\n";
  echo "</li><li>"._WH_DB_ADD."\n";
  echo "<ul>\n";
  echo "<li><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBAddStation&amp;whdb=stations")."\">"._WH_DB_STATIONS."</a></li>\n";
  echo "<li><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBAddMarine&amp;whdb=marine")."\">"._WH_DB_MARINE."</a><br /><br /></li>\n";
  echo "</ul>\n";
  echo "</li><li>"._WH_DB_EDIT."\n";
  echo "<ul>\n";
  echo "<li><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBSelection&amp;whdb=stations&amp;action=edit")."\">"._WH_DB_STATIONS."</a></li>\n";
  echo "<li><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBSelection&amp;whdb=marine&amp;action=edit")."\">"._WH_DB_MARINE."</a><br /><br /></li>\n";
  echo "</ul>\n";
  echo "</li><li>"._WH_DB_DELETE."\n";
  echo "<ul>\n";
  echo "<li><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBSelection&amp;whdb=stations&amp;action=del")."\">"._WH_DB_STATIONS."</a></li>\n";
  echo "<li><a href=\"".adminlink("WeatherHarvest&amp;mode=adminWHDBSelection&amp;whdb=marine&amp;action=del")."\">"._WH_DB_MARINE."</a></li>\n";
  echo "</ul>\n";
  echo "</li></ul></td></tr>\n";
  echo "</table>\n";
}

/******************************************************************************/
/* the following are functions for managing the *_weatherstations table       */
/******************************************************************************/

/******************************************************************************/
/* function fnWeatherStations( $func, $which )                                */
/* $func - add, edit, or delete                                               */
/* $which - 0 = Country, 1 = Region, 2 = City                                 */
/* this function will allow you to add, edit, delete from the weatherstations */
/* table - WARNING - very dangerous if you don't know what you are doing!!!   */
/******************************************************************************/

function fnWeatherStations( $func, $which = 0, $country = "", $region = "" ) {
  global $db, $prefix;
  
  $whstations = new whstations();
  
  include( "header.php" );
  OpenTable();
  
  fnSelectWHStation();

  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnSelectWHStationEdit( $which, $country, $region )                */
/* function to allow you to select a station to edit.                         */
/******************************************************************************/

function fnSelectWHStation() {
  global $db, $prefix;
$which=isset($_POST['which']);
$country=isset($_POST['country']);
$region=isset($_POST['region']);
$func=isset($_POST['func']);
  $whstations = new whstations();

  switch( $which )
  {
    case 0:
	default:
	  $whstations->DisplayCountries( $func );
	  break;
	  
	case 1:
	  $whstations->DisplayRegions($country, $func);
	  break;
	  
	case 2:
	  $whstations->DisplayCity( $region, $func );
	  break;    
  }
}

/******************************************************************************/
/* function fnEditSelectedWHStation( $id )                                    */
/* this function will allow the admin to edit the selected weather station    */
/******************************************************************************/

function fnEditSelectedWHStation( $id ) {
  global $db, $prefix;

  $whstations = new whstations();

  include( "header.php" );
  OpenTable();
  
  if ( ( $list = $whstations->getselectedid( $id ) ) !== false )
  {
    // build screen form for update
	echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._UPDATE_RECORD.$id."</th></tr>\n"
	    ."<tr><td><table align=\"center\"><tr><td align=\"right\">\n"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminWHDBUpdateStation\">\n"		
		."<input type=\"hidden\" name=\"id\" value=\"".$id."\">\n"
		."<input type=\"hidden\" name=\"country\" value=\"".$list['country']."\">\n";
		
	$country_name = $whstations->getcountryname( $list['country'] );
	
	echo _WH_COUNTRY."&nbsp;".$country_name."<br />\n";
	echo _WH_REGION."&nbsp;<input type=\"text\" name=\"region\" maxlength=\"50\" size=\"30\" value=\"".$list['region']."\"><br />\n";
	echo _WH_REPSTATION."&nbsp;<input type=\"text\" name=\"repstation\" maxlength=\"100\" size=\"30\" value=\"".$list['repstation']."\"><br />\n";
	echo _WH_METAR."&nbsp;<input type=\"text\" name=\"code\" maxlength=\"4\" size=\"30\" value=\"".$list['code']."\"><br />\n";
	echo _WH_FIPS."&nbsp;<input type=\"text\" name=\"fips\" maxlength=\"5\" size=\"30\" value=\"".$list['fips']."\"><br />\n";
	echo _WH_PRIRADAR."&nbsp;<input type=\"text\" name=\"primaryradar\" maxlength=\"4\" size=\"30\" value=\"".$list['primaryradar']."\"><br />\n";
	echo _WH_SECRADAR."&nbsp;<input type=\"text\" name=\"secondaryradar\" maxlength=\"4\" size=\"30\" value=\"".$list['secondaryradar']."\"><br />\n";
	echo _WH_USERRADAR."&nbsp;<input type=\"text\" name=\"userradar\"  maxlength=\"255\" size=\"30\" value=\"".$list['userradar']."\"><br />\n";
		
	echo "</td></tr><tr><td align=\"center\"><input type=\"submit\" value=\""._UPDATE_DB."\"></form>\n";	
    echo "</td></tr></table></td></tr></table>\n";       
  }
  else
  {
    echo _INV_DATABASE_ID;
  }

  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnUpdateSelectedWHStation( $list )                                */
/* Function will update the database weatherstations with the supplied values */
/******************************************************************************/

function fnUpdateSelectedWHStation( $list ) {
  global $db, $prefix;

  $whstations = new whstations();

  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._UPDATE_RECORD.$list['id']."</th></tr>\n";
  
  echo "<tr><td align=\"left\">\n";
  echo _WH_COUNTRY."&nbsp;".$list['country']."<br />\n";
  echo _WH_REGION."&nbsp;".$list['region']."<br />\n";
  echo _WH_REPSTATION."&nbsp;".$list['repstation']."<br />\n";
  echo _WH_METAR."&nbsp;".$list['code']."<br />\n";
  echo _WH_FIPS."&nbsp;".$list['fips']."<br />\n";
  echo _WH_PRIRADAR."&nbsp;".$list['primaryradar']."<br />\n";
  echo _WH_SECRADAR."&nbsp;".$list['secondaryradar']."<br />\n";
  echo _WH_USERRADAR."&nbsp;".$list['userradar']."<br />\n";
  echo "</td></tr>\n";
  
  if ( $whstations->updatestation( $list ) == true ) 
  {
    echo "<tr><td>"._WH_DB_RECORD_UPDATE_SUCCESS."</td></tr>\n";	
  }
  else
  {
    echo "<tr><td>"._WH_DB_RECORD_UPDATE_FAILED."</td></tr>\n";
  }
  
  echo "</table>\n";
  
  fnDBManageMenu();
  
  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnDelSelectedWHStation( $id )                                     */
/* print out the database record and verify with admin to delete from table   */
/******************************************************************************/

function fnDelSelectedWHStation( $id ) {
  global $db, $prefix;
  
  $whstations = new whstations();
  
  include( "header.php" );
  OpenTable();
  
  $list = $whstations->getselectedid( $id );
  
  if ( $list !== false )
  {
    echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._VERIFY_DEL.$list['id']."</th></tr>\n"
	    ."<tr><td align=\"center\">\n";
	$country_name = $whstations->getcountryname( $list['country'] );
	echo _WH_COUNTRY."&nbsp;<u>".$country_name."</u><br />\n";
	echo _WH_REGION."&nbsp;<u>".$list['region']."</u><br />\n";
	echo _WH_REPSTATION."&nbsp;<u>".$list['repstation']."</u><br />\n";
	echo _WH_METAR."&nbsp;<u>".$list['code']."</u><br />\n";
	echo _WH_FIPS."&nbsp;<u>".$list['fips']."</u><br />\n";
	echo _WH_PRIRADAR."&nbsp;<u>".$list['primaryradar']."</u><br />\n";
	echo _WH_SECRADAR."&nbsp;<u>".$list['secondaryradar']."</u><br />\n";
	echo _WH_USERRADAR."&nbsp;<u>".$list['userradar']."</u><br />\n";
	echo "</td></tr><tr><td align=\"center\">\n"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminWHDBDeleteStation\">\n"		
		."<input type=\"hidden\" name=\"id\" value=\"".$id."\">\n"
        ."<input type=\"submit\" value=\""._DELETE_RECORD."\"></form>\n";	
	echo "</td></tr></table>\n";	
  }
  
  CloseTable();
  include("footer.php" );
}

/******************************************************************************/
/* function fnDeleteWHStation( $id )                                          */
/* function will perform the actual delete of the record.                     */
/******************************************************************************/

function fnDeleteWHStation( $id ) {
  global $db, $prefix;
  
  $whstations = new whstations();
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._DELETE_RECORD.$id."</th></tr>\n";
  
  if ( $whstations->deletestation( $id ) == true )
  {
    echo "<tr><td>"._WH_DB_RECORD_DELETE_SUCCESS."</td></tr>\n";	
  }
  else
  {
    echo "<tr><td>"._WH_DB_RECORD_DELETE_FAILED."</td></tr>\n";
  }
  
  echo "</table>\n";
  
  fnDBManageMenu();
  
  CloseTable();
  include("footer.php" );
}

/******************************************************************************/
/* function fnAddWHStation()                                                  */
/* Presents admin with a form to add a new record to the table                */
/******************************************************************************/

function fnAddWHStation() {
  global $db, $prefix;
  
  $whstations = new whstations();
  
  include( "header.php" );
  OpenTable();
  
    // build screen form for update
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._ADD_RECORD."</th></tr>\n"
	    ."<tr><td><table align=\"center\"><tr><td align=\"right\">\n"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminWHDBInsertStation\">\n";		
		
  echo _WH_COUNTRY."<br />";
  
  $whstations->DisplayCountryList();
  
  echo "<br />"._WH_REGION."&nbsp;<input type=\"text\" name=\"region\" maxlength=\"50\" size=\"30\"><br />\n";
  echo _WH_REPSTATION."&nbsp;<input type=\"text\" name=\"repstation\" maxlength=\"100\" size=\"30\"><br />\n";
  echo _WH_METAR."&nbsp;<input type=\"text\" name=\"code\" maxlength=\"4\" size=\"30\"><br />\n";
  echo _WH_FIPS."&nbsp;<input type=\"text\" name=\"fips\" maxlength=\"5\" size=\"30\"><br />\n";
  echo _WH_PRIRADAR."&nbsp;<input type=\"text\" name=\"primaryradar\" maxlength=\"4\" size=\"30\"><br />\n";
  echo _WH_SECRADAR."&nbsp;<input type=\"text\" name=\"secondaryradar\" maxlength=\"4\" size=\"30\"><br />\n";
  echo _WH_USERRADAR."&nbsp;<input type=\"text\" name=\"userradar\"  maxlength=\"255\" size=\"30\"><br />\n";
		
  echo "</td></tr><tr><td align=\"center\"><input type=\"submit\" value=\""._INSERT_DB."\"></form>\n";	
  echo "</td></tr></table></td></tr></table>\n";       
    
  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnInsertWHStation( $list )                                        */
/* function will insert the record contained in the $list array into table    */
/******************************************************************************/

function fnInsertWHStation( $list ) {
  global $db, $prefix;
  
  $whstations = new whstations();
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._ADD_RECORD."</th></tr>\n";
  
  echo "<tr><td align=\"left\">\n";
  echo _WH_COUNTRY."&nbsp;".$list['country']."<br />\n";
  echo _WH_REGION."&nbsp;".$list['region']."<br />\n";
  echo _WH_REPSTATION."&nbsp;".$list['repstation']."<br />\n";
  echo _WH_METAR."&nbsp;".$list['code']."<br />\n";
  echo _WH_FIPS."&nbsp;".$list['fips']."<br />\n";
  echo _WH_PRIRADAR."&nbsp;".$list['primaryradar']."<br />\n";
  echo _WH_SECRADAR."&nbsp;".$list['secondaryradar']."<br />\n";
  echo _WH_USERRADAR."&nbsp;".$list['userradar']."<br />\n";
  echo "</td></tr>\n";
  
  if ( $whstations->insertstation( $list ) == true )
  {
    echo "<tr><td>"._WH_DB_RECORD_INSERT_SUCCESS."</td></tr>\n";	
  }
  else
  {
    echo "<tr><td>"._WH_DB_RECORD_INSERT_FAILED."</td></tr>\n";
  }
 
  echo "</table>\n";
  
  fnDBManageMenu();
  
  CloseTable();
  include("footer.php" );
}

/******************************************************************************/
/* the following are functions for managing the *_weathermarine table         */
/******************************************************************************/

/******************************************************************************/
/* function fnWeatherMarine( $func, $which, $ocean="", $region="" )           */
/* $func - add, edit, or delete                                               */
/* $which - 0 = Ocean, 1 = Region                                             */
/* this function will allow you to add, edit, or delete from the weathermarine*/
/* table - WARNING - very dangerous if you don't know what you are doing!!!   */
/******************************************************************************/

function fnWeatherMarine( $func, $which = 0, $ocean = "" ) {
  global $db, $prefix;
  
  include( "header.php" );
  OpenTable();
  
  fnSelectWHMarine( $which, $ocean, $func );

  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnSelectWHMarine( $which, $ocean, $func )                         */
/* function to allow you to select a station to edit.                         */
/******************************************************************************/

function fnSelectWHMarine( $which, $ocean, $func ) {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  switch( $which )
  {
    case 0:
	default:
	  $whmarine->DisplayOceans( $func );
	  break;
	  
	case 1:
	  $whmarine->DisplayRegions( $ocean, $func );
	  break;
  }
}

/******************************************************************************/
/* function fnEditSelectedWHMarine( $id )                                     */
/* this function will allow the admin to edit the selected weather station    */
/******************************************************************************/

function fnEditSelectedWHMarine( $id ) {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  include( "header.php" );
  OpenTable();
  
  if ( ( $list = $whmarine->getselectedid( $id ) ) !== false )
  {
    // build screen form for update
	echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._UPDATE_RECORD.$id."</th></tr>\n"
	    ."<tr><td><table align=\"center\"><tr><td align=\"right\">\n"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminWHDBUpdateMarine\">\n"		
		."<input type=\"hidden\" name=\"id\" value=\"".$id."\">\n"
		."<input type=\"hidden\" name=\"ocean\" value=\"".$list['ocean']."\">\n"
        ."<input type=\"hidden\" name=\"type\" value=\"".$list['type']."\">\n";
		
    echo _WHM_OCEAN."&nbsp;".$list['ocean']."<br />\n";
    echo _WHM_TYPE."&nbsp;".$whmarine->gettypeval( $list['type'] )."<br />\n";
	echo _WHM_REGION."&nbsp;"._REQ_FIELD."<input type=\"text\" name=\"region\" maxlength=\"100\" size=\"30\" value=\"".$list['region']."\"><br />\n";
	echo _WHM_WXZONE."&nbsp;"._REQ_FIELD."<input type=\"text\" name=\"wxzone\" maxlength=\"6\" size=\"30\" value=\"".$list['wxzone']."\"><br />\n";
	echo _WHM_SYNOPSIS."&nbsp;<input type=\"text\" name=\"synopsis\" maxlength=\"6\" size=\"30\" value=\"".$list['synopsis']."\"><br />\n";
	echo _WH_METAR."&nbsp;<input type=\"text\" name=\"code\" maxlength=\"4\" size=\"30\" value=\"".$list['code']."\"><br />\n";
		
	echo "</td></tr><tr><td align=\"center\"><input type=\"submit\" value=\""._UPDATE_DB."\"></form>\n";	
    echo "</td></tr><tr><td align=\"center\">"._REQ_FIELDS_NOTE."</td></tr></table></td></tr></table>\n";
  }
  else
  {
    echo _INV_DATABASE_ID;
  }
    
  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnUpdateSelectedWHMarine( $list )                                 */
/* Function will update the database *_weathermarine with the supplied values */
/******************************************************************************/

function fnUpdateSelectedWHMarine( $list ) {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._UPDATE_RECORD.$list[id]."</th></tr>\n";
  
  echo "<tr><td align=\"left\">\n";
  echo _WHM_OCEAN."&nbsp;".$list['ocean']."<br />\n";
  echo _WHM_TYPE."&nbsp;".$whmarine->gettypeval( $list['type'] )."<br />\n";
  echo _WHM_REGION."&nbsp;".$list['region']."<br />\n";
  echo _WHM_WXZONE."&nbsp;".$list['wxzone']."<br />\n";
  echo _WHM_SYNOPSIS."&nbsp;".$list['synopsis']."<br />\n";
  echo _WH_METAR."&nbsp;".$list['code']."<br />\n";
  echo "</td></tr>\n";

  if ( $whmarine->updatemarine( $list ) == true ) 
  {
    echo "<tr><td>"._WH_DB_RECORD_UPDATE_SUCCESS."</td></tr>\n";	
  }
  else
  {
    echo "<tr><td>"._WH_DB_RECORD_UPDATE_FAILED."</td></tr>\n";
  }
  
  echo "</table>\n";
  
  fnDBManageMenu();
  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* function fnDelSelectedWHMarine( $id )                                      */
/* print out the database record and verify with admin to delete from table   */
/******************************************************************************/

function fnDelSelectedWHMarine( $id ) {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  include( "header.php" );
  OpenTable();
  
  $list = $whmarine->getselectedid( $id );
  
  if ( $list !== false )
  {
    echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._VERIFY_DEL."&nbsp;".$list[id]."</th></tr>\n"
	    ."<tr><td align=\"center\">\n";
    echo _WHM_OCEAN."&nbsp;<u>".$list['ocean']."</u><br />\n";
    echo _WHM_TYPE."&nbsp;<u>".$whmarine->gettypeval( $list['type'] )."</u><br />\n";
	echo _WHM_REGION."&nbsp;<u>".$list['region']."</u><br />\n";
	echo _WHM_WXZONE."&nbsp;<u>".$list['wxzone']."</u><br />\n";
	echo _WHM_SYNOPSIS."&nbsp;<u>".$list['synopsis']."</u><br />\n";
	echo _WH_METAR."&nbsp;<u>".$list['code']."</u><br />\n";
	echo "</td></tr><tr><td align=\"center\">\n"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminWHDBDeleteMarine\">\n"
		."<input type=\"hidden\" name=\"id\" value=\"".$id."\">\n"
        ."<input type=\"submit\" value=\""._DELETE_RECORD."\"></form>\n";
	echo "</td></tr></table>\n";
  }
  
  CloseTable();
  include("footer.php" );
}

/******************************************************************************/
/* function fnDeleteWHMarine( $id )                                           */
/* function will perform the actual delete of the record.                     */
/******************************************************************************/

function fnDeleteWHMarine( $id ) {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._DELETE_RECORD.$id."</th></tr>\n";
  
  if ( $whmarine->deletemarine( $id ) == true )
  {
    echo "<tr><td>"._WH_DB_RECORD_DELETE_SUCCESS."</td></tr>\n";	
  }
  else
  {
    echo "<tr><td>"._WH_DB_RECORD_DELETE_FAILED."</td></tr>\n";
  }
  
  echo "</table>\n";
  
  fnDBManageMenu();
  CloseTable();
  include("footer.php" );
}

/******************************************************************************/
/* function fnAddWHMarine()                                                   */
/* Presents admin with a form to add a new record to the table                */
/******************************************************************************/

function fnAddWHMarine() {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  include( "header.php" );
  OpenTable();
  
    // build screen form for update
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._ADD_RECORD."</th></tr>\n"
	    ."<tr><td><table align=\"center\"><tr><td align=\"right\">\n"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminWHDBInsertMarine\">\n";

  echo _REQ_FIELD._WHM_OCEAN."<br />";
  
  $whmarine->DisplayOceanList();
  echo "<br />"._WHM_OCEAN_SEL_INST."<br /><input type=\"text\" name=\"altocean\" maxlength=\"25\" size=\"30\"><br />\n"; 
  echo _REQ_FIELD._WHM_TYPE."<br />";
  $whmarine->DisplayMarineType();
  echo "<br />"._WHM_REGION."&nbsp;"._REQ_FIELD."<input type=\"text\" name=\"region\" maxlength=\"100\" size=\"30\"><br />\n";
  echo _WHM_WXZONE."&nbsp;"._REQ_FIELD."<input type=\"text\" name=\"wxzone\" maxlength=\"6\" size=\"30\"><br />\n";
  echo _WHM_SYNOPSIS."&nbsp;<input type=\"text\" name=\"synopsis\" maxlength=\"6\" size=\"30\"><br />\n";
  echo _WH_METAR."&nbsp;<input type=\"text\" name=\"code\" maxlength=\"4\" size=\"30\"><br />\n";
		
  echo "</td></tr><tr><td align=\"center\"><input type=\"submit\" value=\""._INSERT_DB."\"></form>\n";	
  echo "</td></tr><tr><td align=\"center\">"._REQ_FIELDS_NOTE."</table></td></tr></table>\n";       
    
  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function fnInsertWHMarine( $list )                                         */
/* function will insert the record contained in the $list array into table    */
/******************************************************************************/

function fnInsertWHMarine( $list ) {
  global $db, $prefix;
  
  $whmarine = new whmarine();
  
  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><th>"._WH_DB_ADMIN."&nbsp;"._ADD_RECORD."</th></tr>\n";

  echo "<tr><td align=\"left\">\n";
  echo _WHM_OCEAN."&nbsp;".$list['ocean']."<br />\n";
  echo _WHM_TYPE."&nbsp;".$whmarine->gettypeval( $list['type'] )."<br />\n";
  echo _WHM_REGION."&nbsp;".$list['region']."<br />\n";
  echo _WHM_WXZONE."&nbsp;".$list['wxzone']."<br />\n";
  echo _WHM_SYNOPSIS."&nbsp;".$list['synopsis']."<br />\n";
  echo _WH_METAR."&nbsp;".$list['code']."<br />\n";
  echo "</td></tr>\n";

  if ( $whmarine->insertmarine( $list ) == true )
  {
    echo "<tr><td>"._WH_DB_RECORD_INSERT_SUCCESS."</td></tr>\n";
  }
  else
  {
    echo "<tr><td>"._WH_DB_RECORD_INSERT_FAILED."</td></tr>\n";
  }

  echo "</table>\n";

  fnDBManageMenu();

  CloseTable();
  include("footer.php" );
}

?>