<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################
if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin('weatherharvest')) { exit; }
$module_name = "WeatherHarvest";
//get_lang($module_name);

require_once( "modules/$module_name/d_config.php");
require_once( "modules/$module_name/wh_ini.php");
require_once( "modules/$module_name/wh_block.php");

function adminSelCountry() {
  global $module_name, $db, $prefix;
  include( "header.php" );

	adminWHMenu();
  OpenTable();
  echo "<table width=\"100%\"><tr><td align=\"center\"><table width=\"100%\"><th align=\"center\">"._WEATHER_HARVEST
      ."</th><tr><td align=\"center\">"._PLS_SEL_COUNTRY."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
      ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
      ."<input type=\"hidden\" name=\"mode\" value=\"adminSelRegion\">\n"
      ."<select name=\"country\" size=\"20\">\n";

  $sql = "select DISTINCT country from ".$prefix."_weatherstations order by country";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );

  foreach( $list as $row )
  {
    $sql = "select * from ".$prefix."_weathercountries where abbrev='".$row['country']."'";
    $result = $db->sql_query( $sql );
    $val = $db->sql_fetchrow( $result );

    echo "<option value=\"".$row['country']."\">".ucwords( $val['name'] )."</option>\n";
  }

  echo "</select><br /><input type=\"submit\" value=\""._SELECT_COUNTRY."\"></form>\n";
  echo "</form></td></tr></table></td></tr></table>\n";  
  CloseTable();

  include( "footer.php" );
}

function adminSelectRegion( $country ) {
  global $db, $prefix;

  $sql = "select * from ".$prefix."_weathercountries where abbrev='".$country."'";
  $result = $db->sql_query( $sql );
  $val = $db->sql_fetchrow( $result );
 
  $sql = "select DISTINCT region from ".$prefix."_weatherstations where country='".$country."'";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );
  $db->sql_freeresult( $result );

  // check to see if region is filled in (could be blank for some countries)
  $fNoRegion = false;
  foreach( $list as $row )
  {
    if ( $row['region'] == "" )
    {
      $fNoRegion = true;
      break;
    }
  }

  include( "header.php" );
  OpenTable();

  if ( $fNoRegion == false )
  {
    echo "<table width=\"100%\"><tr><td align=\"center\"><table width=\"100%\"><th align=\"center\">"._WEATHER_HARVEST."</th>\n"
        ."<tr><td align=\"center\">"._PLS_SEL_ST.ucwords( $val['name'] )."</td></tr>\n"
        ."<tr><td align=\"center\">"._SETUP_SITE_DEF_WH."</td></tr></table></td></tr>\n";
    echo "<tr><td><table align=\"center\">\n"
        ."<tr><td align=\"center\">"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminSelCity\">\n"
        ."<select name=\"state\" size=\"20\">\n";

    $sql = "select DISTINCT region from ".$prefix."_weatherstations where country='".$country."'";
    $result = $db->sql_query($sql);
    $list = $db->sql_fetchrowset( $result );
    $db->sql_freeresult( $result );

    foreach( $list as $row )
    {
      echo "<option value=\"".$row['region']."\">".ucwords( $row['region'] )."</option>\n";
    }

    echo "</select><br /><input type=\"submit\" value=\""._SELECT_REGION."\"></form>\n";
    echo "</form></td></tr></table></td></tr></table>\n";  
  }
  else  // no region, so just display all cities for the country
  {

    echo "<table width=\"100%\"><tr><td align=\"center\"><table width=\"100%\"><th align=\"center\">"._WEATHER_HARVEST."</th>"
        ."<tr><td align=\"center\">"._PLS_SEL_CITY.ucwords( $val['name'] )."</td></tr></table></td></tr>\n";
    echo "<tr><td><table align=\"center\">\n"
        ."<tr><td align=\"center\">"
        ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
        ."<input type=\"hidden\" name=\"mode\" value=\"adminUpdCity\">\n"
        ."<select name=\"code\" size=\"20\">\n";

    $sql = "select repstation, code from ".$prefix."_weatherstations where country='".$country."' order by repstation";
    $result = $db->sql_query($sql);
    $list = $db->sql_fetchrowset( $result );
	
    foreach( $list as $row )
    {
      echo "<option value=\"".$row['code']."\">".ucwords( $row['repstation'] )."</option>\n";
    }

    echo "</select><br /><input type=\"submit\" value=\""._SAVE_CITY."\"></form>\n";
    echo "</form></td></tr></table></td></tr></table>\n";  
  }	
  
  CloseTable();
  include( "footer.php" );
}  

function adminSelectCity( $region ) {
  global $db, $prefix;

  include( "header.php" );
  OpenTable();
  
  echo "<table width=\"100%\"><tr><td align=\"center\"><table width=\"100%\"><th align=\"center\">"._WEATHER_HARVEST."</th>"
      ."<tr><td align=\"center\">"._PLS_SEL_CITY.ucwords( $region )."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
      ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
      ."<input type=\"hidden\" name=\"mode\" value=\"adminUpdCity\">\n"
      ."<select name=\"code\" size=\"20\">\n";

  $sql = "select repstation, code from ".$prefix."_weatherstations where region='".$region."' order by repstation";
  $result = $db->sql_query($sql);
  $list = $db->sql_fetchrowset( $result );

  foreach( $list as $row )
  {
    echo "<option value=\"".$row['code']."\">".ucwords( $row['repstation'] )."</option>\n";
  }

  echo "</select><br /><input type=\"submit\" value=\""._SAVE_CITY."\"></form>\n";
  echo "</form></td></tr></table></td></tr></table>\n";  

  CloseTable();
  include( "footer.php" );
}

function adminSaveDefaultCity( $code ) {
  global $db, $prefix, $module_name, $userinfo;

  include( "header.php" );
  OpenTable();
  
  // validate the user
  if ( can_admin(strtolower($module_name)) ) {
    $uid = $userinfo['user_id'];
	// check to see if user is already in table
	$sql = "select * from ".$prefix."_weatherdefaults where uid='".$uid."'";
	$result = $db->sql_query( $sql );
	if ( $db->sql_numrows($result) == false )  // user does not exist
	{
	  $sql = "INSERT INTO ".$prefix."_weatherdefaults (`uid`, `code`) VALUES ('".$uid."', '".$code."')";
	  $result = $db->sql_query( $sql );
	}
	else // user does exist
	{
	  $sql = "update ".$prefix."_weatherdefaults set code='".$code."' where uid='".$uid."'";
	  $result = $db->sql_query( $sql );
	}
	
	if ( $result )
	{
	  echo $userinfo['username']._SITE_DATA_SAVED;
	  adminWHMenu();
	}
	else
	{
	  echo $userinfo['username']._SITE_DATA_NOT_SAVED;
	}
  }
  else
  {
    echo _INV_ADMIN_DATA;
  }
  
  CloseTable();
  include( "footer.php" );
}

#############################################################################
# function adminSelectBuoy()
# select a default buoy station for the site
#############################################################################

function adminSelectBuoy( )
{
  global $db, $prefix;

  include( "header.php" );
	adminWHMenu();
  OpenTable();
  
  echo "<table width=\"100%\"><tr><td align=\"center\"><table width=\"100%\"><th align=\"center\">"._WEATHER_HARVEST."</th>"
      ."<tr><td align=\"center\">"._PLS_SEL_BUOY."</td></tr></table></td></tr>\n";
  echo "<tr><td><table align=\"center\">\n"
      ."<tr><td align=\"center\">"
      ."<form METHOD=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
      ."<input type=\"hidden\" name=\"mode\" value=\"adminUpdBuoy\">\n"
      ."<select name=\"buoy\" size=\"20\">\n";

  fnBuoyStationOptions();

  echo "</select><br /><input type=\"submit\" value=\""._SAVE_BUOY."\"></form>\n";
  echo "</form></td></tr></table></td></tr></table>\n";  

  CloseTable();
  include( "footer.php" );
}

#####################################################################
# function adminSaveDefatulBuoy( $buoy )
# function will save the default site buoy in the table
#####################################################################

function adminSaveDefaultBuoy( $buoy ) {
  global $db, $prefix, $module_name, $userinfo;

  include( "header.php" );
  OpenTable();

  // validate the user
  if ( can_admin(strtolower($module_name)) ) {
    $uid = $userinfo['user_id'];
	// check to see if user is already in table
	$sql = "select * from ".$prefix."_weatherdefaults where uid='".$uid."'";
	$result = $db->sql_query( $sql );
		if ( $db->sql_numrows($result) == false ) { // user does not exist
	  		$sql = "INSERT INTO ".$prefix."_weatherdefaults (`uid`, `buoy`) VALUES ('".$uid."', '".$buoy."')";
	  		$result = $db->sql_query( $sql );
		} else { // user does exist
			$sql = "update ".$prefix."_weatherdefaults set buoy='".$buoy."' where uid='".$uid."'";
			$result = $db->sql_query( $sql );
		}
	if ( $result ) {
	  echo $userinfo['username']._SITE_DATA_SAVED;
	  adminWHMenu();
	} else {
	  echo $userinfo['username']._SITE_DATA_NOT_SAVED;
	}
  } else {
    echo _INV_ADMIN_DATA;
  }

  CloseTable();
  include( "footer.php" );
}

/******************************************************************************/
/* fucntion adminSaveWHIniData( $list )                                       */
/* this function will save the passed data to the table nuke_weatherini       */
/******************************************************************************/

function adminSaveWHIniData( $list ) {
  global $db, $prefix;

  $wh = new whini();

  include("header.php");
  OpenTable();
  echo "<table align=\"center\"><th align=\"center\">"._ADMIN_WH_INI."</th>\n";
  echo "<tr><td align=\"center\">\n";
  $wh->fnUpdIni( $list );
  echo "</td></tr></table>\n";

  CloseTable();
  include("footer.php");
}

/******************************************************************************/
/* function adminWHIniData()                                                  */
/* Function to allow admin to setup WeatherHarvest initialization parameters, */
/* these will be saved to a database table.                                   */
/******************************************************************************/

function adminWHIniData() {
  global $module_name, $db, $prefix;

  $wh = new whini();

  include_once("header.php");
	adminWHMenu();
  OpenTable();
  echo "<table align=\"center\"><tr><th align=\"center\">"._ADMIN_WH_INI."</th></tr>\n";
  
  echo "<form method=\"POST\" ACTION=\"".adminlink("WeatherHarvest")."\">\n"
      ."<input type=\"hidden\" name=\"mode\" value=\"adminSaveIni\">\n"
      ."<tr><td align=\"right\">\n";

  YesNoForm( $wh->getminiblock(), _MINI_BLOCK, "miniblock" );

  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getuserdefcity(), _USER_CITY, "userdefcity" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getshowbuoy(), _ALLOW_BUOY, "showbuoy" );

  echo "</td></tr><tr><td align=\"right\">\n";
	
  YesNoForm( $wh->getmarineforecast(), _ALLOW_MARINEFORECAST, "marineforecast" );

  echo "</td></tr><tr><td align=\"right\">\n";
	
  YesNoForm( $wh->getshowradar(), _ALLOW_RADAR, "showradar");

  echo "</td></tr><tr><td align=\"right\">\n";
  
  $radarscale = $wh->getradarscale();
  echo _RADAR_SCALE."<input type=\"text\" name=\"radarscale\" value=\"$radarscale\" maxlength=\"3\" size=\"5\">&nbsp;%";
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getradarloops(), _ALLOW_LOOPS, "radarloops" );

  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getextendforecast(), _ALLOW_EF, "extendforecast" );
  
  echo "</td></tr><tr><td align=\"right\">\n";
  
  $ctOne = "";
  $ctTwo = "";
  $ctThr = "";
  $ctFou = "";
  $ctMax = "";
  switch( $wh->getefdaysdisplay() )
  {
    case "1":
      $ctOne = "SELECTED";
      break;

    case "2":
      $ctTwo = "SELECTED";
      break;

    case "3":
      $ctThr = "SELECTED";
      break;

    case "4": 
      $ctFou = "SELECTED";
      break;
	  
	case "5":
	default:
	  $ctMax = "SELECTED";
	  break;  
  }
  
  echo _EF_DAYS_SHOWN."&nbsp;<select name=\"efdaysdisplay\">\n"
      ."<option value=\"1\" ".$ctOne.">"._WH_ONE."</option>\n"
      ."<option value=\"2\" ".$ctTwo.">"._WH_TWO."</option>\n"
      ."<option value=\"3\" ".$ctThr.">"._WH_THREE."</option>\n"
      ."<option value=\"4\" ".$ctFou.">"._WH_FOUR."</option>\n"
	  ."<option value=\"5\" ".$ctMax.">"._WH_ALL."</option>\n"
      ."</select></td></tr><tr><td align=\"right\">\n";
	  
  YesNoForm( $wh->getzippick(), _ZIP_SEARCH, "zippick" );

  echo "</td></tr><tr><td align=\"right\">\n";

  $ctZero = "";
  $ctOne = "";
  $ctTwo = "";
  $ctThr = "";
  $ctFou = "";
  switch( $wh->getcachetimeout_raw() )
  {
    case "0":
	  $ctZero = "SELECTED";
	  break;
	  
    case "1":
    default:
      $ctOne = "SELECTED";
      break;

    case "2":
      $ctTwo = "SELECTED";
      break;

    case "3":
      $ctThr = "SELECTED";
      break;

    case "4": 
      $ctFou = "SELECTED";
      break;
  }
  echo _CACHE_TIMEOUT."&nbsp;<select name=\"cachetimeout\">\n"
      ."<option value=\"0\" ".$ctZero.">"._DISABLE_CACHE."</option>\n"
      ."<option value=\"1\" ".$ctOne.">"._QUARTER_TIME."</option>\n"
      ."<option value=\"2\" ".$ctTwo.">"._HALF_TIME."</option>\n"
      ."<option value=\"3\" ".$ctThr.">"._THREE_QUARTER_TIME."</option>\n"
      ."<option value=\"4\" ".$ctFou.">"._FULL_TIME."</option>\n"
      ."</select></td></tr><tr><td align=\"right\">\n";

  $rcp = $wh->getnukecachepath();
  echo _CACHE_PATH."<br /><input type=\"text\" name=\"nukecachepath\" size=\"35\" value=\"".$rcp."\">\n";
  echo "</td></tr><tr><td align=\"right\">\n";

  $nrp = $wh->getnukeradarpath();
  echo _SHORT_RADAR_PATH."<br /><input type=\"text\" name=\"nukeradarpath\" size=\"35\" value=\"".$nrp."\">\n";
  echo "</td></tr><tr><td align=\"right\">\n";

  $isOne = "";
  $isTwo = "";
  $isThr = "";
  switch( $wh->getimageset() )
  {
    case "1":
    default:
      $isOne = "CHECKED";
      break;

    case "2":
      $isTwo = "CHECKED";
      break;

    case "3":
      $isThr = "CHECKED";
      break;
  }
  echo "<table border=\"1\" align=\"center\"><th>"._SEL_IMAGE_SET."</th>\n"
      ."<tr><td><input type=\"radio\" name=\"imageset\" value=\"1\" ".$isOne." />\n";
  for( $cnt=1; $cnt < 6; $cnt++ )
  {
	echo "<img src=\"modules/$module_name/images/set1/".$cnt.".gif\" />&nbsp;";
  }
  echo "</td></tr>\n";
  echo "<tr><td><input type=\"radio\" name=\"imageset\" value=\"2\" ".$isTwo.">\n";
  for ( $cnt=1; $cnt < 6; $cnt++ )
  {
    echo "<img src=\"modules/$module_name/images/set2/".$cnt.".gif\" />&nbsp;";
  }
  echo "</td></tr>\n";
  echo "<tr><td><input type=\"radio\" name=\"imageset\" value=\"3\" ".$isThr." />\n";
  for ( $cnt=1; $cnt < 6; $cnt++ )
  {
    echo "<img src=\"modules/$module_name/images/set3/".$cnt.".gif\" />&nbsp;";
  }
  echo "</td></tr></table></td></tr><tr><td align=\"center\">\n";
  echo "<input type=\"submit\" value=\""._SAVE_SCREEN."\" />\n";
  echo "</td></tr></form>\n";
  echo "</table>\n";
  CloseTable();
  include("footer.php");
}
?>