<?php
######################################################################
# Weather Magnet
# ============================================
# Copyright (c) 2003 by John Horne seventhseal@ibdeeming.com
# http://ibdeeming.com
# This program is free software. You can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License.
######################################################################

if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin('weatherharvest')) { exit; }
require_once("includes/cmsinit.inc");

$module_name = "WeatherHarvest";
//get_lang($module_name);

require_once( "modules/$module_name/d_config.php");
require_once( "modules/$module_name/wh_ini.php");
require_once( "modules/$module_name/wh_block.php");
/******************************************************************************/
/* function adminBlockLayout()                                                */
/* Function to allow admin to control layout of WeatherHarvest Block          */
/******************************************************************************/

function adminBlockLayout() {
  global $db, $prefix;
  
  $wh = new whblock();
  
  include( "header.php" );
	adminWHMenu();
  OpenTable();
  echo "<table align=\"center\"><tr><th align=\"center\">"._ADMIN_WH_BLOCKLAYOUTMGR."</th></tr>\n"
      ."<tr><td align=\"center\"><b>"._ADMIN_BLOCK_MSG."</b></td></tr>\n";
 
  $selZero = "";
  $selOne = "";
  
  switch( $wh->gettimedisplay() )  // 0 = 12 hour, 1 = 24 hour
  {
    case "0":
      $selZero = "SELECTED";
	  break;
	 
	case "1":
	default:
	  $selOne = "SELECTED";
	  break;
  }
  
  echo "<form method=\"post\" action=\"".adminlink("WeatherHarvest")."\">\n"
      ."<input type=\"hidden\" name=\"mode\" value=\"adminSaveBlockLayout\">\n"
      ."<tr><td align=\"right\">"._TIME_DISPLAY."&nbsp;<select name=\"timedisplay\">\n"
      ."<option value=\"0\" ".$selZero.">"._MIL_TIME."</option>\n"
      ."<option value=\"1\" ".$selOne.">"._STD_TIME."</option>\n"
      ."</select></td></tr><tr><td align=\"right\">\n";

  $datenow = getdate();
  $timeofday = gettimeofday();
  $dst = ( $timeofday['dsttime'] == 0 ? 0 : 1 );
  $nowtimestamp = mktime( $datenow['hours'], $datenow['minutes'], $datenow['seconds'], $datenow['mon'], $datenow['mday'], $datenow['year'], $dst );
  $dateZero = strftime( "%b %d, %Y", $nowtimestamp );  // MMM DD, YYYY 
  $dateOne = strftime( "%d %b, %Y", $nowtimestamp );   // DD MMM, YYYY 
  $dateTwo = strftime( "%Y, %b %d", $nowtimestamp );      // YYYY, MM DD

  $selZero = "";
  $selOne = "";
  $selTwo = "";

  switch( $wh->getdatedisplay() )
  {
    case "0":
    default:
      $selZero = "SELECTED";
      break;

    case "1":
      $selOne = "SELECTED";
      break;

    case "2":
      $selTwo = "SELECTED";
      break;
  }

  echo _DATE_DISPLAY."&nbsp;<select name=\"datedisplay\">\n"
      ."<option value=\"0\" ".$selZero.">".$dateZero."</option>\n"
      ."<option value=\"1\" ".$selOne.">".$dateOne."</option>\n"
      ."<option value=\"2\" ".$selTwo.">".$dateTwo."</option>\n"
      ."</select>\n";
  echo "</td></tr><tr><td align=\"right\">\n";
  
  $selZero = "";
  $selOne = "";

  switch( $wh->getyeardisplay() )
  {
    case "0":
    default:
      $selZero = "SELECTED";
      break;

    case "1":
      $selOne = "SELECTED";
      break;
  }

  $yearZero = strftime( "%Y", $nowtimestamp ); // YYYY
  $yearOne = strftime( "%y", $nowtimestamp ); // YY
  
  echo _YEAR_DISPLAY."&nbsp;<select name=\"yeardisplay\">\n"
      ."<option value=\"0\" ".$selZero.">".$yearZero."</option>\n"
      ."<option value=\"1\" ".$selOne.">".$yearOne."</option>\n"
      ."</select>\n";
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->gettimezone(), _TIMEZONE_DISPLAY, "timezone" );
  
  echo "</td></tr><tr><td align=\"right\">\n";
  
  $selSmall = "";
  $selMedium = "";
  $selLarge = "";
  
  switch( $wh->getfontsize() )
  {
    case "S":
	default:
	  $selSmall = "SELECTED";
	  break;
	  
	case "M":
	  $selMedium = "SELECTED";
	  break;
	  
	case "L":
	  $selLarge = "SELECTED";
	  break;
  }
  
  echo _FONT_SIZE."&nbsp;<select name=\"fontsize\">\n"
      ."<option value=\"S\" ".$selSmall.">"._SMALL."</option>\n"
      ."<option value=\"M\" ".$selMedium.">"._MEDIUM."</option>\n"
	  ."<option value=\"L\" ".$selLarge.">"._LARGE."</option>\n"
      ."</select>\n";
  echo "</td></tr><tr><td align=\"right\">\n";

  $selTop = "";
  $selBottom = "";
  
  if ( $wh->gettimepos() == "T" )
  {
    $selTop = "SELECTED";
  }
  else
  {
    $selBottom = "SELECTED";
  }
  
  echo _TIME_POS."&nbsp;<select name=\"timepos\">\n"
      ."<option value=\"T\" ".$selTop.">"._TOP."</option>\n"
	  ."<option value=\"B\" ".$selBottom.">"._BOTTOM."</option>\n"
	  ."</select>\n";
  echo "</td></tr><tr><td align=\"right\">\n";
  
  YesNoForm( $wh->getshowregion(), _SHOW_REGION, "showregion" );
  
  echo "</td></tr><tr><td align=\"right\">\n";
  
  YesNoForm( $wh->getshowcountry(), _SHOW_COUNTRY, "showcountry" );

  echo "</td></tr><tr><td align=\"right\">\n";
  
  $selNormal = "";
  $selSlim = "";
  
  switch( $wh->getblockwidth() )
  {
    case "0":
	default:
      $selNormal = "SELECTED";
	  break;
	  
	case "1":
	  $selSlim = "SELECTED";
	  break;
  }	
  
  echo _BLOCK_WIDTH."&nbsp;<select name=\"blockwidth\">\n"
      ."<option value=\"0\" ".$selNormal.">"._NORMAL."</option>\n"
	  ."<option value=\"1\" ".$selSlim.">"._NARROW."</option>\n"
	  ."</select>\n";
  echo "</td></tr><tr><td align=\"right\">\n";
  
  $selBoth = "";
  $selStandard = "";
  $selMetric = "";
  
  switch( $wh->getmeasuretype() )
  {
    case "0":
	default:
	  $selBoth = "SELECTED";
	  break;
    
	case "1":
	  $selStandard = "SELECTED";
	  break;
	  
	case "2":
	  $selMetric = "SELECTED";
	  break;
  }
  
  echo _MEASURE_TYPE."&nbsp;<select name=\"measuretype\">\n"
      ."<option value=\"0\" ".$selBoth.">"._BOTH."</option>\n"
	  ."<option value=\"1\" ".$selStandard.">"._STANDARD."</option>\n"
	  ."<option value=\"2\" ".$selMetric.">"._METRIC."</option>\n"
	  ."</select>\n";
  echo "</td></tr><tr><td align=\"center\">\n";
  
  echo "<b>"._DAWNDUSK_DIR."</b>";
  
  $setDawntime = $wh->getdawntime();
  $setDusktime = $wh->getdusktime();
  echo "</td></tr><tr><td align=\"right\">\n";
  echo _DAWN_TIME."<input type=\"text\" name=\"dawntime\" size=\"20\" value=\"".$setDawntime."\">\n";
  echo "</td></tr><tr><td align=\"right\">\n";
  
  echo _DUSK_TIME."<input type=\"text\" name=\"dusktime\" size=\"20\" value=\"".$setDusktime."\">\n";
  echo "</td></tr><tr><td align=\"center\">\n";

  echo "<b>"._BLOCKLINK_DIR."</b>";
  echo "</td></tr><tr><td align=\"right\">\n";
  
  YesNoForm( $wh->getradarlink(), _RADAR_LINK, "radarlink" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getstationlink(), _STATION_LINK, "stationlink" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getsummarylink(), _SUMMARY_LINK, "summarylink" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getwxzonelink(), _WXZONE_LINK, "wxzonelink" );
  
  echo "</td></tr><tr><td align=\"right\">\n";
  
  YesNoForm( $wh->getnowwxzonelink(), _NOWWXZONE_LINK, "wxnowzonelink" );
  
  echo "</td></tr><tr><td align=\"center\">\n";

  echo "<b>"._DIGITAL_WX_IMAGE_LINKS."</b>";
  echo "</td></tr><tr><td align=\"right\">\n";
  
  YesNoForm( $wh->getmaxtemp(), _MAX_TEMP, "maxtemp" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getmintemp(), _MIN_TEMP, "mintemp" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getpop(), _PROB_PRECIP, "pop" );
  
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->gettwind(), _TEMP_WIND, "twind" );
  
  echo "</td></tr><tr><td align=\"right\">\n";
  
  YesNoForm( $wh->gettdew(), _TEMP_DEWPT, "tdew" );
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getwx(), _WEATHER_CONDITION, "wx" );
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getsky(), _SKY_COVER, "sky" );
  echo "</td></tr><tr><td align=\"right\">\n";

  YesNoForm( $wh->getwaveh(), _WAVE_HEIGHT, "waveh" );
  echo "</td></tr><tr><td align=\"center\">\n";

  echo "<input type=\"submit\" value=\""._SAVE_SCREEN."\">\n";
  echo "</td></tr></form>\n";
  echo "</table>\n";
  CloseTable();
  include("footer.php");
}

function adminSaveBlockLayout( $list ) {
  global $db, $prefix;
  
  include("header.php");
  OpenTable();
  
  $wh = new whblock();

  echo "<table align=\"center\"><th align=\"center\">"._ADMIN_WH_BLOCKLAYOUTMGR."</th>\n";
  
  $setDawntime = $list['dawntime'];
  $setDusktime = $list['dusktime'];
  
  if ( $setDawntime < 1 || $setDawntime > $setDusktime || $setDusktime > 2400 )  // failed
  {
    echo "<tr><td align=\"center\">\n";
	echo _INV_BLOCK_ENTRIES;
	echo "</td></tr></table>\n";
  }
  else
  {
    echo "<tr><td align=\"center\">\n";
    $wh->fnUpdBlock( $list );
    echo "</td></tr></table>\n";
  }
  
  CloseTable();
  include("footer.php");
}

?>