<?php
/*************************************************************************
* NukeTreasury - Financial management for PHP-Nuke                       *
* Copyright (c) 2004 by Dave Lawrence AKA Thrash                         *
*                       thrash@fragnastika.com                           *
*                       thrashn8r@hotmail.com                            *
*                                                                        *
* This program is free software; you can redistribute it and/or modify   *
* it under the terms of the GNU General Public License as published by   *
* the Free Software Foundation; either version 2 of the License.         *
*                                                                        *
* $Source: /0cvs/WeatherHarvest/modules/WeatherHarvest/admin/readme.inc,v $
* $Revision: 1.1 $
* $Author: Phoenix $
* $Date: 2007/11/14 13:34:23 $
*                                                                        *
* DragonflyCMS Version by Phoenix at nukebiz.com                         *
*************************************************************************/
if (!defined('CPG_NUKE')) { exit; }
$module_name = basename(dirname(__FILE__));
global $op, $nukeurl, $userinfo;
require_once( "modules/$op/admin/wh_functions.inc" );

include ('header.php');

OpenTable();
	echo adminWHMenu().'<br />
	<span class="genmed"><strong>Read Me</strong></span><br />
	Installation and operational guidelines.<br /><br />';
echo '
<div class="bodyline">
<ol>
<li><a href="'.adminlink('&amp;mode=readme#ModuleSetup').'">WeatherHarvest Module Setup</a></li>
<li><a href="'.adminlink('&amp;mode=readme#OpNotes').'">Operational Notes</a></li>
<li><a href="'.adminlink('&amp;mode=readme#ToDo').'">To Do</a></li>
<li><a href="'.adminlink('&amp;mode=readme#Support').'">Support</a><br /></li>
<li><a href="'.adminlink('&amp;mode=readme#layingback').'">Layingback\'s Radar Hack</a></li>
</ol>
</div>
<br />
<a name="ModuleSetup"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;">Module Setup</div>
<ol>
<li><b>First</b>, you must add the extra database records needed for this module to work.<br />
Visit <a href="'.adminlink('WeatherHarvest&mode=adminWHDBManagement').'" style="text-decoration:underline;"><b>Database Management</b></a>, then click on the link in the <b>INSERT Extra Database Records</b> section.<br /><br /></li>
<li>Then, <b>before</b> activating your block and module, you must set up your defaults in <a href="'.adminlink('WeatherHarvest&mode=adminWHIniData').'" style="text-decoration:underline;"><b>Main Settings</b></a> and <a href="'.adminlink('WeatherHarvest&mode=adminWHBlockLayout').'" style="text-decoration:underline;"><b>Block Layout</b></a>.<br />All paths are based on your Dragonfly root directory. You must have a trailing \'/\' or you\'ll receive errors if they are incorrect.<br />i.e. modules/WeatherHarvest/cache/ - the defaults should work just fine for you.<br /><br /></li>
<li>If you are a power user, you can set up a separate cache path for radar images.<br /><br /></li>
<li>Note: Cache timeout is for cleanup and regeneration of data files. NOAA typically updates every 30 minutes unless a significant event is taking place.<br /><br /></li>
<li>At this point, you should set up your default site city - <a href="'.adminlink('WeatherHarvest&mode=adminWHReportStation').'" style="text-decoration:underline;"><b>Select Weather Station</b></a>.<br /><br /></li>
<li>Once you have successfully saved your initialization data, activate your block(s) and module. You may place the module in your main menu, as it has menu options for users.<br /><br /></li>
<li>You have 3 blocks you can add  through <a href="'.adminlink('blocks').'" style="text-decoration:underline;"><b>Blocks Admin</b></a>.<br />Side blocks called WeatherHarvest and WHBuoyObservation plus a center block called WHExtendFcast_ctr.</li>
<br />
';

echo '</ol></div>
<br />
<a name="OpNotes"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;">Operational Notes</div>
<ol>
<li>This version incorporates Layingback\'s fixes for the revised NOAA radar system (<a href="'.adminlink('&amp;mode=readme#layingback').'">see his notes below</a>).</li>
<li>Further notes will added as necessary.</li>
<br />
</ol></div>
<br />
<a name="ToDo"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;">To Do</div>
<ol>
<li>Code overhaul.</li>
<li>Optimize database queries.</li>
<li>Convert to templated system.</li>
<li>Complete the transition to tableless.</li>
<br />
</ol></div>
<br />
<a name="Support"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;">Support</div>
<ol>
<li>WeatherHarvest Support is <a href="http://nukebiz.com/Forums/viewforum/f=14.html" style="text-decoration:underline;"><b>Available Here</b></a>.</li>
<br />
<br />
AFAIK, all bugs are resolved, so please enjoy!
<br />
</ol>
</div><br />
<a name="layingback"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center; width:180px;">Layingback\'s Radar Hack</div>
<ol>
<b>Layingback wrote:</b><br />
<i>Note this is only of interest to users in USA, due to the extent of the US Govt. NOAA radar system. So don\'t waste your time downloading if you do not need this feature.</i><br />

As part of the hack I have also got the <b>Scale NOAA Radar</b> feature in WeatherHarvest Initialization panel working. (Although if you use it, you may want to suppress the City background display, as the names get hard to read if displayed at anything other than 100%.)<br /><br />

<b>Notes on Implementation</b><br />
Ridge uses multiple background images - called Overlays - to reduce the dynamic content to the radar image alone. This hack downloads all of these on demand, and attempts to cache them semi-permanently in the Weather Harvest cache.  The topo image in particular is fairly large, and may delay initial loads.<br />

The overlays consist of Topo terrain, County borders, Rivers, Highways and Cities. These files are listed in wh_radar.php, and you can suppress them by simply deleting (or commenting out) the undesired images.<br />

Looping Radar displays are still available, they now are at 10 minute intervals from NOAA Ridge, which claims to show the last 20 images, but my hack displays all of them - 30 for my local radar - giving almost a 4 hour view back in time (vs. the 1 hour of the old system).<br />

The Long Range Composite formerly offered by WeatherHarvest is not provided by the newer NOAA Ridge system, and so I removed all references to it.<br /><br />

<b>Cautions</b><br />

It is tricky to align the looping radar images with the backgrounds due to the play buttons, so I had to improvise, and I may be off by +/- a pixel or 2 - in 600.<br /><br />

<b>Scale NOAA Radar</b> works very differently with IE and real browsers. So if keeping the display within a 800 pixel wide screen is important to you, you\'ll need to decide if you want it set to display the correct size in Firefox and be undersized in IE, or OK in IE and a little oversize in Firefox.<br />

Warnings (tornado, winds, flood, etc.) were never supported in old WeatherHarvest, but I have attempted to show the latest warning (only) in Short display as the top background display.  I have no way of adequately testing the Warnings - as the sun is shining today!  (Warnings are not available in long display due a naming collision in NOAA Ridge system.)<br /><br />

<b>Caveat Emptor</b> I made this hack for my own use, and am happy to share it, but you use at your own risk. It should work with your local radar feed, but I have only tested with my local one.

<br />
</ol></div>
';
CloseTable();
?>