<?php
/************************************************************************/
/* Weather Magnet                                                       */
/* ===========================                                          */
/* Copyright (c) 2003 by John Horne                                     */
/* http://ibdeeming.com                                                 */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin('weatherharvest')) { die('Access Denied'); }

global $db, $prefix, $op;

require_once( "modules/$op/admin/wh_admin_ini.php");
require_once( "modules/$op/admin/wh_admin_block.php");
require_once( "modules/$op/admin/wh_db_manage.php" );
require_once( "modules/$op/admin/wh_functions.inc" );

/******************************************************************************/
/* weatherharvest control switch                                              */
/******************************************************************************/

$mode = isset($_POST['mode'])?$_POST['mode']:(isset($_GET['mode'])?$_GET['mode']:'');
switch( $mode )
{
  case "adminWHDBManagement":
	fnSelectWHDB();
	break;

  case "adminWHDBSelection":
	$whdb = isset($_POST['whdb'])?$_POST['whdb']:(isset($_GET['whdb'])?$_GET['whdb']:'');
	  switch( $whdb )
	  {
	    case "stations":
		default:
	      fnWeatherStations( isset($_GET['action']), isset($_POST['which']), isset($_POST['country']), isset($_POST['region']) );
		  break;
        case "marine":
          fnWeatherMarine( $_POST['action'], $_POST['which'], $_POST['ocean'] );
          break;
	  }	  
	break;

  case "adminWHDBEditMarine":
    fnEditSelectedWHMarine( $_POST['id'] );
    break;

  case "adminWHDBEditStation":
    fnEditSelectedWHStation( $_POST['id'] );
    break;

  case "adminWHDBUpdateMarine":
    $list = array( "id" => $id,
                   "type" => $type,
                   "ocean" => $ocean,
                   "region" => $region,
                   "wxzone" => strtolower( $wxzone ),
                   "synopsis" => strtolower( $synopsis ),
                   "code" => strtoupper( $code ) );
    fnUpdateSelectedWHMarine( $list );
    break;

  case 'adminWHDBUpdateStation':
    $list = array( "id" => $id,
	               "country" => $country,
				   "region" => $region,
				   "repstation" => $repstation,
				   "code" => strtoupper( $code ),
				   "fips" => $fips,
				   "primaryradar" => strtolower( $primaryradar ),
				   "secondaryradar" => strtolower( $secondaryradar ),
				   "userradar" => $userradar );
    fnUpdateSelectedWHStation( $list );
	break;

  case 'adminWHDBDelMarine':
    fnDelSelectedWHMarine( $_POST['id'] );
    break;

  case 'adminWHDBDelStation':
    fnDelSelectedWHStation( $_POST['id'] );
	break;

  case 'adminWHDBDeleteMarine':
    fnDeleteWHMarine( $_POST['id'] );
    break;

  case 'adminWHDBDeleteStation':
    fnDeleteWHStation( $_POST['id'] );
	break;

  case 'adminWHDBAddMarine':
    fnAddWHMarine();
    break;

  case 'adminWHDBAddStation':
    fnAddWHStation();
    break;

  case 'adminWHDBInsertMarine':
    if ( $_POST['ocean'] == "" )
    {
      $ocean = $_POST['altocean'];
    }

    $list = array( "type" => $_POST['type'],
                   "ocean" => $_POST['ocean'],
                   "region" => $_POST['region'],
                   "wxzone" => strtolower( $_POST['wxzone'] ),
                   "synopsis" => strtolower( $_POST['synopsis'] ),
                   "code" => strtoupper( $_POST['code'] ) );
    fnInsertWHMarine( $list );
    break;

  case 'adminWHDBInsertStation':
    $list = array( "country" => $_POST['country'],
				   "region" => $_POST['region'],
				   "repstation" => $_POST['repstation'],
				   "code" => strtoupper( $_POST['code'] ),
				   "fips" => $_POST['fips'],
				   "primaryradar" => strtolower( $_POST['primaryradar'] ),
				   "secondaryradar" => strtolower( $_POST['secondaryradar'] ),
				   "userradar" => $_POST['userradar'] );
    fnInsertWHStation( $list );
    break;

  case 'adminSaveBlockLayout':
    $list = array( "timedisplay" => $_POST['timedisplay'],
                   "datedisplay" => $_POST['datedisplay'],
                   "yeardisplay" => $_POST['yeardisplay'],
	               "timezone" => $_POST['timezone'],
	               "timepos" => $_POST['timepos'],
	               "fontsize" => $_POST['fontsize'],
				   "showregion" => $_POST['showregion'],
				   "showcountry" => $_POST['showcountry'],
				   "blockwidth" => $_POST['blockwidth'],
				   "measuretype" => $_POST['measuretype'],
				   "dawntime" => $_POST['dawntime'],
				   "dusktime" => $_POST['dusktime'],
                   "radarlink" => $_POST['radarlink'],
                   "stationlink" => $_POST['stationlink'],
                   "summarylink" => $_POST['summarylink'],
                   "wxzonelink" => $_POST['wxzonelink'],
                   "maxtemp" => $_POST['maxtemp'],
                   "mintemp" => $_POST['mintemp'], 
				   "pop" => $_POST['pop'],
                   "twind" => $_POST['twind'],
                   "tdew" => $_POST['tdew'],
                   "wx" => $_POST['wx'],
                   "sky" => $_POST['sky'],
                   "waveh" => $_POST['waveh'] );
	adminSaveBlockLayout( $list );
    break;

  case 'adminWHBlockLayout':
    adminBlockLayout();
    break;

  case 'adminWHReportStation':
    adminSelCountry();
	break;

  case 'adminSelRegion':
    if ( $_POST['country'] != "" )
	{
      adminSelectRegion( $_POST['country'] );
	}
    break;

  case 'adminSelCity':
    if ( $_POST['state'] != "" )
	{
      adminSelectCity( $_POST['state'] );
	}
	break;

  case 'adminUpdCity':
    if ( $_POST['code'] != "" )
	{
      adminSaveDefaultCity( $_POST['code'] );
	}
	break;

  case 'adminSelBuoy':
    adminSelectBuoy();
    break;

  case 'adminUpdBuoy':
    if ( $_POST['buoy'] != "" )
	{
	  adminSaveDefaultBuoy( $_POST['buoy'] );
	}
    break;

  case 'adminSaveIni':
    $list = array(
		"processtype" => $_POST['processtype'],
		"nukecachepath" => $_POST['nukecachepath'],
		"imageset" => $_POST['imageset'],
		"miniblock" => $_POST['miniblock'],
		"nukeradarpath" => $_POST['nukeradarpath'],
		"radarloops" => $_POST['radarloops'],
		"showradar" => $_POST['showradar'],
		"userdefcity" => $_POST['userdefcity'],
		"zippick" => $_POST['zippick'],
		"cachetimeout" => $_POST['cachetimeout'],
		"showbuoy" => $_POST['showbuoy'],
		"extendforecast" => $_POST['extendforecast'],
		"efdaysdisplay" => $_POST['efdaysdisplay'],
		"marineforecast" => $_POST['marineforecast'],
		"radarscale" => $_POST['radarscale'] );
    adminSaveWHIniData( $list );
    break;

	case 'readme':
		include('modules/'.$op.'/admin/readme.inc');
		break;

	case 'adminWHDBinsert':
		include('modules/'.$op.'/admin/wh_db_records.php');
		break;

  case 'adminWHIniData':
    adminWHIniData();
    break;

  default:
    adminWHIniData();
    break;
}

?>