<?php
if (!defined('CPG_NUKE')) { exit; }

$mod_name = "WeatherHarvest";
get_lang($mod_name);

require_once( "modules/$mod_name/d_config.php" );
require_once( "modules/$mod_name/wh_utils.php" );
require_once( "modules/$mod_name/wh_ini.php" );
require_once( "modules/$mod_name/wh_block.php");
require_once( "modules/$mod_name/wh_radar.php");
require_once( "modules/$mod_name/wh_digifc.php");

global $db, $prefix, $userinfo, $mod_name;

$wh = new whini();
$whblock = new whblock();

//	 These will be in the admin database eventually
$mini_block = $wh->getminiblock(); // true or false
$local_file_path = $wh->getrootcachepath();
$radar_file_path = $wh->getrootradarpath();

/******************************************************************************/
/******************* Do NOT CHANGE THE FOLLOWING VALUE ************************/
$http_server = "http://weather.noaa.gov/cgi-bin/mgetmetar.pl";
$http_post_data = "?cccc=";  // the METAR city code is appended to this
/******************************************************************************/
/******************************************************************************/

// find out what the default for the user or site is
$uid = 1;  // default

// check to see if admin first
if ( can_admin(strtolower($mod_name)) ) {
  $uid = 0;
}

if ( is_user() ) {
    $uid = $userinfo['user_id'];
}

$sql = "SELECT * FROM ".$prefix."_weatherdefaults WHERE uid=".$uid;
$result = $db->sql_query($sql);
if ($result) {
  if ($db->sql_affectedrows() != false ) {
    $row = $db->sql_fetchrow( $result );
    $code = $row['code'];
  } else {
    $sql = "select * from ".$prefix."_weatherdefaults where uid=0";
    $result = $db->sql_query($sql);
    $row = $db->sql_fetchrow( $result );
    $code = $row['code'];
  }
} else { // use the site defualt (uid=0)
  $sql = "select * from ".$prefix."_weatherdefaults where uid=0";
  $result = $db->sql_query($sql);
  $row = $db->sql_fetchrow( $result );
  $code = $row['code'];
}
$db->sql_freeresult( $result );

$sql = "select id, country, region, repstation from ".$prefix."_weatherstations where code='".$code."'";
$result = $db->sql_query( $sql );
$row = $db->sql_fetchrow( $result );
$db->sql_freeresult( $result );

$sql = "select name from ".$prefix."_weathercountries where abbrev='".$row['country']."'";
$result = $db->sql_query($sql);
$c_name = $db->sql_fetchrow( $result );
$db->sql_freeresult( $result);

if ($c_name['name'] != "") {
  $country = $c_name['name'];
} else {
  $country = $row['country'];
}

$id = $row['id'];
$region = $row['region'];
$repstation = $row['repstation'];

$content = "<table><tr><td colspan=\"2\">"._CURRENT_CONDITIONS."</td></tr><tr><td colspan=\"2\">"
          .ucwords( $repstation )."</td></tr>\n";
		  
if ( $mini_block != "YES" ) {
  if ( $whblock->getshowregion() === true && $whblock->getshowcountry() === true ) {
    $content .= "<tr><td><b>"._WH_REGION."</b></td><td><b>"._WH_COUNTRY."</b></td></tr>\n"
               ."<tr><td>".ucwords( $region )."</td><td>".ucwords( $country )."</td></tr>\n";
  } else if ( $whblock->getshowregion() === true ) {
    $content .= "<tr><td><b>"._WH_REGION."</b></td></tr>\n"
	           ."<tr><td>".ucwords( $region )."</td></tr>\n";
  } else if ( $whblock->getshowcountry() === true ) {
    $content .= "<tr><td><b>"._WH_COUNTRY."</b></td></tr>\n"
	           ."<tr><td>".ucwords( $country )."</td></tr>\n";
  }
}

$content .= "</table>\n";

//$remote_file = $remote_file_path.$code.".TXT";
$local_file = $local_file_path.$code.".TXT";

if ( file_exists( $local_file ) ) {
  $filetime = filemtime( $local_file );
  $nowtime = time();

  if ( $nowtime > ($filetime + ( 60 * 30 ) ) ) {
    fnCacheCleanup( $local_file_path );
    fnCacheCleanup( $radar_file_path );
  }
} else {
  fnCacheCleanup( $local_file_path );
  fnCacheCleanup( $radar_file_path );
}

$local_file = fnLatestObsToCache( $http_server.$http_post_data.$code, $local_file );

$return = fnReadFile( $local_file );
if ( $return == "" ) {
  $content .= _WEATHER_NOT_AVAILABLE."<br />";
} else {
  $content .= processMETARFile( $local_file, $mini_block );
}

$content .= "<hr />";

################################################################################
# Show radar thumb
################################################################################

if ($wh->getshowradar() == true ) {
  if ($whblock->getradarlink() == true ) {
    if ( fnCheckRadarEntries( $code ) == true )     {
	  if ( $whblock->gettwind() == true ) {
	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.TWIND)."\">";
//		$content .= fnGetDigitalThumb( $id, TWIND );
		$content .= "<b>"._TEMP_WIND."</b>";
	    $content .= "</a><br />\n";
	  }
	  if ( $whblock->gettdew() == true ) {
  	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.TDEW)."\">";
//		$content .= fnGetDigitalThumb( $id, TDEW );
		$content .= "<b>"._TEMP_DEWPT."</b>";
	    $content .= "</a><br />\n";
	  }
      if ( $whblock->getwx() == true ) {
	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.WX)."\">";
//		$content .= fnGetDigitalThumb( $id, WX );
		$content .= "<b>"._WEATHER_CONDITION."</b>";
	    $content .= "</a><br />\n";
	  }
      if ( $whblock->getsky() == true ) {
	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.SKY)."\">";
//		$content .= fnGetDigitalThumb( $id, SKY );
		$content .= "<b>"._SKY_COVER."</b>";
	    $content .= "</a><br />\n";
	  }	
      if ( $whblock->getmaxtemp() == true ) {
	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.MAXT)."\">";
//		$content .= fnGetDigitalThumb( $id, MAXT );
		$content .= "<b>"._MAX_TEMP."</b>";
	    $content .= "</a><br />\n";
	  }
	  if ( $whblock->getmintemp() == true ) {
	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.MINT)."\">";
//		$content .= fnGetDigitalThumb( $id, MINT );
		$content .= "<b>"._MIN_TEMP."</b>";
	    $content .= "</a><br />\n";
	  }	
	  
	  if ( $whblock->getpop() == true ) {
	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.POP)."\">";
//		$content .= fnGetDigitalThumb( $id, POP );
		$content .= "<b>"._PROB_PRECIP."</b>";
	    $content .= "</a><br />\n";
	  }
	  
	  if ( $whblock->getwaveh() == true ) {
  	    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_DIGITAL.'&amp;id='.$id.'&amp;which='.WAVEH)."\">";
//		$content .= fnGetDigitalThumb( $id, WAVEH );
		$content .= "<b>"._WAVE_HEIGHT."</b>";
	    $content .= "</a><br />\n";
	  }	
	}
    $content .= "<hr />";
  }
}

if ($wh->getshowradar() == true ) {
  if ($whblock->getradarlink() == true ) {
    if ( fnCheckRadarEntries( $code ) == true ) {
      $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_RADAR.'&amp;id='.$id)."\">"._LOCAL_RADAR."</a><br />\n";
    }
  }
}

if ($wh->getuserdefcity() == true) {
  if (is_user()) {
    if ($whblock->getstationlink() == true ) {
      $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._SEL_COUNTRY)."\">"._SEL_REPORTING_STATION."</a><br />\n";
    }
  }
}

if ($whblock->getsummarylink() == true ) {
  $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._WEATHER_SUMMARIES)."\">"._DISPLAY_WEATHER_SUMMARIES."</a><br />\n";
}

if ($wh->getextendforecast() == true && $whblock->getwxzonelink() == true) {
  // check to see if the selected station has extended forecast defined
  if ( fnCheckWXZoneEntry( $code ) == true ) {
    $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_WXZONE.'&amp;id='.$id)."\">"._DISPLAY_WXZONE."</a><br />\n";
    if ( $whblock->getnowwxzonelink() == true ) {
      $content .= "<a href=\"".getlink('WeatherHarvest&amp;op='._DIS_NOWWXZONE.'&amp;id='.$id)."\">"._DISPLAY_NOWWXZONE."</a><br />\n";
    }
  }
}
	$content .= "<hr /><div align=\"center\"><a href=\"javascript:WH_openwindow()\">Weather Harvest</a> &copy;</div>";
	$content .= "<script type=\"text/javascript\">\n";
	$content .= "<!--\n";
	$content .= "function WH_openwindow(){\n";
	$content .= "	window.open (\"index.php?name=WeatherHarvest&file=copyright\",\"Copyright\",\"toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=300\");\n";
	$content .= "}\n";
	$content .= "//-->\n";
	$content .= "</script>\n\n";
?>
