<?php
/***********************************************************************
* This program is free software; you can redistribute it and/or modify *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation; either version 2 of the License.       *
************************************************************************
* $Source: /0cvs/IP_Tracker/modules/IP_Tracker/admin/readme.inc,v $
* $Revision: 1.2 $
* $Author: Phoenix $
* $Date: 2008/06/24 06:52:30 $
*                                                                      *
* DragonflyCMS Version by Phoenix at nukebiz.com                       *
***********************************************************************/
if (!defined('CPG_NUKE')) { exit; }
$module_name = basename(dirname(__FILE__));
global $op, $nukeurl, $userinfo;
include_once ('header.php');
ipt_menu();
OpenTable();
echo '
<div class="bodyline">
<ol>
<li><a href="'.adminlink('&amp;mode=readme#OpNotes').'">Operational Notes</a></li>
<li><a href="'.adminlink('&amp;mode=readme#RegEx').'">Regular Expressions</a></li>
<li><a href="'.adminlink('&amp;mode=readme#ToDo').'">To Do</a></li>
<li><a href="'.adminlink('&amp;mode=readme#Support').'">Support</a></li>
</ol>
</div>
<br />';

echo '
<a id="OpNotes"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;"><b>Operational Notes</b></div>
<ol>
<li>Since you\'re here, I guess you read the README.txt in the distribution, but I\'ll repeat a couple of notes anyway.</li>
<br />
<li style="text-decoration:line-through;">Depending on your web host, exclusions.php may need CHMOD666 but CHMOD644 will work fine on most hosts.</li>
<br />
<li>IF your upgrade to v9.1.4 was successful (you can verify that your exclusions are now in a database table), you can remove the modules/IP_Tracker/exclusions.php file - it is now redundant.</li>
<br />
<li>You may experience excessive load times, even blank pages on large database sizes, so beware of how many records you decide to keep - this is now less of a problem since queries have been optimized.</li>
<br />
<li>BEWARE: changes to viewing permissions will raise your database queries.</li>
<br />
<li>If your database is too large, you can prune through admin, or you can start excluding the big hitting search engines.  You can also choose to exclude regular trusted members. Pruning can now be done by number of older records, Username or IP address.</li>
<br />
<li>The despamming mechanism deletes spam referral records - simply enter the referer address and IPT will delete all records with that referer address, but be very careful in your choice of terms.</li>
<br />
<li>Search engine bots are easily excluded by just excluding them as a user, using their DragonflyCMS "username".</li>
<br />
<li>Consult the regular expression help pop-up, denoted with a ?, or the notes below, if you\'re not sure about how to exclude IPs or host names.</li>
<br />
</ol></div>
<br />';
echo '
<a id="RegEx"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;"><b>Regular Expressions</b></div>
<ol>
<b>IP Exclusions:</b> wildcard characters (*) allowed<br />
Examples:<br />127.0.0.1<br />68.69.+<br />^68.142.+<br />
<br />
<b>Hostname Exclusions:</b> wildcard characters (*) allowed<br />
Examples:<br />swbcs007.sbc.com<br />.+avantgo.com<br />inktomisearch.com<br />
<br />
<b>Username Exclusions</b> be very careful with wildcards.<br />
Examples: add individually as Phred or phudge or Google<br />
<br />
<b>Need regular expression help ?</b><br />
Try http://www.php.net/manual/en/ref.regex.php for starters.<br />
If you want help on regular expressions, here\'s some popular ones.<br />
<b>n?</b> &raquo; Zero or only one single occurrence of character \'n\'<br />
<b>n*</b> &raquo; Zero or more occurrences of character \'n\'<br />
<b>n+</b> &raquo; At least one or more occurrences of character \'n\'<br />
<b>^abc</b> &raquo; String starting with the characters \'abc\'<br />
<b>xyz$</b> &raquo; String ending with the characters \'xyz\'<br />
NOTE: sometimes you really mean + when you write *<br />
NOTE: for IP beginning 68.12 then use \'^68.12\'<br />
NOTE: for IP containing 68.69 then use \'68.69\'<br />
NOTE: for IP beginning 68.69. then use \'^68.69.+\'<br />
<br />
</ol></div>
<br />';

echo '
<a id="ToDo"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;"><b>To Do</b></div>
<ol>
<li style="text-decoration:line-through;">Cache the config data to save a db query.</li>
<li style="text-decoration:line-through;">Improve the exclusions method.</li>
<li>Revamp pagination and sorting on the main page.</li>
<li>Nothing else planned just yet.</li>
<br />
</ol></div>
<br />';
echo '
<a id="Support"></a>
<div class="bodyline">
<div class="blockhead" style="text-align:center;"><b>Support</b></div>
<ol>
<li>IP Tracker Support is <a href="http://nukebiz.com/Forums/viewforum/f=6.html" style="text-decoration:underline;"><b>Available Here</b></a>.</li>
<br />
<br />
Enjoy!
Phoenix
<br />
</ol>
</div>';
CloseTable();
?>