<?php
/*******************************************************************
* IP Tracking Module v3.5 for PHP-Nuke                             *
* Copyright (c) 2003 by Scott Rubin                                *
* http://www.ierealtor.com - phpnuke id: scottr                    *
********************************************************************
* $Source: /0cvs/IP_Tracker/modules/IP_Tracker/iptracking.inc,v $
* $Revision: 1.1 $
* $Author: Phoenix $
* $Date: 2007/09/18 09:00:24 $
*                                                                  *
* DragonflyCMS Version by Phoenix at nukebiz.com                   *
*******************************************************************/
if (!defined('CPG_NUKE')) { exit; }

if (is_active('IP_Tracker')) {
	global $db, $prefix, $userinfo, $iptracker_conf, $ipt_exclude;

if (!Cache :: array_load('iptracker_conf')) {
	$result = $db->sql_query("SELECT * FROM ".$prefix."_iptracking_conf");
	$iptracker_conf = $db->sql_fetchrowset($result);
	Cache :: array_save('iptracker_conf');
}
for ($i = 0; $i < count($iptracker_conf); $i ++) {
	$ipt_conf = $iptracker_conf[$i]; 
}
if (!Cache::array_load('ipt_exclude')) {
	$excludes = $db->sql_query('SELECT * FROM '.$prefix.'_iptracking_exclude', true);
	while ($exclude = $db->sql_fetchrow($excludes, SQL_ASSOC)) {
		$ipt_exclude[$exclude['name']][] = $exclude['value'];
	}
	Cache::array_save('ipt_exclude');
	$db->sql_freeresult($result);
}

	# capture User, IP Address, Host Address, Web Page
	$ipaddr = $userinfo['user_ip'];
	$hostnm = gethostbyaddr($_SERVER['REMOTE_ADDR']);
	$referer = isset($_SERVER['HTTP_REFERER']) ? Fix_Quotes($_SERVER['HTTP_REFERER']) : '';
	$ipcode = isset($_SERVER['REDIRECT_STATUS']) ? intval($_SERVER['REDIRECT_STATUS']) : '';
	$ipuname = (is_user() || is_admin()) ? $userinfo['username'] : ((SEARCHBOT) ? SEARCHBOT : '');

	$exclude_me = false;
	if (!empty($ipt_exclude['hosts'])) {
		$exclude_hosts = implode('|', $ipt_exclude['hosts']);
		$exclude_me = eregi($exclude_hosts, $hostnm) ? true : false;
	}
	if (!empty($ipt_exclude['ips'])) {
		$exclude_ips = implode('|', $ipt_exclude['ips']);
		$exclude_me = eregi($exclude_ips, decode_ip($ipaddr)) ? true : false;
	}
	if (!empty($ipt_exclude['users'])) {
		$exclude_users = implode('|', $ipt_exclude['users']);
		$exclude_me = eregi($exclude_users, $ipuname) ? true : false;
	}
	if ((SEARCHBOT) && $ipt_conf['exclude_bots']) {
		$exclude_me = true;
	}

	if (!$exclude_me) {
		$ipdate = (gmtime() + ($ipt_conf['offset_hours'] * 60 * 60));
		$pg = Fix_Quotes(get_uri());
		if ($ipuname == '') {
			# let the database insert a null into the username column
			$sql = "INSERT INTO ".$prefix."_iptracking 
			(date_time, ip_address, hostname, page, ipcode, referer) 
			VALUES ('$ipdate', '$ipaddr', '$hostnm', '$pg', '$ipcode', '".htmlprepare($referer)."')";
		} else {
			$sql = "INSERT INTO ".$prefix."_iptracking 
			(ipusername, date_time, ip_address, hostname, page, ipcode, referer) 
			VALUES ('$ipuname', '$ipdate', '$ipaddr', '$hostnm', '$pg', '$ipcode', '".htmlprepare($referer)."')";
		}
		$db->sql_query($sql);
		# Delete from the iptracking table based on parameters set in ipsettings.php
		if ($ipt_conf['ipmax'] > 0 && $ipt_conf['ipdel'] > 0 && $ipt_conf['ipmax'] >= $ipt_conf['ipdel']) {
			$numrows = $db->sql_count($prefix.'_iptracking');
			if ($numrows >= $ipt_conf['ipmax']) {
				$db->sql_query("DELETE FROM ".$prefix."_iptracking 
				ORDER BY date_time 
				LIMIT ".$ipt_conf['ipdel']);
				$db->sql_query("OPTIMIZE TABLE ".$prefix."_iptracking");
			}
		}
	}
}