<?php
/*******************************************************************
* IP Tracking Module v3.5 for PHP-Nuke                             *
* Copyright (c) 2003 by Scott Rubin                                *
* http://www.ierealtor.com - phpnuke id: scottr                    *
********************************************************************
* $Source: /0cvs/IP_Tracker/modules/IP_Tracker/index.php,v $
* $Revision: 1.2 $
* $Author: Phoenix $
* $Date: 2008/06/24 06:52:31 $
*                                                                  *
* DragonflyCMS Version by Phoenix at nukebiz.com                   *
*******************************************************************/
if (!defined('CPG_NUKE')) { exit; }
$pagetitle = _IPTRACKING;
global $CPG_SESS, $db, $prefix, $ipt_conf, $bgcolor1, $bgcolor2;
$ThemeSel = $CPG_SESS['theme'];

if (!Cache :: array_load('iptracker_conf')) {
	$result = $db->sql_query("SELECT * FROM ".$prefix."_iptracking_conf");
	$iptracker_conf = $db->sql_fetchrowset($result);
	Cache :: array_save('iptracker_conf');
}
for ($i = 0; $i < count($iptracker_conf); $i ++) {
	$ipt_conf = $iptracker_conf[$i]; 
}

$iptime = formatDateTime((gmtime() + ($ipt_conf['offset_hours'] * 60 * 60)), _DATESTRINGIPT);

$filter = $ipt_conf['show_hits'] == 1 ? 'ipusername IS NOT NULL' : $ipt_conf['show_hits'] == 2 ? 'ipusername IS NULL' : '1=1';

$adminfilter = $ipt_conf['exclude_admin'] && !(can_admin('ip_tracker')) ? 'AND ipcode<>0' : '';

$ipid = isset($_POST['ipid']) ? intval($_POST['ipid']) : (isset($_GET['ipid']) ? intval($_GET['ipid']) : '');
$numip = isset($_GET['numip']) ? intval($_GET['numip']) : $ipt_conf['numip'];

$pagenum = isset($_GET['pagenum']) ? intval($_GET['pagenum']) : 1;
if ($pagenum < 1) { $pagenum = 1; }

if (!isset($_GET['showmodule']) || ereg("All.*Modules", $_GET['showmodule'])) {
	$showmodule = false;
	$modfilter = '';
} else {
	$showmodule = $_GET['showmodule'];
	$modfilter = " AND page LIKE '%$showmodule%'";
}

include ('header.php');
OpenTable();
if (!$ipid) {
	OpenTable();
	$actip = is_active('IP_Tracker') ? _ACTIVATED : _NOTACTIVATED;
	echo '<div style="text-align:center;"><b>'._IPTRACKINGINFO.' - '.$actip.'</b><br />';
	if (can_admin('ip_tracker')) {
		echo '[ <a href="'.adminlink().'">'._IPTADMIN.'</a> ]<br />';
	}
	echo _TODAYIS.": $iptime<br />";
	echo '</div>';
	CloseTable();
	echo '<br />';
	if (isset($_GET['test'])) {
		IPTrack_showIPTest();
	} else {
		IPTrack_showIPStats();
	}
	echo '<br />';
	CloseTable();

	$sql = "SELECT COUNT(DISTINCT ip_address) AS total FROM ".$prefix."_iptracking WHERE $filter $modfilter $adminfilter";
	list($numips) = $db->sql_ufetchrow($sql, SQL_NUM);

	$numhits = $db->sql_count($prefix.'_iptracking', "1=1 $modfilter $adminfilter");

	$numpages = ceil($numips / $numip);
	if ($numpages > 1) {
		echo '<br />';
		OpenTable();
		echo '<div style="text-align:center;">';
		echo $numips.' '._IPADDRESSES." ($numhits "._HITSIPT.", $numpages "._IPTPAGES.", $numip "._PERPAGE.")<br />" ;
		# START Left Arrow
		if ($pagenum > 1) {
			$prevpage = $pagenum - 1 ;
			$leftarrow = 'modules/IP_Tracker/images/left.gif';
			if (!$showmodule) {
				echo "<a href=\"".getlink("&amp;pagenum=$prevpage&amp;orderby=$orderby&amp;orderdir=".$orderdir)."\">";
			} else {
				echo "<a href=\"".getlink("&amp;showmodule=$showmodule&amp;pagenum=$prevpage&amp;orderby=$orderby&amp;orderdir=".$orderdir)."\">";
			}
			echo '<img src="'.$leftarrow.'" style="border:0; padding-right:10px; vertical-align:middle;" alt="" /></a>';
		}
		# END Left Arrow
		# START Page Numbers
		echo '[ ' ;
		for ($i=1; $i < $numpages+1; $i++) {
			if ($i == $pagenum) {
				echo $i;
			} else {
				if (!$showmodule) {
					echo "<a href=\"".getlink("&amp;pagenum=$i&amp;orderby=$orderby&amp;orderdir=".$orderdir)."\">$i</a>";
				} else {
					echo "<a href=\"".getlink("&amp;showmodule=$showmodule&amp;pagenum=$i&amp;orderby=$orderby&amp;orderdir=".$orderdir)."\">$i</a>";
				}
			}
			if ($i < $numpages) { echo ' | '; } else { echo ' ]'; }
		}
		# END Page Numbers
		# START Right Arrow
		if ($pagenum < $numpages) {
			$nextpage = $pagenum + 1 ;
			$rightarrow = 'modules/IP_Tracker/images/right.gif';
			if (!$showmodule) {
				echo "<a href=\"".getlink("&amp;pagenum=$nextpage&amp;orderby=$orderby&amp;orderdir=".$orderdir)."\">";
			} else {
				echo "<a href=\"".getlink("&amp;showmodule=$showmodule&amp;pagenum=$nextpage&amp;orderby=$orderby&amp;orderdir=".$orderdir)."\">";
			}
			echo '<img src="'.$rightarrow.'" style="border:0; padding-left:10px; vertical-align:middle;" alt="" /></a>';
		}
		# END Right Arrow
		echo '</div>';
		CloseTable();
	}
	echo '<div style="text-align:right;">';
	echo '<a href="javascript:void(0);" onclick=\'window.open("'.getlink($module_name.'&amp;file=copyright').'", "Copyright", "toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=300")\'>IP Tracker v9.1.5</a>';
	echo ' &copy;</div>';

} else {
	// IP details paging
	$start = isset($_POST['start']) ? intval($_POST['start']) :(isset($_GET['start']) ? intval($_GET['start']) : 0);
	$sort_order = isset($_POST['order']) ? $_POST['order'] : (isset($_GET['order']) ? $_GET['order'] :'');
	$sort_order = (isset($sort_order) && $sort_order == 'ASC') ? 'ASC' : 'DESC';
	$mode = isset($_POST['mode']) ? $_POST['mode'] : (isset($_GET['mode']) ? $_GET['mode'] : 'date_time');
	switch ($mode) {
		case 'date_time':
			$order_by = "date_time $sort_order LIMIT $start, ".$numip;
			break;
		case 'page':
			$order_by = "page $sort_order LIMIT $start, ".$numip;
			break;
		case 'referer':
			$order_by = "referer $sort_order LIMIT $start, ".$numip;
			break;
	}

	$sql = "SELECT ip_address, ipusername FROM ".$prefix."_iptracking 
	WHERE ipid='$ipid' $adminfilter";
	$result = $db->sql_query($sql);
	list($ip_address, $ipusername) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	$sql = "SELECT * FROM ".$prefix."_iptracking 
	WHERE ip_address='".Fix_Quotes($ip_address)."'";
	$res = $db->sql_query($sql);
	$numurls = $db->sql_numrows($res);

	# default values if none set
	$sql = "SELECT page, ipcode, date_time, referer FROM ".$prefix."_iptracking 
	WHERE ip_address = '".Fix_Quotes($ip_address)."' $adminfilter 
	ORDER BY $order_by ";
	$result = $db->sql_query($sql);
	echo '<div style="text-align:center;"><b>'._PAGEVIEWINFO.($ipusername ? ' - '.$ipusername : ' - '.decode_ip($ip_address)).'<br />';
	# Admin always see info
	$ip_address = decode_ip($ip_address);
	if(!can_admin('ip_tracker') && !(is_user() && $ipt_conf['members_see_iphost'])) {
		echo IPTrack_mask_ip($ip_address);
	} else {
		echo $ip_address;
	}
	if(can_admin('ip_tracker') || !$ipt_conf['hide_host'] || (is_user() && $ipt_conf['members_see_iphost'])) {
		echo ' - '.gethostbyaddr($ip_address);
	}
	echo '</b></div><br />';

	$pagination = ipt_pagination('&amp;ipid='.$ipid.'&amp;mode='.$mode.'&amp;order='.$sort_order, $numurls, $numip, $start). '&nbsp;';
	echo '<form method="post" action="'.getlink().'" style="margin-bottom:0;">
	<table width="100%" cellspacing="2" cellpadding="2" style="background:'.$bgcolor1.'; border:1px solid '.$bgcolor2.';">
	<tr>
	<td align="left"><b>'.sprintf(_IPTPAGEOF, ( floor( $start / $numip ) + 1 ), ceil( $numurls / $numip )).'</b> ('.$numurls.' URLs, '.$numip.' '._PERPAGE.')</td>
	  <td align="right" style="white-space:nowrap;"><span class="genmed">'._IPTSELECTSORT.':&nbsp;'.( can_admin('ip_tracker') && $ipt_conf['show_referer'] ? select_box('mode', $mode, array('date_time'=>_IPTSORTLASTDATE, 'page'=>_IPTSORTPAGEVIEW, 'referer'=>_IPTSORTREFERER)) : select_box('mode', $mode, array('date_time'=>_IPTSORTLASTDATE, 'page'=>_IPTSORTPAGEVIEW)) ).'&nbsp;&nbsp;', _IPTORDER.':&nbsp;'.select_box('order', $sort_order, array('DESC'=>_IPTSORTDESC, 'ASC'=>_IPTSORTASC)).'&nbsp;&nbsp;
		<input type="hidden" name="ipid" value="'.$ipid.'" />
		<input type="hidden" name="start" value="'.$start.'" />
		<input type="submit" name="submit" value="'._IPTSORT.'" class="liteoption" />
	  </span></td>
	</tr>
	<tr>
	<td align="left" colspan="2"><b>'.$pagination.'</b></td>
	</tr>
	</table></form>';

	echo '<table style="background:'.$bgcolor2.'; border:0; margin:auto;" cellspacing="1" cellpadding="3"><tr>';
    echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._PAGEVIEWED.'</td>';
	if (can_admin('ip_tracker')) {
	    echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._IPTCODE.'</td>';
	}
    echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._HITDATE.'</td>';
	if (can_admin('ip_tracker') && $ipt_conf['show_referer']) {
	    echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._IPTREFERER.'</td>';
	}
	echo '</tr>';

    while (list($page, $ipcode, $date_time, $referer) = $db->sql_fetchrow($result)){
		$date_time = formatDateTime($date_time, _DATESTRINGIPT);
		echo '<tr style="background:'.$bgcolor1.';"><td><a href="'.$page.'">'.((strlen($page) > 40) ? substr($page,0,40).'...' : $page).'</a></td>';
		if (can_admin('ip_tracker')) {
			echo '<td>'.$ipcode.'</td>';
		}
		echo '<td>'.$date_time.'</td>';
		if (can_admin('ip_tracker') && $ipt_conf['show_referer']) {
			echo '<td><a href="'.$referer.'">'.((strlen($referer) > 40) ? substr($referer,0,40).'...' : $referer).'</a></td>';
		}
		echo '</tr>';
    }
    $db->sql_freeresult($result);
    echo '</table>';

	$pagination = ipt_pagination('&amp;ipid='.$ipid.'&amp;mode='.$mode.'&amp;order='.$sort_order, $numurls, $numip, $start). '&nbsp;';
	echo '<form method="post" action="'.getlink().'" style="margin-bottom:0;">
	<table width="100%" cellspacing="2" cellpadding="2" style="background:'.$bgcolor1.'; border:1px solid '.$bgcolor2.';">
	<tr>
	<td align="left"><b>'.sprintf(_IPTPAGEOF, ( floor( $start / $numip ) + 1 ), ceil( $numurls / $numip )).'</b> ('.$numurls.' URLs, '.$numip.' '._PERPAGE.')</td>
	  <td align="right" style="white-space:nowrap;"><span class="genmed">'._IPTSELECTSORT.':&nbsp;'.select_box('mode', $mode, array('date_time'=>_IPTSORTLASTDATE, 'page'=>_IPTSORTPAGEVIEW, 'referer'=>_IPTSORTREFERER)).'&nbsp;&nbsp;', _IPTORDER.':&nbsp;'.select_box('order', $sort_order, array('DESC'=>_IPTSORTDESC, 'ASC'=>_IPTSORTASC)).'&nbsp;&nbsp;
		<input type="submit" name="submit" value="'._IPTSORT.'" class="liteoption" />
	  </span></td>
	</tr>
	<tr>
	<td align="left" colspan="2"><b>'.$pagination.'</b></td>
	</tr>
	</table></form>';
	echo '<br /><div style="text-align:center;">'._IPTGOBACK.'</div><br />';
	CloseTable();

}

function IPTrack_showIPStats(){
	global $db, $prefix, $bgcolor1, $bgcolor2, $ThemeSel, $module_name, $mainindex, $filter, $modfilter, $adminfilter;
	global $ipt_conf, $numip;
	global $orderby, $orderdir, $pagenum, $showmodule, $sortshow;
	$orderby = (isset($_GET['orderby']) ? $_GET['orderby'] : '');
	$orderdir = (isset($_GET['orderdir']) ? $_GET['orderdir'] : '');

	// START search IP
	$ipsearch = '<form action="'.getlink('&amp;file=findip').'" method="post" style="margin:0;">';
	$ipsearch .= '<div>';
	$ipsearch .= '<input type="text" name="findip" size="15" />&nbsp;';
	$ipsearch .= '<input type="submit" name="submit" value="Find IP" />';
	$ipsearch .= '</div></form>';

	// START search Username
	$usersearch = '<form action="'.getlink('&amp;file=finduser').'" method="post" style="margin-bottom:0px;">';
	$usersearch .= '<div>';
	$usersearch .= '<input type="text" name="finduser" size="15" />&nbsp;';
	$usersearch .= '<input type="submit" name="submit" value="Find User" />';
	$usersearch .= '</div></form>';

	# START Modules
	$content = '<form action="'.$mainindex.'" method="get" style="margin:0;">';
	$content .= "<p style=\"margin:0;\"><select name=\"module\" onchange=\"top.location.href=this.options[this.selectedIndex].value\">";
	$moduleslist = '';
	$handle = opendir('modules');
	while ($file = readdir($handle)) {
		if ( (!ereg("^[.]",$file)) && !ereg("html$", $file) ) {
			$moduleslist .= "$file ";
		}
	}
	closedir($handle);
	$moduleslist .= '&nbsp;All&nbsp;Modules';
	$moduleslist = explode(' ', $moduleslist);
	sort($moduleslist);
	for ($i=0; $i < sizeof($moduleslist); $i++) {
		if($moduleslist[$i]!='') {
			$content .= '<option value="'.getlink('&amp;showmodule='.$moduleslist[$i]).'" ';
			if($showmodule == $moduleslist[$i]) $content .= ' selected="selected"';
			$content .= '>'.$moduleslist[$i].'</option>';
		}
	}
	$content .= '</select>';
	# Pulldown Menu pop-up help screen
	$content .= '<span class="option">&nbsp;';
	$content .= '<a href="javascript:void(0);" onclick=\'window.open("'.getlink($module_name.'&amp;file=help1').'", "openHelp1", "toolbar=no,location=no,directories=no,status=no,scrollbars=no,resizable=no,copyhistory=no,width=400,height=160")\'><b>?</b></a>';
	$content .= '</span></p></form>';
	# END Modules
	echo '<table width="100%"><tr><td align="left" style="width:30%;">'.$ipsearch.'</td><td align="center" style="width:40%;">'.$content.'</td><td align="right" style="width:30%;">'.$usersearch.'</td></tr></table><br />';

	echo '<table style="background:'.$bgcolor2.'; border:0; margin:auto;" cellspacing="1" cellpadding="3"><tr>';
	# Online?
	if ( (can_admin('ip_tracker') && $ipt_conf['admin_see_online']) || (is_user() && $ipt_conf['members_see_online']) ) {
		echo '<td bgcolor="'.$bgcolor2.'" nowrap="nowrap">'._ONLINE.'?</td>';
	}
	# End Online?
	#START allow sorting by any column
	if ($ipt_conf['updown_arrows']) {
		$asc = '<img src="images/up.gif" style="border:0; vertical-align:middle;" alt="" />';
		$desc = '<img src="images/down.gif" style="border:0; vertical-align:middle;" alt="" />';
		$sep = '';
	} else {
		$asc = 'A';
		$desc = 'D';
		$sep = '/';
	}
	if (!$showmodule) {
		$sortshow = '';
	} else {
		$sortshow = '&amp;showmodule='.$showmodule;
	}
	if ( can_admin('ip_tracker') || (is_user() && $ipt_conf['members_see_users']) ) {
		echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._USER;
		echo ' <a href="'.getlink($sortshow.'&amp;orderby=1&amp;orderdir=asc').'">'.$asc.'</a>'.$sep;
		echo '<a href="'.getlink($sortshow.'&amp;orderby=1&amp;orderdir=desc').'">'.$desc.'</a></td>';
	}
	echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._IPADDRESS;
	echo ' <a href="'.getlink($sortshow.'&amp;orderby=2&amp;orderdir=asc').'">'.$asc.'</a>'.$sep;
	echo '<a href="'.getlink($sortshow.'&amp;orderby=2&amp;orderdir=desc').'">'.$desc.'</a></td>';
	if (can_admin('ip_tracker') || !$ipt_conf['hide_host'] || (is_user() && $ipt_conf['members_see_iphost'])) {
		echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._HOSTNAME;
		echo ' <a href="'.getlink($sortshow.'&amp;orderby=3&amp;orderdir=asc').'">'.$asc.'</a>'.$sep;
		echo '<a href="'.getlink($sortshow.'&amp;orderby=3&amp;orderdir=desc').'">'.$desc.'</a></td>';
	}
	echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._LASTVIEWED;
	echo ' <a href="'.getlink($sortshow.'&amp;orderby=4&amp;orderdir=asc').'">'.$asc.'</a>'.$sep;
	echo '<a href="'.getlink($sortshow.'&amp;orderby=4&amp;orderdir=desc').'">'.$desc.'</a></td>';
	echo '<td style="background:'.$bgcolor2.'; white-space:nowrap;">'._HITSIPT;
	echo ' <a href="'.getlink($sortshow.'&amp;orderby=5&amp;orderdir=asc').'">'.$asc.'</a>'.$sep;
	echo '<a href="'.getlink($sortshow.'&amp;orderby=5&amp;orderdir=desc').'">'.$desc.'</a></td></tr>';
	# default values if none set
	if (!$orderby) { $orderby = '4'; }
	if (!$orderdir) { $orderdir = 'DESC'; }
	#END allow sorting by any column
	$offset = ($pagenum-1) * $numip ;
	# if multiple Users share same IP Address, then you'll see multiple identical IP Addresses when not displaying User, that's ok.
	# now that we can select a module, the number of hits will represent hits to the selected module even though drilling down to display the page views will show all the hits by that IP Address.

	if ( (can_admin('ip_tracker') && $ipt_conf['admin_see_online']) || (is_user() && $ipt_conf['members_see_online']) ) {
		$sql = "SELECT i.ipusername, i.ip_address, i.hostname, MAX(date_time), COUNT(*), MIN(ipid), s.uname FROM ".$prefix."_iptracking AS i 
		LEFT JOIN ".$prefix."_session AS s ON s.uname=i.ipusername 
		WHERE $filter $modfilter $adminfilter 
		GROUP BY 1,2,3 ORDER BY $orderby $orderdir 
		LIMIT $offset, $numip";
		$result = $db->sql_query($sql);
		while (list($ipusername, $ipaddr, $hostnm, $lastview, $hits, $ipid, $ipuseronline) = $db->sql_fetchrow($result)){
			$ipaddr = decode_ip($ipaddr);
			# check if mask IP
			if (!can_admin('ip_tracker') && !(is_user() && $ipt_conf['members_see_iphost'])) {
				$ipaddr = IPTrack_mask_ip($ipaddr);
			}
			echo '<tr style="background:'.$bgcolor1.';">';
			# Online? (admins won't appear since they are not entered in the cms_session table)
			if ((can_admin('ip_tracker') && $ipt_conf['admin_see_online']) || (is_user() && $ipt_conf['members_see_online'])) {
			# check if this user is online
				if ($ipuseronline) {
					echo '<td align="center">'._ONYES.'</td>'; 
				} else {
					echo '<td>&nbsp;</td>'; 
				}
			}
			# check if show users
			if(can_admin('ip_tracker') || (is_user() && $ipt_conf['members_see_users'])) {
				if ($ipusername != '') {
					echo '<td>'.$ipusername.'</td>';
				} else {
					echo '<td>&nbsp;</td>';
				}
			}
			# check if show host
			echo '<td><a href="'.getlink('&amp;ipid='.$ipid).'">'.$ipaddr.'</a></td>';
			if ( can_admin('ip_tracker') || !$ipt_conf['hide_host'] || (is_user() && $ipt_conf['members_see_iphost']) ) {
				echo '<td><a href="http://www.geobytes.com/IpLocator.htm?GetLocation&amp;ipaddress='.$hostnm.'" target="_blank" title="Click for IP info">'.$hostnm.'</a></td>';
			}
			$lastview = formatDateTime($lastview, _DATESTRINGIPT);
			echo '<td>'.$lastview.'</td><td align="center">'.$hits.'</td></tr>';
		}
		$db->sql_freeresult($result);

	} else { // Not showing "Online"
		$sql = "SELECT ipusername, ip_address, hostname, MAX(date_time), COUNT(*), MIN(ipid) FROM ".$prefix."_iptracking 
		WHERE $filter $modfilter $adminfilter 
		GROUP BY 1,2 ORDER BY $orderby $orderdir 
		LIMIT $offset, $numip";
		$result = $db->sql_query($sql);
		while (list($ipusername, $ipaddr, $hostnm, $lastview, $hits, $ipid) = $db->sql_fetchrow($result)){
			$ipaddr = decode_ip($ipaddr);
			# check if mask IP
			if (!can_admin('ip_tracker') && !(is_user() && $ipt_conf['members_see_iphost'])) {
				$ipaddr = IPTrack_mask_ip($ipaddr);
			}
			echo '<tr style="background:'.$bgcolor1.';">';
			# check if show users
			if (can_admin('ip_tracker') || (is_user() && $ipt_conf['members_see_users'])) {
				if ($ipusername != '') {
					echo '<td>'.$ipusername.'</td>';
				} else {
					echo '<td>&nbsp;</td>';
				}
			}
			# check if show host
			echo '<td><a href="'.getlink('&amp;ipid='.$ipid).'">'.$ipaddr.'</a></td>';
			if ( can_admin('ip_tracker') || !$ipt_conf['hide_host'] || (is_user() && $ipt_conf['members_see_iphost']) ) {
				echo '<td><a href="http://www.geobytes.com/IpLocator.htm?GetLocation&amp;ipaddress='.$hostnm.'" target="_blank" title="Click for IP info">'.$hostnm.'</a></td>';
			}
			$lastview = formatDateTime($lastview, _DATESTRINGIPT);
			echo '<td>'.$lastview.'</td><td align="center">'.$hits.'</td>';
			echo '</tr>';
		}
		$db->sql_freeresult($result);
	}
	echo '</table>';
}

function IPTrack_mask_ip($ipaddr) {
# IP Address Masking
    global $ipt_conf;
	$hide_ipseg[1] = $ipt_conf['hide_ipseg1'];
	$hide_ipseg[2] = $ipt_conf['hide_ipseg2'];
	$hide_ipseg[3] = $ipt_conf['hide_ipseg3'];
	$hide_ipseg[4] = $ipt_conf['hide_ipseg4'];
	if (in_array(TRUE, $hide_ipseg)) {
		$ipseg = explode('.', $ipaddr);
		for($lcv = 1; $lcv<=count($ipseg); $lcv++) {
			$seg = $lcv-1;
			# ereg_replace() didn't like $ipseg[$lcv-1] so had to make $seg
			if ($hide_ipseg[$lcv]) {
				$ipseg[$seg] = ereg_replace('[0-9]', $ipt_conf['ipmaskchar'], $ipseg[$seg]);
			}
		}
		$ipaddr = implode('.', $ipseg);
	}
	return $ipaddr;
}

function ipt_pagination($base_url, $num_items, $per_page, $start_item, $add_prevnext_text = TRUE)
{
	$total_pages = ceil($num_items/$per_page);
	if ($total_pages == 1) { return ''; }
	$on_page = floor($start_item / $per_page) + 1;
	$page_string = '';
	if ( $total_pages > 10 ) {
		$init_page_max = ( $total_pages > 3 ) ? 3 : $total_pages;
		for($i = 1; $i < $init_page_max + 1; $i++) {
			$page_string .= ( $i == $on_page ) ? '<b>'.$i.'</b>' : '<a href="'.getlink($base_url.'&amp;start='.( ( $i - 1 ) * $per_page ) ).'">'.$i.'</a>';
			if ( $i <  $init_page_max ) { $page_string .= ', '; }
		}
		if ( $total_pages > 3 ) {
			if ( $on_page > 1  && $on_page < $total_pages ) {
				$page_string .= ( $on_page > 5 ) ? ' ... ' : ', ';
				$init_page_min = ( $on_page > 4 ) ? $on_page : 5;
				$init_page_max = ( $on_page < $total_pages - 4 ) ? $on_page : $total_pages - 4;
				for($i = $init_page_min - 1; $i < $init_page_max + 2; $i++) {
					$page_string .= ($i == $on_page) ? '<b>'.$i.'</b>' : '<a href="'.getlink($base_url.'&amp;start='.( ( $i - 1 ) * $per_page ) ).'">'.$i.'</a>';
					if ( $i <  $init_page_max + 1 ) { $page_string .= ', '; }
				}
				$page_string .= ( $on_page < $total_pages - 4 ) ? ' ... ' : ', ';
			} else {
				$page_string .= ' ... ';
			}
			for($i = $total_pages - 2; $i < $total_pages + 1; $i++) {
				$page_string .= ( $i == $on_page ) ? '<b>'.$i.'</b>'  : '<a href="'.getlink($base_url.'&amp;start='.( ( $i - 1 ) * $per_page ) ).'">'.$i.'</a>';
				if( $i <  $total_pages ) { $page_string .= ", "; }
			}
		}
	} else {
		for($i = 1; $i < $total_pages + 1; $i++) {
			$page_string .= ( $i == $on_page ) ? '<b>'.$i.'</b>' : '<a href="'.getlink($base_url.'&amp;start='.( ( $i - 1 ) * $per_page ) ).'">'.$i.'</a>';
			if ( $i <  $total_pages ) { $page_string .= ', '; }
		}
	}
	if ( $add_prevnext_text ) {
		if ( $on_page > 1 ) {
			$page_string = ' <a href="'.getlink($base_url.'&amp;start='.( ( $on_page - 2 ) * $per_page ) ).'">'._IPTPREVIOUS.'</a>&nbsp;&nbsp;'.$page_string;
		}
		if ( $on_page < $total_pages ) {
			$page_string .= '&nbsp;&nbsp;<a href="'.getlink($base_url.'&amp;start='.( $on_page * $per_page ) ).'">'._IPTNEXT.'</a>';
		}
	}
	$page_string = _IPTGOTOPAGE.': '.$page_string;
	return $page_string;
}
