<?php
/*******************************************************************
* File to install the IP Tracker module                            *
********************************************************************
* $Source: /0cvs/IP_Tracker/modules/IP_Tracker/cpg_inst.php,v $
* $Revision: 1.2 $
* $Author: Phoenix $
* $Date: 2008/06/24 06:52:30 $
*                                                                  *
*******************************************************************/
if (!defined('ADMIN_MOD_INSTALL')) { exit; }

class IP_Tracker {
    var $radmin;
    var $version;
    var $modname;
    var $description;
    var $author;
    var $website;
    var $dbtables;

    function IP_Tracker() {
        $this->radmin = true;
		$this->version = '9.1.6';
        $this->modname = 'IP Tracker';
        $this->description = 'Track your visitor IP and modules visited - ported from IP Tracking v3.5 by Scott Rubin at ierealtor.com.';
        $this->author = 'Phoenix &amp; DJMaze (port)';
        $this->website = 'nukebiz.com';
        $this->dbtables = array('iptracking', 'iptracking_conf');
    }

	function install() {
		global $installer;
		$installer->add_query('CREATE', 'iptracking', '
		ipid int(10) NOT NULL auto_increment,
		ipusername varchar(25) NULL,
		date_time int(10) UNSIGNED NOT NULL DEFAULT '.gmtime().',
		ip_address varbinary(17) NULL,
		hostname varchar(100) NULL,
		page varchar(150) NULL,
		ipcode smallint(6) NOT NULL default 0,
		referer varchar(150) NULL,
		PRIMARY KEY (ipid),
		KEY i1iptracking (ip_address, hostname)', 'iptracking');

		$installer->add_query('CREATE', 'iptracking_conf', '
		id tinyint(1) NOT NULL default 1,
		ipmax int(10) NOT NULL default 100000,
		ipdel int(10) NOT NULL default 1000,
		numip int(10) NOT NULL default 100,
		offset_hours tinyint(2) NOT NULL default 0,
		ipmaskchar varchar(1) NOT NULL default "x",
		hide_ipseg1 tinyint(1) NOT NULL default 0,
		hide_ipseg2 tinyint(1) NOT NULL default 0,
		hide_ipseg3 tinyint(1) NOT NULL default 1,
		hide_ipseg4 tinyint(1) NOT NULL default 1,
		hide_host tinyint(1) NOT NULL default 1,
		members_see_iphost tinyint(1) NOT NULL default 0,
		members_see_users tinyint(1) NOT NULL default 0,
		members_profile tinyint(1) NOT NULL default 0,
		members_see_online tinyint(1) NOT NULL default 0,
		admin_see_online tinyint(1) NOT NULL default 0,
		show_hits tinyint(1) NOT NULL default 0,
		show_referer tinyint(1) NOT NULL default 0,
		show_country tinyint(1) NOT NULL default 0,
		updown_arrows tinyint(1) NOT NULL default 1,
		exclude_admin tinyint(1) NOT NULL default 1,
		exclude_bots tinyint(1) NOT NULL default 0,
		PRIMARY KEY (id)', 'iptracking_conf');

        $installer->add_query('INSERT', 'iptracking_conf', "'1', '100000', '1000', '100', '0', 'x', '0', '0', '1', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0'");

		$installer->add_query('CREATE', 'iptracking_exclude', '
		name VARCHAR(25) NOT NULL,
		value VARCHAR(50) NOT NULL
		', 'iptracking_exclude');

		$installer->add_query('INSERT', 'iptracking_exclude', "'ips', '127.0.0.1'");
		$installer->add_query('INSERT', 'iptracking_exclude', "'ips', '127.0.0.2'");
		$installer->add_query('INSERT', 'iptracking_exclude', "'hosts', 'phried.com'");
		$installer->add_query('INSERT', 'iptracking_exclude', "'hosts', 'wh0tever.com'");
		$installer->add_query('INSERT', 'iptracking_exclude', "'users', 'whatever'");
		$installer->add_query('INSERT', 'iptracking_exclude', "'users', 'Alexa'");

		return true;
	}

	function uninstall() {
		global $installer;
		foreach ($this->dbtables as $table) {
			$installer->add_query('DROP', $table);
		}
	}

	function upgrade($prev_version) {
		global $installer, $db, $prefix;

		if (version_compare($prev_version, '9.0.0.5', '<')) {
			$installer->add_query('CHANGE', 'iptracking', 'date_time date_time int UNSIGNED NOT NULL default '.gmtime());
			$result = $db->sql_query("SELECT ipid, UNIX_TIMESTAMP(date_time) FROM ".$prefix."_iptracking");
			while ($row = $db->sql_fetchrow($result)) {
				$installer->add_query('UPDATE', 'iptracking', "date_time='".Fix_Quotes($row[1])."' WHERE ipid='".$row[0]."'");
			}
			$db->sql_freeresult($result);

			$installer->add_query('ADD', 'iptracking', 'referer VARCHAR(150) NOT NULL');

			$installer->add_query('CREATE', 'iptracking_conf', '
			id tinyint(1) NOT NULL default 1,
			ipmax int(10) NOT NULL default 100000,
			ipdel int(10) NOT NULL default 1000,
			numip int(10) NOT NULL default 50,
			offset_hours tinyint(2) NOT NULL default 0,
			ipmaskchar varchar(1) NOT NULL default "x",
			hide_ipseg1 tinyint(1) NOT NULL default 1,
			hide_ipseg2 tinyint(1) NOT NULL default 1,
			hide_ipseg3 tinyint(1) NOT NULL default 0,
			hide_ipseg4 tinyint(1) NOT NULL default 0,
			hide_host tinyint(1) NOT NULL default 1,
			members_see_iphost tinyint(1) NOT NULL default 0,
			members_see_users tinyint(1) NOT NULL default 0,
			members_profile tinyint(1) NOT NULL default 0,
			members_see_online tinyint(1) NOT NULL default 0,
			admin_see_online tinyint(1) NOT NULL default 0,
			show_hits tinyint(1) NOT NULL default 0,
			show_referer tinyint(1) NOT NULL default 0,
			show_country tinyint(1) NOT NULL default 0,
			updown_arrows tinyint(1) NOT NULL default 1,
			exclude_admin tinyint(1) NOT NULL default 1,
			exclude_bots tinyint(1) NOT NULL default 0,
			PRIMARY KEY (id)', 'iptracking_conf');

	        $installer->add_query('INSERT', 'iptracking_conf', "'1', '100000', '1000', '50', '0', 'x', '1', '1', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0'");
		}

		if (version_compare($prev_version, '9.0.1.0', '<')) {
			$installer->add_query('CHANGE', 'iptracking', 'ip_address ip_address VARBINARY(17) NOT NULL');
			if (!function_exists('inet_pton')) { require('includes/functions/inet.php'); }
			$result = $db->sql_query("SELECT ipid, ip_address FROM ".$prefix."_iptracking");
			while ($row = $db->sql_fetchrow($result)) {
				$installer->add_query('UPDATE', 'iptracking', "ip_address='".$db->escape_binary(inet_pton($row['ip_address']))."' WHERE ipid='".$row['ipid']."'");
			}
			$db->sql_freeresult($result);
		}

		if (version_compare($prev_version, '9.1.4', '<')) {
			$installer->add_query('CREATE', 'iptracking_exclude', '
			name VARCHAR(25) NOT NULL,
			value VARCHAR(50) NOT NULL
			', 'iptracking_exclude');
			include('modules/IP_Tracker/exclusions.php');
			if (!empty($exclude_ips)) {
				foreach ($exclude_ips AS $value) {
					$installer->add_query('INSERT', 'iptracking_exclude', "'ips', '".Fix_Quotes($value)."'");
				}
			}
			if (!empty($exclude_hosts)) {
				foreach ($exclude_hosts AS $value) {
					$installer->add_query('INSERT', 'iptracking_exclude', "'hosts', '".Fix_Quotes($value)."'");
				}
			}
			if (!empty($exclude_users)) {
				foreach ($exclude_users AS $value) {
					$installer->add_query('INSERT', 'iptracking_exclude', "'users', '".Fix_Quotes($value)."'");
				}
			}
		}

		if (version_compare($prev_version, '9.1.6', '<')) {
			$result = $db->sql_query("SELECT ipid, ip_address FROM {$prefix}_iptracking");
			while ($row = $db->sql_fetchrow($result)) {
				$installer->add_query('UPDATE', 'iptracking', "ip_address='".$db->escape_binary(inet_pton(decode_ip($row['ip_address'])))."' WHERE ipid='".$row['ipid']."'");
			}
			$db->sql_freeresult($result);
		}

		return true;
    }

}
