<?php
/***************************************************************************
*	moderators.php
*	copyright CPG DragonflyCMS
*	$Id: moderators.php,v 1.1.2.1 2011/12/13 12:29:27 phoenix Exp $
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version.
***************************************************************************/
if (!defined('CPG_NUKE')) { exit; }
require_once('modules/'.$module_name.'/nukebb.php');

# Start session management
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
# End session management

if (!cache_load_array('category_rows', $module_name)) {
	$category_rows = $db->sql_ufetchrowset('SELECT c.cat_id, c.cat_title, c.cat_order 
	FROM ' . CATEGORIES_TABLE . ' c 
	ORDER BY c.cat_order', SQL_ASSOC);
	cache_save_array('category_rows', $module_name);
}

if( $total_categories = count($category_rows) ) {
	$forum_data = get_forums();
	if (!($total_forums = count($forum_data))) {
		message_die(GENERAL_MESSAGE, $lang['No_forums']);
	}

	$template->assign_vars(array(
		'U_INDEX'		=> getlink(),
		'L_INDEX'		=> _ForumsLANG,
		'L_NO_FORUMS'	=> $lang['No_forums']
		)
	);

	for ($i = 0; $i < $total_categories; $i++) {
		$cat_id = $category_rows[$i]['cat_id'];

		$display_forums = false;
		for($k = 0; $k < $total_forums; $k++) {
			if ( $forum_data[$k]['cat_id'] == $cat_id ) {
				$display_forums = true;
				break;
			}
		}

		if ($display_forums) {
			$template->assign_block_vars('modrows', array(
				'S_IS_CAT'	  => true,
				'CAT_ID'	=> $cat_id,
				'CAT_DESC'	=> $category_rows[$i]['cat_title'],
				'S_NOT_FIRST'	=> ($i == 0) ? false : true,
				'U_VIEWCAT' => getlink('&amp;' . POST_CAT_URL . "=$cat_id")
			));

			for ($j = 0; $j < $total_forums; $j++) {
				if ($forum_data[$j]['cat_id'] == $cat_id) {
					$forum_id = $forum_data[$j]['forum_id'];
					if ($forum_data[$j]['forum_type'] == 2) {
						$forumlink = getlink($forum_data[$j]['forum_link']);
					} else if ($forum_data[$j]['forum_type'] == 3) {
						$forumlink = $forum_data[$j]['forum_link'];
					} else {
						$forumlink = getlink('&amp;file=viewforum&amp;'.POST_FORUM_URL."=$forum_id");
					}
					$subforums = explode(' %% ', $forum_data[$j]['subforums_list']);
					$forum_data[$j]['subforums_list'] = implode('<br />&nbsp;&nbsp;&nbsp;&nbsp;', $subforums);
					$template->assign_block_vars('modrows', array(
						'S_IS_CAT'			=> false,
						'S_IS_LINK'			=> ($forum_data[$j]['forum_type'] >= 2),
						'FORUM_ID'			=> $forum_id,
						'FORUM_NAME'		=> $forum_data[$j]['forum_name'],
						'FORUM_FOLDER_IMG'	=> $forum_data[$j]['folder_image'],
						'FORUM_FOLDER_ALT'	=> $forum_data[$j]['folder_alt'],
						'SUB_FORUMS'		=> ($forum_data[$j]['forum_type'] == 1),
						'SUBFORUMS'			=> $forum_data[$j]['subforums_list'],
						'S_MODERATORS'		=> isset($forum_moderators[$forum_id]) ? implode( ', ', $forum_moderators[$forum_id]) :  $lang['no_moderators'],
						'U_VIEWFORUM'		=> $forumlink
					));
				}
			}
		}
	}
}
else {
	message_die(GENERAL_MESSAGE, $lang['No_forums']);
}

# Display the page
$page_title = $lang['Moderators'];
require_once('includes/phpBB/page_header.php');
$template->set_filenames(array('body' => 'forums/moderators.html'));
require_once('includes/phpBB/page_tail.php');

function get_forums($parent=0, $display_moderators=true) {
	global $db, $lang, $images, $userdata, $module_name, $forum_moderators;
	# Find which forums are visible for this user
	$tmp_forums = $db->sql_ufetchrowset('SELECT forum_id, auth_view FROM '. FORUMS_TABLE, SQL_ASSOC);
	$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $tmp_forums);
	$c = count($tmp_forums);
	$forums = array();
	for ($i=0; $i<$c; ++$i) {
		if ($is_auth_ary[$tmp_forums[$i]['forum_id']]['auth_view']) {
			$forums[] = $tmp_forums[$i]['forum_id'];
		}
	}
	if (0 === count($forums)) { return array(); }
	unset($tmp_forums);
	$forums = implode(',', $forums);

	$sql = 'SELECT *
			FROM '.FORUMS_TABLE.' 
			WHERE forum_id IN ('.$forums.') 
			ORDER BY cat_id, forum_order';
	$result = $db->sql_query($sql);

	# Save a copy of child forums
	$forums = $childs = array();
	while ($row = $db->sql_fetchrow($result, SQL_ASSOC)) {
		if (!$parent && 0 < $row['parent_id']) {
			$childs[$row['parent_id']][] = $row;
		} elseif ($parent && $row['parent_id'] != $parent) {
			$childs[$row['parent_id']][] = $row;
		} else {
			$forums[] = $row;
		}
	}
	$db->sql_freeresult($result);

	# Obtain list of moderators of each forum - first users, then groups
	$forum_moderators = array();
	if ($display_moderators) {
		if (!cache_load_array('forum_moderators', $module_name)) {
			$sql = "SELECT aa.forum_id, u.user_id, u.username
					FROM ".AUTH_ACCESS_TABLE." aa, ".USER_GROUP_TABLE." ug, ".GROUPS_TABLE." g, ".USERS_TABLE." u
					WHERE aa.auth_mod = ".TRUE." AND g.group_single_user = 1
						AND ug.group_id = aa.group_id AND g.group_id = aa.group_id
						AND u.user_id = ug.user_id
					GROUP BY u.user_id, u.username, aa.forum_id
					ORDER BY aa.forum_id, u.user_id";
			$result = $db->sql_query($sql);
			while( $row = $db->sql_fetchrow($result) ) {
				$forum_moderators[$row['forum_id']][] = '<a href="'.getlink('Your_Account&amp;profile='.$row['user_id']).'">'.$row['username'].'</a>';
			}
			$db->sql_freeresult($result);
			$sql = "SELECT aa.forum_id, g.group_id, g.group_name
					FROM ".AUTH_ACCESS_TABLE." aa, ".USER_GROUP_TABLE." ug, ".GROUPS_TABLE." g
					WHERE aa.auth_mod = ".TRUE." AND g.group_single_user = 0
						AND g.group_type <> ".GROUP_HIDDEN."
						AND ug.group_id = aa.group_id AND g.group_id = aa.group_id
					GROUP BY g.group_id, g.group_name, aa.forum_id
					ORDER BY aa.forum_id, g.group_id";
			$result = $db->sql_query($sql);
			while( $row = $db->sql_fetchrow($result) ) {
				$forum_moderators[$row['forum_id']][] = '<a href="'.getlink('Groups&amp;'.POST_GROUPS_URL.'='.$row['group_id']).'">'.$row['group_name'].'</a>';
			}
			$db->sql_freeresult($result);
			cache_save_array('forum_moderators', $module_name);
		}
	}

	$c = count($forums);
	for ($i=0; $i<$c; ++$i) {
		$forum_id = $forums[$i]['forum_id'];
		$forums[$i]['subforums'] = '';
		$forums[$i]['subforums_list'] = '';
		if (!empty($childs[$forum_id])) {
			$forums[$i]['subforums'] = $childs[$forum_id];
			$subforums = array();
			$s = 0;
			foreach ($childs[$forum_id] as $subforum) {
				# get subforums and moderators
				if ($subforum['parent_id'] == $forum_id) {
					if ($subforum['forum_type'] == 2) {
						$subforums[] = '<a href="'.getlink($subforum['forum_link']).'" class="forumlink">'.$subforum['forum_name'].'</a>';
					} elseif ($subforum['forum_type'] == 3) {
						$subforums[] = '<a href="'.$subforum['forum_link'].'" class="forumlink">'.$subforum['forum_name'].'</a>';
					} else {
						$subforums[] = '<a href="'.getlink($module_name.'&amp;file=viewforum&amp;f='.$subforum['forum_id']).'" class="forumlink">'.$subforum['forum_name'].'</a> - '.(isset($forum_moderators[$subforum['forum_id']]) ? implode( ', ', $forum_moderators[$subforum['forum_id']]) : $lang['no_moderators']);
					}
				}
			}
			$forums[$i]['subforums_list'] = implode(' %% ', $subforums);
		}
		$forums[$i]['folder_image'] = $forums[$i]['forum_type'] == 1 ? $images['forum_sub'] : $images['forum'];
		$forums[$i]['folder_alt'] = $forums[$i]['forum_type'] == 1 ? $lang['Subforums'] : $lang['Forum'];
	}
	return $forums;
}

