<?php
/***************************************************************************
*	cloak.php
*	copyright CPG DragonflyCMS
*	adapted from ForumsPro ignore
*	$Id: cloak.php,v 1.1.2.1 2011/12/13 12:29:27 phoenix Exp $
*
*	This program is free software; you can redistribute it and/or modify
*	it under the terms of the GNU General Public License as published by
*	the Free Software Foundation; either version 2 of the License, or
*	(at your option) any later version.
***************************************************************************/
if (!defined('CPG_NUKE')) { exit; }
require_once('modules/'.$module_name.'/nukebb.php');
# Start session management
$userdata = session_pagestart();
init_userprefs($userdata);
# End session management

if (!is_user()) {
	url_redirect(getlink());
}

# Start/Stop cloaking a user
function user_cloak_toggle($user_id) {
	global $db, $prefix, $userinfo, $CPG_SESS, $module_name;

	$post_id = isset($_POST[POST_POST_URL]) ? intval($_POST[POST_POST_URL]) : (isset($_GET[POST_POST_URL]) ? intval($_GET[POST_POST_URL]) : 0);
	$topic_id = isset($_POST[POST_TOPIC_URL]) ? intval($_POST[POST_TOPIC_URL]) : (isset($_GET[POST_TOPIC_URL]) ? intval($_GET[POST_TOPIC_URL]) : 0);
	$forum_id = isset($_POST[POST_FORUM_URL]) ? intval($_POST[POST_FORUM_URL]) : (isset($_GET[POST_FORUM_URL]) ? intval($_GET[POST_FORUM_URL]) : 0);

	# Use the database value in case the session information is out of date
	if ($db->sql_count($prefix.'_bbcloak', 'user_id = '.$userinfo['user_id'].' AND user_cloak = '.$user_id)) {
		$db->sql_query("DELETE FROM {$prefix}_bbcloak 
		WHERE user_id = '$userinfo[user_id]' AND user_cloak = '$user_id'");
	} else {
		$db->sql_query("INSERT INTO {$prefix}_bbcloak 
		(user_id, user_cloak) 
		VALUES 
		('$userinfo[user_id]', '$user_id')");
	}

	unset($CPG_SESS[$module_name]['cloak_user']);

	# Send the user back to where they came from
	if (0 < $post_id) {
		url_redirect(getlink('&amp;file=viewtopic&amp;'.POST_POST_URL.'='.$post_id).'#'.$post_id);
	} elseif (0 < $topic_id) {
		url_redirect(getlink('&amp;file=viewtopic&amp;'.POST_TOPIC_URL.'='.$topic_id));
	} elseif (0 < $forum_id) {
		url_redirect(getlink('&amp;file=viewforum&amp;'.POST_FORUM_URL.'='.$forum_id));
	}
	url_redirect(getlink());
}

# Stop cloaking a user
function user_cloak_stop() {
	global $db, $prefix, $userinfo, $CPG_SESS, $module_name, $lang;

	$user_id_list = isset($_POST['user_id_list']) ? $_POST['user_id_list'] : array();
	if (!is_array($user_id_list) || empty($user_id_list)) {
		cpg_error($lang['Cloaking_none_selected']);
	}

	$user_ids = array();
	foreach ($user_id_list as $user_id) {
		$user_ids[] = intval($user_id);
	}

	if (count($user_ids)) {
		$db->sql_query("DELETE FROM {$prefix}_bbcloak 
		WHERE user_cloak IN ('".implode(', ', $user_ids)."') AND user_id = '$userinfo[user_id]'");
	}

	unset($CPG_SESS[$module_name]['cloak_user']);
	cpg_error($lang['Cloaking_stopped'], _TASK_COMPLETED, getlink('&amp;file=cloak'));
}

# Display the users a user is cloaking
function user_cloak_index() {
	global $db, $prefix, $user_prefix, $template, $userinfo, $board_config, $lang;

	$start = isset($_POST['start']) ? intval($_POST['start']) : (isset($_GET['start']) ? intval($_GET['start']) : 0);
	if (0 > $start) {
		$start = 0;
	}

	# Select the users the user is ignoring
	$users = array();
	$result = $db->sql_query("SELECT c.*, u.username FROM {$prefix}_bbcloak c, {$user_prefix}_users u 
	WHERE c.user_cloak = u.user_id AND c.user_id = '$userinfo[user_id]' 
	LIMIT $start, $board_config[topics_per_page]");
	while ($row = $db->sql_fetchrow($result, SQL_ASSOC)) {
		$users[] = $row;
		$template->assign_block_vars('user_cloak', array(
			'S_USER_CLOAK'	=> $row['user_cloak'],
			'S_USERNAME'	=> $row['username'],
			'U_USER'		=> getlink('Your_Account&amp;profile='.$row['username'])
			)
		);
	}
	$db->sql_freeresult($result);
	$num_users = count($users);

	# If we're beyond the end of the list, then go to home
	if ($start > $num_users) {
		url_redirect(getlink('&amp;file=cloak'));
	}

	$template->assign_vars(array(
	# Add the main template information
		'L_USERNAME'		=> $lang['Username'],
		'L_SELECT'			=> $lang['Select'],
		'L_NO_USERS'		=> $lang['No_user_cloaked'],
		'S_FORM_OPEN_CLOAK'	=> open_form(getlink('&amp;file=cloak&amp;mode=stop'), false, false, 'style="border:0; margin:0; padding:0;"'),
		'S_FORM_CLOSE_CLOAK'=> close_form(),

	# Add the submit button if needed
		'S_CLOAK_STOP'	=> $num_users ? true : false,
		'L_STOP_CLOAK'	=> $lang['Cloaking_stop'],

	# Add the pagination where needed
		'PAGINATION' => $num_users ? generate_pagination('&amp;file=cloak&amp;start=', count($users), $board_config['topics_per_page'], $start, TRUE) : '',
		'PAGE_NUMBER' => $num_users ? sprintf($lang['Page_of'], (floor($start / $board_config['topics_per_page']) + 1), ceil($num_users / $board_config['topics_per_page'])) : '',
		'L_GOTO_PAGE' => $lang['Goto_page'],
		'L_GO' => $lang['Go']
	));

	# Display the page
	$page_title = $lang['Cloak_users'];
	require_once('includes/phpBB/page_header.php');
	$template->set_filenames(array('body' => 'forums/cloak.html'));
	require_once('includes/phpBB/page_tail.php');
}

if (!$board_config['allow_user_cloak']) {
	url_redirect(getlink());
}


# Toggle a cloaked user
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : (isset($_GET['user_id']) ? intval($_GET['user_id']) : 0);
if (0 < $user_id && _ANONYMOUS != $user_id) {
	user_cloak_toggle($user_id);
}

$mode = isset($_POST['mode']) ? $_POST['mode'] : (isset($_GET['mode']) ? $_GET['mode'] : '');
switch ($mode) {
	case 'stop':
		user_cloak_stop();
		break;
	default:
		user_cloak_index();
		break;
}