<?php

/*********************************************
  CPG-NUKE: Advanced Content Management System
  ********************************************
  Copyright (c) 2004 by CPG Dev Team

  Under the GNU General Public License version 2

  Last modification notes:

	$Id: functions_display.php,v 9.5.8.3 2011/12/13 12:29:22 phoenix Exp $

*************************************************************/

if (!defined('IN_PHPBB')) {
	die('Hacking attempt');
}

function display_forums($parent=0, $display_moderators = TRUE) {
	global $db, $board_config, $forum_info, $lang, $images, $userdata, $CPG_SESS, $module_name;

	$tracking_topics = isset($CPG_SESS[$module_name]['track_topics']) ? $CPG_SESS[$module_name]['track_topics'] : array();
	$tracking_forums = isset($CPG_SESS[$module_name]['track_forums']) ? $CPG_SESS[$module_name]['track_forums'] : array();

	# Find which forums are visible for this user
	$tmp_forums = $db->sql_ufetchrowset('SELECT forum_id, auth_view FROM '. FORUMS_TABLE, SQL_ASSOC);
	$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $tmp_forums);
	$c = count($tmp_forums);
	$forums = array();
	for ($i=0; $i<$c; ++$i) {
		if ($is_auth_ary[$tmp_forums[$i]['forum_id']]['auth_view']) {
			$forums[] = $tmp_forums[$i]['forum_id'];
		}
	}
	if (0 === count($forums)) { return array(); }
	unset($tmp_forums);
	$forums = implode(',', $forums);

	# Define appropriate SQL
	$where = (isset($_GET['file']) && $_GET['file'] == 'viewarchive') ? 'AND f.archive_topics > 0' : '';
	switch(SQL_LAYER) {
		case 'oracle':
			$sql = 'SELECT f.*, p.post_time, p.post_username, u.username, u.user_id
					FROM '.FORUMS_TABLE.' f, '.POSTS_TABLE.' p, '.USERS_TABLE.' u
					WHERE p.post_id = f.forum_last_post_id(+)
						AND u.user_id = p.poster_id(+)
					ORDER BY f.cat_id, f.forum_order';
			break;

		default:
			$sql = 'SELECT f.*, p.post_time, p.post_username, u.username, u.user_id
					FROM (( '.FORUMS_TABLE.' f
					LEFT JOIN '.POSTS_TABLE.' p ON p.post_id = f.forum_last_post_id )
					LEFT JOIN '.USERS_TABLE.' u ON u.user_id = p.poster_id )
					WHERE f.forum_id IN ('.$forums.') '.$where.'
					ORDER BY f.cat_id, f.forum_order';
			break;
	}
	$result = $db->sql_query($sql);

	# Save a copy of child forums
	$forums = $childs = array();
	while ($row = $db->sql_fetchrow($result, SQL_ASSOC)) {
		if (!$parent && 0 < $row['parent_id']) {
			$childs[$row['parent_id']][] = $row;
		} elseif ($parent && $row['parent_id'] != $parent) {
			$childs[$row['parent_id']][] = $row;
		} else {
			$forums[] = $row;
		}
/*	# Lanzer speedup
		if ($row['post_time'] > $userdata['user_lastvisit']) {
			$new_topic_data[$row['forum_id']][$row['topic_id']] = $row['post_time'];
		}	*/
	}
	$db->sql_freeresult($result);
	# Obtain a list of topic ids which contain posts made since user last visited
	if (is_user()) {
		$lastvisit = $userdata['user_lastvisit'];
		if ( isset($CPG_SESS[$module_name]['track_all']) ) {
			$lastvisit = $CPG_SESS[$module_name]['track_all'];
		}
		$result = $db->sql_query('SELECT t.forum_id, t.topic_id, p.post_time
				FROM '.TOPICS_TABLE.' t, '.POSTS_TABLE.' p, '.FORUMS_TABLE.' f
				WHERE p.post_id = t.topic_last_post_id
					AND p.post_time > '.$lastvisit.'
					AND t.topic_moved_id = 0
					AND t.forum_id = f.forum_id
					'.$where.'
				ORDER BY p.post_time DESC');
		$new_topic_data = array();
		while ($topic_data = $db->sql_fetchrow($result, SQL_ASSOC)) {
			$forum_id = $topic_data['forum_id'];
			if (empty($new_topic_data[$forum_id])) {
				if (empty($tracking_topics[$topic_data['topic_id']])) {
					$new_topic_data[$forum_id] = true;
					if ($topic_data['parent_id'] != 0 ) {
						$new_topic_data[$topic_data['parent_id']] = true;
					}
				} elseif ($tracking_topics[$topic_data['topic_id']] < $topic_data['post_time']) {
					$new_topic_data[$forum_id] = true;
					if ($topic_data['parent_id'] != 0 ) {
						$new_topic_data[$topic_data['parent_id']] = true;
					}
				}
				if (!empty($tracking_forums[$forum_id])) {
					$new_topic_data[$forum_id] = ($tracking_forums[$forum_id] < $topic_data['post_time']);
				}
			}
		}
		$db->sql_freeresult($result);
	}

	# Obtain list of moderators of each forum
	# First users, then groups ... broken into two queries
	global $forum_moderators;
	$forum_moderators = array();
	if ($display_moderators) {
	if (!cache_load_array('forum_moderators', $module_name)) {
		$sql = "SELECT aa.forum_id, u.user_id, u.username
				FROM ".AUTH_ACCESS_TABLE." aa, ".USER_GROUP_TABLE." ug, ".GROUPS_TABLE." g, ".USERS_TABLE." u
				WHERE aa.auth_mod = ".TRUE." AND g.group_single_user = 1
					AND ug.group_id = aa.group_id AND g.group_id = aa.group_id
					AND u.user_id = ug.user_id
				GROUP BY u.user_id, u.username, aa.forum_id
				ORDER BY aa.forum_id, u.user_id";
		$result = $db->sql_query($sql);
		while( $row = $db->sql_fetchrow($result) ) {
				$forum_moderators[$row['forum_id']][] = '<a href="'.getlink('Your_Account&amp;profile='.$row['user_id']).'">'.$row['username'].'</a>';
		}
		$db->sql_freeresult($result);

		$sql = "SELECT aa.forum_id, g.group_id, g.group_name
				FROM ".AUTH_ACCESS_TABLE." aa, ".USER_GROUP_TABLE." ug, ".GROUPS_TABLE." g
				WHERE aa.auth_mod = ".TRUE." AND g.group_single_user = 0
					AND g.group_type <> ".GROUP_HIDDEN."
					AND ug.group_id = aa.group_id AND g.group_id = aa.group_id
				GROUP BY g.group_id, g.group_name, aa.forum_id
				ORDER BY aa.forum_id, g.group_id";
		$result = $db->sql_query($sql);
		while( $row = $db->sql_fetchrow($result) ) {
				$forum_moderators[$row['forum_id']][] = '<a href="'.getlink('Groups&amp;'.POST_GROUPS_URL.'='.$row['group_id']).'">'.$row['group_name'].'</a>';
		}
		$db->sql_freeresult($result);
		cache_save_array('forum_moderators', $module_name);
	}
	}
	
	$c = count($forums);
	for ($i=0; $i<$c; ++$i) {
		$forum_id = $forums[$i]['forum_id'];
		$forums[$i]['subforums'] = '';
		$forums[$i]['subforums_list'] = '';
		$forums[$i]['subforums_lang'] = '';
		$ftopics = $forums[$i]['forum_topics'];
		$fposts = $forums[$i]['forum_posts'];
		$atopics = $forums[$i]['archive_topics'];
		$aposts = $forums[$i]['archive_posts'];
		if ($forums[$i]['forum_type'] >= 2) {
			$folder_image = $images['forum_link'];
			$folder_alt = 'link';
		} else if ($forums[$i]['forum_status'] == FORUM_LOCKED) {
				$folder_image = $images['forum_locked'];
				$folder_alt = $lang['Forum_locked'];
			} else {
				$unread_topics = false;
				if (is_user()) {
					$unread_topics = !empty($new_topic_data[$forum_id]);
				}
			if (!empty($childs[$forum_id])) {
				$forums[$i]['subforums'] = $childs[$forum_id];
				$subforums = array();
				$s = 0;
				foreach ($childs[$forum_id] as $subforum) {
					$ftopics += $subforum['forum_topics'];
					$fposts += $subforum['forum_posts'];
					$atopics += $subforum['archive_topics'];
					$aposts += $subforum['archive_posts'];
					if (isset($_GET['file']) && $_GET['file'] == 'archives') {
						if ($subforum['parent_id'] == $forum_id && $subforum['archive_topics'] > 0) {
							$subforums[] = '<a href="'.getlink($module_name.'&amp;viewarchive&amp;f='.$subforum['forum_id']).'">'.$subforum['forum_name'].'</a>';
						}
					} else {
					if ($subforum['parent_id'] == $forum_id) {
						if ($subforum['forum_type'] == 2) {
							$subforums[] = '<a href="'.getlink($subforum['forum_link']).'">'.$subforum['forum_name'].'</a>';
						} elseif ($subforum['forum_type'] == 3) {
							$subforums[] = '<a href="'.$subforum['forum_link'].'">'.$subforum['forum_name'].'</a>';
						} else {
							$subforums[] = '<a href="'.getlink($module_name.'&amp;file=viewforum&amp;f='.$subforum['forum_id']).'">'.$subforum['forum_name'].'</a>';
						}
					}
					}
					if ($subforum['post_time'] > $forum_id['post_time'] && $subforum['post_time'] > $forums[$i]['post_time']) {
						$forums[$i]['post_time'] = $subforum['post_time'];
						$forums[$i]['username'] = $subforum['username'];
						$forums[$i]['user_id'] = $subforum['user_id'];
						$forums[$i]['forum_last_post_id'] = $subforum['forum_last_post_id'];
					}
					!empty($new_topic_data[$subforum['forum_id']]) ? $s++ : $s;
				}
				$forums[$i]['subforums_list'] = implode(', ', $subforums);
				$forums[$i]['subforums_lang'] = (count($subforums) == 1) ? $lang['Subforum'] : $lang['Subforums'];
			}
			if ($forums[$i]['forum_type'] == 1) {
				$folder_image = ($unread_topics || $s >0) ? $images['forum_new_sub'] : $images['forum_sub'];
				} else {
					$folder_image = ( $unread_topics ) ? $images['forum_new'] : $images['forum'];
				}
				$folder_alt = ( $unread_topics ) ? $lang['New_posts'] : $lang['No_new_posts'];
			}

		if (isset($forum_moderators[$forum_id])) {
			$l_moderators = ( count($forum_moderators[$forum_id]) === 1 ) ? $lang['Moderator'] : $lang['Moderators'];
			$moderator_list = implode(', ', $forum_moderators[$forum_id]);
		} else {
			$l_moderators = '';
				$moderator_list = '';
			}
		$forums[$i]['post_username'] = ($forums[$i]['post_username']) ? $forums[$i]['post_username'] : $lang['Guest'];
		$forums[$i]['folder_image'] = $folder_image;
		$forums[$i]['folder_alt']	= $folder_alt;
		$forums[$i]['l_moderators']	  = $l_moderators;
		$forums[$i]['moderator_list'] = $moderator_list;
		$forums[$i]['forum_topics'] = $ftopics;
		$forums[$i]['forum_posts'] = $fposts;
		$forums[$i]['archive_topics'] = $atopics;
		$forums[$i]['archive_posts'] = $aposts;
	}
	return $forums;
}

function online_index() {
	global $db, $prefix, $user_prefix, $board_config;
	$now = gmtime() - 300;
	$online_index = '';
	$color1 = $board_config['admin_color'];
	$color2 = $board_config['moderator_color'];
	$color3 = $board_config['member_color'];
	$result1 = $db->sql_query("SELECT COUNT(IF(guest=1,1,NULL)) AS guests, COUNT(IF(guest=3,1,NULL)) AS bots
	FROM {$prefix}_session");
	list($guests, $bots) = $db->sql_fetchrow($result1);
	$db->sql_freeresult($result1);
	$result2 = $db->sql_query("SELECT user_id, username, user_level, user_allow_viewonline 
	FROM {$user_prefix}_users 
	WHERE user_id <> 1 
	AND user_session_time > '$now' 
	ORDER BY username");
	$i = $j = 0;
	while (list($user_id, $username, $user_level, $allow_view) = $db->sql_fetchrow($result2)) {
		$color = ($user_level == ADMIN) ? $color1 : (($user_level == MOD) ? $color2 : $color3);
		$i++;
		$hidden = empty($allow_view) ? $j++ : $j;
		if ($allow_view || is_admin()) {
			$online_index .= '<span class="tiny"><a href="'.getlink('Your_Account&amp;profile='.$user_id).'" title="'.$username.'" style="color:'.$color.';"><b>'.$username.'</b></a>, </span>';
		}
	}
	$db->sql_freeresult($result2);
	$online_index .= '<br />Members '.$i.' (hidden '.$j.'), Guests '.$guests.', Bots '.$bots.'.';
	return $online_index;
}

function online_today() {
	global $db, $user_prefix, $board_config;
	$online_today = '';
	$now = gmtime() - 86400;
	$color1 = $board_config['admin_color'];
	$color2 = $board_config['moderator_color'];
	$color3 = $board_config['member_color'];
	$result = $db->sql_query("SELECT user_id, username, user_level, user_allow_viewonline 
	FROM {$user_prefix}_users 
	WHERE user_id <> 1 
	AND user_session_time > '$now' 
	ORDER BY user_session_time DESC");
	while (list($user_id, $username, $user_level, $allow_view) = $db->sql_fetchrow($result)) {
		$color = ($user_level == ADMIN) ? $color1 : (($user_level == MOD) ? $color2 : $color3);
		if ($allow_view || is_admin()) {
			$online_today .= '<span class="tiny"><a href="'.getlink('Your_Account&amp;profile='.$user_id).'" title="'.$username.'" style="color:'.$color.';">'.$username.'</a>, </span>';
		}
	}
	$db->sql_freeresult($result);
	return $online_today;
}