<?php
/***************************************************************************
*				 archive.php
*				-------------------
*	begin		: Thursday, June 14, 2001
*	copyright		: (C) 2001 The phpBB Group
*	email		: support@phpbb.com
*
*	 Modifications made by CPG Dev Team http://cpgnuke.com
*	 Last modification notes:
*
*	$Id: archive.php,v 1.1.2.1 2011/12/13 12:29:22 phoenix Exp $
*
 *	 This program is free software; you can redistribute it and/or modify
 *	 it under the terms of the GNU General Public License as published by
 *	 the Free Software Foundation; either version 2 of the License, or
 *	 (at your option) any later version.
 *
 ***************************************************************************/

if (!defined('IN_PHPBB')) { exit; }

require_once("includes/phpBB/functions_search.php");

function archive($forum_id, $archive_date, $archive_all = false)
{
	global $db, $lang, $words_removed;

	$archive_all = ($archive_all) ? '' : 'AND t.topic_vote = 0 AND t.topic_type <> ' . POST_ANNOUNCE;
	//
	// Those without polls and announcements ... unless told otherwise!
	//
	$sql = "SELECT t.topic_id FROM ".POSTS_TABLE." p, ".TOPICS_TABLE." t
		WHERE t.forum_id = $forum_id
			$archive_all
			AND ( p.post_id = t.topic_last_post_id OR t.topic_last_post_id = 0 )";
	if ($archive_date != '') {
		$sql .= " AND p.post_time < $archive_date";
	}
	$result = $db->sql_query($sql);

	$sql_topics = '';
	while ($row = $db->sql_fetchrow($result)) {
		$sql_topics .= ( ( $sql_topics != '' ) ? ', ' : '' ) . $row['topic_id'];
	}
	$db->sql_freeresult($result);

	if ($sql_topics != '') {
		$sql = "SELECT post_id FROM ".POSTS_TABLE."
			WHERE forum_id = $forum_id AND topic_id IN ($sql_topics)";
		$result = $db->sql_query($sql);
		$sql_post = '';
		while ($row = $db->sql_fetchrow($result)) {
			$sql_post .= (($sql_post != '') ? ', ' : '') . $row['post_id'];
			$db->sql_query("INSERT INTO ".POSTS_TABLE."_archive 
			(post_id, topic_id, forum_id, poster_id, post_time, poster_ip, post_username, enable_bbcode, enable_html, enable_smilies, enable_sig, post_edit_time, post_edit_count, post_attachment) 
			SELECT post_id, topic_id, forum_id, poster_id, post_time, poster_ip, post_username, enable_bbcode, enable_html, enable_smilies, enable_sig, post_edit_time, post_edit_count, post_attachment 
			FROM ".POSTS_TABLE."
			WHERE post_id='$row[post_id]'");
			$db->sql_query("INSERT INTO ".POSTS_TEXT_TABLE."_archive 
			(post_id, post_subject, post_text) 
			SELECT post_id, post_subject, post_text 
			FROM ".POSTS_TEXT_TABLE."
			WHERE post_id='$row[post_id]'");
		}
		$db->sql_freeresult($result);
		if ($sql_post != '') {
			$db->sql_query("DELETE FROM ".TOPICS_WATCH_TABLE." 
			WHERE topic_id IN ($sql_topics)");

			$db->sql_query("UPDATE ".TOPICS_TABLE." 
			SET topic_archive_flag='1' 
			WHERE topic_id IN ($sql_topics)");
			$archived_topics = $db->sql_affectedrows();

			$db->sql_query("DELETE FROM ".POSTS_TABLE." 
			WHERE post_id IN ($sql_post)");
			$archived_posts = $db->sql_affectedrows();
			$db->sql_query("DELETE FROM ".POSTS_TEXT_TABLE." 
			WHERE post_id IN ($sql_post)");

			$db->sql_query("UPDATE ".FORUMS_TABLE." 
			SET archive_topics = archive_topics + $archived_topics, archive_posts = archive_posts + $archived_posts 
			WHERE forum_id = $forum_id");

			remove_search_post($sql_post);

			return array ('topics' => $archived_topics, 'posts' => $archived_posts, 'words' => $words_removed);
		}
	}
	return array('topics' => 0, 'posts' => 0, 'words' => 0);
}

//
// Function auto_archive(), this function will read the configuration data from
// the auto_archive table and call the archive function with the necessary info.
//
function auto_archive($forum_id = 0)
{
	global $db, $lang;
	$result = $db->sql_query("SELECT * FROM ".ARCHIVE_TABLE." 
	WHERE forum_id = $forum_id");
	if ($row = $db->sql_fetchrow($result)) {
		if ($row['archive_freq'] && $row['archive_days']) {
			$archive_date = gmtime() - ( $row['archive_days'] * 86400 );
			$next_archive = gmtime() + ( $row['archive_freq'] * 86400 );
			archive($forum_id, $archive_date);
			sync('forum', $forum_id);
			$db->sql_query("UPDATE ".FORUMS_TABLE." 
			SET archive_next = $next_archive 
			WHERE forum_id = $forum_id");
		}
	}
	return;
}
