<?php
/********************************************************************
* CPG DragonflyCMS                                                  *
*********************************************************************
* Dragonfly is released under the terms and conditions              *
* of the GNU GPL version 2 or any later version                     *
* Basic forum stats block v9.1.2 by Phoenix at http://nukebiz.com/  *
* Suitable for ForumsPlus                                           *
********************************************************************/
if (!defined('CPG_NUKE')) { exit; }
if (!is_active('Forums')) {
	$content = 'ERROR';
	return trigger_error('Forums module is inactive', E_USER_WARNING);
}

	include_once('includes/phpBB/functions.php');
	global $prefix, $db, $sitename, $board_config;

	Cache::array_load('board_config', 'Forums');

	list($total_posts) = $db->sql_ufetchrow("SELECT SUM(forum_posts) FROM {$prefix}_bbforums", SQL_NUM);
	list($total_topics) = $db->sql_ufetchrow("SELECT SUM(forum_topics) FROM {$prefix}_bbforums", SQL_NUM);
	$archived_topics = $db->sql_count($prefix.'_bbtopics', 'topic_archive_flag = 1');
	$archived_posts = $db->sql_count($prefix.'_bbposts_archive');

	$start_date = create_date($board_config['default_dateformat'], $board_config['board_startdate']);
	$boarddays = ( gmtime() - $board_config['board_startdate'] ) / 86400;
	if ($boarddays > 0) $posts_per_day = sprintf('%.2f', ($total_posts + $archived_posts) / $boarddays);
	if ($boarddays > 0) $topics_per_day = sprintf('%.2f', ($total_topics + $archived_topics) / $boarddays);
	$boarddays = intval($boarddays);

	$content = '<div style="padding:2px;">
    <span class="row1" style="white-space:nowrap; float:left;">Number of Posts:</span>
    <span class="row2" style="float:right;"><b>'.$total_posts.'</b></span><br />
    <span class="row1" style="white-space:nowrap; float:left;">Archived Posts:</span>
    <span class="row2" style="float:right;"><b>'.$archived_posts.'</b></span><br />
    <span class="row1" style="white-space:nowrap; float:left;">Posts per day:</span>
    <span class="row2" style="float:right;"><b>'.$posts_per_day.'</b></span><br />
    <span class="row1" style="white-space:nowrap; float:left;">Number of Topics:</span>
    <span class="row2" style="float:right;"><b>'.$total_topics.'</b></span><br />
    <span class="row1" style="white-space:nowrap; float:left;">Archived Topics:</span>
    <span class="row2" style="float:right;"><b>'.$archived_topics.'</b></span><br />
    <span class="row1" style="white-space:nowrap; float:left;">Topics per day:</span>
    <span class="row2" style="float:right;"><b>'.$topics_per_day.'</b></span><br />
    <span class="row1" style="white-space:nowrap; float:left;">Days Board Open:</span>
    <span class="row2" style="float:right;"><b>'.$boarddays.'</b></span><br />
	</div>';

?>