<?php
/***************************************************************************
 *				  admin_user_forums.php
 *				  -------------------
 *	 begin		  : Saturday, Feb 13, 2001
 *	 copyright		  : (C) 2001 The phpBB Group
 *	 email		  : support@phpbb.com
 *
 *	 $Id: admin_user_forums.php,v 1.1.2.1 2011/12/13 12:29:20 phoenix Exp $
 *
 *	 This program is free software; you can redistribute it and/or modify
 *	 it under the terms of the GNU General Public License as published by
 *	 the Free Software Foundation; either version 2 of the License, or
 *	 (at your option) any later version.
 ***************************************************************************/
if (!defined('ADMIN_PAGES')) { exit; }
if (!($count = $db->sql_count(FORUMS_TABLE))) {
	message_die(GENERAL_MESSAGE, 'You need to create a forum before you can set permissions.');
	return;
}
$params = array('user_id' => POST_USERS_URL, 'group_id' => POST_GROUPS_URL);
while (list($var, $param) = each($params)) {
	if (!empty($_POST[$param]) || !empty($_GET[$param])) {
		$$var = (!empty($_POST[$param])) ? $_POST[$param] : $_GET[$param];
	} else {
		$$var = '';
	}
}

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : intval($user_id);
$group_id = intval($group_id);

# Start Functions
function check_auth($type, $key, $u_access, $is_admin) {
	$auth_user = 0;
	if (count($u_access)) {
		for($j = 0; $j < count($u_access); $j++) {
			$result = 0;
			switch($type) {
				case AUTH_ACL:
					$result = $u_access[$j][$key];
				case AUTH_MOD:
					$result = $result || $u_access[$j]['auth_mod'];
				case AUTH_ADMIN:
					$result = $result || $is_admin;
					break;
			}
			$auth_user = $auth_user || $result;
		}
	} else {
		$auth_user = $is_admin;
	}
	return $auth_user;
}
# End Functions

if (isset($_POST['submit']) && $user_id) {
	$db->sql_query("DELETE FROM ".FORUMS_TABLE."_privileges
	WHERE user_id='$user_id'");
	$forums_list = $_POST['forum_id_list'];
#	print_r($forums_list);
	for($i = 0; $i < count($forums_list); $i++) {
		$forum_id = $forums_list[$i];
		$db->sql_query("INSERT INTO ".FORUMS_TABLE."_privileges 
		(user_id, forum_id) 
		VALUES 
		('$user_id', '$forum_id')");
	}
	url_redirect(adminlink('&amp;do=user_forums&user_id='.$user_id));
}
else if (isset($_POST['username']) || $user_id)
{
	if (isset($_POST['username'])) {
		$this_userdata = getusrdata($_POST['username']);
		if (!is_array($this_userdata)) {
			message_die(GENERAL_MESSAGE, $lang['No_such_user']);
			return;
		}
		$user_id = $this_userdata['user_id'];
	} elseif ($user_id) {
		$this_userdata = getusrdata($user_id);
		if (!is_array($this_userdata)) {
			message_die(GENERAL_MESSAGE, $lang['No_such_user']);
			return;
		}
	}
	if ($this_userdata['user_level'] > 1) {
		message_die(GENERAL_MESSAGE, $_POST['username'].' - '.($this_userdata['user_level'] == 2 ? $lang['Auth_Admin'] :  $lang['Moderator']).'<br />'.$lang['No_cigar']);
		return;
	}

	$tmp_forums = $db->sql_ufetchrowset("SELECT f.forum_id, f.forum_name, f.auth_view, p.user_id as priv 
	FROM ".FORUMS_TABLE." f
	LEFT JOIN ".FORUMS_TABLE."_privileges p ON (p.user_id= '$user_id' AND p.forum_id = f.forum_id) 
	WHERE forum_type < 3 
	ORDER BY forum_order", SQL_ASSOC);
	$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $this_userdata, $tmp_forums);
	$c = count($tmp_forums);
	$forums = array();
	for ($i=0; $i<$c; ++$i) {
		if ($is_auth_ary[$tmp_forums[$i]['forum_id']]['auth_view']) {
			$forums[] = $tmp_forums[$i];
		}
	}
	if (0 === count($forums)) { return array(); }

	$i = 0;
	foreach ($forums as $forum) {
		$row_class = ( !( $i % 2 ) ) ? 'row2' : 'row1';
		$row_color = ( !( $i % 2 ) ) ? $bgcolor2 : $bgcolor1;
		$template->assign_block_vars('forums', array(
			'ROW_COLOR'		=> $row_color,
			'ROW_CLASS'		=> $row_class,
			'FORUM_NAME'	=> $forum['forum_name'],
			'FORUM_ID'		=> $forum['forum_id'],
			'FORUM_PRIV'	=> $forum['priv'] ? 0 : 1,
			'PRIV_CHECK'	=> $forum['priv'] ? ' checked="checked"' : '',
			'U_FORUM_AUTH'	=> '',
			'S_MOD_SELECT'	=> '')
		);
		$i++;
	}

	$sql = "SELECT u.user_id, u.username, u.user_level, g.group_id, g.group_name, g.group_single_user 
	FROM ".USERS_TABLE." u, ".GROUPS_TABLE." g, ".USER_GROUP_TABLE." ug 
	WHERE u.user_id = $user_id AND ug.user_id = u.user_id AND g.group_id = ug.group_id";
	$result = $db->sql_query($sql);
	$ug_info = array();
	while ($row = $db->sql_fetchrow($result)) {
		$ug_info[] = $row;
	}
	$db->sql_freeresult($result);
	$t_username = $ug_info[0]['username'];
	$name = $id = array();
	for ($i = 0; $i < count($ug_info); $i++) {
		if (!$ug_info[$i]['group_single_user']) {
			$name[] = $ug_info[$i]['group_name'];
			$id[] = intval($ug_info[$i]['group_id']);
		}
	}
	if (count($name)) {
		$t_usergroup_list = '';
		for ($i = 0; $i < count($ug_info); $i++) {
			if ($ug_info[$i]['group_single_user']) continue;
			$ug = 'group&amp;' . POST_GROUPS_URL;
			$t_usergroup_list .= (($t_usergroup_list != '') ? ', ' : '').'<a href="'.adminlink('&amp;do=user_forums&amp;mode='.$ug.'='.$id[$i]).'">' . $name[$i] . '</a>';
		}
	} else {
		$t_usergroup_list = $lang['None'];
	}

	$template->set_filenames(array('body' => 'forums/admin/auth_uf_body.html'));

	$s_hidden_fields = '<input type="hidden" name="' . POST_USERS_URL . '" value="' . $user_id . '" />';

	$template->assign_block_vars('switch_user_auth', array());
	$template->assign_vars(array(
		'USERNAME'				=> $t_username,
		'USER_GROUP_MEMBERSHIPS'=> $lang['Group_memberships'] . ' : ' . $t_usergroup_list
	));
	$template->assign_vars(array(
		'L_USER_OR_GROUPNAME'=> $lang['Username'],
		'L_AUTH_TITLE'		=> $lang['User_Forum_Privileges'],
		'L_AUTH_EXPLAIN'	=> $lang['User_forum_explain'],
		'L_MODERATOR_STATUS'=> $lang['Moderator_status'],
		'L_PRIVILEGES'		=> $lang['Privileges'],
		'L_MARK_ALL'		=> $lang['Mark_all'],
		'L_UNMARK_ALL'		=> $lang['Unmark_all'],
		'L_SUBMIT'			=> $lang['Submit'],
		'L_RESET'			=> $lang['Reset'],
		'L_FORUM'			=> $lang['Forum'],
		'L_ANOTHER_USER'	=> $lang['Another_User'],
		'U_USER_FORUMS'		=> adminlink('&amp;do=user_forums'),
		'S_HIDDEN_FIELDS'	=> $s_hidden_fields
	));
} else {
	# Select a user
	$tpl = 'forums/admin/user_select_body.html';
	$template->set_filenames(array('body' => $tpl));
	$template->assign_vars(array(
		'L_FIND_USERNAME'	=> $lang['Find_username'],
		'U_SEARCH_USER'		=> getlink("Forums&amp;file=search&amp;mode=searchuser&amp;popup=1&amp;menu=1", true, true))
	);
	$s_hidden_fields = '';
	$template->assign_vars(array(
		'L_USER_TITLE'		=> $lang['User_Forum_Privileges'],
		'L_USER_EXPLAIN'	=> $lang['User_forum_explain'],
		'L_USER_SELECT'		=> $lang['Select_a_User'],
		'L_LOOK_UP'			=> $lang['Look_up_User'],
		'S_HIDDEN_FIELDS'	=> $s_hidden_fields,
		'S_USER_ACTION'		=> adminlink('&amp;do=user_forums')
	));
}
