<?php
/***************************************************************************
*				  admin_forum_archive.php
*				   -------------------
*	  begin		   : Mon Jul 31, 2001
*	  copyright		   : (C) 2001 The phpBB Group
*	  email		   : support@phpbb.com
****************************************************************************/
/***************************************************************************
 *
 *	 This program is free software; you can redistribute it and/or modify
 *	 it under the terms of the GNU General Public License as published by
 *	 the Free Software Foundation; either version 2 of the License, or
 *	 (at your option) any later version.
 *
 ***************************************************************************/
/* Modifications made by CPG Dev Team http://cpgnuke.com		*/
/* Last modification notes:							*/
/*										*/
/*	 $Id: admin_forum_archive.php,v 1.1.2.1 2011/12/13 12:29:20 phoenix Exp $	*/
/*										*/
/************************************************************************/
if (!defined('ADMIN_PAGES')) { exit; }
require("includes/phpBB/archive.php");
require("includes/phpBB/functions_admin.php");

//
// Get the forum ID for archiving
//
if( isset($_GET[POST_FORUM_URL]) || isset($_POST[POST_FORUM_URL]) ) {
	$forum_id = ( isset($_POST[POST_FORUM_URL]) ) ? $_POST[POST_FORUM_URL] : $_GET[POST_FORUM_URL];
	if( $forum_id == -1 ) {
		$forum_sql = '';
	} else {
		$forum_id = intval($forum_id);
		$forum_sql = "AND forum_id = $forum_id";
	}
} else {
	$forum_id = '';
	$forum_sql = '';
}
//
// Get a list of forum's or the data for the forum that we are pruning.
//
$sql = "SELECT f.*
	FROM " . FORUMS_TABLE . " f, " . CATEGORIES_TABLE . " c
	WHERE c.cat_id = f.cat_id
	$forum_sql
	ORDER BY c.cat_order ASC, f.forum_order ASC";
$result = $db->sql_query($sql);
$forum_rows = array();
while( $row = $db->sql_fetchrow($result) ) {
	$forum_rows[] = $row;
}

//
// Check for submit to be equal to Archive. If so then proceed with the archiving.
//
if( isset($_POST['doarchive']) ) {
	$archivedays = ( isset($_POST['archivedays']) ) ? intval($_POST['archivedays']) : 0;

	// Convert days to seconds for timestamp functions...
	$archivedate = gmtime() - ( $archivedays * 86400 );

	$template->set_filenames(array('body' => 'forums/admin/forum_archive_result_body.html'));

	for($i = 0; $i < count($forum_rows); $i++) {
		$p_result = archive($forum_rows[$i]['forum_id'], $archivedate);
		sync('forum', $forum_rows[$i]['forum_id']);

		$row_color = ( !($i % 2) ) ? $bgcolor2 : $bgcolor1;
		$row_class = ( !($i % 2) ) ? 'row1' : 'row2';

		$template->assign_block_vars('archive_results', array(
			'ROW_COLOR' => $row_color,
			'ROW_CLASS' => $row_class,
			'FORUM_NAME' => $forum_rows[$i]['forum_name'],
			'FORUM_TOPICS' => $p_result['topics'],
			'FORUM_POSTS' => $p_result['posts'],
			'WORDS_REMOVED' => $p_result['words'])
		);
	}
	$template->assign_vars(array(
		'L_FORUM_ARCHIVE' => $lang['Forum_Archive'],
		'L_FORUM' => $lang['Forum'],
		'L_TOPICS_ARCHIVED' => $lang['Topics_archived'],
		'L_POSTS_ARCHIVED' => $lang['Posts_archived'],
		'L_WORDS_REMOVED' => $lang['Words_Removed'],
		'L_ARCHIVE_RESULT' => $lang['Archive_success'])
	);
} else {
	//
	// If they haven't selected a forum for pruning yet then
	// display a select box to use for pruning.
	//
	if( empty($_POST[POST_FORUM_URL]) ) {
		//
		// Output a selection table if no forum id has been specified.
		//
		$template->set_filenames(array('body' => 'forums/admin/forum_archive_select_body.html'));
		$select_list = '<select name="' . POST_FORUM_URL . '">';
		$select_list .= '<option value="-1">' . $lang['All_Forums'] . '</option>';
		for($i = 0; $i < count($forum_rows); $i++) {
			$select_list .= '<option value="' . $forum_rows[$i]['forum_id'] . '">' . $forum_rows[$i]['forum_name'] . '</option>';
		}
		$select_list .= '</select>';
		//
		// Assign the template variables.
		//
		$template->assign_vars(array(
			'L_FORUM_ARCHIVE' => $lang['Forum_Archive'],
			'L_SELECT_FORUM' => $lang['Select_a_Forum'],
			'L_LOOK_UP' => $lang['Look_up_Forum'],

			'S_FORUMARCHIVE_ACTION' => adminlink("&amp;do=forum_archive"),
			'S_FORUMS_SELECT' => $select_list)
		);
	} else {
		$forum_id = intval($_POST[POST_FORUM_URL]);
		//
		// Output the form to retrieve Archive information.
		//
		$template->set_filenames(array('body' => 'forums/admin/forum_archive_body.html'));
		$forum_name = ( $forum_id == -1 ) ? $lang['All_Forums'] : $forum_rows[0]['forum_name'];
		$archive_data = $lang['Archive_topics_not_posted'] . " ";
		$archive_data .= '<input class="post" type="text" name="archivedays" size="4"> ' . $lang['Days'];
		$hidden_input = '<input type="hidden" name="' . POST_FORUM_URL . '" value="' . $forum_id . '">';
		//
		// Assign the template variables.
		//
		$template->assign_vars(array(
			'FORUM_NAME' => $forum_name,

			'L_FORUM' => $lang['Forum'],
			'L_FORUM_ARCHIVE' => $lang['Forum_Archive'],
			'L_FORUM_ARCHIVE_EXPLAIN' => $lang['Forum_Archive_explain'],
			'L_DO_ARCHIVE' => $lang['Do_Archive'],

			'S_FORUMARCHIVE_ACTION' => adminlink("&amp;do=forum_archive"),
			'S_ARCHIVE_DATA' => $archive_data,
			'S_HIDDEN_VARS' => $hidden_input)
		);
	}
}
