<?php
/******************************************************
  Downloads Pro: Designed exclusively for Dragonfly CMS
  *****************************************************
  Copyright © 2005 - 2006 by Trevor Eckart and DJMaze
  http://dragonflycms.org

  Please see the included LICENSE.txt for the terms and
  conditions that govern your use of this module

  $Source: /cvs/modules/Downloads_Pro/modules/Downloads/include/friend.inc,v $
  $Revision: 1.4 $
  $Author: trevor $
  $Date: 2006/06/11 23:48:49 $
******************************************************/
if (!defined('CPG_NUKE')) { exit; }

$friend_id = isset($_GET['friend']) ? intval($_GET['friend']) : $global_id;

$preview = '';
$subject = 'I\'ve come across an interesting download';
if (isset($_POST['preview_message'])) {
    $s_name = strip_tags($_POST['s_name']);
    $s_email = strip_tags($_POST['s_email']);
    $r_name = strip_tags($_POST['r_name']);
    $r_email = strip_tags($_POST['r_email']);
    $personal_message = $_POST['personal_message'];
    
    if (empty($s_name)) { $error = sprintf(_ERROR_NOT_SET, 'Sender name'); }
    if (empty($s_email)) { $error = sprintf(_ERROR_NOT_SET, 'Sender email'); }
    if (is_email($s_email) < 1) { $error = 'Please enter a valid sender email address'; }
    if (empty($r_name)) { $error = sprintf(_ERROR_NOT_SET, 'Recipient name'); }
    if (empty($r_email)) { $error = sprintf(_ERROR_NOT_SET, 'Recipient email'); }
    if (is_email($r_email) < 1) { $error = 'Please enter a valid recipient email address'; }
    if (empty($personal_message)) { $error = sprintf(_ERROR_NOT_SET, 'Personal message'); }
    
    if (isset($error)) { cpg_error($error); }
    
    list($dl_title, $dl_description, $dl_date, $dl_filesize, $dl_hits, $dl_score, $dl_votes) = $db->sql_ufetchrow("SELECT d.title, d.desc_short, d.date, d.filesize, sum(s.hits) AS hits, r.score, count(r.score) AS votes FROM ".$dl_prefix."_downloads d
    LEFT JOIN ".$dl_prefix."_stats s ON (s.id = d.lid)
    LEFT JOIN ".$dl_prefix."_ratings r ON (r.lid = d.lid)
    WHERE d.lid='$friend_id' GROUP BY r.id", SQL_NUM, __FILE__, __LINE__);
    $rating_info = get_rating($dl_score, $dl_votes);
    
    $brackets_array = array('/\{sender\}/', '/\{recipient\}/', '/\{sitename\}/', '/\{title\}/', '/\{date\}/', '/\{hits\}/', '/\{score\}/', '/\{pop\}/', '/\{size\}/', '/\{details\}/');
    $brackets_replacements = array($s_name, $r_name, $MAIN_CFG['global']['sitename'], $dl_title, generate_date($dl_date), $dl_hits, $rating_info['score'], popularity($friend_id, true), notate_size($dl_filesize), getlink('&amp;file=details&amp;id='.$friend_id, true, true));
    $personal_message = preg_replace($brackets_array, $brackets_replacements, $personal_message);
    $preview = '<fieldset><legend>Preview</legend>
    <strong>From:</strong> '.$s_name.' &lt;'.$s_email.'&gt;<br />
    <strong>To:</strong> '.$r_name.' &lt;'.$r_email.'&gt;<br />
    <strong>Date:</strong> '.generate_date(gmtime()).'<br />
    <strong>Subject:</strong> '.$subject.'
    <hr />'.decode_bbcode($personal_message).'</fieldset>';
}

if (isset($_POST['send_message'])) {
    list($dl_title, $dl_description, $dl_date, $dl_filesize, $dl_hits, $dl_score, $dl_votes) = $db->sql_ufetchrow("SELECT d.title, d.desc_short, d.date, d.filesize, sum(s.hits) AS hits, r.score, count(r.score) AS votes FROM ".$dl_prefix."_downloads d
    LEFT JOIN ".$dl_prefix."_stats s ON (s.id = d.lid)
    LEFT JOIN ".$dl_prefix."_ratings r ON (r.lid = d.lid)
    WHERE d.lid='$friend_id' GROUP BY r.id", SQL_NUM, __FILE__, __LINE__);
    $rating_info = get_rating($dl_score, $dl_votes);
    $html = ($MAIN_CFG['email']['allow_html_email'] || is_admin());
    
    $sender_name = strip_tags($_POST['s_name']);
    $sender_email = strip_tags($_POST['s_email']);
    $recip_name = strip_tags($_POST['r_name']);
    $recip_email = strip_tags($_POST['r_email']);
    $personal_message = $_POST['personal_message'];
    
    if (!isset($CPG_SESS['recommend_dl']) && !$CPG_SESS['recommend_dl']) { $error = _SPAMGUARDPROTECTED; }
    if (empty($sender_name)) { $error = sprintf(_ERROR_NOT_SET, 'Sender name'); }
    if (empty($recip_name)) { $error = sprintf(_ERROR_NOT_SET, 'Recipient name'); }
    if (empty($personal_message)) { $error = sprintf(_ERROR_NOT_SET, 'Personal message'); }
    
    $brackets_array = array('/\{sender\}/', '/\{recipient\}/', '/\{sitename\}/', '/\{title\}/', '/\{date\}/', '/\{hits\}/', '/\{score\}/', '/\{pop\}/', '/\{size\}/', '/\{details\}/');
    $brackets_replacements = array($sender_name, $recip_name, $MAIN_CFG['global']['sitename'], $dl_title, generate_date($dl_date, $userinfo['user_dateformat']), $dl_hits, $rating_info['score'], popularity($friend_id, true), notate_size($dl_filesize), getlink('&amp;file=details&amp;id='.$friend_id, true, true));
    $personal_message = preg_replace($brackets_array, $brackets_replacements, $personal_message);
    
    if (isset($error)) {
        cpg_error($error);
    } else {
         if (!send_mail($mailer_message, $personal_message, $html, $subject, $recip_email, $recip_name, $sender_email, $sender_name)) {
            cpg_error($mailer_message);
        } else {
            $CPG_SESS['recommend_dl'] = false;
            unset($CPG_SESS['recommend_dl']);
            cpg_error('Your message has been sent successfully', _TB_INFO, getlink());
        }
    }
} else {
    if (!isset($friend_id)) { url_redirect(getlink()); }
    list($dl_title, $dl_description, $dl_date, $dl_filesize, $dl_pick, $dl_active, $dl_submitter, $dl_hits, $dl_score, $dl_votes) = $db->sql_ufetchrow("SELECT d.title, d.desc_short, d.date, d.filesize, d.pick, d.active, d.submitter, sum(s.hits) AS hits, r.score, count(r.score) AS votes FROM ".$dl_prefix."_downloads d
    LEFT JOIN ".$dl_prefix."_stats s ON (s.id = d.lid)
    LEFT JOIN ".$dl_prefix."_ratings r ON (r.lid = d.lid)
    WHERE d.lid='$friend_id' GROUP BY r.id", SQL_NUM, __FILE__, __LINE__);
    if (!isset($dl_title)) { cpg_error('The specified download does not exist', 404); }
    if ($dl_active != 1 && !can_admin($module_name)) { cpg_error('The specified download is not active'); }
    $rating_info = get_rating($dl_score, $dl_votes);
    $html = ($MAIN_CFG['email']['allow_html_email'] || is_admin());
    $CPG_SESS['recommend_dl'] = true;
    $my_name = $my_email = '';
    if (is_user()) {
        $my_name = (!empty($userinfo['name'])) ? $userinfo['name'] : $userinfo['username'];
        $my_email = $userinfo['user_email'];
    }
    $bbcode = ($html) ? bbcode_table('personal_message', 'recommend_dl', 0) : '';
    $message_insert = isset($_POST['personal_message']) ? $_POST['personal_message'] :
                     "Hey {recipient},\n\n"
                    ."I was surfing a website called ".($html ? '[i]{sitename}[/i]' : '"{sitename}"')." and I came across a download that I thought was rather interesting and I just wanted to share it with you.\n\n"
                    ."The download is called ".($html ? '[i]{title}[/i]' : '"{title}"')." and here is a brief overview...\n\n"
                    ."Published: {date}\n"
                    ."Hits: {hits}\n"
                    .($dl_config['r_active'] ? "Score: {score}\n" : '')
                    ."Popularity: {pop}\n"
                    ."Filesize: {size}\n\n"
                    ."You can read more details here: ".($html ? '[url]{details}[/url]' : '{details}').".\n\n"
                    ."{sender}";
    $pagetitle .= ' '._BC_DELIM.' Tell a Friend '._BC_DELIM.' '.$dl_title;
    require_once('header.php');
    OpenTable();
    echo dl_detail_menu($friend_id, $dl_title, $dl_pick, $dl_active, 7).'<br /><br />
       <span class="genmed"><strong>Tell a Friend</strong></span><br /><br />
       '.(!empty($preview) ? $preview.'<br />' : '').'
       <form action="'.getlink('&amp;friend='.$friend_id).'" method="post" name="recommend_dl" id="recommend_dl" enctype="multipart/form-data" accept-charset="utf-8">
       <label class="ulog" for="s_name">Sender Name</label>
        <input type="text" name="s_name" id="s_name" size="33" maxlength="255" value="'.(isset($_POST['s_name']) ? strip_tags($_POST['s_name']) : $my_name).'" /><br />
       <label class="ulog" for="s_email">Sender Email</label>
        <input type="text" name="s_email" id="s_email" size="33" maxlength="255" value="'.(isset($_POST['s_email']) ? strip_tags($_POST['s_email']) : $my_email).'" /><br /><br />
       <label class="ulog" for="r_name">Recipient Name</label>
        <input type="text" name="r_name" id="r_name" size="33" maxlength="255" value="'.(isset($_POST['r_name']) ? strip_tags($_POST['r_name']) : '').'" /><br />
       <label class="ulog" for="r_email">Recipient Email</label>
        <input type="text" name="r_email" id="r_email" size="33" maxlength="255" value="'.(isset($_POST['r_email']) ? strip_tags($_POST['r_email']) : '').'" /><br /><br />
       '.$bbcode.'
       <textarea name="personal_message" cols="63" rows="18">'.$message_insert.'</textarea><br /><br />
       <input type="hidden" name="id" value="'.$friend_id.'" />
       <input type="submit" name="preview_message" value="'._PREVIEW.'" /> <input type="submit" name="send_message" value="'._SUBMIT.'" />
       </form>';
    CloseTable();
}
