<?php
/****************************************************
  Calendar is released under the terms and conditions
  of the GNU GPL version 2 or any later version
*****************************************************
  RSS Feed for DragonflyCMS 9.1.1
  Provided by Phoenix at NukeBiz dot com
****************************************************/
define('XMLFEED', 1);
$root_path = dirname(dirname(__FILE__));
if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
    $root_path = str_replace('\\', '/', $root_path); //Damn' windows
}
if (strlen($root_path) > 2) define('BASEDIR', $root_path.'/');
else define('BASEDIR', '../');
$cal_module_name = 'CPGNuCalendar';

require_once(BASEDIR.'includes/cmsinit.inc');
require_once(BASEDIR.'includes/functions/language.php');
require_once(BASEDIR.'includes/nbbcode.php');
require_once(BASEDIR.'modules/'.$cal_module_name.'/includes/functions.inc');

global $cal_prefix, $cal_config, $cal_module_name, $repeated_descriptions, $canceled_events, $repeated_events, $events, $calcategories, $bgcolor1, $bgcolor2, $userinfo;

get_lang($cal_module_name);

if (!is_active($cal_module_name)) { die($cal_module_name.' '._CALINACTIVE); }

$year = date('Y');
$month = date('m');
$day = date('d');

$numdays = $cal_config['block_upcoming_days'];
$startdate = sprintf ( '%04d%02d%02d', $year, $month, $day );
$future = adodb_mktime( 0, 0, 0, $month, $day+$numdays, $year);
$enddate = adodb_date( 'Ymd', $future);

/* Pre-Load the descriptions for repeating events for quckier access */
$repeated_descriptions = read_repeated_descriptions ( $startdate, $enddate );
/* Pre-Load the canceled repeating events for quckier access */
$canceled_events = read_canceled_events ( $startdate, $enddate );
/* Pre-Load the repeated events for quckier access */
$repeated_events = read_repeated_events ();
/* Pre-load the non-repeating events for quicker access */
$events = read_events ( $startdate, $enddate );
/* Pre-load the categories for quicker access */
$calcategories = read_categories ( );

for ( $d = 0; $d < $numdays; $d++ ) {
	$days[$d] = adodb_mktime( 0, 0, 0, $month, $day+$d, $year);
}

$date = date('D, d M Y H:i:s \G\M\T', gmtime());
header("Date: $date");
$BASEHREF = ereg_replace('//rss.', '//', $BASEHREF);
header('Content-Type: text/xml'); // application/rss+xml
//  <ttl>60</ttl> a number of minutes that indicates how long a channel can be cached before refresh.
echo '<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0">
<channel>
  <title>'.htmlprepare($sitename).'</title>
  <link>'.$BASEHREF.'</link>
  <description>'.htmlprepare($backend_title).'</description>
  <language>'.$backend_language.'</language>
  <pubDate>'.$date.'</pubDate>
  <ttl>'.(60*24).'</ttl>
  <generator>CPG-Nuke Dragonfly</generator>
  <copyright>'.htmlprepare($sitename).'</copyright>
  <category>Calendar Upcoming Events</category>
  <docs>http://backend.userland.com/rss</docs>
  <image>
    <url>'.$BASEHREF.'images/'.$MAIN_CFG['global']['site_logo'].'</url>
    <title>'.htmlprepare($sitename).'</title>
    <link>'.$BASEHREF."</link>
  </image>\n\n";

for ( $d = 0; $d < $numdays; $d++ ) {
	$date = adodb_date ( 'Ymd', $days[$d] );
	$daysevents = rss_month_events($date);
	if ( $daysevents != '' ) {
		echo $daysevents;
	}
}
?>
</channel>
</rss>