<?php
/*********************************************
  CPGNuCalendar
  ********************************************
  Copyright 2005 by Kris Henneman
  
  Original highly modified code ported from an early 2003 
  version of WebCalendar by http://webcalendar.sourceforge.net
  to PHP-Nuke.  It has since been ported to CPG-Nuke.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  CPGNuCalendar is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  $Id: index.php,v 1.3 2007/10/25 07:43:28 Phoenix Exp $
  $RCSfile: index.php,v $
  $Revision: 1.3 $
  $Author: Phoenix $
  $Date: 2007/10/25 07:43:28 $
**********************************************/

if (!defined('CPG_NUKE')) { exit; }

require_once("modules/$module_name/includes/functions.inc");

global $modheader, $CPG_SESS, $cal_config, $module_name;

$pagetitle .= $cal_module_title;

if (file_exists("modules/$module_name/style/".$CPG_SESS['theme']."style.css")) {
	$modheader .= "\n<link rel=\"stylesheet\" href=\"modules/$module_name/style/".$CPG_SESS['theme']."style.css\" type=\"text/css\" />";
} else {
	$modheader .= "\n<link rel=\"stylesheet\" href=\"modules/$module_name/style/style.css\" type=\"text/css\" />";
}
$modheader .= "\n<script type=\"text/javascript\" src=\"modules/$module_name/js/calendar.js\"></script>";

// Print all the calendar entries for the specified date
//   $date - date in YYYYMMDD format
	function print_monthly_events ( $date ) {
		global $events, $module_name, $cal_config;

		$year = substr ( $date, 0, 4 );
		$month = substr ( $date, 4, 2 );
		$day = substr ( $date, 6, 2 );

		$dateu = adodb_mktime ( 2, 0, 0, $month, $day, $year );
		echo '<table border="0" width="100%" cellspacing="0" cellpadding="0">'
			.'<tr><td class="calendarbg">'
			.'<table border="0" cellspacing="1" cellpadding="0">'
			.'<tr><td class="calendarday">'
			."<div style=\"whitespace:nowrap;\"><a href=\"".getlink($module_name . "&amp;view=day&amp;date=$date") . "\">$day</a>";
		if ( $cal_config['show_weekly_link'] == 1 && adodb_date ( "w", $dateu ) == $cal_config['week_start_day'] && $year > 1969 ) {
			echo "<a href=\"".getlink($module_name . "&amp;view=week&amp;date=$date") . "\">(". _WEEK . " " . week_number ( $dateu ) . ")</a>";
		}

		echo "</div>\n";
		echo '</td></tr></table></td>'
			.'<td width="100%">&nbsp;</td></tr></table>';

		echo print_month_events($date);
	}

// Print all the calendar entries for the specified user for the
// specified date in day-at-a-glance format.
// If we are displaying data from someone other than
// the logged in user, then check the access permission of the entry.
// We output a two column format like:   time: event
// params:
//   $date - date in YYYYMMDD format
//   $user - username
//   $hide_icons - should we hide the icons to make it printer-friendly
	function print_daily_events ( $date ) {
		global $hour_arr, $rowspan_arr, $rowspan;
		global $CELLBG, $TODAYCELLBG, $THFG, $THBG;
		global $repeated_events, $cal_config;

		$rowspan_arr = array ();
		for ( $i = 0; $i < 24; $i++ ) {
			$rowspan_arr[$i] = 0;
		}

		$hour_arr = Array ();
		$first_hour = $cal_config['workday_start'];
		$last_hour = $cal_config['workday_end'];

		print_day_events( $date );

		  // squish events that use the same cell into the same cell.
		  // For example, an event from 8:00-9:15 and another from 9:30-9:45 both
		  // want to show up in the 8:00-9:59 cell.
		  $rowspan = 0;
		  $last_row = -1;
		  for ( $i = 0; $i < 24; $i++ ) {
			if ( $rowspan > 1 ) {
			  if ( ! empty ( $hour_arr[$i] ) ) {
				if ( $rowspan_arr[$i] > 1 ) {
				  $rowspan_arr[$last_row] += ( $rowspan_arr[$i] - 1 );
				  $rowspan += ( $rowspan_arr[$i] - 1 );
				} else {
				  $rowspan_arr[$last_row] += $rowspan_arr[$i];
				}
				// this will move entries apart that appear in one field,
				// yet start on different hours
				$start_time = $i;
				$diff_start_time = $start_time - $last_row;
				for ( $u = $diff_start_time ; $u > 0 ; $u-- )
				  $hour_arr[$last_row] .= "<br />";
				$hour_arr[$last_row] .= $hour_arr[$i];
				$hour_arr[$i] = "";
				$rowspan_arr[$i] = 0;
			  }
			  $rowspan--;
			} elseif ( ! empty ( $rowspan_arr[$i] ) && $rowspan_arr[$i] > 1 ) {
			  $rowspan = $rowspan_arr[$i];
			  $last_row = $i;
			}
		  }
		  if ( ! empty ( $hour_arr[99] ) ) {
			echo "<tr><td class=\"calendartime\" valign=\"top\" height=\"27px\" width=\"14%\">"._ALLDAY."</td><td valign=\"top\" height=\"27px\" class=\"calendartoday\">$hour_arr[99]</td></tr>\n";
		  }
		  $rowspan = 0;
		  for ( $i = $first_hour; $i <= $last_hour; $i++ ) {
			$time = display_time ( $i * 10000 );
			echo "<tr><td class=\"calendartime\" valign=\"top\" height=\"27px\" width=\"14%\">" .
			  $time . "</td>\n";
			if ( $rowspan > 1 ) {
			  // this might mean there's an overlap, or it could mean one event
			  // ends at 11:15 and another starts at 11:30.
			  if ( ! empty ( $hour_arr[$i] ) ) {
				echo "<td valign=\"top\" height=\"27px\" class=\"calendartoday=\">$hour_arr[$i]</td>";
			  }
			  $rowspan--;
			} else {
			  if ( empty ( $hour_arr[$i] ) ) {
				echo "<td height=\"27px\" class=\"calendarday\">&nbsp;</td></tr>\n";
			  } else {
				$rowspan = $rowspan_arr[$i];
				if ( $rowspan > 1 ) {
				  echo "<td valign=\"top\" class=\"calendartoday\" rowspan=\"$rowspan\">$hour_arr[$i]</td></tr>\n";
				} else {
				  echo "<td valign=\"top\" height=\"27px\" class=\"calendartoday\">$hour_arr[$i]</td></tr>\n";
				}
			  }
			}
		  }
	}

	function small_month($month, $year) {
		global $module_name, $cal_config;
		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
		if ( $cal_config['week_start_day'] == "1" ) {
			$wkstart = get_monday_before ( $year, $month, 1 );
		} else {
			$wkstart = get_sunday_before ( $year, $month, 1 );
		}
		$monthstart = adodb_mktime ( 0, 0, 0, $month, 1, $year );
		$monthend = adodb_mktime ( 0, 0, 0, $month + 1, 0, $year );
		echo "<tr><td colspan=\"7\" class=\"cat\" align=\"center\">"
			."<a href=\"".getlink($module_name . "&amp;view=month&amp;day=1&amp;month=$month&amp;year=$year")."\">"
			.month_name ( $month - 1 ) . " " . $year
			."</a></td></tr>\n"
			."<tr><td colspan=\"7\" class=\"calendarth\">"
			."<table border=\"0\" cellpadding=\"0\" cellspacing=\"4\" width=\"100%\"><tr>";
		if ( $cal_config['week_start_day'] == 0 ) {
			echo "<td>" . weekday_letter_name ( 0 ) . "</td>";
		}
		for ( $i = 1; $i < 7; $i++ ) {
			echo "<td>" .	weekday_letter_name ( $i ) . "</td>";
		}
		if ( $cal_config['week_start_day'] == 1 ) {
			echo "<td>" . weekday_letter_name ( 0 ) . "</td>";
		}
		echo "</tr></table></td></tr>\n"
			."<tr><td colspan=\"7\" class=\"calendartoday\">"
			."<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">";
		$today = adodb_mktime ( 2, 0, 0, adodb_date ( "m" ), adodb_date ( "d" ), adodb_date ( "Y" ) );

		for ( $i = $wkstart; adodb_date ( "Ymd", $i ) <= adodb_date ( "Ymd", $monthend ); $i += ( 24 * 3600 * 7 ) ) {
			echo "<tr>\n";
			for ( $j = 0; $j < 7; $j++ ) {
				$date = $i + ( $j * 24 * 3600 );
				if ( adodb_date ( "Ymd", $date ) >= adodb_date ( "Ymd", $monthstart ) &&
					adodb_date ( "Ymd", $date ) <= adodb_date ( "Ymd", $monthend ) ) {
					if ($cal_config['block_month_highlight_days'] == 1) {
						echo "<td class=\"". (hasEvents(adodb_date ( "Ymd", $date )) ? "calendartoday" : "calendarday") ."\" align=\"center\">";
					} else {
						echo "<td class=\"calendarday\" align=\"center\">";
					}
					if ( adodb_date ( "Ymd", $date ) == adodb_date ( "Ymd", $today ) ) {
						 echo "<div id=\"Layer1\" align=\"left\" style=\"position:relative; width: 16px; height: 16px; background-image:url(modules/$module_name/images/today.gif);\"><a href=\"".getlink($module_name . "&amp;view=day&amp;date=".adodb_date ("Ymd", $date ) ) . "\">".adodb_date ( "d", $date ) . "</a></div>";
					} else {
						echo "<a href=\"".getlink($module_name . "&amp;view=day&amp;date=".adodb_date ("Ymd", $date ) ) . "\">"
						.adodb_date ( "d", $date ) . "</a>";
					}
					echo "</td>\n";
					
				} else {
					echo "<td class=\"calendarday\"></td>\n";
				}
			}
			echo "</tr>\n";
		}
		echo "</table></td></tr>";
		echo "</table>\n";
	}

	function view_popup() {
		global $CPG_SESS, $module_name, $cal_config, $BASEHREF;
		$form = $_GET['form'];
		$date = $_GET['date'];
		$daylabel = $_GET['day'];
		$monthlabel = $_GET['month'];
		$yearlabel = $_GET['year'];

		define('HEADER_OPEN', true);

		$thisyear = substr ( $date, 0, 4 );
		$thismonth = substr ( $date, 4, 2 );
		$thisday = substr ( $date, 6, 2 );

		$nextmonth = adodb_mktime ( 2, 0, 0, $thismonth + 1, 1, $thisyear );
		$prevmonth = adodb_mktime ( 2, 0, 0, $thismonth - 1, 1, $thisyear );
		$nextyear = adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear + 1 );
		$prevyear = adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear - 1 );

		echo "<html>\n"
			."<head>\n"
			."<base href=\"" . $BASEHREF . "\">"
			."<link rel=\"stylesheet\" href=\"themes/$CPG_SESS[theme]/style/style.css\" type=\"text/css\">"
			."<title>Date Selection</title>\n"
			."<script type=\"text/javascript\">\n"
			."function sendDate ( date ) {\n"
			."  year = date.substring ( 0, 4 );\n"
			."  month = date.substring ( 4, 6 );\n"
			."  day = date.substring ( 6, 8 );\n"
			."  window.opener.document.$form.$daylabel.selectedIndex = day - 1;\n"
			."  window.opener.document.$form.$monthlabel.selectedIndex = month - 1;\n"
			."  for ( i = 0; i < window.opener.document.$form.$yearlabel.length; i++ ) {\n"
			."    if ( window.opener.document.$form.$yearlabel.options[i].value == year ) {\n"
			."      window.opener.document.$form.$yearlabel.selectedIndex = i;\n"
			."    }\n"
			."  }\n"
			."  window.close ();\n"
			."}\n"
			."</script>\n"
			."</head>\n"
			."<body>\n"
			."<div style=\"text-align:center;\">\n"
			.'<table border="0" width="100%" cellspacing="0" cellpadding="0">';

		if ( $cal_config['week_start_day'] == "1" ) {
			$wkstart = get_monday_before ( $thisyear, $thismonth, 1 );
		} else {
			$wkstart = get_sunday_before ( $thisyear, $thismonth, 1 );
		}
		$monthstart = adodb_mktime ( 0, 0, 0, $thismonth, 1, $thisyear );
		$monthend = adodb_mktime ( 0, 0, 0, $thismonth + 1, 0, $thisyear );
		echo "<tr><td align=\"left\" class=\"cat\">"
			."<a href=\"" . getlink($module_name . "&amp;view=popup&amp;form=editeventform&amp;day=$daylabel&amp;month=$monthlabel&amp;year=$yearlabel&amp;date=" . adodb_date ('Ymd', $prevmonth) ) . "\">&lt;</a> "
			.month_name ( $thismonth - 1 )
			." <a href=\"" . getlink($module_name . "&amp;view=popup&amp;form=editeventform&amp;day=$daylabel&amp;month=$monthlabel&amp;year=$yearlabel&amp;date=" . adodb_date ('Ymd', $nextmonth) ) . "\">&gt;</a>"
			."</td><td align=\"right\" class=\"cat\">"
			."<a href=\"" . getlink($module_name . "&amp;view=popup&amp;form=editeventform&amp;day=$daylabel&amp;month=$monthlabel&amp;year=$yearlabel&amp;date=" . adodb_date ('Ymd', $prevyear) ) . "\">&lt;</a> "
			.$thisyear
			." <a href=\"" . getlink($module_name . "&amp;view=popup&amp;form=editeventform&amp;day=$daylabel&amp;month=$monthlabel&amp;year=$yearlabel&amp;date=" . adodb_date ('Ymd', $nextyear) ) . "\">&gt;</a>"
			."</td></tr>\n"
			.'<tr><td colspan="2" class="calendarbg">'
			.'<table border="0" width="100%" cellspacing="1" cellpadding="2">'
			."<tr>";
		if ( $cal_config['week_start_day'] == 0 ) {
			echo "<th>" . weekday_letter_name ( 0 ) . "</th>";
		}
		for ( $i = 1; $i < 7; $i++ ) {
			echo "<th>" .	weekday_letter_name ( $i ) . "</th>";
		}
		if ( $cal_config['week_start_day'] == 1 )
			echo "<th>" . weekday_letter_name ( 0 ) . "</th>";

		echo "</tr>\n";
		$today = adodb_mktime ( 2, 0, 0, adodb_date ( "m" ), adodb_date ( "d" ), adodb_date ( "Y" ) );
		for ( $i = $wkstart; adodb_date ( "Ymd", $i ) <= adodb_date ( "Ymd", $monthend ); $i += ( 24 * 3600 * 7 ) ) {
			echo "<tr>\n";
			for ( $j = 0; $j < 7; $j++ ) {
				$date = $i + ( $j * 24 * 3600 );
				if ( adodb_date ( "Ymd", $date ) >= adodb_date ( "Ymd", $monthstart ) &&
					adodb_date ( "Ymd", $date ) <= adodb_date ( "Ymd", $monthend ) ) {
					echo "<td class=\"calendarday\">";
					if ( adodb_date ( "Ymd", $date ) == adodb_date ( "Ymd", $today ) ) {
						 echo "<div id=\"Layer1\" align=\"left\" style=\"position:relative; width: 16px; height: 16px; background-image:url(modules/$module_name/images/today.gif);\"><a href=\"javascript:sendDate('" . adodb_date ( "Ymd", $date ) . "')\">".adodb_date ( "d", $date ) . "</a></div>";
					} else {
						echo "<a href=\"javascript:sendDate('" . adodb_date ( "Ymd", $date ) . "')\">"
						.adodb_date ( "d", $date ) . "</a>";
					}
					echo "</td>\n";
				} else {
					echo "<td align=\"center\" class=\"calendarday\"></td>\n";
				}
			}
			echo "</tr>\n";
		}
		echo "</table>\n"
			."</td></tr>\n"
			."</table><br />\n"
			."</div>\n"
			."</body>\n"
			."</html>";
	}
	
	function view_year($thisyear) {
		global $module_name, $cal_config;
		require_once('header.php');
		OpenTable();

		$date = adodb_mktime ( 2, 0, 0, 1, 1, $thisyear - 1);
		$prevyear = adodb_date ( "Y", $date );
		$date = adodb_mktime ( 2, 0, 0, 1, 1, $thisyear + 1);
		$nextyear = adodb_date ( "Y", $date );
		echo '<table border="0" width="100%">'
			.'<tr>'
			.'<td align="left">';

		if ($prevyear >= $cal_config['start_year']) {
			echo "<a href=\"".getlink($module_name . "&amp;view=year&amp;year=$prevyear") . "\">&lt;&lt; $prevyear</a>";
		} else {
			echo '&nbsp;';
		}
		echo '</td>'
			.'<td class="calendartitle" align="center">'
			.$thisyear;
		echo '</td>'
			.'<td align="right">';
		echo"<a href=\"".getlink($module_name . "&amp;view=year&amp;year=$nextyear") . "\">$nextyear &gt;&gt;</a>";
		echo '</td>';
		echo '</tr>';
		echo '</table>';

		$month = 1;
		for ($i = 1; $i <= 12 / $cal_config['year_columns']; $i++) {
			echo '<table border=\"0\" width="100%">'
				.'<tr>';
			for ( $j = 1; $j <= $cal_config['year_columns']; $j++ ) {
				echo '<td align="center" valign="top">';
				small_month( $month++, $thisyear);
				echo '</td>';
			}
			echo '</tr>'
				.'</table>';
		}
		echo "<table border=\"0\" width=\"100%\">"
			."<tr><td align=\"right\">"
			.jumpToDate($thisyear."0101")
			."</td></tr>"
			."</table>";

		CloseTable();
	}

	function view_month($thisday, $thismonth, $thisyear) {
		global $module_name, $cal_config;
		require_once('header.php');
		OpenTable();
		echo "<table border=\"0\" width=\"100%\">"
			."<tr>"
			."<td align=\"left\" valign=\"top\">";
		//This line does not work in the current version of adodb
		$prev = adodb_mktime ( 2, 0, 0, $thismonth - 1, 1, $thisyear );
		//$prev = adodb_mktime ( 2, 0, 0, $thismonth, 0, $thisyear );
		$prevyear = adodb_date ( "Y", $prev );
		$prevmonth = adodb_date ( "m", $prev );
		$next = adodb_mktime ( 2, 0, 0, $thismonth + 1, 1, $thisyear );
		$nextyear = adodb_date ( "Y", $next );
		$nextmonth = adodb_date ( "m", $next );
		$selectedday = adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear );

		if ($prevyear >= $cal_config['start_year']) {
			small_month($prevmonth, $prevyear);
		} else {
			echo '&nbsp;';
		}

		echo "</td>"
			."<td class=\"calendartitle\" align=\"center\">";
		printf ( "%s", month_name ( $thismonth - 1 ) );
		if ($thisyear-1 >= $cal_config['start_year']) {
			echo " <a href=\"".getlink($module_name . "&amp;view=month&amp;month=$thismonth&amp;year=".($thisyear-1)) . "\" title=\"". month_name($thismonth-1)." ".($thisyear-1)."\">&lt;&lt;</a>";
		}
		echo " <a href=\"".getlink($module_name . "&amp;view=year&amp;year=$thisyear") . "\">$thisyear</a>";
		echo " <a href=\"".getlink($module_name . "&amp;view=month&amp;month=$thismonth&amp;year=".($thisyear+1)) . "\" title=\"". month_name($thismonth-1)." ".($thisyear+1)."\">&gt;&gt;</a>";
		$time = time();
		$ddata = date("m/d/y G.i:s", $time);
		echo '<br /><font size="2">'.$ddata.'</font>';
		echo '</td>'
			.'<td align="right" valign="top">';
		small_month($nextmonth, $nextyear);
		echo '</td>';
		echo '</tr>';
		echo '</table>';

		for ( $i = 0; $i < 7; $i++ ) {
		  $weekdays[$i] = weekday_name ( ( $i + $cal_config['week_start_day'] ) % 7 );
		}

		echo '<table border="0" width="100%" cellspacing="0" cellpadding="0">'
			.'<tr><td class="calendarbg">'
			.'<table border="0" width="100%" cellspacing="1" cellpadding="0">'
			.'<tr>';

		for ( $d = 0; $d < 7; $d++ ) {
		  echo "<th width=\"13%\">$weekdays[$d]</th>";
		}
		
		echo '</tr>';

		// We add 2 hours on to the time so that the switch to DST doesn't
		// throw us off.  So, all our dates are 2AM for that day.
		//$sun = get_sunday_before ( $thisyear, $thismonth, 1 );
		if ( $cal_config['week_start_day'] == 1 ) {
		  $wkstart = get_monday_before ( $thisyear, $thismonth, 1 );
		} else {
		  $wkstart = get_sunday_before ( $thisyear, $thismonth, 1 );
		}
		// generate values for first day and last day of month
		$monthstart = adodb_mktime ( 2, 0, 0, $thismonth, 1, $thisyear );
		$monthend = adodb_mktime ( 2, 0, 0, $thismonth + 1, 0, $thisyear );

		// debugging
		//echo "<P>sun = " . adodb_date ( "D, m-d-Y", $sun ) . "<br />";
		//echo "<P>monthstart = " . adodb_date ( "D, m-d-Y", $monthstart ) . "<br />";
		//echo "<P>monthend = " . adodb_date ( "D, m-d-Y", $monthend ) . "<br />";

		$today = adodb_mktime ( 2, 0, 0, adodb_date ( "m" ), adodb_date ( "d" ), adodb_date ( "Y" ) );
		for ( $i = $wkstart; adodb_date ( "Ymd", $i ) <= adodb_date ( "Ymd", $monthend );
		  $i += ( 24 * 3600 * 7 ) ) {
		  echo "<tr>\n";
		  for ( $j = 0; $j < 7; $j++ ) {
			$date = $i + ( $j * 24 * 3600 );
			if ( adodb_date ( "Ymd", $date ) >= adodb_date ( "Ymd", $monthstart ) &&
			  adodb_date ( "Ymd", $date ) <= adodb_date ( "Ymd", $monthend ) ) {
			  if ( adodb_date ( "Ymd", $date ) == adodb_date ( "Ymd", $today ) ) {
				echo "<td class=\"calendartoday\" valign=\"top\" style=\"width:75px; height:75px;\"> ";
				print_monthly_events ( adodb_date ( "Ymd", $date ) );
				echo "</td>\n";
			  } else {
				echo "<td class=\"calendarday\" valign=\"top\" style=\"width:75px; height:75px;\"> ";
				print_monthly_events ( adodb_date ( "Ymd", $date ) );
				echo "</td>\n";
			  }
			} else {
			  echo "<td valign=\"top\" style=\"width:75px; height:75px;\" class=\"calendarday\">&nbsp;</td>\n";
			}
		  }
		  echo "</tr>\n";
		}
		echo "</table>"
			."</td></tr>"
			."<tr><td align=\"right\">"
			.jumpToDate(adodb_date ( "Ymd", $selectedday ))
			."</td></tr>"
			."</table>";
		CloseTable();
	}

	function view_week($thisday, $thismonth, $thisyear) {
		global $first_hour, $last_hour, $hour_arr, $rowspan_arr, $module_name, $cal_config;
		require_once('header.php');
		OpenTable();

		if ( $cal_config['week_start_day'] == 1 ) {
		  $wkstart = get_monday_before ( $thisyear, $thismonth, $thisday );
		} else {
		  $wkstart = get_sunday_before ( $thisyear, $thismonth, $thisday );
		}
		$wkend = $wkstart + ( 3600 * 24 * 6 );
		$startdate = adodb_date ( "Ymd", $wkstart );
		$enddate = adodb_date ( "Ymd", $wkend );

		$next = adodb_mktime ( 2, 0, 0, $thismonth, $thisday + 7, $thisyear );
		$prev = adodb_mktime ( 2, 0, 0, $thismonth, $thisday - 7, $thisyear );
		$today = adodb_mktime ( 2, 0, 0, adodb_date ( "m" ), adodb_date ( "d" ), adodb_date ( "Y" ) );
		$selectedday = adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear );

		for ( $i = 0; $i < 7; $i++ ) {
		  $days[$i] = $wkstart + ( 24 * 3600 ) * $i;
		  $weekdays[$i] = weekday_short_name ( ( $i + $cal_config['week_start_day'] ) % 7 );
		  $colheader[$i] = $weekdays[$i] . "<br />" . month_short_name ( adodb_date ( "m", $days[$i] ) - 1 ) . " " . adodb_date ( "d", $days[$i] );
		}

		echo "<table border=\"0\" width=\"100%\">"
			."<tr>";
		if (adodb_date ("Y", $prev ) >= $cal_config['start_year']) {
			echo "<td align=\"left\"><a href=\"".getlink($module_name . "&amp;view=week&amp;date="
				. adodb_date ("Ymd", $prev ) ) . "\">&lt;&lt;</a></td>";
		} else {
			echo "<td>&nbsp;</td>";
		}
		echo "<td class=\"calendartitle\" align=\"center\">";

		if ( adodb_date ( "m", $wkstart ) == adodb_date ( "m", $wkend ) ) {
			printf ( "%s %d - %d, %d", month_name ( $thismonth - 1 ), adodb_date ( "d", $wkstart ), adodb_date ( "d", $wkend ), $thisyear );
		} else {
			if ( adodb_date ( "Y", $wkstart ) == adodb_date ( "Y", $wkend ) ) {
				printf ( "%s %d - %s %d, %d", month_name ( adodb_date ( "m", $wkstart ) - 1 ), adodb_date ( "d", $wkstart ), month_name ( adodb_date ( "m", $wkend ) - 1 ), adodb_date ( "d", $wkend ), $thisyear );
			} else {
				printf ( "%s %d, %d - %s %d, %d", month_name ( adodb_date ( "m", $wkstart ) - 1 ), adodb_date ( "d", $wkstart ), adodb_date ( "Y", $wkstart ), month_name ( adodb_date ( "m", $wkend ) - 1 ), adodb_date ( "d", $wkend ), adodb_date ( "Y", $wkend ) );
			}
		}

		echo "</b>";

		if ( $cal_config['show_weekly_link'] == "Y" ) {
		  echo "<br />\n(" .	_WEEK . " " . week_number ( $wkstart ) . ")";
		}

		echo "</td>";
		echo "<td align=\"right\"><a href=\"".getlink($module_name . "&view=week&date=" . adodb_date ("Ymd", $next ) ) ."\">&gt;&gt;</a></td>";
		echo "</tr>"
			."</table>"
			."<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">"
			."<tr><td class=\"calendarbg\">"
			."<table border=\"0\" width=\"100%\" cellspacing=\"1\" cellpadding=\"2\">"
			."<tr>"
			."<td width=12% class=\"calendarday\">&nbsp;</td>";

		for ( $d = 0; $d < 7; $d++ ) {
			echo "<th width=\"13%\">$colheader[$d]</th>\n";
		}

		echo "</tr>";

		$first_hour = $cal_config['workday_start'];
		$last_hour = $cal_config['workday_end'];
		$untimed_found = false;
		for ( $d = 0; $d < 7; $d++ ) {
			$hour_arr = Array ();
			$rowspan_arr = Array ();
			$date = adodb_date ( "Ymd", $days[$d] );

			print_day_events( $date );

			// squish events that use the same cell into the same cell.
			// For example, an event from 8:00-9:15 and another from 9:30-9:45 both
			// want to show up in the 8:00-9:59 cell.
			$rowspan = 0;
			$last_row = -1;
			for ( $i = 0; $i < 24; $i++ ) {
				if ( $rowspan > 1 ) {
					if ( ! empty ( $hour_arr[$i] ) ) {
						if ( $rowspan_arr[$i] > 1 ) {
							$rowspan_arr[$last_row] += ( $rowspan_arr[$i] - 1 );
							$rowspan += ( $rowspan_arr[$i] - 1 );
						} else {
							$rowspan_arr[$last_row] += $rowspan_arr[$i];
						}
			// this will move entries apart that appear in one field,
			// yet start on different hours
						$start_time = $i;
						$diff_start_time = $start_time - $last_row;
						for ( $u = $diff_start_time ; $u > 0 ; $u-- ) 
						$hour_arr[$last_row] .= "<br />"; 
						$hour_arr[$last_row] .= $hour_arr[$i];
						$hour_arr[$i] = "";
						$rowspan_arr[$i] = 0;
					}
					$rowspan--;
				} elseif ( ! empty ( $rowspan_arr[$i] ) && $rowspan_arr[$i] > 1 ) {
					$rowspan = $rowspan_arr[$i];
					$last_row = $i;
				}
			}

  // now save the output...
			if ( ! empty ( $hour_arr[99] ) && strlen ( $hour_arr[99] ) ) {
				$untimed[$d] = "<td width=\"12%\" class=\"calendarday\">$hour_arr[99]</td>\n";
				$untimed_found = true;
			}
			$save_hour_arr[$d] = $hour_arr;
			$save_rowspan_arr[$d] = $rowspan_arr;
		}

// untimed events first
		if ( $untimed_found ) {
			echo "<tr><td width=\"12%\" class=\"calendartime\">"._ALLDAY."</td>";
			for ( $d = 0; $d < 7; $d++ ) {
				if ( ! empty ( $untimed[$d] ) && strlen ( $untimed[$d] ) ) {
					echo $untimed[$d];
				} else {
					echo "<td width=\"12%\" class=\"calendarday\">&nbsp;</td>";
				}
			}
			echo "</tr>\n";
		}

		for ( $d = 0; $d < 7; $d++ ) {
			$rowspan_day[$d] = 0;
		}

		for ( $i = $first_hour; $i <= $last_hour; $i++ ) {
			$time = display_time ( $i * 10000 );
			echo "<tr><td valign=\"top\" width=\"13%\" class=\"calendartime\">" . $time . "</td>\n";
			for ( $d = 0; $d < 7; $d++ ) {
				if ( adodb_date ( "Ymd", $days[$d] ) == adodb_date ( "Ymd", $today ) ) {
					$color = "class=\"calendartoday\"";
				} else {
					$color = "class=\"calendarday\"";
				}
//				echo "$d<br />";
//				echo "$i<br />";
//				echo implode(",", $save_rowspan_arr[$d][$i]) . "<br />";
//				$x = $save_rowspan_arr[$d][$i];
				if ( $rowspan_day[$d] > 1 ) {
				// this might mean there's an overlap, or it could mean one event
				// ends at 11:15 and another starts at 11:30.
					if ( ! empty ( $save_hour_arr[$d][$i] ) ) {
						echo "<td valign=\"top\" width=\"12%\" $color><font size=\"-1\">" . $save_hour_arr[$d][$i] . "</font></td>";
					}
					$rowspan_day[$d]--;
				} else {
					if ( empty ( $save_hour_arr[$d][$i] ) ) {
						echo "<td valign=\"top\" width=\"12%\" $color>&nbsp;</td>\n";
					} else {
						$rowspan_day[$d] = $save_rowspan_arr[$d][$i];
						if ( $rowspan_day[$d] > 1 ) {
							echo "<td valign=\"top\" width=\"12%\" valign=\"top\" $color rowspan=\"$rowspan_day[$d]\">"
							."<font size=\"-1\">" . $save_hour_arr[$d][$i] . "</font></td>\n";
						} else {
							echo "<td valign=\"top\" width=\"12%\" $color><font size=\"-1\">" .	$save_hour_arr[$d][$i] . "</font></td>\n";
						}
					}
				}
			}
			echo "</tr>\n";
		}

		echo "</table>"
			."</td></tr>"
			."<tr><td align=\"right\">"
			.jumpToDate(adodb_date ( "Ymd", $selectedday ))
			."</td></tr>"
			."</table>";

		CloseTable();
	}

	function view_day($date) {
		global $module_name, $cal_config, $userinfo;
		require_once('header.php');
		OpenTable();
		echo '<table border="0" width="100%">'
			.'<tr><td valign="top" width="100%">'
			.'<table border="0" width="100%">'
			.'<tr>'
			.'<td class="calendartitle" align="center">'
			.adodb_date( remove_time($userinfo['user_dateformat']),  $date)
			.'</td>'
			.'</tr>'
			.'</table>'
			.'<table border="0" width="100%" cellspacing="0" cellpadding="0">'
			.'<tr><td class="calendarbg">'
			.'<table border="0" width="100%" cellspacing="1" cellpadding="2">';

		print_daily_events ( adodb_date ( "Ymd", $date ) );
		echo '</tr>'
			.'</table>'
			.'</td></tr></table>'
			.'</td>'
			.'<td valign="top">';

		small_month(adodb_date ( "m", $date ), adodb_date ( "Y", $date ));

		if ($cal_config['update'] == 0 || in_group($cal_config['update']-3) || ($cal_config['update'] == 1 && is_user()) || can_admin($module_name)) {
			echo "<br /><br /><br /><form action=\"". getlink($module_name ."&amp;view=add_event") . "\" method=\"post\" name=\"addeventform\">\n"
				."<input type=\"hidden\" name=\"date\" value=\"" . adodb_date ( "Ymd", $date ) . "\" />"
				."<input type=\"submit\" value=\""._CALADDEVENT."\" />"
				."</form>";
		}

		echo "</td></tr>"
			."<tr><td align=\"right\">"
			.jumpToDate(adodb_date ( "Ymd", $date ))
			."</td></tr>"
			."</table>";
		CloseTable();
	}

	function view_event($date) {
		global $cal_prefix, $db, $module_name, $cal_config, $calcategories, $userinfo;
		$id = isset($_POST['id']) ? intval($_POST['id']) : (isset($_GET['id']) ? intval($_GET['id']) : '');
		// make sure this is not a read-only calendar
		require_once('header.php');
		require_once('includes/nbbcode.php');
		OpenTable();
		if ( ! empty ( $id ) && $id > 0 ) {
		  $sql = "SELECT date, time, mod_date, " .
			"mod_time, duration, priority, type, view, " .
			"name, description, image, creator, approved, category FROM ".$cal_prefix." WHERE eid = " . $id;
		  $res = $db->sql_query ( $sql );
		  if ( $res ) {
			$row = $db->sql_fetchrow ( $res );
			$cal_date = $row[0];
			$year = substr ( $cal_date, 0, 4 );
			$month = substr ( $cal_date, 4, 2 );
			$day = substr ( $cal_date, 6, 2 );
			$time = $row[1];
			if ( $time >= 0 ) {
			  $hour = floor($time / 10000);
			  $minute = ( $time / 100 ) % 100;
			  $duration = $row[4];
			} else {
			  $duration = "";
			}
			$priority = $row[5];
			$type = $row[6];
			$view = $row[7];
			$name = $row[8];

			//$description = $row[9];
			$description = decode_bb_all($row[9], 1, true);
			$image = $row[10];
			$creator = $row[11];
			$approved = $row[12];
			$category = $row[13];
			if ($date) {
				$sql = "SELECT name, description 
				FROM ".$cal_prefix."_repeat_desc 
				WHERE eid = '$id' AND date = '$date'";
				$descres = $db->sql_query ( $sql );
				if ( $db->sql_numrows($db->sql_query ( $sql ) ) <> 0 ) {
					$descrow = $db->sql_fetchrow ( $descres );
					$name = $descrow[0];
					$description = decode_bb_all($descrow[1], 1, true);
				}
			}
			// check for repeating event info...
			if ($type == "R"){
				$res = $db->sql_query ( "SELECT eid, type, end, " .
				  "frequency, days FROM ".$cal_prefix."_repeat " .
				  "WHERE eid = $id" );
				if ( $res ) {
				  if ( $row = $db->sql_fetchrow ( $res ) ) {
					$rpt_type = $row[1];
					if ( $row[2] > 0 ) {
					  $rpt_end = date_to_epoch ( $row[2] );
					} else {
					  $rpt_end = 0;
					}
					$rpt_end_date = $row[2];
					if ($rpt_end_date > 0) {
						$endyear = substr ( $rpt_end_date, 0, 4 );
						$endmonth = substr ( $rpt_end_date, 4, 2 );
						$endday = substr ( $rpt_end_date, 6, 2 );
					}
					$rpt_freq = $row[3];
					$rpt_days = $row[4];
					$byDay = array();
					if ($rpt_type == 'weekly') {
						$rpt_sun  = ( substr ( $rpt_days, 0, 1 ) == 'y' );
						$rpt_mon  = ( substr ( $rpt_days, 1, 1 ) == 'y' );
						$rpt_tue  = ( substr ( $rpt_days, 2, 1 ) == 'y' );
						$rpt_wed  = ( substr ( $rpt_days, 3, 1 ) == 'y' );
						$rpt_thu  = ( substr ( $rpt_days, 4, 1 ) == 'y' );
						$rpt_fri  = ( substr ( $rpt_days, 5, 1 ) == 'y' );
						$rpt_sat  = ( substr ( $rpt_days, 6, 1 ) == 'y' );
					} else if ($rpt_type == 'monthlyByDay') {
						$byDay = explode(",", $rpt_days);
						$rpt_select_option = $byDay[0];
						$rpt_select_day = $byDay[1];
					} else if ($rpt_type == 'yearlyByDay') {
						$byDay = explode(",", $rpt_days);
						$rpt_select_option = $byDay[0];
						$rpt_select_day = $byDay[1];
						$rpt_select_month = $byDay[2];
					}
				  }
				}
			}
			
		  }
		} else {
//		  $id = 0; // to avoid warnings below about use of undefined var
		  $time = -1;
		}
		if ( ! empty ( $year ) && $year )
		  $thisyear = $year;
		if ( ! empty ( $month ) && $month )
		  $thismonth = $month;
		if ( ! empty ( $day ) && $day )
		  $thisday = $day;
		if ( empty ( $rpt_type ) || ! $rpt_type )
		  $rpt_type = "none";

		$rpt_subtype = "";
		if ( $rpt_type == "monthlyByDay" ) {
			$rpt_type = "monthly";
			$rpt_subtype = "monthlyByDay";
		}
		if ( $rpt_type == "yearlyByDay" ) {
			$rpt_type = "yearly";
			$rpt_subtype = "yearlyByDay";
		}

		// avoid error for using undefined vars
		if ( empty ( $hour ) )
		  $hour = 0;
		if ( empty ( $duration ) )
		  $duration = 0;
		if ( empty ( $name ) )
		  $name = "";
		if ( empty ( $description ) )
		  $description = "";
		if ( empty ( $priority ) )
		  $priority = 0;
		if ( empty ( $rpt_freq ) )
		  $rpt_freq = 0;
		if ( empty ( $rpt_end_date ) )
		  $rpt_end_date = 0;

		if ( ( empty ( $year ) || ! $year ) &&
		  ( empty ( $month ) || ! $month ) &&
		  ( ! empty ( $date ) && strlen ( $date ) ) ) {
		  $thisyear = $year = substr ( $date, 0, 4 );
		  $thismonth = $month = substr ( $date, 4, 2 );
		  $thisday = $day = substr ( $date, 6, 2 );
		  $cal_date = adodb_date ( "Ymd", $date );
		} else {
		  if ( empty ( $cal_date ) ) {
			$cal_date = adodb_date ( "Ymd" );
		  }
		}

		$thisdate = sprintf ( "%04d%02d%02d", $thisyear, $thismonth, $thisday );
		if ( empty ( $cal_date ) || ! $cal_date ) {
		  $cal_date = $thisdate;
		}
		$image_dir = "modules/$module_name/images/";
		echo "<table border=\"0\" width=\"100%\" cellpadding=\"3\" cellspacing=\"2\">"
			."  <tr><th colspan=\"2\" class=\"calendarhead\">"._CALVIEWEVENT."</th></tr>"
			."	<tr><td align=\"right\" width=\"15%\"><b>"._CALDATE.": </b></td>"
			."	<td>".substr ( $date, 4, 2 )."/".substr ( $date, 6, 2 )."/".substr ( $date, 0, 4 )."</td></tr>"
			."	<tr><td align=\"right\"><b>"._CALEVENTNAME.": </b></td>"
			."	<td>" . htmlspecialchars ( $name )
			." <img src=\"$image_dir$image\" name=\"sample\" style=\"vertical-align:middle\" />"
			."</td></tr>";

		echo "	<tr><td align=\"right\"><b>"._CALSTARTTIME.": </b></td><td>";
		if ($time > 0) {
			echo display_time ( $time );
		} else {
			echo _ALLDAY;
		}
		echo "</td></tr>";

		if ( $duration > 0 ) {
			// calc end time
			$h = (int) ( $time / 10000 );
			$m = ( $time / 100 ) % 100;
			$m += $duration;
			$d = $duration;
			while ( $m >= 60 ) {
				$h++;
				$m -= 60;
			}
			$end_time = sprintf ( "%02d%02d00", $h, $m );

			echo "<tr><td align=\"right\"><b>"._CALENDTIME.": </b></td>"
				."<td>".display_time ( $end_time )
				."</td></tr>";
		}

		if ($creator == $userinfo['username'] || can_admin($module_name) ) {
			echo "	<tr><td align=\"right\"><b>"._CALCATEGORY.": </b></td>"
				."	<td>" . $calcategories[$category]['title'] . "</td></tr>";

			if ($view == 0) {
				$groupName = _MVALL;
			} elseif ($view == 1) {
				$groupName = _MVUSERS;
			} elseif ($view == 2) {
				$groupName = _MVADMIN;
			} elseif ($view == 3) {
				$groupName = _MVANON;
			} elseif ($view >3) {		 // <= phpBB User Groups Integration
				list($groupName) = $db->sql_ufetchrow("SELECT group_name FROM ".$prefix."_bbgroups WHERE group_id=".($view - 3), SQL_NUM, __FILE__, __LINE__);
			} else
				$groupName = _CALPRIVATE;

			echo "	<tr><td align=\"right\"><b>"._CALVISIBLE.": </b></td>"
				."	<td>" . $groupName . "</td></tr>";

			if ($type == "R") {
				echo "	<tr><td align=\"right\"><b>"._CALPATTERN.": </b></td>";
				if ($rpt_type == 'daily') {
					echo "	<td>" . _CALEVERY . " " . $rpt_freq . " " . _CALDAYS . "</td></tr>";
				} elseif ($rpt_type == 'weekly') {
					echo "	<td>" . _CALEVERY . " " . $rpt_freq . " " . _CALWEEKS . " ";
					echo $rpt_sun  == 'y' ? _SUNDAY." " : "";
					echo $rpt_mon  == 'y' ? _MONDAY." " : "";
					echo $rpt_tue  == 'y' ? _TUESDAY." " : "";
					echo $rpt_wed  == 'y' ? _WEDNESDAY." " : "";
					echo $rpt_thu  == 'y' ? _THURSDAY." " : "";
					echo $rpt_fri  == 'y' ? _FRIDAY." " : "";
					echo $rpt_sat  == 'y' ? _SATURDAY." " : "";
					echo "</td></tr>";
				} elseif ($rpt_type == 'monthly') {
					echo "	<td>" . _CALEVERY . " " . $rpt_freq . " " . _CALMONTHS . " ";
					if ($rpt_subtype == "monthlyByDay") {
						echo _CALONTHE . " " . ($rpt_select_option == "+1" ? _SECOND : $rpt_select_option) . " " . $rpt_select_day . " " . _CALOFTHEMONTH;
					}
					echo "</td></tr>";
				} elseif ($rpt_type == 'yearly') {
					echo "	<td>" . _CALEVERY . " " . $rpt_freq . " " . _CALYEARS . " ";
					if ($rpt_subtype == "yearlyByDay") {
						echo _CALONTHE . " " . ($rpt_select_option == "+1" ? _SECOND : $rpt_select_option) . " " . $rpt_select_day . " " . _CALOF . " " . month_name($rpt_select_month - 1);
					}
					echo "</td></tr>";
				}
				echo "	<tr><td align=\"right\"><b>"._CALSTARTDATE.": </b></td>"
					."	<td>$month/$day/$year</td></tr>";

				if ($rpt_end != 0) {
					echo "	<tr><td align=\"right\"><b>"._CALENDBY.": </b></td>"
						."	<td>$endmonth/$endday/$endyear</td></tr>";
				}
			}
			echo "	<tr><td align=\"right\"><b>"._CALSTATUS.": </b></td>"
				."	<td>".($approved > 0 ? _CALAPPROVED : _CALWAITING)."</td></tr>";
		}

		if ($description != $name)
		echo "	<tr><td valign=\"top\" colspan=\"2\"><fieldset><legend>"._CALDESCRIPTION."</legend>"
			. $description . "</fieldset></td></tr>";
		
		// if (all users can update OR 
		//user in a group that can update OR 
		//all registered users can update and current user is a registered user) AND
		//(current user is event creator or calendar admin)
		//then display edit button.
/*		if (($cal_config['update'] == 0 || 
			in_group($cal_config['update']-3) || 
			($cal_config['update'] == 1 && is_user())) &&
			($creator == $userinfo['username'] || can_admin($module_name) )) {
*/
		if ($creator == $userinfo['username'] || can_admin($module_name) || in_group($cal_config['admin_events']-3)) {
			echo "<tr><td colspan=\"2\" align=\"center\"><form action=\"". getlink($module_name ."&view=edit_event") . "\" method=\"post\" name=\"editeventform\">\n"
			."<input type=\"hidden\" name=\"creator\" value=\"$creator\" />"
			."<input type=\"hidden\" name=\"date\" value=\"$date\" />"
			."<input type=\"hidden\" name=\"id\" value=\"$id\" />"
			."<input type=\"submit\" value=\""._CALEDITEVENT."\" />"
			."</form></td></tr>";
		}
		echo "</table>";

		CloseTable();
	}

	function edit_event($date) {
		global $cal_prefix, $db, $module_name, $cal_config, $calcategories, $userinfo;
		$id = isset($_POST['id']) ? intval($_POST['id']) : (isset($_GET['id']) ? intval($_GET['id']) : '');
		$creator = isset($_POST['creator']) ? $_POST['creator'] : '';
		// make sure this is not a read-only calendar
		require_once('header.php');
		require_once('includes/nbbcode.php');
		OpenTable();
		$rpt_select_option = _FIRST;
		$rpt_select_day = _DAY;
		$rpt_select_month = _JANUARY;
		if ( !empty($id) && ($id > 0) && ($creator == $userinfo['username'] || can_admin($module_name) || in_group($cal_config['admin_events']-3)) ) {
		  $sql = "SELECT date, time, mod_date, " .
			"mod_time, duration, priority, type, view, " .
			"name, description, image, category FROM ".$cal_prefix." WHERE eid = " . $id;
		  $res = $db->sql_query ( $sql );
		  if ( $res ) {
			$row = $db->sql_fetchrow ( $res );
			$cal_date = $row[0];
			$year = (int) ( $cal_date / 10000 );
			$month = ( $cal_date / 100 ) % 100;
			$day = $cal_date % 100;
			$time = $row[1];
			if ( $time >= 0 ) {
			  $hour = floor($time / 10000);
			  $minute = ( $time / 100 ) % 100;
			  $duration = $row[4];
			} else {
			  $duration = "";
			}
			$priority = $row[5];
			$type = $row[6];
			$view = $row[7];
			$name = $row[8];
			$description = $row[9];
			$image = $row[10];
			$category = $row[11];
			$sql = "SELECT name, description FROM ".$cal_prefix."_repeat_desc WHERE eid = " . $id . " AND date = $date";
			$descres = $db->sql_query ( $sql );
			if ( $db->sql_numrows($db->sql_query ( $sql ) ) <> 0 ) {
				$descrow = $db->sql_fetchrow ( $descres );
				$name = $descrow[0];
				$description = $descrow[1];
			}

			// check for repeating event info...
			if ($type == "R"){
				$res = $db->sql_query ( "SELECT eid, type, end, " .
				  "frequency, days FROM ".$cal_prefix."_repeat " .
				  "WHERE eid = $id" );
				if ( $res ) {
				  if ( $row = $db->sql_fetchrow ( $res ) ) {
					$rpt_type = $row[1];
					if ( $row[2] > 0 )
					  $rpt_end = date_to_epoch ( $row[2] );
					else
					  $rpt_end = '';
					$rpt_end_date = $row[2];
					$rpt_freq = $row[3];
					$rpt_days = $row[4];
					$byDay = array();
					if ($rpt_type == 'weekly') {
						$rpt_sun  = ( substr ( $rpt_days, 0, 1 ) == 'y' );
						$rpt_mon  = ( substr ( $rpt_days, 1, 1 ) == 'y' );
						$rpt_tue  = ( substr ( $rpt_days, 2, 1 ) == 'y' );
						$rpt_wed  = ( substr ( $rpt_days, 3, 1 ) == 'y' );
						$rpt_thu  = ( substr ( $rpt_days, 4, 1 ) == 'y' );
						$rpt_fri  = ( substr ( $rpt_days, 5, 1 ) == 'y' );
						$rpt_sat  = ( substr ( $rpt_days, 6, 1 ) == 'y' );
					} elseif ($rpt_type == 'monthlyByDay') {
						$byDay = explode(",", $rpt_days);
						$rpt_select_option = $byDay[0];
						$rpt_select_day = $byDay[1];
					} elseif ($rpt_type == 'yearlyByDay') {
						$byDay = explode(",", $rpt_days);
						$rpt_select_option = $byDay[0];
						$rpt_select_day = $byDay[1];
						$rpt_select_month = $byDay[2];
					}
				  }
				}
			}
			
		  }
		} elseif ($cal_config['update'] == 0 || in_group($cal_config['update']-3) || 
		($cal_config['update'] == 1 && is_user()) || can_admin($module_name)) {
		  //New Event
//		  $id = 0; // to avoid warnings below about use of undefined var
		  $id = NULL;
		  $type = "E";
		  $category = "";
		  $image = "circle.gif";
		  $time = -1;
		} else {
			cpg_error('You don\'t have permission to add or edit events.');
		}

		if ( ! empty ( $year ) && $year )
		  $thisyear = $year;
		if ( ! empty ( $month ) && $month )
		  $thismonth = $month;
		if ( ! empty ( $day ) && $day )
		  $thisday = $day;
		if ( empty ( $rpt_type ) || ! $rpt_type )
		  $rpt_type = "none";

		$rpt_subtype = "";
		if ( $rpt_type == "monthlyByDay" ) {
			$rpt_type = "monthly";
			$rpt_subtype = "monthlyByDay";
		}
		if ( $rpt_type == "yearlyByDay" ) {
			$rpt_type = "yearly";
			$rpt_subtype = "yearlyByDay";
		}

		// avoid error for using undefined vars
		if ( empty ( $hour ) )
		  $hour = 0;
		if ( empty ( $duration ) )
		  $duration = 0;
		if ( empty ( $name ) )
		  $name = "";
		if ( empty ( $description ) )
		  $description = "";
		if ( empty ( $priority ) )
		  $priority = 0;
		if ( empty ( $view ) )
		  $view = "";
		if ( empty ( $rpt_end_date ) )
		  $rpt_end_date = 0;

		$rpt_daily_freq = (strcmp ( $rpt_type, 'daily' ) == 0 ) ? $rpt_freq : 1;
		$rpt_weekly_freq = (strcmp ( $rpt_type, 'weekly' ) == 0 ) ? $rpt_freq : 1;
		$rpt_monthly_freq = (strcmp ( $rpt_type, 'monthly' ) == 0 ) ? $rpt_freq : 1;
		$rpt_yearly_freq = (strcmp ( $rpt_type, 'yearly' ) == 0 ) ? $rpt_freq : 1;

		if ( ( empty ( $year ) || ! $year ) &&
		  ( empty ( $month ) || ! $month ) &&
		  ( ! empty ( $date ) && strlen ( $date ) ) ) {
		  $thisyear = $year = substr ( $date, 0, 4 );
		  $thismonth = $month = substr ( $date, 4, 2 );
		  $thisday = $day = substr ( $date, 6, 2 );
		  $cal_date = $date;
		} else {
		  if ( empty ( $cal_date ) ) {
			$cal_date = adodb_date ( "Ymd" );
		  }
		}
		$thisdate = sprintf ( "%04d%02d%02d", $thisyear, $thismonth, $thisday );
		if ( empty ( $cal_date ) || ! $cal_date )
		  $cal_date = $thisdate;
		echo "<script type=\"text/javascript\">\n"
			."function validate_and_submit () {\n"
			."	if ( document.editeventform.name.value == \"\" ) {\n"
			."		alert ( \"You have not entered a Brief Description.\" );\n"
			."		return false;\n"
			."	}\n";
		if ($type == "E" && $cal_date == $date){
			echo"	h = parseInt ( document.editeventform.hour.value );\n"
				."	m = parseInt ( document.editeventform.minute.value );\n";
				if ($cal_config['time_format'] == "12") {
			echo	"	if ( document.editeventform.ampm[1].checked ) {\n"
					."		// pm\n"
					."		if ( h < 12 ){\n"
					."			h += 12;\n"
					."		} else {\n"
					."		// am\n"
					."			if ( h == 12 )\n"
					."				h = 0;\n"
					."		}\n"
					."	}\n";
				}
			echo "	if ( h > 24 || m > 59 ) {\n"
				."		alert ( \"You have not entered a valid time of day\" );\n"
				."		return false;\n"
				."	}\n";
			  // Ask for confirmation for time of day if it is before the user's
			  // preference for work hours.
				if ($cal_config['time_format'] == "24") {
					  echo "if ( h < " . $cal_config['workday_start'] . "  ) {\n";
				}  else {
					  echo "if ( h < " . $cal_config['workday_start'] . " && document.editeventform.ampm[0].checked ) {\n";
				}
			echo "	if ( ! confirm ( \"The time you have entered begins before your preferred work hours.  Is this correct?\"))\n"
				."		return false;\n"
				."}\n";
			  // is there really a change?
			echo "	changed = false;\n"
				."	form=document.editeventform;\n"
				."	for ( i = 0; i < form.elements.length; i++ ) {\n"
				."		field = form.elements[i];\n"
				."		switch ( field.type ) {\n"
				."			case \"radio\":\n"
				."			case \"checkbox\":\n"
				."				if ( field.checked != field.defaultChecked )\n"
				."					changed = true;\n"
				."				break;\n"
				."			case \"text\":\n"
			//      case "textarea":
				."				if ( field.value != field.defaultValue )\n"
				."					changed = true;\n"
				."				break;\n"
				."			case \"select-one\":\n"
			//      case "select-multiple":
				."				for( j = 0; j < field.length; j++ ) {\n"
				."					if ( field.options[j].selected != field.options[j].defaultSelected )\n"
				."						changed = true;\n"
				."				}\n"
				."				break;\n"
				."		}\n"
				."	}\n"
				."	if ( changed ) {\n"
				."		form.entry_changed.value = \"yes\";\n"
				."	}\n";
			}
		  // would be nice to also check date to not allow Feb 31, etc...
		echo "	document.editeventform.submit ();\n"
			."	return true;\n"
			."}\n\n"
			."function selectDate ( formday, formmonth, formyear, currentdate ) {\n"
			."	if ( W3C ) {\n"
			."		dayele = document.getElementById(formday);\n"
			."		monthele = document.getElementById(formmonth);\n"
			."		yearele = document.getElementById(formyear);\n"
			."	} else if ( NS4 ) {\n"
			."		dayele = document.layers[formday];\n"
			."		monthele = document.layers[formmonth];\n"
			."		yearele = document.layers[formyear];\n"
			."	} else { // IE4\n"
			."		dayele = document.all[formday];\n"
			."		monthele = document.all[formmonth];\n"
			."		yearele = document.all[formyear];\n"
			."	}\n"
			."  selected_year = yearele.options[yearele.options.selectedIndex].value;\n"
			."  selected_month = monthele.options[monthele.options.selectedIndex].value;\n"
			."  if (selected_month.length < 2) selected_month = '0' + selected_month;\n"
			."  selected_day = dayele.options[dayele.options.selectedIndex].value;\n"
			."  if (selected_day.length < 2) selected_day = '0' + selected_day;\n"
			."	url = \"" . getlink($module_name . "&view=popup&form=editeventform&day=\" + formday + \"&month=\" + formmonth + \"&year=\" + formyear + \"&date=THEDATE", true, true) . "\";\n"
			."  url = url.replace(\"THEDATE\", selected_year+selected_month+selected_day);\n"
			."	window.open( url, \"DateSelection\", \"width=200,height=176,resizable=no,scrollbars=no\" );\n"
			."}\n"
			."</script>\n";

		echo "<form action=\"". getlink($module_name. "&amp;view=save_event") . "\" method=\"post\" name=\"editeventform\">\n";
		echo '<table border="0">'
			.'<tr><td class="calendartitle">';
		if ( isset ($id) ) {
			echo _CALEDITEVENT;
		} else {
			echo _CALADDEVENT;
		}
		if ( isset($id) ) {
			echo "<input type=\"hidden\" name=\"id\" value=\"$id\" />\n";
		}
		// we need an additional hidden input field
		echo "<input type=\"hidden\" name=\"entry_changed\" value=\"\" />\n";
		echo "  </td></tr>\n"
			."	<tr><td valign=\"top\"><b>"._CALSELECTEDDATE.":</b></td>"
			."	<td>".substr ( $date, 4, 2 )."/".substr ( $date, 6, 2 )."/".substr ( $date, 0, 4 )."</td></tr>"
			."	<tr><td><b>"._CALEVENTNAME.":</b></td>"
			."	<td><input name=\"event\" size=\"25\" value=\"" . htmlspecialchars ( $name ) . "\" /></td></tr>"
			."	<tr><td valign=\"top\"><b>"._CALDESCRIPTION.":</b></td>";
		$desc_bbtable = bbcode_table('description', 'editeventform', 1);
		echo "<td>$desc_bbtable"
			."<textarea name=\"description\" rows=\"15\" cols=\"80\" wrap=\"virtual\">" . $description . "</textarea></td></tr>";
		if ($type == "R" && $cal_date != $date){
			echo "<tr><td valign=\"top\"><b>"._CALSTARTDATE.":</b></td>"
				."<td><input type=\"hidden\" name=\"edit_date\" value=\"$date\" />"
				."<input type=\"hidden\" name=\"recurring_event\" value=\"nochange\" />"
				."<input type=\"hidden\" name=\"rpt_type\" value=\"nochange\" />"
				."<a href=\"". getlink($module_name . "&amp;view=edit_event&amp;id=$id&amp;date=$cal_date") . "\">$month/$day/$year</a> - "._CALCLICKHERE."</td></tr>";
		} else {
			echo "	<tr><td><b>"._CALSTARTTIME.":</b></td>";

		$h12 = $hour;
		$amsel = "checked=\"checked\""; $pmsel = "";
		if ( $cal_config['time_format'] == "12" ) {
		  if ( $h12 < 12 ) {
			$amsel = "checked=\"checked\""; $pmsel = "";
		  } else {
			$amsel = ""; $pmsel = "checked=\"checked\"";
		  }
		  $h12 %= 12;
		  if ( $h12 == 0 ) {
		  	$h12 = 12;
		  }
		}
		if ( $time < 0 ) {
		  $h12 = "";
		}
		echo "	<td><input name=\"hour\" size=\"2\" value=\"". $h12 . "\" maxlength=\"2\" />:<input name=\"minute\" size=\"2\" value=\"";
		if ( $time >= 0 ) {
			printf ( "%02d", $minute );
		}
		echo "\" maxlength=\"2\" />";

		if ( $cal_config['time_format'] == "12" ) {
		  echo "<input type=\"radio\" name=\"ampm\" value=\"am\" ".$amsel." />am\n";
		  echo "<input type=\"radio\" name=\"ampm\" value=\"pm\" ".$pmsel." />pm\n";
		}

		echo "</td></tr>";

		$dur_h = (int)( $duration / 60 );
		$dur_m = $duration - ( $dur_h * 60 );
		echo "<tr><td><b>"._CALDURATION.":</b></td>"
			."<td><input name=\"dhour\" size=\"2\" value=\"$dur_h\" />:"
			."<input name=\"dminute\" size=\"2\" value=\"$dur_m\" /> (hours:minutes)</td></tr>";

		$image_dir = "modules/$module_name/images/";
		$pic_array = array();

		echo "<tr><td><b>"._CALCATEGORY.":</b></td>"
			."<td><select name=\"evt_type\" onchange=\"makeSuggestions('$image_dir', document.editeventform.evt_type.options[document.editeventform.evt_type.options.selectedIndex].id);\">";


		$keys = array_keys($calcategories); 
		$default = (empty($category) ? $cal_config['default_category'] : $calcategories[$category]['title']);
		for ($i=0; $i < sizeof($keys); $i++) {
			echo "	<option value=\"" . $calcategories[$keys[$i]]['catid'] . "\" id=\"" . $calcategories[$keys[$i]]['catid'] . "\"" . ($default == $calcategories[$keys[$i]]['title'] ? " selected=\"selected\"" : "") . " image=\"".$calcategories[$keys[$i]]['image']."\" priority=\"".$calcategories[$keys[$i]]['priority']."\">" . $calcategories[$keys[$i]]['title']. "</option>";
		}

		echo "</select></td></tr>";

		get_calendar_images($image_dir, $pic_array);

		echo "<tr><td><b>"._CALIMAGE.":</b></td>"
			."<td><select onchange=\"changeImage('".$image_dir."', document.editeventform.evt_img.options[document.editeventform.evt_img.selectedIndex].value);\" name=\"evt_img\">";

		foreach ($pic_array as $picture) {
			echo "	<option value=\"$picture\"". (strcmp($image, $picture) == 0 ? " selected=\"selected\"" : "") . ">$picture</option>";
		}
		echo "</select> <img src=\"$image_dir$image\" name=\"sample\" alt=\""._CATADMIN_SAMPLE_IMAGE."\" /></td></tr>";

		echo "<tr><td><b>"._CALPRIORITY.":</b></td>"
			."<td><select name=\"priority\">"
			."	<option value=\"1\"". ( $priority == 1 ? " selected=\"selected\"": "").">Low</option>"
			."	<option value=\"2\"". ( $priority == 2 ? " selected=\"selected\"": "").">Medium</option>"
			."	<option value=\"3\"". ( $priority == 3 ? " selected=\"selected\"": "").">High</option>"
			."</select></td></tr>";

		echo "<tr><td><b>"._CALVISIBLE.":</b></td>"
			."<td>".group_selectbox('view', $view)
			."<input type=\"checkbox\" name=\"private\" value=\"-1\"".($view == -1 ? " checked=\"checked\"" : "")
			." />"._CALPRIVATE."</td></tr>";

		echo "<tr><td valign=\"top\" colspan=\"2\">"
			."<input type=\"checkbox\" name=\"recurring_event\" value=\"1\"" . ( $rpt_type != "none"  ? " checked=\"checked\"" : "" )
			." onclick=\"toggle('recurring');\" />"._CALRECURR
			."<div id=\"recurring\" style=\"display:" . ( $rpt_type != "none"  ? "inline" : "none" ) . ";\">"
			."<fieldset><legend>"._CALPATTERN."</legend>"
			."<table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"100%\">"
			."<tr><td style=\"border-right:1px solid; white-space:nowrap; width:15%;\" valign=\"top\">"
			."<input type=\"radio\" name=\"rpt_type\" value=\"daily\"" . ( strcmp ( $rpt_type, 'daily' ) == 0 ? " checked=\"checked\"" : "" ) . " onclick=\"showRecurProperties('daily');\" /> <b>"._CALDAILY."</b><br /><br />"
			."<input type=\"radio\" name=\"rpt_type\" value=\"weekly\"" . ( strcmp ( $rpt_type, 'weekly' ) == 0 ? " checked=\"checked\"" : "" ) . " onclick=\"showRecurProperties('weekly');\" /> <b>"._CALWEEKLY."</b><br /><br />"
			."<input type=\"radio\" name=\"rpt_type\" value=\"monthly\"" . ( strcmp ( $rpt_type, 'monthly' ) == 0 ? " checked=\"checked\"" : "" ) . " onclick=\"showRecurProperties('monthly');\" /> <b>"._CALMONTHLY."</b><br /><br />"
			."<input type=\"radio\" name=\"rpt_type\" value=\"yearly\"" . ( strcmp ( $rpt_type, 'yearly' ) == 0 ? " checked=\"checked\"" : "" ) . " onclick=\"showRecurProperties('yearly');\" /> <b>"._CALYEARLY."</b><br />"
			."</td><td style=\"white-space:nowrap;\">";

		echo "<div id=\"daily\" style=\"display:" . ( strcmp ( $rpt_type, 'daily' ) == 0 ? "inline" : "none" ) . ";\">"
			." "._CALEVERY." <input name=\"rpt_daily_freq\" size=\"4\" maxlength=\"4\" value=\"" . $rpt_daily_freq . "\" /> "._CALDAYS."."
			."</div>";

		echo "<div id=\"weekly\" style=\"display:" . ( strcmp ( $rpt_type, 'weekly' ) == 0 ? "inline" : "none" ) . ";\">"
			." "._CALEVERY." <input name=\"rpt_weekly_freq\" size=\"4\" maxlength=\"4\" value=\"" . $rpt_weekly_freq . "\" /> "._CALWEEKS.":<br />"
			."<input type=\"checkbox\" name=\"rpt_sun\" value=\"y\" " . (!empty($rpt_sun)?" checked=\"checked\"":"") . " /> ". _SUNDAY
			."<input type=\"checkbox\" name=\"rpt_mon\" value=\"y\" " . (!empty($rpt_mon)?" checked=\"checked\"":"") . " /> ". _MONDAY
			."<input type=\"checkbox\" name=\"rpt_tue\" value=\"y\" " . (!empty($rpt_tue)?" checked=\"checked\"":"") . " /> ". _TUESDAY
			."<input type=\"checkbox\" name=\"rpt_wed\" value=\"y\" " . (!empty($rpt_wed)?" checked=\"checked\"":"") . " /> ". _WEDNESDAY
			."<input type=\"checkbox\" name=\"rpt_thu\" value=\"y\" " . (!empty($rpt_thu)?" checked=\"checked\"":"") . " /> ". _THURSDAY
			."<input type=\"checkbox\" name=\"rpt_fri\" value=\"y\" " . (!empty($rpt_fri)?" checked=\"checked\"":"") . " /> ". _FRIDAY
			."<input type=\"checkbox\" name=\"rpt_sat\" value=\"y\" " . (!empty($rpt_sat)?" checked=\"checked\"":"") . " /> ". _SATURDAY
			."</div>";
		
		echo "<div id=\"monthly\" style=\"display:" . ( strcmp ( $rpt_type, 'monthly' ) == 0 ? "inline" : "none" ) . ";\">"
			." "._CALEVERY." <input name=\"rpt_monthly_freq\" size=\"4\" maxlength=\"4\" value=\"" . $rpt_monthly_freq . "\" /> "._CALMONTHS."<br />"
			."<input type=\"radio\" name=\"rpt_monthsubtype\" value=\"monthlyByDay\" " . ( strcmp ( $rpt_subtype, 'monthlyByDay' ) == 0 ? " checked=\"checked\"" : "" ) . " /> "._CALONTHE." "
			."<select name=\"rpt_select_month_option\">"
			."<option value=\""._FIRST."\"". ( strcmp ($rpt_select_option, _FIRST ) == 0 ? " selected=\"selected\"" : "") . ">"._FIRST."</option>"
			."<option value=\"+1\"". ( strcmp ($rpt_select_option, "+1" ) == 0 ? " selected=\"selected\"" : "") . ">"._SECOND."</option>"
			."<option value=\""._THIRD."\"". ( strcmp ($rpt_select_option, _THIRD ) == 0 ? " selected=\"selected\"" : "") . ">"._THIRD."</option>"
			."<option value=\""._FOURTH."\"". ( strcmp ($rpt_select_option, _FOURTH ) == 0 ? " selected=\"selected\"" : "") . ">"._FOURTH."</option>"
			."<option value=\""._FIFTH."\"". ( strcmp ($rpt_select_option, _FIFTH ) == 0 ? " selected=\"selected\"" : "") . ">"._FIFTH."</option>"
			."<option value=\""._LAST."\"". ( strcmp ($rpt_select_option, _LAST ) == 0 ? " selected=\"selected\"" : "") . ">"._LAST."</option>"
			."</select>"
			."<select name=\"rpt_select_month_day\">"
			."<option value=\""._DAY."\"". ( strcmp ($rpt_select_day, _DAY ) == 0 ? " selected=\"selected\"" : "") . ">"._DAY."</option>"
			."<option value=\""._WEEKDAY."\"". ( strcmp ($rpt_select_day, _WEEKDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._WEEKDAY."</option>"
			."<option value=\""._WEEKENDDAY."\"". ( strcmp ($rpt_select_day, _WEEKENDDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._WEEKENDDAY."</option>"
			."<option value=\""._SUNDAY."\"". ( strcmp ($rpt_select_day, _SUNDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._SUNDAY."</option>"
			."<option value=\""._MONDAY."\"". ( strcmp ($rpt_select_day, _MONDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._MONDAY."</option>"
			."<option value=\""._TUESDAY."\"". ( strcmp ($rpt_select_day, _TUESDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._TUESDAY."</option>"
			."<option value=\""._WEDNESDAY."\"". ( strcmp ($rpt_select_day, _WEDNESDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._WEDNESDAY."</option>"
			."<option value=\""._THURSDAY."\"". ( strcmp ($rpt_select_day, _THURSDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._THURSDAY."</option>"
			."<option value=\""._FRIDAY."\"". ( strcmp ($rpt_select_day, _FRIDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._FRIDAY."</option>"
			."<option value=\""._SATURDAY."\"". ( strcmp ($rpt_select_day, _SATURDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._SATURDAY."</option>"
			."</select> "._CALOFTHEMONTH
			."</div>";

		echo "<div id=\"yearly\" style=\"display:" . ( strcmp ( $rpt_type, 'yearly' ) == 0 ? "inline" : "none" ) . ";\">"
			." "._CALEVERY." <input name=\"rpt_yearly_freq\" size=\"4\" maxlength=\"4\" value=\"" . $rpt_yearly_freq . "\" /> "._CALYEARS."<br />"
			."<input type=\"radio\" name=\"rpt_yearsubtype\" value=\"yearlyByDay\" " . ( strcmp ( $rpt_subtype, 'yearlyByDay' ) == 0 ? " checked=\"checked\"" : "" ) . " /> "._CALONTHE." "
			."<select name=\"rpt_select_year_option\">"
			."<option value=\""._FIRST."\"". ( strcmp ($rpt_select_option, _FIRST ) == 0 ? " selected=\"selected\"" : "") . ">"._FIRST."</option>"
			."<option value=\"+1\"". ( strcmp ($rpt_select_option, "+1" ) == 0 ? " selected=\"selected\"" : "") . ">"._SECOND."</option>"
			."<option value=\""._THIRD."\"". ( strcmp ($rpt_select_option, _THIRD ) == 0 ? " selected=\"selected\"" : "") . ">"._THIRD."</option>"
			."<option value=\""._FOURTH."\"". ( strcmp ($rpt_select_option, _FOURTH ) == 0 ? " selected=\"selected\"" : "") . ">"._FOURTH."</option>"
			."<option value=\""._FIFTH."\"". ( strcmp ($rpt_select_option, _FIFTH ) == 0 ? " selected=\"selected\"" : "") . ">"._FIFTH."</option>"
			."<option value=\""._LAST."\"". ( strcmp ($rpt_select_option, _LAST ) == 0 ? " selected=\"selected\"" : "") . ">"._LAST."</option>"
			."</select>"
			."<select name=\"rpt_select_year_day\">"
			."<option value=\""._DAY."\"". ( strcmp ($rpt_select_day, _DAY ) == 0 ? " selected=\"selected\"" : "") . ">"._DAY."</option>"
			."<option value=\""._WEEKDAY."\"". ( strcmp ($rpt_select_day, _WEEKDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._WEEKDAY."</option>"
			."<option value=\""._WEEKENDDAY."\"". ( strcmp ($rpt_select_day, _WEEKENDDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._WEEKENDDAY."</option>"
			."<option value=\""._SUNDAY."\"". ( strcmp ($rpt_select_day, _SUNDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._SUNDAY."</option>"
			."<option value=\""._MONDAY."\"". ( strcmp ($rpt_select_day, _MONDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._MONDAY."</option>"
			."<option value=\""._TUESDAY."\"". ( strcmp ($rpt_select_day, _TUESDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._TUESDAY."</option>"
			."<option value=\""._WEDNESDAY."\"". ( strcmp ($rpt_select_day, _WEDNESDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._WEDNESDAY."</option>"
			."<option value=\""._THURSDAY."\"". ( strcmp ($rpt_select_day, _THURSDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._THURSDAY."</option>"
			."<option value=\""._FRIDAY."\"". ( strcmp ($rpt_select_day, _FRIDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._FRIDAY."</option>"
			."<option value=\""._SATURDAY."\"". ( strcmp ($rpt_select_day, _SATURDAY ) == 0 ? " selected=\"selected\"" : "") . ">"._SATURDAY."</option>"
			."</select> "._CALOF." "
			."<select name=\"rpt_select_month\">"
			."<option value=\"1\"". ( strcmp ($rpt_select_month, "1" ) == 0 ? " selected=\"selected\"" : "") . ">"._JANUARY."</option>"
			."<option value=\"2\"". ( strcmp ($rpt_select_month, "2" ) == 0 ? " selected=\"selected\"" : "") . ">"._FEBRUARY."</option>"
			."<option value=\"3\"". ( strcmp ($rpt_select_month, "3" ) == 0 ? " selected=\"selected\"" : "") . ">"._MARCH."</option>"
			."<option value=\"4\"". ( strcmp ($rpt_select_month, "4" ) == 0 ? " selected=\"selected\"" : "") . ">"._APRIL."</option>"
			."<option value=\"5\"". ( strcmp ($rpt_select_month, "5" ) == 0 ? " selected=\"selected\"" : "") . ">"._MAY."</option>"
			."<option value=\"6\"". ( strcmp ($rpt_select_month, "6" ) == 0 ? " selected=\"selected\"" : "") . ">"._JUNE."</option>"
			."<option value=\"7\"". ( strcmp ($rpt_select_month, "7" ) == 0 ? " selected=\"selected\"" : "") . ">"._JULY."</option>"
			."<option value=\"8\"". ( strcmp ($rpt_select_month, "8" ) == 0 ? " selected=\"selected\"" : "") . ">"._AUGUST."</option>"
			."<option value=\"9\"". ( strcmp ($rpt_select_month, "9" ) == 0 ? " selected=\"selected\"" : "") . ">"._SEPTEMBER."</option>"
			."<option value=\"10\"". ( strcmp ($rpt_select_month, "10" ) == 0 ? " selected=\"selected\"" : "") . ">"._OCTOBER."</option>"
			."<option value=\"11\"". ( strcmp ($rpt_select_month, "11" ) == 0 ? " selected=\"selected\"" : "") . ">"._NOVEMBER."</option>"
			."<option value=\"12\"". ( strcmp ($rpt_select_month, "12" ) == 0 ? " selected=\"selected\"" : "") . ">"._DECEMBER."</option>"
			."</select></div>";

		echo "</td></tr></table></fieldset>"
			."<div id=\"recurrencerange\" style=\"display:" . ( strcmp ( $rpt_type, 'none' ) == 0 ? "none" : "inline" ) . "\">"
			."<fieldset><legend>"._CALRANGE."</legend>"
			."<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">"
			."<tr><td style=\"width:15%;\">"
			."<b>"._CALSTARTDATE.":</b></td>"
			."<td>" . print_date_selection ( "", $cal_date ) . "</td>"
			."<td><input type=\"radio\" name=\"rpt_end_use\" value=\"n\"" . ( empty($rpt_end) ? " checked=\"checked\"" : "" ) . " /> "._CALNOENDDATE."<br />"
			."<input type=\"radio\" name=\"rpt_end_use\" value=\"y\"" . ( !empty($rpt_end) ? " checked=\"checked\"" : "" ) . " /> "._CALENDBY."&nbsp;"
			."<span class=\"end_day_selection\">"
			. print_date_selection ( "rpt_", $rpt_end_date ? $rpt_end_date : $cal_date )
			."</span></td></tr></table></fieldset>"
			."</div></div></td></tr>";
		}
		echo '</table>';
		if ($id > 0) {
			echo '<div style="float:left;"><input type="button" value="'._CALSAVE.'" onclick="return validate_and_submit();" /></div>';
			echo '</form>'
			."<form action=\"". getlink($module_name ."&amp;view=delete_event") . "\" method=\"post\" id=\"deleteeventform\">\n"
			.'<div style="float:left;">'
			."<input type=\"hidden\" name=\"creator\" value=\"$creator\" />"
			."<input type=\"hidden\" name=\"date\" value=\"$date\" />"
			."<input type=\"hidden\" name=\"id\" value=\"$id\" />";
			if  ($creator == $userinfo['username'] || can_admin($module_name) || in_group($cal_config['admin_events']-3)) {
				echo '<input type="submit" value="'._CALDELETE.'" onclick="return confirm(\''._CALDELETECONFIRM.'\');" />';
			}
			echo '</div>'
			.'</form><br />';
		} else {
			echo '<div><input type="button" value="'._CALSAVE.'" onclick="return validate_and_submit();" /></div>'
			.'</form>';
		}
		CloseTable();
	}

//	function save_event($event, $description, $edit_date, $day, $month, $year, $hour, $minute, $ampm, $dhour, $dminute, $priority, $view, $rpt_type, $evt_type, $evt_img, $rpt_select_option, $rpt_select_day, $rpt_select_month,	$rpt_end_use, $rpt_day, $rpt_month, $rpt_year, $rpt_sun, $rpt_mon, $rpt_tue, $rpt_wed, $rpt_thu, $rpt_fri, $rpt_sat, $rpt_freq ) {
	function save_event() {
		global $cal_prefix, $db, $module_name, $cal_config, $userinfo;
		$id = isset($_POST['id']) ? intval($_POST['id']) : (isset($_GET['id']) ? intval($_GET['id']) : '');
		$event = isset($_POST['event']) ? Fix_Quotes($_POST['event']) : '';
		$description = isset($_POST['description']) ? Fix_Quotes(html2bb($_POST['description'])) : '';
		$edit_date = isset($_POST['edit_date']) ? $_POST['edit_date'] : '';
		$day = $_POST['day'];
		$month = $_POST['month'];
		$year = $_POST['year'];
		$hour = $_POST['hour'];
		$minute = $_POST['minute'];
		$ampm = $_POST['ampm'];
		$dhour = $_POST['dhour'];
		$dminute = $_POST['dminute'];
		$priority = $_POST['priority'];
		$view = isset($_POST['private']) ? $_POST['private'] : $_POST['view'];
		$rpt_type = isset($_POST['recurring_event']) ? (isset($_POST['rpt_monthsubtype']) && $_POST['rpt_type'] == 'monthly' ? $_POST['rpt_monthsubtype'] : (isset($_POST['rpt_yearsubtype']) && $_POST['rpt_type'] == 'yearly' ? $_POST['rpt_yearsubtype'] : 	(isset($_POST['rpt_type']) ? $_POST['rpt_type'] : 'none'))) : 'none';
		$evt_type = $_POST['evt_type'];
		$evt_img = Fix_Quotes($_POST['evt_img']);
		$rpt_select_option = isset($_POST['rpt_monthsubtype']) && $_POST['rpt_type'] == 'monthly' ? $_POST['rpt_select_month_option'] : (isset($_POST['rpt_yearsubtype']) && $_POST['rpt_type'] == 'yearly' ? $_POST['rpt_select_year_option'] : '');
		$rpt_select_day = isset($_POST['rpt_monthsubtype']) && $_POST['rpt_type'] == 'monthly' ? $_POST['rpt_select_month_day'] : (isset($_POST['rpt_yearsubtype']) && $_POST['rpt_type'] == 'yearly' ? $_POST['rpt_select_year_day'] : '');
		$rpt_select_month = $_POST['rpt_select_month'];
		$rpt_end_use = isset($_POST['rpt_end_use']) ? $_POST['rpt_end_use'] : 'n';
		$rpt_day = $_POST['rpt_day'];
		$rpt_month = $_POST['rpt_month'];
		$rpt_year = $_POST['rpt_year'];
		$rpt_sun = isset($_POST['rpt_sun']) ? $_POST['rpt_sun'] : '';
		$rpt_mon = isset($_POST['rpt_mon']) ? $_POST['rpt_mon'] : '';
		$rpt_tue = isset($_POST['rpt_tue']) ? $_POST['rpt_tue'] : '';
		$rpt_wed = isset($_POST['rpt_wed']) ? $_POST['rpt_wed'] : '';
		$rpt_thu = isset($_POST['rpt_thu']) ? $_POST['rpt_thu'] : '';
		$rpt_fri = isset($_POST['rpt_fri']) ? $_POST['rpt_fri'] : '';
		$rpt_sat = isset($_POST['rpt_sat']) ? $_POST['rpt_sat'] : '';
		$rpt_freq = $_POST['rpt_daily_freq'] > 1 && $_POST['rpt_type'] == 'daily' ? $_POST['rpt_daily_freq'] : 
			($_POST['rpt_weekly_freq'] > 1 && $_POST['rpt_type'] == 'weekly' ? $_POST['rpt_weekly_freq'] : 
			($_POST['rpt_monthly_freq'] > 1 && $_POST['rpt_type'] == 'monthly' ? $_POST['rpt_monthly_freq'] : 
			($_POST['rpt_yearly_freq'] > 1 && $_POST['rpt_type'] == 'yearly' ? $_POST['rpt_yearly_freq'] : 1)));
	  if ( empty ( $id ) ) {
		$newevent = true;
		$res = $db->sql_query ( "SELECT MAX(eid) + 1 FROM " .$cal_prefix );
		if ( $db->sql_numrows($res) > 0 ) {
		  $row = $db->sql_fetchrow ( $res );
		  $id = $row[0];
		  if ($id == null || $id < 41) {
			  $id = 41;
		  }
		  $db->sql_freeresult ( $res );
		} else {
		  $id = 41;
		}
	  } else {
		$newevent = false;
		// save old status values of participants
//		sql_query ( "DELETE FROM " .$cal_prefix. " WHERE eid = $id", $dbi );
//		sql_query ( "DELETE FROM " .$cal_prefix. "_repeat WHERE eid = $id", $dbi );
	  }

		$duration = ( $dhour * 60 ) + $dminute;
		if ( strlen ( $hour ) > 0 ) {
		  if ( $cal_config['time_format'] == "12" ) {
			$ampmt = $ampm;
			//This way, a user can pick am and still
			//enter a 24 hour clock time.
			if ($hour > 12 && $ampm == 'am') {
			  $ampmt = 'pm';
			}
			$hour %= 12;
			if ( $ampmt == 'pm' ) {
			  $hour += 12;
			}
		  }
		}

		$approved = date( "Ymd" );
		if (! is_admin() && ! can_admin($module_name) && $view != -1 && $cal_config['admin_approval'] == 1 && !in_group($cal_config['admin_events']-3)) {
			$approved = 0;
		}

//		$event = Fix_Quotes($event);
//		$description = Fix_Quotes($description);

		if ($newevent) {
		  $insertsql = "INSERT INTO " .$cal_prefix. " ( eid, date, " .
			"time, mod_date, mod_time, duration, priority, " .
			"type, view, name, description, image, creator, approved, category ) " .
			"VALUES ( $id, ";
		  $date = adodb_mktime ( 0, 0, 0, $month, $day, $year );
		  $insertsql .= adodb_date ( "Ymd", $date ) . ", ";
		  if ( strlen ( $hour ) > 0 ) {
			$insertsql .= sprintf ( "%02d%02d00, ", $hour, $minute );
		  } else {
			$insertsql .= "-1, ";
		  }
		  $insertsql .= adodb_date ( "Ymd" ) . ", " . adodb_date ( "Gis" ) . ", ";
		  $insertsql .= sprintf ( "%d, ", $duration );
		  $insertsql .= sprintf ( "%d, ", $priority );

		  $insertsql .= ($rpt_type != 'none' ? "'R', " : "'E', ");
		  $insertsql .= "'$view', ";

		  if ( strlen ( $event ) == 0 ) {
			$event = "Unnamed Event";
		  }
		  $insertsql .= "'$event', ";
		  if ( strlen ( $description ) == 0 ) {
			$description = $event;
		  }
		  $insertsql .= "'$description', ";
		  $insertsql .= "'$evt_img', ";
		  $aid = is_admin();
		  $author = ($userinfo['user_id']>1) ? $userinfo['username'] : $aid;
		  $insertsql .= "'".$author."', ";
		  $insertsql .= "$approved, ";
		  $insertsql .= "$evt_type)";
		  $sql = $insertsql;
		} else {
			$date = adodb_mktime ( 0, 0, 0, $month, $day, $year );
			if ($edit_date != null && $edit_date != adodb_date ( "Ymd", $date )) {
				$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_desc WHERE eid = $id and date = $edit_date");
				$sql = "INSERT INTO " .$cal_prefix. "_repeat_desc ( eid, date, name, description ) " .
					"VALUES ( $id, $edit_date, '$event', '$description')";
			} else {
			  $updatesql = "UPDATE " .$cal_prefix. " set ";
			  $updatesql .= "date = " . adodb_date ( "Ymd", $date ) . ", ";
			  if ( strlen ( $hour ) > 0 ) {
				$updatesql .= "time = " . sprintf ( "%02d%02d00, ", $hour, $minute );
			  } else {
				$updatesql .= "time = -1, ";
			  }
			  $updatesql .= "mod_date = " . adodb_date ( "Ymd" ) . ", ";
			  $updatesql .= "mod_time = " . adodb_date ( "Gis" ) . ", ";
			  $updatesql .= "duration = " . sprintf ( "%d, ", $duration );
			  $updatesql .= "priority = " . sprintf ( "%d, ", $priority );
			  $updatesql .= "type = " . ($rpt_type != 'none' ? "'R', " : "'E', ");
			  $updatesql .= "view = '$view', ";

			  if ( strlen ( $event ) == 0 ) {
				$event = "Unnamed Event";
			  }
			  $updatesql .= "name = '$event', ";
			  if ( strlen ( $description ) == 0 ) {
				$description = $event;
			  }
			  $updatesql .= "description = '$description', ";
			  $updatesql .= "image = '$evt_img', ";
//			  $updatesql .= "creator = '".$userinfo['username']."', ";
			  $updatesql .= "category = $evt_type ";
			  $updatesql .= "WHERE eid = $id";
			  $sql = $updatesql;
			}
		}
		$error = "";
//		$rtn = $db->sql_query ( $sql);
		$result = $db->sql_query ( $sql);
		if ( $db->sql_affectedrows( $result ) <= 0 ) {
			$sql_error = $db->sql_error($result);
		}
//		$msg .= "<B>SQL:</B> $sql<P>";

		// add repeating info
//		echo $rpt_type;
		if ($rpt_type != "nochange") {
			$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat WHERE eid = $id");
			if ( strlen ( $rpt_type ) && $rpt_type != 'none' ) {
				$freq = ( $rpt_freq ? $rpt_freq : 1 );
				if ( $rpt_end_use == "y") {
				  $end = sprintf ( "%04d%02d%02d", $rpt_year, $rpt_month, $rpt_day );
				} else {
				  $end = 'NULL';
				}
				if ($rpt_type == 'weekly') {
				  $days = ( $rpt_sun ? 'y' : 'n' )
					. ( $rpt_mon ? 'y' : 'n' )
					. ( $rpt_tue ? 'y' : 'n' )
					. ( $rpt_wed ? 'y' : 'n' )
					. ( $rpt_thu ? 'y' : 'n' )
					. ( $rpt_fri ? 'y' : 'n' )
					. ( $rpt_sat ? 'y' : 'n' );
					$dow = dayOfWeek(adodb_date ( "d", $date ), adodb_date ( "m", $date ), adodb_date ( "Y", $date ));
					if (stristr($days, 'y') === FALSE)
						$days = substr_replace($days, "y", $dow, 1);
				} elseif ($rpt_type == 'monthlyByDay') {
					$days = "$rpt_select_option,$rpt_select_day";
				} elseif ($rpt_type == 'yearlyByDay') {
					$days = "$rpt_select_option,$rpt_select_day,$rpt_select_month";
				} else {
				  $days = "nnnnnnn";
				}
//				echo $days;
				$sql = "INSERT INTO " . $cal_prefix . "_repeat ( eid, " .
					  "type, end, days, frequency ) VALUES " .
					  "( $id, '$rpt_type', $end, '$days', $freq )";
					$result = $db->sql_query ( $sql);
					$error = $db->sql_error($result);
					if ($error['code'] != 0)
						$sql_error = $error;
//				$msg .= "<B>SQL:</B> $sql<P>";
			}
		}

		if ( empty ( $sql_error ) ) {
			if ($edit_date)
				url_redirect(getlink($module_name.'&amp;view=month&amp;date='.$edit_date));
			else
				url_redirect(getlink($module_name.'&amp;view=month&amp;date='.sprintf( '%04d%02d%02d', $year, $month, $day )));
		} else {
			cpg_error (_SQLERROR.': '.$sql_error['code'].' '.$sql_error['message']);
		}
	}

	function delete_event($day, $month, $year) {
		global $cal_prefix, $db, $module_name, $cal_config;
		$id = isset($_POST['id']) ? intval($_POST['id']) : '';
		$creator = isset($_POST['creator']) ? intval($_POST['creator']) : '';
		if ( !empty($id) && ($creator == $userinfo['username'] || can_admin($module_name) || in_group($cal_config['admin_events']-3)) ) {
			$sql = "SELECT date, type FROM ".$cal_prefix." WHERE eid = " . $id;
			$res = $db->sql_query ( $sql);
			if ( $res ) {
				$row = $db->sql_fetchrow ( $res );
				if (substr($row[1],0,1) == 'R'){
					$cal_date = $row[0];
					$start_year = (int) ( $cal_date / 10000 );
					$start_month = ( $cal_date / 100 ) % 100;
					$start_day = $cal_date % 100;
					if (adodb_date ( "Ymd", adodb_mktime ( 0, 0, 0, $start_month, $start_day, $start_year ) ) == adodb_date ( "Ymd", adodb_mktime ( 0, 0, 0, $month, $day, $year ) ) ) {
						$db->sql_query ( "DELETE FROM " .$cal_prefix. " WHERE eid = $id");
						$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat WHERE eid = $id");
						$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_cancel WHERE eid = $id");
						$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_desc WHERE eid = $id");
						}
					else {
						$db->sql_query ( "INSERT INTO " .$cal_prefix. "_repeat_cancel VALUES ($id, ".adodb_date ( "Ymd", adodb_mktime ( 0, 0, 0, $month, $day, $year ) ).")");
					}
				}
				else {
					$db->sql_query ( "DELETE FROM " .$cal_prefix. " WHERE eid = $id");
					$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat WHERE eid = $id");
					$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_cancel WHERE eid = $id");
					$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_desc WHERE eid = $id");
				}
			}
		} else {
			cpg_error('You don\'t have permission to delete events.');
		}
		url_redirect(getlink($module_name.'&amp;view=month&amp;date='.sprintf( "%04d%02d%02d", $year, $month, $day )));
	}

	$date = isset($_POST['date']) ? intval($_POST['date']) : (isset($_GET['date']) ? intval($_GET['date']) : '');
	if (!empty($date)) {
		$thisyear = substr ( $date, 0, 4 );
		$thismonth = substr ( $date, 4, 2 );
		$thisday = substr ( $date, 6, 2 );
	} else {
		$thisyear = !isset($_GET['year']) ? (!isset($_POST['year']) ? adodb_date ("Y") : $_POST['year']) : $_GET['year'];
		$thismonth = !isset($_GET['month']) ? (!isset($_POST['month']) ? adodb_date ("m") : $_POST['month']) : $_GET['month'];
		$thisday = !isset($_GET['day']) ? (!isset($_POST['day']) ? adodb_date ("d") : $_POST['day']) : $_GET['day'];
	}
	if (!checkdate($thismonth, $thisday, $thisyear ))
		cpg_error(_CALINVALIDDATE);
	if ($thisyear < $cal_config['start_year'])
		$thisyear = $cal_config['start_year'];
	$wday = adodb_strftime ( "%w", adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear ) );
	$now = adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear );
	$nowYmd = adodb_date ( "Ymd", $now );
	// "next" refers to next month in this context
	$next = adodb_mktime ( 2, 0, 0, $thismonth + 1, $thisday, $thisyear );
	$nextyear = adodb_date ( "Y", $next );
	$nextmonth = adodb_date ( "m", $next );
//	$nextday = adodb_date ( "d", $next );
//	$month_ago = adodb_date ( "Ymd", adodb_mktime ( 2, 0, 0, $thismonth - 1, $thisday, $thisyear ) );
	// "prev" refers to previous month in this context
	$prev = adodb_mktime ( 2, 0, 0, $thismonth - 1, $thisday, $thisyear );
	$prevyear = adodb_date ( "Y", $prev );
	$prevmonth = adodb_date ( "m", $prev );
//	$prevday = adodb_date ( "d", $prev );
//	$month_ahead = adodb_date ( "Ymd", adodb_mktime ( 2, 0, 0, $thismonth + 1, $thisday, $thisyear ) );

	$view = !isset($_GET['view']) ? (!isset($_POST['view']) ? $cal_config['default_view'] : $_POST['view']) : $_GET['view'];
//	$id = !isset($_GET['id']) ? (!isset($_POST['id']) ? "" : $_POST['id']) : $_GET['id'];

	//if view = month, need to get previous, current and next months data to populate the large and 2 small calendars for the month view.
	$startdate = sprintf ( "%04d%02d01", $prevyear, $prevmonth );
	$enddate = sprintf ( "%04d%02d31", $nextyear, $nextmonth );
	if ($view == 'year') { //need data for all year
		$startdate = sprintf ( "%04d0101", $thisyear );
		$enddate = sprintf ( "%04d1231", $thisyear );
	} elseif ($view == 'week') { //need data for selected week
		$startdate = sprintf ( "%04d%02d%02d", $thisyear, $thismonth, $thisday );
		$thisweek = mktime(0, 0, 0, $thismonth  , $thisday+6, $thisyear);
		$enddate = sprintf ( "%04d%02d%02d", adodb_date ( "Y", $thisweek), adodb_date ( "m", $thisweek), adodb_date ( "d", $thisweek) );
	} elseif ($view == 'day') { //need data for this month because the small month calendar is displayed on the page.
		$startdate = sprintf ( "%04d%02d01", $thisyear, $thismonth );
		$enddate = sprintf ( "%04d%02d31", $thisyear, $thismonth );
	}

	/* Pre-Load the descriptions for repeating events for quckier access */
	$repeated_descriptions = read_repeated_descriptions ( $startdate, $enddate );
	/* Pre-Load the canceled repeating events for quckier access */
	$canceled_events = read_canceled_events ( $startdate, $enddate );
	/* Pre-Load the repeated events for quckier access */
	$repeated_events = read_repeated_events ();
	/* Pre-load the non-repeating events for quicker access */
	$events = read_events ( $startdate, $enddate );
	/* Pre-load the categories for quicker access */
	$calcategories = read_categories ( );

//	$view = isset($_POST['view']) ? $_POST['view'] : (isset($_GET['view']) ? $_GET['view'] : $cal_config['default_view']);
switch ($view) {
	case 'year':
	view_year($thisyear);
	break;

	case 'month':
	view_month ($thisday, $thismonth, $thisyear);
	break;

	case 'popup':
	view_popup();
	break;

	case 'week':
	view_week ($thisday, $thismonth, $thisyear);
	break;

	case 'day':
	view_day ($now);
	break;

	case 'event':
	view_event ($date);
	break;

	case 'add_event':
	case 'edit_event':
	edit_event($date);
	break;

	case 'delete_event':
	delete_event($thisday, $thismonth, $thisyear);
	break;

	case 'save_event':
	save_event();
	break;

	default:
	view_month ($thisday, $thismonth, $thisyear);
	break;
}
