<?php
/*********************************************
  CPGNuCalendar
  ********************************************
  Copyright 2005 by Kris Henneman
  
  Original highly modified code ported from an early 2003 
  version of WebCalendar by http://webcalendar.sourceforge.net
  to PHP-Nuke.  It has since been ported to CPG-Nuke.

  CPGNuCalendar is released under the terms and conditions
  of the GNU GPL version 2 or any later version

  $Id: functions.inc,v 1.1 2007/10/21 13:04:08 Phoenix Exp $
  $RCSfile: functions.inc,v $
  $Revision: 1.1 $
  $Author: Phoenix $
  $Date: 2007/10/21 13:04:08 $
******************************************************************
* Modified by Phoenix at NukeBiz dot com to support RSS feed     *
*****************************************************************/
if (!defined('CPG_NUKE')) { exit; }

global $prefix, $cal_prefix, $MAIN_CFG, $db, $cal_module_name, $cal_config;

$cal_module_name = basename(dirname(dirname(__FILE__)));

$block_module_name = $MAIN_CFG['cpgnucalendar']['block_module_name'];
if (!empty($block_module_name) && $cal_module_name != $block_module_name) {
	$cal_module_name = $block_module_name;
}
//putenv("TZ=GMT");
require_once(BASEDIR.'modules/'.$cal_module_name.'/includes/adodb-time.inc');

$cal_prefix = $prefix.'_'.strtolower($cal_module_name);
$cal_config = $MAIN_CFG[strtolower($cal_module_name)];

if (!isset($cal_module_title)) {
    list($cal_module_title) = $db->sql_ufetchrow("SELECT custom_title FROM ".$prefix."_modules WHERE title='$cal_module_name'", SQL_NUM, __FILE__, __LINE__);
    if (empty($cal_module_title)) { $cal_module_title = $cal_module_name; }
}

/**
 * getfoldercontent()
 * 
 * return the files and directories of a folder in two arrays
 * 
 * @param  $folder the folder to read
 * @param  $pic_array the array that will contain name of picture
 * @return 
 */
	function get_calendar_images($folder, &$pic_array)
	{
		if ($handle = opendir($folder)) {
		   while (false !== ($file = readdir($handle))) {
			   if (!stristr(".,..,calendar.gif,today.gif",$file))
				$pic_array[] = $file;
		   }
		   closedir($handle);
		}
		natcasesort($pic_array);
	} 

function remove_time($dateformat) {
	$timesymbols = array("a", "A", "B", "G", "g", "H", "h", "i", "s", ":");
	return str_replace($timesymbols, "", $dateformat);
}

// Read all the categories and cache them in an array for later use.  This is only called once
// per page request to improve performance.
function read_categories ( ) {
  global $cal_prefix, $db;
  $result = array ();

  $sql = "SELECT catid, title, image, priority, display FROM " . $cal_prefix. "_categories order by title";
  $res = $db->sql_query($sql);

  if ( $res ) {
	$i = 0;
	while ( $row = $db->sql_fetchrow ( $res ) ) {
		$item = array (
			"catid"  => $row[0],
			"title" => $row[1],
			"image" => $row[2],
			"priority" => $row[3],
			"display" => $row[4]
		);
	  $result [$row[0]] = $item;
	}
  }
  $db->sql_freeresult ( $res );
  return $result;
}


// Read all the events for a user for the specified range of dates.
// This is only called once per page request to improve performance.
// All the events get loaded into the array $events sorted by
// time of day (not date).
// params:
//   $startdate - start date range, inclusive (in YYYYMMDD format)
//   $enddate - end date range, inclusive (in YYYYMMDD format)
function read_events ( $startdate, $enddate ) {
  global $cal_prefix;

  if ( $startdate == $enddate )
    $date_filter = $cal_prefix.".date = $startdate";
  else
    $date_filter = $cal_prefix.".date >= $startdate " .
      "AND " . $cal_prefix.".date <= $enddate";

  return query_events ( false, $date_filter );
}

// Read all the repeated event descriptions that have been changed from the original.
//This is only called once per page request to improve performance.  All the events get loaded
// into the array $repeated_descriptions sorted by time of day (not date).
// params:
//	 $user - username
function read_repeated_descriptions ( $startdate, $enddate ) {
  global $cal_prefix, $db;
  $result = array ();

  if ( $startdate == $enddate )
    $date_filter = "date = $startdate";
  else
    $date_filter = "date >= $startdate " .
      "AND date <= $enddate";

  $sql = "SELECT eid, date, name, description FROM " . $cal_prefix. "_repeat_desc WHERE " . $date_filter;
  $res = $db->sql_query($sql);

  if ( $res ) {
	$i = 0;
	while ( $row = $db->sql_fetchrow ( $res ) ) {
		$item = array (
			"eid"  => $row[0],
			"date" => $row[1],
			"name" => $row[2],
			"description" => $row[3]
		);
	  $result [$i++] = $item;
	}
  }
  $db->sql_freeresult ( $res );
  return $result;
}

// Read all the repeated events that have been canceled.  This is only called once
// per page request to improve performance.  All the events get loaded
// into the array $cancelled_events sorted by time of day (not date).
// params:
//	 $user - username
function read_canceled_events ( $startdate, $enddate ) {
  global $cal_prefix, $db;
  $result = array ();

  if ( $startdate == $enddate )
    $date_filter = "date = $startdate";
  else
    $date_filter = "date >= $startdate " .
      "AND date <= $enddate";

  $sql = "SELECT eid, date FROM " . $cal_prefix. "_repeat_cancel WHERE " . $date_filter;
  $res = $db->sql_query($sql);

  if ( $res ) {
	$i = 0;
	while ( $row = $db->sql_fetchrow ( $res ) ) {
		$item = array (
			"eid"  => $row[0],
			"date" => $row[1]
		);
	  $result [$i++] = $item;
	}
  }
  $db->sql_freeresult ( $res );
  return $result;
}

// Read all the repeated events for a user.  This is only called once
// per page request to improve performance.  All the events get loaded
// into the array $repeated_events sorted by time of day (not date).
// params:
//	 $user - username
function read_repeated_events () {
  return query_events ( true, "" );
}

// Read events visible to a user (including layers); return results
// in an array sorted by time of day.
// params:
//	 $want_repeated - true to get repeating events; false to get
//	   non-repeating.
//	 $date_filter - SQL phrase starting with AND, to be appended to
//	   the WHERE clause.  May be empty string.

function query_events ( $want_repeated, $date_filter ) {
  global $cal_prefix, $db, $userinfo;
  $result = array ();

  $sql = "SELECT " . $cal_prefix. ".eid, date, time, duration, priority, "
//	. $cal_prefix. ".type, "
	. "view, name, description, image, category ";
  $where = "";
  if ( $want_repeated ) {
	$sql .= ", "
	  . $cal_prefix. "_repeat.type, end, frequency, days "
	  . "FROM " . $cal_prefix. ", " . $cal_prefix. "_repeat ";
	$where = "WHERE " . $cal_prefix. ".eid = " . $cal_prefix. "_repeat.eid ";
  } else {
	$sql .= "FROM " . $cal_prefix. " ";
  }
  if ( ! empty($date_filter) ) {
	if ( ! empty($where) )
		$where .= " AND " . $date_filter;
	else
		$where .= "WHERE " . $date_filter;
  }

	//Only get events visible this user
	$view[] = 0;
	$userevents = "";
	if (is_user()) {
		//Get user's private events
		$userevents .= "(view = -1 and creator = '".$userinfo['username']."') ";
		//Get events visible to all users
		$view[] = 1;
		foreach($userinfo['_mem_of_groups'] AS $key => $value) 
			$view[] = $key+3;

	}
	if (is_admin()) {
		$view[] = 2;
	}

	$userevents .= (! empty($userevents) ? "OR " : "") . "view in (".implode(",", $view)."))";
	if ( ! empty($where) )
		$where .= " AND (" . $userevents;
	else
		$where .= "WHERE (" . $userevents;
  
	//only get approved events or events that are owned by this user.
	if ( ! empty($where) )
		$where .= " AND (approved > 0 or creator = '".$userinfo['username']."') ";
	else
		$where .= "WHERE (approved > 0 or creator = '".$userinfo['username']."') ";
  
  
  
  // now order the results by time and by entry id.
  $sql .= $where . " ORDER BY priority desc, time, " . $cal_prefix. ".eid";

  $res = $db->sql_query($sql);

  if ( $res ) {
	$i = 0;
	$checkdup_id = -1;
	$first_i_this_id = -1;

	while ( $row = $db->sql_fetchrow ( $res ) ) {

//		if ($row[8] == 'R') {
//		  continue;  // don't show rejected ones
//		}
	  $item = array (
		"eid"   => $row[0],
		"date" => $row[1],
		"time" => $row[2],
		"duration" => $row[3],
		"priority" => $row[4],
		"view" => $row[5],
		"name" => $row[6],
		"description" => $row[7],
		"image" => $row[8],
		"category" => $row[9],
		);
	  if ( $want_repeated && ! empty ( $row[10] ) ) {
		$item['type'] = empty ( $row[10] ) ? "" : $row[10];
		$item['end'] = empty ( $row[11] ) ? "" : $row[11];
		$item['frequency'] = empty ( $row[12] ) ? "" : $row[12];
		$item['days'] = empty ( $row[13] ) ? "" : $row[13];
	  }

	  if ( $item['eid'] != $checkdup_id ) {
		$checkdup_id = $item['eid'];
		$first_i_this_id = $i;
	  }

	  $result [$i++] = $item;

	}
	$db->sql_freeresult ( $res );
  }
  return $result;
}

// Generate a cookie that saves the last calendar view (month, week, day)
// so we can return to this same page after a user edits/deletes/etc an
// event
/*function remember_this_view () {
  global $SCRIPT_FILENAME, $REQUEST_URI;
  SetCookie ( "calendar_last_view", $REQUEST_URI );
}

// Get the last page stored using above function.
// Return empty string if we don't know.
function get_last_view () {
  global $calendar_last_view;
  return $calendar_last_view;
}
*/
// Get the Sunday of the week that the specified date is in.
// (If the date specified is a Sunday, then that date is returned.)
function get_sunday_before ( $year, $month, $day ) {
  $weekday = adodb_date ( "w", adodb_mktime ( 2, 0, 0, $month, $day, $year ) );
  return adodb_mktime ( 2, 0, 0, $month, $day - $weekday, $year );
}

// Get the Monday of the week that the specified date is in.
// (If the date specified is a Monday, then that date is returned.)
function get_monday_before ( $year, $month, $day ) {
  $weekday = adodb_date ( "w", adodb_mktime ( 2, 0, 0, $month, $day, $year ) );
  if ( $weekday == 0 )
	return adodb_mktime ( 2, 0, 0, $month, $day - 6, $year );
  if ( $weekday == 1 )
	return adodb_mktime ( 2, 0, 0, $month, $day, $year );
  return adodb_mktime ( 2, 0, 0, $month, $day - ( $weekday - 1 ), $year );
}

// Return the abbreviated month name
// params:
//	 $m - month (0-11)
function month_short_name ( $m ) {
  switch ( $m ) {
	case 0: return _JAN;
	case 1: return _FEB;
	case 2: return _MAR;
	case 3: return _APR;
	case 4: return _MAY;
	case 5: return _JUN;
	case 6: return _JUL;
	case 7: return _AUG;
	case 8: return _SEP;
	case 9: return _OCT;
	case 10: return _NOV;
	case 11: return _DEC;
  }
  return "unknown-month($m)";
}

// Return the full month name
// params:
//   $m - month (0-11)
function month_name ( $m ) {
  switch ( $m ) {
    case 0: return _JANUARY;
    case 1: return _FEBRUARY;
    case 2: return _MARCH;
    case 3: return _APRIL;
    case 4: return _MAY;
    case 5: return _JUNE;
    case 6: return _JULY;
    case 7: return _AUGUST;
    case 8: return _SEPTEMBER;
    case 9: return _OCTOBER;
    case 10: return _NOVEMBER;
    case 11: return _DECEMBER;
  }
  return "unknown-month($m)";
}

function isWeekday ( $w ) {
	$weekdays = array();
	for ( $i = 0; $i <= 6; $i++ ) {
		$weekdays[weekday_name($i)] = $i;
	}
	if (array_search($w, $weekdays) >= 0)
		return TRUE;
	return FALSE;
}
// Return the full weekday name
// params:
//   $w - weekday (0=Sunday,...,6=Saturday)
function weekday_name ( $w ) {
  switch ( $w ) {
    case 0: return _SUNDAY;
    case 1: return _MONDAY;
    case 2: return _TUESDAY;
    case 3: return _WEDNESDAY;
    case 4: return _THURSDAY;
    case 5: return _FRIDAY;
    case 6: return _SATURDAY;
  }
  return "unknown-weekday($w)";
}

// Return the abbreviated weekday name
// params:
//   $w - weekday (0=Sun,...,6=Sat)
function weekday_short_name ( $w ) {
  switch ( $w ) {
    case 0: return _ABR_SUNDAY;
    case 1: return _ABR_MONDAY;
    case 2: return _ABR_TUESDAY;
    case 3: return _ABR_WEDNESDAY;
    case 4: return _ABR_THURSDAY;
    case 5: return _ABR_FRIDAY;
    case 6: return _ABR_SATURDAY;
  }
  return "unknown-weekday($w)";
}

function weekday_letter_name ( $w ) {
  switch ( $w ) {
    case 0: return _S;
    case 1: return _M;
    case 2: return _T;
    case 3: return _W;
    case 4: return _TH;
    case 5: return _F;
    case 6: return _SA;
  }
  return "unknown-weekday($w)";
}

// Display a time in either 12 or 24 hour format
// params:
//   $time - an interger like 235900
	function display_time ( $time ) {
		global $cal_config;
		$hour = (int) ( $time / 10000 );
		$min = ( $time / 100 ) % 100;
		if ( $cal_config['time_format'] == "12" ) {
			$ampm = $hour >= 12 && $hour != 24 ? _PM : _AM;
			$hour %= 12;
			if ( $hour == 0 ) $hour = 12;
			$ret = sprintf ( "%d:%02d%s", $hour, $min, $ampm );
		}
		else 
			$ret = sprintf ( "%d:%02d", $hour, $min );

		return $ret;
	}

// Returns week number for specified date
// depending from week numbering settings.
// params:
//   $date - date in UNIX time format
function week_number ( $date ) {
	global $cal_config;
  if ( $cal_config['week_start_day'] == "1" )
    return adodb_strftime ( "%V", $date ); // ISO Weeks -- which start on Mondays
  else
    return adodb_strftime ( "%W", $date );
}

function date_to_epoch ( $d ) {
  return adodb_mktime ( 2, 0, 0, substr ( $d, 4, 2 ), substr ( $d, 6, 2 ),
	substr ( $d, 0, 4 ) );
}

function showDate($dateYmd, $rpt_option, $rpt_day, $rpt_month){
	$thisyear = substr($dateYmd, 0, 4);
	$thismonth = substr($dateYmd, 4, 2);
	$thisday = substr($dateYmd, 6, 2);
	$nextmonthday = $thisday;

	if (!empty($rpt_month)) 
		$thismonth = $rpt_month;
	$thismonthlastday = adodb_mktime (0, 0, 0, $thismonth+1, 0, $thisyear);
	$nextmonthlastday = adodb_mktime(0, 0, 0, $thismonth+2, 0, $thisyear);
	if ($thisday == adodb_strftime ("%d", $thismonthlastday) && adodb_strftime ("%d", $thismonthlastday) > adodb_strftime ("%d", $nextmonthlastday))
		$nextmonthday = adodb_strftime ("%d", $nextmonthlastday);

	$month = adodb_mktime ( 2, 0, 0, $thismonth, $thisday, $thisyear );
	$nextmonth = adodb_mktime ( 2, 0, 0, $thismonth + 1, $nextmonthday, $thisyear );

	$smonth = adodb_strftime ("%B %Y", $month);
	$snextmonth = adodb_strftime ("%B %Y", $nextmonth);

	if (strcmp($rpt_option, _LAST) == 0)
		$smonth = $snextmonth;

	if (strcmp($rpt_day,_WEEKDAY)==0) {
		$findDay = strtotime($rpt_option . " " . $rpt_day, strtotime("1 $smonth")) + 43200;
		$weekday_number = dayOfWeek(adodb_date ( "d", $findDay ), adodb_date ( "m", $findDay ), adodb_date ( "Y", $findDay ));
		if ($weekday_number == 0)
			$findDay = strtotime("+1 day", strtotime("1 $smonth")) + 43200;
		else if ($weekday_number == 6)
			$findDay = strtotime("+2 day", strtotime("1 $smonth")) + 43200;
	} else if (strcmp($rpt_day,_WEEKENDDAY)==0) {
		$findDay = strtotime($rpt_option . " " . $rpt_day, strtotime("1 $smonth")) + 43200;
		$weekday_number = dayOfWeek(adodb_date ( "d", $findDay ), adodb_date ( "m", $findDay ), adodb_date ( "Y", $findDay ));
		if ($weekday_number > 0 && $weekday_number < 6) {
			$addDays = 6 - $weekday_number;
			$findDay = strtotime("+$addDays day", strtotime("1 $smonth")) + 43200;
		}
	} else {
		// If rpt_opton = +1 (which means "Second") then change it to "+1 week" if rpt_day is a weekday name.
		if ($rpt_option == "+1" && isWeekday($rpt_day))
			$findDay = strtotime($rpt_option . " week " . $rpt_day, strtotime("1 $smonth")) + 43200;
		else
			$findDay = strtotime($rpt_option . " " . $rpt_day, strtotime("1 $smonth")) + 43200;
	}
	return strcmp(adodb_strftime ("%m/%d/%Y", $month), adodb_strftime ("%m/%d/%Y", $findDay));
}
		
/*		
		
		
		echo "This month is: ". $month ." and next month is: ". $nextmonth . "<br />";

		$findDay = strtotime("first monday", strtotime("1 $month")) + 43200;
		print adodb_strftime ('First Monday: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("+1 week Monday", strtotime("1 $month")) + 43200;
		print adodb_strftime ('Second Monday: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("Fifth friday", strtotime("1 $month")) + 43200;
		print adodb_strftime ('Fifth Friday: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("Last monday", strtotime("1 $nextmonth")) + 43200;
		print adodb_strftime ('Last Monday of the Month: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("now", strtotime("1 $month")) + 43200;
		print adodb_strftime ('First Day: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("-1 day", strtotime("1 $nextmonth")) + 43200;
		print adodb_strftime ('Last Day: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("now", strtotime("1 $month")) + 43200;
		$weekday_number = dayOfWeek(adodb_date ( "d", $findDay ), adodb_date ( "m", $findDay ), adodb_date ( "Y", $findDay ));
		if ($weekday_number == 0)
			$findDay = strtotime("+1 day", strtotime("1 $month")) + 43200;
		else if ($weekday_number == 6)
			$findDay = strtotime("+2 day", strtotime("1 $month")) + 43200;
		print adodb_strftime ('First Weekday of the Month: %B %d, %Y<br />', $findDay);

		$findDay = strtotime("now", strtotime("1 $month")) + 43200;
		$weekday_number = dayOfWeek(adodb_date ( "d", $findDay ), adodb_date ( "m", $findDay ), adodb_date ( "Y", $findDay ));
		if ($weekday_number > 0 && $weekday_number < 6) {
			$addDays = 6 - $weekday_number;
			$findDay = strtotime("+$addDays day", strtotime("1 $month")) + 43200;
		}
		print adodb_strftime ('First Weekend Day of the Month: %B %d, %Y<br />', $findDay);
*/

function isEaster($dateYmd){
	$thisyear = substr($dateYmd, 0, 4);
	$thismonth = substr($dateYmd, 4, 2);
	$thisday = substr($dateYmd, 6, 2);
	$a=fmod($thisyear,19);
	$b=floor($thisyear/100);
	$c=fmod($thisyear,100);
	$d=floor($b/4);
	$e=fmod($b,4);
	$f=floor(($b+8)/25);
	$g=floor(($b-$f+1)/3);
	$h=fmod((19*$a+$b-$d-$g+15),30);
	$i=floor($c/4);
	$k=fmod($c,4);
	$l=fmod((32+2*$e+2*$i-$h-$k),7);
	$m=floor(($a+11*$h+22*$l)/451);
	$month =floor(($h+$l-7*$m+114)/31); // Easter month [3=March, 4=April]
	$p=fmod(($h+$l-7*$m+114),31);
	$day = ($p+1);
	$easter =  adodb_mktime ( 0, 0, 0, $month, $day, $thisyear );
	$test = adodb_mktime ( 0, 0, 0, $thismonth, $thisday, $thisyear );
	return ($test == $easter);
}


//Returns a boolean stating whether or not the event passed
//in will fall on the date passed.
	function repeated_event_matches_date($event, $dateYmd) {
	  // only repeat after the beginning, and if there is an end
	  // before the end
		$date = date_to_epoch ( $dateYmd );
		$thisyear = substr($dateYmd, 0, 4);
		$start = date_to_epoch ( $event['date'] );
		$end   = date_to_epoch ( $event['end'] );
		$freq = $event['frequency'];
		$thismonth = substr($dateYmd, 4, 2);
		if ($event['end'] && $dateYmd > adodb_date ("Ymd",$end) )
			return false;
// *********************
// The following line was causing the first of a set of repeating events to not print out.
// Don't yet know if changing it broke anything else.
// *********************
//		if ( $dateYmd <= adodb_date ("Ymd",$start) )
		if ( $dateYmd < adodb_date ("Ymd",$start) )
			return false;
		$id = $event['eid'];
		if ($event['type'] == 'daily') {
			if ( (floor(($date - $start)/86400)%$freq) )
				return false;
			return true;
		} else if ($event['type'] == 'weekly') {
			$dow  = adodb_date ("w", $date);
			$dow1 = adodb_date ("w", $start);
			$isDay = substr($event['days'], $dow, 1);
			$wstart = $start - ($dow1 * 86400);
			if (floor(($date - $wstart)/604800)%$freq)
				return false;
			if (strcmp($isDay,"y") == 0)
				return true;
		} else if ($event['type'] == 'monthlyByDay') {
			$byDay = array();
			$byDay = explode(",", $event['days']);
			$rpt_select_option = $byDay[0];
			$rpt_select_day = $byDay[1];

			$dowS = adodb_date ("w", $start);
			$dayS = ceil(adodb_date ("d", $start)/7);
			$mthS = adodb_date ("m", $start);
			$yrS  = adodb_date ("Y", $start);

			$dow  = adodb_date ("w", $date);
			$day  = ceil(adodb_date ("d", $date)/7);
			$mth  = adodb_date ("m", $date);
			$yr   = adodb_date ("Y", $date);

			if ((($yr - $yrS)*12 + $mth - $mthS) % $freq)
			return false;

			if (($dowS == $dow) && ($day == $dayS) && (showDate($dateYmd, $rpt_select_option, $rpt_select_day, "") == 0))
			return true;
		} else if ($event['type'] == 'monthly') {
			$mthS = adodb_date ("m", $start);
			$yrS  = adodb_date ("Y", $start);

			$mth  = adodb_date ("m", $date);
			$yr   = adodb_date ("Y", $date);

			if ((($yr - $yrS)*12 + $mth - $mthS) % $freq)
			return false;

			if (adodb_date ("d", $date) == adodb_date ("d", $start))
			return true;
		} else if ($event['type'] == 'yearlyByDay') {
			$byDay = array();
			$byDay = explode(",", $event['days']);
			$rpt_select_option = $byDay[0];
			$rpt_select_day = $byDay[1];
			$rpt_select_month = $byDay[2];

			$dowS = adodb_date ("w", $start);
			$dayS = ceil(adodb_date ("d", $start)/7);
			$mthS = adodb_date ("m", $start);
			$yrS  = adodb_date ("Y", $start);

			$dow  = adodb_date ("w", $date);
			$day  = ceil(adodb_date ("d", $date)/7);
			$mth  = adodb_date ("m", $date);
			$yr   = adodb_date ("Y", $date);
			if ((($yr - $yrS)*12) % $freq > 0)
			return false;

			if (($dowS == $dow) /*&& ($day == $dayS)*/ && ($mthS == $mth) && (showDate($dateYmd, $rpt_select_option, $rpt_select_day, $rpt_select_month) == 0))
			return true;
		} else if ($event['type'] == 'yearly') {
			$yrS = adodb_date ("Y", $start);
			$yr  = adodb_date ("Y", $date);
			if (($yr - $yrS)%$freq)
				return false;

			if ((adodb_date ("dm", $date) == adodb_date ("dm", $start) && $event['name'] != _EASTER) || ($event['name'] == _EASTER && isEaster($dateYmd)))
				return true;
		} else {
		// unknown repeat type
			return false;
		}
	}

// Get all the canceled events for the specified date and return them
// in an array.
// params:
//   $user - username
//   $date - date to get events for in YYYYMMDD format
	function get_repeating_cancels ( $dateYmd ) {
		global $canceled_events;
		$n = 0;
		$ret = array ();
		for ($i=0; $i < count($canceled_events); $i++ ) {
			if ($canceled_events[$i]['date'] == $dateYmd)
				$ret[$n++] = $canceled_events[$i];
		}
		return $ret;
	}

// Get all the repeating events for the specified data and return them
// in an array (which is sorted by time of day).
// params:
//   $user - username
//   $date - date to get events for in YYYYMMDD format
	function get_repeating_entries ( $dateYmd ) {
		global $repeated_events;
		$n = 0;
		$ret = array ();
		//echo count($repeated_events)."<br />";
		//echo $dateYmd."<br />";
		for ($i=0; $i < count($repeated_events); $i++ ) {
			if (repeated_event_matches_date($repeated_events[$i],$dateYmd))
				$ret[$n++] = $repeated_events[$i];
		}
		return $ret;
	}

// Get all the events for a specific date from the array of pre-loaded
// events (which was loaded all at once to improve performance).
// The returned events will be sorted by time of day.
// params:
//   $user - username
//   $date - date to get events for in YYYYMMDD format
	function get_entries ( $date ) {
		global $events;
		$n = 0;
		$ret = array ();
		for ( $i = 0; $i < count ( $events ); $i++ ) {
			if ( $events[$i]['date'] == $date )
				$ret[$n++] = $events[$i];
		}
		return $ret;
	}


	function dayOfWeek($day, $month, $year) {
		if($month > 2) {
			$month -= 2;
		} else {
			$month += 10;
			$year--;
		}

		$weekday = ( floor((13 * $month - 1) / 5) +
			$day + ($year % 100) +
			floor(($year % 100) / 4) +
			floor(($year / 100) / 4) - 2 *
			floor($year / 100) + 77);

		return (($weekday - 7 * floor($weekday / 7)));
	}

// Print out a date selection for use in a form.
// params:
//	 $prefix - prefix to use in front of form element names
//	 $date - currently selected date (in YYYYMMDD) format
	function print_date_selection ( $prefix, $date, $showpopup=true ) {
		global $cal_module_name, $cal_config;
		$thisyear = $year = substr ( $date, 0, 4 );
		$thismonth = $month = substr ( $date, 4, 2 );
		$thisday = $day = substr ( $date, 6, 2 );
		$rtn = "<select name=\"" . $prefix . "day\" id=\"" . $prefix . "day\">\n";
		for ( $i = 1; $i <= 31; $i++ ) {
			$rtn .= "<option value=\"$i\"" . ( $i == $thisday ? " selected=\"selected\"" : "" ) . ">$i</option>\n";
		}
		$rtn .= "</select>\n<select name=\"" . $prefix . "month\" id=\"" . $prefix . "month\">\n";
		for ( $i = 1; $i <= 12; $i++ ) {
			$m = month_short_name ( $i - 1 );
			$rtn .= "<option value=\"$i\"" . ( $i == $thismonth ? " selected=\"selected\"" : "" ) . ">$m</option>\n";
		}
		$rtn .= "</select>\n<select name=\"" . $prefix . "year\" id=\"" . $prefix . "year\">\n";
		for ( $i = $cal_config['start_year']; $i < (adodb_date ( "Y" ) + 5); $i++ ) {
			//$y = adodb_date ( "Y" ) + $i;
			$rtn .= "<option value=\"$i\"" . ( $i == $thisyear ? " selected=\"selected\"" : "" ) . ">$i</option>\n";
		}
		$rtn .= "</select>\n";
		if ($showpopup)
			$rtn .= "<a href=\"javascript:selectDate('" . $prefix . "day','" . $prefix . "month','" . $prefix . "year',". $date .")\"><img src=\"modules/$cal_module_name/images/calendar.gif\" style=\"width:24px; height:24; border:0;\" alt=\"Select Date...\" /></a>";
		return $rtn;
	}
	
	function print_month_events($date) {
		$canceled = get_repeating_cancels ( $date );
		$rep = get_repeating_entries ( $date );
		$ev = get_entries ( $date );
		$cur_rep = 0;
		$eventlist = "";

		for ( $i = 0; $i < count ( $ev ); $i++ ) {
		// print out any repeating events that are before this one...
			while ( $cur_rep < count ( $rep ) && $rep[$cur_rep]['time'] < $ev[$i]['time'] ) {
				if ( count ( $canceled ) > 0 ) {
					for ( $j = 0; $j < count ( $canceled ); $j++ ) {
						if (count($rep) > 0 && $canceled[$j]['eid'] != $rep[$cur_rep]['eid'])
							$eventlist .= print_month_event($rep[$cur_rep], $date);
					}
				}
				else {
					$eventlist .= print_month_event($rep[$cur_rep], $date);
				}
				$cur_rep++;
			}
			if (count($rep) > 0 && $cur_rep < count($rep)) {
				$found = false;
				for ( $j = 0; $j < count ( $rep ); $j++ ) {
					if ($ev[$i]['eid'] == $rep[$j]['eid']) {
						$found = TRUE;
						break;
					}
				}
				if (!$found)
					$eventlist .= print_month_event($ev[$i], $date);
			}
			else {
				$eventlist .= print_month_event($ev[$i], $date);
			}
		}
		// print out any remaining repeating events
		while ( $cur_rep < count ( $rep ) ) {
			if ( count ( $canceled ) > 0 ) {
				for ( $j = 0; $j < count ( $canceled ); $j++ ) {
					if (count($rep) > 0 && $canceled[$j]['eid'] != $rep[$cur_rep]['eid'])
						$eventlist .= print_month_event($rep[$cur_rep], $date);
				}
			}
			else {
				$eventlist .= print_month_event($rep[$cur_rep], $date);
			}
			$cur_rep++;
		}
		return $eventlist;
	}

//Print the specified event for the monthly view calendar
	function print_month_event ( $event, $date ) {
		global $db, $cal_prefix, $cal_module_name, $repeated_descriptions, $cal_config, $calcategories;

		$id = $event['eid'];
		$time = $event['time'];
		$duration = $event['duration'];
		$priority = $event['priority'];
		$view = $event['view'];
		$name = $event['name'];
		$description = $event['description'];
		$image = $event['image'];
		$category = $event['category'];
		$content = "";
		//Print event if...
		//is any user OR
		//is in the specified $view group OR
		//is a registered user OR
		//is a Calendar Admin
		if ($view == 0 || in_group($view) || is_user() || can_admin($cal_module_name)) {
			$content .= "<a href=\"".getlink($cal_module_name . "&amp;view=event&amp;id=$id&amp;date=$date") . "\"";
			$content .= (!empty($description) ? " title=\"".$description."\"" : "") . "><img src=\"modules/$cal_module_name/images/$image\" alt=\"Event\" style=\" vertical-align: middle; border:0;\" /> ";

			if ($cal_config['show_time'] == '1') {
				$timestr = "";
				if ( $time >= 0 ) {
					$timestr = display_time ( $time );
					$content .= $timestr . " ";
					if ( $duration > 0 ) {
						// calc end time
						$h = (int) ( $time / 10000 );
						$m = ( $time / 100 ) % 100;
						$m += $duration;
						$d = $duration;
						while ( $m >= 60 ) {
							$h++;
							$m -= 60;
						}
						$end_time = sprintf ( "%02d%02d00", $h, $m );
						$content .= " - " . display_time ( $end_time ) . " ";
					}
				}
			}
			$descs = count($repeated_descriptions);
			for ( $i = 0; $i < $descs; $i++ ) {
				if ($repeated_descriptions[$i]['eid'] == $id && $repeated_descriptions[$i]['date'] == $date){
					$name = $repeated_descriptions[$i]['name'];
					break;
				}
			}
			if ($calcategories[$category]['display'] == 1 || $image == "circle.gif" || $image == "blank.gif" )
				$content .= htmlspecialchars ( $name );

			$content .= "</a>";
			$content .= "<br />";
		}
		return $content;
	}

//Compile Coming Events for the RSS feed nucal.php
	function rss_month_events($date) {
		global $days, $d;
		$canceled = get_repeating_cancels ( $date );
		$rep = get_repeating_entries ( $date );
		$ev = get_entries ( $date );
		$cur_rep = 0;
		$eventlist = '';
		for ( $i = 0; $i < count ( $ev ); $i++ ) {
		// print out any repeating events that are before this one...
			while ( $cur_rep < count ( $rep ) && $rep[$cur_rep]['time'] < $ev[$i]['time'] ) {
				if ( count ( $canceled ) > 0 ) {
					for ( $j = 0; $j < count ( $canceled ); $j++ ) {
						if (count($rep) > 0 && $canceled[$j]['eid'] != $rep[$cur_rep]['eid'])
							$eventlist .= rss_month_event($rep[$cur_rep], $date);
					}
				}
				else {
					$eventlist .= rss_month_event($rep[$cur_rep], $date);
				}
				$cur_rep++;
			}
			if (count($rep) > 0 && $cur_rep < count($rep)) {
				$found = false;
				for ( $j = 0; $j < count ( $rep ); $j++ ) {
					if ($ev[$i]['eid'] == $rep[$j]['eid']) {
						$found = TRUE;
						break;
					}
				}
				if (!$found)
					$eventlist .= rss_month_event($ev[$i], $date);
			}
			else {
				$eventlist .= rss_month_event($ev[$i], $date);
			}
		}
		while ( $cur_rep < count ( $rep ) ) {
			if ( count ( $canceled ) > 0 ) {
				for ( $j = 0; $j < count ( $canceled ); $j++ ) {
					if (count($rep) > 0 && $canceled[$j]['eid'] != $rep[$cur_rep]['eid'])
						$eventlist .= rss_month_event($rep[$cur_rep], $date);
				}
			}
			else {
				$eventlist .= rss_month_event($rep[$cur_rep], $date);
			}
			$cur_rep++;
		}
		return $eventlist;
	}
//Generate the specified event for the RSS feed nucal.php
	function rss_month_event ( $event, $date ) {
		global $db, $cal_prefix, $cal_module_name, $repeated_descriptions, $cal_config, $calcategories, $days, $d;
		$id = $event['eid'];
		$time = $event['time'];
		$duration = $event['duration'];
		$priority = $event['priority'];
		$view = $event['view'];
		$name = $event['name'];
		$description = $event['description'];
		$image = $event['image'];
		$category = $event['category'];
		$content = '';
		if ($view == 0 || in_group($view) || is_user() || can_admin($cal_module_name)) {
			$content .= '<item>';
			$content .= '<title>';
			if ($cal_config['show_time'] == '1') {
				$timestr = '';
				$addtime = '';
				if ( $time >= 0 ) {
					$timestr = display_time($time);
					if ($duration == 0) {
						$addtime .= $timestr.': ';
					} else {
						$addtime .= $timestr;
					}
					if ( $duration > 0 ) {
						$h = (int) ( $time / 10000 );
						$m = ( $time / 100 ) % 100;
						$m += $duration;
						$du = $duration;
						while ( $m >= 60 ) {
							$h++;
							$m -= 60;
						}
						$end_time = sprintf ( '%02d%02d00', $h, $m );
						$addtime .= '-'.display_time($end_time).': ';
					}
				}
				$content .= ($addtime);
			}
			$descs = count($repeated_descriptions);
			for ( $i = 0; $i < $descs; $i++ ) {
				if ($repeated_descriptions[$i]['eid'] == $id && $repeated_descriptions[$i]['date'] == $date){
					$name = $repeated_descriptions[$i]['name'];
					break;
				}
			}
//			if ($calcategories[$category]['display'] == 1 || $image == 'circle.gif' || $image == 'blank.gif' ) {
				$content .= htmlprepare($name);
//				$content .= htmlspecialchars($name);
//			}
			$content .= '</title>';
			$content .= '<link>';
			$content .= getlink($cal_module_name.'&amp;view=event&amp;id='.$id.'&amp;date='.$date, true, true);
			$content .= '</link>';
			$content .= '<description>';
			$content .= htmlprepare(decode_bbcode(set_smilies($description),1), false, ENT_QUOTES, true);
//			$content .= $description;
			$content .= '</description>';
//			$content .= '<pubDate>'.date('D, d M Y H:i:s \G\M\T', $days[$d]).'</pubDate>';
			$content .= '<pubDate>'.date('D, d M Y', $days[$d]).'</pubDate>';
			$content .= "</item>\n\n";
		}
		return $content;
	}

	function print_day_events($date) {
		global $hour_arr, $rowspan_arr, $rowspan;
		$canceled = get_repeating_cancels ( $date );
		$rep = get_repeating_entries ( $date );
		$ev = get_entries ( $date );
		$cur_rep = 0;

		for ( $i = 0; $i < count ( $ev ); $i++ ) {
		// print out any repeating events that are before this one...
			while ( $cur_rep < count ( $rep ) && $rep[$cur_rep]['time'] < $ev[$i]['time'] ) {
				if ( count ( $canceled ) > 0 ) {
					for ( $j = 0; $j < count ( $canceled ); $j++ ) {
						if (count($rep) > 0 && $canceled[$j]['eid'] != $rep[$cur_rep]['eid'])
							print_day_event($rep[$cur_rep], $date);
					}
				}
				else {
					print_day_event($rep[$cur_rep], $date);
				}
				$cur_rep++;
			}
			if (count($rep) > 0 && $cur_rep < count($rep)) {
				$found = false;
				for ( $j = 0; $j < count ( $rep ); $j++ ) {
					if ($ev[$i]['eid'] == $rep[$j]['eid']) {
						$found = TRUE;
						break;
					}
				}
				if (!$found)
					print_day_event($ev[$i], $date);
			}
			else {
				print_day_event($ev[$i], $date);
			}
		}
		// print out any remaining repeating events
		while ( $cur_rep < count ( $rep ) ) {
			if ( count ( $canceled ) > 0 ) {
				for ( $j = 0; $j < count ( $canceled ); $j++ ) {
					if (count($rep) > 0 && $canceled[$j]['eid'] != $rep[$cur_rep]['eid'])
						print_day_event($rep[$cur_rep], $date);
				}
			}
			else {
				print_day_event($rep[$cur_rep], $date);
			}
			$cur_rep++;
		}
	}

// Generate the HTML for an event to be viewed in the daily or weekly calendar.
// The HTML will be stored in an array ($hour_arr) indexed on the event's
// starting hour.
	function print_day_event ( $event, $date ) {
		global $hour_arr, $rowspan_arr, $rowspan, $cal_module_name, $calcategories, $cal_config;

		$id = $event['eid'];
		$time = $event['time'];
		$duration = $event['duration'];
		$priority = $event['priority'];
		$view = $event['view'];
		$name = $event['name'];
		$description = $event['description'];
		$image = $event['image'];
		$category = $event['category'];

		$first_hour = $cal_config['workday_start'];
		$last_hour = $cal_config['workday_end'];

		//Print event if...
		//is any user OR
		//is in the specified $view group OR
		//is a registered user OR
		//is a Calendar Admin
		if ($view == 0 || in_group($view) || is_user() || can_admin($cal_module_name)) {
			if ( $time >= 0 ) {
				$ind = (int) ( $time / 10000 );
				if ( $ind < $first_hour )
					$first_hour = $ind;
				if ( $ind > $last_hour )
					$last_hour = $ind;
			} else
				$ind = 99;

			if ( empty ( $hour_arr[$ind] ) )
				$hour_arr[$ind] = "";
			if ( empty ( $rowspan_arr[$ind] ) )
				$rowspan_arr[$ind] = "";

			$hour_arr[$ind] .= "<a href=\"".getlink($cal_module_name."&amp;view=event&amp;id=$id&amp;date=$date")."\"";
			$hour_arr[$ind] .= (!empty($description) ? " title=\"".$description."\"" : "") . "><img src=\"modules/$cal_module_name/images/$image\" alt=\"Event\" style=\"border:0;\" /> ";
	
		  if ( $time >= 0 ) {
			$hour_arr[$ind] .= "[" . display_time ( $time );
			if ( $duration > 0 ) {
			  // calc end time
			  $h = (int) ( $time / 10000 );
			  $m = ( $time / 100 ) % 100;
			  $m += $duration;
			  $d = $duration;
			  while ( $m >= 60 ) {
				$h++;
				$m -= 60;
			  }
			  $end_time = sprintf ( "%02d%02d00", $h, $m );
			  $hour_arr[$ind] .= "-" . display_time ( $end_time );
			  if ( $m == 0 )
				$rowspan = $h - $ind;
			  else
				$rowspan = $h - $ind + 1;
			  if ( $rowspan > $rowspan_arr[$ind] && $rowspan > 1 )
				$rowspan_arr[$ind] = $rowspan;
			}
			$hour_arr[$ind] .= "] ";
		  }
		  if ($calcategories[$category]['display'] == 1 || $image == "circle.gif" || $image == "blank.gif" )
			$hour_arr[$ind] .= htmlspecialchars ( $name );

		  $hour_arr[$ind] .= "</a><br />";
		}
	}


function hasEvents ( $date ) {
	global $cal_module_name;
	$canceled = get_repeating_cancels ( $date );
	$rep = get_repeating_entries ( $date );
	$ev = get_entries ( $date );

	$hasEvents = FALSE;
	if ( count ( $ev ) > 0 ) {
		for ( $i = 0; $i < count ( $ev ); $i++ ) {
			if ($ev[$i]['view'] == 0 || in_group($ev[$i]['view']) || is_user() || can_admin($cal_module_name))
				$hasEvents = TRUE;
				break;
		}
	}
	if ($hasEvents)
		return TRUE;

	if ( count ( $rep ) > 0 ) {
		if ( count ( $canceled ) < count ( $rep ) ) {
			for ( $i = 0; $i < count ( $rep ); $i++ ) {
				if ($rep[$i]['view'] == 0 || in_group($rep[$i]['view']) || is_user() || can_admin($cal_module_name))
					$hasEvents = TRUE;
					break;
			}
		}
	}
	if ($hasEvents)
		return TRUE;

	return FALSE;
}

function jumpToDate ( $date ) {
	global $view, $cal_module_name;
	$content = "<form action=\"".getlink($cal_module_name)."\" method=\"post\" name=\"jumpform\">\n"
		."<b>"._CALJUMP_VIEW.":</b><select name=\"view\">\n"
		."	<option value=\"day\"". ($view == "day" ? " selected=\"selected\"" : "") . ">"._CALDAILY." "._CALENDAR."</option>"
		."	<option value=\"week\"". ($view == "week" ? " selected=\"selected\"" : "") . ">"._CALWEEKLY." "._CALENDAR."</option>"
		."	<option value=\"month\"". ($view == "month" ? " selected=\"selected\"" : "") . ">"._CALMONTHLY." "._CALENDAR."</option>"
		."	<option value=\"year\"". ($view == "year" ? " selected=\"selected\"" : "") . ">"._CALYEARLY." "._CALENDAR."</option>"
		."</select> \n"
		
		. print_date_selection ( "", $date, false )
		."<input type=\"submit\" value=\""._CALJUMP_GO."\" />"
		."</form>";
	return $content;
}
?>